/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.TransformationLinkWizardPage;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;

public class TransformationLinkContributor
implements INewModelWizardContributor,
UiConstants {
    private static final Map MAP_CLEAR_SUPPORTS_UPDATES = Collections.singletonMap("clearSupportsUpdate", Boolean.TRUE);
    private static final Map MAP_KEEP_SUPPORTS_UPDATES = Collections.singletonMap("clearSupportsUpdate", Boolean.FALSE);
    private IWizardPage[] pages;
    private TransformationLinkWizardPage transformationLinkPage;

    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return false;
    }

    public void createWizardPages(ISelection selection, IResource targetResource, IPath targetFilePath, MetamodelDescriptor descriptor, boolean isVirtual) {
        this.pages = new IWizardPage[1];
        this.transformationLinkPage = new TransformationLinkWizardPage("transformationLinkWizardPage", selection, descriptor, isVirtual);
        this.pages[0] = this.transformationLinkPage;
    }

    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    public void inputChanged(ISelection selection, IResource targetResource, MetamodelDescriptor descriptor, boolean isVirtual) {
    }

    public void doCancel() {
    }

    public void doFinish(ModelResource modelResource, IProgressMonitor monitor) {
        block10: {
            String transactionName = Util.getString("TransformationLinkContributor.transactionName", new Object[0]);
            boolean started = ModelerCore.startTxn((String)transactionName, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    Map extraProperties;
                    IStructuralCopyTreePopulator populator = this.transformationLinkPage.getTreePopulator();
                    TreeViewer viewer = this.transformationLinkPage.getViewer();
                    Map map = extraProperties = this.transformationLinkPage.isClearSupportsUpdate() ? MAP_CLEAR_SUPPORTS_UPDATES : MAP_KEEP_SUPPORTS_UPDATES;
                    if (populator != null && viewer != null) {
                        populator.copyModel((ModelResource)viewer.getInput(), modelResource, extraProperties, this.transformationLinkPage.isCopyAllDescriptions(), monitor);
                    }
                    succeeded = true;
                }
                catch (Exception ex) {
                    String message = UiConstants.Util.getString("TransformationLinkContributor.doFinishError", (Object)modelResource.getItemName());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!started) break block10;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block10;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public void currentPageChanged(IWizardPage page) {
    }
}

