/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.INewModelObjectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TransformationUiNewModelObjectHelper
implements INewModelObjectHelper {
    public boolean canHelpCreate(Object newObject) {
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject != null && newObject instanceof EObject) {
            EObject newEObject = (EObject)newObject;
            return this.isVirtualTable(newEObject);
        }
        return false;
    }

    private boolean isVirtualTable(EObject newEObject) {
        if (TransformationHelper.isVirtual((Object)newEObject)) {
            if (TransformationHelper.isSqlTable((Object)newEObject) && !TransformationHelper.isXmlDocument((Object)newEObject) && !TransformationHelper.isMappingClass((Object)newEObject)) {
                return true;
            }
            if (TransformationHelper.isSqlProcedure((Object)newEObject)) {
                return true;
            }
        }
        return false;
    }

    public boolean helpCreate(Object newObject, Map properties) {
        ModelResource mr;
        EObject newTarget;
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject && this.isVirtualTable(newTarget = (EObject)newObject) && (mr = ModelUtilities.getModelResourceForModelObject((EObject)newTarget)) != null && !this.diagramExists(newTarget, mr)) {
            TransformationDiagramUtil.createTransformationDiagram(newTarget, mr, true);
        }
        return true;
    }

    private boolean diagramExists(EObject target, ModelResource modelResource) {
        return TransformationDiagramUtil.getTransformationDiagram(modelResource, target, false, false) != null;
    }
}

