/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;

public class DependencyReportDialog
extends Dialog
implements UiConstants {
    private static final String DEFAULT_DELIMETER = "|";
    private static final String DEFAULT_NULL = "<NULL>";
    private static final int DELIMETER_MAX_LENGTH = "|".length();
    private static final boolean INCLUDE_INTERMEDIATE = true;
    private static final boolean REPLACE_NULLS = true;
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DependencyReportDialog.class);
    private static final String REPORT_SUFFIX = DependencyReportDialog.getString("reportSuffix");
    private static final String TXT_EXTENSION = ".txt";
    private String colDelim = "|";
    private String nullVal = "<NULL>";
    private boolean includeIntermediate = true;
    private boolean replaceNulls = true;
    private String lastReportName;
    private String path;
    private IDialogSettings settings;
    private EObject virtualGroup;
    private Button btnDelReset;
    private Button btnNullReset;
    private Button chkIncludeIntermediate;
    private Button chkReplaceNulls;
    private Text txfColDelim;
    private Text txfNullVal;
    private Text txfFileName;

    private static final String getString(String theKey) {
        return Util.getString(String.valueOf(PREFIX) + theKey, new Object[0]);
    }

    private static final String getString(String theKey, Object[] theParams) {
        return Util.getString(String.valueOf(PREFIX) + theKey, theParams);
    }

    public DependencyReportDialog(Shell theShell, EObject theVirtualGroup) {
        super(theShell, DependencyReportDialog.getString("title"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setSizeRelativeToScreen(35, 40);
        this.virtualGroup = theVirtualGroup;
    }

    private String constructFileName() {
        StringBuffer result = new StringBuffer();
        result.append(ModelerCore.getModelEditor().getName(this.virtualGroup));
        result.append(REPORT_SUFFIX);
        if (this.lastReportName != null) {
            String extension = null;
            int index = this.lastReportName.lastIndexOf(46);
            if (index != -1 && index + 1 != this.lastReportName.length()) {
                extension = this.lastReportName.substring(index + 1);
            }
            if (extension != null) {
                result.append('.').append(extension);
            }
        } else {
            result.append(TXT_EXTENSION);
        }
        return result.toString();
    }

    protected Control createButtonBar(Composite theParent) {
        Control c = super.createButtonBar(theParent);
        this.updateEnabledState();
        return c;
    }

    protected Control createContents(Composite theParent) {
        Control c = super.createContents(theParent);
        this.restoreState();
        return c;
    }

    protected Control createDialogArea(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(1, false));
        Composite pnlFile = WidgetFactory.createPanel((Composite)pnlMain, (int)0, (int)768);
        pnlFile.setLayout((Layout)new GridLayout(3, false));
        WidgetFactory.createLabel((Composite)pnlFile, (int)0, (String)DependencyReportDialog.getString("label.fileName"));
        this.txfFileName = WidgetFactory.createTextField((Composite)pnlFile, (int)768, (int)1, (String)"", (int)8);
        Button btn = WidgetFactory.createButton((Composite)pnlFile, (String)InternalUiConstants.Widgets.BROWSE_BUTTON, (int)128);
        btn.setToolTipText(DependencyReportDialog.getString("button.browse.tip"));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DependencyReportDialog.this.handleBrowseSelected();
            }
        });
        Group group = WidgetFactory.createGroup((Composite)pnlMain, (String)DependencyReportDialog.getString("group.settings"), (int)1808, (int)3, (int)3);
        WidgetFactory.createLabel((Composite)group, (int)0, (String)DependencyReportDialog.getString("label.includeIntermediate"));
        this.chkIncludeIntermediate = WidgetFactory.createCheckBox((Composite)group, (String)"", (int)0, (int)2);
        this.chkIncludeIntermediate.setToolTipText(DependencyReportDialog.getString("checkbox.includeIntermediate"));
        this.chkIncludeIntermediate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DependencyReportDialog.this.handleIncludeIntermediateSelected(theEvent);
            }
        });
        WidgetFactory.createLabel((Composite)group, (int)0, (String)DependencyReportDialog.getString("label.columnDelimeter", new Object[]{Integer.toString(DELIMETER_MAX_LENGTH)}));
        this.txfColDelim = WidgetFactory.createTextField((Composite)group, (int)768);
        this.txfColDelim.setToolTipText(DependencyReportDialog.getString("text.columnDelimeter"));
        this.txfColDelim.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                DependencyReportDialog.this.handleColumnDelimeterChanged();
            }
        });
        this.txfColDelim.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent theEvent) {
                DependencyReportDialog.this.handleVerifyDelimeterChanged(theEvent);
            }
        });
        this.btnDelReset = WidgetFactory.createButton((Composite)group, (String)DependencyReportDialog.getString("button.reset"));
        this.btnDelReset.setToolTipText(DependencyReportDialog.getString("button.resetColDelimiter.tip", new Object[]{DEFAULT_DELIMETER}));
        this.btnDelReset.setEnabled(false);
        this.btnDelReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DependencyReportDialog.this.handleColDelResetSelected();
            }
        });
        WidgetFactory.createLabel((Composite)group, (int)0, (String)DependencyReportDialog.getString("label.replaceNulls"));
        this.chkReplaceNulls = WidgetFactory.createCheckBox((Composite)group, (String)"", (int)0, (int)2);
        this.chkReplaceNulls.setToolTipText(DependencyReportDialog.getString("checkbox.replaceNulls"));
        this.chkReplaceNulls.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DependencyReportDialog.this.handleReplaceNullsSelected(theEvent);
            }
        });
        WidgetFactory.createLabel((Composite)group, (int)0, (String)DependencyReportDialog.getString("label.nullValue", null));
        this.txfNullVal = WidgetFactory.createTextField((Composite)group, (int)768);
        this.txfNullVal.setToolTipText(DependencyReportDialog.getString("text.nullValue"));
        this.txfNullVal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                DependencyReportDialog.this.handleNullValueChanged();
            }
        });
        this.btnNullReset = WidgetFactory.createButton((Composite)group, (String)DependencyReportDialog.getString("button.reset"));
        this.btnNullReset.setToolTipText(DependencyReportDialog.getString("button.resetNullValue.tip", new Object[]{DEFAULT_NULL}));
        this.btnNullReset.setEnabled(false);
        this.btnNullReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DependencyReportDialog.this.handleNullValueResetSelected();
            }
        });
        return pnlFile;
    }

    public String getColumnDelimeter() {
        return this.colDelim;
    }

    private IDialogSettings getDialogSettings() {
        if (this.settings == null) {
            this.settings = UiPlugin.getDefault().getDialogSettings();
            IDialogSettings temp = this.settings.getSection(DialogSettingsConstants.SECTION_NAME);
            this.settings = temp == null ? this.settings.addNewSection(DialogSettingsConstants.SECTION_NAME) : temp;
        }
        return this.settings;
    }

    public String getReportFileName() {
        return this.path;
    }

    void handleBrowseSelected() {
        String name;
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(DependencyReportDialog.getString("dialog.title"));
        dialog.setFileName(this.constructFileName());
        if (dialog.open() != null && (name = dialog.getFileName()) != null && name.length() > 0) {
            String directory = dialog.getFilterPath();
            StringBuffer buffer = new StringBuffer();
            buffer.append(directory).append(File.separatorChar).append(name);
            if (name.indexOf(46) < 0) {
                buffer.append(TXT_EXTENSION);
            }
            this.path = buffer.toString();
            this.txfFileName.setText(this.path);
            this.txfFileName.setToolTipText(this.path);
            this.updateEnabledState();
        }
    }

    void handleColumnDelimeterChanged() {
        this.colDelim = this.txfColDelim.getText();
        this.updateEnabledState();
    }

    void handleNullValueChanged() {
        this.nullVal = this.txfNullVal.getText();
        this.updateEnabledState();
    }

    void handleIncludeIntermediateSelected(SelectionEvent theEvent) {
        this.includeIntermediate = ((Button)theEvent.getSource()).getSelection();
    }

    void handleReplaceNullsSelected(SelectionEvent theEvent) {
        this.replaceNulls = ((Button)theEvent.getSource()).getSelection();
        this.txfNullVal.setEnabled(this.replaceNulls);
    }

    void handleColDelResetSelected() {
        this.txfColDelim.setText(DEFAULT_DELIMETER);
        this.txfColDelim.setFocus();
        this.txfColDelim.selectAll();
    }

    void handleNullValueResetSelected() {
        this.txfNullVal.setText(DEFAULT_NULL);
        this.txfNullVal.setFocus();
        this.txfNullVal.selectAll();
    }

    void handleVerifyDelimeterChanged(VerifyEvent theEvent) {
        boolean doit = true;
        if (theEvent.text.length() > 0) {
            String current = this.txfColDelim.getText();
            int currLength = current.length();
            if (currLength > 0) {
                StringBuffer buf = new StringBuffer(this.txfColDelim.getText());
                int start = theEvent.start;
                int end = theEvent.end;
                if (start < currLength && end < currLength) {
                    buf.replace(theEvent.start, theEvent.end, theEvent.text);
                } else if (start >= currLength) {
                    buf.append(theEvent.text);
                } else if (start + theEvent.text.length() - 1 >= DELIMETER_MAX_LENGTH) {
                    doit = false;
                }
                if (doit) {
                    doit = buf.length() <= DELIMETER_MAX_LENGTH;
                }
            } else {
                boolean bl = doit = theEvent.text.length() <= DELIMETER_MAX_LENGTH;
            }
        }
        if (!doit) {
            theEvent.doit = false;
        }
    }

    public boolean isIncludeIntermediate() {
        return this.includeIntermediate;
    }

    public boolean isReplaceNulls() {
        return this.replaceNulls;
    }

    protected void okPressed() {
        this.saveState();
        super.okPressed();
    }

    private void restoreState() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String value = null;
        value = dialogSettings.get("includeIntermediate");
        final boolean checked = value == null ? true : this.settings.getBoolean("includeIntermediate");
        final Button btn = this.chkIncludeIntermediate;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                btn.setSelection(checked);
                Event event = new Event();
                event.widget = btn;
                btn.notifyListeners(13, event);
            }
        });
        value = dialogSettings.get("replaceNulls");
        final boolean nullButtonChecked = value == null ? true : this.settings.getBoolean("replaceNulls");
        final Button nullBtn = this.chkReplaceNulls;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                nullBtn.setSelection(nullButtonChecked);
                Event event = new Event();
                event.widget = nullBtn;
                nullBtn.notifyListeners(13, event);
            }
        });
        value = dialogSettings.get("columnDelimeter");
        if (value == null || value.length() == 0) {
            value = DEFAULT_DELIMETER;
        } else if (value.length() > DELIMETER_MAX_LENGTH) {
            value = value.substring(0, DELIMETER_MAX_LENGTH);
        }
        final String colText = value;
        final Text colTxf = this.txfColDelim;
        value = dialogSettings.get("nullValue");
        if (value == null || value.length() == 0) {
            value = DEFAULT_NULL;
        }
        final String nullText = value;
        final Text nullTxf = this.txfNullVal;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                colTxf.setText(colText);
                nullTxf.setText(nullText);
                nullTxf.setEnabled(nullButtonChecked);
            }
        });
        value = dialogSettings.get("lastReport");
        if (value != null && value.length() != 0) {
            this.lastReportName = value;
            this.txfFileName.setText(this.lastReportName);
            this.path = this.lastReportName;
        }
    }

    private void saveState() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put("includeIntermediate", this.includeIntermediate);
        dialogSettings.put("replaceNulls", this.replaceNulls);
        dialogSettings.put("columnDelimeter", this.colDelim);
        dialogSettings.put("nullValue", this.nullVal);
        dialogSettings.put("lastReport", this.path);
    }

    private void updateEnabledState() {
        boolean enable = true;
        if (this.txfFileName.getText().length() == 0 || this.txfColDelim.getText().length() == 0) {
            enable = false;
        }
        this.getButton(0).setEnabled(enable);
        enable = true;
        if (this.txfColDelim.getText().equals(DEFAULT_DELIMETER)) {
            enable = false;
        }
        this.btnDelReset.setEnabled(enable);
        enable = true;
        if (this.txfNullVal.getText().equals(DEFAULT_NULL)) {
            enable = false;
        }
        this.btnNullReset.setEnabled(enable);
    }

    public String getNullValue() {
        if (this.replaceNulls) {
            return this.nullVal;
        }
        return "";
    }

    static interface DialogSettingsConstants {
        public static final String SECTION_NAME = DependencyReportDialog.class.getSimpleName();
        public static final String COLUMN_DELIMETER = "columnDelimeter";
        public static final String NULL_VALUE = "nullValue";
        public static final String INCLUDE_INTERMEDIATE = "includeIntermediate";
        public static final String LAST_REPORT = "lastReport";
        public static final String REPLACE_NULLS = "replaceNulls";
    }
}

