/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IMetadataID;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.query.ui.builder.util.ElementViewerFactory;

public class BuilderTreeProvider
implements ITreeContentProvider,
ILabelProvider {
    ILabelProvider emfLabelProvider;

    public BuilderTreeProvider() {
        ElementViewerFactory.setContentProvider((ITreeContentProvider)this);
        ElementViewerFactory.setLabelProvider((ILabelProvider)this);
        this.emfLabelProvider = ModelUtilities.getEMFLabelProvider();
    }

    public Object[] getChildren(Object parentElement) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        Object[] result = new Object[]{};
        if (parentElement instanceof EObject) {
            if (parentElement instanceof InputSet) {
                IGroupSymbol group = factory.createGroupSymbol(this.getText(parentElement));
                group.setMetadataID(parentElement);
                return this.getChildren(group);
            }
            if (SqlAspectHelper.isTable((EObject)((EObject)parentElement))) {
                SqlTableAspect tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)parentElement));
                result = tableAspect.getColumns((EObject)parentElement).toArray();
            } else if (SqlAspectHelper.isProcedure((EObject)((EObject)parentElement))) {
                List inParams = TransformationHelper.getInAndInoutParameters((EObject)((EObject)parentElement));
                result = new Object[inParams.size()];
                IGroupSymbol group = factory.createGroupSymbol(this.getText(parentElement));
                group.setMetadataID(parentElement);
                int i = 0;
                while (i < result.length) {
                    result[i] = TransformationSqlHelper.createElemSymbol((EObject)((EObject)inParams.get(i)), (IGroupSymbol)group);
                    ++i;
                }
            } else if (SqlAspectHelper.isProcedureResultSet((EObject)((EObject)parentElement))) {
                SqlColumnSetAspect colSetAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)parentElement));
                IGroupSymbol group = factory.createGroupSymbol(colSetAspect.getFullName((EObject)parentElement));
                group.setMetadataID(parentElement);
                List cols = colSetAspect.getColumns((EObject)parentElement);
                result = new Object[cols.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = TransformationSqlHelper.createElemSymbol((EObject)((EObject)cols.get(i)), (IGroupSymbol)group);
                    ++i;
                }
            }
        } else if (parentElement instanceof IGroupSymbol) {
            IGroupSymbol groupSymbol = (IGroupSymbol)parentElement;
            EObject group = null;
            if (groupSymbol.getMetadataID() instanceof EObject) {
                group = (EObject)groupSymbol.getMetadataID();
                if (group instanceof InputSet) {
                    EList children = ((InputSet)group).getInputParameters();
                    result = new Object[children.size()];
                    int i = 0;
                    while (i < children.size()) {
                        Object child = children.get(i);
                        IElementSymbol elementSymbol = factory.createElementSymbol(this.getText(child));
                        elementSymbol.setMetadataID(child);
                        elementSymbol.setGroupSymbol(groupSymbol);
                        result[i] = elementSymbol;
                        ++i;
                    }
                } else if (SqlAspectHelper.isProcedureResultSet((EObject)group)) {
                    SqlColumnSetAspect colSetAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)group);
                    List cols = colSetAspect.getColumns(group);
                    result = new Object[cols.size()];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = TransformationSqlHelper.createElemSymbol((EObject)((EObject)cols.get(i)), (IGroupSymbol)groupSymbol);
                        ++i;
                    }
                } else {
                    result = new Object[group.eContents().size()];
                    int i = 0;
                    while (i < result.length) {
                        Object child = group.eContents().get(i);
                        IElementSymbol elementSymbol = factory.createElementSymbol(this.getText(child));
                        elementSymbol.setMetadataID(child);
                        elementSymbol.setGroupSymbol(groupSymbol);
                        elementSymbol.setDisplayFullyQualified(true);
                        result[i] = elementSymbol;
                        ++i;
                    }
                }
            } else if (groupSymbol.getMetadataID() instanceof IMetadataID) {
                IMetadataID tempMetadataID = (IMetadataID)groupSymbol.getMetadataID();
                List children = tempMetadataID.getElements();
                result = new Object[children.size()];
                int i = 0;
                while (i < result.length) {
                    Object child = children.get(i);
                    IElementSymbol elementSymbol = factory.createElementSymbol(this.getText(child));
                    elementSymbol.setMetadataID(child);
                    elementSymbol.setGroupSymbol(groupSymbol);
                    elementSymbol.setDisplayFullyQualified(true);
                    result[i] = elementSymbol;
                    ++i;
                }
            } else {
                group = TransformationSqlHelper.getGroupSymbolEObject((IGroupSymbol)((IGroupSymbol)parentElement));
                result = this.getChildren(group);
                Object[] aliasedElements = new Object[result.length];
                int i = 0;
                while (i < result.length) {
                    IExpression elementSymbol = TransformationSqlHelper.createElemSymbol((EObject)((EObject)result[i]), (IGroupSymbol)((IGroupSymbol)parentElement));
                    aliasedElements[i] = elementSymbol;
                    ++i;
                }
                result = aliasedElements;
            }
        } else if (parentElement instanceof IStoredProcedure) {
            SqlProcedureAspect procAspect;
            Object resultSet;
            String procName = ((IStoredProcedure)parentElement).getGroupName();
            EObject element = TransformationSqlHelper.getStoredProcedureEObject((IStoredProcedure)((IStoredProcedure)parentElement));
            if (element != null && SqlAspectHelper.isProcedure((EObject)element) && SqlAspectHelper.isProcedureResultSet((EObject)((EObject)(resultSet = (procAspect = (SqlProcedureAspect)SqlAspectHelper.getSqlAspect((EObject)element)).getResult(element))))) {
                SqlColumnSetAspect rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)resultSet));
                String rsName = rsAspect.getName((EObject)resultSet);
                IGroupSymbol rsGroup = factory.createGroupSymbol(String.valueOf(procName) + '.' + rsName);
                rsGroup.setMetadataID(resultSet);
                result = new Object[]{rsGroup};
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        EObject result = null;
        if (element instanceof EObject) {
            result = ((EObject)element).eContainer();
            if (result == null) {
                result = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)element));
            }
        } else if (element instanceof IElementSymbol) {
            IElementSymbol es = (IElementSymbol)element;
            result = es.getGroupSymbol();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Image getImage(Object obj) {
        if (obj instanceof IGroupSymbol) {
            EObject group = TransformationSqlHelper.getGroupSymbolEObject((IGroupSymbol)((IGroupSymbol)obj));
            return this.emfLabelProvider.getImage((Object)group);
        }
        if (obj instanceof IElementSymbol) {
            EObject element = TransformationSqlHelper.getElementSymbolEObject((IElementSymbol)((IElementSymbol)obj));
            return this.emfLabelProvider.getImage((Object)element);
        }
        if (obj instanceof IStoredProcedure) {
            EObject element = TransformationSqlHelper.getStoredProcedureEObject((IStoredProcedure)((IStoredProcedure)obj));
            return this.emfLabelProvider.getImage((Object)element);
        }
        if (obj instanceof MetadataRecord) {
            return this.emfLabelProvider.getImage(((MetadataRecord)obj).getEObject());
        }
        return this.emfLabelProvider.getImage(obj);
    }

    public String getText(Object obj) {
        if (obj instanceof IGroupSymbol) {
            IGroupSymbol symbol = (IGroupSymbol)obj;
            String result = null;
            if (symbol.getDefinition() == null) {
                result = symbol.getName();
            } else {
                result = symbol.getDefinition();
                result = String.valueOf(result) + " AS " + symbol.getName();
            }
            return result;
        }
        if (obj instanceof IElementSymbol) {
            return ((IElementSymbol)obj).getName();
        }
        if (obj instanceof InputSet) {
            return "INPUTS";
        }
        if (obj instanceof ModelResource) {
            return ModelerCore.getModelEditor().getModelName((ModelResource)obj);
        }
        if (obj instanceof IMetadataID) {
            return ((IMetadataID)obj).getID();
        }
        if (obj instanceof EObject && (TransformationHelper.isSqlColumn((Object)obj) || TransformationHelper.isSqlTable((Object)obj)) || TransformationHelper.isSqlProcedure((Object)obj) || TransformationHelper.isSqlProcedureParameter((Object)obj)) {
            return TransformationHelper.getSqlEObjectFullName((EObject)((EObject)obj));
        }
        if (obj instanceof IStoredProcedure) {
            IStoredProcedure proc = (IStoredProcedure)obj;
            return proc.getGroupName();
        }
        return this.emfLabelProvider.getText(obj);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = new Object[]{};
        if (inputElement instanceof Collection) {
            result = ((Collection)inputElement).toArray();
        }
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.emfLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

