/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler.datatype;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.PluginConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.BindingList;
import org.teiid.designer.transformation.ui.reconciler.ColorManager;
import org.teiid.designer.transformation.ui.reconciler.datatype.DatatypeReconcilerDialog;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.table.CheckBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DatatypeReconcilerPanel
extends SashForm
implements ISelectionChangedListener,
PluginConstants.Images {
    private DatatypeReconcilerDialog datatypeReconcilerDialog = null;
    private BindingList originalBindingList;
    private BindingTableInput bindingListInput;
    private boolean targetLocked;
    ColorManager colorManager;
    TableViewerBuilder bindingTableViewer;
    Label symbolConversionLabel;
    Label symbolWarningLabel;
    Button changeAllColumnDatatypesButton;
    Button convertAllSqlSymbolsButton;
    Text helpText;
    private BindingContentProvider bindingContentProvider;

    public DatatypeReconcilerPanel(Composite parent, DatatypeReconcilerDialog dialog, BindingList bindingList, boolean targetLocked, ColorManager colorManager) {
        super(parent, 512);
        this.originalBindingList = bindingList;
        this.targetLocked = targetLocked;
        this.colorManager = colorManager;
        this.datatypeReconcilerDialog = dialog;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        gridLayout.marginLeft = 20;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        this.bindingListInput = new BindingTableInput(this.createBindingList(this.originalBindingList));
        this.createTableViewerPanel((Composite)this);
        this.datatypeReconcilerDialog.setTitle(Messages.datatypeReconciler_statusTitle);
        this.updateMessageArea();
        this.bindingTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectFirstTypeConflict();
        this.bindingListInput.datatypeChanged();
    }

    private BindingList createBindingList(BindingList bindings) {
        BindingList newBindingList = new BindingList();
        if (bindings != null && bindings.size() > 0) {
            int i = 0;
            while (i < bindings.size()) {
                Binding binding = bindings.get(i);
                newBindingList.add(binding);
                ++i;
            }
        }
        return newBindingList;
    }

    private void updateMessageArea() {
        int statusType = 0;
        String message = Messages.datatypeReconciler_allResolvedMessage;
        if (this.bindingListInput.getBindingList().hasTypeConflict()) {
            message = Messages.datatypeReconciler_someUnresolvedConflicts;
            statusType = 3;
        }
        this.datatypeReconcilerDialog.setMessage(message, statusType);
    }

    private void createTableViewerPanel(Composite theParent) {
        Composite tablePanel = new Composite(theParent, 0);
        GridLayout gridLayout = new GridLayout();
        tablePanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        tablePanel.setLayoutData((Object)gridData);
        Composite headerPanel = WidgetFactory.createPanel((Composite)tablePanel);
        headerPanel.setLayout((Layout)new GridLayout());
        ((GridLayout)headerPanel.getLayout()).numColumns = 3;
        headerPanel.setLayoutData((Object)new GridData(1808));
        ((GridData)headerPanel.getLayoutData()).minimumHeight = 80;
        this.helpText = new Text(headerPanel, 72);
        this.helpText.setBackground(Display.getCurrent().getSystemColor(19));
        this.helpText.setForeground(Display.getCurrent().getSystemColor(10));
        this.helpText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.helpText.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.helpText.getLayoutData()).heightHint = 40;
        ((GridData)this.helpText.getLayoutData()).widthHint = 360;
        this.helpText.setText(Messages.datatypeReconciler_helpText);
        this.convertAllSqlSymbolsButton = WidgetFactory.createButton((Composite)headerPanel, (String)Messages.datatypeReconciler_convertAllSqlSymbolsLabel);
        this.convertAllSqlSymbolsButton.setToolTipText(Messages.datatypeReconciler_convertAllSqlSymbolsTooltip);
        this.convertAllSqlSymbolsButton.setImage(UiPlugin.getDefault().getImage("icons/full/cview20/arrow-only-left-20x20.png"));
        this.convertAllSqlSymbolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatatypeReconcilerPanel.this.changeAllColumnDatatypesButtonPressed();
            }
        });
        WidgetFactory.createLabel((Composite)headerPanel, (String)"   - or -   ");
        this.changeAllColumnDatatypesButton = WidgetFactory.createButton((Composite)headerPanel, (String)Messages.datatypeReconciler_convertAllColumnDatatypesLabel);
        this.changeAllColumnDatatypesButton.setToolTipText(Messages.datatypeReconciler_convertAllColumnDatatypesTooltip);
        this.changeAllColumnDatatypesButton.setImage(UiPlugin.getDefault().getImage("icons/full/cview20/arrow-only-20x20.png"));
        this.changeAllColumnDatatypesButton.setEnabled(false);
        this.changeAllColumnDatatypesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatatypeReconcilerPanel.this.changeAllColumnDatatypesPressed();
            }
        });
        this.bindingTableViewer = new TableViewerBuilder(tablePanel, 68356);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.bindingTableViewer.getTableComposite());
        this.bindingContentProvider = new BindingContentProvider();
        TableViewerColumn column = this.bindingTableViewer.createColumn(16384, 20, 30, true);
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(0));
        column.getColumn().setText(this.getSpaces(8));
        column = this.bindingTableViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(String.valueOf(Messages.datatypeReconciler_sourceSqlSymbolLabel) + this.getSpaces(100));
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(1));
        column = this.bindingTableViewer.createColumn(16384, 15, 30, true);
        column.getColumn().setText(this.getSpaces(8));
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ConvertSymbolEditingSupport((ColumnViewer)this.bindingTableViewer.getTableViewer()));
        column.getColumn().setToolTipText(Messages.datatypeReconciler_convertSourceDatatypeTooltip);
        column = this.bindingTableViewer.createColumn(16384, 15, 30, true);
        column.getColumn().setText(String.valueOf(Messages.datatypeReconciler_matchedTypeLabel) + this.getSpaces(60));
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(3));
        column.setEditingSupport((EditingSupport)new ChangeProposedDatatypeEditingSupport((ColumnViewer)this.bindingTableViewer.getTableViewer()));
        column.getColumn().setToolTipText(Messages.datatypeReconciler_matchedDatatypeTooltip);
        column = this.bindingTableViewer.createColumn(16384, 15, 30, true);
        column.getColumn().setText(this.getSpaces(8));
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(4));
        column.setEditingSupport((EditingSupport)new ChangeDatatypeEditingSupport((ColumnViewer)this.bindingTableViewer.getTableViewer()));
        column.getColumn().setToolTipText(Messages.datatypeReconciler_changeTargetDatatypeTooltip);
        column = this.bindingTableViewer.createColumn(16384, 15, 30, true);
        column.getColumn().setText(String.valueOf(Messages.datatypeReconciler_targetColumnLabel) + this.getSpaces(25));
        column.setLabelProvider((CellLabelProvider)new TheBindingColumnLabelProvider(5));
        this.bindingTableViewer.getTableViewer().setUseHashlookup(true);
        this.bindingTableViewer.setContentProvider((IContentProvider)this.bindingContentProvider);
        this.bindingTableViewer.setInput((Object)this.bindingListInput);
        this.updateRowColors();
        Group selectionPanel = WidgetFactory.createGroup((Composite)tablePanel, (String)Messages.datatypeReconciler_selectionPanelInfoLabel, (int)1, (int)2);
        selectionPanel.setLayoutData((Object)new GridData(1808));
        ((GridData)selectionPanel.getLayoutData()).minimumHeight = 80;
        this.symbolConversionLabel = new Label((Composite)selectionPanel, 0);
        this.symbolConversionLabel.setText("");
        this.symbolConversionLabel.setLayoutData((Object)new GridData(768));
        this.symbolConversionLabel.setForeground(Display.getCurrent().getSystemColor(10));
        new Label((Composite)selectionPanel, 0);
        this.symbolWarningLabel = new Label((Composite)selectionPanel, 0);
        this.symbolWarningLabel.setText("");
        this.symbolWarningLabel.setLayoutData((Object)new GridData(768));
        this.symbolWarningLabel.setForeground(Display.getCurrent().getSystemColor(10));
    }

    private String getDatatypeText(Object object) {
        String result = null;
        if (object != null && object instanceof EObject) {
            result = ModelUtilities.getEMFLabelProvider().getText(object);
        }
        return result;
    }

    private void updateDisplaysOnTableSelection(Binding binding) {
        this.updateAttributeConversionPanel(binding);
        this.updateSymbolConversionPanel(binding);
    }

    private void updateAttributeConversionPanel(Binding binding) {
        this.updateAttributeConversionPanelButtons(binding);
    }

    private void updateAttributeConversionPanelButtons(Binding binding) {
        boolean enableConvertAll = false;
        boolean hasTypeConflict = this.bindingListInput.getBindingList().hasTypeConflict();
        if (hasTypeConflict && !this.targetLocked) {
            enableConvertAll = true;
        }
        this.changeAllColumnDatatypesButton.setEnabled(enableConvertAll);
    }

    private void updateSymbolConversionPanel(Binding binding) {
        boolean canConvert = this.bindingListInput.canConvert(binding);
        if (canConvert) {
            this.symbolConversionLabel.setText(this.bindingListInput.getConvertedSymbol(binding));
        } else {
            this.symbolConversionLabel.setText("");
        }
        this.symbolWarningLabel.setText(this.bindingListInput.getWarningText(binding));
        this.updateSymbolConversionPanelButtons(binding);
    }

    private void updateSymbolConversionPanelButtons(Binding binding) {
        this.convertAllSqlSymbolsButton.setEnabled(this.bindingListInput.hasConflictsAndCanConvert());
    }

    public void updateRowColors() {
        int rows = this.bindingTableViewer.getTable().getItemCount();
        int i = 0;
        while (i < rows) {
            TableItem item = this.bindingTableViewer.getTable().getItem(i);
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (!binding.isBound() || binding.hasTypeConflict()) {
                item.setBackground(this.colorManager.getColor(ColorManager.UNBOUND_BACKGROUND));
            } else {
                item.setBackground(this.colorManager.getColor(ColorManager.BOUND_BACKGROUND));
            }
            ++i;
        }
    }

    void changeAllColumnDatatypesPressed() {
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.hasTypeConflict() && binding.hasAttributeConversion()) {
                binding.acceptAttributeConversion();
            }
            ++i;
        }
        this.bindingListInput.datatypeChanged();
        this.bindingTableViewer.refresh((Object)true);
        this.updateRowColors();
        this.updateMessageArea();
        this.selectFirstBinding();
    }

    void changeAllColumnDatatypesButtonPressed() {
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.hasTypeConflict() && binding.canConvertSqlSymbol()) {
                binding.acceptSqlConversion();
            }
            ++i;
        }
        this.bindingListInput.datatypeChanged();
        this.bindingTableViewer.refresh((Object)true);
        this.updateRowColors();
        this.updateMessageArea();
        this.selectFirstBinding();
    }

    void convertSelectedAttrPressed() {
        Binding binding = this.getSelectedBinding();
        binding.setNewAttrDatatype(this.bindingListInput.getTargetDatatype(binding));
        this.updateAttributeConversionPanel(binding);
        this.bindingListInput.datatypeChanged();
        this.bindingTableViewer.refresh((Object)true);
        this.updateRowColors();
        this.updateMessageArea();
        this.selectBinding(binding);
    }

    void convertSelectedSqlPressed() {
        Binding binding = this.getSelectedBinding();
        if (binding.canConvertSqlSymbol()) {
            binding.acceptSqlConversion();
        }
        this.updateSymbolConversionPanel(binding);
        this.bindingListInput.datatypeChanged();
        this.bindingTableViewer.refresh((Object)true);
        this.updateRowColors();
        this.updateMessageArea();
        this.selectBinding(binding);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        List objects;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Binding binding = null;
        if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
            Object o = SelectionUtilities.getSelectedObject((ISelection)selection);
            binding = (Binding)o;
        } else if (SelectionUtilities.isMultiSelection((ISelection)selection) && (objects = SelectionUtilities.getSelectedObjects((ISelection)selection)).size() > 0) {
            binding = (Binding)objects.get(0);
        }
        this.updateDisplaysOnTableSelection(binding);
    }

    public Binding getSelectedBinding() {
        Object elem;
        Binding selectedBinding = null;
        IStructuredSelection selection = (IStructuredSelection)this.bindingTableViewer.getSelection();
        if (selection != null && (elem = selection.getFirstElement()) != null && elem instanceof Binding) {
            selectedBinding = (Binding)elem;
        }
        return selectedBinding;
    }

    private void selectBinding(Binding binding) {
        if (binding != null) {
            this.bindingTableViewer.setSelection((ISelection)new StructuredSelection((Object)binding), true);
        }
    }

    private void selectFirstBinding() {
        if (this.bindingListInput.getBindingList().size() > 0) {
            Binding binding = this.bindingListInput.getBindingList().get(0);
            this.bindingTableViewer.setSelection((ISelection)new StructuredSelection((Object)binding), true);
        }
    }

    private void selectFirstTypeConflict() {
        Binding nextSelection = this.bindingListInput.getBindingList().getFirstTypeConflict();
        if (nextSelection != null) {
            this.bindingTableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        } else {
            this.selectFirstBinding();
        }
    }

    public boolean hasSqlSymbolModifications() {
        boolean result = false;
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.sqlSymbolWasConverted()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean hasAttributeTypeModifications() {
        boolean result = false;
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.hasAttrTypeModification()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean hasModifications() {
        boolean result = false;
        if (this.hasSqlSymbolModifications() || this.hasAttributeTypeModifications()) {
            result = true;
        }
        return result;
    }

    public void applyBindingTypeModifications() {
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding originalBinding = this.originalBindingList.get(i);
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.hasAttrTypeModification()) {
                originalBinding.setNewAttrDatatype(binding.getCurrentAttrDatatype());
            }
            if (binding.sqlSymbolWasConverted()) {
                originalBinding.setNewSymbol(binding.getCurrentSymbol());
            }
            ++i;
        }
    }

    public void clearBindingTypeModifications() {
        int i = 0;
        while (i < this.bindingListInput.getBindingList().size()) {
            Binding binding = this.bindingListInput.getBindingList().get(i);
            if (binding.hasAttrTypeModification()) {
                binding.setNewAttrDatatype(null);
            }
            if (binding.sqlSymbolWasConverted()) {
                binding.undoSqlConversion();
            }
            ++i;
        }
    }

    private String getSpaces(int nSpaces) {
        StringBuffer sb = new StringBuffer(nSpaces);
        int i = 0;
        while (i < nSpaces) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    class BindingContentProvider
    implements IStructuredContentProvider {
        BindingContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return DatatypeReconcilerPanel.this.bindingListInput.getBindingList().getAll().toArray();
        }
    }

    class BindingTableInput {
        BindingList bindingList;
        Map<Binding, EObject> targetDatatypeMap = new HashMap<Binding, EObject>();
        Map<Binding, Boolean> reconciledList = new HashMap<Binding, Boolean>();

        public BindingTableInput(BindingList bindingList) {
            this.bindingList = bindingList;
            Object[] objectArray = bindingList.getAll().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                Binding binding = (Binding)obj;
                String runtimeType = binding.getCurrentSymbolRuntimeType();
                EObject datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName((String)runtimeType);
                this.targetDatatypeMap.put(binding, datatype);
                ++n2;
            }
            this.datatypeChanged();
        }

        public BindingList getBindingList() {
            return this.bindingList;
        }

        public void datatypeChanged() {
            Object[] objectArray = this.bindingList.getAll().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding;
                Object obj = objectArray[n2];
                this.reconciledList.put(binding, !(binding = (Binding)obj).hasTypeConflict());
                ++n2;
            }
        }

        public EObject getTargetDatatype(Binding binding) {
            return this.targetDatatypeMap.get(binding);
        }

        public boolean isReconciled(Binding binding) {
            return this.reconciledList.get(binding);
        }

        public String getWarningText(Binding binding) {
            String convertedSymbol = binding.getSqlConversionText();
            int lossOfPrecIndex = convertedSymbol.indexOf(10);
            String warningText = "";
            if (lossOfPrecIndex > -1) {
                warningText = convertedSymbol.substring(lossOfPrecIndex + 1, convertedSymbol.length());
            }
            return warningText;
        }

        public String getConvertedSymbol(Binding binding) {
            String convertedSymbol = binding.getSqlConversionText();
            int lossOfPrecIndex = convertedSymbol.indexOf(10);
            if (lossOfPrecIndex > -1) {
                convertedSymbol = convertedSymbol.substring(0, lossOfPrecIndex);
            }
            return convertedSymbol;
        }

        public boolean canConvert(Binding binding) {
            String convertedSymbol = binding.getSqlConversionText();
            int lossOfPrecIndex = convertedSymbol.indexOf(10);
            if (lossOfPrecIndex > -1) {
                convertedSymbol = convertedSymbol.substring(0, lossOfPrecIndex);
            }
            return !convertedSymbol.toUpperCase().startsWith("CONVERT SQL SYMBOL");
        }

        public boolean hasConflictsAndCanConvert() {
            if (this.bindingList.hasTypeConflict()) {
                Object[] objectArray = this.bindingList.getAll().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Binding binding = (Binding)obj;
                    if (this.canConvert(binding)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void setTargetDatatype(Binding binding, EObject dType) {
            this.targetDatatypeMap.put(binding, dType);
            this.datatypeChanged();
        }

        public void setDatatypeOnBinding(Binding binding) {
            binding.setNewAttrDatatype(this.getTargetDatatype(binding));
            this.datatypeChanged();
        }
    }

    class ChangeDatatypeEditingSupport
    extends CheckBoxEditingSupport {
        public ChangeDatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof Binding && newValue instanceof Boolean) {
                DatatypeReconcilerPanel.this.convertSelectedAttrPressed();
            }
        }
    }

    class ChangeProposedDatatypeEditingSupport
    extends CheckBoxEditingSupport {
        public ChangeProposedDatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof Binding && newValue instanceof Boolean) {
                Binding binding = (Binding)element;
                Object attr = binding.getAttribute();
                if (TransformationHelper.isSqlColumn((Object)attr)) {
                    Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                    DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(shell, (EObject)attr, "string");
                    EObject originalValue = DatatypeReconcilerPanel.this.bindingListInput.getTargetDatatype(binding);
                    Object[] selection = new Object[]{originalValue};
                    selection[0] = originalValue;
                    dialog.setInitialSelections(selection);
                    int status = dialog.open();
                    Object newDatatype = originalValue;
                    if (status == 0) {
                        Object[] result = dialog.getResult();
                        newDatatype = result.length == 0 ? null : (EObject)result[0];
                    }
                    if (newDatatype != null && !newDatatype.equals(originalValue)) {
                        DatatypeReconcilerPanel.this.bindingListInput.setTargetDatatype(binding, (EObject)newDatatype);
                        DatatypeReconcilerPanel.this.updateAttributeConversionPanelButtons(binding);
                    }
                }
                DatatypeReconcilerPanel.this.bindingTableViewer.refresh((Object)true);
                DatatypeReconcilerPanel.this.updateRowColors();
                DatatypeReconcilerPanel.this.updateMessageArea();
            }
        }
    }

    class ConvertSymbolEditingSupport
    extends CheckBoxEditingSupport {
        public ConvertSymbolEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof Binding && newValue instanceof Boolean) {
                DatatypeReconcilerPanel.this.convertSelectedSqlPressed();
            }
        }
    }

    class TheBindingColumnLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public TheBindingColumnLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            String result = "";
            Binding binding = (Binding)element;
            switch (this.columnNumber) {
                case 0: {
                    break;
                }
                case 1: {
                    result = binding.getSqlSymbolText(true);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    Object attr = binding.getAttribute();
                    EObject datatype = null;
                    attr = binding.getAttribute();
                    if (TransformationHelper.isSqlColumn((Object)attr)) {
                        datatype = DatatypeReconcilerPanel.this.bindingListInput.getTargetDatatype(binding);
                    }
                    result = DatatypeReconcilerPanel.this.getDatatypeText(datatype);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    result = binding.getAttributeText(true);
                    break;
                }
            }
            return result;
        }

        public String getToolTipText(Object element) {
            return "";
        }

        public Image getImage(Object element) {
            Image image = null;
            Binding binding = (Binding)element;
            switch (this.columnNumber) {
                case 0: {
                    boolean hasWarning;
                    if (DatatypeReconcilerPanel.this.bindingListInput.isReconciled(binding)) break;
                    String warning = DatatypeReconcilerPanel.this.bindingListInput.getWarningText(binding);
                    boolean bl = hasWarning = warning.length() > 0;
                    if (!hasWarning) break;
                    image = UiPlugin.getDefault().getImage("icons/full/cview20/warning-20x20.png");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (DatatypeReconcilerPanel.this.bindingListInput.isReconciled(binding) || !DatatypeReconcilerPanel.this.bindingListInput.canConvert(binding)) {
                        image = UiPlugin.getDefault().getImage("icons/full/cview20/arrow-left-20x20-disabled.png");
                        break;
                    }
                    image = UiPlugin.getDefault().getImage("icons/full/cview20/arrow-left-20x20.png");
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (DatatypeReconcilerPanel.this.bindingListInput.isReconciled(binding)) {
                        image = UiPlugin.getDefault().getImage("icons/full/cview20/arrow-20x20-disabled.png");
                        break;
                    }
                    image = UiPlugin.getDefault().getImage("icons/full/cview20/arrow-20x20.png");
                    break;
                }
                case 5: {
                    break;
                }
            }
            return image;
        }
    }
}

