/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.PluginConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.util.TransformationSqlHelper;

public class SqlLabelProvider
extends LabelProvider
implements ITableLabelProvider,
PluginConstants.Images {
    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (columnIndex == 0 && element != null) {
            if (element instanceof IAliasSymbol) {
                IAliasSymbol aSymbol = (IAliasSymbol)element;
                IExpression uSymbol = aSymbol.getSymbol();
                String symName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)uSymbol, (boolean)true);
                result = String.valueOf(symName) + " AS " + aSymbol.getShortName();
            } else if (element instanceof IExpression) {
                result = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)((IExpression)element), (boolean)true);
            }
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0 && element instanceof IExpression) {
            image = this.getImageForSymbol((IExpression)element);
        }
        return image;
    }

    private Image getImageForSymbol(IExpression seSymbol) {
        Image result = null;
        if (seSymbol != null && seSymbol instanceof IAliasSymbol) {
            seSymbol = ((IAliasSymbol)seSymbol).getSymbol();
        }
        if (seSymbol instanceof IElementSymbol) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_symbol.gif");
        } else if (seSymbol instanceof IAggregateSymbol) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_function.gif");
        } else if (seSymbol instanceof IConstant) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_constant.gif");
        } else if (seSymbol instanceof IExpressionSymbol) {
            IExpression expression = ((IExpressionSymbol)seSymbol).getExpression();
            if (expression != null && expression instanceof IConstant) {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_constant.gif");
            } else if (expression != null && expression instanceof IFunction) {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_function.gif");
            }
        }
        if (result == null) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_undefined.gif");
        }
        return result;
    }
}

