/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import javax.lang.model.type.NullType;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.util.RuntimeTypeConverter;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.type.IDataTypeManagerService;

public class Binding {
    private static final String SPACE = " ";
    private static final String AS = "AS";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String CR = "\n";
    private static final String ATTRIBUTE_TYPE_NULL_TEXT = UiConstants.Util.getString("Binding.attributeTypeNull.text", new Object[0]);
    private static final String BINDING_SYMBOL_NULL_TEXT = UiConstants.Util.getString("Binding.bindingSymbolNull.text", new Object[0]);
    private static final String USE_SQL_SYMBOL_TEXT = UiConstants.Util.getString("Binding.useSqlSymbol.text", new Object[0]);
    private static final String USE_SQL_EXPRESSION_TEXT = UiConstants.Util.getString("Binding.useSqlExpression.text", new Object[0]);
    private static final String CONVERT_SQL_TEXT = UiConstants.Util.getString("Binding.convertSqlSymbol.text", new Object[0]);
    private static final String LOSS_OF_PRECISION_WARNING = UiConstants.Util.getString("Binding.lossOfPrecisionWarning.text", new Object[0]);
    private static final String RUNTIME_TYPES_EQUAL_TEXT = UiConstants.Util.getString("Binding.runtimeTypesEqual.text", new Object[0]);
    private static final String NO_CONVERSION_REQD_TEXT = UiConstants.Util.getString("Binding.noConversionReqd.text", new Object[0]);
    private static final String NO_CONVERSION_AVAIL_TEXT = UiConstants.Util.getString("Binding.noConversionAvail.text", new Object[0]);
    private static final String CANNOT_CONVERT_AGGREGATE_TEXT = UiConstants.Util.getString("Binding.cannotConvertAggregate.text", new Object[0]);
    private Object attribute;
    private EObject originalAttrDatatype;
    private EObject newAttrDatatype;
    private String newAttrName;
    private IExpression originalSymbol;
    private IExpression newSymbol;
    private IExpression availableSymbolConversion;
    private boolean sqlWasConverted = false;
    private boolean isInputParamBinding = false;
    private String sqlConversionText;

    public Binding(Object attribute) {
        this.setAttribute(attribute);
    }

    public Binding(Object attribute, IExpression symbol) {
        this.setAttribute(attribute);
        this.setOriginalSymbol(symbol);
    }

    public boolean isBound() {
        return this.originalSymbol != null;
    }

    public void setInputParamBinding(boolean isInputParam) {
        this.isInputParamBinding = isInputParam;
    }

    public boolean isInputParamBinding() {
        return this.isInputParamBinding;
    }

    public boolean hasTypeConflict() {
        boolean hasConflict = false;
        EObject currentAttrDatatype = this.getCurrentAttrDatatype();
        if (this.isBound()) {
            hasConflict = currentAttrDatatype == null ? true : !TransformationMappingHelper.typesMatch((IExpression)this.getCurrentSymbol(), (EObject)currentAttrDatatype);
        }
        return hasConflict;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public IExpression getOriginalSymbol() {
        return this.originalSymbol;
    }

    public IExpression getCurrentSymbol() {
        IExpression result = this.originalSymbol;
        if (this.newSymbol != null) {
            result = this.newSymbol;
        }
        return result;
    }

    public String getCurrentSymbolRuntimeType() {
        String runtimeType = null;
        IExpression currentSymbol = this.getCurrentSymbol();
        if (currentSymbol != null) {
            runtimeType = RuntimeTypeConverter.getRuntimeType((Object)currentSymbol);
        }
        return runtimeType;
    }

    public int getCurrentSymbolLength() {
        int length = 0;
        IExpression currentSymbol = this.getCurrentSymbol();
        if (currentSymbol != null) {
            length = TransformationSqlHelper.getElementSymbolLength((IExpression)currentSymbol);
        }
        return length;
    }

    public void setAttribute(Object attribute) {
        this.attribute = attribute;
        if (attribute != null && TransformationHelper.isSqlColumn((Object)attribute)) {
            this.originalAttrDatatype = TransformationHelper.getSqlColumnDatatype((EObject)((EObject)attribute));
        }
    }

    public void setOriginalSymbol(IExpression seSymbol) {
        this.originalSymbol = seSymbol;
        this.newSymbol = null;
        if (seSymbol == null) {
            this.availableSymbolConversion = null;
            this.sqlConversionText = null;
            this.sqlWasConverted = false;
        } else if (this.getAttribute() instanceof String) {
            String symbolRuntimeType = RuntimeTypeConverter.getRuntimeType((Object)seSymbol);
            EObject datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName((String)symbolRuntimeType);
            this.setNewAttrDatatype(datatype);
        } else {
            this.updateSqlConversionData();
        }
    }

    public void setNewSymbol(IExpression seSymbol) {
        if (this.originalSymbol == null) {
            this.originalSymbol = seSymbol;
            this.newSymbol = seSymbol;
        } else {
            if (this.newSymbol != null) {
                this.originalSymbol = this.newSymbol;
            }
            this.newSymbol = seSymbol;
        }
        this.updateSqlConversionData();
    }

    public void setNewAttrDatatype(EObject datatype) {
        this.newAttrDatatype = datatype;
        this.updateSqlConversionData();
    }

    public void setNewAttrName(String name) {
        this.newAttrName = name;
    }

    public EObject getOriginalAttrDatatype() {
        return this.newAttrDatatype;
    }

    public EObject getCurrentAttrDatatype() {
        EObject result = this.originalAttrDatatype;
        if (this.hasAttrTypeModification()) {
            result = this.newAttrDatatype;
        }
        return result;
    }

    public String getCurrentAttrName() {
        if (this.hasAttrNameModification()) {
            return this.newAttrName;
        }
        return this.getAttributeName();
    }

    public boolean hasAttrTypeModification() {
        return this.newAttrDatatype != null;
    }

    public boolean hasAttrNameModification() {
        return this.newAttrName != null;
    }

    public void applyAttrNameModification(Object txnSource) {
        if (this.hasAttrNameModification()) {
            String newName = this.getCurrentAttrName();
            Object attribute = this.getAttribute();
            if (attribute instanceof EObject) {
                TransformationHelper.setSqlColumnName((EObject)((EObject)this.getAttribute()), (String)newName, (Object)txnSource);
            }
        }
    }

    public void applyAttrTypeModification(Object txnSource) {
        if (this.hasAttrTypeModification()) {
            EObject newType = this.getCurrentAttrDatatype();
            Object attribute = this.getAttribute();
            if (attribute instanceof EObject) {
                TransformationHelper.setSqlColumnDatatype((EObject)((EObject)attribute), (EObject)newType, (Object)txnSource);
            }
        }
    }

    public boolean hasSymbolModification() {
        return this.newSymbol != null;
    }

    public boolean hasAvailableSymbolConversion() {
        return this.availableSymbolConversion != null;
    }

    public void acceptSqlConversion() {
        if (this.hasAvailableSymbolConversion()) {
            this.newSymbol = this.availableSymbolConversion;
            this.updateSqlConversionData();
            this.sqlWasConverted = true;
        }
    }

    public void undoSqlConversion() {
        if (this.sqlWasConverted) {
            this.newSymbol = null;
            this.updateSqlConversionData();
            this.sqlWasConverted = false;
        }
    }

    public boolean sqlSymbolWasConverted() {
        return this.sqlWasConverted;
    }

    public void acceptAttributeConversion() {
        if (this.hasAttributeConversion()) {
            String runtimeType = this.getCurrentSymbolRuntimeType();
            EObject datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName((String)runtimeType);
            this.setNewAttrDatatype(datatype);
        }
    }

    public String getAttributeName() {
        String result = "";
        Object attr = this.getAttribute();
        if (TransformationHelper.isSqlColumn((Object)attr)) {
            result = TransformationHelper.getSqlEObjectName((EObject)((EObject)attr));
        } else if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }

    public String getAttributeFullName() {
        String result = "";
        Object attr = this.getAttribute();
        if (TransformationHelper.isSqlColumn((Object)attr)) {
            result = TransformationHelper.getSqlEObjectFullName((EObject)((EObject)attr));
        } else if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }

    public String getAttributeText(boolean showType) {
        EObject currentDatatype;
        DatatypeManager dtMgr;
        String dtName;
        StringBuffer sb = new StringBuffer(this.getCurrentAttrName());
        if (showType && (dtName = (dtMgr = ModelerCore.getDatatypeManager((EObject)(currentDatatype = this.getCurrentAttrDatatype()), (boolean)true)).getRuntimeTypeName(currentDatatype)) != null) {
            sb.append(" : " + dtName);
        }
        return sb.toString();
    }

    public String getSqlSymbolText(boolean showType) {
        StringBuffer sb = new StringBuffer();
        IExpression sqlSymbol = this.getCurrentSymbol();
        if (sqlSymbol != null) {
            if (sqlSymbol instanceof IAliasSymbol) {
                sqlSymbol = ((IAliasSymbol)sqlSymbol).getSymbol();
            }
            if (sqlSymbol instanceof IExpression) {
                String symShortName;
                String attrName;
                String symbolName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)sqlSymbol, (boolean)true);
                sb = !this.isInputParamBinding() ? (!(attrName = this.getCurrentAttrName()).equalsIgnoreCase(symShortName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)sqlSymbol, (boolean)false)) ? new StringBuffer(String.valueOf(symbolName) + SPACE + AS + SPACE + attrName) : new StringBuffer(symbolName)) : new StringBuffer(symbolName);
                if (showType) {
                    sb.append(" : " + this.getSymbolDatatype(sqlSymbol));
                }
            }
        }
        return sb.toString();
    }

    private String getSymbolDatatype(IExpression seSymbol) {
        Class objClass = seSymbol.getType();
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        String typeName = objClass == null ? service.getDataTypeName(NullType.class) : service.getDataTypeName(objClass);
        return typeName;
    }

    public IExpression createBindingSymbol() {
        IExpression result = null;
        if (this.isBound()) {
            IExpression currentSymbol = this.getCurrentSymbol();
            String currentAttrName = this.getCurrentAttrName();
            String symbolShortName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)currentSymbol, (boolean)false);
            if (symbolShortName != null && symbolShortName.equalsIgnoreCase(currentAttrName)) {
                result = (IExpression)currentSymbol.clone();
            } else if (currentSymbol instanceof IAliasSymbol) {
                IExpression uSymbol = ((IAliasSymbol)currentSymbol).getSymbol();
                IQueryService queryService = ModelerCore.getTeiidQueryService();
                if (queryService.getSymbolShortName(uSymbol).equalsIgnoreCase(currentAttrName)) {
                    result = (IExpression)uSymbol.clone();
                } else {
                    IAliasSymbol aSym = (IAliasSymbol)currentSymbol.clone();
                    aSym.setShortName(currentAttrName);
                    result = aSym;
                }
            } else {
                IQueryService queryService = ModelerCore.getTeiidQueryService();
                IQueryFactory factory = queryService.createQueryFactory();
                result = currentSymbol = factory.createAliasSymbol(currentAttrName, currentSymbol);
            }
        }
        return result;
    }

    public boolean hasAttributeConversion() {
        EObject datatype;
        boolean canConvert = false;
        String symbolRuntimeType = this.getCurrentSymbolRuntimeType();
        if (symbolRuntimeType != null && (datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName((String)symbolRuntimeType)) != null) {
            canConvert = true;
        }
        return canConvert;
    }

    public boolean canConvertSqlSymbol() {
        return this.availableSymbolConversion != null;
    }

    public String getSqlConversionText() {
        return this.sqlConversionText;
    }

    private void updateSqlConversionData() {
        this.updateCanConvertSqlStatus();
        this.updateAvailableSymbolConversionAndText();
    }

    private void updateCanConvertSqlStatus() {
        if (this.getAttribute() instanceof String || this.getCurrentAttrDatatype() == null) {
            return;
        }
    }

    public void updateAvailableSymbolConversionAndText() {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.sqlConversionText = null;
        this.availableSymbolConversion = null;
        if (this.getCurrentSymbol() == null) {
            this.sqlConversionText = BINDING_SYMBOL_NULL_TEXT;
            return;
        }
        String symbolAlias = "aliasName";
        EObject attrDatatype = this.getCurrentAttrDatatype();
        if (attrDatatype == null) {
            this.sqlConversionText = String.valueOf(NO_CONVERSION_REQD_TEXT) + CR + ATTRIBUTE_TYPE_NULL_TEXT;
            return;
        }
        String currentAttrTypeStr = RuntimeTypeConverter.getRuntimeType((Object)attrDatatype);
        IExpression sqlSymbol = this.getCurrentSymbol();
        String sqlSymbolTypeStr = RuntimeTypeConverter.getRuntimeType((Object)sqlSymbol);
        IExpression oSymbol = this.originalSymbol;
        if (!currentAttrTypeStr.equalsIgnoreCase(sqlSymbolTypeStr)) {
            String originalSQLTypeStr = service.getDataTypeName(oSymbol.getType());
            if (currentAttrTypeStr.equalsIgnoreCase(originalSQLTypeStr)) {
                this.availableSymbolConversion = null;
                this.sqlConversionText = String.valueOf(CONVERT_SQL_TEXT) + CR + oSymbol.toString();
            } else {
                boolean isExplicit = service.isExplicitConversion(sqlSymbolTypeStr, currentAttrTypeStr);
                boolean isImplicit = service.isImplicitConversion(sqlSymbolTypeStr, currentAttrTypeStr);
                if (isImplicit || isExplicit) {
                    if (oSymbol instanceof IAliasSymbol) {
                        IAliasSymbol aSym = (IAliasSymbol)oSymbol;
                        oSymbol = aSym.getSymbol();
                        symbolAlias = this.getCurrentAttrName();
                    }
                    if (oSymbol instanceof IElementSymbol) {
                        symbolAlias = this.getCurrentAttrName();
                        IAliasSymbol aSymbol = TransformationSqlHelper.convertElementSymbol((IElementSymbol)((IElementSymbol)oSymbol), (String)currentAttrTypeStr, (String)symbolAlias);
                        this.availableSymbolConversion = aSymbol;
                        this.sqlConversionText = this.getSQLLabelText((IExpression)aSymbol, symbolAlias, isExplicit);
                        return;
                    }
                    if (oSymbol instanceof IExpressionSymbol) {
                        IExpressionSymbol eSymbol = (IExpressionSymbol)oSymbol.clone();
                        if (TransformationSqlHelper.isConvertFunction((IExpressionSymbol)eSymbol)) {
                            IExpression cExpr = TransformationSqlHelper.getConvertedExpr((IExpressionSymbol)eSymbol);
                            if (cExpr != null) {
                                IExpression seSymbol = cExpr;
                                String seSymbolTypeStr = service.getDataTypeName(seSymbol.getType());
                                if (seSymbolTypeStr != null && seSymbolTypeStr.equalsIgnoreCase(currentAttrTypeStr)) {
                                    this.availableSymbolConversion = seSymbol;
                                    this.sqlConversionText = String.valueOf(USE_SQL_SYMBOL_TEXT) + CR + seSymbol.toString();
                                    return;
                                }
                            } else {
                                String exprTypeStr = service.getDataTypeName(cExpr.getType());
                                if (exprTypeStr != null && exprTypeStr.equalsIgnoreCase(currentAttrTypeStr)) {
                                    IExpressionSymbol exprSymbol = factory.createExpressionSymbol("expr", cExpr);
                                    this.availableSymbolConversion = exprSymbol;
                                    this.sqlConversionText = symbolAlias != null ? String.valueOf(USE_SQL_EXPRESSION_TEXT) + CR + this.availableSymbolConversion.toString() + SPACE + AS + SPACE + symbolAlias : String.valueOf(USE_SQL_EXPRESSION_TEXT) + CR + this.availableSymbolConversion.toString();
                                    return;
                                }
                                if (exprTypeStr != null) {
                                    IExpressionSymbol exprSymb = factory.createExpressionSymbol("expr", cExpr);
                                    eSymbol = TransformationSqlHelper.convertExpressionSymbol((IExpressionSymbol)exprSymb, (String)currentAttrTypeStr);
                                }
                            }
                        } else {
                            eSymbol = TransformationSqlHelper.convertExpressionSymbol((IExpressionSymbol)((IExpressionSymbol)oSymbol), (String)currentAttrTypeStr);
                        }
                        this.sqlConversionText = this.getSQLLabelText((IExpression)eSymbol, symbolAlias, isExplicit);
                        this.availableSymbolConversion = symbolAlias != null ? factory.createAliasSymbol(symbolAlias, (IExpression)eSymbol) : eSymbol;
                    }
                    this.sqlConversionText = String.valueOf(CONVERT_SQL_TEXT) + SPACE + FROM + SPACE + sqlSymbolTypeStr + SPACE + TO + SPACE + currentAttrTypeStr;
                } else {
                    this.sqlConversionText = String.valueOf(CONVERT_SQL_TEXT) + CR + NO_CONVERSION_AVAIL_TEXT + SPACE + FROM + SPACE + sqlSymbolTypeStr + SPACE + TO + SPACE + currentAttrTypeStr;
                }
            }
        } else {
            this.sqlConversionText = String.valueOf(RUNTIME_TYPES_EQUAL_TEXT) + CR + NO_CONVERSION_REQD_TEXT;
        }
    }

    private String getSQLLabelText(IExpression seSymbol, String symbolAlias, boolean isExplicit) {
        StringBuffer sb = new StringBuffer();
        if (seSymbol != null) {
            sb.append(seSymbol.toString());
            if (symbolAlias != null && !(seSymbol instanceof IAliasSymbol)) {
                sb.append(" AS " + symbolAlias);
            }
            if (isExplicit) {
                sb.append(CR + LOSS_OF_PRECISION_WARNING);
            }
        }
        return sb.toString();
    }
}

