/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.reconciler.SqlLabelProvider;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.table.TableSizeAdapter;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class AddSqlSymbolsPanel
extends Composite {
    private int LABEL_GRID_STYLE = 32;
    private String TABLE_LABEL = UiConstants.Util.getString("AddSqlSymbolsPanel.tableLabel", new Object[0]);
    private String COLUMN_1_LABEL = UiConstants.Util.getString("AddSqlSymbolsPanel.column_1_Label", new Object[0]);
    private String COLUMN_2_LABEL = UiConstants.Util.getString("AddSqlSymbolsPanel.column_2_Label", new Object[0]);
    private Table table;
    private TableViewer tableViewer;
    List availableSymbols = Collections.EMPTY_LIST;

    public AddSqlSymbolsPanel(Composite parent, List availableSymbols) {
        super(parent, 0);
        this.availableSymbols = availableSymbols;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        WidgetFactory.createLabel((Composite)this, (int)this.LABEL_GRID_STYLE, (int)1, (String)this.TABLE_LABEL);
        this.createTable(this);
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        TableColumn column1 = new TableColumn(this.table, 16384, 0);
        column1.setText(this.COLUMN_1_LABEL);
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column2 = new TableColumn(this.table, 16384, 1);
        column2.setText(this.COLUMN_2_LABEL);
        weight = new ColumnWeightData(2);
        layout.addColumnData((ColumnLayoutData)weight);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new MySqlContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MySqlLabelProvider());
        this.tableViewer.setInput((Object)this.availableSymbols);
        this.createTableTooltipListeners(this.table);
        new TableSizeAdapter(this.table, 10);
    }

    private void createTableTooltipListeners(final Table table) {
        table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(AddSqlSymbolsPanel.this.getShell(), 16384);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(AddSqlSymbolsPanel.this.getShell().getDisplay().getSystemColor(28));
                        this.label.setBackground(AddSqlSymbolsPanel.this.getShell().getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        Object data = item.getData();
                        String tipText = null;
                        if (data instanceof IExpression) {
                            IQueryService queryService = ModelerCore.getTeiidQueryService();
                            tipText = queryService.getSymbolName((IExpression)data);
                        }
                        if (tipText != null) {
                            this.label.setText(tipText);
                        }
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x + 10, pt.y + 10, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
    }

    public List getSelectedSymbols() {
        ISelection theSelection = this.tableViewer.getSelection();
        if (theSelection == null || theSelection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return SelectionUtilities.getSelectedObjects((ISelection)theSelection);
    }

    class MySqlContentProvider
    implements IStructuredContentProvider {
        MySqlContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return AddSqlSymbolsPanel.this.availableSymbols.toArray();
        }
    }

    class MySqlLabelProvider
    extends SqlLabelProvider {
        MySqlLabelProvider() {
        }

        @Override
        public String getColumnText(Object theElement, int theColumnIndex) {
            String columnText = "EMPTY";
            switch (theColumnIndex) {
                case 0: {
                    columnText = super.getColumnText(theElement, theColumnIndex);
                    break;
                }
                case 1: {
                    EObject singleElementEObject;
                    if (theElement == null) break;
                    if (theElement instanceof IAliasSymbol) {
                        EObject singleElementEObject2;
                        IAliasSymbol aSymbol = (IAliasSymbol)theElement;
                        IExpression uSymbol = aSymbol.getSymbol();
                        if (uSymbol == null || (singleElementEObject2 = TransformationSqlHelper.getSingleElementSymbolEObject((IExpression)uSymbol)) == null) break;
                        columnText = this.getAppendedPath(singleElementEObject2);
                        break;
                    }
                    if (!(theElement instanceof IExpression) || (singleElementEObject = TransformationSqlHelper.getSingleElementSymbolEObject((IExpression)((IExpression)theElement))) == null) break;
                    columnText = this.getAppendedPath(singleElementEObject);
                }
            }
            return columnText;
        }

        private String getAppendedPath(EObject eObj) {
            if (TransformationHelper.isMappingClass((Object)eObj)) {
                MappingClass mc = (MappingClass)eObj;
                EObject doc = mc.getMappingClassSet().getTarget();
                IPath pathToDoc = ModelerCore.getModelEditor().getFullPathToParent(doc);
                pathToDoc = pathToDoc.append(ModelerCore.getModelEditor().getName(doc));
                return pathToDoc.toString();
            }
            return ModelerCore.getModelEditor().getFullPathToParent(eObj).toString();
        }
    }
}

