/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.ui.util.TransformationUmlEObjectHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TransformationDiagramNotificationHelper {
    private Notification primaryNotification = null;
    private DiagramModelNode diagramNode = null;
    private boolean reconcileTargetAttributes = false;
    private boolean reconcileSources = false;
    private boolean refreshDiagram;
    private List reconcileTables = null;
    private boolean handleNotification = false;
    private List changedNodes = null;
    private List movedNodes = null;
    private EObject targetEObject = null;

    public TransformationDiagramNotificationHelper(Notification notification, DiagramModelNode transformationDiagramModelNode) {
        this.primaryNotification = notification;
        this.diagramNode = transformationDiagramModelNode;
        this.init();
    }

    private void init() {
        this.reconcileTables = new ArrayList();
        this.changedNodes = new ArrayList();
        this.movedNodes = new ArrayList();
        this.setTransformation();
        this.setHandleNotification();
        this.setReconcileSources();
        this.setReconcileAttributes();
        this.setRefreshDiagram();
    }

    private void setTransformation() {
        this.targetEObject = ((Diagram)this.diagramNode.getModelObject()).getTarget();
    }

    private void setHandleNotification() {
        boolean shouldHandle = false;
        Diagram currentDiagram = (Diagram)this.diagramNode.getModelObject();
        ModelResource diagramMR = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram);
        if (diagramMR != null) {
            if (this.primaryNotification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)this.primaryNotification).getSource();
                if (source == null || !source.equals(this)) {
                    Collection notifications = ((SourcedNotification)this.primaryNotification).getNotifications();
                    Iterator iter = notifications.iterator();
                    Notification nextNotification = null;
                    while (iter.hasNext() && !shouldHandle) {
                        ModelResource mr;
                        nextNotification = (Notification)iter.next();
                        Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                        if (targetObject != null && targetObject instanceof EObject && !DiagramUiUtilities.isNonDrawingDiagramObject((EObject)((EObject)targetObject))) {
                            shouldHandle = true;
                            continue;
                        }
                        if (!(targetObject instanceof Diagram) || !NotificationUtilities.isRemoved((Notification)nextNotification) || (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject))) == null || !mr.equals(diagramMR)) continue;
                        shouldHandle = true;
                    }
                }
            } else {
                ModelResource mr;
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(this.primaryNotification);
                if (targetObject != null && targetObject instanceof EObject && !DiagramUiUtilities.isNonDrawingDiagramObject((EObject)((EObject)targetObject))) {
                    shouldHandle = true;
                } else if (targetObject instanceof Diagram && NotificationUtilities.isRemoved((Notification)this.primaryNotification) && (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject))) != null && mr.equals(diagramMR)) {
                    shouldHandle = true;
                }
            }
        }
        this.handleNotification = shouldHandle;
    }

    public boolean shouldHandleNotification() {
        return this.handleNotification;
    }

    public boolean shouldReconcileSources() {
        return this.reconcileSources;
    }

    private void setReconcileSources() {
        this.reconcileSources = false;
        String diagramType = ((Diagram)this.diagramNode.getModelObject()).getType();
        if ("transformationDiagramType".equals(diagramType)) {
            this.reconcileSources = true;
        } else if ("dependencyDiagramType".equals(diagramType)) {
            Collection diagramEObjects = DiagramUiUtilities.getEObjects((DiagramModelNode)this.diagramNode);
            Collection notifications = ((SourcedNotification)this.primaryNotification).getNotifications();
            for (Notification nextNotification : notifications) {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                if (!diagramEObjects.contains(targetObject) || !TransformationDiagramNotificationHelper.isAnyContainerType(NotificationUtilities.getAddedChildren((Notification)nextNotification)) && !TransformationDiagramNotificationHelper.isAnyContainerType(NotificationUtilities.getRemovedChildren((Notification)nextNotification))) continue;
                this.reconcileSources = true;
                break;
            }
        }
    }

    private static boolean isAnyContainerType(EObject[] objs) {
        int i = 0;
        while (i < objs.length) {
            EObject object = objs[i];
            int umlType = TransformationUmlEObjectHelper.getEObjectType(object);
            switch (umlType) {
                case 0: 
                case 1: 
                case 100: 
                case 101: 
                case 103: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean shouldRefreshDiagram() {
        return this.refreshDiagram;
    }

    private void setRefreshDiagram() {
        this.refreshDiagram = false;
        String diagramType = ((Diagram)this.diagramNode.getModelObject()).getType();
        if ("dependencyDiagramType".equals(diagramType)) {
            Collection diagramEObjects = DiagramUiUtilities.getEObjects((DiagramModelNode)this.diagramNode);
            Collection notifications = ((SourcedNotification)this.primaryNotification).getNotifications();
            for (Notification nextNotification : notifications) {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                if (diagramEObjects.contains(targetObject)) {
                    this.refreshDiagram = true;
                    break;
                }
                if (NotificationUtilities.isRemoved((Notification)nextNotification)) {
                    EObject[] remChildren;
                    EObject[] eObjectArray = remChildren = NotificationUtilities.getRemovedChildren((Notification)nextNotification);
                    int n = remChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EObject eobj = eObjectArray[n2];
                        if (diagramEObjects.contains(eobj)) {
                            this.refreshDiagram = true;
                        }
                        ++n2;
                    }
                }
                if (this.refreshDiagram) break;
            }
        }
    }

    private void setReconcileAttributes() {
        this.reconcileTargetAttributes = false;
        this.reconcileTables.clear();
        Collection notifications = ((SourcedNotification)this.primaryNotification).getNotifications();
        Iterator iter = notifications.iterator();
        Notification notification = null;
        while (iter.hasNext()) {
            DiagramModelNode vgDiagramNode;
            DiagramModelNode targetNode;
            notification = (Notification)iter.next();
            EObject targetObject = this.getEObjectTarget(notification);
            if (NotificationUtilities.isAdded((Notification)notification) || NotificationUtilities.isRemoved((Notification)notification)) {
                if (!this.reconcileTargetAttributes && targetObject == this.targetEObject) {
                    this.reconcileTargetAttributes = true;
                    targetNode = this.getPrimaryDiagramModelNode(this.diagramNode, targetObject);
                    if (targetNode == null || this.reconcileTables.contains(targetNode)) continue;
                    this.reconcileTables.add(targetNode);
                    continue;
                }
                targetNode = this.getPrimaryDiagramModelNode(this.diagramNode, targetObject);
                if (!this.canAddOrRemove(targetNode)) continue;
                if (!this.isNestedClassifier(targetNode)) {
                    if (targetNode == null || this.reconcileTables.contains(targetNode)) continue;
                    this.reconcileTables.add(targetNode);
                    continue;
                }
                targetNode = this.getModelNode(this.diagramNode, targetObject);
                if (targetNode == null || !this.isNestedClassifier(targetNode) || this.reconcileTables.contains(targetNode)) continue;
                this.reconcileTables.add(targetNode);
                continue;
            }
            if (!NotificationUtilities.isChanged((Notification)notification) || (targetNode = this.getModelNode(this.diagramNode, targetObject)) == null) continue;
            if (notification.getEventType() == 7) {
                if (this.movedNodes.contains(targetNode)) continue;
                this.movedNodes.add(targetNode);
                continue;
            }
            if (!this.changedNodes.contains(targetNode)) {
                this.changedNodes.add(targetNode);
            }
            if ((vgDiagramNode = this.getTargetDiagramNode()) == null || vgDiagramNode != targetNode) continue;
            this.changedNodes.add(this.getTransformationDiagramNode());
        }
    }

    public List getChangedNodes() {
        return this.changedNodes;
    }

    public List getMovedNodes() {
        return this.movedNodes;
    }

    private EObject getEObjectTarget(Notification notification) {
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject instanceof EObject) {
            return (EObject)targetObject;
        }
        return null;
    }

    public DiagramModelNode getPrimaryDiagramModelNode(DiagramModelNode diagramModelNode, EObject someModelObject) {
        if ((diagramModelNode instanceof UmlClassifierNode || diagramModelNode instanceof TransformationNode) && diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject().equals(someModelObject)) {
            return diagramModelNode;
        }
        DiagramModelNode matchedNode = null;
        List contents = diagramModelNode.getChildren();
        if (contents != null && !contents.isEmpty()) {
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DiagramModelNode nextNode = null;
            while (iter.hasNext() && matchedNode == null) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                nextNode = nextObj;
                matchedNode = this.getPrimaryDiagramModelNode(nextNode, someModelObject);
            }
        }
        return matchedNode;
    }

    public DiagramModelNode getModelNode(DiagramModelNode diagramModelNode, EObject someModelObject) {
        if (diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject().equals(someModelObject)) {
            return diagramModelNode;
        }
        DiagramModelNode matchedNode = null;
        List contents = diagramModelNode.getChildren();
        if (contents != null && !contents.isEmpty()) {
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DiagramModelNode nextNode = null;
            while (iter.hasNext() && matchedNode == null) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                nextNode = nextObj;
                matchedNode = this.getModelNode(nextNode, someModelObject);
            }
        }
        return matchedNode;
    }

    private boolean canAddOrRemove(DiagramModelNode targetNode) {
        boolean canDo = false;
        if (targetNode != null && targetNode instanceof UmlClassifierNode) {
            canDo = true;
        }
        return canDo;
    }

    private boolean isNestedClassifier(DiagramModelNode targetNode) {
        return targetNode.getParent() instanceof UmlClassifierContainerNode;
    }

    public List getReconcileTableNodes() {
        return this.reconcileTables;
    }

    public DiagramModelNode getDiagramNode() {
        return this.diagramNode;
    }

    public DiagramModelNode getTargetDiagramNode() {
        return this.getModelNode(this.diagramNode, this.targetEObject);
    }

    public DiagramModelNode getTransformationDiagramNode() {
        Iterator iter = this.diagramNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof TransformationNode)) continue;
            return nextNode;
        }
        return null;
    }
}

