/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.transformation.model.RelationalViewProcedure;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.TransformationDialogModel;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.wizards.sqlbuilder.SQLTemplateDialog;
import org.teiid.designer.transformation.util.SqlStringUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.properties.extension.VdbFileDialogUtil;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;

public class ViewProcedureEditorPanel
extends RelationalEditorPanel
implements RelationalConstants {
    private TabItem generalPropertiesTab;
    private TabItem sqlTab;
    private TabItem parametersTab;
    private TabItem resultSetTab;
    private Button nonPreparedCB;
    private Button deterministicCB;
    private Button returnsNullCB;
    private Button variableArgsCB;
    private Button aggregateCB;
    private Button allowsDistinctCB;
    private Button allowsOrderByCB;
    private Button analyticCB;
    private Button decomposableCB;
    private Button useDistinctRowsCB;
    private Button includeResultSetCB;
    private Text resultSetNameText;
    private Button addParameterButton;
    private Button deleteParameterButton;
    private Button upParameterButton;
    private Button downParameterButton;
    private Button addColumnButton;
    private Button deleteColumnButton;
    private Button upColumnButton;
    private Button downColumnButton;
    private Combo updateCountCombo;
    private TableViewerBuilder parametersViewer;
    private TableViewerBuilder columnsViewer;
    private SqlTextViewer sqlTextViewer;
    private Document sqlDocument;
    private Text javaClassText;
    private Text javaMethodText;
    private Text functionCategoryText;
    private Text udfJarPathText;
    private Button udfJarPathBrowse;
    private Button applyRestWarPropertiesCB;
    private String restMethodValue = "GET";
    private Combo restMethodsCombo;
    private String restUriValue;
    private Text restUriText;
    private String restCharSetValue;
    private Combo restCharSetsCombo;
    private String restHeadersValue;
    private Text restHeadersText;
    boolean validationPerformed = false;

    public ViewProcedureEditorPanel(Composite parent, TransformationDialogModel dialogModel, IDialogStatusListener statusListener) {
        super(parent, (EditRelationalObjectDialogModel)dialogModel, statusListener);
        this.synchronizeUI();
    }

    protected RelationalViewProcedure getRelationalReference() {
        return (RelationalViewProcedure)super.getRelationalReference();
    }

    private boolean isFunction() {
        return this.getRelationalReference().isFunction();
    }

    protected void createPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().applyTo(thePanel);
        GridDataFactory.fillDefaults().applyTo((Control)thePanel);
        this.createNameGroup(thePanel);
        TabFolder tabFolder = this.createTabFolder(parent);
        this.createGeneralPropertiesTab(tabFolder);
        this.createParametersTab(tabFolder);
        if (!this.isFunction()) {
            this.createSQLTab(tabFolder);
            this.createResultSetTab(tabFolder);
        }
        this.createDescriptionTab(tabFolder);
    }

    private void createGeneralPropertiesTab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(Messages.propertiesLabel);
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage((int)5, (int)ModelType.VIRTUAL, (IStatus)Status.OK_STATUS));
    }

    private void createParametersTab(TabFolder folderParent) {
        Composite thePanel = this.createParameterTableGroup((Composite)folderParent);
        this.parametersTab = new TabItem(folderParent, 0);
        this.parametersTab.setControl((Control)thePanel);
        this.parametersTab.setText(Messages.parametersLabel);
        this.parametersTab.setImage(RelationalUiUtil.getRelationalImage((int)6, (int)this.getRelationalReference().getModelType(), (IStatus)Status.OK_STATUS));
    }

    private void createSQLTab(TabFolder folderParent) {
        Composite thePanel = this.createSQLPanel((Composite)folderParent);
        this.sqlTab = new TabItem(folderParent, 0);
        this.sqlTab.setControl((Control)thePanel);
        this.sqlTab.setText(Messages.transformationSqlLabel);
        this.sqlTab.setImage(RelationalUiUtil.getNativeSQLImage((IStatus)Status.OK_STATUS));
    }

    private void createResultSetTab(TabFolder folderParent) {
        Composite thePanel = this.createResultSetPanel((Composite)folderParent);
        this.resultSetTab = new TabItem(folderParent, 0);
        this.resultSetTab.setControl((Control)thePanel);
        this.resultSetTab.setText(Messages.resultSetLabel);
    }

    protected void synchronizeExtendedUI() {
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage((int)5, (int)this.getRelationalReference().getModelType(), (IStatus)Status.OK_STATUS));
        this.parametersViewer.getTable().removeAll();
        IStatus maxStatus = Status.OK_STATUS;
        for (RelationalParameter row : this.getRelationalReference().getParameters()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.parametersViewer.add((Object)row);
        }
        this.parametersTab.setImage(RelationalUiUtil.getRelationalImage((int)6, (int)this.getRelationalReference().getModelType(), (IStatus)maxStatus));
        if (!this.isFunction()) {
            if (this.getRelationalReference().getResultSet() == null) {
                if (WidgetUtil.widgetValueChanged((Button)this.includeResultSetCB, (boolean)false)) {
                    this.includeResultSetCB.setSelection(false);
                    this.addColumnButton.setEnabled(false);
                }
                this.resultSetNameText.setEnabled(false);
                if (WidgetUtil.widgetValueChanged((Text)this.resultSetNameText, (String)"")) {
                    this.resultSetNameText.setText("");
                }
                this.columnsViewer.getTable().removeAll();
                this.columnsViewer.getTable().setEnabled(false);
                this.resultSetTab.setImage(RelationalUiUtil.getRelationalImage((int)3, (int)ModelType.VIRTUAL, (IStatus)Status.OK_STATUS));
            } else {
                this.columnsViewer.getTable().setEnabled(true);
                if (WidgetUtil.widgetValueChanged((Button)this.includeResultSetCB, (boolean)true)) {
                    this.includeResultSetCB.setSelection(true);
                }
                this.resultSetNameText.setEnabled(true);
                if (this.getRelationalReference().getResultSet().getName() != null && WidgetUtil.widgetValueChanged((Text)this.resultSetNameText, (String)this.getRelationalReference().getResultSet().getName())) {
                    this.resultSetNameText.setText(this.getRelationalReference().getResultSet().getName());
                }
                this.columnsViewer.getTable().removeAll();
                if (!this.getRelationalReference().getResultSet().getColumns().isEmpty()) {
                    for (RelationalColumn column : this.getRelationalReference().getResultSet().getColumns()) {
                        this.columnsViewer.add((Object)column);
                    }
                }
                this.resultSetTab.setImage(RelationalUiUtil.getRelationalImage((int)3, (int)this.getRelationalReference().getResultSet().getModelType(), (IStatus)this.getRelationalReference().getResultSet().getStatus()));
            }
        }
        if (this.isFunction() && this.getRelationalReference().getUdfJarPath() != null) {
            int caret = this.udfJarPathText.getCaretPosition();
            this.udfJarPathText.setText(this.getRelationalReference().getUdfJarPath());
            this.udfJarPathText.setSelection(caret);
        }
    }

    private Composite createResultSetPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.includeResultSetCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.includeResultSetCB);
        this.includeResultSetCB.setText(Messages.includeLabel);
        this.includeResultSetCB.setToolTipText(Messages.includeResultSetTooltip);
        this.includeResultSetCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewProcedureEditorPanel.this.includeResultSetCB.getSelection()) {
                    if (ViewProcedureEditorPanel.this.getRelationalReference().getResultSet() == null) {
                        RelationalProcedureResultSet resultSet = new RelationalProcedureResultSet();
                        if (ViewProcedureEditorPanel.this.resultSetNameText.getText() != null) {
                            resultSet.setName(ViewProcedureEditorPanel.this.resultSetNameText.getText());
                        }
                        ViewProcedureEditorPanel.this.getRelationalReference().setResultSet(resultSet);
                    }
                } else {
                    ViewProcedureEditorPanel.this.getRelationalReference().setResultSet(null);
                }
                ViewProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        Composite namePanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)2, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(namePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)namePanel);
        Label label = new Label(namePanel, 131072);
        label.setText(Messages.nameLabel);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.resultSetNameText = new Text(namePanel, 2052);
        this.resultSetNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).minSize(50, -1).applyTo((Control)this.resultSetNameText);
        this.resultSetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = ViewProcedureEditorPanel.this.resultSetNameText.getText();
                if (value == null) {
                    value = "";
                }
                if (ViewProcedureEditorPanel.this.getRelationalReference().getResultSet() != null) {
                    RelationalProcedureResultSet resultSet = ViewProcedureEditorPanel.this.getRelationalReference().getResultSet();
                    resultSet.setName(value);
                }
                ViewProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonPanel);
        this.addColumnButton = new Button(buttonPanel, 8);
        this.addColumnButton.setText(Messages.addLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.addColumnButton);
        this.addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().createColumn();
                ViewProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        this.addColumnButton.setEnabled(false);
        this.deleteColumnButton = new Button(buttonPanel, 8);
        this.deleteColumnButton.setText(Messages.deleteLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteColumnButton);
        this.deleteColumnButton.setEnabled(false);
        this.deleteColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn column = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        column = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (column != null) {
                    ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().removeColumn(column);
                    ViewProcedureEditorPanel.this.deleteColumnButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upColumnButton = new Button(buttonPanel, 8);
        this.upColumnButton.setText(Messages.moveUpLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.upColumnButton);
        this.upColumnButton.setEnabled(false);
        this.upColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewProcedureEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().moveColumnUp(info);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                    ViewProcedureEditorPanel.this.columnsViewer.getTable().select(selectedIndex - 1);
                    ViewProcedureEditorPanel.this.downColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(info));
                    ViewProcedureEditorPanel.this.upColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(info));
                }
            }
        });
        this.downColumnButton = new Button(buttonPanel, 8);
        this.downColumnButton.setText(Messages.moveDownLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.downColumnButton);
        this.downColumnButton.setEnabled(false);
        this.downColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewProcedureEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().moveColumnDown(info);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                    ViewProcedureEditorPanel.this.columnsViewer.getTable().select(selectedIndex + 1);
                    ViewProcedureEditorPanel.this.downColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(info));
                    ViewProcedureEditorPanel.this.upColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(info));
                }
            }
        });
        this.columnsViewer = new TableViewerBuilder(thePanel, 68356);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).applyTo((Control)this.columnsViewer.getTableComposite());
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.columnNameLabel) + "          ");
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.dataTypeLabel) + "          ");
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ColumnWidthEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        if (this.getRelationalReference().getResultSet() != null) {
            for (RelationalColumn row : this.getRelationalReference().getResultSet().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        this.columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ViewProcedureEditorPanel.this.deleteColumnButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.upColumnButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.downColumnButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalColumn columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalColumn)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalColumn)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ViewProcedureEditorPanel.this.deleteColumnButton.setEnabled(enable);
                    if (enable) {
                        ViewProcedureEditorPanel.this.upColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnUp(columnInfo));
                        ViewProcedureEditorPanel.this.downColumnButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().getResultSet().canMoveColumnDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    private Composite createPropertiesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().applyTo((Control)thePanel);
        Label label = null;
        if (!this.isFunction()) {
            String str;
            label = new Label(thePanel, 0);
            label.setText(Messages.updateCountLabel);
            this.updateCountCombo = new Combo(thePanel, 12);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.updateCountCombo);
            String[] stringArray = RelationalConstants.UPDATE_COUNT.AS_ARRAY;
            int n = RelationalConstants.UPDATE_COUNT.AS_ARRAY.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                this.updateCountCombo.add(val);
                ++n2;
            }
            this.updateCountCombo.setText("AUTO");
            this.nonPreparedCB = new Button(thePanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.nonPreparedCB);
            this.nonPreparedCB.setText(Messages.nonPreparedLabel);
            this.nonPreparedCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewProcedureEditorPanel.this.getRelationalReference().setNonPrepared(ViewProcedureEditorPanel.this.nonPreparedCB.getSelection());
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            });
            Group restGroup = WidgetFactory.createGroup((Composite)thePanel, (String)Messages.restOptions, (int)4, (int)1, (int)2);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 4;
            restGroup.setLayoutData((Object)gd);
            this.applyRestWarPropertiesCB = WidgetFactory.createCheckBox((Composite)restGroup, (String)Messages.enableRestForThisProcedure);
            this.applyRestWarPropertiesCB.setEnabled(true);
            this.applyRestWarPropertiesCB.setSelection(true);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.applyRestWarPropertiesCB.setLayoutData((Object)gd);
            this.applyRestWarPropertiesCB.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean checked = ViewProcedureEditorPanel.this.applyRestWarPropertiesCB.getSelection();
                    ViewProcedureEditorPanel.this.getRelationalReference().setRestEnabled(checked);
                    ViewProcedureEditorPanel.this.restMethodsCombo.setEnabled(checked);
                    ViewProcedureEditorPanel.this.restUriText.setEnabled(checked);
                    ViewProcedureEditorPanel.this.restCharSetsCombo.setEnabled(checked);
                    ViewProcedureEditorPanel.this.restHeadersText.setEnabled(checked);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            label = new Label((Composite)restGroup, 0);
            label.setText(Messages.restMethod);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.restMethodsCombo = new Combo((Composite)restGroup, 8);
            gd = new GridData(768);
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 1;
            this.restMethodsCombo.setLayoutData((Object)gd);
            ArrayList<String> comboItems = new ArrayList<String>();
            String[] stringArray2 = RestModelExtensionConstants.METHODS_ARRAY;
            int n3 = RestModelExtensionConstants.METHODS_ARRAY.length;
            int n4 = 0;
            while (n4 < n3) {
                str = stringArray2[n4];
                comboItems.add(str);
                ++n4;
            }
            WidgetUtil.setComboItems((Combo)this.restMethodsCombo, comboItems, null, (boolean)true);
            this.restMethodsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent ev) {
                    ViewProcedureEditorPanel.this.selectMethodComboItem(ViewProcedureEditorPanel.this.restMethodsCombo.getSelectionIndex());
                }
            });
            label = new Label((Composite)restGroup, 0);
            label.setText(Messages.restUri);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.restUriText = WidgetFactory.createTextField((Composite)restGroup, (int)768);
            this.restUriText.setToolTipText(Messages.restUriTooltip);
            this.restUriText.setEditable(true);
            this.restUriText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ViewProcedureEditorPanel.this.restUriValue = ViewProcedureEditorPanel.this.restUriText.getText();
                    ViewProcedureEditorPanel.this.getRelationalReference().setRestUri(ViewProcedureEditorPanel.this.restUriValue);
                }
            });
            label = new Label((Composite)restGroup, 0);
            label.setText(Messages.restCharSet);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.restCharSetsCombo = new Combo((Composite)restGroup, 8);
            gd = new GridData(768);
            gd.verticalAlignment = 2;
            gd.horizontalSpan = 1;
            this.restCharSetsCombo.setLayoutData((Object)gd);
            comboItems = new ArrayList();
            stringArray2 = RestModelExtensionConstants.CHARSETS_ARRAY;
            n3 = RestModelExtensionConstants.CHARSETS_ARRAY.length;
            n4 = 0;
            while (n4 < n3) {
                str = stringArray2[n4];
                comboItems.add(str);
                ++n4;
            }
            WidgetUtil.setComboItems((Combo)this.restCharSetsCombo, comboItems, null, (boolean)true);
            this.restCharSetsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent ev) {
                    ViewProcedureEditorPanel.this.selectCharSetComboItem(ViewProcedureEditorPanel.this.restCharSetsCombo.getSelectionIndex());
                }
            });
            label = new Label((Composite)restGroup, 0);
            label.setText(Messages.restHeaders);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.restHeadersText = WidgetFactory.createTextField((Composite)restGroup, (int)768);
            this.restHeadersText.setToolTipText(Messages.restHeadersTooltip);
            this.restHeadersText.setEditable(true);
            this.restHeadersText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ViewProcedureEditorPanel.this.restHeadersValue = ViewProcedureEditorPanel.this.restHeadersText.getText();
                    ViewProcedureEditorPanel.this.getRelationalReference().setRestHeaders(ViewProcedureEditorPanel.this.restHeadersValue);
                }
            });
        }
        if (this.isFunction()) {
            Group functionGroup = WidgetFactory.createGroup((Composite)thePanel, (String)Messages.functionPropertiesLabel, (int)768, (int)2, (int)3);
            if (!this.getRelationalReference().isSourceFunction()) {
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.functionCategoryLabel);
                this.functionCategoryText = new Text((Composite)functionGroup, 2052);
                this.functionCategoryText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.functionCategoryText);
                this.functionCategoryText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = ViewProcedureEditorPanel.this.functionCategoryText.getText();
                        if (value == null) {
                            value = "";
                        }
                        ViewProcedureEditorPanel.this.getRelationalReference().setFunctionCategory(value);
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.javaClassLabel);
                this.javaClassText = new Text((Composite)functionGroup, 2052);
                this.javaClassText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.javaClassText);
                this.javaClassText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = ViewProcedureEditorPanel.this.javaClassText.getText();
                        if (value == null) {
                            value = "";
                        }
                        ViewProcedureEditorPanel.this.getRelationalReference().setJavaClassName(value);
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.javaMethodLabel);
                this.javaMethodText = new Text((Composite)functionGroup, 2052);
                this.javaMethodText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.javaMethodText);
                this.javaMethodText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = ViewProcedureEditorPanel.this.javaMethodText.getText();
                        if (value == null) {
                            value = "";
                        }
                        ViewProcedureEditorPanel.this.getRelationalReference().setJavaMethodName(value);
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                label = new Label((Composite)functionGroup, 0);
                label.setText(Messages.udfJarPathLabel);
                this.udfJarPathText = new Text((Composite)functionGroup, 2052);
                this.udfJarPathText.setForeground(Display.getCurrent().getSystemColor(10));
                GridDataFactory.fillDefaults().applyTo((Control)this.udfJarPathText);
                this.udfJarPathText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        String value = ViewProcedureEditorPanel.this.udfJarPathText.getText();
                        if (value == null) {
                            value = "";
                        }
                        ViewProcedureEditorPanel.this.getRelationalReference().setUdfJarPath(value);
                        if (!ViewProcedureEditorPanel.this.isSynchronizing()) {
                            ViewProcedureEditorPanel.this.handleInfoChanged();
                        }
                    }
                });
                this.udfJarPathBrowse = new Button((Composite)functionGroup, 131080);
                this.udfJarPathBrowse.setText(UILabelUtil.getLabel((int)0));
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.udfJarPathBrowse);
                this.udfJarPathBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String selectedFile = VdbFileDialogUtil.selectFile((Shell)ViewProcedureEditorPanel.this.udfJarPathBrowse.getShell(), (IProject)ViewProcedureEditorPanel.this.getModelFile().getProject(), (VdbHelper.VdbFolders)VdbHelper.VdbFolders.UDF);
                        ViewProcedureEditorPanel.this.getRelationalReference().setUdfJarPath(selectedFile);
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                Composite innerPanel = WidgetFactory.createPanel((Composite)functionGroup, (int)0, (int)768, (int)3);
                GridLayoutFactory.fillDefaults().numColumns(3).applyTo(innerPanel);
                GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)innerPanel);
                this.deterministicCB = new Button(innerPanel, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.deterministicCB);
                this.deterministicCB.setText(Messages.deterministicLabel);
                this.deterministicCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setDeterministic(ViewProcedureEditorPanel.this.deterministicCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.returnsNullCB = new Button(innerPanel, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.returnsNullCB);
                this.returnsNullCB.setText(Messages.returnsNullOnNullLabel);
                this.returnsNullCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setReturnsNullOnNull(ViewProcedureEditorPanel.this.returnsNullCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.variableArgsCB = new Button(innerPanel, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.variableArgsCB);
                this.variableArgsCB.setText(Messages.variableArgumentsLabel);
                this.variableArgsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setVariableArguments(ViewProcedureEditorPanel.this.variableArgsCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                Group aggregateGroup = WidgetFactory.createGroup((Composite)functionGroup, (String)Messages.aggregatePropertiesLabel, (int)768, (int)2, (int)3);
                this.aggregateCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.aggregateCB);
                this.aggregateCB.setText(Messages.aggregateLabel);
                this.aggregateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setAggregate(ViewProcedureEditorPanel.this.aggregateCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.allowsDistinctCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.allowsDistinctCB);
                this.allowsDistinctCB.setText(Messages.allowsDistinctLabel);
                this.allowsDistinctCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setAllowsDistinct(ViewProcedureEditorPanel.this.allowsDistinctCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.allowsOrderByCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.allowsOrderByCB);
                this.allowsOrderByCB.setText(Messages.allowsOrderByLabel);
                this.allowsOrderByCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setAllowsOrderBy(ViewProcedureEditorPanel.this.allowsOrderByCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.analyticCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.analyticCB);
                this.analyticCB.setText(Messages.analyticLabel);
                this.analyticCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setAnalytic(ViewProcedureEditorPanel.this.analyticCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.decomposableCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.decomposableCB);
                this.decomposableCB.setText(Messages.decomposableLabel);
                this.decomposableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setDecomposable(ViewProcedureEditorPanel.this.decomposableCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
                this.useDistinctRowsCB = new Button((Composite)aggregateGroup, 131104);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.useDistinctRowsCB);
                this.useDistinctRowsCB.setText(Messages.usesDistinctRowsLabel);
                this.useDistinctRowsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewProcedureEditorPanel.this.getRelationalReference().setUseDistinctRows(ViewProcedureEditorPanel.this.useDistinctRowsCB.getSelection());
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                });
            }
        }
        this.setUiState();
        return thePanel;
    }

    private Composite createParameterTableGroup(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addParameterButton = new Button(buttonPanel, 8);
        this.addParameterButton.setText(Messages.addLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.addParameterButton);
        this.addParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewProcedureEditorPanel.this.getRelationalReference().createParameter();
                ViewProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        this.deleteParameterButton = new Button(buttonPanel, 8);
        this.deleteParameterButton.setText(Messages.deleteLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteParameterButton);
        this.deleteParameterButton.setEnabled(false);
        this.deleteParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter parameter = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        parameter = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (parameter != null) {
                    ViewProcedureEditorPanel.this.getRelationalReference().removeParameter(parameter);
                    ViewProcedureEditorPanel.this.deleteParameterButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upParameterButton = new Button(buttonPanel, 8);
        this.upParameterButton.setText(Messages.moveUpLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.upParameterButton);
        this.upParameterButton.setEnabled(false);
        this.upParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        info = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewProcedureEditorPanel.this.parametersViewer.getTable().getSelectionIndex();
                    ViewProcedureEditorPanel.this.getRelationalReference().moveParameterUp(info);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                    ViewProcedureEditorPanel.this.parametersViewer.getTable().select(selectedIndex - 1);
                    ViewProcedureEditorPanel.this.downParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(info));
                    ViewProcedureEditorPanel.this.upParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(info));
                }
            }
        });
        this.downParameterButton = new Button(buttonPanel, 8);
        this.downParameterButton.setText(Messages.moveDownLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.downParameterButton);
        this.downParameterButton.setEnabled(false);
        this.downParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalParameter info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewProcedureEditorPanel.this.parametersViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalParameter) {
                        info = (RelationalParameter)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewProcedureEditorPanel.this.parametersViewer.getTable().getSelectionIndex();
                    ViewProcedureEditorPanel.this.getRelationalReference().moveParameterDown(info);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                    ViewProcedureEditorPanel.this.parametersViewer.getTable().select(selectedIndex + 1);
                    ViewProcedureEditorPanel.this.downParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(info));
                    ViewProcedureEditorPanel.this.upParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(info));
                }
            }
        });
        this.parametersViewer = new TableViewerBuilder(thePanel, 68356);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)this.parametersViewer.getTableComposite());
        TableViewerColumn column = this.parametersViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.parameterNameLabel) + "        ");
        column.setEditingSupport((EditingSupport)new ParameterNameEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(0));
        column = this.parametersViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(String.valueOf(Messages.dataTypeLabel) + "          ");
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column = this.parametersViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ParameterWidthEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        column = this.parametersViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(Messages.directionLabel);
        column.setLabelProvider((CellLabelProvider)new ParameterDataLabelProvider(3));
        column.setEditingSupport((EditingSupport)new DirectionEditingSupport((ColumnViewer)this.parametersViewer.getTableViewer()));
        if (this.getRelationalReference() != null) {
            for (RelationalParameter row : this.getRelationalReference().getParameters()) {
                this.parametersViewer.add((Object)row);
            }
        }
        this.parametersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ViewProcedureEditorPanel.this.deleteParameterButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.upParameterButton.setEnabled(false);
                    ViewProcedureEditorPanel.this.downParameterButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalParameter columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalParameter)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalParameter)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ViewProcedureEditorPanel.this.deleteParameterButton.setEnabled(enable);
                    if (enable) {
                        ViewProcedureEditorPanel.this.upParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterUp(columnInfo));
                        ViewProcedureEditorPanel.this.downParameterButton.setEnabled(ViewProcedureEditorPanel.this.getRelationalReference().canMoveParameterDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    private Composite createSQLPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Button templateButton = new Button(thePanel, 16384);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)templateButton);
        templateButton.setText(Messages.selectSQLTemplateLabel);
        templateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLTemplateDialog templateDialog = new SQLTemplateDialog(UiUtil.getWorkbenchShellOnlyIfUiThread(), SQLTemplateDialog.PROC_TEMPLATES);
                if (templateDialog.open() == 0) {
                    String originalSql = ViewProcedureEditorPanel.this.sqlDocument.get();
                    boolean okToInsertOrReplace = true;
                    if (templateDialog.getInsertOption() == 0 && originalSql != null && originalSql.trim().length() > 0) {
                        okToInsertOrReplace = MessageDialog.openConfirm((Shell)templateDialog.getShell(), (String)Messages.confirmSqlReplaceDialogTitle, (String)Messages.confirmSqlReplaceDialogMessage_2);
                    }
                    if (okToInsertOrReplace) {
                        int caretOffset = ViewProcedureEditorPanel.this.sqlTextViewer.getTextWidget().getCaretOffset();
                        String newSql = SqlStringUtil.insertSql((String)originalSql, (String)templateDialog.getSQL(), (int)templateDialog.getInsertOption(), (int)caretOffset);
                        ViewProcedureEditorPanel.this.getRelationalReference().setTransformationSQL(newSql);
                        ViewProcedureEditorPanel.this.sqlDocument.set(newSql);
                        ViewProcedureEditorPanel.this.handleInfoChanged();
                    }
                }
            }
        });
        this.createSqlGroup(thePanel);
        return thePanel;
    }

    private void createSqlGroup(Composite parent) {
        Group textTableOptionsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.sqlDefinitionLabel);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)textTableOptionsGroup);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)textTableOptionsGroup, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput(this.sqlDocument);
        this.sqlTextViewer.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewProcedureEditorPanel.this.getRelationalReference().setTransformationSQL(ViewProcedureEditorPanel.this.sqlTextViewer.getTextWidget().getText());
                ViewProcedureEditorPanel.this.handleInfoChanged();
            }
        });
        this.sqlTextViewer.setEditable(true);
        this.sqlDocument.set("");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.sqlTextViewer.getControl());
    }

    private void selectMethodComboItem(int selectionIndex) {
        if (selectionIndex >= 0) {
            this.restMethodsCombo.select(selectionIndex);
            this.restMethodValue = this.restMethodsCombo.getItem(selectionIndex);
            this.getRelationalReference().setRestMethod(this.restMethodValue);
        }
    }

    private void selectCharSetComboItem(int selectionIndex) {
        if (selectionIndex >= 0) {
            this.restCharSetsCombo.select(selectionIndex);
            this.restCharSetValue = this.restCharSetsCombo.getItem(selectionIndex);
            this.getRelationalReference().setRestCharSet(this.restCharSetValue);
        }
    }

    private void setUiState() {
        if (!this.isFunction()) {
            if (this.addColumnButton != null && this.includeResultSetCB != null) {
                boolean enable = this.includeResultSetCB.getSelection();
                this.addColumnButton.setEnabled(enable);
                if (!enable) {
                    this.deleteColumnButton.setEnabled(false);
                    this.downColumnButton.setEnabled(false);
                    this.upColumnButton.setEnabled(false);
                }
            }
            boolean restEnabled = this.getRelationalReference().isRestEnabled();
            this.applyRestWarPropertiesCB.setSelection(restEnabled);
            this.restMethodsCombo.setEnabled(restEnabled);
            this.restUriText.setEnabled(restEnabled);
            this.restCharSetsCombo.setEnabled(restEnabled);
            this.restHeadersText.setEnabled(restEnabled);
            return;
        }
        if (this.isFunction()) {
            boolean functionState = true;
            this.deterministicCB.setEnabled(functionState);
            this.returnsNullCB.setEnabled(functionState);
            this.variableArgsCB.setEnabled(functionState);
            this.aggregateCB.setEnabled(functionState);
            boolean aggregateState = functionState;
            if (aggregateState) {
                aggregateState = this.aggregateCB.getSelection();
            }
            this.allowsDistinctCB.setEnabled(aggregateState);
            this.allowsOrderByCB.setEnabled(aggregateState);
            this.analyticCB.setEnabled(aggregateState);
            this.decomposableCB.setEnabled(aggregateState);
            this.useDistinctRowsCB.setEnabled(aggregateState);
        }
    }

    protected void handleInfoChanged() {
        super.handleInfoChanged();
        this.setUiState();
    }

    protected void validate() {
        this.getRelationalReference().validate();
        this.setCanFinish(this.getRelationalReference().nameIsValid());
        IStatus currentStatus = this.getRelationalReference().getStatus();
        if (currentStatus.isOK()) {
            this.setStatus(Status.OK_STATUS);
        } else {
            this.setStatus(currentStatus);
        }
        this.validationPerformed = true;
    }

    public boolean canFinish() {
        if (!this.validationPerformed && this.getRelationalReference().getName() != null) {
            return true;
        }
        return super.canFinish();
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return RelationalUiUtil.getRelationalImage((int)7, (int)ModelType.VIRTUAL, (IStatus)Status.OK_STATUS);
            }
            return null;
        }
    }

    class ColumnNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                String oldValue = ((RelationalColumn)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalColumn)element).setName(newValue);
                    ViewProcedureEditorPanel.this.columnsViewer.refresh(element);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ColumnWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return Integer.toString(((RelationalColumn)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                int oldValue;
                int newValue = oldValue = ((RelationalColumn)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalColumn)element).setLength(newValue);
                    ViewProcedureEditorPanel.this.columnsViewer.refresh(element);
                }
            }
        }
    }

    class DatatypeEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            Collection unsortedTypes = new ArrayList();
            try {
                unsortedTypes = DatatypeUtilities.getAllDesignTimeTypeNames();
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedTypes.toArray(new String[unsortedTypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            if (element instanceof RelationalParameter) {
                return ((RelationalParameter)element).getDatatype();
            }
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getDatatype();
            }
            return "";
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            if (element instanceof RelationalParameter) {
                ((RelationalParameter)element).setDatatype(newValue);
            } else if (element instanceof RelationalColumn) {
                ((RelationalColumn)element).setDatatype(newValue);
            }
            ViewProcedureEditorPanel.this.handleInfoChanged();
        }
    }

    class DirectionEditingSupport
    extends ComboBoxEditingSupport {
        public DirectionEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected String getElementValue(Object element) {
            return ((RelationalParameter)element).getDirection();
        }

        protected String[] refreshItems(Object element) {
            return RelationalConstants.DIRECTION.AS_ARRAY;
        }

        protected void setElementValue(Object element, String newValue) {
            ((RelationalParameter)element).setDirection(newValue);
            ViewProcedureEditorPanel.this.handleInfoChanged();
        }
    }

    class ParameterDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ParameterDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalParameter) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalParameter)element).getName();
                    }
                    case 1: {
                        return ((RelationalParameter)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalParameter)element).getLength());
                    }
                    case 3: {
                        return ((RelationalParameter)element).getDirection();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return RelationalUiUtil.getRelationalImage((int)6, (int)ModelType.VIRTUAL, (IStatus)Status.OK_STATUS);
            }
            return null;
        }
    }

    class ParameterNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ParameterNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalParameter) {
                return ((RelationalParameter)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalParameter) {
                String oldValue = ((RelationalParameter)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalParameter)element).setName(newValue);
                    ViewProcedureEditorPanel.this.parametersViewer.refresh(element);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ParameterWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ParameterWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalParameter) {
                return Integer.toString(((RelationalParameter)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalParameter) {
                int oldValue;
                int newValue = oldValue = ((RelationalParameter)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalParameter)element).setLength(newValue);
                    ViewProcedureEditorPanel.this.parametersViewer.refresh(element);
                    ViewProcedureEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }
}

