/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.edit.RelationalIndexEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.transformation.model.RelationalViewIndex;
import org.teiid.designer.transformation.model.RelationalViewProcedure;
import org.teiid.designer.transformation.model.RelationalViewTable;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.ViewProcedureEditorPanel;
import org.teiid.designer.transformation.ui.editors.ViewTableEditorPanel;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;

public class TransformationDialogModel
extends EditRelationalObjectDialogModel {
    public TransformationDialogModel(RelationalReference relationalObject, IFile modelFile) {
        super(relationalObject, modelFile);
    }

    public RelationalEditorPanel getEditorPanel(IDialogStatusListener statusListener, Composite parent) {
        if (this.relationalObject instanceof RelationalViewTable) {
            return new ViewTableEditorPanel(parent, this, statusListener);
        }
        if (this.relationalObject instanceof RelationalViewProcedure) {
            return new ViewProcedureEditorPanel(parent, this, statusListener);
        }
        if (this.relationalObject instanceof RelationalViewIndex) {
            return new RelationalIndexEditorPanel(parent, (EditRelationalObjectDialogModel)this, statusListener);
        }
        return null;
    }

    public String getDialogTitle() {
        if (this.relationalObject instanceof RelationalViewTable) {
            return Messages.createRelationalViewTableTitle;
        }
        if (this.relationalObject instanceof RelationalViewProcedure) {
            if (((RelationalProcedure)this.relationalObject).isFunction()) {
                return Messages.createRelationalViewUserDefinedFunctionTitle;
            }
            return Messages.createRelationalViewProcedureTitle;
        }
        if (this.relationalObject instanceof RelationalViewIndex) {
            return Messages.createRelationalViewIndexTitle;
        }
        return NLS.bind((String)Messages.unsupportedObjectType, (Object)this.relationalObject.getClass().toString());
    }

    public String getHelpText() {
        if (this.relationalObject instanceof RelationalViewTable) {
            return Messages.createRelationalViewTableHelpText;
        }
        if (this.relationalObject instanceof RelationalViewProcedure) {
            if (((RelationalProcedure)this.relationalObject).isFunction()) {
                return Messages.createRelationalViewUserDefinedFunctionHelpText;
            }
            return Messages.createRelationalViewProcedureHelpText;
        }
        if (this.relationalObject instanceof RelationalViewIndex) {
            return Messages.createRelationalViewIndexHelpText;
        }
        return NLS.bind((String)Messages.unsupportedObjectType, (Object)this.relationalObject.getClass().toString());
    }
}

