/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.SelectFromEObjectListDialog;
import org.teiid.designer.ui.viewsupport.SelectModelObjectLabelProvider;

public class EditTransformationHelper {
    private static final String DIALOG_TITLE = UiConstants.Util.getString("EditTransformationHelper.dialogTitle", new Object[0]);
    private static final String STAGING_TABLE_STR = "<Staging Table>";
    private static final String MAPPING_CLASS_STR = "<Mapping Class>";
    private static final String TABLE_STR = "<Table>";
    private static final String PROCEDURE_STR = "<Procedure>";
    private ModelResource modelResource;

    public EditTransformationHelper(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public void setModelResource(ModelResource theModelResource) {
        this.modelResource = theModelResource;
    }

    public void openAndEdit(EObject eObj) {
        ModelEditorManager.edit((EObject)eObj, (String)"org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage");
    }

    public Collection getAllTransformationTargets() throws ModelWorkspaceException {
        return this.getAllTransformationTargets(this.modelResource);
    }

    public Collection getAllTransformationTargets(ModelResource theModelResource) throws ModelWorkspaceException {
        List transformations = theModelResource.getModelTransformations().getTransformations();
        int nTransforms = transformations.size();
        ArrayList<EObject> allTargets = new ArrayList<EObject>(nTransforms);
        for (Object obj : transformations) {
            EObject table;
            if (!(obj instanceof SqlTransformationMappingRoot) || (table = ((SqlTransformationMappingRoot)obj).getTarget()) == null) continue;
            allTargets.add(table);
        }
        return allTargets;
    }

    public EObject queryUserToSelectTarget(ModelResource modelResource) {
        EObject selectedTarget = null;
        try {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            String message = UiConstants.Util.getString("EditTransformationHelper.dialogMessage", (Object)modelResource.getItemName());
            SelectFromEObjectListDialog dialog = new SelectFromEObjectListDialog(shell, this.getAllTransformationTargets(modelResource), false, DIALOG_TITLE, message, (LabelProvider)new MyLabelProvider());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Object[] results = dialog.getResult();
                selectedTarget = (EObject)results[0];
            }
        }
        catch (ModelWorkspaceException theException) {
            UiConstants.Util.log(4, theException.getMessage());
        }
        return selectedTarget;
    }

    public EObject queryUserToSelectTarget() {
        return this.queryUserToSelectTarget(this.modelResource);
    }

    class MyLabelProvider
    extends SelectModelObjectLabelProvider {
        public String getText(Object theElement) {
            if (theElement instanceof EObject) {
                EObject eo = (EObject)theElement;
                String sText = ModelerCore.getModelEditor().getName(eo);
                if (this.showPath) {
                    String path;
                    String type = this.getType(eo);
                    if (type != null) {
                        sText = String.valueOf(sText) + CoreStringUtil.Constants.SPACE + type + CoreStringUtil.Constants.SPACE;
                    }
                    if ((path = this.getAppendedPath(eo)) != null) {
                        sText = String.valueOf(sText) + " : " + this.getAppendedPath(eo);
                    }
                }
                return sText;
            }
            return super.getText(theElement);
        }

        private String getType(EObject eObj) {
            if (TransformationHelper.isStagingTable((Object)eObj)) {
                return EditTransformationHelper.STAGING_TABLE_STR;
            }
            if (TransformationHelper.isMappingClass((Object)eObj)) {
                return EditTransformationHelper.MAPPING_CLASS_STR;
            }
            if (SqlAspectHelper.isProcedure((EObject)eObj)) {
                return EditTransformationHelper.PROCEDURE_STR;
            }
            if (SqlAspectHelper.isTable((EObject)eObj)) {
                return EditTransformationHelper.TABLE_STR;
            }
            return null;
        }

        private String getAppendedPath(EObject eObj) {
            if (TransformationHelper.isMappingClass((Object)eObj)) {
                MappingClass mc = (MappingClass)eObj;
                EObject doc = mc.getMappingClassSet().getTarget();
                IPath pathToDoc = ModelerCore.getModelEditor().getFullPathToParent(doc);
                pathToDoc = pathToDoc.append(ModelerCore.getModelEditor().getName(doc));
                return pathToDoc.toString();
            }
            return ModelerCore.getModelEditor().getFullPathToParent(eObj).toString();
        }
    }
}

