/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.CreateViewProcedureAction;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;
import org.teiid.designer.ui.wizards.NewModelWizard;
import org.teiid.designer.ui.wizards.NewModelWizardInput;

public class DefineViewProcedureDialog
extends TitleAreaDialog
implements IChangeListener,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefineViewProcedureDialog.class);
    private EObject viewProcedure;
    private IResource selectedModel;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button newViewModelButton;
    private Button browseModelsButton;
    private Text selectedViewModelText;
    private Button newViewProcedureButton;
    private Button browseButton;
    private Text selectedViewProcedureText;
    private Button applyRestWarPropertiesCB;
    private boolean doApplyRestWarProperties;
    private String restMethodValue = "GET";
    private Combo restMethodsCombo;
    private String restUriValue;
    private Text restUriText;
    DesignerProperties designerProperties;

    private static String getString(String key) {
        return Util.getString(String.valueOf(PREFIX) + key, new Object[0]);
    }

    public DefineViewProcedureDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DefineViewProcedureDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = (DesignerProperties)properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DefineViewProcedureDialog.getString("title"));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(DefineViewProcedureDialog.getString("subTitle"));
        this.setMessage(DefineViewProcedureDialog.getString("initialMessage"));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)DefineViewProcedureDialog.getString("viewModelName"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedViewModelText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedViewModelText.setToolTipText(DefineViewProcedureDialog.getString("viewModelNameTooltip"));
        this.selectedViewModelText.setEditable(false);
        this.selectedViewModelText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedViewModelText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newViewModelButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewProcedureDialog.getString("newViewModelButton"));
        this.newViewModelButton.setToolTipText(DefineViewProcedureDialog.getString("newViewModelButtonTooltip"));
        this.newViewModelButton.setEnabled(true);
        this.newViewModelButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newViewModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewProcedureDialog.this.handleNewViewModelPressed();
            }
        });
        this.browseModelsButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewProcedureDialog.getString("browseModelsButton"));
        this.browseModelsButton.setToolTipText(DefineViewProcedureDialog.getString("browseModelsButtonTooltip"));
        this.browseModelsButton.setEnabled(true);
        this.browseModelsButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewProcedureDialog.this.handleBrowseWorkspaceForModelPressed();
            }
        });
        label = WidgetFactory.createLabel((Composite)panel, (String)DefineViewProcedureDialog.getString("viewProcedureName"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedViewProcedureText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedViewProcedureText.setToolTipText(DefineViewProcedureDialog.getString("viewProcedureNameTooltip"));
        this.selectedViewProcedureText.setEditable(false);
        this.selectedViewProcedureText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedViewProcedureText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newViewProcedureButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewProcedureDialog.getString("newButton"));
        this.newViewProcedureButton.setToolTipText(DefineViewProcedureDialog.getString("newButtonTooltip"));
        this.newViewProcedureButton.setEnabled(true);
        this.newViewProcedureButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newViewProcedureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewProcedureDialog.this.handleNewViewProcedurePressed();
            }
        });
        this.browseButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewProcedureDialog.getString("browseButton"));
        this.browseButton.setToolTipText(DefineViewProcedureDialog.getString("browseButtonTooltip"));
        this.browseButton.setEnabled(true);
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewProcedureDialog.this.handleBrowseWorkspaceForObjectPressed();
            }
        });
        Group restGroup = WidgetFactory.createGroup((Composite)panel, (String)DefineViewProcedureDialog.getString("restOptions"), (int)4, (int)1, (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        restGroup.setLayoutData((Object)gd);
        this.applyRestWarPropertiesCB = WidgetFactory.createCheckBox((Composite)restGroup, (String)DefineViewProcedureDialog.getString("enableRestForThisProcedure"));
        this.applyRestWarPropertiesCB.setEnabled(true);
        this.applyRestWarPropertiesCB.setSelection(true);
        this.doApplyRestWarProperties = true;
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.applyRestWarPropertiesCB.setLayoutData((Object)gd);
        this.applyRestWarPropertiesCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = DefineViewProcedureDialog.this.applyRestWarPropertiesCB.getSelection();
                DefineViewProcedureDialog.this.restMethodsCombo.setEnabled(checked);
                DefineViewProcedureDialog.this.restUriText.setEnabled(checked);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label2 = WidgetFactory.createLabel((Composite)restGroup, (String)DefineViewProcedureDialog.getString("restMethod"));
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.restMethodsCombo = new Combo((Composite)restGroup, 8);
        gd = new GridData(768);
        gd.verticalAlignment = 2;
        gd.horizontalSpan = 1;
        this.restMethodsCombo.setLayoutData((Object)gd);
        ArrayList<String> comboItems = new ArrayList<String>();
        String[] stringArray = RestModelExtensionConstants.METHODS_ARRAY;
        int n = RestModelExtensionConstants.METHODS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            comboItems.add(str);
            ++n2;
        }
        WidgetUtil.setComboItems((Combo)this.restMethodsCombo, comboItems, null, (boolean)true);
        this.restMethodsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                DefineViewProcedureDialog.this.selectComboItem(DefineViewProcedureDialog.this.restMethodsCombo.getSelectionIndex());
            }
        });
        label2 = WidgetFactory.createLabel((Composite)restGroup, (String)DefineViewProcedureDialog.getString("uri"));
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.restUriText = WidgetFactory.createTextField((Composite)restGroup, (int)768);
        this.restUriText.setToolTipText(DefineViewProcedureDialog.getString("restUriTooltip"));
        this.restUriText.setEditable(true);
        this.restUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefineViewProcedureDialog.this.restUriValue = DefineViewProcedureDialog.this.restUriText.getText();
            }
        });
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            EObject lastModelObject;
            this.selectedModel = this.designerProperties.getViewModel();
            if (this.selectedModel != null) {
                this.selectedViewModelText.setText(this.selectedModel.getName());
            }
            if ((lastModelObject = this.designerProperties.getLastViewModelObject()) != null && lastModelObject instanceof Procedure) {
                this.viewProcedure = lastModelObject;
                this.selectedViewProcedureText.setText(this.designerProperties.getLastViewModelObjectName());
            }
            this.updateState();
        }
        return control;
    }

    public EObject getViewProcedure() {
        return this.viewProcedure;
    }

    public boolean doApplyRestWarProperties() {
        return this.doApplyRestWarProperties;
    }

    public String getRestMethod() {
        return this.restMethodValue;
    }

    public String getRestUri() {
        return this.restUriValue;
    }

    protected void okPressed() {
        this.doApplyRestWarProperties = this.applyRestWarPropertiesCB.getSelection();
        if (this.doApplyRestWarProperties()) {
            RestModelExtensionAssistant.setRestProperties((EObject)this.getViewProcedure(), (String)this.getRestMethod(), (String)this.getRestUri(), null, null);
        }
        super.okPressed();
    }

    private void selectComboItem(int selectionIndex) {
        if (selectionIndex >= 0) {
            this.restMethodsCombo.select(selectionIndex);
            this.restMethodValue = this.restMethodsCombo.getItem(selectionIndex);
        }
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(DefineViewProcedureDialog.getString("okMsg"));
        }
    }

    private void handleNewViewProcedurePressed() {
        try {
            IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)this.selectedModel));
        }
        catch (PartInitException partInitException) {}
        CreateViewProcedureAction action = new CreateViewProcedureAction((Properties)this.designerProperties);
        action.run();
        this.viewProcedure = action.getNewViewProcedure();
        if (this.viewProcedure != null) {
            String name = ModelerCore.getModelEditor().getName(this.viewProcedure);
            this.selectedViewProcedureText.setText(name);
            this.designerProperties.setLastViewModelObjectName(name);
        }
    }

    private void handleBrowseWorkspaceForObjectPressed() {
        ModelWorkspaceDialog sdDialog = this.createViewProcedureSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter((Properties)this.designerProperties));
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.viewProcedure = (EObject)selections[0];
            String name = ModelerCore.getModelEditor().getName(this.viewProcedure);
            this.selectedViewProcedureText.setText(name);
            this.designerProperties.setLastViewModelObjectName(name);
            this.designerProperties.setPreviewTargetObjectName(name);
            try {
                ModelResource mr = ModelUtilities.getModelResource((Object)this.viewProcedure);
                this.selectedModel = mr.getUnderlyingResource();
                this.designerProperties.setViewModelName(this.selectedModel.getName());
                this.selectedViewModelText.setText(this.selectedModel.getName());
                this.designerProperties.setPreviewTargetModelName(this.selectedModel.getName());
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
            this.updateState();
        }
    }

    private void handleNewViewModelPressed() {
        NewModelWizardInput newModelInput = new NewModelWizardInput("Relational", ModelType.VIRTUAL_LITERAL, null);
        boolean projectDefined = false;
        IWorkbenchWindow iww = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean successful = false;
        try {
            try {
                WizardDialog dialog;
                int result;
                NewModelWizard wizard = new NewModelWizard(newModelInput, (Properties)this.designerProperties);
                IContainer container = this.designerProperties.getViewsFolder();
                if (container == null) {
                    projectDefined = true;
                    container = this.designerProperties.getProject();
                }
                if (container != null) {
                    wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)container));
                }
                if ((result = (dialog = new WizardDialog(iww.getShell(), (IWizard)wizard)).open()) == 0) {
                    successful = true;
                }
            }
            catch (Exception e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                MessageDialog.openError((Shell)iww.getShell(), (String)DefineViewProcedureDialog.getString("modelCreationError.title"), (String)DefineViewProcedureDialog.getString("modelCreationError.message"));
                if (successful) {
                    if (this.selectedModel == null || this.designerProperties.isViewModelDifferent((IFile)this.selectedModel)) {
                        this.selectedModel = this.designerProperties.getViewModel();
                        if (this.selectedModel != null) {
                            this.selectedViewModelText.setText(this.selectedModel.getName());
                        }
                    }
                    if (!projectDefined) {
                        this.designerProperties.setProjectName(this.selectedModel.getProject().getName());
                    }
                }
            }
        }
        finally {
            if (successful) {
                if (this.selectedModel == null || this.designerProperties.isViewModelDifferent((IFile)this.selectedModel)) {
                    this.selectedModel = this.designerProperties.getViewModel();
                    if (this.selectedModel != null) {
                        this.selectedViewModelText.setText(this.selectedModel.getName());
                    }
                }
                if (!projectDefined) {
                    this.designerProperties.setProjectName(this.selectedModel.getProject().getName());
                }
            }
        }
    }

    private void handleBrowseWorkspaceForModelPressed() {
        ModelWorkspaceDialog sdDialog = this.createViewModelSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter((Properties)this.designerProperties));
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.selectedModel = (IResource)selections[0];
            this.designerProperties.setViewModelName(this.selectedModel.getName());
            this.selectedViewModelText.setText(this.selectedModel.getName());
            this.updateState();
        }
    }

    public ModelWorkspaceDialog createViewProcedureSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = DefineViewProcedureDialog.getString("selectionDialog.title");
        String message = DefineViewProcedureDialog.getString("selectionDialog.message");
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                ModelResource mr;
                EObject eObj;
                boolean ok = false;
                if (selection != null && selection.length == 1 && selection[0] instanceof EObject && (eObj = (EObject)selection[0]) instanceof Procedure && (mr = ModelUtilities.getModelResource((Object)eObj)) != null) {
                    ok = ModelIdentifier.isVirtualModelType((ModelResource)mr);
                }
                if (!ok) {
                    String msg = DefineViewProcedureDialog.getString("selectionDialog.invalidSelection");
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.transformation.ui");
            }
        });
        return result;
    }

    public ModelWorkspaceDialog createViewModelSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = DefineViewProcedureDialog.getString("viewModel.selectionDialog.title");
        String message = DefineViewProcedureDialog.getString("viewModel.selectionDialog.message");
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IResource res;
                ModelResource mr;
                boolean ok = false;
                if (selection != null && selection.length == 1 && selection[0] instanceof IResource && (mr = ModelUtilities.getModelResource((Object)(res = (IResource)selection[0]))) != null) {
                    ok = ModelIdentifier.isVirtualModelType((ModelResource)mr);
                }
                if (!ok) {
                    String msg = DefineViewProcedureDialog.getString("viewModel.selectionDialog.invalidSelection");
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.transformation.ui");
            }
        });
        return result;
    }
}

