/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.criteria;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.designer.transformation.ui.builder.criteria.AbstractPredicateCriteriaTypeEditor;
import org.teiid.designer.transformation.ui.builder.criteria.CriteriaExpressionEditor;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.model.MatchCriteriaEditorModel;

public class MatchCriteriaEditor
extends AbstractPredicateCriteriaTypeEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(MatchCriteriaEditor.class);
    private static final int ESC_CHAR_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.01);
    private IMatchCriteria matchCriteria;
    private CriteriaExpressionEditor leftEditor;
    private CriteriaExpressionEditor rightEditor;
    private Composite rightComponent;
    private Control leftComponent;
    private ViewController viewController;
    MatchCriteriaEditorModel theModel;
    private Text escCharText;

    public MatchCriteriaEditor(Composite parent, MatchCriteriaEditorModel model) {
        super(parent, IMatchCriteria.class, (AbstractPredicateCriteriaTypeEditorModel)model);
        this.theModel = model;
        this.viewController = new ViewController();
        model.addModelListener((ILanguageObjectEditorModelListener)this.viewController);
        this.viewController.initialize();
    }

    @Override
    public String getToolTipText() {
        String tip = Util.getString(String.valueOf(PREFIX) + "toolTipText", new Object[0]);
        return tip;
    }

    @Override
    public String getTitle() {
        String title = Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
        return title;
    }

    @Override
    public Control createLeftComponent(Composite parent) {
        this.leftEditor = new CriteriaExpressionEditor(parent, this.theModel.getLeftExpressionModel());
        this.leftComponent = this.leftEditor.getUi();
        return this.leftComponent;
    }

    @Override
    public Control createRightComponent(Composite parent) {
        this.rightComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.rightComponent.setLayout((Layout)layout);
        this.rightEditor = new CriteriaExpressionEditor(this.rightComponent, this.theModel.getRightExpressionModel());
        GridData rightEditorGridData = new GridData(1808);
        this.rightEditor.getUi().setLayoutData((Object)rightEditorGridData);
        Composite escCharPanel = new Composite(this.rightComponent, 0);
        GridLayout escLayout = new GridLayout();
        escCharPanel.setLayout((Layout)escLayout);
        escLayout.numColumns = 2;
        Label escCharLabel = new Label(escCharPanel, 0);
        escCharLabel.setText(Util.getString(String.valueOf(PREFIX) + "escapeCharacter", new Object[0]));
        this.escCharText = new Text(escCharPanel, 2052);
        String escCharToolTipText = Util.getString(String.valueOf(PREFIX) + "escCharToolTipText", new Object[0]);
        this.escCharText.setToolTipText(escCharToolTipText);
        this.escCharText.setTextLimit(1);
        this.escCharText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                MatchCriteriaEditor.this.escapeCharacterModified();
            }
        });
        GridData escCharGridData = new GridData();
        escCharGridData.widthHint = ESC_CHAR_TEXT_WIDTH;
        this.escCharText.setLayoutData((Object)escCharGridData);
        return this.rightComponent;
    }

    @Override
    public IExpression getLeftExpression() {
        IExpression leftExpression = null;
        if (this.matchCriteria != null) {
            leftExpression = this.matchCriteria.getLeftExpression();
        }
        return leftExpression;
    }

    @Override
    public IExpression getRightExpression() {
        IExpression rightExpression = null;
        if (this.matchCriteria != null) {
            rightExpression = this.matchCriteria.getRightExpression();
        }
        return rightExpression;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        CoreArgCheck.isInstanceOf(IMatchCriteria.class, (Object)obj);
        this.matchCriteria = (IMatchCriteria)obj;
        if (this.leftEditor != null) {
            this.leftEditor.setLanguageObject((ILanguageObject)this.getLeftExpression());
        }
        if (this.rightEditor != null) {
            this.rightEditor.setLanguageObject((ILanguageObject)this.getRightExpression());
        }
    }

    @Override
    public String[] getOperators() {
        return this.theModel.getOperators();
    }

    @Override
    public void acceptFocus() {
        this.leftEditor.acceptFocus();
    }

    @Override
    public void setOperator(String op) {
        this.theModel.setCurrentOperator(op);
    }

    @Override
    public String getCurrentOperator() {
        return this.theModel.getCurrentOperator();
    }

    void escapeCharacterModified() {
        String textStr = this.escCharText.getText();
        if (textStr != null && textStr.length() > 0) {
            char newChar = this.escCharText.getText().charAt(0);
            this.theModel.setEscapeChar(newChar);
        } else {
            this.theModel.setEscapeChar('\u0000');
        }
    }

    void displayEscapeChar() {
        char newChar = this.theModel.getEscapeChar();
        String textStr = this.escCharText.getText();
        char oldChar = textStr != null && textStr.length() > 0 ? this.escCharText.getText().charAt(0) : (char)'\u0000';
        if (oldChar != newChar) {
            if (newChar != '\u0000') {
                this.escCharText.setText(new String(new char[]{newChar}));
            } else {
                this.escCharText.setText("");
            }
        }
    }

    void displayLeftExpression() {
    }

    void displayRightExpression() {
    }

    void displayLanguageObjectChange() {
        this.displayLeftExpression();
        this.displayRightExpression();
        this.displayEscapeChar();
    }

    private class ViewController
    implements ILanguageObjectEditorModelListener {
        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).MatchCriteriaEditor.this.theModel, "SAVED"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("MATCH CRITERIA LEFT EXPRESSION")) {
                MatchCriteriaEditor.this.displayLeftExpression();
            } else if (type.equals("MATCH CRITERIA RIGHT EXPRESSION")) {
                MatchCriteriaEditor.this.displayRightExpression();
            } else if (type.equals("MATCH CRITERIA ESCAPE CHAR")) {
                MatchCriteriaEditor.this.displayEscapeChar();
            } else if (type.equals("SAVED")) {
                MatchCriteriaEditor.this.displayLanguageObjectChange();
            }
        }
    }
}

