/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;

public abstract class AbstractLanguageObjectEditor
implements ILanguageObjectEditor,
UiConstants {
    private static final String PREFIX = "AbstractLanguageObjectEditor.";
    private Class editorType;
    private ILanguageObjectEditorModel model;
    private Composite pnlUi;

    protected AbstractLanguageObjectEditor(Composite theParent, Class theEditorType, ILanguageObjectEditorModel theModel) {
        CoreArgCheck.isNotNull((Object)theParent);
        CoreArgCheck.isNotNull((Object)theEditorType);
        CoreArgCheck.isNotNull((Object)theModel);
        this.setEditorType(theEditorType);
        this.setModel(theModel);
        this.pnlUi = new Composite(theParent, 0);
        this.pnlUi.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.pnlUi.setLayout((Layout)layout);
        this.createUi(this.pnlUi);
    }

    @Override
    public abstract void acceptFocus();

    public boolean addModelListener(ILanguageObjectEditorModelListener theListener) {
        return this.model.addModelListener(theListener);
    }

    @Override
    public void clear() {
        this.model.clear();
    }

    protected abstract void createUi(Composite var1);

    @Override
    public Class getEditorType() {
        return this.editorType;
    }

    @Override
    public ILanguageObject getLanguageObject() {
        return this.model.getLanguageObject();
    }

    @Override
    public ILanguageObjectEditorModel getModel() {
        return this.model;
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract String getToolTipText();

    @Override
    public final Control getUi() {
        return this.pnlUi;
    }

    @Override
    public boolean hasChanged() {
        return this.model.hasChanged();
    }

    @Override
    public boolean isComplete() {
        return this.model.isComplete();
    }

    @Override
    public boolean isEnabled() {
        return this.pnlUi.isEnabled();
    }

    public boolean removeModelListener(ILanguageObjectEditorModelListener theListener) {
        return this.model.removeModelListener(theListener);
    }

    @Override
    public void reset() {
        this.model.reset();
    }

    @Override
    public void save() {
        this.model.save();
    }

    @Override
    public void setEditorType(Class theEditorType) {
        CoreArgCheck.isNotNull((Object)theEditorType, (String)Util.getString("AbstractLanguageObjectEditor.nullEditorType", new Object[0]));
        if (!ILanguageObject.class.isAssignableFrom(theEditorType)) {
            CoreArgCheck.isTrue((boolean)ILanguageObject.class.isAssignableFrom(theEditorType), (String)Util.getString("AbstractLanguageObjectEditor.editorTypeNotLangObj", new Object[0]));
        }
        this.editorType = theEditorType;
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        if (theEnableFlag) {
            WidgetUtil.enable((Composite)this.pnlUi);
        } else {
            WidgetUtil.disable((Composite)this.pnlUi);
        }
    }

    @Override
    public void setModel(ILanguageObjectEditorModel theModel) {
        CoreArgCheck.isNotNull((Object)theModel);
        CoreArgCheck.isEqual((Object)this.editorType, (Object)theModel.getModelType());
        this.model = theModel;
    }

    @Override
    public abstract void setLanguageObject(ILanguageObject var1);
}

