/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class ValidateModelTransformationsHandler
extends AbstractHandler {
    private void clearUUIDSqlString(SqlTransformationMappingRoot mappingRoot) {
        MappingHelper helper;
        if (mappingRoot != null && (helper = mappingRoot.getHelper()) != null && helper instanceof SqlTransformation) {
            SqlTransformation sqlHelper = (SqlTransformation)helper;
            if (sqlHelper.isInsertAllowed() && !sqlHelper.isInsertSqlDefault()) {
                sqlHelper.setInsertSql(null);
            }
            if (sqlHelper.isUpdateAllowed() && !sqlHelper.isUpdateSqlDefault()) {
                sqlHelper.setUpdateSql(null);
            }
            if (sqlHelper.isDeleteAllowed() && !sqlHelper.isDeleteSqlDefault()) {
                sqlHelper.setDeleteSql(null);
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ModelObjectEditorPage editorPage;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof MultiPageModelEditor && (editorPage = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && editorPage instanceof TransformationObjectEditorPage) {
            ((MultiPageModelEditor)editor).closeObjectEditor();
        }
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IFile virtualModelFile = (IFile)selection.getFirstElement();
        ModelResource virtualModel = null;
        try {
            ModelResource modelResource = ModelUtil.getModelResource((IFile)virtualModelFile, (boolean)false);
            if (ModelUtilities.isVirtual((ModelResource)modelResource)) {
                virtualModel = modelResource;
            }
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log((Throwable)e);
        }
        if (virtualModel != null) {
            IResource resource = virtualModel.getResource();
            ModelEditorManager.getModelEditorForFile((IFile)((IFile)resource), (boolean)true);
            final ModelResource viewModel = virtualModel;
            final List[] brokenTables = new ArrayList[1];
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor theMonitor) {
                    brokenTables[0] = ValidateModelTransformationsHandler.this.revalidate(viewModel);
                    theMonitor.done();
                }
            };
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                UiConstants.Util.log(e.getTargetException());
            }
            this.warnUserAboutInvalidTransformations(shell, brokenTables[0]);
        }
        return null;
    }

    private void invalidateSqlRootCache(List mappingRoots) {
        Object nextObj2 = null;
        for (Object nextObj2 : mappingRoots) {
            if (!(nextObj2 instanceof SqlTransformationMappingRoot)) continue;
            SqlTransformationMappingRoot mappingRoot = nextObj2;
            SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)false, (Object)((Object)this));
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean resetTransformation(SqlTransformationMappingRoot mappingRoot, int cmdType, QueryValidator qv) {
        String userSqlString = TransformationHelper.getSqlString((Object)mappingRoot, (int)cmdType);
        this.setUserString(mappingRoot, userSqlString, cmdType);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, null);
        QueryValidationResult result = qv.validateSql(userSqlString, cmdType, false);
        return result.isParsable() && result.isResolvable() && result.isValidatable();
    }

    List revalidate(ModelResource virtualModel) {
        ArrayList<EObject> brokenSqlTables = new ArrayList<EObject>();
        if (virtualModel != null) {
            UiPlugin.getDefault().setIgnoreTransformationNotifications(true);
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Revalidate Transformations", (Object)((Object)this));
            boolean succeeded = false;
            try {
                try {
                    Object nextObj2 = null;
                    List transformations = virtualModel.getModelTransformations().getTransformations();
                    this.invalidateSqlRootCache(transformations);
                    for (Object nextObj2 : transformations) {
                        if (!TransformationHelper.isSqlTransformationMappingRoot(nextObj2)) continue;
                        SqlTransformationMappingRoot mappingRoot = nextObj2;
                        TransformationValidator qv = new TransformationValidator(mappingRoot, false);
                        boolean supportsUpdates = false;
                        EObject mRootTarget = mappingRoot.getTarget();
                        SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)mRootTarget);
                        if (sqlAspect != null && sqlAspect instanceof SqlTableAspect) {
                            supportsUpdates = ((SqlTableAspect)sqlAspect).supportsUpdate(mRootTarget);
                        }
                        boolean selectValid = true;
                        boolean insertValid = true;
                        boolean updateValid = true;
                        boolean deleteValid = true;
                        selectValid = this.resetTransformation(mappingRoot, 0, (QueryValidator)qv);
                        if (supportsUpdates) {
                            insertValid = this.resetTransformation(mappingRoot, 1, (QueryValidator)qv);
                            updateValid = this.resetTransformation(mappingRoot, 2, (QueryValidator)qv);
                            deleteValid = this.resetTransformation(mappingRoot, 3, (QueryValidator)qv);
                        } else {
                            this.clearUUIDSqlString(mappingRoot);
                        }
                        if (selectValid && insertValid && updateValid && deleteValid) continue;
                        brokenSqlTables.add(mRootTarget);
                    }
                    succeeded = true;
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                UiPlugin.getDefault().setIgnoreTransformationNotifications(false);
            }
        }
        return brokenSqlTables;
    }

    private void setUserString(SqlTransformationMappingRoot mappingRoot, String userSqlStr, int cmdType) {
        if (cmdType == 0) {
            TransformationHelper.setSelectSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)((Object)this));
        } else if (cmdType == 1) {
            TransformationHelper.setInsertSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)((Object)this));
        } else if (cmdType == 2) {
            TransformationHelper.setUpdateSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)((Object)this));
        } else if (cmdType == 3) {
            TransformationHelper.setDeleteSqlUserString((Object)mappingRoot, (String)userSqlStr, (boolean)false, (boolean)false, (Object)((Object)this));
        }
    }

    private void warnUserAboutInvalidTransformations(Shell shell, List invalidSourceList) {
        if (!invalidSourceList.isEmpty()) {
            String title = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsTitle", new Object[0]);
            String msg = UiConstants.Util.getString("RevalidateModelTransformationsAction.invalidTransformationsMessage", new Object[0]);
            ArrayList<String> copyOfList = new ArrayList<String>(invalidSourceList.size());
            for (Object nextObj : invalidSourceList) {
                String path = ModelObjectUtilities.getTrimmedFullPath((EObject)((EObject)nextObj));
                String name = ModelerCore.getModelEditor().getName((EObject)nextObj);
                String row = String.valueOf(path) + "/" + name;
                copyOfList.add(row);
            }
            ListMessageDialog.openWarning((Shell)shell, (String)title, null, (String)msg, copyOfList, null);
        }
    }
}

