/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.teiid.designer.diagram.ui.util.RelationalUmlEObjectHelper;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class TransformationSelectionHelper {
    public static final int COUNT_SINGLE = 1;
    public static final int COUNT_MULTIPLE_SAME = -1;
    public static final int COUNT_MULTIPLE_MIXED = 2;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TARGET_TABLE = 0;
    public static final int TYPE_TARGET_CHILD = 1;
    public static final int TYPE_SOURCE_TABLE = 2;
    public static final int TYPE_SOURCE_CHILD = 3;
    public static final int TYPE_INPUT_SET = 4;
    public static final int TYPE_RESULT_SET = 5;
    public static final int TYPE_SOURCE_RESULT_SET = 6;
    public static final int TYPE_SQL_TRANSFORMATION_ROOT = 9;
    public static final int TYPE_SQL_TRANSFORMATION_ROOT_EXTRA = 10;
    public static final int TYPE_DIAGRAM = 11;
    public static final int TYPE_XQUERY_TRANSFORMATION_ROOT = 12;
    private EObject transformationRoot;
    private ISelection selection = null;
    private int type = -1;
    private int count = 0;
    private int countType = 1;

    public TransformationSelectionHelper(EObject tRoot, ISelection selection) {
        this.transformationRoot = tRoot;
        this.selection = selection;
        this.init();
    }

    private void init() {
        this.setType();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public EObject getSingleEObject() {
        if (SelectionUtilities.isSingleSelection((ISelection)this.selection)) {
            this.count = 1;
            this.countType = 1;
            EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)this.selection);
            if (eObj != null) {
                return eObj;
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    private void setType() {
        this.type = -1;
        if (SelectionUtilities.isSingleSelection((ISelection)this.selection)) {
            this.count = 1;
            this.countType = 1;
            EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)this.selection);
            if (eObj != null) {
                this.type = this.getEObjectType(eObj);
            }
        } else {
            List allSelected = SelectionUtilities.getSelectedEObjects((ISelection)this.selection);
            this.count = allSelected.size();
            if (this.count > 0) {
                EObject nextEObj = (EObject)allSelected.get(0);
                int firstType = this.getEObjectType(nextEObj);
                int nextType = -1;
                int i = 1;
                while (i < this.count) {
                    nextEObj = (EObject)allSelected.get(i);
                    nextType = this.getEObjectType(nextEObj);
                    if (nextType != firstType) {
                        this.type = -1;
                        this.countType = 2;
                        break;
                    }
                    this.type = firstType;
                    this.countType = -1;
                    ++i;
                }
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getCountType() {
        return this.countType;
    }

    public boolean isVirtual() {
        boolean isVirtual = false;
        if (SelectionUtilities.isSingleSelection((ISelection)this.selection)) {
            EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)this.selection);
            if (eObj != null) {
                isVirtual = ModelObjectUtilities.isVirtual((EObject)eObj);
            }
        } else if (SelectionUtilities.isMultiSelection((ISelection)this.selection)) {
            isVirtual = true;
            Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)this.selection).iterator();
            while (iter.hasNext() && isVirtual) {
                isVirtual = ModelObjectUtilities.isVirtual((EObject)((EObject)iter.next()));
            }
        }
        return isVirtual;
    }

    private EObject getMappingRootTarget(EObject eObj) {
        if (eObj != null && TransformationHelper.isSqlTransformationMappingRoot((Object)eObj)) {
            return ((SqlTransformationMappingRoot)eObj).getTarget();
        }
        return null;
    }

    public int getEObjectType(EObject eObj) {
        int eObjType = -1;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)eObj)) {
            eObjType = eObj == this.transformationRoot ? 9 : 10;
        } else if ((TransformationHelper.isSqlTable((Object)eObj) || TransformationHelper.isSqlProcedure((Object)eObj) || TransformationHelper.isSqlProcedureResultSet((Object)eObj)) && this.transformationRoot != null) {
            EObject rsContainer;
            EObject target = this.getMappingRootTarget(this.transformationRoot);
            if (target != null && TransformationHelper.isSqlProcedureResultSet((Object)target)) {
                target = target.eContainer();
            }
            eObjType = target != null && target == eObj ? 0 : (TransformationHelper.isSqlProcedureResultSet((Object)eObj) && ModelObjectUtilities.isVirtual((EObject)eObj) ? ((rsContainer = eObj.eContainer()) == target ? 5 : 6) : (TransformationHelper.isSqlInputSet((Object)eObj) ? 4 : 2));
        } else if (this.transformationRoot != null && (TransformationHelper.isSqlColumn((Object)eObj) || TransformationHelper.isSqlProcedureParameter((Object)eObj))) {
            EObject eContainer = eObj.eContainer();
            EObject target = this.getMappingRootTarget(this.transformationRoot);
            EObject secondaryTarget = TransformationHelper.getTransformationTarget((Object)this.transformationRoot);
            eObjType = target != null && target == eContainer ? 1 : (secondaryTarget != null && secondaryTarget == eContainer ? 1 : 3);
        } else {
            int umlType = RelationalUmlEObjectHelper.getEObjectType((EObject)eObj);
            if (umlType == 2 || umlType == 7 || umlType == 3 || umlType == 4) {
                eObjType = 3;
                if (this.transformationRoot != null) {
                    EObject eContainer = eObj.eContainer();
                    EObject target = this.getMappingRootTarget(this.transformationRoot);
                    EObject secondaryTarget = TransformationHelper.getTransformationTarget((Object)this.transformationRoot);
                    if (target != null && target == eContainer || secondaryTarget != null && secondaryTarget == eContainer) {
                        eObjType = 1;
                    }
                }
            } else if (eObj instanceof Diagram) {
                eObjType = 11;
            }
        }
        return eObjType;
    }
}

