/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;

public class LockAction
extends TransformationAction {
    private static final String LOCK_ACTION_DESCRIPTION = UiConstants.Util.getString("LockAction.lockText", new Object[0]);
    private static final String UNLOCK_ACTION_DESCRIPTION = UiConstants.Util.getString("LockAction.unlockText", new Object[0]);
    private boolean lockMode = true;

    public LockAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        this.setImageAndText();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.lockMode = !this.isTargetLocked();
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        Object o;
        if (this.getTransformation() != null && (o = SelectionUtilities.getSelectedObject((ISelection)this.getSelection())) instanceof EObject) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)this.getLockDescription(), (Object)((Object)this));
            boolean succeeded = false;
            try {
                SqlTransformationMappingRoot target = this.getRoot();
                if (target != null) {
                    target.setOutputReadOnly(this.lockMode);
                    succeeded = true;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.lockMode = !this.lockMode;
        this.determineEnablement();
    }

    private void determineEnablement() {
        EObject eObject;
        boolean enable = false;
        if (this.getPart() instanceof ModelEditor && SelectionUtilities.isSingleSelection((ISelection)this.getSelection()) && (eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection())) != null && !this.isReadOnly() && TransformationHelper.isVirtualSqlTable((Object)eObject) && this.isSameAsDiagramTarget(eObject)) {
            enable = true;
        }
        this.setImageAndText();
        this.setEnabled(enable);
    }

    private boolean isSameAsDiagramTarget(EObject eObject) {
        EObject target = DiagramEditorUtil.getCurrentVisibleDiagramTarget();
        return target != null && target.equals(eObject);
    }

    public SqlTransformationMappingRoot getRoot() {
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        SqlTransformationMappingRoot tRoot = null;
        if (eObject != null && TransformationHelper.isVirtualSqlTable((Object)eObject) && !TransformationHelper.isXmlDocument((Object)eObject) && this.isSameAsDiagramTarget(eObject)) {
            tRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)eObject);
        }
        return tRoot;
    }

    public boolean isTargetLocked() {
        SqlTransformationMappingRoot tRoot = this.getRoot();
        if (tRoot != null) {
            return tRoot.isOutputReadOnly();
        }
        return false;
    }

    private void setImageAndText() {
        if (this.lockMode) {
            this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/lock_mapping_class.gif"));
        } else {
            this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/unlock_mapping_class.gif"));
        }
        this.setText(this.getLockDescription());
    }

    private String getLockDescription() {
        if (this.lockMode) {
            return LOCK_ACTION_DESCRIPTION;
        }
        return UNLOCK_ACTION_DESCRIPTION;
    }
}

