/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.RelationalDialogModel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialog;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.relational.ui.textimport.RelationalTableLocationSelectionValidator;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.model.RelationalViewProcedure;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.TransformationDialogModel;
import org.teiid.designer.transformation.ui.textimport.VirtualModelSelectorDialog;
import org.teiid.designer.transformation.ui.textimport.VirtualTablelLocationSelectionValidator;
import org.teiid.designer.transformation.ui.wizards.RelationalModelSelectorDialog;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class CreateFunctionAction
extends Action {
    public CreateFunctionAction() {
        super(Messages.createFunctionLabel);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-relational-procedure.png"));
    }

    public CreateFunctionAction(Properties properties) {
        this();
    }

    public void run(String name, int numArgs) {
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        SelectFunctionTypeDialog procedureTypeDialog = new SelectFunctionTypeDialog(shell);
        procedureTypeDialog.open();
        if (procedureTypeDialog.getReturnCode() == 0) {
            boolean isUDF = procedureTypeDialog.isUDF();
            if (isUDF) {
                ModelResource mr = this.queryUserForViewModel();
                if (mr != null) {
                    RelationalViewProcedure relationalProcedure = new RelationalViewProcedure(name);
                    relationalProcedure.setFunction(true);
                    int i = 0;
                    while (i < numArgs) {
                        RelationalParameter param = new RelationalParameter("arg" + (i + 1));
                        param.setDatatype("string");
                        relationalProcedure.addParameter(param);
                        ++i;
                    }
                    RelationalParameter returnParam = new RelationalParameter("return_param");
                    returnParam.setDatatype("string");
                    returnParam.setDirection("RETURN");
                    relationalProcedure.addParameter(returnParam);
                    TransformationDialogModel dialogModel = new TransformationDialogModel((RelationalReference)relationalProcedure, this.getCorrespondingResource(mr));
                    EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, (EditRelationalObjectDialogModel)dialogModel);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        this.createUDFInTxn(mr, relationalProcedure);
                    }
                }
            } else {
                ModelResource mr = this.queryUserForModel();
                if (mr != null) {
                    RelationalProcedure relationalProcedure = new RelationalProcedure(name);
                    relationalProcedure.setProcedureType(RelationalProcedure.PROCEDURE_TYPE.SOURCE_FUNCTION);
                    int i = 0;
                    while (i < numArgs) {
                        RelationalParameter param = new RelationalParameter("arg" + (i + 1));
                        param.setDatatype("string");
                        relationalProcedure.addParameter(param);
                        ++i;
                    }
                    RelationalDialogModel dialogModel = new RelationalDialogModel((RelationalReference)relationalProcedure, this.getCorrespondingResource(mr));
                    EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, (EditRelationalObjectDialogModel)dialogModel);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        this.createFunctionInTxn(mr, relationalProcedure);
                    }
                }
            }
        }
    }

    private void createUDFInTxn(ModelResource modelResource, RelationalViewProcedure viewProcedure) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalViewProcedureTitle, (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    RelationalViewModelFactory factory = new RelationalViewModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)viewProcedure);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewProcedureExceptionMessage, (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalViewProcedureExceptionMessage, (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void createFunctionInTxn(ModelResource modelResource, RelationalProcedure procedure) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create Source Function", (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    RelationalModelFactory factory = new RelationalModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)procedure);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalProcedureExceptionMessage, (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalProcedureExceptionMessage, (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private IFile getCorrespondingResource(ModelResource mr) {
        IFile file = null;
        try {
            file = (IFile)mr.getCorrespondingResource();
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log((Throwable)e);
        }
        return file;
    }

    private ModelResource queryUserForViewModel() {
        VirtualModelSelectorDialog mwdDialog = new VirtualModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator(new VirtualTablelLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0) {
            Object[] oSelectedObjects = mwdDialog.getResult();
            try {
                if (oSelectedObjects.length == 1 && oSelectedObjects[0] instanceof IFile) {
                    return ModelUtil.getModelResource((IFile)((IFile)oSelectedObjects[0]), (boolean)false);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return null;
    }

    private ModelResource queryUserForModel() {
        RelationalModelSelectorDialog mwdDialog = new RelationalModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator((ISelectionStatusValidator)new RelationalTableLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0) {
            Object[] oSelectedObjects = mwdDialog.getResult();
            try {
                if (oSelectedObjects.length == 1 && oSelectedObjects[0] instanceof IFile) {
                    return ModelUtil.getModelResource((IFile)((IFile)oSelectedObjects[0]), (boolean)false);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return null;
    }

    class SelectFunctionTypeDialog
    extends TitleAreaDialog {
        boolean isUDF;

        public SelectFunctionTypeDialog(Shell parentShell) {
            super(parentShell);
            this.isUDF = false;
        }

        protected void constrainShellSize() {
            super.constrainShellSize();
            Shell shell = this.getShell();
            shell.setText("Choose Function Type");
            Rectangle r = shell.getBounds();
            shell.setBounds(r.x, r.y, (int)((double)r.width * 0.67), r.height);
            Shell parentShell = (Shell)shell.getParent();
            Rectangle parentBounds = parentShell.getBounds();
            Point parentCenter = new Point(parentBounds.x + parentBounds.width / 2, parentBounds.y + parentBounds.height / 2);
            Rectangle r2 = shell.getBounds();
            Point shellLocation = new Point(parentCenter.x - r2.width / 2, parentCenter.y - r2.height / 2);
            shell.setBounds(Math.max(0, shellLocation.x), Math.max(0, shellLocation.y), r2.width, r2.height);
        }

        protected Control createDialogArea(Composite parent) {
            Composite pnlOuter = (Composite)super.createDialogArea(parent);
            Composite panel = new Composite(pnlOuter, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            panel.setLayout((Layout)gridLayout);
            panel.setLayoutData((Object)new GridData(1808));
            this.setTitle(Messages.selectProcedureTypeDialogSubTitle);
            final Button sourceFunctionRB = new Button(panel, 16);
            sourceFunctionRB.setSelection(true);
            sourceFunctionRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            sourceFunctionRB.setText(Messages.sourceFunctionLabel);
            sourceFunctionRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectFunctionTypeDialog.this.isUDF = !sourceFunctionRB.getSelection();
                }
            });
            Text descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalSourceFunctionDescription);
            final Button userDefinedFunctionRB = new Button(panel, 16);
            userDefinedFunctionRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            userDefinedFunctionRB.setText(Messages.userDefinedFunctionLabel);
            userDefinedFunctionRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectFunctionTypeDialog.this.isUDF = userDefinedFunctionRB.getSelection();
                }
            });
            descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalViewUserDefinedFunctionDescription);
            return pnlOuter;
        }

        public boolean isUDF() {
            return this.isUDF;
        }
    }
}

