/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.EventObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.SqlTransformationStatusChangeEvent;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.editors.ModelEditor;

public class ClearTransformationAction
extends TransformationAction
implements EventObjectListener,
UiConstants {
    private static final String ACTION_DESCRIPTION = "Clear Transformation";
    private static final String REMOVE_ATTRIBUTES_TITLE = UiConstants.Util.getString("ClearTransformationAction.deleteAttributesTitle", new Object[0]);
    private static final String CONFIRM_TITLE = UiConstants.Util.getString("ClearTransformationAction.confirmTitle", new Object[0]);
    private static final String CONFIRM_MESSAGE = UiConstants.Util.getString("ClearTransformationAction.confirmMessage", new Object[0]);

    public ClearTransformationAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_clear_transformation.gif"));
        SqlMappingRootCache.addEventListener((EventObjectListener)this);
    }

    @Override
    public void setTransformation(EObject transformationEObject) {
        EObject transMappingRoot;
        super.setTransformation(transformationEObject);
        boolean enable = false;
        if (!this.isDependencyDiagram() && (transMappingRoot = this.getTransformation()) != null && TransformationHelper.isTransformationMappingRoot((Object)transMappingRoot)) {
            enable = this.shouldEnable(transMappingRoot);
        }
        this.setEnabled(enable);
    }

    private boolean shouldEnable(EObject transMappingRoot) {
        return this.rootIsValid(transMappingRoot) && TransformationSourceManager.canClear(transMappingRoot);
    }

    public void processEvent(EventObject e) {
        if (e instanceof SqlTransformationStatusChangeEvent) {
            boolean enable = false;
            EObject eventMappingRoot = ((SqlTransformationStatusChangeEvent)e).getMappingRoot();
            if (eventMappingRoot != null && eventMappingRoot.equals(this.getTransformation())) {
                enable = this.shouldEnable(this.getTransformation());
                this.setEnabled(enable);
            }
        }
    }

    @Override
    protected void doRun() {
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        boolean userContinue = MessageDialog.openConfirm((Shell)shell, (String)CONFIRM_TITLE, (String)CONFIRM_MESSAGE);
        if (userContinue) {
            boolean objectEditorOpen = false;
            ModelEditor activeEditor = this.getActiveEditor();
            if (activeEditor != null && activeEditor.getActiveObjectEditor() != null) {
                objectEditorOpen = true;
            }
            boolean canUndo = false;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)this);
            boolean succeeded = false;
            try {
                EObject targetEObject = ((TransformationMappingRoot)this.getTransformation()).getTarget();
                boolean removeAttributes = false;
                if ((!TransformationHelper.isMappingClass((Object)targetEObject) || TransformationHelper.isStagingTable((Object)targetEObject)) && targetEObject.eContents().size() > 0) {
                    String message = UiConstants.Util.getString("ClearTransformationAction.deleteAttributesMessage", (Object)ModelerCore.getModelEditor().getName(targetEObject));
                    removeAttributes = MessageDialog.openQuestion((Shell)shell, (String)REMOVE_ATTRIBUTES_TITLE, (String)message);
                }
                if (objectEditorOpen) {
                    activeEditor.closeObjectEditor();
                }
                TransformationSourceManager.clear(this.getTransformation(), removeAttributes);
                DiagramEntityManager.cleanUpDiagram((Diagram)this.getCurrentDiagram());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                this.setEnabled(this.shouldEnable(this.getTransformation()));
            }
        }
    }

    private boolean rootIsValid(EObject transMappingRoot) {
        return transMappingRoot != null && transMappingRoot.eResource() != null;
    }

    public void dispose() {
        SqlMappingRootCache.removeEventListener((EventObjectListener)this);
        super.dispose();
    }
}

