/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.ui.PluginConstants;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.util.TransformationNotificationListener;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.PreferenceKeyAndDefaultValue;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class UiPlugin
extends AbstractUiPlugin
implements UiConstants {
    private static UiPlugin plugin;
    private TransformationNotificationListener notificationListener = new TransformationNotificationListener();

    public UiPlugin() {
        plugin = this;
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    private void init() {
        TransformationPlugin.getDefault();
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this.notificationListener);
    }

    public void setIgnoreTransformationNotifications(boolean ignoreNotifications) {
        if (this.notificationListener != null) {
            this.notificationListener.setIgnoreNotifications(ignoreNotifications);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        this.storeDefaultPreferenceValues();
        this.init();
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public ActionService getActionService(IWorkbenchPage page) {
        return DiagramUiPlugin.getDefault().getActionService(page);
    }

    public PluginUtil getPluginUtil() {
        return Util;
    }

    private void storeDefaultPreferenceValues() {
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PluginConstants.Prefs.Appearance.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Appearance.PREFERENCES[i]);
            ++i;
        }
        DiagramUiPlugin.getDefault().savePreferences();
        preferenceStore = UiPlugin.getDefault().getPreferenceStore();
        i = 0;
        while (i < PluginConstants.Prefs.Reconciler.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Reconciler.PREFERENCES[i]);
            ++i;
        }
        UiPlugin.getDefault().savePreferences();
    }

    public void stop(BundleContext context) throws Exception {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notificationListener);
        super.stop(context);
    }

    public String getString(String prefix, String id) {
        return Util.getString(String.valueOf(prefix) + id, new Object[0]);
    }
}

