(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("gmaps_3.16", function(server, options) {
    server._gmaps = {};
    return {
      defs : defs
    };
  });

  var defs = {"!name":"gmaps","google":{"maps":{"Map":{"!proto":"google.maps.MVCObject","!type":"fn(mapDiv: +Node, opts?: +google.maps.MapOptions)","!doc":"Creates a new map inside of the given HTML container, which is typically a DIV element.","prototype":{"fitBounds":{"!type":"fn(bounds: +google.maps.LatLngBounds)","!doc":"Sets the viewport to contain the given bounds."},"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Returns the lat/lng bounds of the current viewport. If more than one copy of the world is visible, the bounds range in longitude from -180 to 180 degrees inclusive. If the map is not yet initialized (i.e. the mapType is still null), or center and zoom have not been set then the result is null or undefined."},"getCenter":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the position displayed at the center of the map. Note that this LatLng object is not wrapped. See LatLng for more information."},"getDiv":{"!type":"fn() -> +Node"},"getHeading":{"!type":"fn() -> number","!doc":"Returns the compass heading of aerial imagery. The heading value is measured in degrees (clockwise) from cardinal direction North."},"getMapTypeId":{"!type":"fn() -> +google.maps.MapTypeId"},"getProjection":{"!type":"fn() -> +google.maps.Projection","!doc":"Returns the current Projection. If the map is not yet initialized (i.e. the mapType is still null) then the result is null. Listen to projection_changed and check its value to ensure it is not null."},"getStreetView":{"!type":"fn() -> +google.maps.StreetViewPanorama","!doc":"Returns the default StreetViewPanorama bound to the map, which may be a default panorama embedded within the map, or the panorama set using setStreetView(). Changes to the map's streetViewControl will be reflected in the display of such a bound panorama."},"getTilt":{"!type":"fn() -> number","!doc":"Returns the current angle of incidence of the map, in degrees from the viewport plane to the map plane. The result will be 0 for imagery taken directly overhead or 45 for 45° imagery. 45° imagery is only available for SATELLITE and HYBRID map types, within some locations, and at some zoom levels. Note: This method does not return the value set by setTilt. See setTilt for details."},"getZoom":{"!type":"fn() -> number"},"panBy":{"!type":"fn(x: number, y: number)","!doc":"Changes the center of the map by the given distance in pixels. If the distance is less than both the width and height of the map, the transition will be smoothly animated. Note that the map coordinate system increases from west to east (for x values) and north to south (for y values)."},"panTo":{"!type":"fn(latLng: +google.maps.LatLng)","!doc":"Changes the center of the map to the given LatLng. If the change is less than both the width and height of the map, the transition will be smoothly animated."},"panToBounds":{"!type":"fn(latLngBounds: +google.maps.LatLngBounds)","!doc":"Pans the map by the minimum amount necessary to contain the given LatLngBounds. It makes no guarantee where on the map the bounds will be, except that as much of the bounds as possible will be visible. The bounds will be positioned inside the area bounded by the map type and navigation (pan, zoom, and Street View) controls, if they are present on the map. If the bounds is larger than the map, the map will be shifted to include the northwest corner of the bounds. If the change in the map's position is less than both the width and height of the map, the transition will be smoothly animated."},"setCenter":{"!type":"fn(latlng: +google.maps.LatLng)"},"setHeading":{"!type":"fn(heading: number)","!doc":"Sets the compass heading for aerial imagery measured in degrees from cardinal direction North."},"setMapTypeId":{"!type":"fn(mapTypeId: +google.maps.MapTypeId)"},"setOptions":{"!type":"fn(options: +google.maps.MapOptions)"},"setStreetView":{"!type":"fn(panorama: +google.maps.StreetViewPanorama)","!doc":"Binds a StreetViewPanorama to the map. This panorama overrides the default StreetViewPanorama, allowing the map to bind to an external panorama outside of the map. Setting the panorama to null binds the default embedded panorama back to the map."},"setTilt":{"!type":"fn(tilt: number)","!doc":"Controls the automatic switching behavior for the angle of incidence of the map. The only allowed values are 0 and 45. setTilt(0) causes the map to always use a 0° overhead view regardless of the zoom level and viewport. setTilt(45) causes the tilt angle to automatically switch to 45 whenever 45° imagery is available for the current zoom level and viewport, and switch back to 0 whenever 45° imagery is not available (this is the default behavior). 45° imagery is only available for SATELLITE and HYBRID map types, within some locations, and at some zoom levels. Note: getTilt returns the current tilt angle, not the value set by setTilt. Because getTilt and setTilt refer to different things, do not bind() the tilt property; doing so may yield unpredictable effects."},"setZoom":{"!type":"fn(zoom: number)"}}},"MapOptions":{},"MapTypeId":{},"MapTypeControlOptions":{},"MapTypeControlStyle":{},"OverviewMapControlOptions":{},"PanControlOptions":{},"RotateControlOptions":{},"ScaleControlOptions":{},"ScaleControlStyle":{},"StreetViewControlOptions":{},"ZoomControlOptions":{},"ZoomControlStyle":{},"ControlPosition":{},"Data":{"!proto":"google.maps.MVCObject","!type":"fn(options?: +Data.DataOptions)","!doc":"Creates an empty collection, with the given DataOptions.","prototype":{"add":{"!type":"fn(feature: +Data.Feature) -> +Data.Feature","!doc":"Adds a feature to the collection, and returns the added feature. If the feature has an ID, it will replace any existing feature in the collection with the same ID. If no feature is given, a new feature will be created with null geometry and no properties. If FeatureOptions are given, a new feature will be created with the specified properties."},"addGeoJson":{"!type":"fn(geoJson: ?, options?: +Data.GeoJsonOptions) -> [+Data.Feature]","!doc":"Adds GeoJSON features to the collection. Give this method a parsed JSON. The imported features are returned. Throws an exception if the GeoJSON could not be imported."},"contains":{"!type":"fn(feature: +Data.Feature) -> bool","!doc":"Checks whether the given feature is in the collection."},"forEach":{"!type":"fn(callback: fn())","!doc":"Repeatedly invokes the given function, passing a feature in the collection to the function on each invocation. The order of iteration through the features is undefined."},"getFeatureById":{"!type":"fn(id: string) -> +Data.Feature","!doc":"Returns the feature with the given ID, if it exists in the collection. Otherwise returns undefined."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which the features are displayed."},"getStyle":{"!type":"fn() -> +Data.StylingFunction","!doc":"Gets the style for all features in the collection."},"loadGeoJson":{"!type":"fn(url: string, options?: +Data.GeoJsonOptions)","!doc":"Loads GeoJSON from a URL, and adds the features to the collection."},"overrideStyle":{"!type":"fn(feature: +Data.Feature, style: +Data.StyleOptions)","!doc":"Changes the style of a feature. These changes are applied on top of the style specified by setStyle(). Style properties set to null revert to the value specified via setStyle()."},"remove":{"!type":"fn(feature: +Data.Feature)","!doc":"Removes a feature from the collection."},"revertStyle":{"!type":"fn(feature?: +Data.Feature)","!doc":"Removes the effect of previous overrideStyle() calls. The style of the given feature reverts to the style specified by setStyle(). If no feature is given, all features have their style reverted."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the features on the specified map. If map is set to null, the features will be removed from the map."},"setStyle":{"!type":"fn(style: +Data.StylingFunction)","!doc":"Sets the style for all features in the collection. Styles specified on a per-feature basis via overrideStyle() continue to apply. Pass either an object with the desired style options, or a function that computes the style for each feature. The function will be called every time a feature's properties are updated."}},"DataOptions":{},"GeoJsonOptions":{},"StyleOptions":{},"StylingFunction":{},"Feature":{"!type":"fn(options?: +Data.FeatureOptions)","!doc":"Constructs a Feature with the given options.","prototype":{"forEachProperty":{"!type":"fn(callback: fn())","!doc":"Repeatedly invokes the given function, passing a property value and name on each invocation. The order of iteration through the properties is undefined."},"getGeometry":{"!type":"fn() -> +Data.Geometry","!doc":"Returns the feature's geometry."},"getId":{"!type":"fn() -> string","!doc":"Returns the feature ID."},"getProperty":{"!type":"fn(name: string) -> ?","!doc":"Returns the value of the requested property, or undefined if the property does not exist."},"removeProperty":{"!type":"fn(name: string)","!doc":"Removes the property with the given name."},"setGeometry":{"!type":"fn(newGeometry: +Data.Geometry)","!doc":"Sets the feature's geometry."},"setProperty":{"!type":"fn(name: string, newValue: ?)","!doc":"Sets the value of the specified property. If newValue is undefined this is equivalent to calling removeProperty."}}},"FeatureOptions":{},"Geometry":{"prototype":{"getType":{"!type":"fn() -> string","!doc":"Returns the type of the geometry object. Possibilities are \"Point\", \"MultiPoint\", \"LineString\", \"MultiLineString\", \"LinearRing\", \"Polygon\", \"MultiPolygon\", or \"GeometryCollection\"."}}},"Point":{"!proto":"Data.Geometry","!type":"fn(latLng: +google.maps.LatLng)","!doc":"Constructs a Data.Point from the given LatLng or LatLngLiteral.","prototype":{"get":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the contained LatLng."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"Point\"."}}},"MultiPoint":{"!proto":"Data.Geometry","!type":"fn(elements: [+LatLn])","!doc":"Constructs a Data.MultiPoint from the given LatLngs or LatLngLiterals.","prototype":{"getArray":{"!type":"fn() -> [+LatLng]","!doc":"Returns an array of the contained LatLngs. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +google.maps.LatLng","!doc":"Returns the n-th contained LatLng."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained LatLngs."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"MultiPoint\"."}}},"LineString":{"!proto":"Data.Geometry","!type":"fn(elements: [+LatLn])","!doc":"Constructs a Data.LineString from the given LatLngs or LatLngLiterals.","prototype":{"getArray":{"!type":"fn() -> [+LatLng]","!doc":"Returns an array of the contained LatLngs. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +google.maps.LatLng","!doc":"Returns the n-th contained LatLng."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained LatLngs."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"LineString\"."}}},"MultiLineString":{"!proto":"Data.Geometry","!type":"fn(elements: [+Data.LineStrin])","!doc":"Constructs a Data.MultiLineString from the given Data.LineStrings or arrays of positions.","prototype":{"getArray":{"!type":"fn() -> [+Data.LineString]","!doc":"Returns an array of the contained Data.LineStrings. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +Data.LineString","!doc":"Returns the n-th contained Data.LineString."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained Data.LineStrings."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"MultiLineString\"."}}},"LinearRing":{"!proto":"Data.Geometry","!type":"fn(elements: [+LatLn])","!doc":"Constructs a Data.LinearRing from the given LatLngs or LatLngLiterals.","prototype":{"getArray":{"!type":"fn() -> [+LatLng]","!doc":"Returns an array of the contained LatLngs. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +google.maps.LatLng","!doc":"Returns the n-th contained LatLng."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained LatLngs."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"LinearRing\"."}}},"Polygon":{"!proto":"Data.Geometry","!type":"fn(elements: [+Data.LinearRin])","!doc":"Constructs a Data.Polygon from the given Data.LinearRings or arrays of positions.","prototype":{"getArray":{"!type":"fn() -> [+Data.LinearRing]","!doc":"Returns an array of the contained Data.LinearRings. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +Data.LinearRing","!doc":"Returns the n-th contained Data.LinearRing."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained Data.LinearRings."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"Polygon\"."}}},"MultiPolygon":{"!proto":"Data.Geometry","!type":"fn(elements: [+Data.Polygo])","!doc":"Constructs a Data.MultiPolygon from the given Data.Polygons or arrays of positions.","prototype":{"getArray":{"!type":"fn() -> [+Data.Polygon]","!doc":"Returns an array of the contained Data.Polygons. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +Data.Polygon","!doc":"Returns the n-th contained Data.Polygon."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained Data.Polygons."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"MultiPolygon\"."}}},"GeometryCollection":{"!proto":"Data.Geometry","!type":"fn(elements: [+Data.Geometr])","!doc":"Constructs a Data.GeometryCollection from the given geometry objects or LatLngs.","prototype":{"getArray":{"!type":"fn() -> [+Data.Geometry]","!doc":"Returns an array of the contained geometry objects. A new array is returned each time getArray() is called."},"getAt":{"!type":"fn(n: number) -> +Data.Geometry","!doc":"Returns the n-th contained geometry object."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of contained geometry objects."},"getType":{"!type":"fn() -> string","!doc":"Returns the string \"GeometryCollection\"."}}},"MouseEvent":{},"AddFeatureEvent":{},"RemoveFeatureEvent":{},"SetGeometryEvent":{},"SetPropertyEvent":{},"RemovePropertyEvent":{}},"Marker":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.MarkerOptions)","!doc":"Creates a marker with the options specified. If a map is specified, the marker is added to the map upon construction. Note that the position must be set for the marker to display.","prototype":{"getAnimation":{"!type":"fn() -> +google.maps.Animation"},"getClickable":{"!type":"fn() -> bool"},"getCursor":{"!type":"fn() -> string"},"getDraggable":{"!type":"fn() -> bool"},"getIcon":{"!type":"fn() -> string"},"getMap":{"!type":"fn() -> +google.maps.Map"},"getOpacity":{"!type":"fn() -> number"},"getPosition":{"!type":"fn() -> +google.maps.LatLng"},"getShape":{"!type":"fn() -> +google.maps.MarkerShape"},"getTitle":{"!type":"fn() -> string"},"getVisible":{"!type":"fn() -> bool"},"getZIndex":{"!type":"fn() -> number"},"setAnimation":{"!type":"fn(animation: +google.maps.Animation)","!doc":"Start an animation. Any ongoing animation will be cancelled. Currently supported animations are: BOUNCE, DROP. Passing in null will cause any animation to stop."},"setClickable":{"!type":"fn(flag: bool)"},"setCursor":{"!type":"fn(cursor: string)"},"setDraggable":{"!type":"fn(flag: bool)"},"setIcon":{"!type":"fn(icon: string)"},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the marker on the specified map or panorama. If map is set to null, the marker will be removed."},"setOpacity":{"!type":"fn(opacity: number)"},"setOptions":{"!type":"fn(options: +google.maps.MarkerOptions)"},"setPosition":{"!type":"fn(latlng: +google.maps.LatLng)"},"setShape":{"!type":"fn(shape: +google.maps.MarkerShape)"},"setTitle":{"!type":"fn(title: string)"},"setVisible":{"!type":"fn(visible: bool)"},"setZIndex":{"!type":"fn(zIndex: number)"}}},"MarkerOptions":{},"Icon":{},"MarkerShape":{},"Symbol":{},"SymbolPath":{},"Animation":{},"InfoWindow":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.InfoWindowOptions)","!doc":"Creates an info window with the given options. An InfoWindow can be placed on a map at a particular position or above a marker, depending on what is specified in the options. Unless auto-pan is disabled, an InfoWindow will pan the map to make itself visible when it is opened. After constructing an InfoWindow, you must call open to display it on the map. The user can click the close button on the InfoWindow to remove it from the map, or the developer can call close() for the same effect.","prototype":{"close":{"!type":"fn()","!doc":"Closes this InfoWindow by removing it from the DOM structure."},"getContent":{"!type":"fn() -> string"},"getPosition":{"!type":"fn() -> +google.maps.LatLng"},"getZIndex":{"!type":"fn() -> number"},"open":{"!type":"fn(map?: +google.maps.Map, anchor?: +google.maps.MVCObject)","!doc":"Opens this InfoWindow on the given map. Optionally, an InfoWindow can be associated with an anchor. In the core API, the only anchor is the Marker class. However, an anchor can be any MVCObject that exposes a LatLng position property and optionally a Point anchorPoint property for calculating the pixelOffset (see InfoWindowOptions). The anchorPoint is the offset from the anchor's position to the tip of the InfoWindow."},"setContent":{"!type":"fn(content: string)"},"setOptions":{"!type":"fn(options: +google.maps.InfoWindowOptions)"},"setPosition":{"!type":"fn(position: +google.maps.LatLng)"},"setZIndex":{"!type":"fn(zIndex: number)"}}},"InfoWindowOptions":{},"Polyline":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.PolylineOptions)","!doc":"Create a polyline using the passed PolylineOptions, which specify both the path of the polyline and the stroke style to use when drawing the polyline. You may pass either an array of LatLngs or an MVCArray of LatLngs when constructing a polyline, though simple arrays are converted to MVCArrays within the polyline upon instantiation.","prototype":{"getDraggable":{"!type":"fn() -> bool","!doc":"Returns whether this shape can be dragged by the user."},"getEditable":{"!type":"fn() -> bool","!doc":"Returns whether this shape can be edited by the user."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this shape is attached."},"getPath":{"!type":"fn() -> +MVCArray.<LatLng>","!doc":"Retrieves the first path."},"getVisible":{"!type":"fn() -> bool","!doc":"Returns whether this poly is visible on the map."},"setDraggable":{"!type":"fn(draggable: bool)","!doc":"If set to true, the user can drag this shape over the map. The geodesic property defines the mode of dragging."},"setEditable":{"!type":"fn(editable: bool)","!doc":"If set to true, the user can edit this shape by dragging the control points shown at the vertices and on each segment."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders this shape on the specified map. If map is set to null, the shape will be removed."},"setOptions":{"!type":"fn(options: +google.maps.PolylineOptions)"},"setPath":{"!type":"fn(path: +MVCArray.<LatLng>)","!doc":"Sets the first path. See PolylineOptions for more details."},"setVisible":{"!type":"fn(visible: bool)","!doc":"Hides this poly if set to false."}}},"PolylineOptions":{},"IconSequence":{},"Polygon":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.PolygonOptions)","!doc":"Create a polygon using the passed PolygonOptions, which specify the polygon's path, the stroke style for the polygon's edges, and the fill style for the polygon's interior regions. A polygon may contain one or more paths, where each path consists of an array of LatLngs. You may pass either an array of LatLngs or an MVCArray of LatLngs when constructing these paths. Arrays are converted to MVCArrays within the polygon upon instantiation.","prototype":{"getDraggable":{"!type":"fn() -> bool","!doc":"Returns whether this shape can be dragged by the user."},"getEditable":{"!type":"fn() -> bool","!doc":"Returns whether this shape can be edited by the user."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this shape is attached."},"getPath":{"!type":"fn() -> +MVCArray.<LatLng>","!doc":"Retrieves the first path."},"getPaths":{"!type":"fn() -> +MVCArray.<MVCArray.<LatLng>>","!doc":"Retrieves the paths for this polygon."},"getVisible":{"!type":"fn() -> bool","!doc":"Returns whether this poly is visible on the map."},"setDraggable":{"!type":"fn(draggable: bool)","!doc":"If set to true, the user can drag this shape over the map. The geodesic property defines the mode of dragging."},"setEditable":{"!type":"fn(editable: bool)","!doc":"If set to true, the user can edit this shape by dragging the control points shown at the vertices and on each segment."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders this shape on the specified map. If map is set to null, the shape will be removed."},"setOptions":{"!type":"fn(options: +google.maps.PolygonOptions)"},"setPath":{"!type":"fn(path: +MVCArray.<LatLng>)","!doc":"Sets the first path. See PolylineOptions for more details."},"setPaths":{"!type":"fn(paths: +MVCArray.<MVCArray.<LatLng>>)","!doc":"Sets the path for this polygon."},"setVisible":{"!type":"fn(visible: bool)","!doc":"Hides this poly if set to false."}}},"PolygonOptions":{},"PolyMouseEvent":{},"Rectangle":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.RectangleOptions)","!doc":"Create a rectangle using the passed RectangleOptions, which specify the bounds and style.","prototype":{"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Returns the bounds of this rectangle."},"getDraggable":{"!type":"fn() -> bool","!doc":"Returns whether this rectangle can be dragged by the user."},"getEditable":{"!type":"fn() -> bool","!doc":"Returns whether this rectangle can be edited by the user."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this rectangle is displayed."},"getVisible":{"!type":"fn() -> bool","!doc":"Returns whether this rectangle is visible on the map."},"setBounds":{"!type":"fn(bounds: +google.maps.LatLngBounds)","!doc":"Sets the bounds of this rectangle."},"setDraggable":{"!type":"fn(draggable: bool)","!doc":"If set to true, the user can drag this rectangle over the map."},"setEditable":{"!type":"fn(editable: bool)","!doc":"If set to true, the user can edit this rectangle by dragging the control points shown at the corners and on each edge."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the rectangle on the specified map. If map is set to null, the rectangle will be removed."},"setOptions":{"!type":"fn(options: +google.maps.RectangleOptions)"},"setVisible":{"!type":"fn(visible: bool)","!doc":"Hides this rectangle if set to false."}}},"RectangleOptions":{},"Circle":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.CircleOptions)","!doc":"Create a circle using the passed CircleOptions, which specify the center, radius, and style.","prototype":{"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Gets the LatLngBounds of this Circle."},"getCenter":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the center of this circle."},"getDraggable":{"!type":"fn() -> bool","!doc":"Returns whether this circle can be dragged by the user."},"getEditable":{"!type":"fn() -> bool","!doc":"Returns whether this circle can be edited by the user."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this circle is displayed."},"getRadius":{"!type":"fn() -> number","!doc":"Returns the radius of this circle (in meters)."},"getVisible":{"!type":"fn() -> bool","!doc":"Returns whether this circle is visible on the map."},"setCenter":{"!type":"fn(center: +google.maps.LatLng)","!doc":"Sets the center of this circle."},"setDraggable":{"!type":"fn(draggable: bool)","!doc":"If set to true, the user can drag this circle over the map."},"setEditable":{"!type":"fn(editable: bool)","!doc":"If set to true, the user can edit this circle by dragging the control points shown at the center and around the circumference of the circle."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the circle on the specified map. If map is set to null, the circle will be removed."},"setOptions":{"!type":"fn(options: +google.maps.CircleOptions)"},"setRadius":{"!type":"fn(radius: number)","!doc":"Sets the radius of this circle (in meters)."},"setVisible":{"!type":"fn(visible: bool)","!doc":"Hides this circle if set to false."}}},"CircleOptions":{},"StrokePosition":{},"GroundOverlay":{"!proto":"google.maps.MVCObject","!type":"fn(url: string, bounds: +google.maps.LatLngBounds, opts?: +google.maps.GroundOverlayOptions)","!doc":"Creates a ground overlay from the provided image URL and its LatLngBounds. The image is scaled to fit the current bounds, and projected using the current map projection.","prototype":{"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Gets the LatLngBounds of this overlay."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this ground overlay is displayed."},"getOpacity":{"!type":"fn() -> number","!doc":"Returns the opacity of this ground overlay."},"getUrl":{"!type":"fn() -> string","!doc":"Gets the url of the projected image."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the ground overlay on the specified map. If map is set to null, the overlay is removed."},"setOpacity":{"!type":"fn(opacity: number)","!doc":"Sets the opacity of this ground overlay."}}},"GroundOverlayOptions":{},"OverlayView":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"Creates an OverlayView.","prototype":{"draw":{"!type":"fn()","!doc":"Implement this method to draw or update the overlay. This method is called after onAdd() and when the position from projection.fromLatLngToPixel() would return a new value for a given LatLng. This can happen on change of zoom, center, or map type. It is not necessarily called on drag or resize."},"getMap":{"!type":"fn() -> +google.maps.Map"},"getPanes":{"!type":"fn() -> +google.maps.MapPanes","!doc":"Returns the panes in which this OverlayView can be rendered. The panes are not initialized until onAdd is called by the API."},"getProjection":{"!type":"fn() -> +google.maps.MapCanvasProjection","!doc":"Returns the MapCanvasProjection object associated with this OverlayView. The projection is not initialized until onAdd is called by the API."},"onAdd":{"!type":"fn()","!doc":"Implement this method to initialize the overlay DOM elements. This method is called once after setMap() is called with a valid map. At this point, panes and projection will have been initialized."},"onRemove":{"!type":"fn()","!doc":"Implement this method to remove your elements from the DOM. This method is called once following a call to setMap(null)."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Adds the overlay to the map or panorama."}}},"MapPanes":{},"MapCanvasProjection":{"prototype":{"fromContainerPixelToLatLng":{"!type":"fn(pixel: +google.maps.Point, nowrap?: bool) -> +google.maps.LatLng","!doc":"Computes the geographical coordinates from pixel coordinates in the map's container."},"fromDivPixelToLatLng":{"!type":"fn(pixel: +google.maps.Point, nowrap?: bool) -> +google.maps.LatLng","!doc":"Computes the geographical coordinates from pixel coordinates in the div that holds the draggable map."},"fromLatLngToContainerPixel":{"!type":"fn(latLng: +google.maps.LatLng) -> +google.maps.Point","!doc":"Computes the pixel coordinates of the given geographical location in the map's container element."},"fromLatLngToDivPixel":{"!type":"fn(latLng: +google.maps.LatLng) -> +google.maps.Point","!doc":"Computes the pixel coordinates of the given geographical location in the DOM element that holds the draggable map."},"getWorldWidth":{"!type":"fn() -> number","!doc":"The width of the world in pixels in the current zoom level. For projections with a heading angle of either 90 or 270 degrees, this corresponds to the pixel span in the Y-axis."}}},"Geocoder":{"!type":"fn()","!doc":"Creates a new instance of a Geocoder that sends geocode requests to Google servers.","prototype":{"geocode":{"!type":"fn(request: +google.maps.GeocoderRequest, callback: fn())","!doc":"Geocode a request."}}},"GeocoderRequest":{},"GeocoderComponentRestrictions":{},"GeocoderStatus":{},"GeocoderResult":{},"GeocoderAddressComponent":{},"GeocoderGeometry":{},"GeocoderLocationType":{},"DirectionsRenderer":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.DirectionsRendererOptions)","!doc":"Creates the renderer with the given options. Directions can be rendered on a map (as visual overlays) or additionally on a <div> panel (as textual instructions).","prototype":{"getDirections":{"!type":"fn() -> +google.maps.DirectionsResult","!doc":"Returns the renderer's current set of directions."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which the DirectionsResult is rendered."},"getPanel":{"!type":"fn() -> +Node","!doc":"Returns the panel <div> in which the DirectionsResult is rendered."},"getRouteIndex":{"!type":"fn() -> number","!doc":"Returns the current (zero-based) route index in use by this DirectionsRenderer object."},"setDirections":{"!type":"fn(directions: +google.maps.DirectionsResult)","!doc":"Set the renderer to use the result from the DirectionsService. Setting a valid set of directions in this manner will display the directions on the renderer's designated map and panel."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"This method specifies the map on which directions will be rendered. Pass null to remove the directions from the map."},"setOptions":{"!type":"fn(options: +google.maps.DirectionsRendererOptions)","!doc":"Change the options settings of this DirectionsRenderer after initialization."},"setPanel":{"!type":"fn(panel: +Node)","!doc":"This method renders the directions in a <div>. Pass null to remove the content from the panel."},"setRouteIndex":{"!type":"fn(routeIndex: number)","!doc":"Set the (zero-based) index of the route in the DirectionsResult object to render. By default, the first route in the array will be rendered."}}},"DirectionsRendererOptions":{},"DirectionsService":{"!type":"fn()","!doc":"Creates a new instance of a DirectionsService that sends directions queries to Google servers.","prototype":{"route":{"!type":"fn(request: +google.maps.DirectionsRequest, callback: fn())","!doc":"Issue a directions search request."}}},"DirectionsRequest":{},"TravelMode":{},"UnitSystem":{},"TransitOptions":{},"DirectionsWaypoint":{},"DirectionsStatus":{},"DirectionsResult":{},"DirectionsRoute":{},"DirectionsLeg":{},"DirectionsStep":{},"Distance":{},"Duration":{},"Time":{},"TransitDetails":{},"TransitStop":{},"TransitLine":{},"TransitAgency":{},"TransitVehicle":{},"VehicleType":{},"ElevationService":{"!type":"fn()","!doc":"Creates a new instance of a ElevationService that sends elevation queries to Google servers.","prototype":{"getElevationAlongPath":{"!type":"fn(request: +google.maps.PathElevationRequest, callback: fn())","!doc":"Makes an elevation request along a path, where the elevation data are returned as distance-based samples along that path."},"getElevationForLocations":{"!type":"fn(request: +google.maps.LocationElevationRequest, callback: fn())","!doc":"Makes an elevation request for a list of discrete locations."}}},"LocationElevationRequest":{},"PathElevationRequest":{},"ElevationResult":{},"ElevationStatus":{},"MaxZoomService":{"!type":"fn()","!doc":"Creates a new instance of a MaxZoomService that can be used to send queries about the maximum zoom level available for satellite imagery.","prototype":{"getMaxZoomAtLatLng":{"!type":"fn(latlng: +google.maps.LatLng, callback: fn())","!doc":"Returns the maximum zoom level available at a particular LatLng for the Satellite map type. As this request is asynchronous, you must pass a callback function which will be executed upon completion of the request, being passed a MaxZoomResult."}}},"MaxZoomResult":{},"MaxZoomStatus":{},"DistanceMatrixService":{"!type":"fn()","!doc":"Creates a new instance of a DistanceMatrixService that sends distance matrix queries to Google servers.","prototype":{"getDistanceMatrix":{"!type":"fn(request: +google.maps.DistanceMatrixRequest, callback: fn())","!doc":"Issues a distance matrix request."}}},"DistanceMatrixRequest":{},"DistanceMatrixResponse":{},"DistanceMatrixResponseRow":{},"DistanceMatrixResponseElement":{},"DistanceMatrixStatus":{},"DistanceMatrixElementStatus":{},"MapType":{"prototype":{"getTile":{"!type":"fn(tileCoord: +google.maps.Point, zoom: number, ownerDocument: +Document) -> +Node","!doc":"Returns a tile for the given tile coordinate (x, y) and zoom level. This tile will be appended to the given ownerDocument. Not available for base map types."},"releaseTile":{"!type":"fn(tile: +Node)","!doc":"Releases the given tile, performing any necessary cleanup. The provided tile will have already been removed from the document. Optional."}}},"MapTypeRegistry":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"The MapTypeRegistry holds the collection of custom map types available to the map for its use. The API consults this registry when providing the list of avaiable map types within controls, for example.","prototype":{"set":{"!type":"fn(id: string, mapType: +google.maps.MapType)","!doc":"Sets the registry to associate the passed string identifier with the passed MapType."}}},"Projection":{"prototype":{"fromLatLngToPoint":{"!type":"fn(latLng: +google.maps.LatLng, point?: +google.maps.Point) -> +google.maps.Point","!doc":"Translates from the LatLng cylinder to the Point plane. This interface specifies a function which implements translation from given LatLng values to world coordinates on the map projection. The Maps API calls this method when it needs to plot locations on screen. Projection objects must implement this method."},"fromPointToLatLng":{"!type":"fn(pixel: +google.maps.Point, nowrap?: bool) -> +google.maps.LatLng","!doc":"This interface specifies a function which implements translation from world coordinates on a map projection to LatLng values. The Maps API calls this method when it needs to translate actions on screen to positions on the map. Projection objects must implement this method."}}},"ImageMapType":{"!proto":"google.maps.MVCObject","!type":"fn(opts: +google.maps.ImageMapTypeOptions)","!doc":"Constructs an ImageMapType using the provided ImageMapTypeOptions","prototype":{"getOpacity":{"!type":"fn() -> number","!doc":"Returns the opacity level (0 (transparent) to 1.0) of the ImageMapType tiles."},"getTile":{"!type":"fn(tileCoord: +google.maps.Point, zoom: number, ownerDocument: +Document) -> +Node"},"releaseTile":{"!type":"fn(tile: +Node)"},"setOpacity":{"!type":"fn(opacity: number)","!doc":"Sets the opacity level (0 (transparent) to 1.0) of the ImageMapType tiles."}}},"ImageMapTypeOptions":{"prototype":{"getTileUrl":{"!type":"fn(coordinate: +google.maps.Point, zoom: number) -> string","!doc":"Returns a string (URL) for given tile coordinate (x, y) and zoom level."}}},"StyledMapType":{"!proto":"google.maps.MVCObject","!type":"fn(styles: [+MapTypeStyle], options?: +google.maps.StyledMapTypeOptions)","!doc":"Creates a styled MapType with the specified options. The StyledMapType takes an array of MapTypeStyles, where each MapTypeStyle is applied to the map consecutively. A later MapTypeStyle that applies the same MapTypeStylers to the same selectors as an earlier MapTypeStyle will override the earlier MapTypeStyle.","prototype":{"getTile":{"!type":"fn(tileCoord: +google.maps.Point, zoom: number, ownerDocument: +Document) -> +Node"},"releaseTile":{"!type":"fn(tile: +Node)"}}},"StyledMapTypeOptions":{},"MapTypeStyle":{},"MapTypeStyleFeatureType":{},"MapTypeStyleElementType":{},"MapTypeStyler":{},"BicyclingLayer":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"A layer that displays bike lanes and paths and demotes large roads.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."}}},"FusionTablesLayer":{"!proto":"google.maps.MVCObject","!type":"fn(options: +google.maps.FusionTablesLayerOptions)","!doc":"A layer that displays data from a Fusion Table.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."},"setOptions":{"!type":"fn(options: +google.maps.FusionTablesLayerOptions)"}}},"FusionTablesLayerOptions":{},"FusionTablesQuery":{},"FusionTablesStyle":{},"FusionTablesHeatmap":{},"FusionTablesMarkerOptions":{},"FusionTablesPolygonOptions":{},"FusionTablesPolylineOptions":{},"FusionTablesMouseEvent":{},"FusionTablesCell":{},"KmlLayer":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.KmlLayerOptions)","!doc":"Creates a KmlLayer which renders the contents of the specified KML/KMZ file (https://developers.google.com/kml/documentation/kmlreference) or GeoRSS file (http://www.georss.org).","prototype":{"getDefaultViewport":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Get the default viewport for the layer being displayed."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Get the map on which the KML Layer is being rendered."},"getMetadata":{"!type":"fn() -> +google.maps.KmlLayerMetadata","!doc":"Get the metadata associated with this layer, as specified in the layer markup."},"getStatus":{"!type":"fn() -> +google.maps.KmlLayerStatus","!doc":"Get the status of the layer, set once the requested document has loaded."},"getUrl":{"!type":"fn() -> string","!doc":"Gets the URL of the KML file being displayed."},"getZIndex":{"!type":"fn() -> number","!doc":"Gets the z-index of the KML Layer."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the KML Layer on the specified map. If map is set to null, the layer is removed."},"setUrl":{"!type":"fn(url: string)","!doc":"Sets the URL of the KML file to display."},"setZIndex":{"!type":"fn(zIndex: number)","!doc":"Sets the z-index of the KML Layer."}}},"KmlLayerOptions":{},"KmlLayerMetadata":{},"KmlLayerStatus":{},"KmlMouseEvent":{},"KmlFeatureData":{},"KmlAuthor":{},"TrafficLayer":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"A layer that displays current road traffic.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."}}},"TransitLayer":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"A layer that displays transit lines.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."}}},"StreetViewPanorama":{"!proto":"google.maps.MVCObject","!type":"fn(container: +Node, opts?: +google.maps.StreetViewPanoramaOptions)","!doc":"Creates a panorama with the passed StreetViewPanoramaOptions.","prototype":{"getLinks":{"!type":"fn() -> [+StreetViewLink]","!doc":"Returns the set of navigation links for the Street View panorama."},"getPano":{"!type":"fn() -> string","!doc":"Returns the current panorama ID for the Street View panorama. This id is stable within the browser's current session only."},"getPhotographerPov":{"!type":"fn() -> +google.maps.StreetViewPov","!doc":"Returns the heading and pitch of the photographer when this panorama was taken. For Street View panoramas on the road, this also reveals in which direction the car was travelling. This data is available after the pano_changed event."},"getPosition":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the current LatLng position for the Street View panorama."},"getPov":{"!type":"fn() -> +google.maps.StreetViewPov","!doc":"Returns the current point of view for the Street View panorama."},"getStatus":{"!type":"fn() -> +google.maps.StreetViewStatus","!doc":"Returns the status of the panorama on completion of the setPosition() or setPano() request."},"getVisible":{"!type":"fn() -> bool","!doc":"Returns true if the panorama is visible. It does not specify whether Street View imagery is available at the specified position."},"getZoom":{"!type":"fn() -> number","!doc":"Returns the zoom level of the panorama. Fully zoomed-out is level 0, where the field of view is 180 degrees. Zooming in increases the zoom level."},"registerPanoProvider":{"!type":"fn(provider: fn() -> +google.maps.StreetViewPanoramaData)","!doc":"Set the custom panorama provider called on pano change to load custom panoramas."},"setOptions":{"!type":"fn(options: +google.maps.StreetViewPanoramaOptions)","!doc":"Sets a collection of key-value pairs."},"setPano":{"!type":"fn(pano: string)","!doc":"Sets the current panorama ID for the Street View panorama."},"setPosition":{"!type":"fn(latLng: +google.maps.LatLng)","!doc":"Sets the current LatLng position for the Street View panorama."},"setPov":{"!type":"fn(pov: +google.maps.StreetViewPov)","!doc":"Sets the point of view for the Street View panorama."},"setVisible":{"!type":"fn(flag: bool)","!doc":"Sets to true to make the panorama visible. If set to false, the panorama will be hidden whether it is embedded in the map or in its own <div>."},"setZoom":{"!type":"fn(zoom: number)","!doc":"Sets the zoom level of the panorama. Fully zoomed-out is level 0, where the field of view is 180 degrees. Zooming in increases the zoom level."}}},"StreetViewPanoramaOptions":{"prototype":{"panoProvider":{"!type":"fn(panoId: string) -> +google.maps.StreetViewPanoramaData","!doc":"Custom panorama provider, which takes a string pano id and returns an object defining the panorama given that id. This function must be defined to specify custom panorama imagery."}}},"StreetViewAddressControlOptions":{},"StreetViewLink":{},"StreetViewPov":{},"StreetViewPanoramaData":{},"StreetViewLocation":{},"StreetViewTileData":{"prototype":{"getTileUrl":{"!type":"fn(pano: string, tileZoom: number, tileX: number, tileY: number) -> string","!doc":"Gets the tile image URL for the specified tile. pano is the panorama ID of the Street View tile. tileZoom is the zoom level of the tile. tileX is the x-coordinate of the tile. tileY is the y-coordinate of the tile. Returns the URL for the tile image."}}},"StreetViewService":{"prototype":{"getPanoramaById":{"!type":"fn(pano: string, callback: fn())","!doc":"Retrieves the data for the given pano id and passes it to the provided callback as a StreetViewPanoramaData object. Pano ids are unique per panorama and stable for the lifetime of a session, but are liable to change between sessions."},"getPanoramaByLocation":{"!type":"fn(latlng: +google.maps.LatLng, radius: number, callback: fn())","!doc":"Retrieves the StreetViewPanoramaData for a panorama within a given radius of the given LatLng. The StreetViewPanoramaData is passed to the provided callback. If the radius is less than 50 meters, the nearest panorama will be returned."}}},"StreetViewStatus":{},"StreetViewCoverageLayer":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"Creates a new instance of StreetViewCoverageLayer.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If the map is set to null, the layer will be removed."}}},"MapsEventListener":{},"event":{"addDomListener":{"!type":"fn(instance: ?, eventName: string, handler: +Function, capture?: bool) -> +google.maps.MapsEventListener","!doc":"Cross browser event handler registration. This listener is removed by calling removeListener(handle) for the handle that is returned by this function."},"addDomListenerOnce":{"!type":"fn(instance: ?, eventName: string, handler: +Function, capture?: bool) -> +google.maps.MapsEventListener","!doc":"Wrapper around addDomListener that removes the listener after the first event."},"addListener":{"!type":"fn(instance: ?, eventName: string, handler: +Function) -> +google.maps.MapsEventListener","!doc":"Adds the given listener function to the given event name for the given object instance. Returns an identifier for this listener that can be used with removeListener()."},"addListenerOnce":{"!type":"fn(instance: ?, eventName: string, handler: +Function) -> +google.maps.MapsEventListener","!doc":"Like addListener, but the handler removes itself after handling the first event."},"clearInstanceListeners":{"!type":"fn(instance: ?)","!doc":"Removes all listeners for all events for the given instance."},"clearListeners":{"!type":"fn(instance: ?, eventName: string)","!doc":"Removes all listeners for the given event for the given instance."},"removeListener":{"!type":"fn(listener: +google.maps.MapsEventListener)","!doc":"Removes the given listener, which should have been returned by addListener above."},"trigger":{"!type":"fn(instance: ?, eventName: string, var_args: ?)","!doc":"Triggers the given event. All arguments after eventName are passed as arguments to the listeners."}},"MouseEvent":{"prototype":{"stop":{"!type":"fn()","!doc":"Prevents this event from propagating further."}}},"LatLng":{"!type":"fn(lat: number, lng: number, noWrap?: bool)","!doc":"Creates a LatLng object representing a geographic point. Latitude is specified in degrees within the range [-90, 90]. Longitude is specified in degrees within the range [-180, 180]. Set noWrap to true to enable values outside of this range. Note the ordering of latitude and longitude.","prototype":{"equals":{"!type":"fn(other: +google.maps.LatLng) -> bool","!doc":"Comparison function."},"lat":{"!type":"fn() -> number","!doc":"Returns the latitude in degrees."},"lng":{"!type":"fn() -> number","!doc":"Returns the longitude in degrees."},"toString":{"!type":"fn() -> string","!doc":"Converts to string representation."},"toUrlValue":{"!type":"fn(precision?: number) -> string","!doc":"Returns a string of the form \"lat,lng\" for this LatLng. We round the lat/lng values to 6 decimal places by default."}}},"LatLngLiteral":{},"LatLngBounds":{"!type":"fn(sw?: +google.maps.LatLng, ne?: +google.maps.LatLng)","!doc":"Constructs a rectangle from the points at its south-west and north-east corners.","prototype":{"contains":{"!type":"fn(latLng: +google.maps.LatLng) -> bool","!doc":"Returns true if the given lat/lng is in this bounds."},"equals":{"!type":"fn(other: +google.maps.LatLngBounds) -> bool","!doc":"Returns true if this bounds approximately equals the given bounds."},"extend":{"!type":"fn(point: +google.maps.LatLng) -> +google.maps.LatLngBounds","!doc":"Extends this bounds to contain the given point."},"getCenter":{"!type":"fn() -> +google.maps.LatLng","!doc":"Computes the center of this LatLngBounds"},"getNorthEast":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the north-east corner of this bounds."},"getSouthWest":{"!type":"fn() -> +google.maps.LatLng","!doc":"Returns the south-west corner of this bounds."},"intersects":{"!type":"fn(other: +google.maps.LatLngBounds) -> bool","!doc":"Returns true if this bounds shares any points with this bounds."},"isEmpty":{"!type":"fn() -> bool","!doc":"Returns if the bounds are empty."},"toSpan":{"!type":"fn() -> +google.maps.LatLng","!doc":"Converts the given map bounds to a lat/lng span."},"toString":{"!type":"fn() -> string","!doc":"Converts to string."},"toUrlValue":{"!type":"fn(precision?: number) -> string","!doc":"Returns a string of the form \"lat_lo,lng_lo,lat_hi,lng_hi\" for this bounds, where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box."},"union":{"!type":"fn(other: +google.maps.LatLngBounds) -> +google.maps.LatLngBounds","!doc":"Extends this bounds to contain the union of this and the given bounds."}}},"Point":{"!type":"fn(x: number, y: number)","!doc":"A point on a two-dimensional plane.","prototype":{"equals":{"!type":"fn(other: +google.maps.Point) -> bool","!doc":"Compares two Points"},"toString":{"!type":"fn() -> string","!doc":"Returns a string representation of this Point."}}},"Size":{"!type":"fn(width: number, height: number, widthUnit?: string, heightUnit?: string)","!doc":"Two-dimensonal size, where width is the distance on the x-axis, and height is the distance on the y-axis.","prototype":{"equals":{"!type":"fn(other: +google.maps.Size) -> bool","!doc":"Compares two Sizes."},"toString":{"!type":"fn() -> string","!doc":"Returns a string representation of this Size."}}},"MVCObject":{"!type":"fn()","!doc":"Creates an MVCObject.","prototype":{"addListener":{"!type":"fn(eventName: string, handler: +Function) -> +google.maps.MapsEventListener","!doc":"Adds the given listener function to the given event name. Returns an identifier for this listener that can be used with google.maps.event.removeListener."},"bindTo":{"!type":"fn(key: string, target: +google.maps.MVCObject, targetKey?: string, noNotify?: bool)","!doc":"Binds a View to a Model."},"changed":{"!type":"fn(key: string)","!doc":"Generic handler for state changes. Override this in derived classes to handle arbitrary state changes."},"get":{"!type":"fn(key: string) -> ?","!doc":"Gets a value."},"notify":{"!type":"fn(key: string)","!doc":"Notify all observers of a change on this property. This notifies both objects that are bound to the object's property as well as the object that it is bound to."},"set":{"!type":"fn(key: string, value: ?)","!doc":"Sets a value."},"setValues":{"!type":"fn(values: ?)","!doc":"Sets a collection of key-value pairs."},"unbind":{"!type":"fn(key: string)","!doc":"Removes a binding. Unbinding will set the unbound property to the current value. The object will not be notified, as the value has not changed."},"unbindAll":{"!type":"fn()","!doc":"Removes all bindings."}}},"MVCArray":{"!proto":"google.maps.MVCObject","!type":"fn(array?: +Array)","!doc":"A mutable MVC Array.","prototype":{"clear":{"!type":"fn()","!doc":"Removes all elements from the array."},"forEach":{"!type":"fn(callback: fn())","!doc":"Iterate over each element, calling the provided callback. The callback is called for each element like: callback(element, index)."},"getArray":{"!type":"fn() -> +Array","!doc":"Returns a reference to the underlying Array. Warning: if the Array is mutated, no events will be fired by this object."},"getAt":{"!type":"fn(i: number) -> ?","!doc":"Returns the element at the specified index."},"getLength":{"!type":"fn() -> number","!doc":"Returns the number of elements in this array."},"insertAt":{"!type":"fn(i: number, elem: ?)","!doc":"Inserts an element at the specified index."},"pop":{"!type":"fn() -> ?","!doc":"Removes the last element of the array and returns that element."},"push":{"!type":"fn(elem: ?) -> number","!doc":"Adds one element to the end of the array and returns the new length of the array."},"removeAt":{"!type":"fn(i: number) -> ?","!doc":"Removes an element from the specified index."},"setAt":{"!type":"fn(i: number, elem: ?)","!doc":"Sets an element at the specified index."}}},"geometry":{"encoding":{"decodePath":{"!type":"fn(encodedPath: string) -> [+LatLng]","!doc":"Decodes an encoded path string into a sequence of LatLngs."},"encodePath":{"!type":"fn(path: [+LatLng]) -> string","!doc":"Encodes a sequence of LatLngs into an encoded path string."}},"spherical":{"computeArea":{"!type":"fn(path: [+LatLng], radius?: number) -> number","!doc":"Returns the area of a closed path. The computed area uses the same units as the radius. The radius defaults to the Earth's radius in meters, in which case the area is in square meters."},"computeDistanceBetween":{"!type":"fn(from: +google.maps.LatLng, to: +google.maps.LatLng, radius?: number) -> number","!doc":"Returns the distance between two LatLngs."},"computeHeading":{"!type":"fn(from: +google.maps.LatLng, to: +google.maps.LatLng) -> number","!doc":"Returns the heading from one LatLng to another LatLng. Headings are expressed in degrees clockwise from North within the range [-180,180)."},"computeLength":{"!type":"fn(path: [+LatLng], radius?: number) -> number","!doc":"Returns the length of the given path."},"computeOffset":{"!type":"fn(from: +google.maps.LatLng, distance: number, heading: number, radius?: number) -> +google.maps.LatLng","!doc":"Returns the LatLng resulting from moving a distance from an origin in the specified heading (expressed in degrees clockwise from north)."},"computeOffsetOrigin":{"!type":"fn(to: +google.maps.LatLng, distance: number, heading: number, radius?: number) -> +google.maps.LatLng","!doc":"Returns the location of origin when provided with a LatLng destination, meters travelled and original heading. Headings are expressed in degrees clockwise from North. This function returns null when no solution is available."},"computeSignedArea":{"!type":"fn(loop: [+LatLng], radius?: number) -> number","!doc":"Returns the signed area of a closed path. The signed area may be used to determine the orientation of the path. The computed area uses the same units as the radius. The radius defaults to the Earth's radius in meters, in which case the area is in square meters."},"interpolate":{"!type":"fn(from: +google.maps.LatLng, to: +google.maps.LatLng, fraction: number) -> +google.maps.LatLng","!doc":"Returns the LatLng which lies the given fraction of the way between the origin LatLng and the destination LatLng."}},"poly":{"containsLocation":{"!type":"fn(point: +google.maps.LatLng, polygon: +google.maps.Polygon) -> bool","!doc":"Computes whether the given point lies inside the specified polygon."},"isLocationOnEdge":{"!type":"fn(point: +google.maps.LatLng, poly: +google.maps.Polygon, tolerance?: number) -> bool","!doc":"Computes whether the given point lies on or near to a polyline, or the edge of a polygon, within a specified tolerance. Returns true when the difference between the latitude and longitude of the supplied point, and the closest point on the edge, is less than the tolerance. The tolerance defaults to 10-9 degrees."}}},"adsense":{"AdUnit":{"!proto":"google.maps.MVCObject","!type":"fn(container: +Node, opts: +google.maps.adsense.AdUnitOptions)","!doc":"Creates an AdSense for Content display ad on the associated map.","prototype":{"getBackgroundColor":{"!type":"fn() -> string","!doc":"Returns the AdUnit's background color."},"getBorderColor":{"!type":"fn() -> string","!doc":"Returns the AdUnit's border color."},"getChannelNumber":{"!type":"fn() -> string","!doc":"Returns the channel number in use by this AdUnit."},"getContainer":{"!type":"fn() -> +Node","!doc":"Returns the containing element of the AdUnit."},"getFormat":{"!type":"fn() -> +google.maps.adsense.AdFormat","!doc":"Returns the format in use by this AdUnit."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map to which this AdUnit's ads are targeted."},"getPosition":{"!type":"fn() -> +google.maps.ControlPosition","!doc":"Returns the ControlPosition at which this AdUnit is displayed on the map."},"getPublisherId":{"!type":"fn() -> string","!doc":"Returns the specified AdSense For Content publisher ID."},"getTextColor":{"!type":"fn() -> string","!doc":"Returns the AdUnit's text color."},"getTitleColor":{"!type":"fn() -> string","!doc":"Returns the AdUnit's title color."},"getUrlColor":{"!type":"fn() -> string","!doc":"Returns the AdUnit's URL color."},"setBackgroundColor":{"!type":"fn(backgroundColor: string)","!doc":"Sets the AdUnit's background color."},"setBorderColor":{"!type":"fn(borderColor: string)","!doc":"Sets the AdUnit's border color."},"setChannelNumber":{"!type":"fn(channelNumber: string)","!doc":"Specifies the channel number for this AdUnit. Channel numbers are optional and can be created for Google AdSense tracking."},"setFormat":{"!type":"fn(format: +google.maps.adsense.AdFormat)","!doc":"Specifies the display format for this AdUnit."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Associates this AdUnit with the specified map. Ads will be targeted to the map's viewport. The map must be specified in order to display ads."},"setPosition":{"!type":"fn(position: +google.maps.ControlPosition)","!doc":"Sets the ControlPosition at which to display the AdUnit on the map. If the position is set to null, the AdUnit is removed from the map."},"setTextColor":{"!type":"fn(textColor: string)","!doc":"Sets the AdUnit's text color."},"setTitleColor":{"!type":"fn(titleColor: string)","!doc":"Sets the AdUnit's title color."},"setUrlColor":{"!type":"fn(urlColor: string)","!doc":"Sets the AdUnit's URL color."}}},"AdUnitOptions":{},"AdFormat":{}},"panoramio":{"PanoramioLayer":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.panoramio.PanoramioLayerOptions)","!doc":"A layer that displays data from Panoramio.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"getTag":{"!type":"fn() -> string"},"getUserId":{"!type":"fn() -> string"},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."},"setOptions":{"!type":"fn(options: +google.maps.panoramio.PanoramioLayerOptions)"},"setTag":{"!type":"fn(tag: string)"},"setUserId":{"!type":"fn(userId: string)"}}},"PanoramioLayerOptions":{},"PanoramioFeature":{},"PanoramioMouseEvent":{}},"places":{"Autocomplete":{"!proto":"google.maps.MVCObject","!type":"fn(inputField: +HTMLInputElement, opts?: +google.maps.places.AutocompleteOptions)","!doc":"Creates a new instance of Autocomplete that attaches to the specified input text field with the given options.","prototype":{"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Returns the bounds to which predictions are biased."},"getPlace":{"!type":"fn() -> +google.maps.places.PlaceResult","!doc":"Returns the details of the Place selected by user if the details were successfully retrieved. Otherwise returns a stub Place object, with the name property set to the current value of the input field."},"setBounds":{"!type":"fn(bounds: +google.maps.LatLngBounds)","!doc":"Sets the preferred area within which to return Place results. Results are biased towards, but not restricted to, this area."},"setComponentRestrictions":{"!type":"fn(restrictions: +google.maps.places.ComponentRestrictions)","!doc":"Sets the component restrictions. Component restrictions are used to restrict predictions to only those within the parent component. E.g., the country."},"setTypes":{"!type":"fn(types: [string])","!doc":"Sets the types of predictions to be returned. Supported types are 'establishment' for businesses and 'geocode' for addresses. If no type is specified, both types will be returned. The setTypes method accepts a single element array."}}},"AutocompleteOptions":{},"AutocompletePrediction":{},"PredictionTerm":{},"PredictionSubstring":{},"AutocompleteService":{"!type":"fn()","!doc":"Creates a new instance of the AutocompleteService.","prototype":{"getPlacePredictions":{"!type":"fn(request: +google.maps.places.AutocompletionRequest, callback: fn())","!doc":"Retrieves place autocomplete predictions based on the supplied autocomplete request."},"getQueryPredictions":{"!type":"fn(request: +google.maps.places.QueryAutocompletionRequest, callback: fn())","!doc":"Retrieves query autocomplete predictions based on the supplied query autocomplete request."}}},"AutocompletionRequest":{},"ComponentRestrictions":{},"PlaceAspectRating":{},"PlaceDetailsRequest":{},"PlaceGeometry":{},"PlacePhoto":{"prototype":{"getUrl":{"!type":"fn(opts: +google.maps.places.PhotoOptions) -> string","!doc":"Returns the image URL corresponding to the specified options. You must include a PhotoOptions object with at least one of maxWidth or maxHeight specified."}}},"PhotoOptions":{},"PlaceResult":{},"PlaceReview":{},"PlaceSearchPagination":{"prototype":{"nextPage":{"!type":"fn()","!doc":"Fetches the next page of results. Uses the same callback function that was provided to the first search request."}}},"PlaceSearchRequest":{},"PlacesService":{"!type":"fn(attrContainer: +HTMLDivElement)","!doc":"Creates a new instance of the PlacesService that renders attributions in the specified container.","prototype":{"getDetails":{"!type":"fn(request: +google.maps.places.PlaceDetailsRequest, callback: fn())","!doc":"Retrieves details about the Place identified by the given reference."},"nearbySearch":{"!type":"fn(request: +google.maps.places.PlaceSearchRequest, callback: fn())","!doc":"Retrieves a list of Places in a given area. The PlaceResults passed to the callback are stripped-down versions of a full PlaceResult. A more detailed PlaceResult for each Place can be obtained by sending a Place Details request with the desired Place's reference value."},"radarSearch":{"!type":"fn(request: +google.maps.places.RadarSearchRequest, callback: fn())","!doc":"Similar to the nearbySearch function, with the following differences: the search response will include up to 200 Places, identified only by their geographic coordinates and Place reference."},"textSearch":{"!type":"fn(request: +google.maps.places.TextSearchRequest, callback: fn())","!doc":"Similar to the nearbySearch function, with the following differences: it retrieves a list of Places based on the query attribute in the given request object; bounds or location  + radius parameters are optional; and the region, when provided, will not restrict the results to places inside the area, only bias the response towards results near it."}}},"PlacesServiceStatus":{},"QueryAutocompletePrediction":{},"QueryAutocompletionRequest":{},"RadarSearchRequest":{},"RankBy":{},"SearchBox":{"!proto":"google.maps.MVCObject","!type":"fn(inputField: +HTMLInputElement, opts?: +google.maps.places.SearchBoxOptions)","!doc":"Creates a new instance of SearchBox that attaches to the specified input text field with the given options.","prototype":{"getBounds":{"!type":"fn() -> +google.maps.LatLngBounds","!doc":"Returns the bounds to which query predictions are biased."},"getPlaces":{"!type":"fn() -> [+PlaceResult]","!doc":"Returns the query selected by the user, or null if no places have been found yet, to be used with places_changed event."},"setBounds":{"!type":"fn(bounds: +google.maps.LatLngBounds)","!doc":"Sets the region to use for biasing query predictions. Results will only be biased towards this area and not be completely restricted to it."}}},"SearchBoxOptions":{},"TextSearchRequest":{}},"drawing":{"DrawingManager":{"!proto":"google.maps.MVCObject","!type":"fn(options?: +google.maps.drawing.DrawingManagerOptions)","!doc":"Creates a DrawingManager that allows users to draw overlays on the map, and switch between the type of overlay to be drawn with a drawing control.","prototype":{"getDrawingMode":{"!type":"fn() -> +google.maps.drawing.OverlayType","!doc":"Returns the DrawingManager's drawing mode."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the Map to which the DrawingManager is attached, which is the Map on which the overlays created will be placed."},"setDrawingMode":{"!type":"fn(drawingMode: +google.maps.drawing.OverlayType)","!doc":"Changes the DrawingManager's drawing mode, which defines the type of overlay to be added on the map. Accepted values are MARKER, POLYGON, POLYLINE, RECTANGLE, CIRCLE, or null. A drawing mode of null means that the user can interact with the map as normal, and clicks do not draw anything."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Attaches the DrawingManager object to the specified Map."},"setOptions":{"!type":"fn(options: +google.maps.drawing.DrawingManagerOptions)","!doc":"Sets the DrawingManager's options."}}},"DrawingManagerOptions":{},"DrawingControlOptions":{},"OverlayCompleteEvent":{},"OverlayType":{}},"weather":{"CloudLayer":{"!proto":"google.maps.MVCObject","!type":"fn()","!doc":"Creates a new CloudLayer instance that displays a cloud overlay.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."}}},"WeatherLayer":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.weather.WeatherLayerOptions)","!doc":"Creates a new WeatherLayer instance that displays weather icons.","prototype":{"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."},"setOptions":{"!type":"fn(options: +google.maps.weather.WeatherLayerOptions)","!doc":"Sets the WeatherLayer's options."}}},"WeatherLayerOptions":{},"TemperatureUnit":{},"WindSpeedUnit":{},"LabelColor":{},"WeatherMouseEvent":{},"WeatherFeature":{},"WeatherConditions":{},"WeatherForecast":{}},"visualization":{"MapsEngineLayer":{"!proto":"google.maps.MVCObject","!type":"fn(options: +google.maps.visualization.MapsEngineLayerOptions)","!doc":"Creates a new instance of MapsEngineLayer.","prototype":{"getLayerId":{"!type":"fn() -> string","!doc":"Returns the ID of the Maps Engine layer being displayed, if set."},"getLayerKey":{"!type":"fn() -> string","!doc":"Returns the key of the layer to be displayed."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"getMapId":{"!type":"fn() -> string","!doc":"Returns the ID of the Maps Engine map to which the layer belongs."},"getOpacity":{"!type":"fn() -> number","!doc":"Returns the opacity of the layer. Applies only to imagery layers."},"getProperties":{"!type":"fn() -> +google.maps.visualization.MapsEngineLayerProperties","!doc":"Returns properties of the Maps Engine layer, which are available once the layer has loaded."},"getStatus":{"!type":"fn() -> +google.maps.visualization.MapsEngineStatus","!doc":"Returns the status of the layer, which is available once the requested layer has loaded."},"getZIndex":{"!type":"fn() -> number","!doc":"Returns the z-index."},"setLayerId":{"!type":"fn(layerId: string)","!doc":"Sets the ID of a single Maps Engine layer to display. Changing this value will cause the layer to be redrawn."},"setLayerKey":{"!type":"fn(layerKey: string)","!doc":"Sets the key of the layer to be displayed. Maps Engine layer keys are only unique within a single map, and can be changed by map owners. Changing this value will cause the layer to be redrawn."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."},"setMapId":{"!type":"fn(mapId: string)","!doc":"Sets the ID of the Maps Engine map that contains the layer with the given layerKey. Changing this value will cause the layer to be redrawn."},"setOpacity":{"!type":"fn(opacity: number)","!doc":"Sets the opacity of the layer, expressed as a number between 0 and 1. Applies only to imagery layers. Note: Be careful of setting this option for other layer types, as it may become effective in the future."},"setOptions":{"!type":"fn(options: +google.maps.visualization.MapsEngineLayerOptions)"},"setZIndex":{"!type":"fn(zIndex: number)","!doc":"Sets the z-index. Only applies to Vector and KML layers."}}},"MapsEngineLayerOptions":{},"MapsEngineLayerProperties":{},"MapsEngineMouseEvent":{},"MapsEngineStatus":{},"DynamicMapsEngineLayer":{"!proto":"google.maps.MVCObject","!type":"fn(options: +google.maps.visualization.DynamicMapsEngineLayerOptions)","!doc":"Creates a new instance of DynamicMapsEngineLayer.","prototype":{"getFeatureStyle":{"!type":"fn(featureId: string) -> +google.maps.visualization.FeatureStyle","!doc":"Returns the style for the given feature, with which individual style properties can be retrieved or set."},"getLayerId":{"!type":"fn() -> string","!doc":"Returns the ID of the Maps Engine layer being displayed, if set."},"getLayerKey":{"!type":"fn() -> string","!doc":"Returns the key of the layer to be displayed."},"getMap":{"!type":"fn() -> +google.maps.Map","!doc":"Returns the map on which this layer is displayed."},"getMapId":{"!type":"fn() -> string","!doc":"Returns the ID of the Maps Engine map to which the layer belongs."},"getOpacity":{"!type":"fn() -> number","!doc":"Returns the opacity of the layer. Applies only to imagery layers."},"getStatus":{"!type":"fn() -> +google.maps.visualization.MapsEngineStatus","!doc":"Returns the status of the layer, set once the requested layer has loaded."},"setLayerId":{"!type":"fn(layerId: string)","!doc":"Sets the ID of a single Maps Engine layer to display."},"setLayerKey":{"!type":"fn(layerKey: string)","!doc":"Sets the key of the layer to be displayed. Maps Engine Layer Keys are only unique within a single map, and can be changed by map owners. Changing this value will cause the layer to be redrawn."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the layer on the specified map. If map is set to null, the layer will be removed."},"setMapId":{"!type":"fn(mapId: string)","!doc":"Sets the ID of the Maps Engine map to which the layer belongs. Changing this value will cause the layer to be redrawn."},"setOpacity":{"!type":"fn(opacity: number)","!doc":"Sets the opacity of the layer, expressed as a number between 0 and 1. Applies only to imagery layers. Note: Be careful of setting this option for other layer types, as it may become effective in the future."},"setOptions":{"!type":"fn(options: +google.maps.visualization.DynamicMapsEngineLayerOptions)"}}},"DynamicMapsEngineLayerOptions":{},"DynamicMapsEngineMouseEvent":{"prototype":{"getDetails":{"!type":"fn(callback: fn())","!doc":"Takes a callback that will be called with details about the feature that may be used to render an info window."}}},"FeatureStyle":{"prototype":{"reset":{"!type":"fn(property: string)","!doc":"Resets the given style property to its original value."},"resetAll":{"!type":"fn()","!doc":"Resets all style properties to their original values."}}},"HeatmapLayer":{"!proto":"google.maps.MVCObject","!type":"fn(opts?: +google.maps.visualization.HeatmapLayerOptions)","!doc":"Creates a new instance of HeatmapLayer.","prototype":{"getData":{"!type":"fn() -> +MVCArray.<LatLng","!doc":"Returns the data points currently displayed by this heatmap."},"getMap":{"!type":"fn() -> +google.maps.Map"},"setData":{"!type":"fn(data: +MVCArray.<LatLng)","!doc":"Sets the data points to be displayed by this heatmap."},"setMap":{"!type":"fn(map: +google.maps.Map)","!doc":"Renders the heatmap on the specified map. If map is set to null, the heatmap will be removed."}}},"HeatmapLayerOptions":{},"WeightedLocation":{}}}}}

});  
