(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("../lib/infer"), require("../lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define(["../lib/infer", "../lib/tern"], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";
  
  function Component() {
    this.use = null;
  }
  
  function getComponent(data, name) {
    return data.components[name];// || (data.modules[name] = new infer.AVal);
  }
  
  function Module() {
    this.def = null;
    this.requires = null;
  }
  
  function getOrCreateModule(data, name) {
    var module = data.modules[name];
    if (!module) {
      module = new Module();
      data.modules[name] = module;
    }
    return module;
  }
  
  function getModule(data, name) {
    if (!data.initialized) {
      //infer.def.load(yuiOop);
      //infer.def.load(yuiEventAndNode);
      data.initialized = true;
    }    
    return data.modules[name];// || (data.modules[name] = new infer.AVal);
  }
  
  function injectModule(Y, name) {
    var cx = infer.cx(), server = cx.parent, data = server._yui, module = getModule(data, name);
    if (module) { 
      var def = module.def, requires = module.requires;
      if (def) {
        def.getType().propagate(Y);        
      }
      if (requires) {
        for ( var i = 0; i < requires.length; i++) {
          var moduleName = requires[i];
          injectModule(Y, moduleName);
        }
      }
    } else {
      var component = getComponent(data, name);
      if (component && component.use) {
        for ( var i = 0; i < component.use.length; i++) {
          var moduleName = component.use[i];
          injectModule(Y, moduleName);
        }
      }
    }
  }
  
  function getFnIndex(argNodes) {
    for ( var i = 0; i < argNodes.length; i++) {
      if (argNodes[i].type == "FunctionExpression") {
        return i;
      }
    }
  }
  
  infer.registerFunction("yui_add", function(self, args, argNodes) {
    var yui = self.getType();
    if (yui && argNodes) {
      var index = getFnIndex(argNodes);
      if (index) {
        var fn = args[index];
        if (fn.argNames  && fn.argNames.length > 0) {        
          var Y = fn.args[0];
          yui.getProp("prototype").getType().propagate(Y); 
        }
      }      
    }
  });
  
  infer.registerFunction("yui_use", function(self, args, argNodes) {
    var yui = self.getType();
    if (yui && argNodes) {
      var index = getFnIndex(argNodes);
      if (index) {
        var fn = args[index];
        if (fn.argNames  && fn.argNames.length > 0) {              
          var Y = fn.args[0];
          yui.propagate(Y);        
          
          var cx = infer.cx(), defs = cx.definitions["aui"];
		  for(var d in defs) {
			defs[d].getType().propagate(Y);
		  }
          //defs['event'].getType().propagate(Y);
          //defs['node'].getType().propagate(Y);  
          
          for ( var i = 0; i < argNodes.length - 1; i++) {
            var node = argNodes[i];
            if (node.type == "Literal" && typeof node.value == "string") {
              injectModule(Y, node.value);
            } else if (node.type == "ArrayExpression") for (var i = 0; i < node.elements.length; ++i) {
              var elt = node.elements[i];
              if (elt.type == "Literal" && typeof elt.value == "string") {
                injectModule(Y, elt.value);
              }
            }
          }
        }        
      }
    }
  });
  
  function preCondenseReach(state) {
    
  }

  function postLoadDef(json) {
    var cx = infer.cx(), defName = json["!name"], defs = cx.definitions[defName], server = cx.parent, _yui = server._yui, yuiModule = defName && defName.slice(0, 'yui-'.length) == 'yui-';
    if (defs && yuiModule) for (var name in defs) {
      var obj = defs[name].getType();
      if (obj.metaData) {
        // it's a component
        var metaData = obj.metaData, componentName = null;
        for ( componentName in metaData) {
          var c = metaData[componentName];
          for(var prop in c) {
            switch(prop) {
            case 'plugins':
              break;
            case 'submodules':
              var submodules = c[prop];
              for ( var submoduleName in submodules) {
                var submodule = submodules[submoduleName];
                var module = getOrCreateModule(_yui, submoduleName);
                module.requires = submodule.requires;
              }
              break;
            case 'use':
              var component = new Component();
              component.use = c[prop];
              _yui.components[componentName] = component;
              break;            
            }
          } 
        }       
      } else {
        // it's a module
        var moduleName = name.replace(/_/g, '-')
        var module = getOrCreateModule(_yui, moduleName);
        module.def = obj;
      }
    }
  }

  tern.registerPlugin("aui", function(server, options) {
    server._yui = {
        components: Object.create(null),
        modules: Object.create(null)
    };
    
    server.on("reset", function() {
      this._yui.initialized = false;
      this._yui.modules = Object.create(null);      
    });
    
    return {
      defs: defs,
      passes: {
        preCondenseReach: preCondenseReach,
        postLoadDef: postLoadDef
      },
    };
  });
  
  var defs = {
 "!name": "aui",
 "!define": {
  "aui_ace_editor": {
   "A.AceEditor.AutoCompleteBase": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor.AutoCompleteBase",
    "!doc": "A base class for AutoCompleteBase.",
    "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html",
    "FILL_MODE_INSERT": {
     "!type": "?",
     "!doc": "Exposes a constant for insert fill mode. See `fillMode` for more information.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#property_FILL_MODE_INSERT"
    },
    "FILL_MODE_OVERWRITE": {
     "!type": "?",
     "!doc": "Exposes a constant for overwrite fill mode. See `fillMode` for more\ninformation.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#property_FILL_MODE_OVERWRITE"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for AutoCompleteBase.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#property_ATTRS"
    },
    "prototype": {
     "fillMode": {
      "!type": "fn()",
      "!doc": "The mode in which the AutoComplete should operate. Can be one of these:\nINSERT - value '0' or OVERWRITE - value '1'. In case of INSERT mode, when\nEditor adds a suggestion, it will be added next to the matched\nexpression. In case of OVERWRITE mode, the suggestion will overwrite the\nmatched expression.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#attribute_fillMode"
     },
     "filters": {
      "!type": "fn()",
      "!doc": "Provides an array of filter functions which will filter the results. By\ndefault there is one function which provides phrase match filtering.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#attribute_filters"
     },
     "processor": {
      "!type": "fn()",
      "!doc": "The default processor which will be used to process matches.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#attribute_processor"
     },
     "showListKey": {
      "!type": "fn()",
      "!doc": "The keyboard combination which should be used to show the list with found\nresults.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#attribute_showListKey"
     },
     "sorters": {
      "!type": "fn()",
      "!doc": "Provides an array of sorter functions which will sort the results. By\ndefault there is one function which sorts the results in ascending order.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteBase.html#attribute_sorters"
     }
    }
   },
   "A.AceEditor.AutoCompleteFreemarker": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor.AutoCompleteFreemarker",
    "!proto": "aui_ace_editor.A.AceEditor.TemplateProcessor",
    "!doc": "A base class for Freemarker plugin.",
    "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html",
    "prototype": {
     "getMatch": {
      "!type": "fn(content: string) -> +yui.Object",
      "!doc": "Checks if the provided content contains directive or variable.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#method_getMatch"
     },
     "directives": {
      "!type": "fn()",
      "!doc": "Contains the list of supported directives according to Freemarker\nspecification.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#attribute_directives"
     },
     "directivesMatcher": {
      "!type": "fn()",
      "!doc": "Contains the regular expression which checks for directive\npresence.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#attribute_directivesMatcher"
     },
     "host": {
      "!type": "fn()",
      "!doc": "The Editor in which the current instance is plugged.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#attribute_host"
     },
     "variables": {
      "!type": "fn()",
      "!doc": "Contains the supported variables.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#attribute_variables"
     },
     "variablesMatcher": {
      "!type": "fn()",
      "!doc": "Contains the regular expression which will check for variable\nmatch.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#attribute_variablesMatcher"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Freemarker.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteFreemarker.html#property_ATTRS"
    }
   },
   "A.AceEditor.AutoCompleteList": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor.AutoCompleteList",
    "!proto": "overlay.Overlay",
    "!doc": "A base class for AutoCompleteList.",
    "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the AutoCompleteList.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#property_ATTRS"
    },
    "prototype": {
     "host": {
      "!type": "fn()",
      "!doc": "The Editor in which the current instance is plugged.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_host"
     },
     "listNode": {
      "!type": "fn()",
      "!doc": "A Node in which results will be shown.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_listNode"
     },
     "loadingMessage": {
      "!type": "fn()",
      "!doc": "A string, representing the loading message.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_loadingMessage"
     },
     "results": {
      "!type": "fn()",
      "!doc": "Contains the current set of results in the list.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_results"
     },
     "selectedEntry": {
      "!type": "fn()",
      "!doc": "Provides the currently selected entry.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_selectedEntry"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#attribute_strings"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "The prefix of all CSS Classes.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#property_CSS_PREFIX"
    },
    "HTML_PARSER": {
     "!type": "?",
     "!doc": "Object hash, defining how attribute values are to be parsed from\nmarkup contained in the widget's content box.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteList.html#property_HTML_PARSER"
    }
   },
   "A.AceEditor.TemplateProcessor": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor.TemplateProcessor",
    "!proto": "base.Base",
    "!doc": "A base class for TemplateProcessor.",
    "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html",
    "prototype": {
     "getResults": {
      "!type": "fn(match: yui.Object, callbackSuccess: fn(), callbackError: fn())",
      "!doc": "Accepts match and depending on its type processes directives or\nvariables. In case of success, calls the provided success callback,\nor the error callback otherwise.",
      "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#method_getResults"
     },
     "getSuggestion": {
      "!type": "fn(match: yui.Object, selectedSuggestion: string) -> string",
      "!doc": "Formats the selected suggestion depending on the match type and\ncurrently selected editor mode. The match type can be one of:\nMATCH_DIRECTOVES or MATCH_VARIABLES. The selected editor mode can be\none of the following: INSERT or OVERWRITE. See {{#crossLink\n\"AceEditor.AutoCompleteBase/fillMode:attribute\"}}{{/crossLink}}",
      "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#method_getSuggestion"
     },
     "directives": {
      "!type": "fn()",
      "!doc": "Contains an array of all possible directives for the\ncorresponding language.",
      "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#attribute_directives"
     },
     "host": {
      "!type": "fn()",
      "!doc": "The Editor in which the current instance is plugged.",
      "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#attribute_host"
     },
     "variables": {
      "!type": "fn()",
      "!doc": "Contains the supported variables for the corresponding language.",
      "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#attribute_variables"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TemplateProcessor.",
     "!url": "http://alloyui.com/classes/A.AceEditor.TemplateProcessor.html#property_ATTRS"
    }
   },
   "A.AceEditor.AutoCompleteVelocity": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor.AutoCompleteVelocity",
    "!proto": "aui_ace_editor.A.AceEditor.TemplateProcessor",
    "!doc": "A base class for Velocity plugin.",
    "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html",
    "prototype": {
     "getMatch": {
      "!type": "fn(content: string) -> +yui.Object",
      "!doc": "Checks if the provided content contains directive or variable.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#method_getMatch"
     },
     "directives": {
      "!type": "fn()",
      "!doc": "Contains the list of supported directives according to Velocity\nspecification.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#attribute_directives"
     },
     "directivesMatcher": {
      "!type": "fn()",
      "!doc": "Contains the regular expression which checks for directive.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#attribute_directivesMatcher"
     },
     "host": {
      "!type": "fn()",
      "!doc": "The Editor in which the current instance is plugged.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#attribute_host"
     },
     "variables": {
      "!type": "fn()",
      "!doc": "Contains the supported variables.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#attribute_variables"
     },
     "variablesMatcher": {
      "!type": "fn()",
      "!doc": "Contains the regular expression which will check for variable\nmatch.",
      "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#attribute_variablesMatcher"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property which provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Velocity.",
     "!url": "http://alloyui.com/classes/A.AceEditor.AutoCompleteVelocity.html#property_ATTRS"
    }
   },
   "A.AceEditor": {
    "!type": "fn(config: yui.Object) -> +aui_ace_editor.A.AceEditor",
    "!proto": "widget.Widget",
    "!doc": "A base class for ACE Editor.\n\nCheck the [live demo](http://alloyui.com/examples/ace-editor/).",
    "!url": "http://alloyui.com/classes/A.AceEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AceEditor.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.AceEditor.html#property_EXTENDS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the ACE Editor.",
     "!url": "http://alloyui.com/classes/A.AceEditor.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of ACE Editor.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_height"
     },
     "highlightActiveLine": {
      "!type": "fn()",
      "!doc": "Determine if the active line of code\nwill be highlighted or not.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_highlightActiveLine"
     },
     "mode": {
      "!type": "fn()",
      "!doc": "Correspond to the language being typed.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_mode"
     },
     "readOnly": {
      "!type": "fn()",
      "!doc": "Determine if the code will be\neditable or not.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_readOnly"
     },
     "showPrintMargin": {
      "!type": "fn()",
      "!doc": "Determine if print margin will\nbe visible or not.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_showPrintMargin"
     },
     "tabSize": {
      "!type": "fn()",
      "!doc": "The indentation size of tab key.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_tabSize"
     },
     "useSoftTabs": {
      "!type": "fn()",
      "!doc": "Determine if the tab key will act as\nspace characters or tab characters.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_useSoftTabs"
     },
     "useWrapMode": {
      "!type": "fn()",
      "!doc": "Determine if the line will break\nwhen it reaches the end of the line.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_useWrapMode"
     },
     "value": {
      "!type": "fn()",
      "!doc": "Some predefined value on the editor.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_value"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of ACE Editor.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#attribute_width"
     },
     "getEditor": {
      "!type": "fn()",
      "!doc": "Get editor.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#method_getEditor"
     },
     "getSelection": {
      "!type": "fn()",
      "!doc": "Get a text selection.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#method_getSelection"
     },
     "getSession": {
      "!type": "fn()",
      "!doc": "Get session.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#method_getSession"
     },
     "gotoLine": {
      "!type": "fn(line)",
      "!doc": "Go to a specific line of code.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#method_gotoLine"
     },
     "insert": {
      "!type": "fn(text)",
      "!doc": "Insert content into the editor.",
      "!url": "http://alloyui.com/classes/A.AceEditor.html#method_insert"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.AceEditor.html#property_UI_ATTRS"
    }
   },
   "A.Plugin.Aria": {
    "!type": "fn(config: yui.Object) -> +aui_aria.A.Plugin.Aria",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for Aria.",
    "!url": "http://alloyui.com/classes/A.Plugin.Aria.html",
    "W3C_ATTRIBUTES": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define [W3C's Supported States and\nProperties](http://www.w3.org/TR/wai-aria/states_and_properties).",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_W3C_ATTRIBUTES"
    },
    "W3C_ROLES": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define [W3C's Roles Model](http://www.w3.org/TR/wai-\naria/roles).",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_W3C_ROLES"
    }
   }
  },
  "aui_aria": {
   "A.Plugin.Aria": {
    "!type": "fn(config: yui.Object) -> +aui_aria.A.Plugin.Aria",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for Aria.",
    "!url": "http://alloyui.com/classes/A.Plugin.Aria.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for\nthe `A.Aria`.",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_ATTRS"
    },
    "prototype": {
     "attributes": {
      "!type": "fn()",
      "!doc": "The ARIA attributes collection.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_attributes"
     },
     "attributeValueFormat": {
      "!type": "fn()",
      "!doc": "The ARIA attribute value format.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_attributeValueFormat"
     },
     "attributeNode": {
      "!type": "fn()",
      "!doc": "Node container for the ARIA attribute.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_attributeNode"
     },
     "roleName": {
      "!type": "fn()",
      "!doc": "The ARIA role name.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_roleName"
     },
     "roleNode": {
      "!type": "fn()",
      "!doc": "Node container for the ARIA role.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_roleNode"
     },
     "validateW3C": {
      "!type": "fn()",
      "!doc": "Checks if the attribute is valid with W3C rules.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#attribute_validateW3C"
     },
     "isValidAttribute": {
      "!type": "fn(attrName) -> bool",
      "!doc": "Checks if the ARIA attribute is valid.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_isValidAttribute"
     },
     "isValidRole": {
      "!type": "fn(roleName) -> bool",
      "!doc": "Checks if the ARIA role is valid.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_isValidRole"
     },
     "setAttribute": {
      "!type": "fn(attrName, attrValue, node) -> bool",
      "!doc": "Set a single ARIA attribute.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_setAttribute"
     },
     "setAttributes": {
      "!type": "fn(attributes)",
      "!doc": "Set a list of ARIA attributes.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_setAttributes"
     },
     "setRole": {
      "!type": "fn(roleName, node) -> bool",
      "!doc": "Set a single ARIA role.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_setRole"
     },
     "setRoles": {
      "!type": "fn(roles)",
      "!doc": "Set a list of ARIA roles.",
      "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#method_setRoles"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.Plugin.Aria.html#property_EXTENDS"
    }
   }
  },
  "aui_arraysort": {
   "A.ArraySort": {
    "!type": "fn() -> +aui_arraysort.A.ArraySort",
    "!doc": "Augment the [YUI3 ArraySort](ArraySort.html) with more util methods.",
    "!url": "http://alloyui.com/classes/A.ArraySort.html",
    "prototype": {
     "compareIgnoreWhiteSpace": {
      "!type": "fn(a, b, desc, compareFn) -> ?",
      "!doc": "Compare two arrays ignoring white spaces.",
      "!url": "http://alloyui.com/classes/A.ArraySort.html#method_compareIgnoreWhiteSpace"
     },
     "stableSort": {
      "!type": "fn(array, compareFn)",
      "!doc": "Sorts an object array keeping the order of equal items. ECMA script\nstandard does not specify the behaviour when the compare function\nreturns the value 0;",
      "!url": "http://alloyui.com/classes/A.ArraySort.html#method_stableSort"
     }
    }
   }
  },
  "aui_audio": {
   "A.Audio": {
    "!type": "fn(config: yui.Object) -> +aui_audio.A.Audio",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Audio.\n\nCheck the [live demo](http://alloyui.com/examples/audio/).",
    "!url": "http://alloyui.com/classes/A.Audio.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Audio.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Audio.",
     "!url": "http://alloyui.com/classes/A.Audio.html#property_ATTRS"
    },
    "prototype": {
     "url": {
      "!type": "fn()",
      "!doc": "URL used by Audio to play.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_url"
     },
     "oggUrl": {
      "!type": "fn()",
      "!doc": "URL (on .ogg format) used by Audio to play.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_oggUrl"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of audio.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_type"
     },
     "swfWidth": {
      "!type": "fn()",
      "!doc": "The width of Audio's fallback using Flash.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_swfWidth"
     },
     "swfHeight": {
      "!type": "fn()",
      "!doc": "The height of Audio's fallback using Flash.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_swfHeight"
     },
     "swfUrl": {
      "!type": "fn()",
      "!doc": "URL (on .swf format) used by Audio to create\na fallback player with Flash.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_swfUrl"
     },
     "fixedAttributes": {
      "!type": "fn()",
      "!doc": "An additional list of attributes.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_fixedAttributes"
     },
     "flashVars": {
      "!type": "fn()",
      "!doc": "Variables used by Flash player.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_flashVars"
     },
     "render": {
      "!type": "fn()",
      "!doc": "If `true` the render phase will be automatically invoked\npreventing the `.render()` manual call.",
      "!url": "http://alloyui.com/classes/A.Audio.html#attribute_render"
     },
     "load": {
      "!type": "fn()",
      "!doc": "Load audio track.",
      "!url": "http://alloyui.com/classes/A.Audio.html#method_load"
     },
     "pause": {
      "!type": "fn()",
      "!doc": "Pause audio track.",
      "!url": "http://alloyui.com/classes/A.Audio.html#method_pause"
     },
     "play": {
      "!type": "fn()",
      "!doc": "Play audio track.",
      "!url": "http://alloyui.com/classes/A.Audio.html#method_play"
     }
    },
    "BIND_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes\nfor the bindUI lifecycle phase.",
     "!url": "http://alloyui.com/classes/A.Audio.html#property_BIND_UI_ATTRS"
    },
    "SYNC_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes\nfor the syncUI lifecycle phase.",
     "!url": "http://alloyui.com/classes/A.Audio.html#property_SYNC_UI_ATTRS"
    }
   }
  },
  "aui_autosize_iframe": {
   "A.AutosizeIframe": {
    "!type": "fn(config: yui.Object) -> +aui_autosize_iframe.A.AutosizeIframe",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for `A.AutosizeIframe`.",
    "!url": "http://alloyui.com/classes/A.AutosizeIframe.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#property_NS"
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#property_EXTENDS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.AutosizeIframe`.",
     "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the iframe.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#attribute_height"
     },
     "monitorHeight": {
      "!type": "fn()",
      "!doc": "Indicates if the height should be monitored.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#attribute_monitorHeight"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the iframe.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#attribute_width"
     },
     "pauseMonitor": {
      "!type": "fn()",
      "!doc": "Stops to monitor the height.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#method_pauseMonitor"
     },
     "restartMonitor": {
      "!type": "fn()",
      "!doc": "Restarts to monitor the height.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#method_restartMonitor"
     },
     "getContentHeight": {
      "!type": "fn(iframeWin) -> number",
      "!doc": "Returns the content height of a window.",
      "!url": "http://alloyui.com/classes/A.AutosizeIframe.html#method_getContentHeight"
     }
    }
   }
  },
  "aui_button": {
   "A.ButtonExt": {
    "!type": "fn(config: yui.Object) -> +aui_button.A.ButtonExt",
    "!doc": "A base class for `ButtonExt`.",
    "!url": "http://alloyui.com/classes/A.ButtonExt.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Defines the default attribute configuration for the `ButtonExt`.",
     "!url": "http://alloyui.com/classes/A.ButtonExt.html#property_ATTRS"
    },
    "prototype": {
     "domType": {
      "!type": "fn()",
      "!doc": "Defines the HTML type attribute of element e.g. `<input type=\"button\">`.",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#attribute_domType"
     },
     "icon": {
      "!type": "fn()",
      "!doc": "Contains a CSS class of the icon to use. A list of icons can be found\n[here](http://liferay.github.io/alloy-bootstrap/base-css.html#icons).",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#attribute_icon"
     },
     "iconElement": {
      "!type": "fn()",
      "!doc": "Defines markup template for icon, passed in as a node e.g.\n`Y.Node.create('<i></i>')`.",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#attribute_iconElement"
     },
     "iconAlign": {
      "!type": "fn()",
      "!doc": "Sets position of icon.",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#attribute_iconAlign"
     },
     "primary": {
      "!type": "fn()",
      "!doc": "Sets button style to primary.",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#attribute_primary"
     },
     "syncButtonExtUI": {
      "!type": "fn()",
      "!doc": "Updates icon image, icon alignment, and primary button style.",
      "!url": "http://alloyui.com/classes/A.ButtonExt.html#method_syncButtonExtUI"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Defines how attribute values are to be parsed from markup contained in\n`ButtonExt`.",
     "!url": "http://alloyui.com/classes/A.ButtonExt.html#property_HTML_PARSER"
    },
    "getTypedButtonTemplate": {
     "!type": "fn(template: string, type: string) -> string",
     "!doc": "Updates the HTML markup specified as the `template` argument with the\npassed `type`.",
     "!url": "http://alloyui.com/classes/A.ButtonExt.html#method_getTypedButtonTemplate"
    }
   },
   "A.ButtonCore": {
    "!type": "fn() -> +aui_button.A.ButtonCore",
    "!doc": "A base class for ButtonCore.",
    "!url": "http://alloyui.com/classes/A.ButtonCore.html",
    "CLASS_NAMES": {
     "!type": "?",
     "!doc": "Contains CSS class names to use for `ButtonCore`.",
     "!url": "http://alloyui.com/classes/A.ButtonCore.html#property_CLASS_NAMES"
    }
   },
   "A.Button": {
    "!type": "fn() -> +aui_button.A.Button",
    "!proto": "button.Button",
    "!doc": "A base class for Button.",
    "!url": "http://alloyui.com/classes/A.Button.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Button.html#property_CSS_PREFIX"
    },
    "prototype": {
     "getWidgetLazyConstructorFromNodeData": {
      "!type": "fn(node: node.Node) -> +yui.Object",
      "!doc": "Returns an object literal containing widget constructor data specified in\nthe node.",
      "!url": "http://alloyui.com/classes/A.Button.html#method_getWidgetLazyConstructorFromNodeData"
     },
     "hasWidgetLazyConstructorData": {
      "!type": "fn(node: node.Node) -> bool",
      "!doc": "Returns a boolean, true if node has widget constructor data.",
      "!url": "http://alloyui.com/classes/A.Button.html#method_hasWidgetLazyConstructorData"
     },
     "setWidgetLazyConstructorNodeData": {
      "!type": "fn(node: node.Node, config: yui.Object)",
      "!doc": "Updates node's widget constructor data attribute with config.",
      "!url": "http://alloyui.com/classes/A.Button.html#method_setWidgetLazyConstructorNodeData"
     },
     "syncIconUI": {
      "!type": "fn(buttonElement: node.Node, iconElement: node.Node, iconAlign: string)",
      "!doc": "Updates icon alignment in button.",
      "!url": "http://alloyui.com/classes/A.Button.html#method_syncIconUI"
     }
    }
   },
   "A.ButtonGroup": {
    "!type": "fn() -> +aui_button.A.ButtonGroup",
    "!doc": "A base class for ButtonGroup.",
    "!url": "http://alloyui.com/classes/A.ButtonGroup.html",
    "prototype": {
     "item": {
      "!type": "fn(index: number) -> +button.Button",
      "!doc": "Returns the `item` or `node` of specified `index`.",
      "!url": "http://alloyui.com/classes/A.ButtonGroup.html#method_item"
     },
     "select": {
      "!type": "fn(items: yui.Array)",
      "!doc": "Selects items by adding the active class name.",
      "!url": "http://alloyui.com/classes/A.ButtonGroup.html#method_select"
     },
     "toggleSelect": {
      "!type": "fn(items: yui.Array, forceSelection: bool)",
      "!doc": "Toggles selection by adding or removing the active class name.",
      "!url": "http://alloyui.com/classes/A.ButtonGroup.html#method_toggleSelect"
     },
     "unselect": {
      "!type": "fn(items: yui.Array)",
      "!doc": "Selects items by adding the active class name.",
      "!url": "http://alloyui.com/classes/A.ButtonGroup.html#method_unselect"
     }
    }
   },
   "A.ButtonSearchCancel": {
    "!type": "fn(config: yui.Object) -> +aui_button.A.ButtonSearchCancel",
    "!proto": "base.Base",
    "!doc": "A base class for `ButtonSearchCancel`, providing:\n\n- Adds a button search cancel icon in order to clear the text on inputs and\ntextareas. Similar behavior of the HTML5 search input that contains a cancel\nbutton to clear the current element value.",
    "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html",
    "prototype": {
     "initializer": {
      "!type": "fn()",
      "!doc": "Construction logic executed during `ButtonSearchCancel` instantiation.\nLifecycle.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#method_initializer"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "Bind events on the UI. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#method_bindUI"
     },
     "getButtonForElement": {
      "!type": "fn(element: node.Node) -> +node.Node",
      "!doc": "Delegates events on the UI. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#method_getButtonForElement"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Defines the event delegation container of `ButtonSearchCancel`\ninstance.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#attribute_container"
     },
     "gutter": {
      "!type": "fn()",
      "!doc": "Defines the space surrounding the cancel icon rendered on the input.\nUseful when the user needs a different alignment. Gutter values are\nadded to the X and Y alignment values of the button search cancel.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#attribute_gutter"
     },
     "iconClass": {
      "!type": "fn()",
      "!doc": "Icon CSS class to be used on the search cancel button.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#attribute_iconClass"
     },
     "trigger": {
      "!type": "fn()",
      "!doc": "Defines the CSS selector for the input elements the button search\ncancel renders. Supports single or multiple node selector.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#attribute_trigger"
     },
     "zIndex": {
      "!type": "fn()",
      "!doc": "Defines the z-index of the button search cancel.",
      "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#attribute_zIndex"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for\nthe `ButtonSearchCancel`.",
     "!url": "http://alloyui.com/classes/A.ButtonSearchCancel.html#property_ATTRS"
    }
   }
  },
  "aui_carousel": {
   "A.Carousel": {
    "!type": "fn(config: yui.Object) -> +aui_carousel.A.Carousel",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Carousel.\n\nCheck the [live demo](http://alloyui.com/examples/carousel/).",
    "!url": "http://alloyui.com/classes/A.Carousel.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Carousel.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Carousel.",
     "!url": "http://alloyui.com/classes/A.Carousel.html#property_ATTRS"
    },
    "prototype": {
     "activeIndex": {
      "!type": "fn()",
      "!doc": "Index of the first visible item of the carousel.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_activeIndex"
     },
     "animationTime": {
      "!type": "fn()",
      "!doc": "Duration of the animation in seconds when change index on\nCarousel.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_animationTime"
     },
     "intervalTime": {
      "!type": "fn()",
      "!doc": "Interval time in seconds between an item transition.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_intervalTime"
     },
     "itemSelector": {
      "!type": "fn()",
      "!doc": "CSS Selector whitch determines the items to be loaded to the\nCarousel.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_itemSelector"
     },
     "nodeMenu": {
      "!type": "fn()",
      "!doc": "Node container of the navigation items.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_nodeMenu"
     },
     "nodeMenuItemSelector": {
      "!type": "fn()",
      "!doc": "CSS selector to match the navigation items.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_nodeMenuItemSelector"
     },
     "playing": {
      "!type": "fn()",
      "!doc": "Attributes that determines the status of transitions between\nitems.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#attribute_playing"
     },
     "item": {
      "!type": "fn(val)",
      "!doc": "Set the `activeIndex` attribute which\nactivates a certain item on Carousel based on its index.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#method_item"
     },
     "next": {
      "!type": "fn()",
      "!doc": "Go to the next index.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#method_next"
     },
     "pause": {
      "!type": "fn()",
      "!doc": "Set the `playing` attribute\nto false which pauses the animation.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#method_pause"
     },
     "play": {
      "!type": "fn()",
      "!doc": "Set the `playing` attribute\nto true which starts the animation.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#method_play"
     },
     "prev": {
      "!type": "fn()",
      "!doc": "Go to previous index.",
      "!url": "http://alloyui.com/classes/A.Carousel.html#method_prev"
     }
    }
   }
  },
  "aui_char_counter": {
   "A.CharCounter": {
    "!type": "fn(config: yui.Object) -> +aui_char_counter.A.CharCounter",
    "!proto": "base.Base",
    "!doc": "A base class for CharCounter, providing:\n\n- Limit the number of characters allowed in an input box\n- Display the number of characters left\n\nCheck the [live demo](http://alloyui.com/examples/char-counter/).",
    "!url": "http://alloyui.com/classes/A.CharCounter.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.CharCounter.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the CharCounter.",
     "!url": "http://alloyui.com/classes/A.CharCounter.html#property_ATTRS"
    },
    "prototype": {
     "counter": {
      "!type": "fn()",
      "!doc": "Node or Selector to display the information of the counter.",
      "!url": "http://alloyui.com/classes/A.CharCounter.html#attribute_counter"
     },
     "maxLength": {
      "!type": "fn()",
      "!doc": "Max number of characters the [input](A.CharCounter.html#attr_input)\ncan have.",
      "!url": "http://alloyui.com/classes/A.CharCounter.html#attribute_maxLength"
     },
     "input": {
      "!type": "fn()",
      "!doc": "Node or Selector for the input field. Required.",
      "!url": "http://alloyui.com/classes/A.CharCounter.html#attribute_input"
     },
     "checkLength": {
      "!type": "fn()",
      "!doc": "Check the current value of the\n[input](A.CharCounter.html#attr_input), truncate the data if needed,\nand re-sync the UI. Fired from\n[_onInputChange](A.CharCounter.html#method__onInputChange).",
      "!url": "http://alloyui.com/classes/A.CharCounter.html#method_checkLength"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.CharCounter.html#property_EXTENDS"
    }
   }
  },
  "aui_collection": {
   "A.LinkedSet": {
    "!type": "fn(config: yui.Object) -> +aui_collection.A.LinkedSet",
    "!proto": "A.Set",
    "!doc": "A base class for LinkedSet.",
    "!url": "http://alloyui.com/classes/A.LinkedSet.html",
    "prototype": {
     "values": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets a list view of the values contained in this linked set.",
      "!url": "http://alloyui.com/classes/A.LinkedSet.html#method_values"
     }
    }
   },
   "A.HashMap": {
    "!type": "fn(config: yui.Object) -> +aui_collection.A.HashMap",
    "!proto": "base.Base",
    "!doc": "A base class for HashMap.",
    "!url": "http://alloyui.com/classes/A.HashMap.html",
    "prototype": {
     "clear": {
      "!type": "fn()",
      "!doc": "Fires the `clear` custom event.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_clear"
     },
     "getValue": {
      "!type": "fn(key) -> +yui.Object",
      "!doc": "Returns the value from a key in this map.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_getValue"
     },
     "has": {
      "!type": "fn(key, opt_hash) -> bool",
      "!doc": "Checks if this map has the specified key.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_has"
     },
     "hasValue": {
      "!type": "fn(value) -> bool",
      "!doc": "Returns `true` if this map contains a certain value.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_hasValue"
     },
     "keys": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns a collection of the keys contained in this map.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_keys"
     },
     "isEmpty": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if this map contains no key-value mappings.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_isEmpty"
     },
     "put": {
      "!type": "fn(key, value, opt_hash)",
      "!doc": "Fires the `put` custom event.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_put"
     },
     "putAll": {
      "!type": "fn(map)",
      "!doc": "Copies all of the mappings from the specified map to this map.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_putAll"
     },
     "remove": {
      "!type": "fn(key, opt_hash) -> +yui.Object",
      "!doc": "Fires the `remove` custom event.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_remove"
     },
     "size": {
      "!type": "fn() -> number",
      "!doc": "Returns the number of key-value mappings in this map.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_size"
     },
     "values": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns a collection of the values contained in this map.",
      "!url": "http://alloyui.com/classes/A.HashMap.html#method_values"
     }
    }
   },
   "A.HashSet": {
    "!type": "fn(config: yui.Object) -> +aui_collection.A.HashSet",
    "!proto": "base.Base",
    "!doc": "A base class for HashSet.",
    "!url": "http://alloyui.com/classes/A.HashSet.html",
    "prototype": {
     "add": {
      "!type": "fn(value)",
      "!doc": "Fires the `add` custom event.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_add"
     },
     "clear": {
      "!type": "fn()",
      "!doc": "Fires the `clear` custom event.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_clear"
     },
     "has": {
      "!type": "fn(value, opt_hash) -> bool",
      "!doc": "Checks if this set has the specified key.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_has"
     },
     "isEmpty": {
      "!type": "fn()",
      "!doc": "Returns `true` if this set contains no elements.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_isEmpty"
     },
     "remove": {
      "!type": "fn(value)",
      "!doc": "Fires the `remove` custom event with an argument.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_remove"
     },
     "size": {
      "!type": "fn()",
      "!doc": "Get the size of the map.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_size"
     },
     "values": {
      "!type": "fn()",
      "!doc": "Get the keys of the map.",
      "!url": "http://alloyui.com/classes/A.HashSet.html#method_values"
     }
    }
   }
  },
  "aui_color_picker": {
   "A.ColorPalette": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.ColorPalette",
    "!proto": "widget.Widget",
    "!doc": "A base class for `ColorPalette`.",
    "!url": "http://alloyui.com/classes/A.ColorPalette.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.ColorPalette.html#property_CSS_PREFIX"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ColorPalette.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `ColorPalette`.",
     "!url": "http://alloyui.com/classes/A.ColorPalette.html#property_ATTRS"
    },
    "prototype": {
     "items": {
      "!type": "fn()",
      "!doc": "Colors available to the `ColorPalette`.",
      "!url": "http://alloyui.com/classes/A.ColorPalette.html#attribute_items"
     }
    }
   },
   "A.ColorPickerBase": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.ColorPickerBase",
    "!doc": "A base class for `ColorPickerBase`.",
    "!url": "http://alloyui.com/classes/A.ColorPickerBase.html",
    "prototype": {
     "reset": {
      "!type": "fn()",
      "!doc": "Resets the `ColorPickerBase` to it's default state.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#method_reset"
     },
     "bodyContent": {
      "!type": "fn()",
      "!doc": "The content of body.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_bodyContent"
     },
     "color": {
      "!type": "fn()",
      "!doc": "Currently selected color.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_color"
     },
     "colorPalette": {
      "!type": "fn()",
      "!doc": "Default colors available to the color palette.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_colorPalette"
     },
     "currentTrigger": {
      "!type": "fn()",
      "!doc": "Current `trigger` node.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_currentTrigger"
     },
     "defaultColor": {
      "!type": "fn()",
      "!doc": "Provides the default color used for the `recentColors` palette.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_defaultColor"
     },
     "hsvPalette": {
      "!type": "fn()",
      "!doc": "`HSVPalette` used for selecting custom colors not present in\n`defualtColors`.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_hsvPalette"
     },
     "recentColors": {
      "!type": "fn()",
      "!doc": "Colors that have been selected recently from the `HSVPalette`.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_recentColors"
     },
     "renderColorPalette": {
      "!type": "fn()",
      "!doc": "Determines if the color palette is rendered on load.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_renderColorPalette"
     },
     "renderHSVPalette": {
      "!type": "fn()",
      "!doc": "Determines if the `HSVPalette` is rendered on load.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_renderHSVPalette"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_strings"
     },
     "trigger": {
      "!type": "fn()",
      "!doc": "Trigger node that opens the color palette.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_trigger"
     },
     "triggerEvent": {
      "!type": "fn()",
      "!doc": "Trigger event that fires on `trigger` click.",
      "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#attribute_triggerEvent"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `ColorPickerBase`.",
     "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#property_ATTRS"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#property_CSS_PREFIX"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ColorPickerBase.html#property_NAME"
    }
   },
   "A.ColorPickerPopover": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.ColorPickerPopover",
    "!proto": "aui_popover.A.Popover",
    "!doc": "A base class for `ColorPickerPopover`.",
    "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `ColorPickerPopover`.",
     "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html#property_ATTRS"
    },
    "prototype": {
     "align": {
      "!type": "fn()",
      "!doc": "The alignment configuration for `ColorPickerPopover`.",
      "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html#attribute_align"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Determines if `ColorPickerPopover` is visible or not.",
      "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html#attribute_visible"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.ColorPickerPopover.html#property_NS"
    }
   },
   "A.HSVPalette": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.HSVPalette",
    "!proto": "widget.Widget",
    "!doc": "A base class for `HSVPalette`.",
    "!url": "http://alloyui.com/classes/A.HSVPalette.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.HSVPalette.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `HSVPalette`.",
     "!url": "http://alloyui.com/classes/A.HSVPalette.html#property_ATTRS"
    },
    "prototype": {
     "controls": {
      "!type": "fn()",
      "!doc": "Determines if HSVA and RGB input `controls` are visible.",
      "!url": "http://alloyui.com/classes/A.HSVPalette.html#attribute_controls"
     },
     "fieldValidator": {
      "!type": "fn()",
      "!doc": "Collection of regular expressions used to validate field values.",
      "!url": "http://alloyui.com/classes/A.HSVPalette.html#attribute_fieldValidator"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Currently `selected` color value.",
      "!url": "http://alloyui.com/classes/A.HSVPalette.html#attribute_selected"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.HSVPalette.html#attribute_strings"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.HSVPalette.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.HSVPalette.html#property_NS"
    }
   },
   "A.HSVAPaletteModal": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.HSVAPaletteModal",
    "!proto": "aui_modal.A.Modal",
    "!doc": "A base class for `HSVAPaletteModal`.",
    "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `HSVAPaletteModal`.",
     "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#property_ATTRS"
    },
    "prototype": {
     "hsv": {
      "!type": "fn()",
      "!doc": "Configuration options for the `HSVPalette`.",
      "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#attribute_hsv"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Currently `selected` color value.",
      "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#attribute_selected"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#property_CSS_PREFIX"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.HSVAPaletteModal.html#property_NS"
    }
   },
   "A.HSVAPalette": {
    "!type": "fn(config: yui.Object) -> +aui_color_picker.A.HSVAPalette",
    "!proto": "aui_color_picker.A.HSVPalette",
    "!doc": "A base class for `HSVAPalette`.",
    "!url": "http://alloyui.com/classes/A.HSVAPalette.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.HSVAPalette.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.HSVAPalette.html#property_NS"
    }
   }
  },
  "aui_component": {
   "A.Component": {
    "!type": "fn(config: yui.Object) -> +aui_component.A.Component",
    "!proto": "widget.Widget",
    "!doc": "A base class for `A.Component`, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)",
    "!url": "http://alloyui.com/classes/A.Component.html",
    "prototype": {
     "clone": {
      "!type": "fn(config: yui.Object) -> +widget.Widget",
      "!doc": "Clone the current `A.Component`.",
      "!url": "http://alloyui.com/classes/A.Component.html#method_clone"
     },
     "useARIA": {
      "!type": "fn()",
      "!doc": "Indicates if use of the WAI-ARIA Roles and States should be enabled\nfor the Widget.",
      "!url": "http://alloyui.com/classes/A.Component.html#attribute_useARIA"
     },
     "hideClass": {
      "!type": "fn()",
      "!doc": "CSS class added to hide the `boundingBox` when\n[visible](A.Component.html#attr_visible) is set to `false`.",
      "!url": "http://alloyui.com/classes/A.Component.html#attribute_hideClass"
     },
     "render": {
      "!type": "fn()",
      "!doc": "If `true` the render phase will be autimatically invoked preventing\nthe `.render()` manual call.",
      "!url": "http://alloyui.com/classes/A.Component.html#attribute_render"
     },
     "getById": {
      "!type": "fn(id)",
      "!doc": "Gets component's instance by id.",
      "!url": "http://alloyui.com/classes/A.Component.html#method_getById"
     },
     "create": {
      "!type": "fn(config)",
      "!doc": "Applies standard extensions from a given config to create a new class using\nthe static `Base.build` method.",
      "!url": "http://alloyui.com/classes/A.Component.html#method_create"
     },
     "build": {
      "!type": "fn()",
      "!doc": "Applies extensions to a class using the static `Base.build` method.",
      "!url": "http://alloyui.com/classes/A.Component.html#method_build"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for\nthe Component.",
     "!url": "http://alloyui.com/classes/A.Component.html#property_ATTRS"
    },
    "_INSTANCES": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the map to store Component instances by id.",
     "!url": "http://alloyui.com/classes/A.Component.html#property__INSTANCES"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Component.html#property_CSS_PREFIX"
    }
   }
  },
  "aui_datatable": {
   "A.DataTable.CellEditorSupport": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.DataTable.CellEditorSupport",
    "!doc": "An extension for A.DataTable to support Cell Editing.",
    "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#property_NAME"
    },
    "EDITOR_ZINDEX": {
     "!type": "number",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#property_EDITOR_ZINDEX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the CellEditorSupport.",
     "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#property_ATTRS"
    },
    "prototype": {
     "editEvent": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#attribute_editEvent"
     },
     "getEditor": {
      "!type": "fn(record, column)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#method_getEditor"
     },
     "getCellEditor": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#method_getCellEditor"
     },
     "getRecordColumnValue": {
      "!type": "fn(record, column)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTable.CellEditorSupport.html#method_getRecordColumnValue"
     }
    }
   },
   "A.BaseCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.BaseCellEditor",
    "!proto": "overlay.Overlay",
    "!doc": "Abstract class BaseCellEditor.",
    "!url": "http://alloyui.com/classes/A.BaseCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the BaseCellEditor.",
     "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#property_ATTRS"
    },
    "prototype": {
     "editable": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_editable"
     },
     "elementName": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_elementName"
     },
     "footerContent": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_footerContent"
     },
     "hideOnSave": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_hideOnSave"
     },
     "inputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_inputFormatter"
     },
     "outputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_outputFormatter"
     },
     "showToolbar": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_showToolbar"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_strings"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_tabIndex"
     },
     "toolbar": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_toolbar"
     },
     "unescapeValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_unescapeValue"
     },
     "validator": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_validator"
     },
     "value": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_value"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#attribute_visible"
     },
     "formatValue": {
      "!type": "fn(formatter, val)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#method_formatValue"
     },
     "getValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#method_getValue"
     },
     "getElementsValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.\n\nNOTE FOR DEVELOPERS: Yoy *may* want to replace the methods from\nthis section on your implementation.",
      "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#method_getElementsValue"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#property_EXTENDS"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.BaseCellEditor.html#property_UI_ATTRS"
    }
   },
   "A.BaseOptionsCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.BaseOptionsCellEditor",
    "!proto": "aui_datatable.A.BaseCellEditor",
    "!doc": "Abstract class BaseOptionsCellEditor for options attribute support.",
    "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the BaseOptionsCellEditor.",
     "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#property_ATTRS"
    },
    "prototype": {
     "inputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#attribute_inputFormatter"
     },
     "options": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#attribute_options"
     },
     "outputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#attribute_outputFormatter"
     },
     "selectedAttrName": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#attribute_selectedAttrName"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#attribute_strings"
     },
     "addNewOption": {
      "!type": "fn(name, value)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#method_addNewOption"
     },
     "removeOption": {
      "!type": "fn(optionRow)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#method_removeOption"
     },
     "saveOptions": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#method_saveOptions"
     },
     "toggleEdit": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#method_toggleEdit"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#property_EXTENDS"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.BaseOptionsCellEditor.html#property_UI_ATTRS"
    }
   },
   "A.TextCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.TextCellEditor",
    "!proto": "aui_datatable.A.BaseCellEditor",
    "!doc": "TextCellEditor class.",
    "!url": "http://alloyui.com/classes/A.TextCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TextCellEditor.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TextCellEditor.html#property_EXTENDS"
    }
   },
   "A.TextAreaCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.TextAreaCellEditor",
    "!proto": "aui_datatable.A.BaseCellEditor",
    "!doc": "TextAreaCellEditor class.",
    "!url": "http://alloyui.com/classes/A.TextAreaCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TextAreaCellEditor.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TextAreaCellEditor.html#property_EXTENDS"
    }
   },
   "A.DropDownCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.DropDownCellEditor",
    "!proto": "aui_datatable.A.BaseOptionsCellEditor",
    "!doc": "DropDownCellEditor class.",
    "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the DropDownCellEditor.",
     "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#property_ATTRS"
    },
    "prototype": {
     "multiple": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#attribute_multiple"
     },
     "getElementsValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#method_getElementsValue"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#property_EXTENDS"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.DropDownCellEditor.html#property_UI_ATTRS"
    }
   },
   "A.CheckboxCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.CheckboxCellEditor",
    "!proto": "aui_datatable.A.BaseOptionsCellEditor",
    "!doc": "CheckboxCellEditor class.",
    "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the CheckboxCellEditor.",
     "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html#property_ATTRS"
    },
    "prototype": {
     "selectedAttrName": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html#attribute_selectedAttrName"
     },
     "getElementsValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html#method_getElementsValue"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.CheckboxCellEditor.html#property_EXTENDS"
    }
   },
   "A.RadioCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.RadioCellEditor",
    "!proto": "aui_datatable.A.CheckboxCellEditor",
    "!doc": "RadioCellEditor class.",
    "!url": "http://alloyui.com/classes/A.RadioCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.RadioCellEditor.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.RadioCellEditor.html#property_EXTENDS"
    },
    "prototype": {
     "getElementsValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.RadioCellEditor.html#method_getElementsValue"
     }
    }
   },
   "A.DateCellEditor": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.DateCellEditor",
    "!proto": "aui_datatable.A.BaseCellEditor",
    "!doc": "DateCellEditor class.",
    "!url": "http://alloyui.com/classes/A.DateCellEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DateCellEditor.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DateCellEditor.html#property_EXTENDS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the DateCellEditor.",
     "!url": "http://alloyui.com/classes/A.DateCellEditor.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#attribute_bodyContent"
     },
     "calendar": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#attribute_calendar"
     },
     "dateFormat": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#attribute_dateFormat"
     },
     "inputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#attribute_inputFormatter"
     },
     "outputFormatter": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#attribute_outputFormatter"
     },
     "getElementsValue": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#method_getElementsValue"
     },
     "formatDate": {
      "!type": "fn(date)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DateCellEditor.html#method_formatDate"
     }
    }
   },
   "A.DataTableHighlight": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.DataTableHighlight",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for DataTableHighlight.",
    "!url": "http://alloyui.com/classes/A.DataTableHighlight.html",
    "prototype": {
     "clear": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#method_clear"
     },
     "getActiveRegion": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#method_getActiveRegion"
     },
     "getSelectionRegion": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#method_getSelectionRegion"
     },
     "activeBorderWidth": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_activeBorderWidth"
     },
     "overlayActiveNode": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_overlayActiveNode"
     },
     "overlayNode": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_overlayNode"
     },
     "highlightRange": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_highlightRange"
     },
     "rangeBorderWidth": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_rangeBorderWidth"
     },
     "type": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#attribute_type"
     }
    },
    "NS": {
     "!type": "string",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the DataTableHighlight.",
     "!url": "http://alloyui.com/classes/A.DataTableHighlight.html#property_ATTRS"
    }
   },
   "A.PropertyList": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.PropertyList",
    "!proto": "datatable.DataTable",
    "!doc": "A base class for PropertyList.",
    "!url": "http://alloyui.com/classes/A.PropertyList.html",
    "prototype": {
     "getDefaultEditor": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#method_getDefaultEditor"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#attribute_columns"
     },
     "scrollable": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#attribute_scrollable"
     },
     "editEvent": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#attribute_editEvent"
     },
     "width": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.\n\nDataTable scroll breaks when width value is a number\nSee http://yuilibrary.com/projects/yui3/ticket/2532600",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#attribute_width"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Colection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.PropertyList.html#attribute_strings"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "TODO. Wanna help? Please send a Pull Request.",
     "!url": "http://alloyui.com/classes/A.PropertyList.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the PropertyList.",
     "!url": "http://alloyui.com/classes/A.PropertyList.html#property_ATTRS"
    }
   },
   "A.DataTableSelection": {
    "!type": "fn(config: yui.Object) -> +aui_datatable.A.DataTableSelection",
    "!doc": "A base class for DataTableSelection.",
    "!url": "http://alloyui.com/classes/A.DataTableSelection.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the DataTableSelection.",
     "!url": "http://alloyui.com/classes/A.DataTableSelection.html#property_ATTRS"
    },
    "prototype": {
     "activeCell": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#attribute_activeCell"
     },
     "activeCoord": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#attribute_activeCoord"
     },
     "activeRow": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#attribute_activeRow"
     },
     "selection": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#attribute_selection"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#attribute_tabIndex"
     },
     "captureSelection": {
      "!type": "fn(coords)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_captureSelection"
     },
     "getActiveColumn": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_getActiveColumn"
     },
     "getActiveRecord": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_getActiveRecord"
     },
     "getCoord": {
      "!type": "fn(seed)",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_getCoord"
     },
     "getColumn": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_getColumn"
     },
     "getRow": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.\n\nAdd support to get a row by seed on DataTable getRow\nSee http://yuilibrary.com/projects/yui3/ticket/2532605",
      "!url": "http://alloyui.com/classes/A.DataTableSelection.html#method_getRow"
     }
    }
   }
  },
  "aui_datatype_date_parse": {
   "A.DateParser": {
    "!type": "fn(opt_pattern: string) -> +aui_datatype_date_parse.A.DateParser",
    "!doc": "A base class for `A.DateParser`.",
    "!url": "http://alloyui.com/classes/A.DateParser.html",
    "TOKEN_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the token prefix, e.g. %A.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_TOKEN_PREFIX"
    },
    "TWO_DIGIT_YEAR_BASE": {
     "!type": "number",
     "!doc": "Static property provides a base year to sum two digit years, e.g. For the\nmask %Y, \"13\" will be parsed to 2013.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_TWO_DIGIT_YEAR_BASE"
    },
    "prototype": {
     "compilePattern": {
      "!type": "fn(pattern: string)",
      "!doc": "\"Compiles\" the strftime pattern. The same DateParser instance can be\nreused to other \"compiled\" masks.",
      "!url": "http://alloyui.com/classes/A.DateParser.html#method_compilePattern"
     },
     "parse": {
      "!type": "fn(mask: string, text: string, opt_date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Takes a string mask and a text as input and parses it as a native\nJavaScript Date.",
      "!url": "http://alloyui.com/classes/A.DateParser.html#method_parse"
     }
    },
    "HINTS": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\npossible token values, e.g. year, month, day etc.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS"
    },
    "HINTS.AGGREGATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\naggregates tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.AGGREGATES"
    },
    "HINTS.AMPM": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nampm tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.AMPM"
    },
    "HINTS.YEAR": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nyear tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.YEAR"
    },
    "HINTS.MONTH": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nmonth tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.MONTH"
    },
    "HINTS.DAY": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nday tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.DAY"
    },
    "HINTS.HOURS": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nhours tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.HOURS"
    },
    "HINTS.MINUTES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nminutes tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.MINUTES"
    },
    "HINTS.SECONDS": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\nseconds tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.SECONDS"
    },
    "HINTS.TZ": {
     "!type": "+yui.Object",
     "!doc": "Static property provides an object that contains hints information for\ntimezone tokens.",
     "!url": "http://alloyui.com/classes/A.DateParser.html#property_HINTS.TZ"
    }
   },
   "Date": {
    "!type": "fn()",
    "!doc": "Date provides a set of utility functions to operate against Date objects.",
    "!url": "http://alloyui.com/classes/Date.html",
    "parse": {
     "!type": "fn(mask: string, text: string, opt_date: datatype_date.Date) -> +datatype_date.Date",
     "!doc": "Takes a string mask and a text as input and parses it as a native JavaScript\nDate. **If only one argument is passed**, the YUI parser will be called for\nbackwards compatibility.",
     "!url": "http://alloyui.com/classes/Date.html#method_parse"
    }
   }
  },
  "aui_datatype": {
   "A.DataType.Boolean": {
    "!type": "fn()",
    "!doc": "`A.DataType.Boolean` provides a set of utility to parse `falsey` value to\n`false` and `non-falsey` to `true`.",
    "!url": "http://alloyui.com/classes/A.DataType.Boolean.html",
    "prototype": {
     "parse": {
      "!type": "fn(data: ?) -> bool",
      "!doc": "Parses any `falsey` value to `false` and `non-falsey` to `true`.",
      "!url": "http://alloyui.com/classes/A.DataType.Boolean.html#method_parse"
     }
    }
   },
   "A.DataType.String": {
    "!type": "fn()",
    "!doc": "`A.DataType.String` provides a set of utility to provides a simple\nfunction that evaluates a string to a primitive value (if possible).\nSupports `true` and `false` also.",
    "!url": "http://alloyui.com/classes/A.DataType.String.html",
    "prototype": {
     "evaluate": {
      "!type": "fn(data: ?) -> bool",
      "!doc": "Evaluates a string to a primitive value (if possible). Supports\n`true` and `false` also. Unrecognized strings are\nreturned without any modification.",
      "!url": "http://alloyui.com/classes/A.DataType.String.html#method_evaluate"
     }
    }
   },
   "A.DataType.DateMath": {
    "!type": "fn()",
    "!doc": "`A.DataType.DateMath` is used for simple date manipulation. The class is a\nstatic utility used for adding, subtracting, and comparing dates. Based on\n`YAHOO.widget.DateMath`.",
    "!url": "http://alloyui.com/classes/A.DataType.DateMath.html",
    "DAY": {
     "!type": "string",
     "!doc": "Constant field representing Day.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_DAY"
    },
    "WEEK": {
     "!type": "string",
     "!doc": "Constant field representing Week.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_WEEK"
    },
    "YEAR": {
     "!type": "string",
     "!doc": "Constant field representing Year.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_YEAR"
    },
    "MONTH": {
     "!type": "string",
     "!doc": "Constant field representing Month.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_MONTH"
    },
    "MINUTES": {
     "!type": "string",
     "!doc": "Constant field representing Minutes.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_MINUTES"
    },
    "HOUR": {
     "!type": "string",
     "!doc": "Constant field representing Hour.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_HOUR"
    },
    "SECONDS": {
     "!type": "string",
     "!doc": "Constant field representing Seconds.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_SECONDS"
    },
    "MAX_MONTH_LENGTH": {
     "!type": "number",
     "!doc": "Constant field representing the number of maximum days in a month.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_MAX_MONTH_LENGTH"
    },
    "WEEK_LENGTH": {
     "!type": "number",
     "!doc": "Constant field representing the number of maximum days in a week.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_WEEK_LENGTH"
    },
    "ONE_DAY_MS": {
     "!type": "number",
     "!doc": "Constant field representing one day, in milliseconds.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_ONE_DAY_MS"
    },
    "ONE_HOUR_MS": {
     "!type": "number",
     "!doc": "Constant field representing one hour, in milliseconds.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_ONE_HOUR_MS"
    },
    "ONE_MINUTE_MS": {
     "!type": "number",
     "!doc": "Constant field representing one minute, in milliseconds.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_ONE_MINUTE_MS"
    },
    "ONE_SECOND_MS": {
     "!type": "number",
     "!doc": "Constant field representing one second, in milliseconds.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_ONE_SECOND_MS"
    },
    "WEEK_ONE_JAN_DATE": {
     "!type": "number",
     "!doc": "Constant field representing the date in first week of January\nwhich identifies the first week of the year.\n\nIn the U.S, Jan 1st is normally used based on a Sunday start of week. ISO\n8601, used widely throughout Europe, uses Jan 4th, based on a Monday\nstart of week.",
     "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#property_WEEK_ONE_JAN_DATE"
    },
    "prototype": {
     "add": {
      "!type": "fn(date: datatype_date.Date, field: string, amount: number) -> +datatype_date.Date",
      "!doc": "Adds the specified amount of time to the this instance.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_add"
     },
     "compare": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> bool",
      "!doc": "Compare dates.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_compare"
     },
     "copyHours": {
      "!type": "fn(d1, d2)",
      "!doc": "Copies hours, minutes, seconds and milliseconds.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_copyHours"
     },
     "subtract": {
      "!type": "fn(date: datatype_date.Date, field: number, amount: number) -> +datatype_date.Date",
      "!doc": "Subtracts the specified amount of time from the this instance.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_subtract"
     },
     "before": {
      "!type": "fn(date: datatype_date.Date, compareTo: datatype_date.Date) -> bool",
      "!doc": "Determines whether a given date is before another date on the calendar.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_before"
     },
     "after": {
      "!type": "fn(date: datatype_date.Date, compareTo: datatype_date.Date) -> bool",
      "!doc": "Determines whether a given date is after another date on the calendar.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_after"
     },
     "between": {
      "!type": "fn(date: datatype_date.Date, dateBegin: datatype_date.Date, dateEnd: datatype_date.Date) -> bool",
      "!doc": "Determines whether a given date is between two other dates on the\ncalendar.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_between"
     },
     "getJan1": {
      "!type": "fn(calendarYear: number) -> +datatype_date.Date",
      "!doc": "Retrieves a JavaScript Date object representing January 1 of any given\nyear.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getJan1"
     },
     "getDayOffset": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> number",
      "!doc": "Calculates the number of days between the specified dates.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getDayOffset"
     },
     "getHoursOffset": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> number",
      "!doc": "Calculates the number of hours between the specified dates.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getHoursOffset"
     },
     "getMinutesOffset": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> number",
      "!doc": "Calculates the number of minutes between the specified dates.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getMinutesOffset"
     },
     "getSecondsOffset": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> number",
      "!doc": "Calculates the number of seconds between the specified dates.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getSecondsOffset"
     },
     "getOffset": {
      "!type": "fn(d1, d2, constantAmount)",
      "!doc": "Returns the amount of time subtracted.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getOffset"
     },
     "getWeekNumber": {
      "!type": "fn(date: datatype_date.Date, firstDayOfWeek: number, janDate: number) -> number",
      "!doc": "Calculates the week number for the given date. Can currently support standard\nU.S. week numbers, based on Jan 1st defining the 1st week of the year, and\nISO8601 week numbers, based on Jan 4th defining the 1st week of the year.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getWeekNumber"
     },
     "getFirstDayOfWeek": {
      "!type": "fn(dt: datatype_date.Date, startOfWeek: number) -> +datatype_date.Date",
      "!doc": "Gets the first day of the week, for the give date.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getFirstDayOfWeek"
     },
     "isWeekDay": {
      "!type": "fn(date: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed date is a week day.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isWeekDay"
     },
     "isTueOrThu": {
      "!type": "fn(date: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed date is a Tuesday or Thursday.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isTueOrThu"
     },
     "isMonWedOrFri": {
      "!type": "fn(date: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed date is a Monday, Wednesday or Friday.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isMonWedOrFri"
     },
     "isNextDay": {
      "!type": "fn(date1: datatype_date.Date, date2: datatype_date.Date) -> ?",
      "!doc": "Checks if the {date2} is the next day.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isNextDay"
     },
     "isNextDayBoundary": {
      "!type": "fn(date1: datatype_date.Date, date2: datatype_date.Date) -> ?",
      "!doc": "Checks if the {date2} is the next day at 00:00:00.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isNextDayBoundary"
     },
     "isDayOverlap": {
      "!type": "fn(date1: datatype_date.Date, date2: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed date is between two days.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isDayOverlap"
     },
     "isToday": {
      "!type": "fn(date: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed date is today.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isToday"
     },
     "isSameMonth": {
      "!type": "fn(d1: datatype_date.Date, d2: datatype_date.Date) -> ?",
      "!doc": "Checks if the passed dates are in the same month.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isSameMonth"
     },
     "isYearOverlapWeek": {
      "!type": "fn(weekBeginDate: datatype_date.Date) -> bool",
      "!doc": "Determines if a given week overlaps two different years.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isYearOverlapWeek"
     },
     "isMonthOverlapWeek": {
      "!type": "fn(weekBeginDate: datatype_date.Date) -> bool",
      "!doc": "Determines if a given week overlaps two different months.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_isMonthOverlapWeek"
     },
     "findMonthStart": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Getss the first day of a month containing a given date.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_findMonthStart"
     },
     "findMonthEnd": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Gets the last day of a month containing a given date.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_findMonthEnd"
     },
     "clearTime": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Clears the time fields from a given date, effectively setting the time to\n12 noon.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_clearTime"
     },
     "safeClearTime": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Clears the time fields from a given date, effectively setting the time to\n12 noon. This is \"safe\" because clones the date before clear, not\naffecting the passed reference.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_safeClearTime"
     },
     "toLastHour": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Sets the time fields from a given date to the last possible hour.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_toLastHour"
     },
     "toMidnight": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Sets the time fields from a given date to midnight.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_toMidnight"
     },
     "clone": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Clones the passed date object.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_clone"
     },
     "getDate": {
      "!type": "fn(y: number, m: number, d: number) -> +datatype_date.Date",
      "!doc": "Returns a new JavaScript Date object, representing the given year,\nmonth and date. Time fields (hr, min, sec, ms) on the new Date object\nare set to 0. The method allows Date instances to be created with the a\nyear less than 100. \"new Date(year, month, date)\" implementations\nset the year to 19xx if a year (xx) which is less than 100 is provided.\n\n**NOTE:** Validation on argument values is not performed. It is the\ncaller's responsibility to ensure arguments are valid as per the\nECMAScript-262 Date object specification for the\nnew Date(year, month[, date]) constructor.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getDate"
     },
     "getDaysInMonth": {
      "!type": "fn(year, month) -> +datatype_date.Date",
      "!doc": "Gets date from a given month and year.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_getDaysInMonth"
     },
     "toUsTimeString": {
      "!type": "fn(date, padHours, omitMinutes, hideAmPm) -> string",
      "!doc": "Converts a date to US time format.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_toUsTimeString"
     },
     "toIsoTimeString": {
      "!type": "fn(date, showSeconds) -> string",
      "!doc": "Converts a date to ISO time format.",
      "!url": "http://alloyui.com/classes/A.DataType.DateMath.html#method_toIsoTimeString"
     }
    }
   }
  },
  "aui_datepicker": {
   "A.DatePickerDelegate": {
    "!type": "fn(config: yui.Object) -> +aui_datepicker.A.DatePickerDelegate",
    "!doc": "A base class for `DatePickerDelegate`.",
    "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html",
    "prototype": {
     "getSelectedDates": {
      "!type": "fn(node) -> +yui.Object",
      "!doc": "Gets the selected dates.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#method_getSelectedDates"
     },
     "getParsedDatesFromInputValue": {
      "!type": "fn(opt_value) -> +yui.Object",
      "!doc": "Gets parsed dates from input value.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#method_getParsedDatesFromInputValue"
     },
     "useInputNode": {
      "!type": "fn()",
      "!doc": "Method not implemented.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#method_useInputNode"
     },
     "useInputNodeOnce": {
      "!type": "fn(node)",
      "!doc": "Triggers `useInputNode` method once.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#method_useInputNodeOnce"
     },
     "activeInput": {
      "!type": "fn()",
      "!doc": "The active input element that holds the calendar instance.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_activeInput"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Contains an element.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_container"
     },
     "dateSeparator": {
      "!type": "fn()",
      "!doc": "Character that separate dates.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_dateSeparator"
     },
     "mask": {
      "!type": "fn()",
      "!doc": "Defines the date format.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_mask"
     },
     "trigger": {
      "!type": "fn()",
      "!doc": "Stores a trigger.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_trigger"
     },
     "valueExtractor": {
      "!type": "fn()",
      "!doc": "Extracts a value from a function.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_valueExtractor"
     },
     "valueFormatter": {
      "!type": "fn()",
      "!doc": "Formats a value from a function.",
      "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#attribute_valueFormatter"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for the\n`DatePickerDelegate`.",
     "!url": "http://alloyui.com/classes/A.DatePickerDelegate.html#property_ATTRS"
    }
   },
   "A.DatePickerNativeBase": {
    "!type": "fn(config: yui.Object) -> +aui_datepicker.A.DatePickerNativeBase",
    "!doc": "A base class for `DatePickerNativeBase`.",
    "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for the\n`DatePickerNativeBase`.",
     "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#property_ATTRS"
    },
    "prototype": {
     "nativeMask": {
      "!type": "fn()",
      "!doc": "Defines the native date mask.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#attribute_nativeMask"
     },
     "nativeType": {
      "!type": "fn()",
      "!doc": "Defines the type attribute in an HTML element.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#attribute_nativeType"
     },
     "bindNativeUI": {
      "!type": "fn()",
      "!doc": "Bind the events on the `DatePickerNativeBase` UI. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_bindNativeUI"
     },
     "clearSelection": {
      "!type": "fn()",
      "!doc": "Clears selected dates in the native calendar.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_clearSelection"
     },
     "deselectDates": {
      "!type": "fn()",
      "!doc": "Deselects dates in the native calendar.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_deselectDates"
     },
     "hide": {
      "!type": "fn()",
      "!doc": "Blurs native calendar.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_hide"
     },
     "show": {
      "!type": "fn()",
      "!doc": "Focus native calendar.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_show"
     },
     "selectDates": {
      "!type": "fn(dates)",
      "!doc": "Selects a date in the native calendar.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_selectDates"
     },
     "useInputNode": {
      "!type": "fn(node)",
      "!doc": "Renders the widget in an `<input>` node.",
      "!url": "http://alloyui.com/classes/A.DatePickerNativeBase.html#method_useInputNode"
     }
    }
   },
   "A.DatePickerPopover": {
    "!type": "fn(config: yui.Object) -> +aui_datepicker.A.DatePickerPopover",
    "!doc": "A base class for `DatePickerPopover`.",
    "!url": "http://alloyui.com/classes/A.DatePickerPopover.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for the\n`DatePickerPopover`.",
     "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#property_ATTRS"
    },
    "prototype": {
     "autoHide": {
      "!type": "fn()",
      "!doc": "Sets the initial visibility.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#attribute_autoHide"
     },
     "popover": {
      "!type": "fn()",
      "!doc": "Stores the configuration of the `Popover` instance.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#attribute_popover"
     },
     "popoverCssClass": {
      "!type": "fn()",
      "!doc": "Defines the CSS classname of the `Popover`.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#attribute_popoverCssClass"
     },
     "alignTo": {
      "!type": "fn(node)",
      "!doc": "Sets the `Popover` alignment.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#method_alignTo"
     },
     "getPopover": {
      "!type": "fn() -> +Popover",
      "!doc": "Returns an existent `Popover` instance or creates a new one if it\ndoesn't exists.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#method_getPopover"
     },
     "hide": {
      "!type": "fn()",
      "!doc": "Hides the `Popover`.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#method_hide"
     },
     "show": {
      "!type": "fn()",
      "!doc": "Shows the `Popover`.",
      "!url": "http://alloyui.com/classes/A.DatePickerPopover.html#method_show"
     }
    }
   },
   "A.DatePickerBase": {
    "!type": "fn(config: yui.Object) -> +aui_datepicker.A.DatePickerBase",
    "!doc": "A base class for `DatePickerBase`.",
    "!url": "http://alloyui.com/classes/A.DatePickerBase.html",
    "PANES": {
     "!type": "+yui.Array",
     "!doc": "Lists `CalendarBase` pane templates.",
     "!url": "http://alloyui.com/classes/A.DatePickerBase.html#property_PANES"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for the\n`DatePickerBase`.",
     "!url": "http://alloyui.com/classes/A.DatePickerBase.html#property_ATTRS"
    },
    "prototype": {
     "calendar": {
      "!type": "fn()",
      "!doc": "Stores the configuration of the `Calendar` instance.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#attribute_calendar"
     },
     "autoHide": {
      "!type": "fn()",
      "!doc": "Sets the initial visibility.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#attribute_autoHide"
     },
     "panes": {
      "!type": "fn()",
      "!doc": "Defines how many panes should be rendered.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#attribute_panes"
     },
     "clearSelection": {
      "!type": "fn(silent)",
      "!doc": "Clears a selection in the `Calendar`.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#method_clearSelection"
     },
     "deselectDates": {
      "!type": "fn(dates)",
      "!doc": "Deselects a date in the `Calendar`.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#method_deselectDates"
     },
     "getCalendar": {
      "!type": "fn() -> +calendar.Calendar",
      "!doc": "Returns an existent `Calendar` instance or creates a new one if it\ndoesn't exists.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#method_getCalendar"
     },
     "selectDates": {
      "!type": "fn(dates)",
      "!doc": "Selects a date in the `Calendar`.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#method_selectDates"
     },
     "useInputNode": {
      "!type": "fn(node)",
      "!doc": "Renders the widget in an `<input>` node.",
      "!url": "http://alloyui.com/classes/A.DatePickerBase.html#method_useInputNode"
     }
    }
   }
  },
  "aui_diagram_builder": {
   "A.AvailableField": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.AvailableField",
    "!proto": "base.Base",
    "!doc": "A base class for AvailableField.",
    "!url": "http://alloyui.com/classes/A.AvailableField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.AvailableField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.AvailableField`.",
     "!url": "http://alloyui.com/classes/A.AvailableField.html#property_ATTRS"
    },
    "prototype": {
     "draggable": {
      "!type": "fn()",
      "!doc": "Defines if the field is draggable or not.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_draggable"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The descriptor of a field.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_label"
     },
     "iconClass": {
      "!type": "fn()",
      "!doc": "The CSS class name used in the icon.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_iconClass"
     },
     "id": {
      "!type": "fn()",
      "!doc": "The identifier of a field.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_id"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The node used in a field.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_node"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of a field.",
      "!url": "http://alloyui.com/classes/A.AvailableField.html#attribute_type"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.AvailableField.html#property_EXTENDS"
    }
   },
   "A.FieldSupport": {
    "!type": "fn() -> +aui_diagram_builder.A.FieldSupport",
    "!doc": "A base class for `A.FieldSupport`.",
    "!url": "http://alloyui.com/classes/A.FieldSupport.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FieldSupport`.",
     "!url": "http://alloyui.com/classes/A.FieldSupport.html#property_ATTRS"
    },
    "prototype": {
     "fields": {
      "!type": "fn()",
      "!doc": "The collection of fields.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#attribute_fields"
     },
     "maxFields": {
      "!type": "fn()",
      "!doc": "Defines the maximum number of fields.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#attribute_maxFields"
     },
     "addField": {
      "!type": "fn(field, index)",
      "!doc": "Adds a single field in the field list.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#method_addField"
     },
     "createFields": {
      "!type": "fn(val) -> +A.ArrayList",
      "!doc": "Creates a collection of fields.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#method_createFields"
     },
     "removeField": {
      "!type": "fn(field)",
      "!doc": "Removes a single field from the field list.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#method_removeField"
     },
     "createField": {
      "!type": "fn(val)",
      "!doc": "Creates a single field.\n\nNOTE FOR DEVELOPERS: Yoy *may* want to replace the\nmethods from this section on your implementation.",
      "!url": "http://alloyui.com/classes/A.FieldSupport.html#method_createField"
     }
    }
   },
   "A.DiagramBuilderBase": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramBuilderBase",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for DiagramBuilderBase.",
    "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramBuilderBase`.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#property_ATTRS"
    },
    "prototype": {
     "availableFields": {
      "!type": "fn()",
      "!doc": "List of available fields.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_availableFields"
     },
     "availableFieldsDragConfig": {
      "!type": "fn()",
      "!doc": "The configuration object for draggable available fields.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_availableFieldsDragConfig"
     },
     "canvas": {
      "!type": "fn()",
      "!doc": "A node created using the `CANVAS_TEMPLATE` template.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_canvas"
     },
     "dropConfig": {
      "!type": "fn()",
      "!doc": "The configuration object for drop container node.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_dropConfig"
     },
     "contentContainer": {
      "!type": "fn()",
      "!doc": "Host node for content created using the `CONTENT_CONTAINER_TEMPLATE`\ntemplate.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_contentContainer"
     },
     "dropContainer": {
      "!type": "fn()",
      "!doc": "Host node for drop created using the `DROP_CONTAINER_TEMPLATE`\ntemplate.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_dropContainer"
     },
     "fieldsContainer": {
      "!type": "fn()",
      "!doc": "Host node for fields created using the `FIELDS_CONTAINER_TEMPLATE`\ntemplate.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_fieldsContainer"
     },
     "propertyList": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.PropertyList`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_propertyList"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_strings"
     },
     "tabView": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.TabView`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_tabView"
     },
     "toolbar": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.Toolbar`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_toolbar"
     },
     "toolbarContainer": {
      "!type": "fn()",
      "!doc": "Host node for toolbar created using the `TOOLBAR_CONTAINER_TEMPLATE`\ntemplate.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#attribute_toolbarContainer"
     },
     "isAvailableFieldsDrag": {
      "!type": "fn(drag) -> bool",
      "!doc": "Checks if the `availableFields` are draggable.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#method_isAvailableFieldsDrag"
     },
     "plotFields": {
      "!type": "fn()",
      "!doc": "Plots a collection of fields.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#method_plotFields"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values have to be parsed from markup.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#property_HTML_PARSER"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#property_UI_ATTRS"
    },
    "AUGMENTS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the augmented classes.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilderBase.html#property_AUGMENTS"
    }
   },
   "A.Connector": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.Connector",
    "!proto": "base.Base",
    "!doc": "A base class for Connector.",
    "!url": "http://alloyui.com/classes/A.Connector.html",
    "prototype": {
     "draw": {
      "!type": "fn()",
      "!doc": "Responsible for drawing the connectors.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_draw"
     },
     "getProperties": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the list of properties from the property model.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_getProperties"
     },
     "getPropertyModel": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the model defition of a property.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_getPropertyModel"
     },
     "getStrings": {
      "!type": "fn()",
      "!doc": "Gets the collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_getStrings"
     },
     "hide": {
      "!type": "fn()",
      "!doc": "Sets the visibility to `false`.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_hide"
     },
     "show": {
      "!type": "fn()",
      "!doc": "Sets the visibility to `true`.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_show"
     },
     "coord": {
      "!type": "fn()",
      "!doc": "Converts a coordinate to X and Y positions.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_coord"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Converts serializable attributes to JSON format.",
      "!url": "http://alloyui.com/classes/A.Connector.html#method_toJSON"
     },
     "arrowPoints": {
      "!type": "fn()",
      "!doc": "Arrow points from `A.PolygonUtil` instance.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_arrowPoints"
     },
     "builder": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.DiagramBuilder`.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_builder"
     },
     "color": {
      "!type": "fn()",
      "!doc": "The color used in the connector.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_color"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Graphic used to represent the connector.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_graphic"
     },
     "lazyDraw": {
      "!type": "fn()",
      "!doc": "Determine if the draw should be delayed or not.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_lazyDraw"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the connector.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_name"
     },
     "nodeName": {
      "!type": "fn()",
      "!doc": "The connector node name.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_nodeName"
     },
     "p1": {
      "!type": "fn()",
      "!doc": "Origin connector position.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_p1"
     },
     "p2": {
      "!type": "fn()",
      "!doc": "Destination connector position.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_p2"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Checks if a connector is selected or not.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_selected"
     },
     "shape": {
      "!type": "fn()",
      "!doc": "Graphic used to represent the connector's shape.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shape"
     },
     "shapeArrow": {
      "!type": "fn()",
      "!doc": "Graphic used to represent the connector's shape arrow.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shapeArrow"
     },
     "shapeArrowHover": {
      "!type": "fn()",
      "!doc": "Collection of styles applied when mouse is over the shape arrow.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shapeArrowHover"
     },
     "shapeArrowSelected": {
      "!type": "fn()",
      "!doc": "Collection of styles applied when shape arrow is selected.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shapeArrowSelected"
     },
     "shapeHover": {
      "!type": "fn()",
      "!doc": "Collection of styles applied when mouse is over the shape.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shapeHover"
     },
     "shapeSelected": {
      "!type": "fn()",
      "!doc": "Collection of styles applied when shape is selected.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_shapeSelected"
     },
     "showName": {
      "!type": "fn()",
      "!doc": "Sets the visibility of the connector name.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_showName"
     },
     "transition": {
      "!type": "fn()",
      "!doc": "Stores the uid, source and target data from a connector.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_transition"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether or not the connector is visible.",
      "!url": "http://alloyui.com/classes/A.Connector.html#attribute_visible"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.Connector`.",
     "!url": "http://alloyui.com/classes/A.Connector.html#property_ATTRS"
    },
    "STRINGS": {
     "!type": "+yui.Object",
     "!doc": "Collection of strings used to label elements of the UI.",
     "!url": "http://alloyui.com/classes/A.Connector.html#property_STRINGS"
    }
   },
   "A.DiagramBuilder": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramBuilder",
    "!proto": "aui_diagram_builder.A.DiagramBuilderBase",
    "!doc": "A base class for Diagram Builder.\n\nCheck the [live demo](http://alloyui.com/examples/diagram-builder/).",
    "!url": "http://alloyui.com/classes/A.DiagramBuilder.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramBuilder`.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#property_ATTRS"
    },
    "prototype": {
     "connector": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.Connector`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_connector"
     },
     "fieldsDragConfig": {
      "!type": "fn()",
      "!doc": "Configuration object for draggable fields.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_fieldsDragConfig"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.Graphic`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_graphic"
     },
     "highlightDropZones": {
      "!type": "fn()",
      "!doc": "Checks if the drop zones should be highlighted or not.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_highlightDropZones"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_strings"
     },
     "showSuggestConnector": {
      "!type": "fn()",
      "!doc": "Checks if a connector suggestion is visible or not.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_showSuggestConnector"
     },
     "suggestConnectorOverlay": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.Overlay` used in the connector suggestion.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#attribute_suggestConnectorOverlay"
     },
     "syncConnectionsUI": {
      "!type": "fn()",
      "!doc": "Syncs the connections in the UI.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_syncConnectionsUI"
     },
     "clearFields": {
      "!type": "fn()",
      "!doc": "Fetches all fields and destroys each instance of it.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_clearFields"
     },
     "closeEditProperties": {
      "!type": "fn()",
      "!doc": "Disables the settings tab and selects the field tab.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_closeEditProperties"
     },
     "connect": {
      "!type": "fn(diagramNode1, diagramNode2, optConnector)",
      "!doc": "Gets two `A.DiagramNode` instances and connect them.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_connect"
     },
     "connectAll": {
      "!type": "fn(nodes)",
      "!doc": "Creates a connector for each node that has source and target\nproperties.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_connectAll"
     },
     "createField": {
      "!type": "fn(val)",
      "!doc": "Creates a new field based on the field class type.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_createField"
     },
     "deleteSelectedConnectors": {
      "!type": "fn()",
      "!doc": "Fetches all selected connectors and disconnect them.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_deleteSelectedConnectors"
     },
     "deleteSelectedNode": {
      "!type": "fn()",
      "!doc": "Fetches the selected node and delete it.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_deleteSelectedNode"
     },
     "eachConnector": {
      "!type": "fn(fn)",
      "!doc": "An utility function to loop through all connectors.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_eachConnector"
     },
     "editConnector": {
      "!type": "fn(connector)",
      "!doc": "Enables the settings tab, sets the connector properties in the\nproperty list, and stores the connector in the `editingConnector` and\n`selectedConnector` attributes.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_editConnector"
     },
     "editNode": {
      "!type": "fn(diagramNode)",
      "!doc": "Enables the settings tab, sets the node properties in the property\nlist, and stores the node in the `editingNode` and `selectedNode`\nattributes.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_editNode"
     },
     "getFieldClass": {
      "!type": "fn(type)",
      "!doc": "Gets the field class based on the `A.DiagramBuilder` type. If the type\ndoesn't exist, logs an error message.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_getFieldClass"
     },
     "getNodesByTransitionProperty": {
      "!type": "fn(property, value)",
      "!doc": "Returns a collection of nodes by its transition property.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_getNodesByTransitionProperty"
     },
     "getSelectedConnectors": {
      "!type": "fn()",
      "!doc": "Returns a collection of selected connectors.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_getSelectedConnectors"
     },
     "getSourceNodes": {
      "!type": "fn(diagramNode)",
      "!doc": "Returns a collection of source nodes.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_getSourceNodes"
     },
     "hideSuggestConnectorOverlay": {
      "!type": "fn(diagramNode, drag)",
      "!doc": "Hides the suggest connector overlay.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_hideSuggestConnectorOverlay"
     },
     "isAbleToConnect": {
      "!type": "fn()",
      "!doc": "Checks if a node is able to connect with another.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_isAbleToConnect"
     },
     "isFieldsDrag": {
      "!type": "fn(drag)",
      "!doc": "Checks if the field is draggable.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_isFieldsDrag"
     },
     "plotField": {
      "!type": "fn(field)",
      "!doc": "Renders a field in the `dropContainer`.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_plotField"
     },
     "select": {
      "!type": "fn(diagramNode)",
      "!doc": "Selects and focus a certain node.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_select"
     },
     "showSuggestConnectorOverlay": {
      "!type": "fn(xy)",
      "!doc": "Shows the suggest connector overlay in a certain X and Y position.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_showSuggestConnectorOverlay"
     },
     "stopEditing": {
      "!type": "fn()",
      "!doc": "Clears node/connectors selections and close edit properties.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_stopEditing"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Converts fields to JSON format.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_toJSON"
     },
     "unselectConnectors": {
      "!type": "fn()",
      "!doc": "Clears connectors selection.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_unselectConnectors"
     },
     "unselectNodes": {
      "!type": "fn()",
      "!doc": "Clears nodes selection.",
      "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#method_unselectNodes"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#property_EXTENDS"
    },
    "FIELDS_TAB": {
     "!type": "number",
     "!doc": "The index of the fields tab.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#property_FIELDS_TAB"
    },
    "SETTINGS_TAB": {
     "!type": "number",
     "!doc": "The index of the settings tab.",
     "!url": "http://alloyui.com/classes/A.DiagramBuilder.html#property_SETTINGS_TAB"
    }
   },
   "A.DiagramNodeManagerBase": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeManagerBase",
    "!proto": "base.Base",
    "!doc": "A base class for DiagramNodeManagerBase.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeManagerBase.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeManagerBase.html#property_NAME"
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeManagerBase.html#property_EXTENDS"
    }
   },
   "A.DiagramNode": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNode",
    "!proto": "overlay.Overlay",
    "!doc": "A base class for DiagramNode.",
    "!url": "http://alloyui.com/classes/A.DiagramNode.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_NAME"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_UI_ATTRS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNode`.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_ATTRS"
    },
    "prototype": {
     "builder": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.DiagramBuilderBase`.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_builder"
     },
     "connectors": {
      "!type": "fn()",
      "!doc": "A map of connectors.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_connectors"
     },
     "controlsToolbar": {
      "!type": "fn()",
      "!doc": "A toolbar to represent controls.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_controlsToolbar"
     },
     "description": {
      "!type": "fn()",
      "!doc": "The description of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_description"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Stores an instance of `A.Graphic`.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_graphic"
     },
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_height"
     },
     "highlighted": {
      "!type": "fn()",
      "!doc": "Checks if a node is highlighted or not.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_highlighted"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_name"
     },
     "required": {
      "!type": "fn()",
      "!doc": "Checks if a node is required or not.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_required"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Checks if a node is selected or not.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_selected"
     },
     "shapeBoundary": {
      "!type": "fn()",
      "!doc": "A graphic shape to represent a boundary.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_shapeBoundary"
     },
     "highlightBoundaryStroke": {
      "!type": "fn()",
      "!doc": "Represents a stroke to highlight a boundary.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_highlightBoundaryStroke"
     },
     "shapeInvite": {
      "!type": "fn()",
      "!doc": "Configuration object to generate the shape invite graphic.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_shapeInvite"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_strings"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "Specify the tab order of elements.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_tabIndex"
     },
     "transitions": {
      "!type": "fn()",
      "!doc": "Map of transitions that stores the uid, source and target data from\nconnectors.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_transitions"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_width"
     },
     "zIndex": {
      "!type": "fn()",
      "!doc": "Specify the stack order of elements.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#attribute_zIndex"
     },
     "addTransition": {
      "!type": "fn(transition)",
      "!doc": "Adds a transition into the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_addTransition"
     },
     "alignTransition": {
      "!type": "fn(transition)",
      "!doc": "Aligns a single transition.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_alignTransition"
     },
     "alignTransitions": {
      "!type": "fn()",
      "!doc": "Aligns a collection of transitions.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_alignTransitions"
     },
     "close": {
      "!type": "fn()",
      "!doc": "Destroys this instance.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_close"
     },
     "connect": {
      "!type": "fn(transition, optConnector)",
      "!doc": "Checks if a transition is connected, if not creates a new\n`A.Connector` instance.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connect"
     },
     "connectDrop": {
      "!type": "fn(event)",
      "!doc": "Calls the `connectNode` method with `publishedTarget` parameter.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectDrop"
     },
     "connectEnd": {
      "!type": "fn(event)",
      "!doc": "Handles the `connectEnd` event.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectEnd"
     },
     "connectMove": {
      "!type": "fn(event)",
      "!doc": "Sets the connector position based on the mouse X and Y positions.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectMove"
     },
     "connectNode": {
      "!type": "fn(diagramNode)",
      "!doc": "Prepares the transition and connects a node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectNode"
     },
     "connectOutTarget": {
      "!type": "fn(event)",
      "!doc": "Sets the `publishedTarget` attribute to null and hiddes the\n`publishedSource`'s invite.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectOutTarget"
     },
     "connectOverTarget": {
      "!type": "fn(event)",
      "!doc": "If `publishedSource` is different from the current instance, sets the\n`publishedTarget` to the current instance.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectOverTarget"
     },
     "connectStart": {
      "!type": "fn(event)",
      "!doc": "Highlights each diagram node and fires a `publishedSource` event.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_connectStart"
     },
     "disconnect": {
      "!type": "fn(transition)",
      "!doc": "Checks if a transition is connected, if yes removes the transition.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_disconnect"
     },
     "eachConnector": {
      "!type": "fn(fn)",
      "!doc": "An utility function to loop through all connectors.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_eachConnector"
     },
     "getConnector": {
      "!type": "fn(transition)",
      "!doc": "Returns a connector based on the transition uid.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_getConnector"
     },
     "getContainer": {
      "!type": "fn()",
      "!doc": "Returns the `dropContainer` or bounding box's parent node.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_getContainer"
     },
     "getLeftTop": {
      "!type": "fn()",
      "!doc": "Returns the left and top positions of a node based in its container.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_getLeftTop"
     },
     "getProperties": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the list of properties from the property model.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_getProperties"
     },
     "getPropertyModel": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the model defition of a property.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_getPropertyModel"
     },
     "isBoundaryDrag": {
      "!type": "fn(drag) -> bool",
      "!doc": "Checks if boundary is draggable.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_isBoundaryDrag"
     },
     "isTransitionConnected": {
      "!type": "fn(transition)",
      "!doc": "Checks if a connector has an transition uid property.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_isTransitionConnected"
     },
     "prepareTransition": {
      "!type": "fn(val)",
      "!doc": "Builds the transition configuration object.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_prepareTransition"
     },
     "removeTransition": {
      "!type": "fn(transition)",
      "!doc": "Removes the transition uid from a transition.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_removeTransition"
     },
     "renderShapeBoundary": {
      "!type": "fn()",
      "!doc": "Renders the `shapeBoundary` attribute.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_renderShapeBoundary"
     },
     "renderShapeInvite": {
      "!type": "fn()",
      "!doc": "Renders the `shapeInvite` attribute.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_renderShapeInvite"
     },
     "syncConnectionsUI": {
      "!type": "fn()",
      "!doc": "Syncs the connections in the UI.",
      "!url": "http://alloyui.com/classes/A.DiagramNode.html#method_syncConnectionsUI"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_EXTENDS"
    },
    "CIRCLE_POINTS": {
     "!type": "+yui.Array",
     "!doc": "Coordinates to generate a circle graphic.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_CIRCLE_POINTS"
    },
    "DIAMOND_POINTS": {
     "!type": "+yui.Array",
     "!doc": "Coordinates to generate a diamond graphic.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_DIAMOND_POINTS"
    },
    "SQUARE_POINTS": {
     "!type": "+yui.Array",
     "!doc": "Coordinates to generate a square graphic.",
     "!url": "http://alloyui.com/classes/A.DiagramNode.html#property_SQUARE_POINTS"
    }
   },
   "A.DiagramNodeState": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeState",
    "!proto": "aui_diagram_builder.A.DiagramNode",
    "!doc": "A base class for DiagramNodeState.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeState.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeState`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#attribute_height"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#attribute_width"
     },
     "renderShapeBoundary": {
      "!type": "fn()",
      "!doc": "Renders the shape boundary.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#method_renderShapeBoundary"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeState.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeCondition": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeCondition",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for DiagramNodeCondition.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeCondition`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#attribute_height"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#attribute_width"
     },
     "renderShapeBoundary": {
      "!type": "fn()",
      "!doc": "Renders the shape boundary.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#method_renderShapeBoundary"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeCondition.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeStart": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeStart",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for DiagramNodeStart.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeStart.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeStart.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeStart`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeStart.html#property_ATTRS"
    },
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeStart.html#attribute_type"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeStart.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeEnd": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeEnd",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for DiagramNodeEnd.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeEnd.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeEnd.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeEnd`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeEnd.html#property_ATTRS"
    },
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeEnd.html#attribute_type"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeEnd.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeJoin": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeJoin",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for DiagramNodeJoin.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeJoin`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#attribute_height"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#attribute_width"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeJoin.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeFork": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeFork",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for DiagramNodeFork.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeFork`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#attribute_height"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#attribute_width"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeFork.html#property_EXTENDS"
    }
   },
   "A.DiagramNodeTask": {
    "!type": "fn(config: yui.Object) -> +aui_diagram_builder.A.DiagramNodeTask",
    "!proto": "aui_diagram_builder.A.DiagramNodeState",
    "!doc": "A base class for `A.DiagramNodeTask`.",
    "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.DiagramNodeTask`.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#property_ATTRS"
    },
    "prototype": {
     "height": {
      "!type": "fn()",
      "!doc": "The height of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#attribute_height"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#attribute_type"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the node.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#attribute_width"
     },
     "renderShapeBoundary": {
      "!type": "fn()",
      "!doc": "Renders the shape boundary.",
      "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#method_renderShapeBoundary"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.DiagramNodeTask.html#property_EXTENDS"
    }
   }
  },
  "aui_event": {
   "A.FormBuilderAvailableField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderAvailableField",
    "!proto": "aui_diagram_builder.A.AvailableField",
    "!doc": "A base class for `A.FormBuilderAvailableField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html",
    "prototype": {
     "hasModifier": {
      "!type": "fn() -> bool",
      "!doc": "Checks if an event is triggered by a keyboard key like `CTRL`, `ALT`\nor `SHIFT`.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_hasModifier"
     },
     "isKey": {
      "!type": "fn(name) -> bool",
      "!doc": "Checks if an event is triggered by a keyboard key.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isKey"
     },
     "isKeyInRange": {
      "!type": "fn(start, end) -> bool",
      "!doc": "Checks if an event is triggered by a keyboard key located between two\nother keys.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isKeyInRange"
     },
     "isKeyInSet": {
      "!type": "fn() -> bool",
      "!doc": "Checks if an event is triggered by a keyboard key contained in the\nkey set.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isKeyInSet"
     },
     "isModifyingKey": {
      "!type": "fn()",
      "!doc": "Checks if an event is triggered by `ENTER`, `TAB`, `ESC` keyboard\nkeys or by a key located between `PAGE UP` and `DOWN`.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isModifyingKey"
     },
     "isNavKey": {
      "!type": "fn() -> bool",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isNavKey"
     },
     "isSpecialKey": {
      "!type": "fn() -> bool",
      "!doc": "Checks if an event is triggered by a special keyboard key like\n`SHIFT`, `CAPS LOCK`, etc.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_isSpecialKey"
     },
     "change": {
      "!type": "fn()",
      "!doc": "Defines a new `change` event in the DOM event system.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#event_change"
     },
     "delegate": {
      "!type": "fn(node, subscription, notifier, filter)",
      "!doc": "Implementation logic for subscription via `node.delegate`.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_delegate"
     },
     "detach": {
      "!type": "fn(node, subscription, notifier)",
      "!doc": "Implementation logic for cleaning up a detached subscription.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_detach"
     },
     "detachDelegate": {
      "!type": "fn(node, subscription, notifier)",
      "!doc": "Implementation logic for cleaning up a detached delegate subscription.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_detachDelegate"
     },
     "on": {
      "!type": "fn(node, subscription, notifier)",
      "!doc": "Implementation logic for event subscription.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#method_on"
     },
     "submit": {
      "!type": "fn()",
      "!doc": "Defines a new `submit` event in the DOM event system.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#event_submit"
     },
     "input": {
      "!type": "fn()",
      "!doc": "Defines a new `input` event in the DOM event system.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#event_input"
     }
    }
   }
  },
  "aui_form_builder": {
   "A.FormBuilderAvailableField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderAvailableField",
    "!proto": "aui_diagram_builder.A.AvailableField",
    "!doc": "A base class for `A.FormBuilderAvailableField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderAvailableField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#property_ATTRS"
    },
    "prototype": {
     "hiddenAttributes": {
      "!type": "fn()",
      "!doc": "List of hidden attributes.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_hiddenAttributes"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_name"
     },
     "options": {
      "!type": "fn()",
      "!doc": "Collection of options.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_options"
     },
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_predefinedValue"
     },
     "readOnlyAttributes": {
      "!type": "fn()",
      "!doc": "List of read-only input fields.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_readOnlyAttributes"
     },
     "required": {
      "!type": "fn()",
      "!doc": "Checks if an input field is required. In other words, it needs\ncontent to be valid.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_required"
     },
     "showLabel": {
      "!type": "fn()",
      "!doc": "If `true` the label is showed.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_showLabel"
     },
     "tip": {
      "!type": "fn()",
      "!doc": "Hint to help the user to fill the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_tip"
     },
     "unique": {
      "!type": "fn()",
      "!doc": "Checks if the input field is unique or not.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_unique"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#attribute_width"
     }
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderAvailableField.html#property_EXTENDS"
    }
   },
   "A.FormBuilder": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilder",
    "!proto": "aui_diagram_builder.A.DiagramBuilderBase",
    "!doc": "A base class for `A.FormBuilder`.",
    "!url": "http://alloyui.com/classes/A.FormBuilder.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilder`.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_ATTRS"
    },
    "prototype": {
     "allowRemoveRequiredFields": {
      "!type": "fn()",
      "!doc": "Checks if removing required fields is permitted or not.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#attribute_allowRemoveRequiredFields"
     },
     "enableEditing": {
      "!type": "fn()",
      "!doc": "Enables a field to be editable.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#attribute_enableEditing"
     },
     "fieldsSortableListConfig": {
      "!type": "fn()",
      "!doc": "Collection of sortable fields.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#attribute_fieldsSortableListConfig"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#attribute_strings"
     },
     "closeEditProperties": {
      "!type": "fn()",
      "!doc": "Selects the field tab and disables the setting tabs.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_closeEditProperties"
     },
     "createField": {
      "!type": "fn(config) -> +yui.Object",
      "!doc": "Creates a field and returns its configuration.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_createField"
     },
     "duplicateField": {
      "!type": "fn(field)",
      "!doc": "Gets the current field index and then clones the field. Inserts the\nnew one after the current field index, inside of the current field\nparent.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_duplicateField"
     },
     "editField": {
      "!type": "fn(field)",
      "!doc": "Checks if the current field is a `A.FormBuilderField` instance and\nselects it.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_editField"
     },
     "getFieldClass": {
      "!type": "fn(type) -> +yui.Object",
      "!doc": "Gets the field class based on the `A.FormBuilder` type. If the type\ndoesn't exist, logs an error message.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_getFieldClass"
     },
     "getFieldProperties": {
      "!type": "fn(field) -> +yui.Array",
      "!doc": "Gets a list of properties from the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_getFieldProperties"
     },
     "insertField": {
      "!type": "fn(field, index, parent)",
      "!doc": "Removes field from previous parent and inserts into the new parent.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_insertField"
     },
     "openEditProperties": {
      "!type": "fn(field)",
      "!doc": "Enables the settings tab.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_openEditProperties"
     },
     "plotField": {
      "!type": "fn(field, container)",
      "!doc": "Renders a field in the container.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_plotField"
     },
     "plotFields": {
      "!type": "fn(fields, container)",
      "!doc": "Renders a list of fields in the container.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_plotFields"
     },
     "selectFields": {
      "!type": "fn(fields)",
      "!doc": "Adds fields to a `A.LinkedSet` instance.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_selectFields"
     },
     "simulateFocusField": {
      "!type": "fn(field)",
      "!doc": "Triggers a focus event in the current field and a blur event in the\nlast focused field.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_simulateFocusField"
     },
     "unselectFields": {
      "!type": "fn(fields)",
      "!doc": "Removes fields from the `A.LinkedSet` instance.",
      "!url": "http://alloyui.com/classes/A.FormBuilder.html#method_unselectFields"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_UI_ATTRS"
    },
    "EXTENDS": {
     "!type": "string",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_EXTENDS"
    },
    "FIELDS_TAB": {
     "!type": "number",
     "!doc": "Static property used to define the fields tab.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_FIELDS_TAB"
    },
    "SETTINGS_TAB": {
     "!type": "number",
     "!doc": "Static property used to define the settings tab.",
     "!url": "http://alloyui.com/classes/A.FormBuilder.html#property_SETTINGS_TAB"
    }
   },
   "A.FormBuilderFieldBase": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderFieldBase",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for `A.FormBuilderFieldBase`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderFieldBase.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldBase.html#property_NAME"
    },
    "AUGMENTS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the augmented classes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldBase.html#property_AUGMENTS"
    }
   },
   "A.FormBuilderField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderField",
    "!proto": "aui_form_builder.A.FormBuilderFieldBase",
    "!doc": "A base class for `A.FormBuilderField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderField.html#property_ATTRS"
    },
    "prototype": {
     "acceptChildren": {
      "!type": "fn()",
      "!doc": "If `true` children are accepted.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_acceptChildren"
     },
     "builder": {
      "!type": "fn()",
      "!doc": "The `A.FormBuilder` instance.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_builder"
     },
     "controlsToolbar": {
      "!type": "fn()",
      "!doc": "Collection of toolbar controls.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_controlsToolbar"
     },
     "dataType": {
      "!type": "fn()",
      "!doc": "Indicates which is the type of data for the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_dataType"
     },
     "disabled": {
      "!type": "fn()",
      "!doc": "Checks if the input field is disabled or not.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_disabled"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Checks if the input field is selected or not.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_selected"
     },
     "hiddenAttributes": {
      "!type": "fn()",
      "!doc": "List of hidden attributes.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_hiddenAttributes"
     },
     "id": {
      "!type": "fn()",
      "!doc": "The id of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_id"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The label of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_label"
     },
     "localizationMap": {
      "!type": "fn()",
      "!doc": "Collection for content localization.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_localizationMap"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_name"
     },
     "parent": {
      "!type": "fn()",
      "!doc": "Container for the field parent.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_parent"
     },
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_predefinedValue"
     },
     "readOnly": {
      "!type": "fn()",
      "!doc": "Checks if an input field is read-only.\nIn other words, it cannot be modified.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_readOnly"
     },
     "readOnlyAttributes": {
      "!type": "fn()",
      "!doc": "List of read-only input fields.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_readOnlyAttributes"
     },
     "required": {
      "!type": "fn()",
      "!doc": "Checks if an input field is required.\nIn other words, it needs content to be valid.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_required"
     },
     "showLabel": {
      "!type": "fn()",
      "!doc": "If `true` the label is showed.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_showLabel"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_strings"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "Specify the tab order.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_tabIndex"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_template"
     },
     "tip": {
      "!type": "fn()",
      "!doc": "Hint to help the user to fill the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_tip"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Defines the type of field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_type"
     },
     "unique": {
      "!type": "fn()",
      "!doc": "Checks if the input field is unique or not.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_unique"
     },
     "zIndex": {
      "!type": "fn()",
      "!doc": "Stack order of the field. An element with greater stack order is\nalways in front of an element with a lower stack order.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_zIndex"
     },
     "dropZoneNode": {
      "!type": "fn()",
      "!doc": "Node used to generate the drop zone.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_dropZoneNode"
     },
     "labelNode": {
      "!type": "fn()",
      "!doc": "Node used to generate a label.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_labelNode"
     },
     "requiredFlagNode": {
      "!type": "fn()",
      "!doc": "Node used to generate the required flag.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_requiredFlagNode"
     },
     "templateNode": {
      "!type": "fn()",
      "!doc": "Node used to generate a template.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_templateNode"
     },
     "tipFlagNode": {
      "!type": "fn()",
      "!doc": "Node used to generate a tip.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#attribute_tipFlagNode"
     },
     "createField": {
      "!type": "fn(val) -> +yui.Object",
      "!doc": "Creates the field using the `createField` method from\n`A.FormBuilder`.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method_createField"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Gets the field markup.\n\nTo developer: Implement this",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method_getHTML"
     },
     "getNode": {
      "!type": "fn() -> +node.Node",
      "!doc": "Creates a `Node` from the HTML string.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method_getNode"
     },
     "getProperties": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets properties from the property model.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method_getProperties"
     },
     "getPropertyModel": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Returns a list of property models. Each property model is made of a\nname, attribute, editor, and formatter.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method_getPropertyModel"
     },
     "_getToolbarItems": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets a list of toolbar items.",
      "!url": "http://alloyui.com/classes/A.FormBuilderField.html#method__getToolbarItems"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderField.html#property_UI_ATTRS"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderField.html#property_EXTENDS"
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values have to be parsed from markup.",
     "!url": "http://alloyui.com/classes/A.FormBuilderField.html#property_HTML_PARSER"
    }
   },
   "A.FormBuilderButtonField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderButtonField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderButtonField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderButtonField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#property_ATTRS"
    },
    "prototype": {
     "acceptChildren": {
      "!type": "fn()",
      "!doc": "If `true` children are accepted.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#attribute_acceptChildren"
     },
     "buttonType": {
      "!type": "fn()",
      "!doc": "Defines the button type attribute, e.g. `type=\"reset\"`.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#attribute_buttonType"
     },
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the button field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#attribute_predefinedValue"
     },
     "showLabel": {
      "!type": "fn()",
      "!doc": "If `true` the label is showed.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#attribute_showLabel"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#attribute_template"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#method_getHTML"
     },
     "getPropertyModel": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Returns a list of property models including the `A.RadioCellEditor`\nmodel.",
      "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#method_getPropertyModel"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#property_UI_ATTRS"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderButtonField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderCheckBoxField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderCheckBoxField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderCheckBoxField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderCheckBoxField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#property_ATTRS"
    },
    "prototype": {
     "dataType": {
      "!type": "fn()",
      "!doc": "Indicates which is the type of data for the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#attribute_dataType"
     },
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the checkbox field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#attribute_predefinedValue"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#attribute_template"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the `A.RadioCellEditor`\nmodel.",
      "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#method_getPropertyModel"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#method_getHTML"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderCheckBoxField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderFieldsetField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderFieldsetField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderFieldsetField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderFieldsetField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#property_ATTRS"
    },
    "prototype": {
     "acceptChildren": {
      "!type": "fn()",
      "!doc": "If `true` children are accepted.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#attribute_acceptChildren"
     },
     "dataType": {
      "!type": "fn()",
      "!doc": "Indicates which is the type of data for the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#attribute_dataType"
     },
     "labelNode": {
      "!type": "fn()",
      "!doc": "Markup used to generate a label.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#attribute_labelNode"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#attribute_template"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#method_getHTML"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the `A.TextCellEditor()`\nand `A.RadioCellEditor` models.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#method_getPropertyModel"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#property_UI_ATTRS"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFieldsetField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderFileUploadField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderFileUploadField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderFileUploadField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderFileUploadField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#property_ATTRS"
    },
    "prototype": {
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#attribute_template"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#method_getHTML"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderFileUploadField.html#property_EXTENDS"
    }
   },
   "A.OptionsEditor": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.OptionsEditor",
    "!proto": "aui_datatable.A.RadioCellEditor",
    "!doc": "A base class for `A.OptionsEditor`.",
    "!url": "http://alloyui.com/classes/A.OptionsEditor.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.OptionsEditor.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.OptionsEditor`.",
     "!url": "http://alloyui.com/classes/A.OptionsEditor.html#property_ATTRS"
    },
    "prototype": {
     "editable": {
      "!type": "fn()",
      "!doc": "Defines if a field is editable.",
      "!url": "http://alloyui.com/classes/A.OptionsEditor.html#attribute_editable"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.OptionsEditor.html#property_EXTENDS"
    }
   },
   "A.FormBuilderMultipleChoiceField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderMultipleChoiceField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderMultipleChoiceField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderMultipleChoiceField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#property_ATTRS"
    },
    "prototype": {
     "acceptChildren": {
      "!type": "fn()",
      "!doc": "If `true` children are accepted.",
      "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#attribute_acceptChildren"
     },
     "options": {
      "!type": "fn()",
      "!doc": "Collection of options. Each option is made of a label and value.",
      "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#attribute_options"
     },
     "optionTemplate": {
      "!type": "fn()",
      "!doc": "Markup used to generate each item from `options` attribute.",
      "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#attribute_optionTemplate"
     },
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the multiple choice field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#attribute_predefinedValue"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the `A.RadioCellEditor`\nmodel.",
      "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#method_getPropertyModel"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#property_UI_ATTRS"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderMultipleChoiceField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderRadioField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderRadioField",
    "!proto": "aui_form_builder.A.FormBuilderMultipleChoiceField",
    "!doc": "A base class for `A.FormBuilderRadioField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderRadioField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#property_ATTRS"
    },
    "prototype": {
     "predefinedValue": {
      "!type": "fn()",
      "!doc": "Specifies a predefined value for the radio field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#attribute_predefinedValue"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#attribute_template"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Returns the HTML template.",
      "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#method_getHTML"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderRadioField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderSelectField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderSelectField",
    "!proto": "aui_form_builder.A.FormBuilderMultipleChoiceField",
    "!doc": "A base class for `A.FormBuilderSelectField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderSelectField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#property_ATTRS"
    },
    "prototype": {
     "multiple": {
      "!type": "fn()",
      "!doc": "Checks if the drop-down list allows multiple selections.",
      "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#attribute_multiple"
     },
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#attribute_template"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#method_getHTML"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the `A.RadioCellEditor`\nmodel.",
      "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#method_getPropertyModel"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#property_UI_ATTRS"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderSelectField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderTextField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderTextField",
    "!proto": "aui_form_builder.A.FormBuilderField",
    "!doc": "A base class for `A.FormBuilderTextField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderTextField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#property_ATTRS"
    },
    "prototype": {
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#attribute_template"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the input field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#attribute_width"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Injects data into the template and returns the HTML result.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#method_getHTML"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the `A.RadioCellEditor`\nmodel.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#method_getPropertyModel"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextField.html#property_EXTENDS"
    }
   },
   "A.FormBuilderTextAreaField": {
    "!type": "fn(config: yui.Object) -> +aui_form_builder.A.FormBuilderTextAreaField",
    "!proto": "aui_form_builder.A.FormBuilderTextField",
    "!doc": "A base class for `A.FormBuilderTextAreaField`.",
    "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormBuilderTextAreaField`.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#property_ATTRS"
    },
    "prototype": {
     "template": {
      "!type": "fn()",
      "!doc": "Reusable block of markup used to generate the field.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#attribute_template"
     },
     "getPropertyModel": {
      "!type": "fn()",
      "!doc": "Returns a list of property models including the\n`A.TextAreaCellEditor` model.",
      "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#method_getPropertyModel"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormBuilderTextAreaField.html#property_EXTENDS"
    }
   }
  },
  "aui_form_validator": {
   "A.FormValidator": {
    "!type": "fn(config: yui.Object) -> +aui_form_validator.A.FormValidator",
    "!proto": "base.Base",
    "!doc": "A base class for `A.FormValidator`.",
    "!url": "http://alloyui.com/classes/A.FormValidator.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.FormValidator.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.FormValidator`.",
     "!url": "http://alloyui.com/classes/A.FormValidator.html#property_ATTRS"
    },
    "prototype": {
     "boundingBox": {
      "!type": "fn()",
      "!doc": "The widget's outermost node, used for sizing and positioning.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_boundingBox"
     },
     "containerErrorClass": {
      "!type": "fn()",
      "!doc": "Container for the CSS error class.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_containerErrorClass"
     },
     "containerValidClass": {
      "!type": "fn()",
      "!doc": "Container for the CSS valid class.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_containerValidClass"
     },
     "errorClass": {
      "!type": "fn()",
      "!doc": "Defines the CSS error class.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_errorClass"
     },
     "extractRules": {
      "!type": "fn()",
      "!doc": "If `true` the validation rules are extracted from the DOM.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_extractRules"
     },
     "fieldContainer": {
      "!type": "fn()",
      "!doc": "Container for a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_fieldContainer"
     },
     "fieldStrings": {
      "!type": "fn()",
      "!doc": "Collection of strings used on a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_fieldStrings"
     },
     "labelCssClass": {
      "!type": "fn()",
      "!doc": "The CSS class for `<label>`.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_labelCssClass"
     },
     "messageContainer": {
      "!type": "fn()",
      "!doc": "Container for the form message.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_messageContainer"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_strings"
     },
     "rules": {
      "!type": "fn()",
      "!doc": "Collection of rules to validate fields.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_rules"
     },
     "selectText": {
      "!type": "fn()",
      "!doc": "Defines if the text will be selected or not after validation.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_selectText"
     },
     "showMessages": {
      "!type": "fn()",
      "!doc": "Defines if the validation messages will be showed or not.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_showMessages"
     },
     "showAllMessages": {
      "!type": "fn()",
      "!doc": "Defines if all validation messages will be showed or not.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_showAllMessages"
     },
     "stackErrorContainer": {
      "!type": "fn()",
      "!doc": "Defines a container for the stack errors.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_stackErrorContainer"
     },
     "validateOnBlur": {
      "!type": "fn()",
      "!doc": "If `true` the field will be validated on blur event.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_validateOnBlur"
     },
     "validateOnInput": {
      "!type": "fn()",
      "!doc": "If `true` the field will be validated on input event.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_validateOnInput"
     },
     "validClass": {
      "!type": "fn()",
      "!doc": "Defines the CSS valid class.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#attribute_validClass"
     },
     "addFieldError": {
      "!type": "fn(field, ruleName)",
      "!doc": "Adds a validation error in the field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_addFieldError"
     },
     "clearFieldError": {
      "!type": "fn(field)",
      "!doc": "Removes a validation error in the field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_clearFieldError"
     },
     "eachRule": {
      "!type": "fn(fn)",
      "!doc": "Executes a function to each rule.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_eachRule"
     },
     "findFieldContainer": {
      "!type": "fn(field) -> +node.Node",
      "!doc": "Gets the ancestor of a given field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_findFieldContainer"
     },
     "focusInvalidField": {
      "!type": "fn()",
      "!doc": "Focus on the invalid field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_focusInvalidField"
     },
     "getField": {
      "!type": "fn(fieldOrFieldName) -> +node.Node",
      "!doc": "Gets a field from the form.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_getField"
     },
     "getFieldsByName": {
      "!type": "fn(fieldName) -> +node.NodeList",
      "!doc": "Gets a list of fields based on its name.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_getFieldsByName"
     },
     "getFieldError": {
      "!type": "fn(field) -> string",
      "!doc": "Gets a list of fields with errors.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_getFieldError"
     },
     "getFieldStackErrorContainer": {
      "!type": "fn(field)",
      "!doc": "Gets the stack error container of a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_getFieldStackErrorContainer"
     },
     "getFieldErrorMessage": {
      "!type": "fn(field, rule) -> string",
      "!doc": "Gets the error message of a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_getFieldErrorMessage"
     },
     "hasErrors": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if there are errors.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_hasErrors"
     },
     "highlight": {
      "!type": "fn(field, valid)",
      "!doc": "Highlights a field with error or success.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_highlight"
     },
     "normalizeRuleValue": {
      "!type": "fn(ruleValue)",
      "!doc": "Normalizes rule value.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_normalizeRuleValue"
     },
     "unhighlight": {
      "!type": "fn(field)",
      "!doc": "Removes the highlight of a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_unhighlight"
     },
     "printStackError": {
      "!type": "fn(field, container, errors)",
      "!doc": "Prints the stack error messages into a container.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_printStackError"
     },
     "resetAllFields": {
      "!type": "fn()",
      "!doc": "Resets the CSS class and content of all fields.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_resetAllFields"
     },
     "resetField": {
      "!type": "fn(field)",
      "!doc": "Resets the CSS class and content of a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_resetField"
     },
     "resetFieldCss": {
      "!type": "fn(field)",
      "!doc": "Removes the CSS classes of a field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_resetFieldCss"
     },
     "validatable": {
      "!type": "fn(field) -> bool",
      "!doc": "Checks if a field can be validated or not.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_validatable"
     },
     "validate": {
      "!type": "fn()",
      "!doc": "Validates all fields.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_validate"
     },
     "validateField": {
      "!type": "fn(field)",
      "!doc": "Validates a single field.",
      "!url": "http://alloyui.com/classes/A.FormValidator.html#method_validateField"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.FormValidator.html#property_EXTENDS"
    }
   }
  },
  "aui_image_cropper": {
   "A.ImageCropper": {
    "!type": "fn(config: yui.Object) -> +aui_image_cropper.A.ImageCropper",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Image Cropper.\n\nCheck the [live demo](http://alloyui.com/examples/image-cropper/).",
    "!url": "http://alloyui.com/classes/A.ImageCropper.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ImageCropper.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Image Cropper.",
     "!url": "http://alloyui.com/classes/A.ImageCropper.html#property_ATTRS"
    },
    "prototype": {
     "cropHeight": {
      "!type": "fn()",
      "!doc": "The height of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_cropHeight"
     },
     "cropWidth": {
      "!type": "fn()",
      "!doc": "The width of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_cropWidth"
     },
     "minWidth": {
      "!type": "fn()",
      "!doc": "The minimum width of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_minWidth"
     },
     "minHeight": {
      "!type": "fn()",
      "!doc": "The minimum height of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_minHeight"
     },
     "movable": {
      "!type": "fn()",
      "!doc": "Determine if the crop area should move or not.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_movable"
     },
     "preserveRatio": {
      "!type": "fn()",
      "!doc": "Determine if the crop area should preserve the\naspect ratio or not.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_preserveRatio"
     },
     "region": {
      "!type": "fn()",
      "!doc": "Determine the region of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_region"
     },
     "resizable": {
      "!type": "fn()",
      "!doc": "Determine if the crop area should resize or not.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_resizable"
     },
     "x": {
      "!type": "fn()",
      "!doc": "The X position of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "The Y position of a selected area to crop.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#attribute_y"
     },
     "syncImageUI": {
      "!type": "fn()",
      "!doc": "Sync the image on the UI.",
      "!url": "http://alloyui.com/classes/A.ImageCropper.html#method_syncImageUI"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.ImageCropper.html#property_UI_ATTRS"
    }
   }
  },
  "aui_image_viewer": {
   "A.ImageViewer": {
    "!type": "fn(config: yui.Object) -> +aui_image_viewer.A.ImageViewer",
    "!proto": "widget.Widget",
    "!doc": "A base class for `A.ImageViewer`, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Displays an image in a Overlay\n- Keyboard navigation support\n\nCheck the [live demo](http://alloyui.com/examples/image-viewer/).",
    "!url": "http://alloyui.com/classes/A.ImageViewer.html",
    "prototype": {
     "close": {
      "!type": "fn()",
      "!doc": "Hides the `A.ImageViewer` instance.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_close"
     },
     "getLink": {
      "!type": "fn(currentIndex: number) -> +node.Node",
      "!doc": "Gets the `Node` reference to the `currentIndex` element from\nthe [links](A.ImageViewer.html#attr_links).",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_getLink"
     },
     "getCurrentLink": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets the current loaded node link reference.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_getCurrentLink"
     },
     "loadImage": {
      "!type": "fn(src: string)",
      "!doc": "Loads an image `src` on the `A.ImageViewer`.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_loadImage"
     },
     "hasLink": {
      "!type": "fn(currentIndex: number) -> bool",
      "!doc": "Checks if there is a node reference for the `currentIndex`.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_hasLink"
     },
     "hasNext": {
      "!type": "fn() -> bool",
      "!doc": "Checks if there is a next element to navigate.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_hasNext"
     },
     "hasPrev": {
      "!type": "fn() -> bool",
      "!doc": "Checks if there is a previous element to navigate.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_hasPrev"
     },
     "hideControls": {
      "!type": "fn()",
      "!doc": "Hide all UI controls (i.e., arrows, close icon etc).",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_hideControls"
     },
     "next": {
      "!type": "fn()",
      "!doc": "Loads the previous image.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_next"
     },
     "preloadAllImages": {
      "!type": "fn()",
      "!doc": "Preloads the neighbor image (i.e., the previous and next image\nbased on the current load one).",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_preloadAllImages"
     },
     "preloadImage": {
      "!type": "fn(currentIndex: number)",
      "!doc": "Preloads an image based on its `index`.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_preloadImage"
     },
     "showLoading": {
      "!type": "fn()",
      "!doc": "Shows the loading icon.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_showLoading"
     },
     "show": {
      "!type": "fn()",
      "!doc": "Shows the `A.ImageViewer` UI.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#method_show"
     },
     "anim": {
      "!type": "fn()",
      "!doc": "If `true` the navigation is animated.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_anim"
     },
     "bodyContent": {
      "!type": "fn()",
      "!doc": "The content of body.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_bodyContent"
     },
     "caption": {
      "!type": "fn()",
      "!doc": "The caption of the displayed image.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_caption"
     },
     "captionFromTitle": {
      "!type": "fn()",
      "!doc": "If `true` the [caption](A.ImageViewer.html#attr_caption) will be\npulled from the title DOM attribute.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_captionFromTitle"
     },
     "centered": {
      "!type": "fn()",
      "!doc": "If `true` the Overlay with the image will be positioned\non the center of the viewport.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_centered"
     },
     "currentIndex": {
      "!type": "fn()",
      "!doc": "Index of the current image.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_currentIndex"
     },
     "image": {
      "!type": "fn()",
      "!doc": "Image node element used to load the images.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_image"
     },
     "imageAnim": {
      "!type": "fn()",
      "!doc": "Configuration attributes passed to the [Anim](Anim.html) class.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_imageAnim"
     },
     "infoTemplate": {
      "!type": "fn()",
      "!doc": "String template used to display the information.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_infoTemplate"
     },
     "links": {
      "!type": "fn()",
      "!doc": "Selector or NodeList containing the links where the\n`A.ImageViewer` extracts the information to generate the\nthumbnails.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_links"
     },
     "loading": {
      "!type": "fn()",
      "!doc": "Whether the image is during a loading state.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_loading"
     },
     "modal": {
      "!type": "fn()",
      "!doc": "Displays the modal the viewport. Set to `false` to disable.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_modal"
     },
     "showClose": {
      "!type": "fn()",
      "!doc": "Shows close icon control.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_showClose"
     },
     "showControls": {
      "!type": "fn()",
      "!doc": "Shows the controls.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_showControls"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "Specify the tab order of elements.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_tabIndex"
     },
     "totalLinks": {
      "!type": "fn()",
      "!doc": "Helper attribute to get the `size` of the\n[links](A.ImageViewer.html#attr_links) NodeList.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_totalLinks"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Determines if the `A.ImageViewer` should be visible or not.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_visible"
     },
     "zIndex": {
      "!type": "fn()",
      "!doc": "Specify the stack order of elements.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_zIndex"
     },
     "controlLeftEl": {
      "!type": "fn()",
      "!doc": "The element to be used as left control.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_controlLeftEl"
     },
     "controlRightEl": {
      "!type": "fn()",
      "!doc": "The element to be used as right control.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_controlRightEl"
     },
     "captionEl": {
      "!type": "fn()",
      "!doc": "The element to be used as caption.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_captionEl"
     },
     "closeEl": {
      "!type": "fn()",
      "!doc": "The element to be used as close.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_closeEl"
     },
     "infoEl": {
      "!type": "fn()",
      "!doc": "The element to be used as info.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_infoEl"
     },
     "loader": {
      "!type": "fn()",
      "!doc": "HTML element to contain the `img` which is being loaded.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_loader"
     },
     "loadingEl": {
      "!type": "fn()",
      "!doc": "The element to be used as loading.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_loadingEl"
     },
     "maxHeight": {
      "!type": "fn()",
      "!doc": "The maximum height of the element.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_maxHeight"
     },
     "maxWidth": {
      "!type": "fn()",
      "!doc": "The maximum width of the element.",
      "!url": "http://alloyui.com/classes/A.ImageViewer.html#attribute_maxWidth"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ImageViewer.html#property_NAME"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.ImageViewer.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.ImageViewer`.",
     "!url": "http://alloyui.com/classes/A.ImageViewer.html#property_ATTRS"
    }
   },
   "A.ImageGallery": {
    "!type": "fn(config: yui.Object) -> +aui_image_viewer.A.ImageGallery",
    "!proto": "aui_image_viewer.A.ImageViewer",
    "!doc": "A base class for `A.ImageGallery`, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Displays an image in a Overlay\n- Displays list of thumbnails of the images as a control\n- Slide show functionalities (i.e., play, pause etc)\n- Keyboard navigation support\n\nCheck the [live demo](http://alloyui.com/examples/image-viewer/gallery/).",
    "!url": "http://alloyui.com/classes/A.ImageGallery.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ImageGallery.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.ImageGallery`.",
     "!url": "http://alloyui.com/classes/A.ImageGallery.html#property_ATTRS"
    },
    "prototype": {
     "autoPlay": {
      "!type": "fn()",
      "!doc": "If `true` the slide show will be played when the\n`A.ImageGallery` is displayed.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_autoPlay"
     },
     "delay": {
      "!type": "fn()",
      "!doc": "Delay in milliseconds to change to the next image.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_delay"
     },
     "pagination": {
      "!type": "fn()",
      "!doc": "[A.Pagination](A.Pagination.html) configuration Object. The\n`A.Pagination` handles the thumbnails control.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_pagination"
     },
     "paginationEl": {
      "!type": "fn()",
      "!doc": "Element which contains the [A.Pagination](A.Pagination.html) with the\nthumbnails.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_paginationEl"
     },
     "paginationInstance": {
      "!type": "fn()",
      "!doc": "Stores the [A.Pagination](A.Pagination.html) instance.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_paginationInstance"
     },
     "paused": {
      "!type": "fn()",
      "!doc": "If `true` the slide show is paused.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_paused"
     },
     "pausedLabel": {
      "!type": "fn()",
      "!doc": "Label to display when the slide show is paused.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_pausedLabel"
     },
     "playing": {
      "!type": "fn()",
      "!doc": "If `true` the slide show is playing.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_playing"
     },
     "playingLabel": {
      "!type": "fn()",
      "!doc": "Label to display when the slide show is playing.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_playingLabel"
     },
     "repeat": {
      "!type": "fn()",
      "!doc": "Restart the navigation when reach the last element.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_repeat"
     },
     "showPlayer": {
      "!type": "fn()",
      "!doc": "Shows the player controls (i.e., pause and show buttons).",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_showPlayer"
     },
     "toolbar": {
      "!type": "fn()",
      "!doc": "[A.Toolbar](A.Toolbar.html) with a play, and pause buttons.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_toolbar"
     },
     "useOriginalImage": {
      "!type": "fn()",
      "!doc": "If `true` will use the original image as thumbnails.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#attribute_useOriginalImage"
     },
     "hidePagination": {
      "!type": "fn()",
      "!doc": "Hides the [A.Pagination](A.Pagination.html) with the thumbnails list.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#method_hidePagination"
     },
     "pause": {
      "!type": "fn()",
      "!doc": "Pauses the slide show.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#method_pause"
     },
     "play": {
      "!type": "fn()",
      "!doc": "Plays the slide show.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#method_play"
     },
     "show": {
      "!type": "fn()",
      "!doc": "Shows the `A.ImageGallery`.\n\n**NOTE:**Overloads the [ImageViewer](A.ImageViewer.html) show method\nto not loadImage, the changeRequest now is responsible to do that if\nwe invoke the superclass show method its loading the image, and the\nchangeRequest loads again, avoiding double request.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#method_show"
     },
     "showPagination": {
      "!type": "fn()",
      "!doc": "Shows the [A.Pagination](A.Pagination.html) with the thumbnails list.",
      "!url": "http://alloyui.com/classes/A.ImageGallery.html#method_showPagination"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.ImageGallery.html#property_EXTENDS"
    }
   }
  },
  "aui_media_viewer_plugin": {
   "A.MediaViewerPlugin": {
    "!type": "fn(config: yui.Object) -> +aui_media_viewer_plugin.A.MediaViewerPlugin",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for `A.MediaViewerPlugin`.\n\nCheck the [live demo](http://alloyui.com/examples/image-viewer/).",
    "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.MediaViewerPlugin`.",
     "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#property_ATTRS"
    },
    "prototype": {
     "providers": {
      "!type": "fn()",
      "!doc": "Contains the templates, options and definitions for each provider\n(Flash, Youtube, Vimeo).",
      "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#attribute_providers"
     },
     "close": {
      "!type": "fn()",
      "!doc": "Checks if the media type is an image, if not empty the content.",
      "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#method_close"
     },
     "loadMedia": {
      "!type": "fn(linkHref)",
      "!doc": "Loads a media based on the `providers` and include it on a container.",
      "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#method_loadMedia"
     },
     "preloadImage": {
      "!type": "fn(index)",
      "!doc": "Preloads an image.",
      "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#method_preloadImage"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.MediaViewerPlugin.html#property_EXTENDS"
    }
   }
  },
  "aui_io": {
   "A.IORequest": {
    "!type": "fn(config: yui.Object) -> +aui_io.A.IORequest",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for IORequest, providing:\n\n- Response data normalization for XML, JSON, JavaScript\n- Cache options\n\nCheck the [live demo](http://alloyui.com/examples/io/).",
    "!url": "http://alloyui.com/classes/A.IORequest.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.IORequest.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the IORequest.",
     "!url": "http://alloyui.com/classes/A.IORequest.html#property_ATTRS"
    },
    "prototype": {
     "autoLoad": {
      "!type": "fn()",
      "!doc": "If `true` invoke the [start](A.IORequest.html#method_start) method\nautomatically, initializing the IO transaction.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_autoLoad"
     },
     "cache": {
      "!type": "fn()",
      "!doc": "If `false` the current timestamp will be appended to the\nurl, avoiding the url to be cached.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_cache"
     },
     "dataType": {
      "!type": "fn()",
      "!doc": "The type of the request (i.e., could be xml, json, javascript, text).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_dataType"
     },
     "responseData": {
      "!type": "fn()",
      "!doc": "This is a normalized attribute for the response data. It's useful to\nretrieve the correct type for the\n[dataType](A.IORequest.html#attr_dataType) (i.e., in json requests\nthe `responseData`) is a JSONObject.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_responseData"
     },
     "uri": {
      "!type": "fn()",
      "!doc": "URI to be requested using AJAX.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_uri"
     },
     "active": {
      "!type": "fn()",
      "!doc": "Whether the transaction is active or not.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_active"
     },
     "cfg": {
      "!type": "fn()",
      "!doc": "Object containing all the [IO Configuration Attributes](A.io.html).\nThis Object is passed to the `A.io` internally.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_cfg"
     },
     "transaction": {
      "!type": "fn()",
      "!doc": "Stores the IO Object of the current transaction.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_transaction"
     },
     "arguments": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_arguments"
     },
     "context": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_context"
     },
     "data": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_data"
     },
     "form": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_form"
     },
     "headers": {
      "!type": "fn()",
      "!doc": "Set the correct ACCEPT header based on the dataType.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_headers"
     },
     "method": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_method"
     },
     "selector": {
      "!type": "fn()",
      "!doc": "A selector to be used to query against the response of the\nrequest. Only works if the response is XML or HTML.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_selector"
     },
     "sync": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_sync"
     },
     "timeout": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_timeout"
     },
     "xdr": {
      "!type": "fn()",
      "!doc": "See [IO\nConfiguration](http://developer.yahoo.com/yui/3/io/#configuration).",
      "!url": "http://alloyui.com/classes/A.IORequest.html#attribute_xdr"
     },
     "getFormattedData": {
      "!type": "fn() -> string",
      "!doc": "Applies the `YUI.AUI.defaults.io.dataFormatter` if\ndefined and return the formatted data.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#method_getFormattedData"
     },
     "start": {
      "!type": "fn()",
      "!doc": "Starts the IO transaction. Used to refresh the content also.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#method_start"
     },
     "stop": {
      "!type": "fn()",
      "!doc": "Stops the IO transaction.",
      "!url": "http://alloyui.com/classes/A.IORequest.html#method_stop"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.IORequest.html#property_EXTENDS"
    }
   },
   "A.io": {
    "!type": "fn()",
    "!doc": "Alloy IO extension",
    "!url": "http://alloyui.com/classes/A.io.html",
    "prototype": {
     "A.io.request": {
      "!type": "fn(uri: string, config: yui.Object) -> +IORequest",
      "!doc": "Static method to invoke the [IORequest](A.IORequest.html).\nLikewise [IO](A.io.html).",
      "!url": "http://alloyui.com/classes/A.io.html#method_A.io.request"
     }
    }
   }
  },
  "aui_modal": {
   "A.Modal": {
    "!type": "fn(config: yui.Object) -> +aui_modal.A.Modal",
    "!proto": "widget.Widget",
    "!doc": "A base class for Modal.\n\nCheck the [live demo](http://alloyui.com/examples/modal/).",
    "!url": "http://alloyui.com/classes/A.Modal.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Modal.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Modal.",
     "!url": "http://alloyui.com/classes/A.Modal.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determine the content of Modal's body section.\n\nTemporary fix for widget-stdmod bug when bodyContent initializes\nempty. this._currFillNode is never updated if _uiSetFillHeight is not\ncalled.",
      "!url": "http://alloyui.com/classes/A.Modal.html#attribute_bodyContent"
     },
     "destroyOnHide": {
      "!type": "fn()",
      "!doc": "Determine if Modal should be destroyed when hidden.",
      "!url": "http://alloyui.com/classes/A.Modal.html#attribute_destroyOnHide"
     },
     "draggable": {
      "!type": "fn()",
      "!doc": "Determine if Modal should be draggable or not.",
      "!url": "http://alloyui.com/classes/A.Modal.html#attribute_draggable"
     },
     "resizable": {
      "!type": "fn()",
      "!doc": "Determine if Modal should be resizable or not.",
      "!url": "http://alloyui.com/classes/A.Modal.html#attribute_resizable"
     },
     "toolbars": {
      "!type": "fn()",
      "!doc": "Determine the content of Modal's header section.",
      "!url": "http://alloyui.com/classes/A.Modal.html#attribute_toolbars"
     }
    },
    "TEMPLATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides a set of reusable templates.",
     "!url": "http://alloyui.com/classes/A.Modal.html#property_TEMPLATES"
    }
   }
  },
  "aui_node": {
   "A.Node": {
    "!type": "fn() -> +aui_node.A.Node",
    "!doc": "Augments the [YUI3 Node](Node.html) with more util methods.\n\nCheck the [live demo](http://alloyui.com/examples/node/).",
    "!url": "http://alloyui.com/classes/A.Node.html",
    "prototype": {
     "ancestors": {
      "!type": "fn(selector: string) -> +node.NodeList",
      "!doc": "Returns the current ancestors of the node element. If a selector is\nspecified, the ancestors are filtered to match the selector.\n\nExample:\n\n```\nA.one('#nodeId').ancestors('div');\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_ancestors"
     },
     "ancestorsByClassName": {
      "!type": "fn(className: string) -> +node.NodeList",
      "!doc": "Returns the current ancestors of the node element filtered by a\nclassName. This is an optimized method for finding ancestors by a\nspecific CSS class name.\n\nExample:\n\n```\nA.one('#nodeId').ancestorsByClassName('aui-hide');\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_ancestorsByClassName"
     },
     "attr": {
      "!type": "fn(name: string, value: string) -> string",
      "!doc": "Gets or sets the value of an attribute for the first element in the set\nof matched elements. If only the `name` is passed it works as a getter.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.attr('title', 'Setting a new title attribute');\n// Alert the value of the title attribute: 'Setting a new title attribute'\nalert( node.attr('title') );\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_attr"
     },
     "clone": {
      "!type": "fn() -> +node.Node",
      "!doc": "Normalizes the behavior of cloning a node, which by default should not\nclone the events that are attached to it.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.clone().appendTo('body');\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_clone"
     },
     "center": {
      "!type": "fn(val: yui.Array) -> !this",
      "!doc": "Centralizes the current Node instance with the passed `val` Array, Node,\nString, or Region, if not specified, the body will be used.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\n// Center the `node` with the `#container`.\nnode.center('#container');\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_center"
     },
     "empty": {
      "!type": "fn() -> !this",
      "!doc": "Removes not only child (and other descendant) elements, but also any text\nwithin the set of matched elements. This is because, according to the DOM\nspecification, any string of text within an element is considered a child\nnode of that element.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.empty();\n```",
      "!url": "http://alloyui.com/classes/A.Node.html#method_empty"
     },
     "getDOM": {
      "!type": "fn() -> +HTMLNode",
      "!doc": "Retrieves the DOM node bound to a Node instance. See\n[getDOMNode](Node.html#method_getDOMNode).",
      "!url": "http://alloyui.com/classes/A.Node.html#method_getDOM"
     },
     "getBorderWidth": {
      "!type": "fn(sides: string) -> number",
      "!doc": "Returns the combined width of the border for the specified sides.",
      "!url": "http://alloyui.com/classes/A.Node.html#method_getBorderWidth"
     }
    }
   },
   "Node": {
    "!type": "fn(node: HTMLElement) -> +node.Node",
    "!doc": "The Node class provides a wrapper for manipulating DOM Nodes.\nNode properties can be accessed via the set/get methods.\nUse `Y.one()` to retrieve Node instances.\n\n<strong>NOTE:</strong> Node properties are accessed using\nthe <code>set</code> and <code>get</code> methods.",
    "!url": "http://alloyui.com/classes/Node.html",
    "prototype": {
     "getCenterXY": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the current center position of the node in page coordinates.",
      "!url": "http://alloyui.com/classes/Node.html#method_getCenterXY"
     },
     "getMargin": {
      "!type": "fn(sides: string) -> number",
      "!doc": "Returns the combined size of the margin for the specified sides.",
      "!url": "http://alloyui.com/classes/Node.html#method_getMargin"
     },
     "getPadding": {
      "!type": "fn(sides: string) -> number",
      "!doc": "Returns the combined width of the border for the specified sides.",
      "!url": "http://alloyui.com/classes/Node.html#method_getPadding"
     },
     "guid": {
      "!type": "fn() -> string",
      "!doc": "Sets the id of the Node instance if the object does not have one. The\ngenerated id is based on a guid created by the\n[stamp](YUI.html#method_stamp) method.",
      "!url": "http://alloyui.com/classes/Node.html#method_guid"
     },
     "hover": {
      "!type": "fn(overFn: string, outFn: string) -> +node.Node",
      "!doc": "Creates a hover interaction.",
      "!url": "http://alloyui.com/classes/Node.html#method_hover"
     },
     "html": {
      "!type": "fn(value: string)",
      "!doc": "Gets or sets the HTML contents of the node. If the `value` is passed it's\nset the content of the element, otherwise it works as a getter for the\ncurrent content.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.html('Setting new HTML');\n// Alert the value of the current content\nalert( node.html() );\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_html"
     },
     "outerHTML": {
      "!type": "fn() -> string",
      "!doc": "Gets the outerHTML of a node, which islike innerHTML, except that it\nactually contains the HTML of the node itself.",
      "!url": "http://alloyui.com/classes/Node.html#method_outerHTML"
     },
     "placeAfter": {
      "!type": "fn(newNode: node.Node) -> !this",
      "!doc": "Inserts a `newNode` after the node instance (i.e., as the next sibling).\nIf the reference node has no parent, then does nothing.\n\nExample:\n\n```\nvar titleNode = A.one('#titleNode');\nvar descriptionNode = A.one('#descriptionNode');\n// the description is usually shown after the title\ntitleNode.placeAfter(descriptionNode);\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_placeAfter"
     },
     "placeBefore": {
      "!type": "fn(newNode: node.Node) -> !this",
      "!doc": "Inserts a `newNode` before the node instance (i.e., as the previous\nsibling). If the reference node has no parent, then does nothing.\n\nExample:\n\n```\nvar descriptionNode = A.one('#descriptionNode');\nvar titleNode = A.one('#titleNode');\n// the title is usually shown before the description\ndescriptionNode.placeBefore(titleNode);\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_placeBefore"
     },
     "prependTo": {
      "!type": "fn(selector: node.Node) -> !this",
      "!doc": "Inserts the node instance to the begining of the `selector` node (i.e.,\ninsert before the `firstChild` of the `selector`).\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.prependTo('body');\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_prependTo"
     },
     "radioClass": {
      "!type": "fn(cssClass: string) -> !this",
      "!doc": "Adds one or more CSS classes to an element and remove the class(es) from\nthe siblings of the element.",
      "!url": "http://alloyui.com/classes/Node.html#method_radioClass"
     },
     "resetId": {
      "!type": "fn(prefix: string) -> !this",
      "!doc": "Generates an unique identifier and reset the id attribute of the node\ninstance using the new value. Invokes the [guid](Node.html#method_guid).",
      "!url": "http://alloyui.com/classes/Node.html#method_resetId"
     },
     "selectText": {
      "!type": "fn(start: number, end: number)",
      "!doc": "Selects a substring of text inside of the input element.",
      "!url": "http://alloyui.com/classes/Node.html#method_selectText"
     },
     "selectable": {
      "!type": "fn(noRecurse) -> !this",
      "!doc": "Enables text selection for this element (normalized across browsers).",
      "!url": "http://alloyui.com/classes/Node.html#method_selectable"
     },
     "swallowEvent": {
      "!type": "fn(eventName: string, preventDefault: bool) -> !this",
      "!doc": "Stops the specified event(s) from bubbling and optionally prevents the\ndefault action.\n\nExample:\n\n```\nvar anchor = A.one('a#anchorId');\nanchor.swallowEvent('click');\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_swallowEvent"
     },
     "text": {
      "!type": "fn(text: string)",
      "!doc": "Gets or sets the combined text contents of the node instance, including\nit's descendants. If the `text` is passed it's set the content of the\nelement, otherwise it works as a getter for the current content.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.text('Setting new text content');\n// Alert the value of the current content\nalert( node.text() );\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_text"
     },
     "toggle": {
      "!type": "fn(on: bool, callback: fn()) -> !this",
      "!doc": "Displays or hide the node instance.\n\nNOTE: This method assume that your node were hidden because of the\n'aui-hide' css class were being used. This won't manipulate the inline\n`style.display` property.",
      "!url": "http://alloyui.com/classes/Node.html#method_toggle"
     },
     "unselectable": {
      "!type": "fn(noRecurse) -> !this",
      "!doc": "Disables text selection for this element (normalized across browsers).",
      "!url": "http://alloyui.com/classes/Node.html#method_unselectable"
     },
     "val": {
      "!type": "fn(value: string)",
      "!doc": "Gets or sets the value attribute of the node instance. If the `value` is\npassed it's set the value of the element, otherwise it works as a getter\nfor the current value.\n\nExample:\n\n```\nvar input = A.one('#inputId');\ninput.val('Setting new input value');\n// Alert the value of the input\nalert( input.val() );\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_val"
     },
     "width": {
      "!type": "fn() -> number",
      "!doc": "Returns the width of the content, not including the padding, border or\nmargin. If a width is passed, the node's overall width is set to that size.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.width(); //return content width\nnode.width(100); // sets box width\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_width"
     },
     "height": {
      "!type": "fn() -> number",
      "!doc": "Returns the height of the content, not including the padding, border or\nmargin. If a height is passed, the node's overall height is set to that size.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.height(); //return content height\nnode.height(100); // sets box height\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_height"
     },
     "innerWidth": {
      "!type": "fn() -> number",
      "!doc": "Returns the size of the box from inside of the border, which is the\n`offsetWidth` plus the padding on the left and right.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.innerWidth();\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_innerWidth"
     },
     "innerHeight": {
      "!type": "fn() -> number",
      "!doc": "Returns the size of the box from inside of the border, which is offsetHeight\nplus the padding on the top and bottom.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.innerHeight();\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_innerHeight"
     },
     "outerWidth": {
      "!type": "fn() -> number",
      "!doc": "Returns the outer width of the box including the border, if true is passed as\nthe first argument, the margin is included.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.outerWidth();\nnode.outerWidth(true); // includes margin\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_outerWidth"
     },
     "outerHeight": {
      "!type": "fn() -> number",
      "!doc": "Returns the outer height of the box including the border, if true is passed\nas the first argument, the margin is included.\n\nExample:\n\n```\nvar node = A.one('#nodeId');\nnode.outerHeight();\nnode.outerHeight(true); // includes margin\n```",
      "!url": "http://alloyui.com/classes/Node.html#method_outerHeight"
     }
    }
   },
   "A.NodeList": {
    "!type": "fn() -> +aui_node.A.NodeList",
    "!doc": "Augments the [YUI3 NodeList](NodeList.html) with more util methods.\n\nChecks the list of [Methods](NodeList.html#methods) available for AUI\nNodeList.",
    "!url": "http://alloyui.com/classes/A.NodeList.html",
    "prototype": {
     "all": {
      "!type": "fn()",
      "!doc": "See [Node all](Node.html#method_all).",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_all"
     },
     "first": {
      "!type": "fn() -> +node.Node",
      "!doc": "Returns the first element in the node list collection.",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_first"
     },
     "getDOM": {
      "!type": "fn()",
      "!doc": "See [Node getDOMNode](Node.html#method_getDOMNode).",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_getDOM"
     },
     "last": {
      "!type": "fn() -> +node.Node",
      "!doc": "Returns the last element in the node list collection.",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_last"
     },
     "one": {
      "!type": "fn()",
      "!doc": "See [Node one](Node.html#method_one).",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_one"
     },
     "getBody": {
      "!type": "fn()",
      "!doc": "Gets the body node. Shortcut to `A.one('body')`.",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_getBody"
     },
     "getDoc": {
      "!type": "fn()",
      "!doc": "Gets the document node. Shortcut to `A.one(document)`.",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_getDoc"
     },
     "getWin": {
      "!type": "fn()",
      "!doc": "Gets the window node. Shortcut to `A.one(window)`.",
      "!url": "http://alloyui.com/classes/A.NodeList.html#method_getWin"
     }
    }
   },
   "A.HTML5": {
    "!type": "fn()",
    "!doc": "An object that encapsulates util methods for HTML5 shiving.\n\n**What is a \"shiv\"?**\n\nTo the world, a shiv is a slang term for a sharp object used as a\nknife-like weapon. To Internet Explorer, a shiv is a script that, when\nexecuted, forces the browser to recognize HTML5 elements.",
    "!url": "http://alloyui.com/classes/A.HTML5.html",
    "prototype": {
     "onAfterPrint": {
      "!type": "fn()",
      "!doc": "Fires after a print.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_onAfterPrint"
     },
     "onBeforePrint": {
      "!type": "fn()",
      "!doc": "Fires before a print.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_onBeforePrint"
     },
     "parseCSS": {
      "!type": "fn(cssText) -> string",
      "!doc": "Navigates through the CSS joining rules and replacing content.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_parseCSS"
     },
     "restoreHTML": {
      "!type": "fn()",
      "!doc": "Restores the HTML from the `bodyClone` and `bodyEl` attributes.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_restoreHTML"
     },
     "writeHTML": {
      "!type": "fn()",
      "!doc": "Generates the HTML for print.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_writeHTML"
     },
     "IECreateFix": {
      "!type": "fn(frag: node.Node, content: string) -> +node.Node",
      "!doc": "Receives a `frag` and a HTML content. This method shivs the HTML5\nnodes appended to a Node or fragment which is not on the document\nyet.",
      "!url": "http://alloyui.com/classes/A.HTML5.html#method_IECreateFix"
     }
    }
   }
  },
  "aui_pagination": {
   "A.Pagination": {
    "!type": "fn(config: yui.Object) -> +aui_pagination.A.Pagination",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Pagination, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Set of controls to navigate through paged data\n\nCheck the [live demo](http://alloyui.com/examples/pagination/).",
    "!url": "http://alloyui.com/classes/A.Pagination.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Pagination.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for\nthe `A.Pagination`.",
     "!url": "http://alloyui.com/classes/A.Pagination.html#property_ATTRS"
    },
    "prototype": {
     "circular": {
      "!type": "fn()",
      "!doc": "When enabled this property allows the navigation to go back to the\nbeggining when it reaches the last page, the opposite behavior is\nalso true. Incremental page navigation could happen clicking the\ncontrol arrows or invoking `.next()` and `.prev()` methods.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_circular"
     },
     "formatter": {
      "!type": "fn()",
      "!doc": "A formatter function to format each pagination item.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_formatter"
     },
     "items": {
      "!type": "fn()",
      "!doc": "Holds the page items as a `NodeList`. The list could be queried from\nthe DOM trough Widget `HTML_PARSER` or generated if\n[total](A.Pagination.html#attr_total) is specified.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_items"
     },
     "offset": {
      "!type": "fn()",
      "!doc": "Initial page offset.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_offset"
     },
     "page": {
      "!type": "fn()",
      "!doc": "Determines if pagination controls (Next and Prev) are rendered.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_page"
     },
     "total": {
      "!type": "fn()",
      "!doc": "Total number of page links available. If set, the new\n[items](A.Pagination.html#attr_items) node list will be rendered.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_total"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#attribute_strings"
     },
     "getItem": {
      "!type": "fn(i: node.Node) -> +node.Node",
      "!doc": "Retrieve the item node from the passesed item index parameter.\nIf passed item is a node instead of the index returns itself.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_getItem"
     },
     "getOffsetPageNumber": {
      "!type": "fn() -> number",
      "!doc": "Retrieve page number including offset e.g., if offset is 100 and\nactive page is 5, this method returns 105.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_getOffsetPageNumber"
     },
     "getOffsetTotalPages": {
      "!type": "fn() -> number",
      "!doc": "Retrieve total number of pages including offset e.g., if offset is\n100 and total 10, this method returns 110.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_getOffsetTotalPages"
     },
     "getTotalItems": {
      "!type": "fn() -> number",
      "!doc": "Retrieve total number of dom items representing the links, including\nthe arrow control items. Do not include the offset.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_getTotalItems"
     },
     "next": {
      "!type": "fn()",
      "!doc": "Navigate to the next page.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_next"
     },
     "prev": {
      "!type": "fn()",
      "!doc": "Navigate to the previous page.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_prev"
     },
     "setState": {
      "!type": "fn(state: yui.Object)",
      "!doc": "Set the new pagination state. The state is a payload object\ncontaining the page number, e.g. `{page:1}`.",
      "!url": "http://alloyui.com/classes/A.Pagination.html#method_setState"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values are to be parsed from markup\ncontained in the widget's content box.",
     "!url": "http://alloyui.com/classes/A.Pagination.html#property_HTML_PARSER"
    },
    "BIND_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes for the bindUI lifecycle\nphase.",
     "!url": "http://alloyui.com/classes/A.Pagination.html#property_BIND_UI_ATTRS"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.Pagination.html#property_UI_ATTRS"
    }
   }
  },
  "aui_palette": {
   "A.Palette": {
    "!type": "fn(config: yui.Object) -> +aui_palette.A.Palette",
    "!proto": "widget.Widget",
    "!doc": "A base class for Palette.",
    "!url": "http://alloyui.com/classes/A.Palette.html",
    "prototype": {
     "getItem": {
      "!type": "fn(row: number, col: number) -> +yui.Object",
      "!doc": "Returns an item in the Palette by row and column.",
      "!url": "http://alloyui.com/classes/A.Palette.html#method_getItem"
     },
     "getItemByIndex": {
      "!type": "fn(index: number) -> +yui.Object",
      "!doc": "Returns an item in the Palette by its index.",
      "!url": "http://alloyui.com/classes/A.Palette.html#method_getItemByIndex"
     },
     "getItemByValue": {
      "!type": "fn(value: yui.Object) -> +yui.Object",
      "!doc": "Returns an item in the Palette by its value.",
      "!url": "http://alloyui.com/classes/A.Palette.html#method_getItemByValue"
     },
     "select": {
      "!type": "fn(valueOrIndex: number)",
      "!doc": "Selects an item in the Palette.",
      "!url": "http://alloyui.com/classes/A.Palette.html#method_select"
     },
     "toggleSelection": {
      "!type": "fn()",
      "!doc": "If true, on user interaction if the user clicks on an already\nselected element, it will be unselected.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_toggleSelection"
     },
     "unselect": {
      "!type": "fn(valueOrIndex: number)",
      "!doc": "Unselects an item. The item must be specified by its value or index.",
      "!url": "http://alloyui.com/classes/A.Palette.html#method_unselect"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "Specifies how many columns should contain the Palette. If the\nvalue is a positive number, the Palette will generate as many\ncolumns as specified in this property and it will fit the\nprovided `items` in these columns.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_columns"
     },
     "containerNode": {
      "!type": "fn()",
      "!doc": "Container node of the palette. If found, palette widget will not\ngenerate content.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_containerNode"
     },
     "formatter": {
      "!type": "fn()",
      "!doc": "Provides a function, which will be used to format the content\nduring Palette creation.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_formatter"
     },
     "items": {
      "!type": "fn()",
      "!doc": "An array of Palette items. These items will be rendered in the\nPalette according to the specified `columns`.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_items"
     },
     "selected": {
      "!type": "fn()",
      "!doc": "Provides the index of currently selected item.",
      "!url": "http://alloyui.com/classes/A.Palette.html#attribute_selected"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values have to be parsed from\nmarkup contained in the Palette's content box.",
     "!url": "http://alloyui.com/classes/A.Palette.html#property_HTML_PARSER"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Palette.",
     "!url": "http://alloyui.com/classes/A.Palette.html#property_ATTRS"
    }
   }
  },
  "aui_parse_content": {
   "A.ParseContent": {
    "!type": "fn(config: yui.Object) -> +aui_parse_content.A.ParseContent",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A base class for ParseContent, providing:\n\n- After plug ParseContent on a A.Node instance the javascript chunks will be\n  executed (remote and inline scripts)\n- All the javascripts within a content will be executed according to the\n  order of apparition\n\n**NOTE:** For performance reasons on DOM manipulation,\nParseContent only parses the content passed to the\n[setContent](Node.html#method_setContent),\n[prepend](Node.html#method_prepend) and\n[append](Node.html#method_append) methods.\n\nQuick Example:\n\n```\nnode.plug(A.Plugin.ParseContent);\n```",
    "!url": "http://alloyui.com/classes/A.ParseContent.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ParseContent.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.ParseContent.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the ParseContent.",
     "!url": "http://alloyui.com/classes/A.ParseContent.html#property_ATTRS"
    },
    "prototype": {
     "queue": {
      "!type": "fn()",
      "!doc": "A queue of elements to be parsed.",
      "!url": "http://alloyui.com/classes/A.ParseContent.html#attribute_queue"
     },
     "globalEval": {
      "!type": "fn(data: string)",
      "!doc": "Global eval the <data>data</data> passed.",
      "!url": "http://alloyui.com/classes/A.ParseContent.html#method_globalEval"
     },
     "parseContent": {
      "!type": "fn(content: string) -> string",
      "!doc": "Extract the `script` tags from the string content and\nevaluate the chunks.",
      "!url": "http://alloyui.com/classes/A.ParseContent.html#method_parseContent"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.ParseContent.html#property_EXTENDS"
    }
   }
  },
  "aui_popover": {
   "A.Popover": {
    "!type": "fn(config: yui.Object) -> +aui_popover.A.Popover",
    "!proto": "widget.Widget",
    "!doc": "A base class for Popover.\n\nCheck the [live demo](http://alloyui.com/examples/popover/).",
    "!url": "http://alloyui.com/classes/A.Popover.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Popover.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Popover.",
     "!url": "http://alloyui.com/classes/A.Popover.html#property_ATTRS"
    },
    "prototype": {
     "triggerToggleEvent": {
      "!type": "fn()",
      "!doc": "DOM event to hide the tooltip.",
      "!url": "http://alloyui.com/classes/A.Popover.html#attribute_triggerToggleEvent"
     }
    },
    "TEMPLATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides a set of reusable templates.",
     "!url": "http://alloyui.com/classes/A.Popover.html#property_TEMPLATES"
    }
   }
  },
  "aui_progressbar": {
   "A.ProgressBar": {
    "!type": "fn(config: yui.Object) -> +aui_progressbar.A.ProgressBar",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Progressbar, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- A visual means of showing progress of an ongoing operation\n- Can be enhanced via CSS styles to provide different colors, shapes and\n  textures\n- The bar can move horizontally or vertically\n- The movement can be enhanced by using the Animation utility\n\nCheck the [live demo](http://alloyui.com/examples/progress-bar/).",
    "!url": "http://alloyui.com/classes/A.ProgressBar.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ProgressBar.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the ProgressBar.",
     "!url": "http://alloyui.com/classes/A.ProgressBar.html#property_ATTRS"
    },
    "prototype": {
     "useARIA": {
      "!type": "fn()",
      "!doc": "Boolean indicating if use of the WAI-ARIA Roles and States\nshould be enabled.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_useARIA"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Display height of the progressbar.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_height"
     },
     "label": {
      "!type": "fn()",
      "!doc": "Display label of the progressbar. If not specified try to query\nusing HTML_PARSER an element inside boundingBox which matches\n`aui-progressbar-text` and get its innerHTML to be\nused as label.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_label"
     },
     "max": {
      "!type": "fn()",
      "!doc": "Represents the top value for the bar. The bar will be fully\nextended when reaching this value. Values higher than this will\nbe ignored.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_max"
     },
     "min": {
      "!type": "fn()",
      "!doc": "Represents the lowest value for the bar. The bar will be\ntotally collapsed when reaching this value. Values lower than\nthis will be ignored.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_min"
     },
     "orientation": {
      "!type": "fn()",
      "!doc": "Display orientation of the progressbar (i.e. vertical or\nhorizontal).",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_orientation"
     },
     "ratio": {
      "!type": "fn()",
      "!doc": "Calculate the ratio based on `max` and `min` values.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_ratio"
     },
     "step": {
      "!type": "fn()",
      "!doc": "Calculate the progressbar step based on `ratio` value.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_step"
     },
     "textNode": {
      "!type": "fn()",
      "!doc": "DOM Node to display the text of the progressbar. If not\nspecified try to query using HTML_PARSER an element inside\ncontentBox which matches `aui-progressbar-text`.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_textNode"
     },
     "value": {
      "!type": "fn()",
      "!doc": "The value for the bar. Valid values are in between the minValue\nand maxValue attributes.",
      "!url": "http://alloyui.com/classes/A.ProgressBar.html#attribute_value"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values are to be parsed from\nmarkup contained in the widget's bounding box.",
     "!url": "http://alloyui.com/classes/A.ProgressBar.html#property_HTML_PARSER"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.ProgressBar.html#property_UI_ATTRS"
    }
   }
  },
  "aui_rating": {
   "A.Rating": {
    "!type": "fn(config: yui.Object) -> +aui_rating.A.Rating",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Rating, providing:\n\n- A non-obstrusive star rating control\n- Could be based on a set of radio input boxes\n\nCheck the [live demo](http://alloyui.com/examples/rating/).",
    "!url": "http://alloyui.com/classes/A.Rating.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Rating.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Rating.",
     "!url": "http://alloyui.com/classes/A.Rating.html#property_ATTRS"
    },
    "prototype": {
     "disabled": {
      "!type": "fn()",
      "!doc": "Whether the Rating is disabled or not.\nDisabled Ratings don't allow hover or click,\njust display selected stars.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_disabled"
     },
     "canReset": {
      "!type": "fn()",
      "!doc": "If `true` could be reseted\n(i.e., have no values selected).",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_canReset"
     },
     "cssClasses": {
      "!type": "fn()",
      "!doc": "CSS classes applied on Rating.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_cssClasses"
     },
     "defaultSelected": {
      "!type": "fn()",
      "!doc": "The number of selected starts when the Rating render.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_defaultSelected"
     },
     "elements": {
      "!type": "fn()",
      "!doc": "[NodeList](NodeList.html) of elements used on the\nRating. Each element is one Star.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_elements"
     },
     "hiddenInput": {
      "!type": "fn()",
      "!doc": "Hidden input to handle the selected value. This hidden input\nreplace the radio elements and keep the same name.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_hiddenInput"
     },
     "inputName": {
      "!type": "fn()",
      "!doc": "Name of the [hiddenInput](A.Rating.html#attr_hiddenInput) element. If\nnot specified will use the name of the replaced radio.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_inputName"
     },
     "label": {
      "!type": "fn()",
      "!doc": "Label to be displayed with the Rating elements.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_label"
     },
     "labelNode": {
      "!type": "fn()",
      "!doc": "DOM Node to display the text of the StarRating. If not\nspecified try to query using HTML_PARSER an element inside\nboundingBox which matches `aui-rating-label-element`.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_labelNode"
     },
     "selectedIndex": {
      "!type": "fn()",
      "!doc": "Stores the index of the selected element.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_selectedIndex"
     },
     "showTitle": {
      "!type": "fn()",
      "!doc": "If `true` will extract the value of the\n`title` attribute on the radio, and use it on the\ngenerated Rating elements.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_showTitle"
     },
     "size": {
      "!type": "fn()",
      "!doc": "Number of Rating elements to be displayed.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_size"
     },
     "title": {
      "!type": "fn()",
      "!doc": "If set, will be used when there is no DOM `title` on the\nradio elements.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_title"
     },
     "value": {
      "!type": "fn()",
      "!doc": "Stores the value of the current selected Rating element.",
      "!url": "http://alloyui.com/classes/A.Rating.html#attribute_value"
     },
     "clearSelection": {
      "!type": "fn()",
      "!doc": "Clear all selected starts to the default state.",
      "!url": "http://alloyui.com/classes/A.Rating.html#method_clearSelection"
     },
     "select": {
      "!type": "fn(index: number)",
      "!doc": "Select the `index` Rating element.",
      "!url": "http://alloyui.com/classes/A.Rating.html#method_select"
     },
     "fillTo": {
      "!type": "fn(index: number, className: string)",
      "!doc": "Add the `className` on the the `index` element\nand all the previous Rating elements.",
      "!url": "http://alloyui.com/classes/A.Rating.html#method_fillTo"
     },
     "indexOf": {
      "!type": "fn(elem: node.Node) -> number",
      "!doc": "Find the index of the `elem`.",
      "!url": "http://alloyui.com/classes/A.Rating.html#method_indexOf"
     },
     "itemClick": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handle the itemClick event.",
      "!url": "http://alloyui.com/classes/A.Rating.html#event_itemClick"
     },
     "itemSelect": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handle the itemOver event.",
      "!url": "http://alloyui.com/classes/A.Rating.html#event_itemSelect"
     },
     "itemOut": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handle the itemOut event.",
      "!url": "http://alloyui.com/classes/A.Rating.html#event_itemOut"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Object hash, defining how attribute values are to be parsed from\nmarkup contained in the widget's content box.",
     "!url": "http://alloyui.com/classes/A.Rating.html#property_HTML_PARSER"
    }
   },
   "A.ThumbRating": {
    "!type": "fn(config: yui.Object) -> +aui_rating.A.ThumbRating",
    "!proto": "aui_rating.A.Rating",
    "!doc": "A base class for ThumbRating, providing:\n\n- A non-obstrusive star rating control using Thumb up and Thumb down icons\n- Could be based on a set of radio input boxes\n\nCheck the [live demo](http://alloyui.com/examples/rating/).",
    "!url": "http://alloyui.com/classes/A.ThumbRating.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.ThumbRating.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the ThumbRating.",
     "!url": "http://alloyui.com/classes/A.ThumbRating.html#property_ATTRS"
    },
    "prototype": {
     "cssClasses": {
      "!type": "fn()",
      "!doc": "CSS classes applied on ThumbRating.",
      "!url": "http://alloyui.com/classes/A.ThumbRating.html#attribute_cssClasses"
     },
     "size": {
      "!type": "fn()",
      "!doc": "The size on ThumbRating is always 2 (i.e., thumb up and thumb down).",
      "!url": "http://alloyui.com/classes/A.ThumbRating.html#attribute_size"
     },
     "fillTo": {
      "!type": "fn(index: number, className: string)",
      "!doc": "Add the `className` on the the `index` element\nand all the previous Rating elements.",
      "!url": "http://alloyui.com/classes/A.ThumbRating.html#method_fillTo"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.ThumbRating.html#property_EXTENDS"
    }
   }
  },
  "aui_scheduler": {
   "A.SchedulerCalendar": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerCalendar",
    "!proto": "app.ModelList",
    "!doc": "A base class for `SchedulerCalendar`.",
    "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerCalendar`.",
     "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#property_ATTRS"
    },
    "prototype": {
     "color": {
      "!type": "fn()",
      "!doc": "Contains the `color` of the scheduler calendar.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_color"
     },
     "disabled": {
      "!type": "fn()",
      "!doc": "Determines if the calender is enabled.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_disabled"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this calendar.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_name"
     },
     "palette": {
      "!type": "fn()",
      "!doc": "Contains a list of colors for the calendar.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_palette"
     },
     "scheduler": {
      "!type": "fn()",
      "!doc": "Contains this `SchedulerCalendar`'s `SchedulerBase' object.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_scheduler"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the calendar is visible.",
      "!url": "http://alloyui.com/classes/A.SchedulerCalendar.html#attribute_visible"
     }
    }
   },
   "A.SchedulerEvent": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerEvent",
    "!proto": "app.Model",
    "!doc": "A base class for `SchedulerEvent`.",
    "!url": "http://alloyui.com/classes/A.SchedulerEvent.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerEvent`.",
     "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#property_ATTRS"
    },
    "prototype": {
     "allDay": {
      "!type": "fn()",
      "!doc": "Determines whether a new event will take place all day. When enabled,\nthe event will not contain 24-hour clock date inputs.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_allDay"
     },
     "content": {
      "!type": "fn()",
      "!doc": "Contains the content of Scheduler event's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_content"
     },
     "color": {
      "!type": "fn()",
      "!doc": "Contains the `color` of a calendar event.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_color"
     },
     "colorBrightnessFactor": {
      "!type": "fn()",
      "!doc": "Contains the color brightness factor is applied to the `color`\nattribute.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_colorBrightnessFactor"
     },
     "colorSaturationFactor": {
      "!type": "fn()",
      "!doc": "Contains the color saturation factor is applied to the `color`\nattribute.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_colorSaturationFactor"
     },
     "titleDateFormat": {
      "!type": "fn()",
      "!doc": "Contains the formatted title date for this scheduler event, taking\ninto account ISO time. The value will not contain an `endDate` if\nthis event is `allDay`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_titleDateFormat"
     },
     "endDate": {
      "!type": "fn()",
      "!doc": "Contains the date corresponding to the current ending date of a\nscheduled event. By default, the value is one hour after the\n`startDate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_endDate"
     },
     "disabled": {
      "!type": "fn()",
      "!doc": "Determines if the event is disabled.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_disabled"
     },
     "meeting": {
      "!type": "fn()",
      "!doc": "Determines if the event is a meeting.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_meeting"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Contains the event `NodeList`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_node"
     },
     "reminder": {
      "!type": "fn()",
      "!doc": "Determines if the event is requires reminder.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_reminder"
     },
     "repeated": {
      "!type": "fn()",
      "!doc": "Determines if the event is to be repeated.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_repeated"
     },
     "scheduler": {
      "!type": "fn()",
      "!doc": "Contains this `SchedulerEvent`'s `SchedulerBase' object.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_scheduler"
     },
     "startDate": {
      "!type": "fn()",
      "!doc": "Contains the date corresponding to the current starting date of a\nscheduled event. By default, the value is the date set on the user's\ncomputer.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_startDate"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the event is visible.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#attribute_visible"
     },
     "addPaddingNode": {
      "!type": "fn()",
      "!doc": "Sometimes an event will require a padding node that mimics the\nbehavior of the scheduler `event`'s `node`. This can occur in the\nweek view when an event spans multiple days.\n\nFor example, an event beginning at 10pm on January 1 and ending on\n3am January 2nd would require a padding node. The `event`'s `node`\nappears from January 1 from 10:00pm to 11:59pm and the `paddingNode`\nis rendered on the table from January 2 from 12:00am to 3:00am.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_addPaddingNode"
     },
     "clone": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Clones the scheduler `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_clone"
     },
     "copyDates": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent, options: yui.Object)",
      "!doc": "Copies the dates from the `event` parameter to the instance `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_copyDates"
     },
     "copyPropagateAttrValues": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent, dontCopyMap: bool, options: yui.Object)",
      "!doc": "Copies the propagate attribute vales from an `event` to this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_copyPropagateAttrValues"
     },
     "getDaysDuration": {
      "!type": "fn() -> number",
      "!doc": "Gets the number of days an `event` is scheduled to take place.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getDaysDuration"
     },
     "getHoursDuration": {
      "!type": "fn() -> number",
      "!doc": "Gets the number of hours an `event` is scheduled to take place.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getHoursDuration"
     },
     "getMinutesDuration": {
      "!type": "fn() -> number",
      "!doc": "Gets the number of minutes an `event` is scheduled to take place.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getMinutesDuration"
     },
     "getSecondsDuration": {
      "!type": "fn() -> number",
      "!doc": "Gets the number of seconds an `event` is scheduled to take place.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getSecondsDuration"
     },
     "sameEndDate": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event`'s end date is this same as this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_sameEndDate"
     },
     "sameStartDate": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event`'s start date is this same as this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_sameStartDate"
     },
     "isAfter": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event` is after this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_isAfter"
     },
     "isBefore": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event` is before this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_isBefore"
     },
     "intersects": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event` interescts with this `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_intersects"
     },
     "intersectHours": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent) -> bool",
      "!doc": "Determines if an `event`'s hours' interescts with this `event`'s\nhours.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_intersectHours"
     },
     "isDayBoundaryEvent": {
      "!type": "fn() -> bool",
      "!doc": "Determines if a this `event` starts or ends at the beginning or end\nof a day.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_isDayBoundaryEvent"
     },
     "isDayOverlapEvent": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the passed date is between `startDate` and `endDate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_isDayOverlapEvent"
     },
     "getClearEndDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Clears the time fields from the `endDate`, effectively setting the\ntime to 12 noon.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getClearEndDate"
     },
     "getClearStartDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Clears the time fields from the `startDate`, effectively setting the\ntime to 12 noon.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_getClearStartDate"
     },
     "move": {
      "!type": "fn(date: datatype_date.Date, options: yui.Object)",
      "!doc": "Moves this Scheduler event to a new date specified by the date\nparameter.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_move"
     },
     "setContent": {
      "!type": "fn(content)",
      "!doc": "Replaces each node's current content with the `content`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_setContent"
     },
     "setTitle": {
      "!type": "fn(content)",
      "!doc": "Replaces each node's current title with the `content`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_setTitle"
     },
     "syncNodeContentUI": {
      "!type": "fn()",
      "!doc": "Sets the content of the Scheduler event to the content attribute\nvalue.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_syncNodeContentUI"
     },
     "syncNodeTitleUI": {
      "!type": "fn()",
      "!doc": "Sets the title of the Scheduler event to the a formated date.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_syncNodeTitleUI"
     },
     "split": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Splits an event into multiple days. Since an event can span across\nmultiple days in the week view, this event will be split into chunks\nfor each day column.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#method_split"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#property_EXTENDS"
    },
    "PROPAGATE_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Defines the propegate attribute keys for `Scheduler` events.",
     "!url": "http://alloyui.com/classes/A.SchedulerEvent.html#property_PROPAGATE_ATTRS"
    }
   },
   "A.SchedulerView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerView",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for `SchedulerView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerView.html#property_NAME"
    },
    "AUGMENTS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the augmented classes.",
     "!url": "http://alloyui.com/classes/A.SchedulerView.html#property_AUGMENTS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerView.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determines the content of Scheduler view's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_bodyContent"
     },
     "filterFn": {
      "!type": "fn()",
      "!doc": "Applies a filter to `SchedulerEvent`s.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_filterFn"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Contains the height of a `SchedulerView` in pixels.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_height"
     },
     "isoTime": {
      "!type": "fn()",
      "!doc": "Indicates whether this `SchedulerView` should use international\nstandard time.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_isoTime"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this view.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_name"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the navigation date.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_navigationDateFormatter"
     },
     "nextDate": {
      "!type": "fn()",
      "!doc": "Contains the next `Date` in the `SchedulerView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_nextDate"
     },
     "prevDate": {
      "!type": "fn()",
      "!doc": "Contains the previous `Date` in the `SchedulerView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_prevDate"
     },
     "scheduler": {
      "!type": "fn()",
      "!doc": "Contains this `SchedulerView`'s `SchedulerBase' object.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_scheduler"
     },
     "scrollable": {
      "!type": "fn()",
      "!doc": "Indicates whether this `SchedulerView` is scrollable.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_scrollable"
     },
     "triggerNode": {
      "!type": "fn()",
      "!doc": "Contains the `Node` that triggers.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_triggerNode"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the calendar is visible.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#attribute_visible"
     },
     "getAdjustedViewDate": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Returns a date value of the date with its time adjusted\nto midnight.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_getAdjustedViewDate"
     },
     "flushViewCache": {
      "!type": "fn()",
      "!doc": "Removes all data from `evtDateStack`, `evtRenderedStack` and\n`rowDateTableStack`.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_flushViewCache"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_getPrevDate"
     },
     "getToday": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the current date.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_getToday"
     },
     "limitDate": {
      "!type": "fn(date: datatype_date.Date, maxDate: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Returns a clone of a given `date` that will adjust to the `maxDate`\nif it occurs after `maxDate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_limitDate"
     },
     "plotEvents": {
      "!type": "fn()",
      "!doc": "Plots all events in the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_plotEvents"
     },
     "syncStdContent": {
      "!type": "fn()",
      "!doc": "Sync `SchedulerView` StdContent.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_syncStdContent"
     },
     "syncEventUI": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent)",
      "!doc": "Sync `event` on the UI.",
      "!url": "http://alloyui.com/classes/A.SchedulerView.html#method_syncEventUI"
     }
    },
    "BIND_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes\nfor the bindUI lifecycle phase.",
     "!url": "http://alloyui.com/classes/A.SchedulerView.html#property_BIND_UI_ATTRS"
    }
   },
   "A.SchedulerEvents": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerEvents",
    "!proto": "app.ModelList",
    "!doc": "A base class for `SchedulerEvents`.",
    "!url": "http://alloyui.com/classes/A.SchedulerEvents.html",
    "prototype": {
     "comparator": {
      "!type": "fn(model: yui.Object) -> number",
      "!doc": "Compares the inputs of a start and end date to see if adding `1` to the\nstart date time is larger than the difference between start and end date\ntimes.",
      "!url": "http://alloyui.com/classes/A.SchedulerEvents.html#method_comparator"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerEvents`.",
     "!url": "http://alloyui.com/classes/A.SchedulerEvents.html#property_ATTRS"
    }
   },
   "A.SchedulerEventSupport": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerEventSupport",
    "!doc": "A base class for `SchedulerEventSupport`.",
    "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerEventSupport`.",
     "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#property_ATTRS"
    },
    "prototype": {
     "addEvents": {
      "!type": "fn(models: yui.Array) -> +aui_scheduler.A.SchedulerEvents",
      "!doc": "Adds and returns the collection of events for this `Scheduler`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_addEvents"
     },
     "eachEvent": {
      "!type": "fn(fn: fn()) -> +aui_scheduler.A.SchedulerEvents",
      "!doc": "Applies a `function` to the collection of `Scheduler` events.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_eachEvent"
     },
     "flushEvents": {
      "!type": "fn()",
      "!doc": "Deletes each event in the collection of `Scheduler` events.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_flushEvents"
     },
     "getEventByClientId": {
      "!type": "fn(clientId: string) -> +yui.Object",
      "!doc": "Returns the event by matching it's `clientId`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_getEventByClientId"
     },
     "getEvents": {
      "!type": "fn(filterFn: fn()) -> +yui.Array",
      "!doc": "Gets a collection of events.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_getEvents"
     },
     "getEventsByDay": {
      "!type": "fn(date: datatype_date.Date, includeOverlap: bool) -> +yui.Array",
      "!doc": "Gets a collection of events within a given day. It will filter\noverlapping events by default unless `includeOverlap` is true.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_getEventsByDay"
     },
     "getIntersectEvents": {
      "!type": "fn(date: datatype_date.Date) -> +yui.Array",
      "!doc": "Returns the list of all events that intersect with a given date. Events\nthat are not visible are not included in this list.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_getIntersectEvents"
     },
     "removeEvents": {
      "!type": "fn(models: yui.Array) -> +aui_scheduler.A.SchedulerEvents",
      "!doc": "Removes given `SchedulerEvents` from the scheduler.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_removeEvents"
     },
     "resetEvents": {
      "!type": "fn(models: yui.Array) -> +aui_scheduler.A.SchedulerEvents",
      "!doc": "Completely replaces all `SchedulerEvents` in the list with the given\n`SchedulerEvents`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventSupport.html#method_resetEvents"
     }
    }
   },
   "A.SchedulerBase": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerBase",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for `SchedulerBase`.",
    "!url": "http://alloyui.com/classes/A.SchedulerBase.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerBase.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerBase`.",
     "!url": "http://alloyui.com/classes/A.SchedulerBase.html#property_ATTRS"
    },
    "prototype": {
     "activeView": {
      "!type": "fn()",
      "!doc": "Contains the active view.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_activeView"
     },
     "date": {
      "!type": "fn()",
      "!doc": "Contains the date corresponding to the current date which is the\nvalue of the date set on the user's computer.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_date"
     },
     "eventRecorder": {
      "!type": "fn()",
      "!doc": "Contains the `Scheduler`'s `SchedulerEventRecorder` instance.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_eventRecorder"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Contains the collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_strings"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the navigation date.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_navigationDateFormatter"
     },
     "views": {
      "!type": "fn()",
      "!doc": "Contains the list of views belonging to this `Scheduler`.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_views"
     },
     "viewDate": {
      "!type": "fn()",
      "!doc": "Contains the `Scheduler`'s current date. If there is an `activeView`,\nthis attribute will contain the `activeView`'s current date.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_viewDate"
     },
     "firstDayOfWeek": {
      "!type": "fn()",
      "!doc": "First day of the week: Sunday is 0, Monday is 1.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_firstDayOfWeek"
     },
     "todayDate": {
      "!type": "fn()",
      "!doc": "Today date representation. This option allows the developer to\nspecify the date he wants to be used as the today date.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#attribute_todayDate"
     },
     "getViewByName": {
      "!type": "fn(name: string) -> +aui_scheduler.A.SchedulerView",
      "!doc": "Returns the `SchedulerView` that belongs to a given name.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_getViewByName"
     },
     "getStrings": {
      "!type": "fn() -> string",
      "!doc": "Returns this `Scheduler`'s `strings` attribute value.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_getStrings"
     },
     "getString": {
      "!type": "fn(key: string) -> string",
      "!doc": "Returns the string that matches the `key` type.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_getString"
     },
     "renderView": {
      "!type": "fn(view: aui_scheduler.A.SchedulerView)",
      "!doc": "Renders the `SchedulerView` based on the given `view` parameter\nunder `instance.bodyNode`.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_renderView"
     },
     "plotViewEvents": {
      "!type": "fn(view)",
      "!doc": "Plots all events for the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_plotViewEvents"
     },
     "syncEventsUI": {
      "!type": "fn()",
      "!doc": "Plots the `activeView` events value.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_syncEventsUI"
     },
     "renderButtonGroup": {
      "!type": "fn()",
      "!doc": "Renders a new `ButtonGroup` and attaches it to the `Scheduler`\ninstances as a property `instance.buttonGroup`. It is rendered under\nthe `Scheduler` instance's `viewsNode`.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_renderButtonGroup"
     },
     "syncStdContent": {
      "!type": "fn()",
      "!doc": "Sync `SchedulerBase` StdContent.",
      "!url": "http://alloyui.com/classes/A.SchedulerBase.html#method_syncStdContent"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Contains an object hash, defining how attribute values are to be parsed\nfrom markup contained in the widget's bounding box.",
     "!url": "http://alloyui.com/classes/A.SchedulerBase.html#property_HTML_PARSER"
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.SchedulerBase.html#property_UI_ATTRS"
    },
    "AUGMENTS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the augmented classes.",
     "!url": "http://alloyui.com/classes/A.SchedulerBase.html#property_AUGMENTS"
    }
   },
   "A.SchedulerEventRecorder": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerEventRecorder",
    "!proto": "aui_scheduler.A.SchedulerEvent",
    "!doc": "A base class for `SchedulerEventRecorder`.",
    "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerEventRecorder`.",
     "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#property_ATTRS"
    },
    "prototype": {
     "allDay": {
      "!type": "fn()",
      "!doc": "Determines whether a new event will take place all day. When enabled,\nthe event will not contain 24-hour clock date inputs.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_allDay"
     },
     "content": {
      "!type": "fn()",
      "!doc": "Determines the content of this Scheduler event recorder's body\nsection.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_content"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "Contains the duration of an `event` in minutes.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_duration"
     },
     "dateFormat": {
      "!type": "fn()",
      "!doc": "Contains the default date format for an `event`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_dateFormat"
     },
     "event": {
      "!type": "fn()",
      "!doc": "A scheduler `event` is the wrapper object that contains an `event`\ntitle, start and end times and a description.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_event"
     },
     "popover": {
      "!type": "fn()",
      "!doc": "Contains the scheduler event recorder's `popover` instance.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_popover"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements of the UI.\nThis attribute defaults to `{}` unless the attribute is set.\nWhen this attribute is set, the passed value merges with a\npseudo-default collection of strings.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_strings"
     },
     "bodyTemplate": {
      "!type": "fn()",
      "!doc": "Contains the `SchedulerEventRecorder`'s body template.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_bodyTemplate"
     },
     "headerTemplate": {
      "!type": "fn()",
      "!doc": "Contains the `SchedulerEventRecorder`'s header template.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#attribute_headerTemplate"
     },
     "getContentNode": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets the content node belonging to the `popover`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_getContentNode"
     },
     "getFormattedDate": {
      "!type": "fn() -> string",
      "!doc": "Returns the formatted date including start and end hours if the event\nis not `allDay`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_getFormattedDate"
     },
     "getTemplateData": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns this Scheduler event recorder's `content`, and dates.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_getTemplateData"
     },
     "getUpdatedSchedulerEvent": {
      "!type": "fn(optAttrMap: yui.Object) -> +yui.Object",
      "!doc": "Returns an updated event and also merges in any additional attributes\npassed in as `optAttrMap`.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_getUpdatedSchedulerEvent"
     },
     "hidePopover": {
      "!type": "fn()",
      "!doc": "Hides this Scheduler event recorder's `popover` component.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_hidePopover"
     },
     "populateForm": {
      "!type": "fn()",
      "!doc": "Loads template data into the Scheduler event recorder's form.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_populateForm"
     },
     "serializeForm": {
      "!type": "fn() -> string",
      "!doc": "Converts this event recorder's form node object to a string.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_serializeForm"
     },
     "showPopover": {
      "!type": "fn()",
      "!doc": "Hides this Scheduler event recorder's `popover` component.",
      "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#method_showPopover"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerEventRecorder.html#property_EXTENDS"
    }
   },
   "A.SchedulerAgendaView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerAgendaView",
    "!proto": "aui_scheduler.A.SchedulerView",
    "!doc": "A base class for `SchedulerAgendaView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerAgendaView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determines the content of Scheduler view agenda's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_bodyContent"
     },
     "eventsDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the events date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_eventsDateFormatter"
     },
     "headerDayDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the header day date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_headerDayDateFormatter"
     },
     "headerExtraDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the header extra date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_headerExtraDateFormatter"
     },
     "infoDayDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the info day date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_infoDayDateFormatter"
     },
     "infoLabelBigDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the info label date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_infoLabelBigDateFormatter"
     },
     "infoLabelSmallDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the info label small date.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_infoLabelSmallDateFormatter"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this agenda.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_name"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Contains the collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#attribute_strings"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the agenda view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the agenda view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#method_getPrevDate"
     },
     "plotEvents": {
      "!type": "fn()",
      "!doc": "Plots all events in the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#method_plotEvents"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerAgendaView.html#property_EXTENDS"
    }
   },
   "A.SchedulerDayView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerDayView",
    "!proto": "aui_scheduler.A.SchedulerView",
    "!doc": "A base class for `SchedulerDayView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerDayView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerDayView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determines the content of Scheduler day view's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_bodyContent"
     },
     "days": {
      "!type": "fn()",
      "!doc": "Contains the number of day columns this view displays.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_days"
     },
     "delegateConfig": {
      "!type": "fn()",
      "!doc": "Configures this view's `DD.Delegate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_delegateConfig"
     },
     "eventWidth": {
      "!type": "fn()",
      "!doc": "Contains the width of a `SchedulerView` in pixels.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_eventWidth"
     },
     "filterFn": {
      "!type": "fn()",
      "!doc": "Applies a filter to `SchedulerEvent`s.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_filterFn"
     },
     "headerDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the header date.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_headerDateFormatter"
     },
     "headerView": {
      "!type": "fn()",
      "!doc": "Contains the header view.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_headerView"
     },
     "headerViewConfig": {
      "!type": "fn()",
      "!doc": "Configures the header day view.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_headerViewConfig"
     },
     "hourHeight": {
      "!type": "fn()",
      "!doc": "Contains the height of an hour in pixels.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_hourHeight"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this day view.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_name"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the navigation date.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_navigationDateFormatter"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Contains the collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_strings"
     },
     "headerTableNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `headerTable` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_headerTableNode!~YUIDOC_LINE~!return"
     },
     "headerViewLabelNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `headerViewLabel` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_headerViewLabelNode!~YUIDOC_LINE~!return"
     },
     "resizerNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `resizer` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_resizerNode!~YUIDOC_LINE~!return"
     },
     "tableNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `table` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_tableNode!~YUIDOC_LINE~!return"
     },
     "colDaysNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `colDays` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_colDaysNode!~YUIDOC_LINE~!return"
     },
     "colHeaderDaysNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `colHeaderDays` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_colHeaderDaysNode!~YUIDOC_LINE~!return"
     },
     "markercellsNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `markercells` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_markercellsNode!~YUIDOC_LINE~!return"
     },
     "timesNode!~YUIDOC_LINE~!return": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `times` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#attribute_timesNode!~YUIDOC_LINE~!return"
     },
     "syncStdContent": {
      "!type": "fn()",
      "!doc": "Sync SchedulerView StdContent.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncStdContent"
     },
     "calculateEventHeight": {
      "!type": "fn(duration: number) -> number",
      "!doc": "Calculates and returns the height of an event based on a given\n`duration`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_calculateEventHeight"
     },
     "calculateTop": {
      "!type": "fn(date: datatype_date.Date) -> number",
      "!doc": "Calculates and returns the value needed to get the `top` property\ngive a `date`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_calculateTop"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the day view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the day view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getPrevDate"
     },
     "getColumnByDate": {
      "!type": "fn(date: datatype_date.Date) -> number",
      "!doc": "Returns the column `Node` determined by a given `Date`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getColumnByDate"
     },
     "getColumnShimByDate": {
      "!type": "fn(date: datatype_date.Date) -> number",
      "!doc": "Returns the column shim `Node` determined by a given `Date`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getColumnShimByDate"
     },
     "getDateByColumn": {
      "!type": "fn(colNumber) -> ?",
      "!doc": "Returns the `Date` determined by a given column `Node`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getDateByColumn"
     },
     "getDateDaysOffset": {
      "!type": "fn(date: datatype_date.Date) -> number",
      "!doc": "Returns the number of offset days.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getDateDaysOffset"
     },
     "getYCoordTime": {
      "!type": "fn(top: number) -> +yui.Array",
      "!doc": "Returns the time at the Y coordinate from a given top position.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getYCoordTime"
     },
     "plotEvent": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent)",
      "!doc": "Plots a given event for the day view.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_plotEvent"
     },
     "plotEvents": {
      "!type": "fn()",
      "!doc": "Plots all events in the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_plotEvents"
     },
     "syncColumnsUI": {
      "!type": "fn()",
      "!doc": "Syncs the `SchedulerView` `columns` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncColumnsUI"
     },
     "syncDaysHeaderUI": {
      "!type": "fn()",
      "!doc": "Syncs the `SchedulerView` `daysHeader` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncDaysHeaderUI"
     },
     "syncEventsIntersectionUI": {
      "!type": "fn(columnEvents: yui.Array)",
      "!doc": "Syncs the `SchedulerView` `eventsIntersection` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncEventsIntersectionUI"
     },
     "syncEventHeightUI": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent)",
      "!doc": "Syncs the `SchedulerView` `eventHeight` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncEventHeightUI"
     },
     "syncEventTopUI": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent)",
      "!doc": "Syncs the `SchedulerView` `eventTop` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncEventTopUI"
     },
     "syncHeaderViewUI": {
      "!type": "fn()",
      "!doc": "Syncs the `SchedulerView` `headerView` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_syncHeaderViewUI"
     },
     "calculateYDelta": {
      "!type": "fn(startXY: yui.Array, xy: yui.Array)",
      "!doc": "Calculates the Y delta between two XY coordinates.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_calculateYDelta"
     },
     "findEventIntersections": {
      "!type": "fn(evt: aui_scheduler.A.SchedulerEvent, Array: yui.Array) -> +yui.Array",
      "!doc": "Returns a collection of `SchedulerEvents` as the parameter `events`\nthat intersect with `evt`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_findEventIntersections"
     },
     "getXYDelta": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Calculates the XY delta between the `event.currentTarget` XY\ncoordinates as well as the XY coordinates from the event page.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getXYDelta"
     },
     "getTickY": {
      "!type": "fn() -> number",
      "!doc": "Returns the nearest multiple of 10 to half the height of this\n`SchedulerView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_getTickY"
     },
     "roundToNearestHour": {
      "!type": "fn(date: datatype_date.Date, time: yui.Array)",
      "!doc": "Rounds a given `Date` to a given hour represented as time.",
      "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#method_roundToNearestHour"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Contains an object hash, defining how attribute values are to be parsed\nfrom markup contained in the widget's bounding box.",
     "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#property_HTML_PARSER"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerDayView.html#property_EXTENDS"
    }
   },
   "A.SchedulerMonthView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerMonthView",
    "!proto": "aui_scheduler.A.SchedulerTableView",
    "!doc": "A base class for `SchedulerMonthView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerMonthView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#property_ATTRS"
    },
    "prototype": {
     "displayDaysInterval": {
      "!type": "fn()",
      "!doc": "Contains the number of Days to display in a month view.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#attribute_displayDaysInterval"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this month view.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#attribute_name"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the navigation date.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#attribute_navigationDateFormatter"
     },
     "getAdjustedViewDate": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Returns a date value of the first day of the month with its time\nadjusted to midnight.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#method_getAdjustedViewDate"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the month view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the month view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#method_getPrevDate"
     },
     "plotEvents": {
      "!type": "fn()",
      "!doc": "Plots all events in the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#method_plotEvents"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerMonthView.html#property_EXTENDS"
    }
   },
   "A.SchedulerTableViewDD": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerTableViewDD",
    "!doc": "A base class for `SchedulerTableViewDD`.",
    "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerTableViewDD`.",
     "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#property_ATTRS"
    },
    "prototype": {
     "delegateConfig": {
      "!type": "fn()",
      "!doc": "Configures this view's `DD.Delegate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#attribute_delegateConfig"
     },
     "viewDDBindUI": {
      "!type": "fn()",
      "!doc": "Binds the scheduler view `DD.Delegate` events on the UI. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_viewDDBindUI"
     },
     "viewDDRenderUI": {
      "!type": "fn()",
      "!doc": "Renders the scheduler view `DD.Delegate` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_viewDDRenderUI"
     },
     "viewDDSyncUI": {
      "!type": "fn()",
      "!doc": "Syncs the scheduler view `DD.Delegate` instance. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_viewDDSyncUI"
     },
     "removeLasso": {
      "!type": "fn()",
      "!doc": "Removes the table view lasso.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_removeLasso"
     },
     "removeProxy": {
      "!type": "fn()",
      "!doc": "Removes the table view proxy node.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_removeProxy"
     },
     "renderLasso": {
      "!type": "fn(startPos: yui.Array, endPos: yui.Array)",
      "!doc": "Renders the table view lasso at the given `ij` coordinates for the table\nmatrix. It represents the selection for the table view, e.g. `j`\nrepresents a row and `i` a column, for `startPos` being `[0,0]` and\n`endPos` being `[0,3]`, this method will render three nodes representing\nthe selected lasso.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableViewDD.html#method_renderLasso"
     }
    }
   },
   "A.SchedulerTableView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerTableView",
    "!proto": "aui_scheduler.A.SchedulerView",
    "!doc": "A base class for `SchedulerTableView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerTableView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerTableView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determines the content of Scheduler table view's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_bodyContent"
     },
     "displayDaysInterval": {
      "!type": "fn()",
      "!doc": "Contains the number of days to display per interval in the\n`SchedulerTableView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_displayDaysInterval"
     },
     "displayRows": {
      "!type": "fn()",
      "!doc": "Contains the number of rows to display in the `SchedulerTableView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_displayRows"
     },
     "fixedHeight": {
      "!type": "fn()",
      "!doc": "Indicates whether the height of the `SchedulerTableView` is fixed.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_fixedHeight"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this `SchedulerTableView`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_name"
     },
     "headerDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the header date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_headerDateFormatter"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the function that formats the navigation date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_navigationDateFormatter"
     },
     "scrollable": {
      "!type": "fn()",
      "!doc": "Indicates whether the `SchedulerTableView` is scrollable.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_scrollable"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Contains the collection of strings used to label elements of the UI.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_strings"
     },
     "headerTableNode": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `headerTable` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_headerTableNode"
     },
     "colHeaderDaysNode": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `colHeaderDays` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_colHeaderDaysNode"
     },
     "rowsContainerNode": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `rowsContainer` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_rowsContainerNode"
     },
     "tableGridNode": {
      "!type": "fn()",
      "!doc": "Contains the function that returns the `tableGrid` node.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#attribute_tableGridNode"
     },
     "buildEventsRow": {
      "!type": "fn(rowStartDate: datatype_date.Date, rowEndDate: datatype_date.Date, rowDisplayIndex: number) -> +node.Node",
      "!doc": "Builds a row of events.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_buildEventsRow"
     },
     "buildEventsTable": {
      "!type": "fn(rowStartDate: datatype_date.Date, rowEndDate: datatype_date.Date) -> +node.Node",
      "!doc": "Builds a table of events.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_buildEventsTable"
     },
     "buildEventsTitleRow": {
      "!type": "fn(tableNode: node.Node, rowStartDate: datatype_date.Date, rowEndDate: datatype_date.Date) -> +node.Node",
      "!doc": "Builds a row with the title and today's date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_buildEventsTitleRow"
     },
     "buildGridRowNode": {
      "!type": "fn(rowIndex: number) -> +node.Node",
      "!doc": "Builds a new row `Node` and appends a table grid `Node`. Returns the\nrow `Node`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_buildGridRowNode"
     },
     "flushViewCache": {
      "!type": "fn()",
      "!doc": "Removes all data from `evtDateStack`, `evtRenderedStack` and\n`rowDateTableStack`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_flushViewCache"
     },
     "getIntersectEvents": {
      "!type": "fn(date: datatype_date.Date) -> +yui.Array",
      "!doc": "Returns the list of all events that intersect with a given date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_getIntersectEvents"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the `SchedulerTableView`'s\n        current date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the\n`SchedulerTableView`'s current date.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_getPrevDate"
     },
     "hideEventsOverlay": {
      "!type": "fn()",
      "!doc": "Hides this `SchedulerViewTable` event's `overlay` component.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_hideEventsOverlay"
     },
     "loopDates": {
      "!type": "fn(startDate: datatype_date.Date, endDate: datatype_date.Date, fn: fn(), incrementBy: string, factor: number)",
      "!doc": "Applies a given function to each date between `startDate` and\n`endDate`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_loopDates"
     },
     "plotEvents": {
      "!type": "fn()",
      "!doc": "Plots all events in the current view.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_plotEvents"
     },
     "syncDaysHeaderUI": {
      "!type": "fn()",
      "!doc": "Updates the `SchedulerTableView`'s `colHeaderDaysNode` to reflect\nany changes made to the instance attributes.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_syncDaysHeaderUI"
     },
     "syncGridUI": {
      "!type": "fn()",
      "!doc": "Updates the `SchedulerTableView`'s column grid by moving styling to\nthe current day cell `Node`.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_syncGridUI"
     },
     "syncStdContent": {
      "!type": "fn()",
      "!doc": "Sync SchedulerView content.",
      "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#method_syncStdContent"
     }
    },
    "HTML_PARSER": {
     "!type": "+yui.Object",
     "!doc": "Contains an object hash, defining how attribute values are to be parsed\nfrom markup contained in the widget's bounding box.",
     "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#property_HTML_PARSER"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerTableView.html#property_EXTENDS"
    }
   },
   "A.SchedulerWeekView": {
    "!type": "fn(config: yui.Object) -> +aui_scheduler.A.SchedulerWeekView",
    "!proto": "aui_scheduler.A.SchedulerDayView",
    "!doc": "A base class for `SchedulerWeekView`.",
    "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `SchedulerWeekView`.",
     "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#property_ATTRS"
    },
    "prototype": {
     "bodyContent": {
      "!type": "fn()",
      "!doc": "Determines the content of Scheduler week view's body section.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#attribute_bodyContent"
     },
     "days": {
      "!type": "fn()",
      "!doc": "Contains the number of days in a week.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#attribute_days"
     },
     "headerViewConfig": {
      "!type": "fn()",
      "!doc": "Configures the header week view.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#attribute_headerViewConfig"
     },
     "name": {
      "!type": "fn()",
      "!doc": "Determines the name for this week view.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#attribute_name"
     },
     "navigationDateFormatter": {
      "!type": "fn()",
      "!doc": "Contains the formatted navigation date formatter for this week view.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#attribute_navigationDateFormatter"
     },
     "getAdjustedViewDate": {
      "!type": "fn(date: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Returns a date value of the first day of the week with its time\nadjusted to midnight.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#method_getAdjustedViewDate"
     },
     "getNextDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that follows the week view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#method_getNextDate"
     },
     "getPrevDate": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the date that preceeds the week view's current\ndate.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#method_getPrevDate"
     },
     "getToday": {
      "!type": "fn() -> +datatype_date.Date",
      "!doc": "Returns the value of the week view's current date.",
      "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#method_getToday"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SchedulerWeekView.html#property_EXTENDS"
    }
   }
  },
  "aui_search": {
   "A.TernarySearchNode": {
    "!type": "fn(config: yui.Object) -> +aui_search.A.TernarySearchNode",
    "!proto": "base.Base",
    "!doc": "A base class for TernarySearchNode.",
    "!url": "http://alloyui.com/classes/A.TernarySearchNode.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.TernarySearchNode`.",
     "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#property_ATTRS"
    },
    "prototype": {
     "character": {
      "!type": "fn()",
      "!doc": "String formed by a single letter.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#attribute_character"
     },
     "child": {
      "!type": "fn()",
      "!doc": "The child node in the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#attribute_child"
     },
     "largerNode": {
      "!type": "fn()",
      "!doc": "The larger node in the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#attribute_largerNode"
     },
     "smallerNode": {
      "!type": "fn()",
      "!doc": "The smaller node in the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#attribute_smallerNode"
     },
     "word": {
      "!type": "fn()",
      "!doc": "String formed by a group of letters.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#attribute_word"
     },
     "isEndOfWord": {
      "!type": "fn()",
      "!doc": "Converts the `word` attribute value to a `Boolean` and ensures a\n`Boolean` type.",
      "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#method_isEndOfWord"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TernarySearchNode.html#property_EXTENDS"
    }
   },
   "A.TernarySearchTree": {
    "!type": "fn(config: yui.Object) -> +aui_search.A.TernarySearchTree",
    "!proto": "base.Base",
    "!doc": "A base class for TernarySearchTree.",
    "!url": "http://alloyui.com/classes/A.TernarySearchTree.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the namespace.",
     "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#property_NS"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#property_EXTENDS"
    },
    "prototype": {
     "add": {
      "!type": "fn(word)",
      "!doc": "Adds a word in the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#method_add"
     },
     "contains": {
      "!type": "fn(word) -> bool",
      "!doc": "Checks if the argument is part of the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#method_contains"
     },
     "empty": {
      "!type": "fn()",
      "!doc": "Set tree's root to `null`.",
      "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#method_empty"
     },
     "patternMatch": {
      "!type": "fn(pattern) -> +yui.Array",
      "!doc": "Checks if a pattern match.",
      "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#method_patternMatch"
     },
     "prefixSearch": {
      "!type": "fn(prefix) -> +yui.Array",
      "!doc": "Searches for a prefix in the tree.",
      "!url": "http://alloyui.com/classes/A.TernarySearchTree.html#method_prefixSearch"
     }
    }
   }
  },
  "aui_selector": {
   "A.Selector": {
    "!type": "fn() -> +aui_selector.A.Selector",
    "!doc": "Augment the [YUI3 Selector](Selector.html) with more util methods.",
    "!url": "http://alloyui.com/classes/A.Selector.html",
    "prototype": {
     "button": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is a button element or contains `type=\"button\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_button"
     },
     "checkbox": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"checkbox\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_checkbox"
     },
     "checked": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is checked or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_checked"
     },
     "disabled": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is disabled or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_disabled"
     },
     "empty": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is empty or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_empty"
     },
     "enabled": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is enabled or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_enabled"
     },
     "file": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"file\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_file"
     },
     "header": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is a header (e.g. `<h1>`, `<h2>`, ...) or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_header"
     },
     "hidden": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is hidden or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_hidden"
     },
     "image": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"image\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_image"
     },
     "input": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is an input (e.g. `<textarea>`, `<input>`, ...) or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_input"
     },
     "parent": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node contains a child or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_parent"
     },
     "password": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"password\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_password"
     },
     "radio": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"radio\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_radio"
     },
     "reset": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"reset\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_reset"
     },
     "selected": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is selected or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_selected"
     },
     "submit": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"submit\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_submit"
     },
     "text": {
      "!type": "fn() -> bool",
      "!doc": "Checks if the node contains `type=\"text\"`.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_text"
     },
     "visible": {
      "!type": "fn(node) -> bool",
      "!doc": "Checks if the node is visible or not.",
      "!url": "http://alloyui.com/classes/A.Selector.html#method_visible"
     }
    }
   }
  },
  "aui_sortable_layout": {
   "A.SortableLayout": {
    "!type": "fn(config: yui.Object) -> +aui_sortable_layout.A.SortableLayout",
    "!proto": "base.Base",
    "!doc": "A base class for SortableLayout, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- DragDrop utility for drag lists, portal layouts (portlets)\n\nCheck the [live demo](http://alloyui.com/examples/sortable-layout/).",
    "!url": "http://alloyui.com/classes/A.SortableLayout.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SortableLayout.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.SortableLayout`.",
     "!url": "http://alloyui.com/classes/A.SortableLayout.html#property_ATTRS"
    },
    "prototype": {
     "delegateConfig": {
      "!type": "fn()",
      "!doc": "Configuration object for delegate.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_delegateConfig"
     },
     "proxyNode": {
      "!type": "fn()",
      "!doc": "Proxy drag node used instead of dragging the original node.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_proxyNode"
     },
     "dragNodes": {
      "!type": "fn()",
      "!doc": "The CSS class name used to define which nodes are draggable.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_dragNodes"
     },
     "dropContainer": {
      "!type": "fn()",
      "!doc": "The container which serves to host dropped elements.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_dropContainer"
     },
     "dropNodes": {
      "!type": "fn()",
      "!doc": "The CSS class name used to define which nodes serve as container to\nbe dropped.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_dropNodes"
     },
     "groups": {
      "!type": "fn()",
      "!doc": "List of elements to add this sortable layout into.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_groups"
     },
     "lazyStart": {
      "!type": "fn()",
      "!doc": "Specifies if the start should be delayed.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_lazyStart"
     },
     "placeholder": {
      "!type": "fn()",
      "!doc": "Simulates the position of the dragged element.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_placeholder"
     },
     "proxy": {
      "!type": "fn()",
      "!doc": "Proxy element to be used when dragging.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#attribute_proxy"
     },
     "addDropNode": {
      "!type": "fn(node, config)",
      "!doc": "Checks if the `Node` isn't a drop node. If not, creates a new Drop\ninstance and adds to drop target group.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_addDropNode"
     },
     "addDropTarget": {
      "!type": "fn(drop)",
      "!doc": "Adds a Drop instance to a group.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_addDropTarget"
     },
     "alignPlaceholder": {
      "!type": "fn(region, isTarget)",
      "!doc": "Sync placeholder size and set its X and Y positions.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_alignPlaceholder"
     },
     "calculateDirections": {
      "!type": "fn(drag)",
      "!doc": "Calculates drag's X and Y directions.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_calculateDirections"
     },
     "calculateQuadrant": {
      "!type": "fn(drag, drop) -> number",
      "!doc": "Calculates quadrant position.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_calculateQuadrant"
     },
     "getPlaceholderXY": {
      "!type": "fn(region, isTarget) -> +yui.Array",
      "!doc": "Gets placeholder X and Y positions.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_getPlaceholderXY"
     },
     "removeDropTarget": {
      "!type": "fn(drop)",
      "!doc": "Removes a Drop instance from group.",
      "!url": "http://alloyui.com/classes/A.SortableLayout.html#method_removeDropTarget"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SortableLayout.html#property_EXTENDS"
    }
   }
  },
  "aui_sortable_list": {
   "A.SortableList": {
    "!type": "fn(config: yui.Object) -> +aui_sortable_list.A.SortableList",
    "!proto": "base.Base",
    "!doc": "A base class for SortableList, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Sortable list utility\n\nCheck the [live demo](http://alloyui.com/examples/sortable-list/).",
    "!url": "http://alloyui.com/classes/A.SortableList.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.SortableList.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.SortableList`.",
     "!url": "http://alloyui.com/classes/A.SortableList.html#property_ATTRS"
    },
    "prototype": {
     "dd": {
      "!type": "fn()",
      "!doc": "Drag & Drop plugin attached to the widget.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_dd"
     },
     "dropCondition": {
      "!type": "fn()",
      "!doc": "Validates the condition for an element to be dropped.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_dropCondition"
     },
     "dropContainer": {
      "!type": "fn()",
      "!doc": "The container which serves to host dropped elements.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_dropContainer"
     },
     "dropOn": {
      "!type": "fn()",
      "!doc": "The CSS class name used to define which nodes serve as container to\nbe dropped.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_dropOn"
     },
     "helper": {
      "!type": "fn()",
      "!doc": "Indicates that the element is being dragged.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_helper"
     },
     "nodes": {
      "!type": "fn()",
      "!doc": "The CSS class name used to define which nodes are draggable.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_nodes"
     },
     "placeholder": {
      "!type": "fn()",
      "!doc": "Simulates the position of the dragged element.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_placeholder"
     },
     "proxy": {
      "!type": "fn()",
      "!doc": "Proxy element to be used when dragging.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_proxy"
     },
     "sortCondition": {
      "!type": "fn()",
      "!doc": "Validates the condition for an element to be sorted.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#attribute_sortCondition"
     },
     "add": {
      "!type": "fn(node)",
      "!doc": "Creates a drag instance from a single node.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#method_add"
     },
     "addAll": {
      "!type": "fn(nodes)",
      "!doc": "Creates drag instances from a list of nodes.",
      "!url": "http://alloyui.com/classes/A.SortableList.html#method_addAll"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.SortableList.html#property_EXTENDS"
    }
   }
  },
  "aui_tabview": {
   "A.Tab": {
    "!type": "fn(config: yui.Object) -> +aui_tabview.A.Tab",
    "!proto": "swfdetect.Tab",
    "!doc": "A base class for Tab.\n\nCheck the [live demo](http://alloyui.com/examples/tabview/).",
    "!url": "http://alloyui.com/classes/A.Tab.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Tab.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Tab.",
     "!url": "http://alloyui.com/classes/A.Tab.html#property_ATTRS"
    },
    "prototype": {
     "disabled": {
      "!type": "fn()",
      "!doc": "TODO. Wanna help? Please send a Pull Request.",
      "!url": "http://alloyui.com/classes/A.Tab.html#attribute_disabled"
     }
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Tab.html#property_CSS_PREFIX"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.Tab.html#property_EXTENDS"
    }
   },
   "A.TabView": {
    "!type": "fn(config: yui.Object) -> +aui_tabview.A.TabView",
    "!proto": "tabview.TabView",
    "!doc": "A base class for TabView.\n\nCheck the [live demo](http://alloyui.com/examples/tabview/).",
    "!url": "http://alloyui.com/classes/A.TabView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TabView.html#property_NAME"
    },
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.TabView.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TabView.",
     "!url": "http://alloyui.com/classes/A.TabView.html#property_ATTRS"
    },
    "prototype": {
     "stacked": {
      "!type": "fn()",
      "!doc": "Determine the orientation of tabs.\nCan be stacked (vertical) or not (horizontal).",
      "!url": "http://alloyui.com/classes/A.TabView.html#attribute_stacked"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Determine the type of tabs.",
      "!url": "http://alloyui.com/classes/A.TabView.html#attribute_type"
     },
     "disableTab": {
      "!type": "fn(i)",
      "!doc": "Disable tab based on its index.",
      "!url": "http://alloyui.com/classes/A.TabView.html#method_disableTab"
     },
     "enableTab": {
      "!type": "fn(i)",
      "!doc": "Enable tab based on its index.",
      "!url": "http://alloyui.com/classes/A.TabView.html#method_enableTab"
     },
     "getActiveTab": {
      "!type": "fn()",
      "!doc": "Get the tabs.",
      "!url": "http://alloyui.com/classes/A.TabView.html#method_getActiveTab"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.TabView.html#property_UI_ATTRS"
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TabView.html#property_EXTENDS"
    }
   }
  },
  "aui_text": {
   "A.TimePickerBase": {
    "!type": "fn(config: yui.Object) -> +aui_timepicker.A.TimePickerBase",
    "!doc": "A base class for `TimePickerBase`.",
    "!url": "http://alloyui.com/classes/A.TimePickerBase.html",
    "prototype": {
     "match": {
      "!type": "fn(str: string, group: string, flags: string)",
      "!doc": "Tests a string against an Unicode pattern. Returns the first match.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_match"
     },
     "test": {
      "!type": "fn(str: string, group: string, flags: string)",
      "!doc": "Tests a string against an Unicode pattern. Returns true or false.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_test"
     }
    }
   }
  },
  "aui_timepicker": {
   "A.TimePickerBase": {
    "!type": "fn(config: yui.Object) -> +aui_timepicker.A.TimePickerBase",
    "!doc": "A base class for `TimePickerBase`.",
    "!url": "http://alloyui.com/classes/A.TimePickerBase.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration for the\n`TimePickerBase`.",
     "!url": "http://alloyui.com/classes/A.TimePickerBase.html#property_ATTRS"
    },
    "prototype": {
     "autocomplete": {
      "!type": "fn()",
      "!doc": "Default `AutoComplete` configuration options.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#attribute_autocomplete"
     },
     "dateSeparator": {
      "!type": "fn()",
      "!doc": "Value seperator for `queryDelimiter` attribute of `AutoComplete` class.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#attribute_dateSeparator"
     },
     "mask": {
      "!type": "fn()",
      "!doc": "Format for displayed time.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#attribute_mask"
     },
     "popoverCssClass": {
      "!type": "fn()",
      "!doc": "CSS class for popover.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#attribute_popoverCssClass"
     },
     "values": {
      "!type": "fn()",
      "!doc": "Time values available to `AutoComplete` instance.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#attribute_values"
     },
     "clearSelection": {
      "!type": "fn()",
      "!doc": "Clears selection.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_clearSelection"
     },
     "getAutoComplete": {
      "!type": "fn(node: node.Node) -> +yui.Object",
      "!doc": "Creates and returns a new instance of `AutoComplete`.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_getAutoComplete"
     },
     "selectDates": {
      "!type": "fn(dates: yui.Object)",
      "!doc": "Sets selected date.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_selectDates"
     },
     "useInputNode": {
      "!type": "fn(node: node.Node)",
      "!doc": "Syncs `TimePicker` values to input node value.",
      "!url": "http://alloyui.com/classes/A.TimePickerBase.html#method_useInputNode"
     }
    }
   }
  },
  "aui_timer": {
   "A.Timer": {
    "!type": "fn() -> +aui_timer.A.Timer",
    "!doc": "A base class for Timer.",
    "!url": "http://alloyui.com/classes/A.Timer.html",
    "prototype": {
     "clearInterval": {
      "!type": "fn(id)",
      "!doc": "Cancels repeated action which was set up using `setInterval` function.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_clearInterval"
     },
     "clearTimeout": {
      "!type": "fn(id)",
      "!doc": "Clears the delay set by `setTimeout` function.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_clearTimeout"
     },
     "intervalTime": {
      "!type": "fn(newInterval) -> number",
      "!doc": "Defines the fixed time delay between each interval.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_intervalTime"
     },
     "isRepeatable": {
      "!type": "fn(task) -> bool",
      "!doc": "Checks if the task is repeatable or not.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_isRepeatable"
     },
     "setTimeout": {
      "!type": "fn(fn, ms, context)",
      "!doc": "Calls a function after a specified delay.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_setTimeout"
     },
     "setInterval": {
      "!type": "fn(fn, ms, context)",
      "!doc": "Calls a function repeatedly, with a fixed time delay between each call to\nthat function.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_setInterval"
     },
     "register": {
      "!type": "fn(repeats, fn, ms, context, args)",
      "!doc": "Adds a new task to the timer.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_register"
     },
     "run": {
      "!type": "fn(task)",
      "!doc": "Runs the task function.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_run"
     },
     "unregister": {
      "!type": "fn(repeats, id)",
      "!doc": "Removes a task from the timer.",
      "!url": "http://alloyui.com/classes/A.Timer.html#method_unregister"
     }
    },
    "A.clearInterval": {
     "!type": "fn(id)",
     "!doc": "Cancels repeated action which was set up using `setInterval` function.",
     "!url": "http://alloyui.com/classes/A.Timer.html#method_A.clearInterval"
    },
    "A.clearTimeout": {
     "!type": "fn(id)",
     "!doc": "Clears the delay set by `setTimeout` function.",
     "!url": "http://alloyui.com/classes/A.Timer.html#method_A.clearTimeout"
    },
    "A.setInterval": {
     "!type": "fn(fn, ms, context)",
     "!doc": "Calls a function repeatedly, with a fixed time delay between each call to\nthat function.",
     "!url": "http://alloyui.com/classes/A.Timer.html#method_A.setInterval"
    },
    "A.setTimeout": {
     "!type": "fn(fn, ms, context)",
     "!doc": "Calls a function after a specified delay.",
     "!url": "http://alloyui.com/classes/A.Timer.html#method_A.setTimeout"
    }
   }
  },
  "aui_toggler": {
   "A.Toggler": {
    "!type": "fn(config: yui.Object) -> +aui_toggler.A.Toggler",
    "!proto": "base.Base",
    "!doc": "A base class for Toggler.\n\nCheck the [live demo](http://alloyui.com/examples/toggler/).",
    "!url": "http://alloyui.com/classes/A.Toggler.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Toggler.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.Toggler`.",
     "!url": "http://alloyui.com/classes/A.Toggler.html#property_ATTRS"
    },
    "prototype": {
     "animated": {
      "!type": "fn()",
      "!doc": "Determine if the `A.Toggler` transitions will animate.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_animated"
     },
     "animating": {
      "!type": "fn()",
      "!doc": "Determine if the `A.Toggler` transitions are being animated in that\nmoment.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_animating"
     },
     "bindDOMEvents": {
      "!type": "fn()",
      "!doc": "Determine if the `A.Toggler` should bind DOM events or not.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_bindDOMEvents"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The content of a Toogler instance.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_content"
     },
     "expanded": {
      "!type": "fn()",
      "!doc": "Determine if the content starts as toggled on/off on page load.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_expanded"
     },
     "header": {
      "!type": "fn()",
      "!doc": "The header of a Toogler instance.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_header"
     },
     "transition": {
      "!type": "fn()",
      "!doc": "Transition definitions such as duration and type of easing effect.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#attribute_transition"
     },
     "headerEventHandler": {
      "!type": "fn(event, instance)",
      "!doc": "Handle header events.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_headerEventHandler"
     },
     "animate": {
      "!type": "fn(config, fn)",
      "!doc": "Expand `A.Toggler` with an animation.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_animate"
     },
     "collapse": {
      "!type": "fn()",
      "!doc": "Hide `A.Toggler` content.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_collapse"
     },
     "expand": {
      "!type": "fn()",
      "!doc": "Show `A.Toggler` content.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_expand"
     },
     "getContentHeight": {
      "!type": "fn() -> number",
      "!doc": "Return the height of content.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_getContentHeight"
     },
     "toggle": {
      "!type": "fn(expand)",
      "!doc": "Show or hide content.",
      "!url": "http://alloyui.com/classes/A.Toggler.html#method_toggle"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.Toggler.html#property_EXTENDS"
    }
   },
   "A.TogglerDelegate": {
    "!type": "fn(config: yui.Object) -> +aui_toggler.A.TogglerDelegate",
    "!proto": "base.Base",
    "!doc": "A base class for Toggler Delegate.\n\nCheck the [live demo](http://alloyui.com/examples/toggler/).",
    "!url": "http://alloyui.com/classes/A.TogglerDelegate.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the `A.TogglerDelegate`.",
     "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#property_ATTRS"
    },
    "prototype": {
     "animated": {
      "!type": "fn()",
      "!doc": "Determine if the `A.TogglerDelegate` transitions will animate.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_animated"
     },
     "closeAllOnExpand": {
      "!type": "fn()",
      "!doc": "Determine if the `A.TogglerDelegate` switches\nwill be set to off when one switch is toggled on.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_closeAllOnExpand"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container of `A.TogglerDelegate` instance.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_container"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The content of a Toogler Delegate instance.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_content"
     },
     "expanded": {
      "!type": "fn()",
      "!doc": "Determine if the content starts as toggled on/off on page load.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_expanded"
     },
     "header": {
      "!type": "fn()",
      "!doc": "The header of a Toogler Delegate instance.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_header"
     },
     "transition": {
      "!type": "fn()",
      "!doc": "Transition definitions such as duration and type of easing effect.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#attribute_transition"
     },
     "collapseAll": {
      "!type": "fn()",
      "!doc": "Collapse all items.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#method_collapseAll"
     },
     "createAll": {
      "!type": "fn()",
      "!doc": "Forces toggler creation on delegated header elements.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#method_createAll"
     },
     "expandAll": {
      "!type": "fn()",
      "!doc": "Expand all items.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#method_expandAll"
     },
     "findContentNode": {
      "!type": "fn(header)",
      "!doc": "Return the content node.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#method_findContentNode"
     },
     "headerEventHandler": {
      "!type": "fn(event)",
      "!doc": "Handle header events.",
      "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#method_headerEventHandler"
     }
    },
    "EXTENDS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define which component it extends.",
     "!url": "http://alloyui.com/classes/A.TogglerDelegate.html#property_EXTENDS"
    }
   }
  },
  "aui_toolbar": {
   "A.Toolbar": {
    "!type": "fn(config: yui.Object) -> +aui_toolbar.A.Toolbar",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Toolbar.\n\nCheck the [live demo](http://alloyui.com/examples/toolbar/).",
    "!url": "http://alloyui.com/classes/A.Toolbar.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Toolbar.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#property_ATTRS"
    },
    "prototype": {
     "children": {
      "!type": "fn()",
      "!doc": "A list of child elements.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#attribute_children"
     },
     "toolbarRenderer": {
      "!type": "fn()",
      "!doc": "Define a new `ToolbarRenderer`.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#attribute_toolbarRenderer"
     },
     "add": {
      "!type": "fn(children, where)",
      "!doc": "Insert children on Toolbar.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#method_add"
     },
     "clear": {
      "!type": "fn()",
      "!doc": "Clear children from Toolbar.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#method_clear"
     },
     "getEnclosingWidget": {
      "!type": "fn(seed)",
      "!doc": "Find the first ancestor node that is a widget bounding box.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#method_getEnclosingWidget"
     },
     "item": {
      "!type": "fn(index)",
      "!doc": "Get a certain item based on its index.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#method_item"
     },
     "remove": {
      "!type": "fn(where)",
      "!doc": "Remove children from Toolbar.",
      "!url": "http://alloyui.com/classes/A.Toolbar.html#method_remove"
     }
    },
    "UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the UI attributes.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#property_UI_ATTRS"
    },
    "A.Toolbar.isSupportedWidget": {
     "!type": "fn(o)",
     "!doc": "Check if type is supported.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#method_A.Toolbar.isSupportedWidget"
    },
    "CONTENT_TEMPLATE": {
     "!type": "?",
     "!doc": "Static property provide a content template.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#property_CONTENT_TEMPLATE"
    },
    "TEMPLATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provide a group of templates.",
     "!url": "http://alloyui.com/classes/A.Toolbar.html#property_TEMPLATES"
    }
   },
   "A.ToolbarRenderer": {
    "!type": "fn(config: yui.Object) -> +aui_toolbar.A.ToolbarRenderer",
    "!doc": "A base class for ToolbarRenderer.\n\nCheck the [live demo](http://alloyui.com/examples/toolbar/).",
    "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html",
    "TEMPLATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides a set of templates.",
     "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#property_TEMPLATES"
    },
    "RENDERER": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define how\nthings are going to be rendered.",
     "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#property_RENDERER"
    },
    "prototype": {
     "button": {
      "!type": "fn(childRenderHints)",
      "!doc": "Define how a button should be rendered.",
      "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#method_button"
     },
     "group": {
      "!type": "fn(childRenderHints)",
      "!doc": "Define how a group should be rendered.",
      "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#method_group"
     },
     "render": {
      "!type": "fn(children)",
      "!doc": "Render children in a document fragment.",
      "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#method_render"
     },
     "renderNode": {
      "!type": "fn(child)",
      "!doc": "Render node.",
      "!url": "http://alloyui.com/classes/A.ToolbarRenderer.html#method_renderNode"
     }
    }
   }
  },
  "aui_tooltip": {
   "A.Tooltip": {
    "!type": "fn(config: yui.Object) -> +aui_tooltip.A.Tooltip",
    "!proto": "widget.Widget",
    "!doc": "A base class for Tooltip.\n\nCheck the [live demo](http://alloyui.com/examples/tooltip/).",
    "!url": "http://alloyui.com/classes/A.Tooltip.html",
    "CSS_PREFIX": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the CSS prefix.",
     "!url": "http://alloyui.com/classes/A.Tooltip.html#property_CSS_PREFIX"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Tooltip.",
     "!url": "http://alloyui.com/classes/A.Tooltip.html#property_ATTRS"
    },
    "prototype": {
     "animated": {
      "!type": "fn()",
      "!doc": "Determine if the transitions will animate or not.",
      "!url": "http://alloyui.com/classes/A.Tooltip.html#attribute_animated"
     },
     "constrain": {
      "!type": "fn()",
      "!doc": "Determine the tooltip constrain node.",
      "!url": "http://alloyui.com/classes/A.Tooltip.html#attribute_constrain"
     },
     "formatter": {
      "!type": "fn()",
      "!doc": "Format the title attribute before set the content of the tooltip.",
      "!url": "http://alloyui.com/classes/A.Tooltip.html#attribute_formatter"
     },
     "opacity": {
      "!type": "fn()",
      "!doc": "Determine the opacity.",
      "!url": "http://alloyui.com/classes/A.Tooltip.html#attribute_opacity"
     },
     "triggerShowEvent": {
      "!type": "fn()",
      "!doc": "DOM event to show the tooltip.",
      "!url": "http://alloyui.com/classes/A.Tooltip.html#attribute_triggerShowEvent"
     }
    },
    "TEMPLATES": {
     "!type": "+yui.Object",
     "!doc": "Static property provides a set of reusable templates.",
     "!url": "http://alloyui.com/classes/A.Tooltip.html#property_TEMPLATES"
    }
   },
   "A.TooltipDelegate": {
    "!type": "fn(config: yui.Object) -> +aui_tooltip.A.TooltipDelegate",
    "!proto": "base.Base",
    "!doc": "A base class for Toggler Delegate.\n\nCheck the [live demo](http://alloyui.com/examples/tooltip/).",
    "!url": "http://alloyui.com/classes/A.TooltipDelegate.html",
    "prototype": {
     "_onUserHideInteraction": {
      "!type": "fn(event)",
      "!doc": "Show tooltip on user interaction.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#method__onUserHideInteraction"
     },
     "_onUserShowInteraction": {
      "!type": "fn(event)",
      "!doc": "Show tooltip on user interaction.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#method__onUserShowInteraction"
     },
     "align": {
      "!type": "fn()",
      "!doc": "The alignment configuration for this widget.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_align"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container of Toggler Delegate instance.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_container"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "Determine the duration of the tooltip animation.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_duration"
     },
     "opacity": {
      "!type": "fn()",
      "!doc": "Determine the opacity of the tooltip.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_opacity"
     },
     "triggerHideEvent": {
      "!type": "fn()",
      "!doc": "DOM event to hide the tooltip.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_triggerHideEvent"
     },
     "triggerShowEvent": {
      "!type": "fn()",
      "!doc": "DOM event to show the tooltip.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_triggerShowEvent"
     },
     "zIndex": {
      "!type": "fn()",
      "!doc": "Specify the zIndex for the tooltips.",
      "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#attribute_zIndex"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Toggler Delegate.",
     "!url": "http://alloyui.com/classes/A.TooltipDelegate.html#property_ATTRS"
    }
   }
  },
  "aui_tree": {
   "A.TreeData": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeData",
    "!proto": "base.Base",
    "!doc": "A base class for TreeData, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Handle the data of the tree\n- Basic DOM implementation (append/remove/insert)\n- Indexing management to handle the children nodes",
    "!url": "http://alloyui.com/classes/A.TreeData.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeData.",
     "!url": "http://alloyui.com/classes/A.TreeData.html#property_ATTRS"
    },
    "prototype": {
     "container": {
      "!type": "fn()",
      "!doc": "Container to nest children nodes. If it has a container it's not a leaf.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#attribute_container"
     },
     "children": {
      "!type": "fn()",
      "!doc": "Array of children (i.e. could be a JSON metadata object or a TreeNode\ninstance).",
      "!url": "http://alloyui.com/classes/A.TreeData.html#attribute_children"
     },
     "index": {
      "!type": "fn()",
      "!doc": "Index the nodes.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#attribute_index"
     },
     "getNodeById": {
      "!type": "fn(uid: string) -> +aui_tree.TreeNode",
      "!doc": "Get a TreeNode by id.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_getNodeById"
     },
     "isRegistered": {
      "!type": "fn(node: aui_tree.TreeNode) -> bool",
      "!doc": "Whether the TreeNode is registered on this TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_isRegistered"
     },
     "updateReferences": {
      "!type": "fn(node: aui_tree.TreeNode, parentNode: aui_tree.TreeNode, ownerTree: TreeView)",
      "!doc": "Update the references of the passed TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_updateReferences"
     },
     "refreshIndex": {
      "!type": "fn()",
      "!doc": "Refresh the index (i.e. re-index all nodes).",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_refreshIndex"
     },
     "registerNode": {
      "!type": "fn(node: aui_tree.TreeNode)",
      "!doc": "Register the passed TreeNode on this TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_registerNode"
     },
     "updateIndex": {
      "!type": "fn(index: yui.Object)",
      "!doc": "Update the [index](A.TreeData.html#attr_index) attribute value.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_updateIndex"
     },
     "unregisterNode": {
      "!type": "fn(node: aui_tree.TreeNode)",
      "!doc": "Unregister the passed TreeNode from this TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_unregisterNode"
     },
     "collapseAll": {
      "!type": "fn()",
      "!doc": "Collapse all children of the TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_collapseAll"
     },
     "expandAll": {
      "!type": "fn()",
      "!doc": "Expand all children of the TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_expandAll"
     },
     "selectAll": {
      "!type": "fn()",
      "!doc": "Select all children of the TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_selectAll"
     },
     "unselectAll": {
      "!type": "fn()",
      "!doc": "Unselect all children of the TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_unselectAll"
     },
     "eachChildren": {
      "!type": "fn(fn: fn(), deep: bool)",
      "!doc": "Loop each children and execute the `fn` callback.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_eachChildren"
     },
     "eachParent": {
      "!type": "fn(fn: fn())",
      "!doc": "Loop each parent node and execute the `fn` callback.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_eachParent"
     },
     "bubbleEvent": {
      "!type": "fn(eventType: string, args: yui.Array, cancelBubbling: bool, stopActionPropagation: bool)",
      "!doc": "Bubble event to all parent nodes.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_bubbleEvent"
     },
     "createNode": {
      "!type": "fn(options: yui.Object) -> +aui_tree.TreeNode",
      "!doc": "Create a TreeNode instance.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_createNode"
     },
     "appendChild": {
      "!type": "fn(node: aui_tree.TreeNode, cancelBubbling: bool)",
      "!doc": "Append a child node to the TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_appendChild"
     },
     "item": {
      "!type": "fn(index: number) -> +aui_tree.TreeNode",
      "!doc": "Get a TreeNode children by index.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_item"
     },
     "indexOf": {
      "!type": "fn(node: aui_tree.TreeNode) -> number",
      "!doc": "Index of the passed TreeNode on the\n[children](A.TreeData.html#attr_children) attribute.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_indexOf"
     },
     "hasChildNodes": {
      "!type": "fn() -> bool",
      "!doc": "Whether the TreeData contains children or not.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_hasChildNodes"
     },
     "getChildren": {
      "!type": "fn(deep: bool) -> +yui.Array",
      "!doc": "Get an Array of the children nodes of the current TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_getChildren"
     },
     "getEventOutputMap": {
      "!type": "fn(node: TreeData) -> +yui.Object",
      "!doc": "Get an object containing metadata for the custom events.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_getEventOutputMap"
     },
     "removeChild": {
      "!type": "fn(node: TreeData)",
      "!doc": "Remove the passed `node` from the current TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_removeChild"
     },
     "_removeChild": {
      "!type": "fn(node: TreeData)",
      "!doc": "Remove the passed `node` from the current TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method__removeChild"
     },
     "empty": {
      "!type": "fn()",
      "!doc": "Delete all children of the current TreeData.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_empty"
     },
     "insert": {
      "!type": "fn(treeNode: aui_tree.TreeNode, refTreeNode: aui_tree.TreeNode, where: aui_tree.TreeNode)",
      "!doc": "Insert `treeNode` before or after the `refTreeNode`.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_insert"
     },
     "insertAfter": {
      "!type": "fn(treeNode: aui_tree.TreeNode, refTreeNode: aui_tree.TreeNode)",
      "!doc": "Insert `treeNode` after the `refTreeNode`.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_insertAfter"
     },
     "insertBefore": {
      "!type": "fn(treeNode: aui_tree.TreeNode, refTreeNode: aui_tree.TreeNode)",
      "!doc": "Insert `treeNode` before the `refTreeNode`.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_insertBefore"
     },
     "getNodeByChild": {
      "!type": "fn(child: node.Node) -> +aui_tree.TreeNode",
      "!doc": "Get a TreeNode instance by a child DOM Node.",
      "!url": "http://alloyui.com/classes/A.TreeData.html#method_getNodeByChild"
     }
    }
   },
   "A.TreeViewIO": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeViewIO",
    "!doc": "A base class for TreeViewIO.",
    "!url": "http://alloyui.com/classes/A.TreeViewIO.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeViewIO.",
     "!url": "http://alloyui.com/classes/A.TreeViewIO.html#property_ATTRS"
    },
    "prototype": {
     "io": {
      "!type": "fn()",
      "!doc": "IO options for the current TreeNode load the children.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#attribute_io"
     },
     "initIO": {
      "!type": "fn()",
      "!doc": "Initialize the IO transaction setup on the\n[io](A.TreeViewIO.html#attr_io) attribute.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#method_initIO"
     },
     "ioStartHandler": {
      "!type": "fn()",
      "!doc": "IO Start handler.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#method_ioStartHandler"
     },
     "ioCompleteHandler": {
      "!type": "fn()",
      "!doc": "IO Complete handler.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#method_ioCompleteHandler"
     },
     "ioSuccessHandler": {
      "!type": "fn()",
      "!doc": "IO Success handler.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#method_ioSuccessHandler"
     },
     "ioFailureHandler": {
      "!type": "fn()",
      "!doc": "IO Failure handler.",
      "!url": "http://alloyui.com/classes/A.TreeViewIO.html#method_ioFailureHandler"
     }
    }
   },
   "A.TreeNode": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeNode",
    "!proto": "base.Base",
    "!doc": "A base class for TreeNode, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- The node for the TreeView component\n\nCheck the [live demo](http://alloyui.com/examples/tree/).",
    "!url": "http://alloyui.com/classes/A.TreeNode.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeNode.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeNode.",
     "!url": "http://alloyui.com/classes/A.TreeNode.html#property_ATTRS"
    },
    "prototype": {
     "boundingBox": {
      "!type": "fn()",
      "!doc": "The widget's outermost node, used for sizing and positioning.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_boundingBox"
     },
     "contentBox": {
      "!type": "fn()",
      "!doc": "The direct descendant of a widget's\nbounding box and houses its content.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_contentBox"
     },
     "cssClasses": {
      "!type": "fn()",
      "!doc": "CSS classes used on TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_cssClasses"
     },
     "draggable": {
      "!type": "fn()",
      "!doc": "If true the TreeNode is draggable.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_draggable"
     },
     "ownerTree": {
      "!type": "fn()",
      "!doc": "TreeView which contains the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_ownerTree"
     },
     "label": {
      "!type": "fn()",
      "!doc": "Label of the TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_label"
     },
     "expanded": {
      "!type": "fn()",
      "!doc": "Whether the TreeNode is expanded by default.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_expanded"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Id of the TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_id"
     },
     "leaf": {
      "!type": "fn()",
      "!doc": "Whether the TreeNode could have children or not (i.e. if any\nchildren is present the TreeNode is a leaf).",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_leaf"
     },
     "nextSibling": {
      "!type": "fn()",
      "!doc": "Next sibling of the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_nextSibling"
     },
     "prevSibling": {
      "!type": "fn()",
      "!doc": "Previous sibling of the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_prevSibling"
     },
     "parentNode": {
      "!type": "fn()",
      "!doc": "Parent node of the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_parentNode"
     },
     "labelEl": {
      "!type": "fn()",
      "!doc": "Label element to house the `label` attribute.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_labelEl"
     },
     "hitAreaEl": {
      "!type": "fn()",
      "!doc": "Hitarea element.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_hitAreaEl"
     },
     "alwaysShowHitArea": {
      "!type": "fn()",
      "!doc": "Always show the hitarea icon.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_alwaysShowHitArea"
     },
     "iconEl": {
      "!type": "fn()",
      "!doc": "Icon element.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_iconEl"
     },
     "tabIndex": {
      "!type": "fn()",
      "!doc": "Specify the tab order.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_tabIndex"
     },
     "rendered": {
      "!type": "fn()",
      "!doc": "If true the TreeNode is rendered.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#attribute_rendered"
     },
     "render": {
      "!type": "fn(container)",
      "!doc": "Render TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_render"
     },
     "appendChild": {
      "!type": "fn()",
      "!doc": "Append child on TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_appendChild"
     },
     "collapse": {
      "!type": "fn()",
      "!doc": "Collapse the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_collapse"
     },
     "collapseAll": {
      "!type": "fn()",
      "!doc": "Collapse all TreeNodes.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_collapseAll"
     },
     "contains": {
      "!type": "fn(node: aui_tree.TreeNode) -> bool",
      "!doc": "Check if the current TreeNode contains the passed `node`.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_contains"
     },
     "createNodes": {
      "!type": "fn(nodes)",
      "!doc": "Create nodes.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_createNodes"
     },
     "expand": {
      "!type": "fn()",
      "!doc": "Expand the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_expand"
     },
     "expandAll": {
      "!type": "fn()",
      "!doc": "Expand all TreeNodes.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_expandAll"
     },
     "getDepth": {
      "!type": "fn() -> number",
      "!doc": "Get the depth of the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_getDepth"
     },
     "hasChildNodes": {
      "!type": "fn()",
      "!doc": "Check if it has child nodes.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_hasChildNodes"
     },
     "isSelected": {
      "!type": "fn() -> bool",
      "!doc": "Whether the current TreeNode is selected or not.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_isSelected"
     },
     "isLeaf": {
      "!type": "fn() -> bool",
      "!doc": "Whether the current TreeNode is ancestor of the passed `node` or not.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_isLeaf"
     },
     "toggle": {
      "!type": "fn()",
      "!doc": "Toggle the current TreeNode, `collapsed` or `expanded`.",
      "!url": "http://alloyui.com/classes/A.TreeNode.html#method_toggle"
     }
    }
   },
   "A.TreeNodeIO": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeNodeIO",
    "!proto": "aui_tree.A.TreeNode",
    "!doc": "A base class for TreeNodeIO, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Ajax support to load the children of the current TreeNode",
    "!url": "http://alloyui.com/classes/A.TreeNodeIO.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeNode.",
     "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#property_ATTRS"
    },
    "prototype": {
     "loading": {
      "!type": "fn()",
      "!doc": "Whether the current TreeNode IO transaction is loading.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#attribute_loading"
     },
     "loaded": {
      "!type": "fn()",
      "!doc": "Whether the current TreeNode has loaded the content.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#attribute_loaded"
     },
     "cache": {
      "!type": "fn()",
      "!doc": "Whether the current TreeNode should cache the loaded content or not.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#attribute_cache"
     },
     "leaf": {
      "!type": "fn()",
      "!doc": "Whether the TreeNode could have children or not (i.e. if any\nchildren is present the TreeNode is a leaf).",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#attribute_leaf"
     },
     "createNodes": {
      "!type": "fn(nodes)",
      "!doc": "Create nodes.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#method_createNodes"
     },
     "expand": {
      "!type": "fn()",
      "!doc": "Expand the current TreeNodeIO.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#method_expand"
     },
     "_onIOSuccess": {
      "!type": "fn(event)",
      "!doc": "Fire when IO success.",
      "!url": "http://alloyui.com/classes/A.TreeNodeIO.html#method__onIOSuccess"
     }
    }
   },
   "A.TreeNodeCheck": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeNodeCheck",
    "!proto": "aui_tree.A.TreeNodeIO",
    "!doc": "A base class for TreeNodeCheck, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- Checkbox support for the TreeNode",
    "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeNode.",
     "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#property_ATTRS"
    },
    "prototype": {
     "checked": {
      "!type": "fn()",
      "!doc": "Whether the TreeNode is checked or not.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#attribute_checked"
     },
     "checkName": {
      "!type": "fn()",
      "!doc": "Name of the checkbox element used on the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#attribute_checkName"
     },
     "checkContainerEl": {
      "!type": "fn()",
      "!doc": "Container element for the checkbox.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#attribute_checkContainerEl"
     },
     "checkEl": {
      "!type": "fn()",
      "!doc": "Checkbox element.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#attribute_checkEl"
     },
     "check": {
      "!type": "fn()",
      "!doc": "Check the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#method_check"
     },
     "uncheck": {
      "!type": "fn()",
      "!doc": "Uncheck the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#method_uncheck"
     },
     "toggleCheck": {
      "!type": "fn()",
      "!doc": "Toggle the check status of the current TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#method_toggleCheck"
     },
     "isChecked": {
      "!type": "fn() -> ?",
      "!doc": "Whether the current TreeNodeCheck is checked.",
      "!url": "http://alloyui.com/classes/A.TreeNodeCheck.html#method_isChecked"
     }
    }
   },
   "A.TreeNodeTask": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeNodeTask",
    "!proto": "aui_tree.A.TreeNodeCheck",
    "!doc": "A base class for TreeNodeTask, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- 3 states checkbox support\n- Automatic check/uncheck the parent status based on the children checked\n  status",
    "!url": "http://alloyui.com/classes/A.TreeNodeTask.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeNodeTask.html#property_NAME"
    },
    "prototype": {
     "check": {
      "!type": "fn(originalTarget)",
      "!doc": "Check the current TreeNodeTask.",
      "!url": "http://alloyui.com/classes/A.TreeNodeTask.html#method_check"
     },
     "uncheck": {
      "!type": "fn(originalTarget)",
      "!doc": "Uncheck the current TreeNodeTask.",
      "!url": "http://alloyui.com/classes/A.TreeNodeTask.html#method_uncheck"
     }
    }
   },
   "A.TreeNodeRadio": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeNodeRadio",
    "!proto": "aui_tree.A.TreeNodeTask",
    "!doc": "A base class for TreeNodeRadio, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- 3 states checkbox support\n- Automatic check/uncheck the parent status based on the children checked\n  status",
    "!url": "http://alloyui.com/classes/A.TreeNodeRadio.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeNodeRadio.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeNodeRadio.",
     "!url": "http://alloyui.com/classes/A.TreeNodeRadio.html#property_ATTRS"
    },
    "prototype": {
     "cssClasses": {
      "!type": "fn()",
      "!doc": "CSS classes used on TreeNodeRadio.",
      "!url": "http://alloyui.com/classes/A.TreeNodeRadio.html#attribute_cssClasses"
     },
     "check": {
      "!type": "fn()",
      "!doc": "Check the current TreeNodeRadio.",
      "!url": "http://alloyui.com/classes/A.TreeNodeRadio.html#method_check"
     }
    }
   },
   "TreeNode": {
    "!type": "fn()",
    "!url": "http://alloyui.com/classes/TreeNode.html",
    "prototype": {
     "nodeTypes": {
      "!type": "+yui.Object",
      "!doc": "TreeNode types hash map.\n\n```\nA.TreeNode.nodeTypes = {\n radio: A.TreeNodeRadio,\n task: A.TreeNodeTask,\n check: A.TreeNodeCheck,\n node: A.TreeNode,\n io: A.TreeNodeIO\n};\n```",
      "!url": "http://alloyui.com/classes/TreeNode.html#property_nodeTypes"
     }
    }
   },
   "A.TreeViewPaginator": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeViewPaginator",
    "!doc": "A base class for TreeViewPaginator.",
    "!url": "http://alloyui.com/classes/A.TreeViewPaginator.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeView.",
     "!url": "http://alloyui.com/classes/A.TreeViewPaginator.html#property_ATTRS"
    },
    "prototype": {
     "paginator": {
      "!type": "fn()",
      "!doc": "Paginator.",
      "!url": "http://alloyui.com/classes/A.TreeViewPaginator.html#attribute_paginator"
     }
    }
   },
   "A.TreeView": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeView",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for TreeView, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n\nCheck the [live demo](http://alloyui.com/examples/tree/).",
    "!url": "http://alloyui.com/classes/A.TreeView.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeView.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeView.",
     "!url": "http://alloyui.com/classes/A.TreeView.html#property_ATTRS"
    },
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Type of the treeview (i.e. could be 'file' or 'normal').",
      "!url": "http://alloyui.com/classes/A.TreeView.html#attribute_type"
     },
     "lastSelected": {
      "!type": "fn()",
      "!doc": "Last selected TreeNode.",
      "!url": "http://alloyui.com/classes/A.TreeView.html#attribute_lastSelected"
     },
     "lazyLoad": {
      "!type": "fn()",
      "!doc": "Determine if its going to be lazy loaded or not.",
      "!url": "http://alloyui.com/classes/A.TreeView.html#attribute_lazyLoad"
     },
     "selectOnToggle": {
      "!type": "fn()",
      "!doc": "Determine if its going to be selected on toggle.",
      "!url": "http://alloyui.com/classes/A.TreeView.html#attribute_selectOnToggle"
     },
     "createNodes": {
      "!type": "fn(nodes)",
      "!doc": "Create Nodes.",
      "!url": "http://alloyui.com/classes/A.TreeView.html#method_createNodes"
     }
    }
   },
   "A.TreeViewDD": {
    "!type": "fn(config: yui.Object) -> +aui_tree.A.TreeViewDD",
    "!proto": "aui_tree.A.TreeView",
    "!doc": "A base class for TreeViewDD, providing:\n\n- Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n- DragDrop support for the TreeNodes",
    "!url": "http://alloyui.com/classes/A.TreeViewDD.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.TreeViewDD.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the TreeViewDD.",
     "!url": "http://alloyui.com/classes/A.TreeViewDD.html#property_ATTRS"
    },
    "prototype": {
     "helper": {
      "!type": "fn()",
      "!doc": "Dragdrop helper element.",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_helper"
     },
     "scrollDelay": {
      "!type": "fn()",
      "!doc": "Delay of the scroll while dragging the TreeNodes.",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_scrollDelay"
     },
     "dropAction": {
      "!type": "fn()",
      "!doc": "Drop action (i.e. could be 'append', 'below' or 'above').",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_dropAction"
     },
     "lastY": {
      "!type": "fn()",
      "!doc": "Last Y.",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_lastY"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Node.",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_node"
     },
     "nodeContent": {
      "!type": "fn()",
      "!doc": "Reference for the current drop node.",
      "!url": "http://alloyui.com/classes/A.TreeViewDD.html#attribute_nodeContent"
     }
    }
   }
  },
  "aui_url": {
   "A.Url": {
    "!type": "fn(config: yui.Object) -> +aui_url.A.Url",
    "!doc": "A base class for `A.Url`.\n\nIn order to understand what each attribute/method does,\nyou need to see the anatomy of a URL:\n\n```\n foo://example.com:8042/over/there?name=ferret#nose\n \\_/   \\______________/\\_________/ \\_________/ \\__/\nScheme     Authority       Path       Query   Anchor\n```",
    "!url": "http://alloyui.com/classes/A.Url.html",
    "prototype": {
     "addParameter": {
      "!type": "fn(key, values)",
      "!doc": "Adds a single parameter in the URL.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_addParameter"
     },
     "addParameters": {
      "!type": "fn(parameters)",
      "!doc": "Adds a list of parameters in the URL.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_addParameters"
     },
     "hasParameter": {
      "!type": "fn(key) -> bool",
      "!doc": "Checks if the URL has a parameter.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_hasParameter"
     },
     "getParameter": {
      "!type": "fn(key) -> string",
      "!doc": "Gets a single parameter.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getParameter"
     },
     "getParameters": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets a list of parameters.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getParameters"
     },
     "getAnchor": {
      "!type": "fn() -> string",
      "!doc": "Gets the anchor.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getAnchor"
     },
     "getAuthority": {
      "!type": "fn() -> string",
      "!doc": "Gets the authority.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getAuthority"
     },
     "getDirectory": {
      "!type": "fn() -> string",
      "!doc": "Gets the directory.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getDirectory"
     },
     "getFile": {
      "!type": "fn() -> string",
      "!doc": "Gets the file.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getFile"
     },
     "getHost": {
      "!type": "fn() -> string",
      "!doc": "Gets the host.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getHost"
     },
     "getPassword": {
      "!type": "fn() -> string",
      "!doc": "Gets the password.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getPassword"
     },
     "getPath": {
      "!type": "fn() -> string",
      "!doc": "Gets the path.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getPath"
     },
     "getPort": {
      "!type": "fn() -> string",
      "!doc": "Gets the port.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getPort"
     },
     "getProtocol": {
      "!type": "fn() -> string",
      "!doc": "Gets the protocol.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getProtocol"
     },
     "getQuery": {
      "!type": "fn() -> string",
      "!doc": "Gets the query.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getQuery"
     },
     "getRelative": {
      "!type": "fn() -> string",
      "!doc": "Gets the relative.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getRelative"
     },
     "getSource": {
      "!type": "fn() -> string",
      "!doc": "Gets the source.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getSource"
     },
     "getUser": {
      "!type": "fn() -> string",
      "!doc": "Gets the user.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getUser"
     },
     "getUserInfo": {
      "!type": "fn() -> string",
      "!doc": "Gets the user info.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_getUserInfo"
     },
     "removeParameter": {
      "!type": "fn(key)",
      "!doc": "Removes a single parameter from the parameters list.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_removeParameter"
     },
     "removeParameters": {
      "!type": "fn(parameters)",
      "!doc": "Removes a list of parameters from the parameters list.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_removeParameters"
     },
     "setParameter": {
      "!type": "fn(key, opt_values)",
      "!doc": "Sets a single parameter.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setParameter"
     },
     "setParameters": {
      "!type": "fn(parameters)",
      "!doc": "Sets a list of parameters.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setParameters"
     },
     "setAnchor": {
      "!type": "fn(val)",
      "!doc": "Sets the anchor.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setAnchor"
     },
     "setAuthority": {
      "!type": "fn(val)",
      "!doc": "Sets the authority.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setAuthority"
     },
     "setDirectory": {
      "!type": "fn(val)",
      "!doc": "Sets the directory.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setDirectory"
     },
     "setFile": {
      "!type": "fn(val)",
      "!doc": "Sets the file.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setFile"
     },
     "setHost": {
      "!type": "fn(val)",
      "!doc": "Sets the host.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setHost"
     },
     "setPassword": {
      "!type": "fn(val)",
      "!doc": "Sets the password.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setPassword"
     },
     "setPath": {
      "!type": "fn(val)",
      "!doc": "Sets the path.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setPath"
     },
     "setPort": {
      "!type": "fn(val)",
      "!doc": "Sets the port.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setPort"
     },
     "setProtocol": {
      "!type": "fn(val)",
      "!doc": "Sets the protocol.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setProtocol"
     },
     "setRelative": {
      "!type": "fn(val)",
      "!doc": "Sets the relative.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setRelative"
     },
     "setSource": {
      "!type": "fn(val)",
      "!doc": "Sets the source.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setSource"
     },
     "setUser": {
      "!type": "fn(val)",
      "!doc": "Sets the user.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setUser"
     },
     "setUserInfo": {
      "!type": "fn(val)",
      "!doc": "Sets the user info.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_setUserInfo"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Generates the entire URL based on each attribute.",
      "!url": "http://alloyui.com/classes/A.Url.html#method_toString"
     }
    }
   }
  },
  "aui_video": {
   "A.Video": {
    "!type": "fn(config: yui.Object) -> +aui_video.A.Video",
    "!proto": "aui_component.A.Component",
    "!doc": "A base class for Video.\n\nCheck the [live demo](http://alloyui.com/examples/video/).",
    "!url": "http://alloyui.com/classes/A.Video.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://alloyui.com/classes/A.Video.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Video.",
     "!url": "http://alloyui.com/classes/A.Video.html#property_ATTRS"
    },
    "prototype": {
     "url": {
      "!type": "fn()",
      "!doc": "URL used by Video to play.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_url"
     },
     "ogvUrl": {
      "!type": "fn()",
      "!doc": "URL (on .ogv format) used by Video to play.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_ogvUrl"
     },
     "swfUrl": {
      "!type": "fn()",
      "!doc": "URL (on .swf format) used by Video to create\na fallback player with Flash.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_swfUrl"
     },
     "poster": {
      "!type": "fn()",
      "!doc": "Image displayed before playback starts.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_poster"
     },
     "fixedAttributes": {
      "!type": "fn()",
      "!doc": "An additional list of attributes.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_fixedAttributes"
     },
     "flashVars": {
      "!type": "fn()",
      "!doc": "Variables used by Flash player.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_flashVars"
     },
     "render": {
      "!type": "fn()",
      "!doc": "If `true` the render phase will be automatically invoked\npreventing the `.render()` manual call.",
      "!url": "http://alloyui.com/classes/A.Video.html#attribute_render"
     },
     "load": {
      "!type": "fn()",
      "!doc": "Load video track.",
      "!url": "http://alloyui.com/classes/A.Video.html#method_load"
     },
     "pause": {
      "!type": "fn()",
      "!doc": "Pause video track.",
      "!url": "http://alloyui.com/classes/A.Video.html#method_pause"
     },
     "play": {
      "!type": "fn()",
      "!doc": "Play video track.",
      "!url": "http://alloyui.com/classes/A.Video.html#method_play"
     }
    },
    "BIND_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes\nfor the bindUI lifecycle phase.",
     "!url": "http://alloyui.com/classes/A.Video.html#property_BIND_UI_ATTRS"
    },
    "SYNC_UI_ATTRS": {
     "!type": "+yui.Array",
     "!doc": "Static property used to define the attributes\nfor the syncUI lifecycle phase.",
     "!url": "http://alloyui.com/classes/A.Video.html#property_SYNC_UI_ATTRS"
    }
   }
  },
  "aui_widget_cssclass": {
   "A.WidgetCssClass": {
    "!type": "fn(The: yui.Object)",
    "!doc": "Widget extension, which can be used to add cssClass support to the\nbase Widget class, through the [Base.build](Base.html#method_build) method.",
    "!url": "http://alloyui.com/classes/A.WidgetCssClass.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Component.",
     "!url": "http://alloyui.com/classes/A.WidgetCssClass.html#property_ATTRS"
    },
    "prototype": {
     "cssClass": {
      "!type": "fn()",
      "!doc": "CSS class to be automatically added to the `boundingBox`.",
      "!url": "http://alloyui.com/classes/A.WidgetCssClass.html#attribute_cssClass"
     }
    },
    "CSS_CLASS_CONTENT_SUFFIX": {
     "!type": "string",
     "!doc": "Static property used to define the default suffix for cssClass attribute\nvalue applied on `contentBox` node.",
     "!url": "http://alloyui.com/classes/A.WidgetCssClass.html#property_CSS_CLASS_CONTENT_SUFFIX"
    }
   },
   "A.WidgetPositionAlignSuggestion": {
    "!type": "fn(The: yui.Object)",
    "!doc": "Widget extension, which can be used to suggest alignment points based on\nposition attribute to base Widget class, through the\n[Base.build](Base.html#method_build) method. It also tries to find\nthe best position in case the widget doesn't fit it's constrainment node.",
    "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration.",
     "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html#property_ATTRS"
    },
    "prototype": {
     "position": {
      "!type": "fn()",
      "!doc": "Determine the position of the tooltip.",
      "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html#attribute_position"
     },
     "POSITION_ALIGN_SUGGESTION": {
      "!type": "+",
      "!doc": "Property defining the align points based on the suggested `position`.",
      "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html#property_POSITION_ALIGN_SUGGESTION"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "Construction logic executed during WidgetPositionAlignSuggestion\ninstantiation. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html#method_initializer"
     },
     "alignNode": {
      "!type": "fn()",
      "!doc": "Suggest alignment for the node based on the `position` suggestion.",
      "!url": "http://alloyui.com/classes/A.WidgetPositionAlignSuggestion.html#attribute_alignNode"
     }
    }
   }
  },
  "aui_widget_toggle": {
   "A.WidgetToggle": {
    "!type": "fn(The: yui.Object)",
    "!doc": "Widget extension, which can be used to add toggle visibility support to the\nbase Widget class, through the [Base.build](Base.html#method_build)\nmethod.",
    "!url": "http://alloyui.com/classes/A.WidgetToggle.html",
    "prototype": {
     "toggle": {
      "!type": "fn(visible: bool)",
      "!doc": "Toggles widget visibility.",
      "!url": "http://alloyui.com/classes/A.WidgetToggle.html#method_toggle"
     }
    }
   }
  },
  "aui_widget_toolbars": {
   "A.WidgetToolbars": {
    "!type": "fn() -> +aui_widget_toolbars.A.WidgetToolbars",
    "!doc": "A base class for Widget Toolbars.",
    "!url": "http://alloyui.com/classes/A.WidgetToolbars.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration.",
     "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#property_ATTRS"
    },
    "prototype": {
     "toolbars": {
      "!type": "fn()",
      "!doc": "Collection of `A.Toolbar` instances.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#attribute_toolbars"
     },
     "toolbarPosition": {
      "!type": "fn()",
      "!doc": "Collection of toolbar's header, body, and footer positions.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#attribute_toolbarPosition"
     },
     "addToolbar": {
      "!type": "fn(toolbar, section) -> +aui_toolbar.A.Toolbar",
      "!doc": "Includes a `A.Toolbar` instance into the widget.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#method_addToolbar"
     },
     "getToolbar": {
      "!type": "fn(section) -> +aui_toolbar.A.Toolbar",
      "!doc": "Gets the `A.Toolbar` instance based on its section.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#method_getToolbar"
     },
     "getToolbarSection": {
      "!type": "fn(section) -> string",
      "!doc": "Gets the toolbar's section. If no argument is passed, returns the\n`StdMod.FOOTER`.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#method_getToolbarSection"
     },
     "removeToolbar": {
      "!type": "fn(section)",
      "!doc": "Destroys the `A.Toolbar` instance based on its section.",
      "!url": "http://alloyui.com/classes/A.WidgetToolbars.html#method_removeToolbar"
     }
    }
   }
  },
  "aui_widget_transition": {
   "A.WidgetTransition": {
    "!type": "fn() -> +aui_widget_transition.A.WidgetTransition",
    "!doc": "Widget extension, which can be used to add toggle visibility support to the\nbase Widget class, through the [Base.build](Base.html#method_build)\nmethod.",
    "!url": "http://alloyui.com/classes/A.WidgetTransition.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration.",
     "!url": "http://alloyui.com/classes/A.WidgetTransition.html#property_ATTRS"
    },
    "prototype": {
     "animated": {
      "!type": "fn()",
      "!doc": "Determine if the transitions will animate or not.",
      "!url": "http://alloyui.com/classes/A.WidgetTransition.html#attribute_animated"
     },
     "delay": {
      "!type": "fn()",
      "!doc": "Determine the `delay` (in milliseconds) after widget's transition\nanimation. By default there's no delay. Can pass as parameter\na object `{show: value, hide: value}` or a single value 'Number'.",
      "!url": "http://alloyui.com/classes/A.WidgetTransition.html#attribute_delay"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "Determine the duration of the transition.",
      "!url": "http://alloyui.com/classes/A.WidgetTransition.html#attribute_duration"
     },
     "opacity": {
      "!type": "fn()",
      "!doc": "Determine the opacity.",
      "!url": "http://alloyui.com/classes/A.WidgetTransition.html#attribute_opacity"
     },
     "stickDuration": {
      "!type": "fn()",
      "!doc": "Determine the duration (in milliseconds) for the widget to stick\nvisibility after the trigger element. By default the stick duration is\nnot specified.",
      "!url": "http://alloyui.com/classes/A.WidgetTransition.html#attribute_stickDuration"
     }
    }
   },
   "A.WidgetTrigger": {
    "!type": "fn(The: yui.Object)",
    "!doc": "Widget extension, which can be used to add trigger support to the\nbase Widget class, through the [Base.build](Base.html#method_build) method.",
    "!url": "http://alloyui.com/classes/A.WidgetTrigger.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration.",
     "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#property_ATTRS"
    },
    "prototype": {
     "bindDOMEvents": {
      "!type": "fn()",
      "!doc": "Determine if the Toggler should bind DOM events or not.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#attribute_bindDOMEvents"
     },
     "trigger": {
      "!type": "fn()",
      "!doc": "Trigger node to change widget visibility state.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#attribute_trigger"
     },
     "triggerHideEvent": {
      "!type": "fn()",
      "!doc": "DOM event to hide the tooltip.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#attribute_triggerHideEvent"
     },
     "triggerShowEvent": {
      "!type": "fn()",
      "!doc": "DOM event to show the tooltip.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#attribute_triggerShowEvent"
     },
     "triggerToggleEvent": {
      "!type": "fn()",
      "!doc": "DOM event to toggle the tooltip.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#attribute_triggerToggleEvent"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "Construction logic executed during WidgetTrigger\ninstantiation. Lifecycle.",
      "!url": "http://alloyui.com/classes/A.WidgetTrigger.html#method_initializer"
     }
    }
   }
  },
  "anim": {
   "Anim": {
    "!type": "fn() -> +anim.Anim",
    "!proto": "base.Base",
    "!doc": "A class for constructing animation instances.",
    "!url": "http://alloyui.com/classes/Anim.html",
    "getBezier": {
     "!type": "fn(points: [number], t: number) -> [number]",
     "!doc": "Get the current position of the animated element based on t.\nEach point is an array of \"x\" and \"y\" values (0 = x, 1 = y)\nAt least 2 points are required (start and end).\nFirst point is start. Last point is end.\nAdditional control points are optional.",
     "!url": "http://alloyui.com/classes/Anim.html#method_getBezier"
    },
    "prototype": {
     "start": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation begins.",
      "!url": "http://alloyui.com/classes/Anim.html#event_start"
     },
     "tween": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires every frame of the animation.",
      "!url": "http://alloyui.com/classes/Anim.html#event_tween"
     },
     "end": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires after the animation completes.",
      "!url": "http://alloyui.com/classes/Anim.html#event_end"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The object to be animated.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_node"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "The length of the animation.  Defaults to \"1\" (second).",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_duration"
     },
     "easing": {
      "!type": "fn()",
      "!doc": "The method that will provide values to the attribute(s) during the animation.\nDefaults to \"Easing.easeNone\".",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_easing"
     },
     "from": {
      "!type": "fn()",
      "!doc": "The starting values for the animated properties.\n\nFields may be strings, numbers, or functions.\nIf a function is used, the return value becomes the from value.\nIf no from value is specified, the DEFAULT_GETTER will be used.\nSupports any unit, provided it matches the \"to\" (or default)\nunit (e.g. `{width: '10em', color: 'rgb(0, 0, 0)', borderColor: '#ccc'}`).\n\nIf using the default ('px' for length-based units), the unit may be omitted\n(e.g. `{width: 100}, borderColor: 'ccc'}`, which defaults to pixels\nand hex, respectively).",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_from"
     },
     "to": {
      "!type": "fn()",
      "!doc": "The ending values for the animated properties.\n\nFields may be strings, numbers, or functions.\nSupports any unit, provided it matches the \"from\" (or default)\nunit (e.g. `{width: '50%', color: 'red', borderColor: '#ccc'}`).\n\nIf using the default ('px' for length-based units), the unit may be omitted\n(e.g. `{width: 100, borderColor: 'ccc'}`, which defaults to pixels\nand hex, respectively).",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_to"
     },
     "startTime": {
      "!type": "fn()",
      "!doc": "Date stamp for the first frame of the animation.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_startTime"
     },
     "elapsedTime": {
      "!type": "fn()",
      "!doc": "Current time the animation has been running.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_elapsedTime"
     },
     "running": {
      "!type": "fn()",
      "!doc": "Whether or not the animation is currently running.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_running"
     },
     "iterations": {
      "!type": "fn()",
      "!doc": "The number of times the animation should run",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_iterations"
     },
     "iterationCount": {
      "!type": "fn()",
      "!doc": "The number of iterations that have occurred.\nResets when an animation ends (reaches iteration count or stop() called).",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_iterationCount"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "How iterations of the animation should behave.\nPossible values are \"normal\" and \"alternate\".\nNormal will repeat the animation, alternate will reverse on every other pass.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_direction"
     },
     "paused": {
      "!type": "fn()",
      "!doc": "Whether or not the animation is currently paused.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_paused"
     },
     "reverse": {
      "!type": "fn()",
      "!doc": "If true, the `from` and `to` attributes are swapped, \nand the animation is then run starting from `from`.",
      "!url": "http://alloyui.com/classes/Anim.html#attribute_reverse"
     },
     "run": {
      "!type": "fn() -> !this",
      "!doc": "Starts or resumes an animation.",
      "!url": "http://alloyui.com/classes/Anim.html#method_run"
     },
     "pause": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation is paused.",
      "!url": "http://alloyui.com/classes/Anim.html#event_pause"
     },
     "stop": {
      "!type": "fn(finish: bool) -> !this",
      "!doc": "Stops the animation and resets its time.",
      "!url": "http://alloyui.com/classes/Anim.html#method_stop"
     },
     "resume": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation is resumed (run from pause).",
      "!url": "http://alloyui.com/classes/Anim.html#event_resume"
     },
     "iteration": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation begins an iteration.",
      "!url": "http://alloyui.com/classes/Anim.html#event_iteration"
     }
    },
    "RE_DEFAULT_UNIT": {
     "!type": "?",
     "!doc": "Regex of properties that should use the default unit.",
     "!url": "http://alloyui.com/classes/Anim.html#property_RE_DEFAULT_UNIT"
    },
    "DEFAULT_UNIT": {
     "!type": "?",
     "!doc": "The default unit to use with properties that pass the RE_DEFAULT_UNIT test.",
     "!url": "http://alloyui.com/classes/Anim.html#property_DEFAULT_UNIT"
    },
    "intervalTime": {
     "!type": "?",
     "!doc": "Time in milliseconds passed to setInterval for frame processing",
     "!url": "http://alloyui.com/classes/Anim.html#property_intervalTime"
    },
    "behaviors": {
     "!type": "?",
     "!doc": "Bucket for custom getters and setters",
     "!url": "http://alloyui.com/classes/Anim.html#property_behaviors"
    },
    "DEFAULT_SETTER": {
     "!type": "?",
     "!doc": "The default setter to use when setting object properties.",
     "!url": "http://alloyui.com/classes/Anim.html#property_DEFAULT_SETTER"
    },
    "DEFAULT_GETTER": {
     "!type": "?",
     "!doc": "The default getter to use when getting object properties.",
     "!url": "http://alloyui.com/classes/Anim.html#property_DEFAULT_GETTER"
    },
    "run": {
     "!type": "fn()",
     "!doc": "Runs all animation instances.",
     "!url": "http://alloyui.com/classes/Anim.html#method_run"
    },
    "pause": {
     "!type": "fn()",
     "!doc": "Pauses all animation instances.",
     "!url": "http://alloyui.com/classes/Anim.html#method_pause"
    },
    "stop": {
     "!type": "fn()",
     "!doc": "Stops all animation instances.",
     "!url": "http://alloyui.com/classes/Anim.html#method_stop"
    }
   },
   "Easing": {
    "!type": "fn()",
    "!doc": "The easing module provides methods for customizing\nhow an animation behaves during each run.",
    "!url": "http://alloyui.com/classes/Easing.html",
    "prototype": {
     "easeNone": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Uniform speed between points.",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeNone"
     },
     "easeIn": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and accelerates towards end. (quadratic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeIn"
     },
     "easeOut": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins quickly and decelerates towards end.  (quadratic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeOut"
     },
     "easeBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and decelerates towards end. (quadratic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeBoth"
     },
     "easeInStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and accelerates towards end. (quartic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeInStrong"
     },
     "easeOutStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins quickly and decelerates towards end.  (quartic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeOutStrong"
     },
     "easeBothStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and decelerates towards end. (quartic)",
      "!url": "http://alloyui.com/classes/Easing.html#method_easeBothStrong"
     },
     "elasticIn": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap in elastic effect.",
      "!url": "http://alloyui.com/classes/Easing.html#method_elasticIn"
     },
     "elasticOut": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap out elastic effect.",
      "!url": "http://alloyui.com/classes/Easing.html#method_elasticOut"
     },
     "elasticBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap both elastic effect.",
      "!url": "http://alloyui.com/classes/Easing.html#method_elasticBoth"
     },
     "backIn": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Backtracks slightly, then reverses direction and moves to end.",
      "!url": "http://alloyui.com/classes/Easing.html#method_backIn"
     },
     "backOut": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Overshoots end, then reverses and comes back to end.",
      "!url": "http://alloyui.com/classes/Easing.html#method_backOut"
     },
     "backBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Backtracks slightly, then reverses direction, overshoots end,\nthen reverses and comes back to end.",
      "!url": "http://alloyui.com/classes/Easing.html#method_backBoth"
     },
     "bounceIn": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounce off of start.",
      "!url": "http://alloyui.com/classes/Easing.html#method_bounceIn"
     },
     "bounceOut": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounces off end.",
      "!url": "http://alloyui.com/classes/Easing.html#method_bounceOut"
     },
     "bounceBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounces off start and end.",
      "!url": "http://alloyui.com/classes/Easing.html#method_bounceBoth"
     }
    }
   }
  },
  "app": {
   "App.Content": {
    "!type": "fn()",
    "!doc": "`Y.App` extension that provides pjax-style content fetching and handling.\n\nThis makes it easy to fetch server rendered content for URLs using Ajax. The\nHTML content returned from the server will be view-ified and set as the app's\nmain content, making it seamless to use a mixture of server and client rendered\nviews.\n\nWhen the `\"app-content\"` module is used, it will automatically mix itself into\n`Y.App`, and it provides three main features:\n\n  - **`Y.App.Content.route`**: A stack of middleware which forms a pjax-style\n    content route.\n\n  - **`loadContent()`**: Route middleware which load content from a server. This\n    makes an Ajax request for the requested URL, parses the returned content and\n    puts it on the route's response object.\n\n  - **`showContent()`**: Method which provides an easy way to view-ify HTML\n    content which should be shown as an app's active/visible view.\n\nThe following is an example of how these features can be used:\n\n    // Creates a new app and registers the `\"post\"` view.\n    var app = new Y.App({\n        views: {\n            post: {type: Y.PostView}\n        }\n    });\n\n    // Uses a simple server rendered content route for the About page.\n    app.route('/about/', Y.App.Content.route);\n\n    // Uses the `loadContent()` middleware to fetch the contents of the post\n    // from the server and shows that content in a `\"post\"` view.\n    app.route('/posts/:id/', 'loadContent', function (req, res, next) {\n        this.showContent(res.content.node, {view: 'post'});\n    });",
    "!url": "http://alloyui.com/classes/App.Content.html",
    "route": {
     "!type": "+yui.Array",
     "!doc": "A stack of middleware which forms a pjax-style content route.\n\nThis route will load the rendered HTML content from the server, then create and\nshow a new view using those contents.",
     "!url": "http://alloyui.com/classes/App.Content.html#property_route"
    },
    "prototype": {
     "showContent": {
      "!type": "fn(content: HTMLElement, options?: yui.Object, callback?: fn())",
      "!doc": "Sets this app's `activeView` attribute using the specified `content`.\n\nThis provides an easy way to view-ify HTML content which should be shown as\nthis app's active/visible view. This method will determine the appropriate\nview `container` node based on the specified `content`. By default, a new\n`Y.View` instance will be created unless `options.view` is specified.\n\nUnder the hood, this method calls the `showView()` method, so refer to its\ndocs for more information.",
      "!url": "http://alloyui.com/classes/App.Content.html#method_showContent"
     }
    }
   },
   "App.Transitions": {
    "!type": "fn()",
    "!doc": "`Y.App` extension that provides view transitions in browsers which support\nnative CSS3 transitions.\n\nView transitions provide an nice way to move from one \"page\" to the next that is\nboth pleasant to the user and helps to communicate a hierarchy between sections\nof an application.\n\nWhen the `\"app-transitions\"` module is used, it will automatically mix itself\ninto `Y.App` and transition between `activeView` changes using the following\neffects:\n\n  - **`fade`**: Cross-fades between the old an new active views.\n\n  - **`slideLeft`**: The old and new active views are positioned next to each\n    other and both slide to the left.\n\n  - **`slideRight`**: The old and new active views are positioned next to each\n    other and both slide to the right.\n\n**Note:** Transitions are an opt-in feature and are enabled via an app's\n`transitions` attribute.",
    "!url": "http://alloyui.com/classes/App.Transitions.html",
    "prototype": {
     "transitions": {
      "!type": "+yui.Object",
      "!doc": "Default transitions to use when the `activeView` changes.\n\nThe following are types of changes for which transitions can be defined that\ncorrespond to the relationship between the new and previous `activeView`:\n\n  * `navigate`: The default transition to use when changing the `activeView`\n    of the application.\n\n  * `toChild`: The transition to use when the new `activeView` is configured\n    as a child of the previously active view via its `parent` property as\n    defined in this app's `views`.\n\n  * `toParent`: The transition to use when the new `activeView` is\n    configured as the `parent` of the previously active view as defined in\n    this app's `views`.\n\n**Note:** Transitions are an opt-in feature and will only be used in\nbrowsers which support native CSS3 transitions.",
      "!url": "http://alloyui.com/classes/App.Transitions.html#property_transitions"
     },
     "showView": {
      "!type": "fn(view: string, config?: yui.Object, options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Sets which view is active/visible for the application. This will set the\napp's `activeView` attribute to the specified `view`.\n\nThe `view` will be \"attached\" to this app, meaning it will be both rendered\ninto this app's `viewContainer` node and all of its events will bubble to\nthe app. The previous `activeView` will be \"detached\" from this app.\n\nWhen a string-name is provided for a view which has been registered on this\napp's `views` object, the referenced metadata will be used and the\n`activeView` will be set to either a preserved view instance, or a new\ninstance of the registered view will be created using the specified `config`\nobject passed-into this method.\n\nA callback function can be specified as either the third or fourth argument,\nand this function will be called after the new `view` becomes the\n`activeView`, is rendered to the `viewContainer`, and is ready to use.",
      "!url": "http://alloyui.com/classes/App.Transitions.html#method_showView"
     }
    },
    "FX": {
     "!type": "+yui.Object",
     "!doc": "Collect of transitions -> fx.\n\nA transition (e.g. \"fade\") is a simple name given to a configuration of fx to\napply, consisting of `viewIn` and `viewOut` properties who's values are names of\nfx registered on `Y.Transition.fx`.\n\nBy default transitions: `fade`, `slideLeft`, and `slideRight` have fx defined.",
     "!url": "http://alloyui.com/classes/App.Transitions.html#property_FX"
    }
   },
   "ModelSync.Local": {
    "!type": "fn()",
    "!doc": "An extension which provides a sync implementation through locally stored\nkey value pairs, either through the HTML localStorage API or falling back\nonto an in-memory cache, that can be mixed into a Model or ModelList subclass.\n\nA group of Models/ModelLists is serialized in localStorage by either its\nclass name, or a specified 'root' that is provided.\n\n    var User = Y.Base.create('user', Y.Model, [Y.ModelSync.Local], {\n        root: 'user'\n    });\n\n    var Users = Y.Base.create('users', Y.ModelList, [Y.ModelSync.Local], {\n        model: User,\n    });",
    "!url": "http://alloyui.com/classes/ModelSync.Local.html",
    "prototype": {
     "root": {
      "!type": "string",
      "!doc": "Root used as the key inside of localStorage and/or the in-memory store.",
      "!url": "http://alloyui.com/classes/ModelSync.Local.html#property_root"
     },
     "storage": {
      "!type": "+Storage",
      "!doc": "Shortcut for access to localStorage.",
      "!url": "http://alloyui.com/classes/ModelSync.Local.html#property_storage"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Creates a synchronization layer with the localStorage API, if available.\nOtherwise, falls back to a in-memory data store.\n\nThis method is called internally by load(), save(), and destroy().",
      "!url": "http://alloyui.com/classes/ModelSync.Local.html#method_sync"
     }
    }
   },
   "ModelSync.REST": {
    "!type": "fn()",
    "!doc": "An extension which provides a RESTful XHR sync implementation that can be mixed\ninto a Model or ModelList subclass.\n\nThis makes it trivial for your Model or ModelList subclasses communicate and\ntransmit their data via RESTful XHRs. In most cases you'll only need to provide\na value for `root` when sub-classing `Y.Model`.\n\n    Y.User = Y.Base.create('user', Y.Model, [Y.ModelSync.REST], {\n        root: '/users'\n    });\n\n    Y.Users = Y.Base.create('users', Y.ModelList, [Y.ModelSync.REST], {\n        // By convention `Y.User`'s `root` will be used for the lists' URL.\n        model: Y.User\n    });\n\n    var users = new Y.Users();\n\n    // GET users list from: \"/users\"\n    users.load(function () {\n        var firstUser = users.item(0);\n\n        firstUser.get('id'); // => \"1\"\n\n        // PUT updated user data at: \"/users/1\"\n        firstUser.set('name', 'Eric').save();\n    });",
    "!url": "http://alloyui.com/classes/ModelSync.REST.html",
    "CSRF_TOKEN": {
     "!type": "string",
     "!doc": "A request authenticity token to validate HTTP requests made by this extension\nwith the server when the request results in changing persistent state. This\nallows you to protect your server from Cross-Site Request Forgery attacks.\n\nA CSRF token provided by the server can be embedded in the HTML document and\nassigned to `YUI.Env.CSRF_TOKEN` like this:\n\n    <script>\n        YUI.Env.CSRF_TOKEN = {{session.authenticityToken}};\n    </script>\n\nThe above should come after YUI seed file so that `YUI.Env` will be defined.\n\n**Note:** This can be overridden on a per-request basis. See `sync()` method.\n\nWhen a value for the CSRF token is provided, either statically or via `options`\npassed to the `save()` and `destroy()` methods, the applicable HTTP requests\nwill have a `X-CSRF-Token` header added with the token value.",
     "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_CSRF_TOKEN"
    },
    "EMULATE_HTTP": {
     "!type": "bool",
     "!doc": "Static flag to use the HTTP POST method instead of PUT or DELETE.\n\nIf the server-side HTTP framework isn't RESTful, setting this flag to `true`\nwill cause all PUT and DELETE requests to instead use the POST HTTP method, and\nadd a `X-HTTP-Method-Override` HTTP header with the value of the method type\nwhich was overridden.",
     "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_EMULATE_HTTP"
    },
    "HTTP_HEADERS": {
     "!type": "+yui.Object",
     "!doc": "Default headers used with all XHRs.\n\nBy default the `Accept` and `Content-Type` headers are set to\n\"application/json\", this signals to the HTTP server to process the request\nbodies as JSON and send JSON responses. If you're sending and receiving content\nother than JSON, you can override these headers and the `parse()` and\n`serialize()` methods.\n\n**Note:** These headers will be merged with any request-specific headers, and\nthe request-specific headers will take precedence.",
     "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_HTTP_HEADERS"
    },
    "HTTP_METHODS": {
     "!type": "+yui.Object",
     "!doc": "Static mapping of RESTful HTTP methods corresponding to CRUD actions.",
     "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_HTTP_METHODS"
    },
    "HTTP_TIMEOUT": {
     "!type": "number",
     "!doc": "The number of milliseconds before the XHRs will timeout/abort. This defaults to\n30 seconds.\n\n**Note:** This can be overridden on a per-request basis. See `sync()` method.",
     "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_HTTP_TIMEOUT"
    },
    "prototype": {
     "root": {
      "!type": "string",
      "!doc": "A string which represents the root or collection part of the URL which\nrelates to a Model or ModelList. Usually this value should be same for all\ninstances of a specific Model/ModelList subclass.\n\nWhen sub-classing `Y.Model`, usually you'll only need to override this\nproperty, which lets the URLs for the XHRs be generated by convention. If\nthe `root` string ends with a trailing-slash, XHR URLs will also end with a\n\"/\", and if the `root` does not end with a slash, neither will the XHR URLs.",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_root"
     },
     "url": {
      "!type": "string",
      "!doc": "A string which specifies the URL to use when making XHRs, if not value is\nprovided, the URLs used to make XHRs will be generated by convention.\n\nWhile a `url` can be provided for each Model/ModelList instance, usually\nyou'll want to either rely on the default convention or provide a tokenized\nstring on the prototype which can be used for all instances.\n\nWhen sub-classing `Y.Model`, you will probably be able to rely on the\ndefault convention of generating URLs in conjunction with the `root`\nproperty and whether the model is new or not (i.e. has an `id`). If the\n`root` property ends with a trailing-slash, the generated URL for the\nspecific model will also end with a trailing-slash.",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#property_url"
     },
     "getURL": {
      "!type": "fn(action?: string, options?: yui.Object) -> string",
      "!doc": "Returns the URL for this model or model list for the given `action` and\n`options`, if specified.\n\nThis method correctly handles the variations of `root` and `url` values and\nis called by the `sync()` method to get the URLs used to make the XHRs.\n\nYou can override this method if you need to provide a specific\nimplementation for how the URLs of your Model and ModelList subclasses need\nto be generated.",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#method_getURL"
     },
     "parseIOResponse": {
      "!type": "fn(response: yui.Object) -> +Any",
      "!doc": "Called to parse the response object returned from `Y.io()`. This method\nreceives the full response object and is expected to \"prep\" a response which\nis suitable to pass to the `parse()` method.\n\nBy default the response body is returned (`responseText`), because it\nusually represents the entire entity of this model on the server.\n\nIf you need to parse data out of the response's headers you should do so by\noverriding this method. If you'd like the entire response object from the\nXHR to be passed to your `parse()` method, you can simply assign this\nproperty to `false`.",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#method_parseIOResponse"
     },
     "serialize": {
      "!type": "fn(action?: string) -> string",
      "!doc": "Serializes `this` model to be used as the HTTP request entity body.\n\nBy default this model will be serialized to a JSON string via its `toJSON()`\nmethod.\n\nYou can override this method when the HTTP server expects a different\nrepresentation of this model's data that is different from the default JSON\nserialization. If you're sending and receive content other than JSON, be\nsure change the `Accept` and `Content-Type` `HTTP_HEADERS` as well.\n\n**Note:** A model's `toJSON()` method can also be overridden. If you only\nneed to modify which attributes are serialized to JSON, that's a better\nplace to start.",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#method_serialize"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Communicates with a RESTful HTTP server by sending and receiving data via\nXHRs. This method is called internally by load(), save(), and destroy().\n\nThe URL used for each XHR will be retrieved by calling the `getURL()` method\nand passing it the specified `action` and `options`.\n\nThis method relies heavily on standard RESTful HTTP conventions",
      "!url": "http://alloyui.com/classes/ModelSync.REST.html#method_sync"
     }
    }
   },
   "View.NodeMap": {
    "!type": "fn()",
    "!doc": "View extension that adds a static `getByNode()` method that returns the nearest\nView instance associated with the given Node (similar to Widget's `getByNode()`\nmethod).\n\nNote that it's important to call `destroy()` on a View instance using this\nextension when you plan to stop using it. This ensures that all internal\nreferences to that View are cleared to prevent memory leaks.",
    "!url": "http://alloyui.com/classes/View.NodeMap.html",
    "getByNode": {
     "!type": "fn(node: node.Node) -> +app.View",
     "!doc": "Returns the nearest View instance associated with the given Node. The Node may\nbe a View container or any child of a View container.\n\nNote that only instances of Views that have the Y.View.NodeMap extension mixed\nin will be returned. The base View class doesn't provide this functionality by\ndefault due to the additional memory management overhead involved in maintaining\na mapping of Nodes to View instances.",
     "!url": "http://alloyui.com/classes/View.NodeMap.html#method_getByNode"
    }
   },
   "App.Base": {
    "!type": "fn(config?: yui.Object) -> +app.App.Base",
    "!proto": "base.Base",
    "!doc": "Provides a top-level application component which manages navigation and views.\n\nThis gives you a foundation and structure on which to build your application; it\ncombines robust URL navigation with powerful routing and flexible view\nmanagement.",
    "!url": "http://alloyui.com/classes/App.Base.html",
    "prototype": {
     "views": {
      "!type": "+yui.Object",
      "!doc": "Hash of view-name to metadata used to declaratively describe an\napplication's views and their relationship with the app and its other views.\n\nThe view metadata is composed of Objects keyed to a view-name that can have\nany or all of the following properties:\n\n  * `type`: Function or a string representing the view constructor to use to\n    create view instances. If a string is used, the constructor function is\n    assumed to be on the `Y` object; e.g. `\"SomeView\"` -> `Y.SomeView`.\n\n  * `preserve`: Boolean for whether the view instance should be retained. By\n    default, the view instance will be destroyed when it is no longer the\n    `activeView`. If `true` the view instance will simply be `removed()`\n    from the DOM when it is no longer active. This is useful when the view\n    is frequently used and may be expensive to re-create.\n\n  * `parent`: String to another named view in this hash that represents the\n    parent view within the application's view hierarchy; e.g. a `\"photo\"`\n    view could have `\"album\"` has its `parent` view. This parent/child\n    relationship is a useful cue for things like transitions.\n\n  * `instance`: Used internally to manage the current instance of this named\n    view. This can be used if your view instance is created up-front, or if\n    you would rather manage the View lifecycle, but you probably should just\n    let this be handled for you.\n\nIf `views` are specified at instantiation time, the metadata in the `views`\nObject here will be used as defaults when creating the instance's `views`.\n\nEvery `Y.App` instance gets its own copy of a `views` object so this Object\non the prototype will not be polluted.",
      "!url": "http://alloyui.com/classes/App.Base.html#property_views"
     },
     "createView": {
      "!type": "fn(name: string, config?: yui.Object) -> +app.View",
      "!doc": "Creates and returns a new view instance using the provided `name` to look up\nthe view info metadata defined in the `views` object. The passed-in `config`\nobject is passed to the view constructor function.\n\nThis function also maps a view instance back to its view info metadata.",
      "!url": "http://alloyui.com/classes/App.Base.html#method_createView"
     },
     "getViewInfo": {
      "!type": "fn(view: app.View) -> +yui.Object",
      "!doc": "Returns the metadata associated with a view instance or view name defined on\nthe `views` object.",
      "!url": "http://alloyui.com/classes/App.Base.html#method_getViewInfo"
     },
     "navigate": {
      "!type": "fn(url: string, options?: yui.Object)",
      "!doc": "Navigates to the specified URL if there is a route handler that matches. In\nbrowsers capable of using HTML5 history or when `serverRouting` is falsy,\nthe navigation will be enhanced by firing the `navigate` event and having\nthe app handle the \"request\". When `serverRouting` is `true`, non-HTML5\nbrowsers will navigate to the new URL via a full page reload.\n\nWhen there is a route handler for the specified URL and it is being\nnavigated to, this method will return `true`, otherwise it will return\n`false`.\n\n**Note:** The specified URL _must_ be of the same origin as the current URL,\notherwise an error will be logged and navigation will not occur. This is\nintended as both a security constraint and a purposely imposed limitation as\nit does not make sense to tell the app to navigate to a URL on a\ndifferent scheme, host, or port.",
      "!url": "http://alloyui.com/classes/App.Base.html#method_navigate"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Renders this application by appending the `viewContainer` node to the\n`container` node if it isn't already a child of the container, and the\n`activeView` will be appended the view container, if it isn't already.\n\nYou should call this method at least once, usually after the initialization\nof your app instance so the proper DOM structure is setup and optionally\nappend the container to the DOM if it's not there already.\n\nYou may override this method to customize the app's rendering, but you\nshould expect that the `viewContainer`'s contents will be modified by the\napp for the purpose of rendering the `activeView` when it changes.",
      "!url": "http://alloyui.com/classes/App.Base.html#method_render"
     },
     "showView": {
      "!type": "fn(view: string, config?: yui.Object, options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Sets which view is active/visible for the application. This will set the\napp's `activeView` attribute to the specified `view`.\n\nThe `view` will be \"attached\" to this app, meaning it will be both rendered\ninto this app's `viewContainer` node and all of its events will bubble to\nthe app. The previous `activeView` will be \"detached\" from this app.\n\nWhen a string-name is provided for a view which has been registered on this\napp's `views` object, the referenced metadata will be used and the\n`activeView` will be set to either a preserved view instance, or a new\ninstance of the registered view will be created using the specified `config`\nobject passed-into this method.\n\nA callback function can be specified as either the third or fourth argument,\nand this function will be called after the new `view` becomes the\n`activeView`, is rendered to the `viewContainer`, and is ready to use.",
      "!url": "http://alloyui.com/classes/App.Base.html#method_showView"
     },
     "activeView": {
      "!type": "fn()",
      "!doc": "The application's active/visible view.\n\nThis attribute is read-only, to set the `activeView` use the\n`showView()` method.",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_activeView"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Container node which represents the application's bounding-box, into\nwhich this app's content will be rendered.\n\nThe container node serves as the host for all DOM events attached by the\napp. Delegation is used to handle events on children of the container,\nallowing the container's contents to be re-rendered at any time without\nlosing event subscriptions.\n\nThe default container is the `<body>` Node, but you can override this in\na subclass, or by passing in a custom `container` config value at\ninstantiation time.\n\nWhen `container` is overridden by a subclass or passed as a config\noption at instantiation time, it may be provided as a selector string, a\nDOM element, or a `Y.Node` instance. During initialization, this app's\n`create()` method will be called to convert the container into a\n`Y.Node` instance if it isn't one already and stamp it with the CSS\nclass: `\"yui3-app\"`.\n\nThe container is not added to the page automatically. This allows you to\nhave full control over how and when your app is actually rendered to\nthe page.",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_container"
     },
     "html5": {
      "!type": "fn()",
      "!doc": "Whether or not this browser is capable of using HTML5 history.\n\nThis value is dependent on the value of `serverRouting` and will default\naccordingly.\n\nSetting this to `false` will force the use of hash-based history even on\nHTML5 browsers, but please don't do this unless you understand the\nconsequences.",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_html5"
     },
     "linkSelector": {
      "!type": "fn()",
      "!doc": "CSS selector string used to filter link click events so that only the\nlinks which match it will have the enhanced-navigation behavior of pjax\napplied.\n\nWhen a link is clicked and that link matches this selector, navigating\nto the link's `href` URL using the enhanced, pjax, behavior will be\nattempted; and the browser's default way to navigate to new pages will\nbe the fallback.\n\nBy default this selector will match _all_ links on the page.",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_linkSelector"
     },
     "serverRouting": {
      "!type": "fn()",
      "!doc": "Whether or not this application's server is capable of properly routing\nall requests and rendering the initial state in the HTML responses.\n\nThis can have three different values, each having particular\nimplications on how the app will handle routing and navigation:\n\n  * `undefined`: The best form of URLs will be chosen based on the\n    capabilities of the browser. Given no information about the server\n    environmentm a balanced approach to routing and navigation is\n    chosen.\n\n    The server should be capable of handling full-path requests, since\n    full-URLs will be generated by browsers using HTML5 history. If this\n    is a client-side-only app the server could handle full-URL requests\n    by sending a redirect back to the root with a hash-based URL, e.g:\n\n        Request:     http://example.com/users/1\n        Redirect to: http://example.com/#/users/1\n\n  * `true`: The server is *fully* capable of properly handling requests\n    to all full-path URLs the app can produce.\n\n    This is the best option for progressive-enhancement because it will\n    cause **all URLs to always have full-paths**, which means the server\n    will be able to accurately handle all URLs this app produces. e.g.\n\n        http://example.com/users/1\n\n    To meet this strict full-URL requirement, browsers which are not\n    capable of using HTML5 history will make requests to the server\n    resulting in full-page reloads.\n\n  * `false`: The server is *not* capable of properly handling requests\n    to all full-path URLs the app can produce, therefore all routing\n    will be handled by this App instance.\n\n    Be aware that this will cause **all URLs to always be hash-based**,\n    even in browsers that are capable of using HTML5 history. e.g.\n\n        http://example.com/#/users/1\n\n    A single-page or client-side-only app where the server sends a\n    \"shell\" page with JavaScript to the client might have this\n    restriction. If you're setting this to `false`, read the following:\n\n**Note:** When this is set to `false`, the server will *never* receive\nthe full URL because browsers do not send the fragment-part to the\nserver, that is everything after and including the \"#\".\n\nConsider the following example:\n\n    URL shown in browser: http://example.com/#/users/1\n    URL sent to server:   http://example.com/\n\nYou should feel bad about hurting our precious web if you forcefully set\neither `serverRouting` or `html5` to `false`, because you're basically\npunching the web in the face here with your lossy URLs! Please make sure\nyou know what you're doing and that you understand the implications.\n\nIdeally you should always prefer full-path URLs (not /#/foo/), and want\nfull-page reloads when the client's browser is not capable of enhancing\nthe experience using the HTML5 history APIs. Setting this to `true` is\nthe best option for progressive-enhancement (and graceful-degradation).",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_serverRouting"
     },
     "viewContainer": {
      "!type": "fn()",
      "!doc": "The node into which this app's `views` will be rendered when they become\nthe `activeView`.\n\nThe view container node serves as the container to hold the app's\n`activeView`. Each time the `activeView` is set via `showView()`, the\nprevious view will be removed from this node, and the new active view's\n`container` node will be appended.\n\nThe default view container is a `<div>` Node, but you can override this\nin a subclass, or by passing in a custom `viewContainer` config value at\ninstantiation time. The `viewContainer` may be provided as a selector\nstring, DOM element, or a `Y.Node` instance (having the `viewContainer`\nand the `container` be the same node is also supported).\n\nThe app's `render()` method will stamp the view container with the CSS\nclass `\"yui3-app-views\"` and append it to the app's `container` node if\nit isn't already, and any `activeView` will be appended to this node if\nit isn't already.",
      "!url": "http://alloyui.com/classes/App.Base.html#attribute_viewContainer"
     }
    }
   },
   "App": {
    "!type": "fn(config?: yui.Object) -> +app.App",
    "!proto": "app.App.Base",
    "!doc": "Provides a top-level application component which manages navigation and views.\n\nThis gives you a foundation and structure on which to build your application; it\ncombines robust URL navigation with powerful routing and flexible view\nmanagement.\n\n`Y.App` is both a namespace and constructor function. The `Y.App` class is\nspecial in that any `Y.App` class extensions that are included in the YUI\ninstance will be **auto-mixed** on to the `Y.App` class. Consider this example:\n\n    YUI().use('app-base', 'app-transitions', function (Y) {\n        // This will create two YUI Apps, `basicApp` will not have transitions,\n        // but `fancyApp` will have transitions support included and turn it on.\n        var basicApp = new Y.App.Base(),\n            fancyApp = new Y.App({transitions: true});\n    });",
    "!url": "http://alloyui.com/classes/App.html",
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "CSS classes used by `Y.App`.",
     "!url": "http://alloyui.com/classes/App.html#property_CLASS_NAMES"
    },
    "serverRouting": {
     "!type": "bool",
     "!doc": "Default `serverRouting` attribute value for all apps.",
     "!url": "http://alloyui.com/classes/App.html#property_serverRouting"
    }
   },
   "LazyModelList": {
    "!type": "fn() -> +app.LazyModelList",
    "!proto": "app.ModelList",
    "!doc": "LazyModelList is a subclass of ModelList that maintains a list of plain\nJavaScript objects rather than a list of Model instances. This makes it\nwell-suited for managing large amounts of data (on the order of thousands of\nitems) that would tend to bog down a vanilla ModelList.\n\nThe API presented by LazyModelList is the same as that of ModelList, except that\nin every case where ModelList would provide a Model instance, LazyModelList\nprovides a plain JavaScript object. LazyModelList also provides a `revive()`\nmethod that can convert the plain object at a given index into a full Model\ninstance.\n\nSince the items stored in a LazyModelList are plain objects and not full Model\ninstances, there are a few caveats to be aware of:\n\n  * Since items are plain objects and not Model instances, they contain\n    properties rather than Model attributes. To retrieve a property, use\n    `item.foo` rather than `item.get('foo')`. To set a property, use\n    `item.foo = 'bar'` rather than `item.set('foo', 'bar')`.\n\n  * Model attribute getters and setters aren't supported, since items in the\n    LazyModelList are stored and manipulated as plain objects with simple\n    properties rather than YUI attributes.\n\n  * Changes made to the plain object version of an item will not trigger or\n    bubble up Model `change` events. However, once an item is revived into a\n    full Model using the `revive()` method, changes to that Model instance\n    will trigger and bubble change events as expected.\n\n  * Custom `idAttribute` fields are not supported.\n\n  * `id` and `clientId` properties _are_ supported. If an item doesn't have a\n    `clientId` property, one will be generated automatically when the item is\n    added to a LazyModelList.\n\nLazyModelList is generally much more memory efficient than ModelList when\nmanaging large numbers of items, and adding/removing items is significantly\nfaster. However, the tradeoff is that LazyModelList is only well-suited for\nstoring very simple items without complex attributes, and consumers must\nexplicitly revive items into full Model instances as needed (this is not done\ntransparently for performance reasons).",
    "!url": "http://alloyui.com/classes/LazyModelList.html",
    "prototype": {
     "free": {
      "!type": "fn(model?: app.Model) -> !this",
      "!doc": "Deletes the specified model from the model cache to release memory. The\nmodel won't be destroyed or removed from the list, just freed from the\ncache; it can still be instantiated again using `revive()`.\n\nIf no model or model index is specified, all cached models in this list will\nbe freed.\n\nNote: Specifying an index is faster than specifying a model instance, since\nthe latter requires an `indexOf()` call.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_free"
     },
     "get": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#get() to return a map of property values rather than\nperforming attribute lookups.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#getAsHTML() to return a map of HTML-escaped property\nvalues rather than performing attribute lookups.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#getAsURL() to return a map of URL-encoded property\nvalues rather than performing attribute lookups.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_getAsURL"
     },
     "indexOf": {
      "!type": "fn(needle: app.Model) -> number",
      "!doc": "Returns the index of the given object or Model instance in this\nLazyModelList.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_indexOf"
     },
     "reset": {
      "!type": "fn(models?: [yui.Object], options?: yui.Object) -> !this",
      "!doc": "Overrides ModelList#reset() to work with plain objects.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_reset"
     },
     "revive": {
      "!type": "fn(item?: number) -> +app.Model",
      "!doc": "Revives an item (or all items) into a full Model instance. The _item_\nargument may be the index of an object in this list, an actual object (which\nmust exist in the list), or may be omitted to revive all items in the list.\n\nOnce revived, Model instances are attached to this list and cached so that\nreviving them in the future doesn't require another Model instantiation. Use\nthe `free()` method to explicitly uncache and detach a previously revived\nModel instance.\n\nNote: Specifying an index rather than an object will be faster, since\nobjects require an `indexOf()` lookup in order to retrieve the index.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_revive"
     },
     "toJSON": {
      "!type": "fn() -> [+yui.Object]",
      "!doc": "Overrides ModelList#toJSON() to use toArray() instead, since it's more\nefficient for LazyModelList.",
      "!url": "http://alloyui.com/classes/LazyModelList.html#method_toJSON"
     }
    }
   },
   "ModelList": {
    "!type": "fn(config: yui.Object) -> +app.ModelList",
    "!proto": "base.Base",
    "!doc": "Provides an API for managing an ordered list of Model instances.\n\nIn addition to providing convenient `add`, `create`, `reset`, and `remove`\nmethods for managing the models in the list, ModelLists are also bubble targets\nfor events on the model instances they contain. This means, for example, that\nyou can add several models to a list, and then subscribe to the `*:change` event\non the list to be notified whenever any model in the list changes.\n\nModelLists also maintain sort order efficiently as models are added and removed,\nbased on a custom `comparator` function you may define (if no comparator is\ndefined, models are sorted in insertion order).",
    "!url": "http://alloyui.com/classes/ModelList.html",
    "prototype": {
     "add": {
      "!type": "fn(models: app.Model, options?: yui.Object) -> +app.Model",
      "!doc": "Adds the specified model or array of models to this list. You may also pass\nanother ModelList instance, in which case all the models in that list will\nbe added to this one as well.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_add"
     },
     "create": {
      "!type": "fn(model: app.Model, options?: yui.Object, callback?: fn()) -> +app.Model",
      "!doc": "Creates or updates the specified model on the server, then adds it to this\nlist if the server indicates success.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_create"
     },
     "error": {
      "!type": "fn(error: Any, src: string)",
      "!doc": "Fired when an error occurs, such as when an attempt is made to add a\nduplicate model to the list, or when a sync layer response can't be parsed.",
      "!url": "http://alloyui.com/classes/ModelList.html#event_error"
     },
     "load": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Loads this list of models from the server.\n\nThis method delegates to the `sync()` method to perform the actual load\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nIf the load operation succeeds, a `reset` event will be fired.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_load"
     },
     "remove": {
      "!type": "fn(models: app.Model, options?: yui.Object) -> +app.Model",
      "!doc": "Removes the specified model or array of models from this list. You may also\npass another ModelList instance to remove all the models that are in both\nthat instance and this instance, or pass numerical indices to remove the\nmodels at those indices.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_remove"
     },
     "reset": {
      "!type": "fn(models?: [app.Model], options?: yui.Object) -> !this",
      "!doc": "Completely replaces all models in the list with those specified, and fires a\nsingle `reset` event.\n\nUse `reset` when you want to add or remove a large number of items at once\nwith less overhead, and without firing `add` or `remove` events for each\none.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_reset"
     },
     "model": {
      "!type": "+app.Model",
      "!doc": "The `Model` class or subclass of the models in this list.\n\nThe class specified here will be used to create model instances\nautomatically based on attribute hashes passed to the `add()`, `create()`,\nand `reset()` methods.\n\nYou may specify the class as an actual class reference or as a string that\nresolves to a class reference at runtime (the latter can be useful if the\nspecified class will be loaded lazily).",
      "!url": "http://alloyui.com/classes/ModelList.html#property_model"
     },
     "comparator": {
      "!type": "fn(model: app.Model) -> number",
      "!doc": "Define this method to provide a function that takes a model as a parameter\nand returns a value by which that model should be sorted relative to other\nmodels in this list.\n\nBy default, no comparator is defined, meaning that models will not be sorted\n(they'll be stored in the order they're added).",
      "!url": "http://alloyui.com/classes/ModelList.html#method_comparator"
     },
     "each": {
      "!type": "fn(callback: fn(), thisObj?: yui.Object) -> !this",
      "!doc": "Executes the supplied function on each model in this list.\n\nBy default, the callback function's `this` object will refer to the model\ncurrently being iterated. Specify a `thisObj` to override the `this` object\nif desired.\n\nNote: Iteration is performed on a copy of the internal array of models, so\nit's safe to delete a model from the list during iteration.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_each"
     },
     "filter": {
      "!type": "fn(options?: yui.Object, callback: fn()) -> [+app.Model]",
      "!doc": "Executes the supplied function on each model in this list. Returns an array\ncontaining the models for which the supplied function returned a truthy\nvalue.\n\nThe callback function's `this` object will refer to this ModelList. Use\n`Y.bind()` to bind the `this` object to another object if desired.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_filter"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nvalue of that attribute. Otherwise, returns an array containing the values\nof the specified attribute from each model in this list.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> string",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nHTML-escaped value of that attribute. Otherwise, returns an array containing\nthe HTML-escaped values of the specified attribute from each model in this\nlist.\n\nThe values are escaped using `Escape.html()`.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> string",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nURL-encoded value of that attribute. Otherwise, returns an array containing\nthe URL-encoded values of the specified attribute from each model in this\nlist.\n\nThe values are encoded using the native `encodeURIComponent()` function.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_getAsURL"
     },
     "getByClientId": {
      "!type": "fn(clientId: string) -> +app.Model",
      "!doc": "Returns the model with the specified _clientId_, or `null` if not found.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_getByClientId"
     },
     "getById": {
      "!type": "fn(id: string) -> +app.Model",
      "!doc": "Returns the model with the specified _id_, or `null` if not found.\n\nNote that models aren't expected to have an id until they're saved, so if\nyou're working with unsaved models, it may be safer to call\n`getByClientId()`.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_getById"
     },
     "invoke": {
      "!type": "fn(name: string, args?: Any) -> [+Any]",
      "!doc": "Calls the named method on every model in the list. Any arguments provided\nafter _name_ will be passed on to the invoked method.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_invoke"
     },
     "item": {
      "!type": "fn(index: number) -> +app.Model",
      "!doc": "Returns the model at the specified _index_.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_item"
     },
     "map": {
      "!type": "fn(fn: fn(), thisObj?: yui.Object) -> +yui.Array",
      "!doc": "Executes the specified function on each model in this list and returns an\narray of the function's collected return values.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_map"
     },
     "parse": {
      "!type": "fn(response: Any) -> [+yui.Object]",
      "!doc": "Called to parse the _response_ when the list is loaded from the server.\nThis method receives a server _response_ and is expected to return an array\nof model attribute hashes.\n\nThe default implementation assumes that _response_ is either an array of\nattribute hashes or a JSON string that can be parsed into an array of\nattribute hashes. If _response_ is a JSON string and either `Y.JSON` or the\nnative `JSON` object are available, it will be parsed automatically. If a\nparse error occurs, an `error` event will be fired and the model will not be\nupdated.\n\nYou may override this method to implement custom parsing logic if necessary.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_parse"
     },
     "some": {
      "!type": "fn(callback: fn(), thisObj?: yui.Object) -> bool",
      "!doc": "Executes the supplied function on each model in this list, and stops\niterating if the callback returns `true`.\n\nBy default, the callback function's `this` object will refer to the model\ncurrently being iterated. Specify a `thisObj` to override the `this` object\nif desired.\n\nNote: Iteration is performed on a copy of the internal array of models, so\nit's safe to delete a model from the list during iteration.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_some"
     },
     "sort": {
      "!type": "fn(options?: yui.Object) -> !this",
      "!doc": "Forcibly re-sorts the list.\n\nUsually it shouldn't be necessary to call this method since the list\nmaintains its sort order when items are added and removed, but if you change\nthe `comparator` function after items are already in the list, you'll need\nto re-sort.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_sort"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Override this method to provide a custom persistence implementation for this\nlist. The default method just calls the callback without actually doing\nanything.\n\nThis method is called internally by `load()` and its implementations relies\non the callback being called. This effectively means that when a callback is\nprovided, it must be called at some point for the class to operate correctly.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_sync"
     },
     "toArray": {
      "!type": "fn() -> [+app.Model]",
      "!doc": "Returns an array containing the models in this list.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_toArray"
     },
     "toJSON": {
      "!type": "fn() -> [+yui.Object]",
      "!doc": "Returns an array containing attribute hashes for each model in this list,\nsuitable for being passed to `Y.JSON.stringify()`.\n\nUnder the hood, this method calls `toJSON()` on each model in the list and\npushes the results into an array.",
      "!url": "http://alloyui.com/classes/ModelList.html#method_toJSON"
     }
    }
   },
   "Model": {
    "!type": "fn() -> +app.Model",
    "!proto": "base.Base",
    "!doc": "Attribute-based data model with APIs for getting, setting, validating, and\nsyncing attribute values, as well as events for being notified of model changes.\n\nIn most cases, you'll want to create your own subclass of `Y.Model` and\ncustomize it to meet your needs. In particular, the `sync()` and `validate()`\nmethods are meant to be overridden by custom implementations. You may also want\nto override the `parse()` method to parse non-generic server responses.",
    "!url": "http://alloyui.com/classes/Model.html",
    "prototype": {
     "change": {
      "!type": "fn(changed: yui.Object)",
      "!doc": "Fired when one or more attributes on this model are changed.",
      "!url": "http://alloyui.com/classes/Model.html#event_change"
     },
     "error": {
      "!type": "fn(error: Any, src: string)",
      "!doc": "Fired when an error occurs, such as when the model doesn't validate or when\na sync layer response can't be parsed.",
      "!url": "http://alloyui.com/classes/Model.html#event_error"
     },
     "load": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Loads this model from the server.\n\nThis method delegates to the `sync()` method to perform the actual load\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nA successful load operation will fire a `load` event, while an unsuccessful\nload operation will fire an `error` event with the `src` value \"load\".\n\nIf the load operation succeeds and one or more of the loaded attributes\ndiffer from this model's current attributes, a `change` event will be fired.",
      "!url": "http://alloyui.com/classes/Model.html#method_load"
     },
     "save": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Saves this model to the server.\n\nThis method delegates to the `sync()` method to perform the actual save\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nA successful save operation will fire a `save` event, while an unsuccessful\nsave operation will fire an `error` event with the `src` value \"save\".\n\nIf the save operation succeeds and one or more of the attributes returned in\nthe server's response differ from this model's current attributes, a\n`change` event will be fired.",
      "!url": "http://alloyui.com/classes/Model.html#method_save"
     },
     "changed": {
      "!type": "+yui.Object",
      "!doc": "Hash of attributes that have changed since the last time this model was\nsaved.",
      "!url": "http://alloyui.com/classes/Model.html#property_changed"
     },
     "idAttribute": {
      "!type": "string",
      "!doc": "Name of the attribute to use as the unique id (or primary key) for this\nmodel.\n\nThe default is `id`, but if your persistence layer uses a different name for\nthe primary key (such as `_id` or `uid`), you can specify that here.\n\nThe built-in `id` attribute will always be an alias for whatever attribute\nname you specify here, so getting and setting `id` will always behave the\nsame as getting and setting your custom id attribute.",
      "!url": "http://alloyui.com/classes/Model.html#property_idAttribute"
     },
     "lastChange": {
      "!type": "+yui.Object",
      "!doc": "Hash of attributes that were changed in the last `change` event. Each item\nin this hash is an object with the following properties:\n\n  * `newVal`: The new value of the attribute after it changed.\n  * `prevVal`: The old value of the attribute before it changed.\n  * `src`: The source of the change, or `null` if no source was specified.",
      "!url": "http://alloyui.com/classes/Model.html#property_lastChange"
     },
     "lists": {
      "!type": "[+app.ModelList]",
      "!doc": "Array of `ModelList` instances that contain this model.\n\nWhen a model is in one or more lists, the model's events will bubble up to\nthose lists. You can subscribe to a model event on a list to be notified\nwhen any model in the list fires that event.\n\nThis property is updated automatically when this model is added to or\nremoved from a `ModelList` instance. You shouldn't alter it manually. When\nworking with models in a list, you should always add and remove models using\nthe list's `add()` and `remove()` methods.",
      "!url": "http://alloyui.com/classes/Model.html#property_lists"
     },
     "destroy": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Destroys this model instance and removes it from its containing lists, if\nany.\n\nThe _callback_, if one is provided, will be called after the model is\ndestroyed.\n\nIf `options.remove` is `true`, then this method delegates to the `sync()`\nmethod to delete the model from the persistence layer, which is an\nasynchronous action. In this case, the _callback_ (if provided) will be\ncalled after the sync layer indicates success or failure of the delete\noperation.",
      "!url": "http://alloyui.com/classes/Model.html#method_destroy"
     },
     "generateClientId": {
      "!type": "fn() -> string",
      "!doc": "Returns a clientId string that's unique among all models on the current page\n(even models in other YUI instances). Uniqueness across pageviews is\nunlikely.",
      "!url": "http://alloyui.com/classes/Model.html#method_generateClientId"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "Returns the value of the specified attribute.\n\nIf the attribute's value is an object, _name_ may use dot notation to\nspecify the path to a specific property within the object, and the value of\nthat property will be returned.",
      "!url": "http://alloyui.com/classes/Model.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> string",
      "!doc": "Returns an HTML-escaped version of the value of the specified string\nattribute. The value is escaped using `Y.Escape.html()`.",
      "!url": "http://alloyui.com/classes/Model.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> string",
      "!doc": "Returns a URL-encoded version of the value of the specified string\nattribute. The value is encoded using the native `encodeURIComponent()`\nfunction.",
      "!url": "http://alloyui.com/classes/Model.html#method_getAsURL"
     },
     "isModified": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if any attribute of this model has been changed since the\nmodel was last saved.\n\nNew models (models for which `isNew()` returns `true`) are implicitly\nconsidered to be \"modified\" until the first time they're saved.",
      "!url": "http://alloyui.com/classes/Model.html#method_isModified"
     },
     "isNew": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if this model is \"new\", meaning it hasn't been saved since it\nwas created.\n\nNewness is determined by checking whether the model's `id` attribute has\nbeen set. An empty id is assumed to indicate a new model, whereas a\nnon-empty id indicates a model that was either loaded or has been saved\nsince it was created.",
      "!url": "http://alloyui.com/classes/Model.html#method_isNew"
     },
     "parse": {
      "!type": "fn(response: Any) -> +yui.Object",
      "!doc": "Called to parse the _response_ when the model is loaded from the server.\nThis method receives a server _response_ and is expected to return an\nattribute hash.\n\nThe default implementation assumes that _response_ is either an attribute\nhash or a JSON string that can be parsed into an attribute hash. If\n_response_ is a JSON string and either `Y.JSON` or the native `JSON` object\nare available, it will be parsed automatically. If a parse error occurs, an\n`error` event will be fired and the model will not be updated.\n\nYou may override this method to implement custom parsing logic if necessary.",
      "!url": "http://alloyui.com/classes/Model.html#method_parse"
     },
     "set": {
      "!type": "fn(name: string, value: Any, options?: yui.Object) -> !this",
      "!doc": "Sets the value of a single attribute. If model validation fails, the\nattribute will not be set and an `error` event will be fired.\n\nUse `setAttrs()` to set multiple attributes at once.",
      "!url": "http://alloyui.com/classes/Model.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attributes: yui.Object, options?: yui.Object) -> !this",
      "!doc": "Sets the values of multiple attributes at once. If model validation fails,\nthe attributes will not be set and an `error` event will be fired.",
      "!url": "http://alloyui.com/classes/Model.html#method_setAttrs"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Override this method to provide a custom persistence implementation for this\nmodel. The default just calls the callback without actually doing anything.\n\nThis method is called internally by `load()`, `save()`, and `destroy()`, and\ntheir implementations rely on the callback being called. This effectively\nmeans that when a callback is provided, it must be called at some point for\nthe class to operate correctly.",
      "!url": "http://alloyui.com/classes/Model.html#method_sync"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns a copy of this model's attributes that can be passed to\n`Y.JSON.stringify()` or used for other nefarious purposes.\n\nThe `clientId` attribute is not included in the returned object.\n\nIf you've specified a custom attribute name in the `idAttribute` property,\nthe default `id` attribute will not be included in the returned object.\n\nNote: The ECMAScript 5 specification states that objects may implement a\n`toJSON` method to provide an alternate object representation to serialize\nwhen passed to `JSON.stringify(obj)`.  This allows class instances to be\nserialized as if they were plain objects.  This is why Model's `toJSON`\nreturns an object, not a JSON string.\n\nSee <http://es5.github.com/#x15.12.3> for details.",
      "!url": "http://alloyui.com/classes/Model.html#method_toJSON"
     },
     "undo": {
      "!type": "fn(attrNames?: [string], options?: yui.Object) -> !this",
      "!doc": "Reverts the last change to the model.\n\nIf an _attrNames_ array is provided, then only the named attributes will be\nreverted (and only if they were modified in the previous change). If no\n_attrNames_ array is provided, then all changed attributes will be reverted\nto their previous values.\n\nNote that only one level of undo is available: from the current state to the\nprevious state. If `undo()` is called when no previous state is available,\nit will simply do nothing.",
      "!url": "http://alloyui.com/classes/Model.html#method_undo"
     },
     "validate": {
      "!type": "fn(attrs: yui.Object, callback: fn())",
      "!doc": "Override this method to provide custom validation logic for this model.\n\nWhile attribute-specific validators can be used to validate individual\nattributes, this method gives you a hook to validate a hash of all\nattributes before the model is saved. This method is called automatically\nbefore `save()` takes any action. If validation fails, the `save()` call\nwill be aborted.\n\nIn your validation method, call the provided `callback` function with no\narguments to indicate success. To indicate failure, pass a single argument,\nwhich may contain an error message, an array of error messages, or any other\nvalue. This value will be passed along to the `error` event.",
      "!url": "http://alloyui.com/classes/Model.html#method_validate"
     },
     "clientId": {
      "!type": "fn()",
      "!doc": "A client-only identifier for this model.\n\nLike the `id` attribute, `clientId` may be used to retrieve model\ninstances from lists. Unlike the `id` attribute, `clientId` is\nautomatically generated, and is only intended to be used on the client\nduring the current pageview.",
      "!url": "http://alloyui.com/classes/Model.html#attribute_clientId"
     },
     "id": {
      "!type": "fn()",
      "!doc": "A unique identifier for this model. Among other things, this id may be\nused to retrieve model instances from lists, so it should be unique.\n\nIf the id is empty, this model instance is assumed to represent a new\nitem that hasn't yet been saved.\n\nIf you would prefer to use a custom attribute as this model's id instead\nof using the `id` attribute (for example, maybe you'd rather use `_id`\nor `uid` as the primary id), you may set the `idAttribute` property to\nthe name of your custom id attribute. The `id` attribute will then\nact as an alias for your custom attribute.",
      "!url": "http://alloyui.com/classes/Model.html#attribute_id"
     }
    }
   },
   "Router": {
    "!type": "fn(config?: yui.Object) -> +app.Router",
    "!proto": "base.Base",
    "!doc": "Provides URL-based routing using HTML5 `pushState()` or the location hash.\n\nThis makes it easy to wire up route handlers for different application states\nwhile providing full back/forward navigation support and bookmarkable, shareable\nURLs.",
    "!url": "http://alloyui.com/classes/Router.html",
    "prototype": {
     "ready": {
      "!type": "fn(dispatched: bool)",
      "!doc": "Fired when the router is ready to begin dispatching to route handlers.\n\nYou shouldn't need to wait for this event unless you plan to implement some\nkind of custom dispatching logic. It's used internally in order to avoid\ndispatching to an initial route if a browser history change occurs first.",
      "!url": "http://alloyui.com/classes/Router.html#event_ready"
     },
     "dispatch": {
      "!type": "fn() -> !this",
      "!doc": "Dispatches to the first route handler that matches the current URL, if any.\n\nIf `dispatch()` is called before the `ready` event has fired, it will\nautomatically wait for the `ready` event before dispatching. Otherwise it\nwill dispatch immediately.",
      "!url": "http://alloyui.com/classes/Router.html#method_dispatch"
     },
     "getPath": {
      "!type": "fn() -> string",
      "!doc": "Gets the current route path.",
      "!url": "http://alloyui.com/classes/Router.html#method_getPath"
     },
     "hasRoute": {
      "!type": "fn(url: string) -> bool",
      "!doc": "Returns `true` if this router has at least one route that matches the\nspecified URL, `false` otherwise.\n\nThis method enforces the same-origin security constraint on the specified\n`url`; any URL which is not from the same origin as the current URL will\nalways return `false`.",
      "!url": "http://alloyui.com/classes/Router.html#method_hasRoute"
     },
     "match": {
      "!type": "fn(path: string) -> [+yui.Object]",
      "!doc": "Returns an array of route objects that match the specified URL path.\n\nIf this router has a `root`, then the specified `path` _must_ be\nsemantically within the `root` path to match any routes.\n\nThis method is called internally to determine which routes match the current\npath whenever the URL changes. You may override it if you want to customize\nthe route matching logic, although this usually shouldn't be necessary.\n\nEach returned route object has the following properties:\n\n  * `callback`: A function or a string representing the name of a function\n    this router that should be executed when the route is triggered.\n\n  * `keys`: An array of strings representing the named parameters defined in\n    the route's path specification, if any.\n\n  * `path`: The route's path specification, which may be either a string or\n    a regex.\n\n  * `regex`: A regular expression version of the route's path specification.\n    This regex is used to determine whether the route matches a given path.",
      "!url": "http://alloyui.com/classes/Router.html#method_match"
     },
     "param": {
      "!type": "fn(name: string, handler: fn()) -> !this",
      "!doc": "Adds a handler for a route param specified by _name_.\n\nParam handlers can be registered via this method and are used to\nvalidate/format values of named params in routes before dispatching to the\nroute's handler functions. Using param handlers allows routes to defined\nusing string paths which allows for `req.params` to use named params, but\nstill applying extra validation or formatting to the param values parsed\nfrom the URL.\n\nIf a param handler regex or function returns a value of `false`, `null`,\n`undefined`, or `NaN`, the current route will not match and be skipped. All\nother return values will be used in place of the original param value parsed\nfrom the URL.",
      "!url": "http://alloyui.com/classes/Router.html#method_param"
     },
     "removeRoot": {
      "!type": "fn(url: string) -> string",
      "!doc": "Removes the `root` URL from the front of _url_ (if it's there) and returns\nthe result. The returned path will always have a leading `/`.",
      "!url": "http://alloyui.com/classes/Router.html#method_removeRoot"
     },
     "removeQuery": {
      "!type": "fn(url: string) -> string",
      "!doc": "Removes a query string from the end of the _url_ (if one exists) and returns\nthe result.",
      "!url": "http://alloyui.com/classes/Router.html#method_removeQuery"
     },
     "replace": {
      "!type": "fn(url?: string) -> !this",
      "!doc": "Replaces the current browser history entry with a new one, and dispatches to\nthe first matching route handler, if any.\n\nBehind the scenes, this method uses HTML5 `pushState()` in browsers that\nsupport it (or the location hash in older browsers and IE) to change the\nURL.\n\nThe specified URL must share the same origin (i.e., protocol, host, and\nport) as the current page, or an error will occur.",
      "!url": "http://alloyui.com/classes/Router.html#method_replace"
     },
     "route": {
      "!type": "fn(route: string, callbacks: yui.Array) -> !this",
      "!doc": "Adds a route handler for the specified `route`.\n\nThe `route` parameter may be a string or regular expression to represent a\nURL path, or a route object. If it's a string (which is most common), it may\ncontain named parameters: `:param` will match any single part of a URL path\n(not including `/` characters), and `*param` will match any number of parts\nof a URL path (including `/` characters). These named parameters will be\nmade available as keys on the `req.params` object that's passed to route\nhandlers.\n\nIf the `route` parameter is a regex, all pattern matches will be made\navailable as numbered keys on `req.params`, starting with `0` for the full\nmatch, then `1` for the first subpattern match, and so on.\n\nAlternatively, an object can be provided to represent the route and it may\ncontain a `path` property which is a string or regular expression which\ncauses the route to be process as described above. If the route object\nalready contains a `regex` or `regexp` property, the route will be\nconsidered fully-processed and will be associated with any `callacks`\nspecified on the object and those specified as parameters to this method.\n**Note:** Any additional data contained on the route object will be\npreserved.\n\nHere's a set of sample routes along with URL paths that they match:\n\n  * Route: `/photos/:tag/:page`\n    * URL: `/photos/kittens/1`, params: `{tag: 'kittens', page: '1'}`\n    * URL: `/photos/puppies/2`, params: `{tag: 'puppies', page: '2'}`\n\n  * Route: `/file/*path`\n    * URL: `/file/foo/bar/baz.txt`, params: `{path: 'foo/bar/baz.txt'}`\n    * URL: `/file/foo`, params: `{path: 'foo'}`\n\n**Middleware**: Routes also support an arbitrary number of callback\nfunctions. This allows you to easily reuse parts of your route-handling code\nwith different route. This method is liberal in how it processes the\nspecified `callbacks`, you can specify them as separate arguments, or as\narrays, or both.\n\nIf multiple route match a given URL, they will be executed in the order they\nwere added. The first route that was added will be the first to be executed.\n\n**Passing Control**: Invoking the `next()` function within a route callback\nwill pass control to the next callback function (if any) or route handler\n(if any). If a value is passed to `next()`, it's assumed to be an error,\ntherefore stopping the dispatch chain, unless that value is: `\"route\"`,\nwhich is special case and dispatching will skip to the next route handler.\nThis allows middleware to skip any remaining middleware for a particular\nroute.",
      "!url": "http://alloyui.com/classes/Router.html#method_route"
     },
     "save": {
      "!type": "fn(url?: string) -> !this",
      "!doc": "Saves a new browser history entry and dispatches to the first matching route\nhandler, if any.\n\nBehind the scenes, this method uses HTML5 `pushState()` in browsers that\nsupport it (or the location hash in older browsers and IE) to change the\nURL and create a history entry.\n\nThe specified URL must share the same origin (i.e., protocol, host, and\nport) as the current page, or an error will occur.",
      "!url": "http://alloyui.com/classes/Router.html#method_save"
     },
     "upgrade": {
      "!type": "fn() -> bool",
      "!doc": "Upgrades a hash-based URL to an HTML5 URL if necessary. In non-HTML5\nbrowsers, this method is a noop.",
      "!url": "http://alloyui.com/classes/Router.html#method_upgrade"
     },
     "html5": {
      "!type": "fn()",
      "!doc": "Whether or not this browser is capable of using HTML5 history.\n\nSetting this to `false` will force the use of hash-based history even on\nHTML5 browsers, but please don't do this unless you understand the\nconsequences.",
      "!url": "http://alloyui.com/classes/Router.html#attribute_html5"
     },
     "params": {
      "!type": "fn()",
      "!doc": "Map of params handlers in the form: `name` -> RegExp | Function.\n\nIf a param handler regex or function returns a value of `false`, `null`,\n`undefined`, or `NaN`, the current route will not match and be skipped.\nAll other return values will be used in place of the original param\nvalue parsed from the URL.\n\nThis attribute is intended to be used to set params at init time, or to\ncompletely reset all params after init. To add params after init without\nresetting all existing params, use the `param()` method.",
      "!url": "http://alloyui.com/classes/Router.html#attribute_params"
     },
     "root": {
      "!type": "fn()",
      "!doc": "Absolute root path from which all routes should be evaluated.\n\nFor example, if your router is running on a page at\n`http://example.com/myapp/` and you add a route with the path `/`, your\nroute will never execute, because the path will always be preceded by\n`/myapp`. Setting `root` to `/myapp` would cause all routes to be\nevaluated relative to that root URL, so the `/` route would then execute\nwhen the user browses to `http://example.com/myapp/`.",
      "!url": "http://alloyui.com/classes/Router.html#attribute_root"
     },
     "routes": {
      "!type": "fn()",
      "!doc": "Array of route objects.\n\nEach item in the array must be an object with the following properties\nin order to be processed by the router:\n\n  * `path`: String or regex representing the path to match. See the docs\n    for the `route()` method for more details.\n\n  * `callbacks`: Function or a string representing the name of a\n    function on this router instance that should be called when the\n    route is triggered. An array of functions and/or strings may also be\n    provided. See the docs for the `route()` method for more details.\n\nIf a route object contains a `regex` or `regexp` property, or if its\n`path` is a regular express, then the route will be considered to be\nfully-processed. Any fully-processed routes may contain the following\nproperties:\n\n  * `regex`: The regular expression representing the path to match, this\n    property may also be named `regexp` for greater compatibility.\n\n  * `keys`: Array of named path parameters used to populate `req.params`\n    objects when dispatching to route handlers.\n\nAny additional data contained on these route objects will be retained.\nThis is useful to store extra metadata about a route; e.g., a `name` to\ngive routes logical names.\n\nThis attribute is intended to be used to set routes at init time, or to\ncompletely reset all routes after init. To add routes after init without\nresetting all existing routes, use the `route()` method.",
      "!url": "http://alloyui.com/classes/Router.html#attribute_routes"
     }
    },
    "dispatch": {
     "!type": "fn()",
     "!doc": "Dispatches to the first route handler that matches the specified `path` for\nall active router instances.\n\nThis provides a mechanism to cause all active router instances to dispatch\nto their route handlers without needing to change the URL or fire the\n`history:change` or `hashchange` event.",
     "!url": "http://alloyui.com/classes/Router.html#method_dispatch"
    }
   },
   "View": {
    "!type": "fn() -> +app.View",
    "!proto": "base.Base",
    "!doc": "Represents a logical piece of an application's user interface, and provides a\nlightweight, overridable API for rendering content and handling delegated DOM\nevents on a container element.\n\nThe View class imposes little structure and provides only minimal functionality\nof its own: it's basically just an overridable API interface that helps you\nimplement custom views.\n\nAs of YUI 3.5.0, View allows ad-hoc attributes to be specified at instantiation\ntime, so you don't need to subclass `Y.View` to add custom attributes. Just pass\nthem to the constructor:\n\n    var view = new Y.View({foo: 'bar'});\n    view.get('foo'); // => \"bar\"",
    "!url": "http://alloyui.com/classes/View.html",
    "prototype": {
     "containerTemplate": {
      "!type": "string",
      "!doc": "Template for this view's container.",
      "!url": "http://alloyui.com/classes/View.html#property_containerTemplate"
     },
     "events": {
      "!type": "+yui.Object",
      "!doc": "Hash of CSS selectors mapped to events to delegate to elements matching\nthose selectors.\n\nCSS selectors are relative to the `container` element. Events are attached\nto the container, and delegation is used so that subscribers are only\nnotified of events that occur on elements inside the container that match\nthe specified selectors. This allows the container's contents to be re-\nrendered as needed without losing event subscriptions.\n\nEvent handlers can be specified either as functions or as strings that map\nto function names on this view instance or its prototype.\n\nThe `this` object in event handlers will refer to this view instance. If\nyou'd prefer `this` to be something else, use `Y.bind()` to bind a custom\n`this` object.",
      "!url": "http://alloyui.com/classes/View.html#property_events"
     },
     "template": {
      "!type": "+mixed",
      "!doc": "Template for this view's contents.\n\nThis is a convenience property that has no default behavior of its own.\nIt's only provided as a convention to allow you to store whatever you\nconsider to be a template, whether that's an HTML string, a `Y.Node`\ninstance, a Mustache template, or anything else your little heart\ndesires.\n\nHow this template gets used is entirely up to you and your custom\n`render()` method.",
      "!url": "http://alloyui.com/classes/View.html#property_template"
     },
     "destroy": {
      "!type": "fn(options?: yui.Object) -> !this",
      "!doc": "Destroys this View, detaching any DOM events and optionally also destroying\nits container node.\n\nBy default, the container node will not be destroyed. Pass an _options_\nobject with a truthy `remove` property to destroy the container as well.",
      "!url": "http://alloyui.com/classes/View.html#method_destroy"
     },
     "attachEvents": {
      "!type": "fn(events?: yui.Object) -> !this",
      "!doc": "Attaches delegated event handlers to this view's container element. This\nmethod is called internally to subscribe to events configured in the\n`events` attribute when the view is initialized.\n\nYou may override this method to customize the event attaching logic.",
      "!url": "http://alloyui.com/classes/View.html#method_attachEvents"
     },
     "create": {
      "!type": "fn(container?: HTMLElement) -> +node.Node",
      "!doc": "Creates and returns a container node for this view.\n\nBy default, the container is created from the HTML template specified in the\n`containerTemplate` property, and is _not_ added to the DOM automatically.\n\nYou may override this method to customize how the container node is created\n(such as by rendering it from a custom template format). Your method must\nreturn a `Y.Node` instance.",
      "!url": "http://alloyui.com/classes/View.html#method_create"
     },
     "detachEvents": {
      "!type": "fn() -> !this",
      "!doc": "Detaches DOM events that have previously been attached to the container by\n`attachEvents()`.",
      "!url": "http://alloyui.com/classes/View.html#method_detachEvents"
     },
     "remove": {
      "!type": "fn() -> !this",
      "!doc": "Removes this view's container element from the DOM (if it's in the DOM),\nbut doesn't destroy it or any event listeners attached to it.",
      "!url": "http://alloyui.com/classes/View.html#method_remove"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Renders this view.\n\nThis method is a noop by default. Override it to provide a custom\nimplementation that renders this view's content and appends it to the\ncontainer element. Ideally your `render` method should also return `this` as\nthe end to allow chaining, but that's up to you.\n\nSince there's no default renderer, you're free to render your view however\nyou see fit, whether that means manipulating the DOM directly, dumping\nstrings into `innerHTML`, or using a template language of some kind.\n\nFor basic templating needs, `Y.Node.create()` and `Y.Lang.sub()` may\nsuffice, but there are no restrictions on what tools or techniques you can\nuse to render your view. All you need to do is append something to the\ncontainer element at some point, and optionally append the container\nto the DOM if it's not there already.",
      "!url": "http://alloyui.com/classes/View.html#method_render"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Container node into which this view's content will be rendered.\n\nThe container node serves as the host for all DOM events attached by the\nview. Delegation is used to handle events on children of the container,\nallowing the container's contents to be re-rendered at any time without\nlosing event subscriptions.\n\nThe default container is a `<div>` Node, but you can override this in\na subclass, or by passing in a custom `container` config value at\ninstantiation time. If you override the default container in a subclass\nusing `ATTRS`, you must use the `valueFn` property. The view's constructor\nwill ignore any assignments using `value`.\n\nWhen `container` is overridden by a subclass or passed as a config\noption at instantiation time, you can provide it as a selector string, a\nDOM element, a `Y.Node` instance, or (if you are subclassing and modifying\nthe attribute), a `valueFn` function that returns a `Y.Node` instance.\nThe value will be converted into a `Y.Node` instance if it isn't one\nalready.\n\nThe container is not added to the page automatically. This allows you to\nhave full control over how and when your view is actually rendered to\nthe page.",
      "!url": "http://alloyui.com/classes/View.html#attribute_container"
     }
    }
   }
  },
  "arraysort": {
   "ArraySort": {
    "!type": "fn()",
    "!doc": "Provides comparator functions useful for sorting arrays.",
    "!url": "http://alloyui.com/classes/ArraySort.html",
    "compare": {
     "!type": "fn(a: yui.Object, b: yui.Object, desc: bool) -> bool",
     "!doc": "Comparator function for simple case-insensitive sorting of an array of\nstrings.",
     "!url": "http://alloyui.com/classes/ArraySort.html#method_compare"
    },
    "naturalCompare": {
     "!type": "fn(a: number, b: number, options?: yui.Object) -> number",
     "!doc": "Performs a natural-order comparison of two strings or numbers (or a string\nand a number). This ensures that a value like 'foo2' will be sorted before\n'foo10', whereas a standard ASCII sort would sort 'foo10' first.",
     "!url": "http://alloyui.com/classes/ArraySort.html#method_naturalCompare"
    }
   }
  },
  "async_queue": {
   "AsyncQueue": {
    "!type": "fn(callback: fn()) -> +async_queue.AsyncQueue",
    "!proto": "event_custom.EventTarget",
    "!doc": "<p>A specialized queue class that supports scheduling callbacks to execute\nsequentially, iteratively, even asynchronously.</p>\n\n<p>Callbacks can be function refs or objects with the following keys.  Only\nthe <code>fn</code> key is required.</p>\n\n<ul>\n<li><code>fn</code> -- The callback function</li>\n<li><code>context</code> -- The execution context for the callbackFn.</li>\n<li><code>args</code> -- Arguments to pass to callbackFn.</li>\n<li><code>timeout</code> -- Millisecond delay before executing callbackFn.\n                    (Applies to each iterative execution of callback)</li>\n<li><code>iterations</code> -- Number of times to repeat the callback.\n<li><code>until</code> -- Repeat the callback until this function returns\n                        true.  This setting trumps iterations.</li>\n<li><code>autoContinue</code> -- Set to false to prevent the AsyncQueue from\n                       executing the next callback in the Queue after\n                       the callback completes.</li>\n<li><code>id</code> -- Name that can be used to get, promote, get the\n                       indexOf, or delete this callback.</li>\n</ul>",
    "!url": "http://alloyui.com/classes/AsyncQueue.html",
    "defaults": {
     "!type": "+yui.Object",
     "!doc": "<p>Static default values used to populate callback configuration properties.\nPreconfigured defaults include:</p>\n\n<ul>\n <li><code>autoContinue</code>: <code>true</code></li>\n <li><code>iterations</code>: 1</li>\n <li><code>timeout</code>: 10 (10ms between callbacks)</li>\n <li><code>until</code>: (function to run until iterations &lt;= 0)</li>\n</ul>",
     "!url": "http://alloyui.com/classes/AsyncQueue.html#property_defaults"
    },
    "prototype": {
     "defaults": {
      "!type": "+yui.Object",
      "!doc": "Callback defaults for this instance.  Static defaults that are not\noverridden are also included.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#property_defaults"
     },
     "next": {
      "!type": "fn() -> fn()",
      "!doc": "Returns the next callback needing execution.  If a callback is\nconfigured to repeat via iterations or until, it will be returned until\nthe completion criteria is met.\n\nWhen the queue is empty, null is returned.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_next"
     },
     "run": {
      "!type": "fn() -> !this",
      "!doc": "Sets the queue in motion.  All queued callbacks will be executed in\norder unless pause() or stop() is called or if one of the callbacks is\nconfigured with autoContinue: false.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_run"
     },
     "complete": {
      "!type": "fn()",
      "!doc": "Event fired when there is no remaining callback in the running queue. Also fired after stop().",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#event_complete"
     },
     "isRunning": {
      "!type": "fn() -> bool",
      "!doc": "Determines if the queue is waiting for a callback to complete execution.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_isRunning"
     },
     "add": {
      "!type": "fn(callback: fn()) -> !this",
      "!doc": "Add any number of callbacks to the end of the queue. Callbacks may be\nprovided as functions or objects.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_add"
     },
     "pause": {
      "!type": "fn() -> !this",
      "!doc": "Pause the execution of the queue after the execution of the current\ncallback completes.  If called from code outside of a queued callback,\nclears the timeout for the pending callback. Paused queue can be\nrestarted with q.run()",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_pause"
     },
     "stop": {
      "!type": "fn() -> !this",
      "!doc": "Stop and clear the queue after the current execution of the\ncurrent callback completes.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_stop"
     },
     "indexOf": {
      "!type": "fn(callback: string) -> number",
      "!doc": "Returns the current index of a callback.  Pass in either the id or\ncallback function from getCallback.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_indexOf"
     },
     "getCallback": {
      "!type": "fn(id: string) -> +yui.Object",
      "!doc": "Retrieve a callback by its id.  Useful to modify the configuration\nwhile the queue is running.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_getCallback"
     },
     "promote": {
      "!type": "fn(callback: string) -> !this",
      "!doc": "Promotes the named callback to the top of the queue. If a callback is\ncurrently executing or looping (via until or iterations), the promotion\nis scheduled to occur after the current callback has completed.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_promote"
     },
     "remove": {
      "!type": "fn(callback: string) -> !this",
      "!doc": "Removes the callback from the queue.  If the queue is active, the\nremoval is scheduled to occur after the current callback has completed.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_remove"
     },
     "size": {
      "!type": "fn() -> number",
      "!doc": "Returns the number of callbacks in the queue.",
      "!url": "http://alloyui.com/classes/AsyncQueue.html#method_size"
     }
    }
   }
  },
  "attribute": {
   "Attribute": {
    "!type": "fn(attrs: yui.Object, values: yui.Object, lazy: bool)",
    "!doc": "<p>\nAttribute provides configurable attribute support along with attribute change events. It is designed to be\naugmented on to a host class, and provides the host with the ability to configure attributes to store and retrieve state,\nalong with attribute change events.\n</p>\n<p>For example, attributes added to the host can be configured:</p>\n<ul>\n    <li>As read only.</li>\n    <li>As write once.</li>\n    <li>With a setter function, which can be used to manipulate\n    values passed to Attribute's <a href=\"#method_set\">set</a> method, before they are stored.</li>\n    <li>With a getter function, which can be used to manipulate stored values,\n    before they are returned by Attribute's <a href=\"#method_get\">get</a> method.</li>\n    <li>With a validator function, to validate values before they are stored.</li>\n</ul>\n\n<p>See the <a href=\"#method_addAttr\">addAttr</a> method, for the complete set of configuration\noptions available for attributes.</p>\n\n<p><strong>NOTE:</strong> Most implementations will be better off extending the <a href=\"Base.html\">Base</a> class,\ninstead of augmenting Attribute directly. Base augments Attribute and will handle the initial configuration\nof attributes for derived classes, accounting for values passed into the constructor.</p>",
    "!url": "http://alloyui.com/classes/Attribute.html",
    "INVALID_VALUE": {
     "!type": "+yui.Object",
     "!doc": "<p>The value to return from an attribute setter in order to prevent the set from going through.</p>\n\n<p>You can return this value from your setter if you wish to combine validator and setter\nfunctionality into a single setter function, which either returns the massaged value to be stored or\nAttributeCore.INVALID_VALUE to prevent invalid values from being stored.</p>",
     "!url": "http://alloyui.com/classes/Attribute.html#property_INVALID_VALUE"
    },
    "protectAttrs": {
     "!type": "fn(attrs: yui.Object) -> +yui.Object",
     "!doc": "Utility method to protect an attribute configuration hash, by merging the\nentire object and the individual attr config objects.",
     "!url": "http://alloyui.com/classes/Attribute.html#method_protectAttrs"
    }
   },
   "AttributeCore": {
    "!type": "fn(attrs: yui.Object, values: yui.Object, lazy: bool)",
    "!doc": "<p>\nAttributeCore provides the lightest level of configurable attribute support. It is designed to be\naugmented on to a host class, and provides the host with the ability to configure\nattributes to store and retrieve state, <strong>but without support for attribute change events</strong>.\n</p>\n<p>For example, attributes added to the host can be configured:</p>\n<ul>\n    <li>As read only.</li>\n    <li>As write once.</li>\n    <li>With a setter function, which can be used to manipulate\n    values passed to Attribute's <a href=\"#method_set\">set</a> method, before they are stored.</li>\n    <li>With a getter function, which can be used to manipulate stored values,\n    before they are returned by Attribute's <a href=\"#method_get\">get</a> method.</li>\n    <li>With a validator function, to validate values before they are stored.</li>\n</ul>\n\n<p>See the <a href=\"#method_addAttr\">addAttr</a> method, for the complete set of configuration\noptions available for attributes.</p>\n\n<p>Object/Classes based on AttributeCore can augment <a href=\"AttributeObservable.html\">AttributeObservable</a>\n(with true for overwrite) and <a href=\"AttributeExtras.html\">AttributeExtras</a> to add attribute event and\nadditional, less commonly used attribute methods, such as `modifyAttr`, `removeAttr` and `reset`.</p>",
    "!url": "http://alloyui.com/classes/AttributeCore.html",
    "INVALID_VALUE": {
     "!type": "+yui.Object",
     "!doc": "<p>The value to return from an attribute setter in order to prevent the set from going through.</p>\n\n<p>You can return this value from your setter if you wish to combine validator and setter\nfunctionality into a single setter function, which either returns the massaged value to be stored or\nAttributeCore.INVALID_VALUE to prevent invalid values from being stored.</p>",
     "!url": "http://alloyui.com/classes/AttributeCore.html#property_INVALID_VALUE"
    },
    "protectAttrs": {
     "!type": "fn(attrs: yui.Object) -> +yui.Object",
     "!doc": "Utility method to protect an attribute configuration hash, by merging the\nentire object and the individual attr config objects.",
     "!url": "http://alloyui.com/classes/AttributeCore.html#method_protectAttrs"
    },
    "prototype": {
     "addAttr": {
      "!type": "fn(name: string, config: yui.Object, lazy: bool) -> !this",
      "!doc": "<p>\nAdds an attribute with the provided configuration to the host object.\n</p>\n<p>\nThe config argument object supports the following properties:\n</p>\n\n<dl>\n   <dt>value &#60;Any&#62;</dt>\n   <dd>The initial value to set on the attribute</dd>\n\n   <dt>valueFn &#60;Function | String&#62;</dt>\n   <dd>\n   <p>A function, which will return the initial value to set on the attribute. This is useful\n   for cases where the attribute configuration is defined statically, but needs to\n   reference the host instance (\"this\") to obtain an initial value. If both the value and valueFn properties are defined,\n   the value returned by the valueFn has precedence over the value property, unless it returns undefined, in which\n   case the value property is used.</p>\n\n   <p>valueFn can also be set to a string, representing the name of the instance method to be used to retrieve the value.</p>\n   </dd>\n\n   <dt>readOnly &#60;boolean&#62;</dt>\n   <dd>Whether or not the attribute is read only. Attributes having readOnly set to true\n       cannot be modified by invoking the set method.</dd>\n\n   <dt>writeOnce &#60;boolean&#62; or &#60;string&#62;</dt>\n   <dd>\n       Whether or not the attribute is \"write once\". Attributes having writeOnce set to true,\n       can only have their values set once, be it through the default configuration,\n       constructor configuration arguments, or by invoking set.\n       <p>The writeOnce attribute can also be set to the string \"initOnly\",\n        in which case the attribute can only be set during initialization\n       (when used with Base, this means it can only be set during construction)</p>\n   </dd>\n\n   <dt>setter &#60;Function | String&#62;</dt>\n   <dd>\n   <p>The setter function used to massage or normalize the value passed to the set method for the attribute.\n   The value returned by the setter will be the final stored value. Returning\n   <a href=\"#property_Attribute.INVALID_VALUE\">Attribute.INVALID_VALUE</a>, from the setter will prevent\n   the value from being stored.\n   </p>\n\n   <p>setter can also be set to a string, representing the name of the instance method to be used as the setter function.</p>\n   </dd>\n\n   <dt>getter &#60;Function | String&#62;</dt>\n   <dd>\n   <p>\n   The getter function used to massage or normalize the value returned by the get method for the attribute.\n   The value returned by the getter function is the value which will be returned to the user when they\n   invoke get.\n   </p>\n\n   <p>getter can also be set to a string, representing the name of the instance method to be used as the getter function.</p>\n   </dd>\n\n   <dt>validator &#60;Function | String&#62;</dt>\n   <dd>\n   <p>\n   The validator function invoked prior to setting the stored value. Returning\n   false from the validator function will prevent the value from being stored.\n   </p>\n\n   <p>validator can also be set to a string, representing the name of the instance method to be used as the validator function.</p>\n   </dd>\n\n   <dt>lazyAdd &#60;boolean&#62;</dt>\n   <dd>Whether or not to delay initialization of the attribute until the first call to get/set it.\n   This flag can be used to over-ride lazy initialization on a per attribute basis, when adding multiple attributes through\n   the <a href=\"#method_addAttrs\">addAttrs</a> method.</dd>\n\n</dl>\n\n<p>The setter, getter and validator are invoked with the value and name passed in as the first and second arguments, and with\nthe context (\"this\") set to the host object.</p>\n\n<p>Configuration properties outside of the list mentioned above are considered private properties used internally by attribute,\nand are not intended for public use.</p>",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_addAttr"
     },
     "attrAdded": {
      "!type": "fn(name: string) -> bool",
      "!doc": "Checks if the given attribute has been added to the host",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_attrAdded"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "Returns the current value of the attribute. If the attribute\nhas been configured with a 'getter' function, this method will delegate\nto the 'getter' to obtain the value of the attribute.",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_get"
     },
     "set": {
      "!type": "fn(name: string, value: Any, opts?: yui.Object) -> !this",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attrs: yui.Object, opts?: yui.Object) -> !this",
      "!doc": "Sets multiple attribute values.",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_setAttrs"
     },
     "getAttrs": {
      "!type": "fn(attrs: [string]) -> +yui.Object",
      "!doc": "Gets multiple attribute values.",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_getAttrs"
     },
     "addAttrs": {
      "!type": "fn(cfgs: yui.Object, values: yui.Object, lazy: bool) -> !this",
      "!doc": "Configures a group of attributes, and sets initial values.\n\n<p>\n<strong>NOTE:</strong> This method does not isolate the configuration object by merging/cloning.\nThe caller is responsible for merging/cloning the configuration object if required.\n</p>",
      "!url": "http://alloyui.com/classes/AttributeCore.html#method_addAttrs"
     }
    }
   },
   "AttributeExtras": {
    "!type": "fn()",
    "!doc": "A augmentable implementation for AttributeCore, providing less frequently used\nmethods for Attribute management such as modifyAttrs(), removeAttr and reset()",
    "!url": "http://alloyui.com/classes/AttributeExtras.html",
    "prototype": {
     "modifyAttr": {
      "!type": "fn(name: string, config: yui.Object)",
      "!doc": "Updates the configuration of an attribute which has already been added.\n<p>\nThe properties which can be modified through this interface are limited\nto the following subset of attributes, which can be safely modified\nafter a value has already been set on the attribute: readOnly, writeOnce,\nbroadcast and getter.\n</p>",
      "!url": "http://alloyui.com/classes/AttributeExtras.html#method_modifyAttr"
     },
     "removeAttr": {
      "!type": "fn(name: string)",
      "!doc": "Removes an attribute from the host object",
      "!url": "http://alloyui.com/classes/AttributeExtras.html#method_removeAttr"
     },
     "reset": {
      "!type": "fn(name: string) -> !this",
      "!doc": "Resets the attribute (or all attributes) to its initial value, as long as\nthe attribute is not readOnly, or writeOnce.",
      "!url": "http://alloyui.com/classes/AttributeExtras.html#method_reset"
     }
    }
   },
   "AttributeObservable": {
    "!type": "fn()",
    "!doc": "Provides an augmentable implementation of attribute change events for\nAttributeCore.",
    "!url": "http://alloyui.com/classes/AttributeObservable.html",
    "prototype": {
     "set": {
      "!type": "fn(name: string, value: Any, opts: yui.Object) -> !this",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://alloyui.com/classes/AttributeObservable.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attrs: yui.Object, opts: yui.Object) -> !this",
      "!doc": "Sets multiple attribute values.",
      "!url": "http://alloyui.com/classes/AttributeObservable.html#method_setAttrs"
     }
    }
   },
   "State": {
    "!type": "fn() -> +attribute.State",
    "!doc": "The State class maintains state for a collection of named items, with\na varying number of properties defined.\n\nIt avoids the need to create a separate class for the item, and separate instances\nof these classes for each item, by storing the state in a 2 level hash table,\nimproving performance when the number of items is likely to be large.",
    "!url": "http://alloyui.com/classes/State.html",
    "prototype": {
     "data": {
      "!type": "?",
      "!doc": "Hash of attributes",
      "!url": "http://alloyui.com/classes/State.html#property_data"
     },
     "add": {
      "!type": "fn(name: string, key: string, val: Any)",
      "!doc": "Adds a property to an item.",
      "!url": "http://alloyui.com/classes/State.html#method_add"
     },
     "addAll": {
      "!type": "fn(name: string, obj: yui.Object)",
      "!doc": "Adds multiple properties to an item.",
      "!url": "http://alloyui.com/classes/State.html#method_addAll"
     },
     "remove": {
      "!type": "fn(name: string, key: string)",
      "!doc": "Removes a property from an item.",
      "!url": "http://alloyui.com/classes/State.html#method_remove"
     },
     "removeAll": {
      "!type": "fn(name: string, obj: yui.Object)",
      "!doc": "Removes multiple properties from an item, or removes the item completely.",
      "!url": "http://alloyui.com/classes/State.html#method_removeAll"
     },
     "get": {
      "!type": "fn(name: string, key: string) -> +Any",
      "!doc": "For a given item, returns the value of the property requested, or undefined if not found.",
      "!url": "http://alloyui.com/classes/State.html#method_get"
     },
     "getAll": {
      "!type": "fn(name: string, reference: bool) -> +yui.Object",
      "!doc": "For the given item, returns an object with all of the\nitem's property/value pairs. By default the object returned\nis a shallow copy of the stored data, but passing in true\nas the second parameter will return a reference to the stored\ndata.",
      "!url": "http://alloyui.com/classes/State.html#method_getAll"
     }
    }
   }
  },
  "autocomplete": {
   "AutoCompleteBase": {
    "!type": "fn()",
    "!doc": "Extension that provides core autocomplete logic (but no UI implementation) for a\ntext input field or textarea.\n\nThe `AutoCompleteBase` class provides events and attributes that abstract away\ncore autocomplete logic and configuration, but does not provide a widget\nimplementation or suggestion UI. For a prepackaged autocomplete widget, see\n`AutoCompleteList`.\n\nThis extension cannot be instantiated directly, since it doesn't provide an\nactual implementation. It's intended to be mixed into a `Y.Base`-based class or\nwidget.\n\n`Y.Widget`-based example:\n\n    YUI().use('autocomplete-base', 'widget', function (Y) {\n        var MyAC = Y.Base.create('myAC', Y.Widget, [Y.AutoCompleteBase], {\n            // Custom prototype methods and properties.\n        }, {\n            // Custom static methods and properties.\n        });\n\n        // Custom implementation code.\n    });\n\n`Y.Base`-based example:\n\n    YUI().use('autocomplete-base', function (Y) {\n        var MyAC = Y.Base.create('myAC', Y.Base, [Y.AutoCompleteBase], {\n            initializer: function () {\n                this._bindUIACBase();\n                this._syncUIACBase();\n            },\n\n            // Custom prototype methods and properties.\n        }, {\n            // Custom static methods and properties.\n        });\n\n        // Custom implementation code.\n    });",
    "!url": "http://alloyui.com/classes/AutoCompleteBase.html",
    "prototype": {
     "clear": {
      "!type": "fn(prevVal: string, src: string)",
      "!doc": "Fires after the query has been completely cleared or no longer meets the\nminimum query length requirement.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#event_clear"
     },
     "query": {
      "!type": "fn()",
      "!doc": "Current query, or `null` if there is no current query.\n\nThe query might not be the same as the current value of the input node, both\nfor timing reasons (due to `queryDelay`) and because when one or more\n`queryDelimiter` separators are in use, only the last portion of the\ndelimited input string will be used as the query value.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_query"
     },
     "results": {
      "!type": "fn()",
      "!doc": "Current results, or an empty array if there are no results.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_results"
     },
     "clearCache": {
      "!type": "fn() -> !this",
      "!doc": "Clears the result cache.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#method_clearCache"
     },
     "sendRequest": {
      "!type": "fn(query?: string, requestTemplate?: fn()) -> !this",
      "!doc": "Sends a request to the configured source. If no source is configured, this\nmethod won't do anything.\n\nUsually there's no reason to call this method manually; it will be called\nautomatically when user input causes a `query` event to be fired. The only\ntime you'll need to call this method manually is if you want to force a\nrequest to be sent when no user input has occurred.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#method_sendRequest"
     },
     "allowBrowserAutocomplete": {
      "!type": "fn()",
      "!doc": "Whether or not to enable the browser's built-in autocomplete functionality\nfor input fields.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_allowBrowserAutocomplete"
     },
     "allowTrailingDelimiter": {
      "!type": "fn()",
      "!doc": "When a `queryDelimiter` is set, trailing delimiters will automatically be\nstripped from the input value by default when the input node loses focus.\nSet this to `true` to allow trailing delimiters.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_allowTrailingDelimiter"
     },
     "enableCache": {
      "!type": "fn()",
      "!doc": "Whether or not to enable in-memory caching in result sources that support\nit.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_enableCache"
     },
     "inputNode": {
      "!type": "fn()",
      "!doc": "Node to monitor for changes, which will generate `query` events when\nappropriate. May be either an `<input>` or a `<textarea>`.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_inputNode"
     },
     "maxResults": {
      "!type": "fn()",
      "!doc": "Maximum number of results to return. A value of `0` or less will allow an\nunlimited number of results.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_maxResults"
     },
     "minQueryLength": {
      "!type": "fn()",
      "!doc": "Minimum number of characters that must be entered before a `query` event\nwill be fired. A value of `0` allows empty queries; a negative value will\neffectively disable all `query` events.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_minQueryLength"
     },
     "queryDelay": {
      "!type": "fn()",
      "!doc": "Number of milliseconds to delay after input before triggering a `query`\nevent. If new input occurs before this delay is over, the previous input\nevent will be ignored and a new delay will begin.\n\nThis can be useful both to throttle queries to a remote data source and to\navoid distracting the user by showing them less relevant results before\nthey've paused their typing.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_queryDelay"
     },
     "queryDelimiter": {
      "!type": "fn()",
      "!doc": "Query delimiter string. When a delimiter is configured, the input value\nwill be split on the delimiter, and only the last portion will be used in\nautocomplete queries and updated when the `query` attribute is\nmodified.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_queryDelimiter"
     },
     "requestTemplate": {
      "!type": "fn()",
      "!doc": "Source request template. This can be a function that accepts a query as a\nparameter and returns a request string, or it can be a string containing the\nplaceholder \"{query}\", which will be replaced with the actual URI-encoded\nquery. In either case, the resulting string will be appended to the request\nURL when the `source` attribute is set to a remote DataSource, JSONP URL, or\nXHR URL (it will not be appended to YQL URLs).\n\nWhile `requestTemplate` may be set to either a function or a string, it will\nalways be returned as a function that accepts a query argument and returns a\nstring.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_requestTemplate"
     },
     "resultFilters": {
      "!type": "fn()",
      "!doc": "Array of local result filter functions. If provided, each filter will be\ncalled with two arguments when results are received: the query and an array\nof result objects. See the documentation for the `results` event for a list\nof the properties available on each result object.\n\nEach filter is expected to return a filtered or modified version of the\nresults array, which will then be passed on to subsequent filters, then the\n`resultHighlighter` function (if set), then the `resultFormatter` function\n(if set), and finally to subscribers to the `results` event.\n\nIf no `source` is set, result filters will not be called.\n\nPrepackaged result filters provided by the autocomplete-filters and\nautocomplete-filters-accentfold modules can be used by specifying the filter\nname as a string, such as `'phraseMatch'` (assuming the necessary filters\nmodule is loaded).",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_resultFilters"
     },
     "resultFormatter": {
      "!type": "fn()",
      "!doc": "Function which will be used to format results. If provided, this function\nwill be called with two arguments after results have been received and\nfiltered: the query and an array of result objects. The formatter is\nexpected to return an array of HTML strings or Node instances containing the\ndesired HTML for each result.\n\nSee the documentation for the `results` event for a list of the properties\navailable on each result object.\n\nIf no `source` is set, the formatter will not be called.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_resultFormatter"
     },
     "resultHighlighter": {
      "!type": "fn()",
      "!doc": "Function which will be used to highlight results. If provided, this function\nwill be called with two arguments after results have been received and\nfiltered: the query and an array of filtered result objects. The highlighter\nis expected to return an array of highlighted result text in the form of\nHTML strings.\n\nSee the documentation for the `results` event for a list of the properties\navailable on each result object.\n\nIf no `source` is set, the highlighter will not be called.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_resultHighlighter"
     },
     "resultListLocator": {
      "!type": "fn()",
      "!doc": "Locator that should be used to extract an array of results from a non-array\nresponse.\n\nBy default, no locator is applied, and all responses are assumed to be\narrays by default. If all responses are already arrays, you don't need to\ndefine a locator.\n\nThe locator may be either a function (which will receive the raw response as\nan argument and must return an array) or a string representing an object\npath, such as \"foo.bar.baz\" (which would return the value of\n`result.foo.bar.baz` if the response is an object).\n\nWhile `resultListLocator` may be set to either a function or a string, it\nwill always be returned as a function that accepts a response argument and\nreturns an array.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_resultListLocator"
     },
     "resultTextLocator": {
      "!type": "fn()",
      "!doc": "Locator that should be used to extract a plain text string from a non-string\nresult item. The resulting text value will typically be the value that ends\nup being inserted into an input field or textarea when the user of an\nautocomplete implementation selects a result.\n\nBy default, no locator is applied, and all results are assumed to be plain\ntext strings. If all results are already plain text strings, you don't need\nto define a locator.\n\nThe locator may be either a function (which will receive the raw result as\nan argument and must return a string) or a string representing an object\npath, such as \"foo.bar.baz\" (which would return the value of\n`result.foo.bar.baz` if the result is an object).\n\nWhile `resultTextLocator` may be set to either a function or a string, it\nwill always be returned as a function that accepts a result argument and\nreturns a string.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_resultTextLocator"
     },
     "source": {
      "!type": "fn()",
      "!doc": "Source for autocomplete results. The following source types are supported:\n\n<dl>\n  <dt>Array</dt>\n  <dd>\n    <p>\n    The full array will be provided to any configured filters for each\n    query. This is an easy way to create a fully client-side autocomplete\n    implementation.\n    </p>\n\n    <p>\n    Example: `['first result', 'second result', 'etc']`\n    </p>\n  </dd>\n\n  <dt>DataSource</dt>\n  <dd>\n    A `DataSource` instance or other object that provides a DataSource-like\n    `sendRequest` method. See the `DataSource` documentation for details.\n  </dd>\n\n  <dt>Function</dt>\n  <dd>\n    <p>\n    A function source will be called with the current query and a\n    callback function as parameters, and should either return an array of\n    results (for synchronous operation) or return nothing and pass an\n    array of results to the provided callback (for asynchronous\n    operation).\n    </p>\n\n    <p>\n    Example (synchronous):\n    </p>\n\n    <pre>\n    function (query) {\n        return ['foo', 'bar'];\n    }\n    </pre>\n\n    <p>\n    Example (async):\n    </p>\n\n    <pre>\n    function (query, callback) {\n        callback(['foo', 'bar']);\n    }\n    </pre>\n  </dd>\n\n  <dt>Object</dt>\n  <dd>\n    <p>\n    An object will be treated as a query hashmap. If a property on the\n    object matches the current query, the value of that property will be\n    used as the response.\n    </p>\n\n    <p>\n    The response is assumed to be an array of results by default. If the\n    response is not an array, provide a `resultListLocator` to\n    process the response and return an array.\n    </p>\n\n    <p>\n    Example: `{foo: ['foo result 1', 'foo result 2'], bar: ['bar result']}`\n    </p>\n  </dd>\n</dl>\n\nIf the optional `autocomplete-sources` module is loaded, then\nthe following additional source types will be supported as well:\n\n<dl>\n  <dt>&lt;select&gt; Node</dt>\n  <dd>\n    You may provide a YUI Node instance wrapping a &lt;select&gt;\n    element, and the options in the list will be used as results. You\n    will also need to specify a `resultTextLocator` of 'text'\n    or 'value', depending on what you want to use as the text of the\n    result.\n\n    Each result will be an object with the following properties:\n\n    <dl>\n      <dt>html (String)</dt>\n      <dd>\n        <p>HTML content of the &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>index (Number)</dt>\n      <dd>\n        <p>Index of the &lt;option&gt; element in the list.</p>\n      </dd>\n\n      <dt>node (Y.Node)</dt>\n      <dd>\n        <p>Node instance referring to the original &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>selected (Boolean)</dt>\n      <dd>\n        <p>Whether or not this item is currently selected in the\n        &lt;select&gt; list.</p>\n      </dd>\n\n      <dt>text (String)</dt>\n      <dd>\n        <p>Text content of the &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>value (String)</dt>\n      <dd>\n        <p>Value of the &lt;option&gt; element.</p>\n      </dd>\n    </dl>\n  </dd>\n\n  <dt>String (JSONP URL)</dt>\n  <dd>\n    <p>\n    If a URL with a `{callback}` placeholder is provided, it will be used to\n    make a JSONP request. The `{query}` placeholder will be replaced with\n    the current query, and the `{callback}` placeholder will be replaced\n    with an internally-generated JSONP callback name. Both placeholders must\n    appear in the URL, or the request will fail. An optional `{maxResults}`\n    placeholder may also be provided, and will be replaced with the value of\n    the maxResults attribute (or 1000 if the maxResults attribute is 0 or\n    less).\n    </p>\n\n    <p>\n    The response is assumed to be an array of results by default. If the\n    response is not an array, provide a `resultListLocator` to process the\n    response and return an array.\n    </p>\n\n    <p>\n    <strong>The `jsonp` module must be loaded in order for\n    JSONP URL sources to work.</strong> If the `jsonp` module\n    is not already loaded, it will be loaded on demand if possible.\n    </p>\n\n    <p>\n    Example: `'http://example.com/search?q={query}&callback={callback}'`\n    </p>\n  </dd>\n\n  <dt>String (XHR URL)</dt>\n  <dd>\n    <p>\n    If a URL without a `{callback}` placeholder is provided, it will be used\n    to make a same-origin XHR request. The `{query}` placeholder will be\n    replaced with the current query. An optional `{maxResults}` placeholder\n    may also be provided, and will be replaced with the value of the\n    maxResults attribute (or 1000 if the maxResults attribute is 0 or less).\n    </p>\n\n    <p>\n    The response is assumed to be a JSON array of results by default. If the\n    response is a JSON object and not an array, provide a\n    `resultListLocator` to process the response and return an array. If the\n    response is in some form other than JSON, you will need to use a custom\n    DataSource instance as the source.\n    </p>\n\n    <p>\n    <strong>The `io-base` and `json-parse` modules\n    must be loaded in order for XHR URL sources to work.</strong> If\n    these modules are not already loaded, they will be loaded on demand\n    if possible.\n    </p>\n\n    <p>\n    Example: `'http://example.com/search?q={query}'`\n    </p>\n  </dd>\n\n  <dt>String (YQL query)</dt>\n  <dd>\n    <p>\n    If a YQL query is provided, it will be used to make a YQL request. The\n    `{query}` placeholder will be replaced with the current autocomplete\n    query. This placeholder must appear in the YQL query, or the request\n    will fail. An optional `{maxResults}` placeholder may also be provided,\n    and will be replaced with the value of the maxResults attribute (or 1000\n    if the maxResults attribute is 0 or less).\n    </p>\n\n    <p>\n    <strong>The `yql` module must be loaded in order for YQL\n    sources to work.</strong> If the `yql` module is not\n    already loaded, it will be loaded on demand if possible.\n    </p>\n\n    <p>\n    Example: `'select * from search.suggest where query=\"{query}\"'`\n    </p>\n  </dd>\n</dl>\n\nAs an alternative to providing a source, you could simply listen for `query`\nevents and handle them any way you see fit. Providing a source is optional,\nbut will usually be simpler.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_source"
     },
     "sourceType": {
      "!type": "fn()",
      "!doc": "May be used to force a specific source type, overriding the automatic source\ntype detection. It should almost never be necessary to do this, but as they\ntaught us in the Boy Scouts, one should always be prepared, so it's here if\nyou need it. Be warned that if you set this attribute and something breaks,\nit's your own fault.\n\nSupported `sourceType` values are: 'array', 'datasource', 'function', and\n'object'.\n\nIf the `autocomplete-sources` module is loaded, the following additional\nsource types are supported: 'io', 'jsonp', 'select', 'string', 'yql'",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_sourceType"
     },
     "tokenInput": {
      "!type": "fn()",
      "!doc": "If the `inputNode` specified at instantiation time has a `node-tokeninput`\nplugin attached to it, this attribute will be a reference to the\n`Y.Plugin.TokenInput` instance.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_tokenInput"
     },
     "value": {
      "!type": "fn()",
      "!doc": "Current value of the input node.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_value"
     },
     "yqlEnv": {
      "!type": "fn()",
      "!doc": "YQL environment file URL to load when the `source` is set to a YQL query.\nSet this to `null` to use the default Open Data Tables environment file\n(http://datatables.org/alltables.env).",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_yqlEnv"
     },
     "yqlProtocol": {
      "!type": "fn()",
      "!doc": "URL protocol to use when the `source` is set to a YQL query.",
      "!url": "http://alloyui.com/classes/AutoCompleteBase.html#attribute_yqlProtocol"
     }
    },
    "SOURCE_TYPES": {
     "!type": "+yui.Object",
     "!doc": "Mapping of built-in source types to their setter functions. DataSource instances\nand DataSource-like objects are handled natively, so are not mapped here.",
     "!url": "http://alloyui.com/classes/AutoCompleteBase.html#property_SOURCE_TYPES"
    }
   },
   "AutoCompleteFilters": {
    "!type": "fn()",
    "!doc": "Provides pre-built result matching filters for AutoComplete.",
    "!url": "http://alloyui.com/classes/AutoCompleteFilters.html",
    "charMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `charMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_charMatchFold"
    },
    "phraseMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `phraseMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_phraseMatchFold"
    },
    "startsWithFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `startsWith()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_startsWithFold"
    },
    "subWordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `subWordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_subWordMatchFold"
    },
    "wordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `wordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_wordMatchFold"
    },
    "charMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain all of the characters in the query,\nin any order (not necessarily consecutive). Case-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_charMatch"
    },
    "charMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `charMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_charMatchCase"
    },
    "phraseMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain the complete query as a phrase.\nCase-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_phraseMatch"
    },
    "phraseMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `phraseMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_phraseMatchCase"
    },
    "startsWith": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that start with the complete query as a phrase.\nCase-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_startsWith"
    },
    "startsWithCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `startsWith()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_startsWithCase"
    },
    "subWordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results in which all the words of the query match either\nwhole words or parts of words in the result. Non-word characters like\nwhitespace and certain punctuation are ignored. Case-insensitive.\n\nThis is basically a combination of `wordMatch()` (by ignoring whitespace and\nword order) and `phraseMatch()` (by allowing partial matching instead of\nrequiring the entire word to match).\n\nExample use case: Trying to find personal names independently of name order\n(Western or Eastern order) and supporting immediate feedback by allowing\npartial occurences. So queries like \"J. Doe\", \"Doe, John\", and \"J. D.\" would\nall match \"John Doe\".",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_subWordMatch"
    },
    "subWordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `subWordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_subWordMatchCase"
    },
    "wordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain all of the words in the query, in\nany order. Non-word characters like whitespace and certain punctuation are\nignored. Case-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_wordMatch"
    },
    "wordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `wordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteFilters.html#method_wordMatchCase"
    }
   },
   "AutoCompleteHighlighters": {
    "!type": "fn()",
    "!doc": "Provides pre-built result highlighters for AutoComplete.",
    "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html",
    "charMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `charMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_charMatchFold"
    },
    "phraseMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `phraseMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_phraseMatchFold"
    },
    "startsWithFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `startsWith()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_startsWithFold"
    },
    "subWordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `subWordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_subWordMatchFold"
    },
    "wordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `wordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_wordMatchFold"
    },
    "charMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights any individual query character that occurs anywhere in a result.\nCase-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_charMatch"
    },
    "charMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `charMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_charMatchCase"
    },
    "phraseMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights the complete query as a phrase anywhere within a result. Case-\ninsensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_phraseMatch"
    },
    "phraseMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `phraseMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_phraseMatchCase"
    },
    "startsWith": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights the complete query as a phrase at the beginning of a result.\nCase-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_startsWith"
    },
    "startsWithCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `startsWith()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_startsWithCase"
    },
    "subWordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights portions of results in which words from the query match either\nwhole words or parts of words in the result. Non-word characters like\nwhitespace and certain punctuation are ignored. Case-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_subWordMatch"
    },
    "subWordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `subWordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_subWordMatchCase"
    },
    "wordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights individual words in results that are also in the query. Non-word\ncharacters like punctuation are ignored. Case-insensitive.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_wordMatch"
    },
    "wordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `wordMatch()`.",
     "!url": "http://alloyui.com/classes/AutoCompleteHighlighters.html#method_wordMatchCase"
    }
   },
   "AutoCompleteList": {
    "!type": "fn(config: yui.Object) -> +autocomplete.AutoCompleteList",
    "!proto": "widget.Widget",
    "!doc": "Traditional autocomplete dropdown list widget, just like Mom used to make.",
    "!url": "http://alloyui.com/classes/AutoCompleteList.html",
    "prototype": {
     "select": {
      "!type": "fn(itemNode: node.Node, result: yui.Object)",
      "!doc": "Fires when an autocomplete suggestion is selected from the list,\ntypically via a keyboard action or mouse click.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#event_select"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hides the list, unless the `alwaysShowList` attribute is `true`.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#method_hide"
     },
     "selectItem": {
      "!type": "fn(itemNode?: node.Node, originEvent?: event_custom.EventFacade) -> !this",
      "!doc": "Selects the specified _itemNode_, or the current `activeItem` if _itemNode_\nis not specified.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#method_selectItem"
     },
     "activateFirstItem": {
      "!type": "fn()",
      "!doc": "If `true`, the first item in the list will be activated by default when\nthe list is initially displayed and when results change.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_activateFirstItem"
     },
     "activeItem": {
      "!type": "fn()",
      "!doc": "Item that's currently active, if any. When the user presses enter, this\nis the item that will be selected.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_activeItem"
     },
     "alwaysShowList": {
      "!type": "fn()",
      "!doc": "If `true`, the list will remain visible even when there are no results\nto display.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_alwaysShowList"
     },
     "circular": {
      "!type": "fn()",
      "!doc": "If `true`, keyboard navigation will wrap around to the opposite end of\nthe list when navigating past the first or last item.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_circular"
     },
     "hoveredItem": {
      "!type": "fn()",
      "!doc": "Item currently being hovered over by the mouse, if any.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_hoveredItem"
     },
     "listNode": {
      "!type": "fn()",
      "!doc": "Node that will contain result items.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_listNode"
     },
     "scrollIntoView": {
      "!type": "fn()",
      "!doc": "If `true`, the viewport will be scrolled to ensure that the active list\nitem is visible when necessary.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_scrollIntoView"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Translatable strings used by the AutoCompleteList widget.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_strings"
     },
     "tabSelect": {
      "!type": "fn()",
      "!doc": "If `true`, pressing the tab key while the list is visible will select\nthe active item, if any.",
      "!url": "http://alloyui.com/classes/AutoCompleteList.html#attribute_tabSelect"
     }
    }
   }
  },
  "base": {
   "Base": {
    "!type": "fn(config: yui.Object) -> +base.Base",
    "!doc": "<p>\nA base class which objects requiring attributes and custom event support can\nextend. Base also handles the chaining of initializer and destructor methods across\nthe hierarchy as part of object construction and destruction. Additionally, attributes configured\nthrough the static <a href=\"#property_ATTRS\">ATTRS</a> property for each class\nin the hierarchy will be initialized by Base.\n</p>\n\n<p>\n**NOTE:** Prior to version 3.11.0, ATTRS would get added a class at a time. That is,\nBase would loop through each class in the hierarchy, and add the class' ATTRS, and\nthen call it's initializer, and move on to the subclass' ATTRS and initializer. As of\n3.11.0, ATTRS from all classes in the hierarchy are added in one `addAttrs` call before\nany initializers are called. This fixes subtle edge-case issues with subclass ATTRS overriding\nsuperclass `setter`, `getter` or `valueFn` definitions and being unable to get/set attributes\ndefined by the subclass. This order of operation change may impact `setter`, `getter` or `valueFn`\ncode which expects a superclass' initializer to have run. This is expected to be rare, but to support\nit, Base supports a `_preAddAttrs()`, method hook (same signature as `addAttrs`). Components can\nimplement this method on their prototype for edge cases which do require finer control over\nthe order in which attributes are added (see widget-htmlparser).\n</p>\n\n<p>\nThe static <a href=\"#property_NAME\">NAME</a> property of each class extending\nfrom Base will be used as the identifier for the class, and is used by Base to prefix\nall events fired by instances of that class.\n</p>",
    "!url": "http://alloyui.com/classes/Base.html",
    "NAME": {
     "!type": "string",
     "!doc": "<p>\nThe string to be used to identify instances of\nthis class, for example in prefixing events.\n</p>\n<p>\nClasses extending Base, should define their own\nstatic NAME property, which should be camelCase by\nconvention (e.g. MyClass.NAME = \"myClass\";).\n</p>",
     "!url": "http://alloyui.com/classes/Base.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "The default set of attributes which will be available for instances of this class, and\ntheir configuration. In addition to the configuration properties listed by\nAttribute's <a href=\"Attribute.html#method_addAttr\">addAttr</a> method, the attribute\ncan also be configured with a \"cloneDefaultValue\" property, which defines how the statically\ndefined value field should be protected (\"shallow\", \"deep\" and false are supported values).\n\nBy default if the value is an object literal or an array it will be \"shallow\" cloned, to\nprotect the default value.",
     "!url": "http://alloyui.com/classes/Base.html#property_ATTRS"
    },
    "modifyAttrs": {
     "!type": "fn(ctor?: fn(), configs: yui.Object)",
     "!doc": "Provides a way to safely modify a `Y.Base` subclass' static `ATTRS` after\nthe class has been defined or created.\n\nBase-based classes cache information about the class hierarchy in order to\nefficiently create instances. This cache includes includes the aggregated\n`ATTRS` configs. If the static `ATTRS` configs need to be modified after the\nclass has been defined or create, then use this method which will make sure\nto clear any cached data before making any modifications.",
     "!url": "http://alloyui.com/classes/Base.html#method_modifyAttrs"
    },
    "build": {
     "!type": "fn(name: fn(), main: fn(), extensions: fn(), cfg: yui.Object) -> fn()",
     "!doc": "<p>\nBuilds a custom constructor function (class) from the\nmain function, and array of extension functions (classes)\nprovided. The NAME field for the constructor function is\ndefined by the first argument passed in.\n</p>\n<p>\nThe cfg object supports the following properties\n</p>\n<dl>\n   <dt>dynamic &#60;boolean&#62;</dt>\n   <dd>\n   <p>If true (default), a completely new class\n   is created which extends the main class, and acts as the\n   host on which the extension classes are augmented.</p>\n   <p>If false, the extensions classes are augmented directly to\n   the main class, modifying the main class' prototype.</p>\n   </dd>\n   <dt>aggregates &#60;String[]&#62;</dt>\n   <dd>An array of static property names, which will get aggregated\n   on to the built class, in addition to the default properties build\n   will always aggregate as defined by the main class' static _buildCfg\n   property.\n   </dd>\n</dl>",
     "!url": "http://alloyui.com/classes/Base.html#method_build"
    },
    "create": {
     "!type": "fn(name: string, main: fn(), extensions: fn(), px: yui.Object, sx: yui.Object) -> fn()",
     "!doc": "Creates a new class (constructor function) which extends the base class passed in as the second argument,\nand mixes in the array of extensions provided.\n\nPrototype properties or methods can be added to the new class, using the px argument (similar to Y.extend).\n\nStatic properties or methods can be added to the new class, using the sx argument (similar to Y.extend).\n\n**NOTE FOR COMPONENT DEVELOPERS**: Both the `base` class, and `extensions` can define static a `_buildCfg`\nproperty, which acts as class creation meta-data, and drives how special static properties from the base\nclass, or extensions should be copied, aggregated or (custom) mixed into the newly created class.\n\nThe `_buildCfg` property is a hash with 3 supported properties: `statics`, `aggregates` and `custom`, e.g:\n\n    // If the Base/Main class is the thing introducing the property:\n\n    MyBaseClass._buildCfg = {\n\n       // Static properties/methods to copy (Alias) to the built class.\n       statics: [\"CopyThisMethod\", \"CopyThisProperty\"],\n\n       // Static props to aggregate onto the built class.\n       aggregates: [\"AggregateThisProperty\"],\n\n       // Static properties which need custom handling (e.g. deep merge etc.)\n       custom: {\n          \"CustomProperty\" : function(property, Receiver, Supplier) {\n             ...\n             var triggers = Receiver.CustomProperty.triggers;\n             Receiver.CustomProperty.triggers = triggers.concat(Supplier.CustomProperty.triggers);\n             ...\n          }\n       }\n    };\n\n    MyBaseClass.CopyThisMethod = function() {...};\n    MyBaseClass.CopyThisProperty = \"foo\";\n    MyBaseClass.AggregateThisProperty = {...};\n    MyBaseClass.CustomProperty = {\n       triggers: [...]\n    }\n\n    // Or, if the Extension is the thing introducing the property:\n\n    MyExtension._buildCfg = {\n        statics : ...\n        aggregates : ...\n        custom : ...\n    }\n\nThis way, when users pass your base or extension class to `Y.Base.create` or `Y.Base.mix`, they don't need to\nknow which properties need special handling. `Y.Base` has a buildCfg which defines `ATTRS` for custom mix handling\n(to protect the static config objects), and `Y.Widget` has a buildCfg which specifies `HTML_PARSER` for\nstraight up aggregation.",
     "!url": "http://alloyui.com/classes/Base.html#method_create"
    },
    "mix": {
     "!type": "fn(main: fn(), extensions: fn()) -> fn()",
     "!doc": "<p>Mixes in a list of extensions to an existing class.</p>",
     "!url": "http://alloyui.com/classes/Base.html#method_mix"
    },
    "plug": {
     "!type": "fn()",
     "!doc": "Alias for <a href=\"Plugin.Host.html#method_Plugin.Host.plug\">Plugin.Host.plug</a>. See aliased\nmethod for argument and return value details.",
     "!url": "http://alloyui.com/classes/Base.html#method_plug"
    },
    "unplug": {
     "!type": "fn()",
     "!doc": "Alias for <a href=\"Plugin.Host.html#method_Plugin.Host.unplug\">Plugin.Host.unplug</a>. See the\naliased method for argument and return value details.",
     "!url": "http://alloyui.com/classes/Base.html#method_unplug"
    }
   },
   "BaseCore": {
    "!type": "fn(cfg: yui.Object) -> +base.BaseCore",
    "!doc": "The BaseCore class, is the lightest version of Base, and provides Base's\nbasic lifecycle management and ATTRS construction support, but doesn't\nfire init/destroy or attribute change events.\n\nBaseCore also handles the chaining of initializer and destructor methods across\nthe hierarchy as part of object construction and destruction. Additionally, attributes\nconfigured through the static <a href=\"#property_BaseCore.ATTRS\">ATTRS</a>\nproperty for each class in the hierarchy will be initialized by BaseCore.\n\nClasses which require attribute support, but don't intend to use/expose attribute\nchange events can extend BaseCore instead of Base for optimal kweight and\nruntime performance.\n\n**3.11.0 BACK COMPAT NOTE FOR COMPONENT DEVELOPERS**\n\nPrior to version 3.11.0, ATTRS would get added a class at a time. That is:\n\n<pre>\n   for each (class in the hierarchy) {\n      Call the class Extension constructors.\n\n      Add the class ATTRS.\n\n      Call the class initializer\n      Call the class Extension initializers.\n   }\n</pre>\n\nAs of 3.11.0, ATTRS from all classes in the hierarchy are added in one `addAttrs` call\nbefore **any** initializers are called. That is, the flow becomes:\n\n<pre>\n   for each (class in the hierarchy) {\n      Call the class Extension constructors.\n   }\n\n   Add ATTRS for all classes\n\n   for each (class in the hierarchy) {\n      Call the class initializer.\n      Call the class Extension initializers.\n   }\n</pre>\n\nAdding all ATTRS at once fixes subtle edge-case issues with subclass ATTRS overriding\nsuperclass `setter`, `getter` or `valueFn` definitions and being unable to get/set attributes\ndefined by the subclass. It also leaves us with a cleaner order of operation flow moving\nforward.\n\nHowever, it may require component developers to upgrade their components, for the following\nscenarios:\n\n1. It impacts components which may have `setter`, `getter` or `valueFn` code which\nexpects a superclass' initializer to have run.\n\nThis is expected to be rare, but to support it, Base now supports a `_preAddAttrs()`, method\nhook (same signature as `addAttrs`). Components can implement this method on their prototype\nfor edge cases which do require finer control over the order in which attributes are added\n(see widget-htmlparser for example).\n\n2. Extension developers may need to move code from Extension constructors to `initializer`s\n\nOlder extensions, which were written before `initializer` support was added, had a lot of\ninitialization code in their constructors. For example, code which acccessed superclass\nattributes. With the new flow this code would not be able to see attributes. The recommendation\nis to move this initialization code to an `initializer` on the Extension, which was the\nrecommendation for anything created after `initializer` support for Extensions was added.",
    "!url": "http://alloyui.com/classes/BaseCore.html",
    "NAME": {
     "!type": "string",
     "!doc": "The string to be used to identify instances of this class.\n\nClasses extending BaseCore, should define their own\nstatic NAME property, which should be camelCase by\nconvention (e.g. MyClass.NAME = \"myClass\";).",
     "!url": "http://alloyui.com/classes/BaseCore.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "The default set of attributes which will be available for instances of this class, and\ntheir configuration. In addition to the configuration properties listed by\nAttributeCore's <a href=\"AttributeCore.html#method_addAttr\">addAttr</a> method,\nthe attribute can also be configured with a \"cloneDefaultValue\" property, which\ndefines how the statically defined value field should be protected\n(\"shallow\", \"deep\" and false are supported values).\n\nBy default if the value is an object literal or an array it will be \"shallow\"\ncloned, to protect the default value.",
     "!url": "http://alloyui.com/classes/BaseCore.html#property_ATTRS"
    },
    "prototype": {
     "initialized": {
      "!type": "fn()",
      "!doc": "Flag indicating whether or not this object\nhas been through the init lifecycle phase.",
      "!url": "http://alloyui.com/classes/BaseCore.html#attribute_initialized"
     },
     "destroyed": {
      "!type": "fn()",
      "!doc": "Flag indicating whether or not this object\nhas been through the destroy lifecycle phase.",
      "!url": "http://alloyui.com/classes/BaseCore.html#attribute_destroyed"
     },
     "name": {
      "!type": "string",
      "!doc": "The string used to identify the class of this object.",
      "!url": "http://alloyui.com/classes/BaseCore.html#property_name"
     },
     "init": {
      "!type": "fn(cfg: yui.Object) -> !this",
      "!doc": "Init lifecycle method, invoked during construction. Sets up attributes\nand invokes initializers for the class hierarchy.",
      "!url": "http://alloyui.com/classes/BaseCore.html#method_init"
     },
     "destroy": {
      "!type": "fn() -> !this",
      "!doc": "Destroy lifecycle method. Invokes destructors for the class hierarchy.",
      "!url": "http://alloyui.com/classes/BaseCore.html#method_destroy"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Default toString implementation. Provides the constructor NAME\nand the instance guid, if set.",
      "!url": "http://alloyui.com/classes/BaseCore.html#method_toString"
     }
    },
    "modifyAttrs": {
     "!type": "fn(ctor?: fn(), configs: yui.Object)",
     "!doc": "Provides a way to safely modify a `Y.BaseCore` subclass' static `ATTRS`\nafter the class has been defined or created.\n\nBaseCore-based classes cache information about the class hierarchy in order\nto efficiently create instances. This cache includes includes the aggregated\n`ATTRS` configs. If the static `ATTRS` configs need to be modified after the\nclass has been defined or create, then use this method which will make sure\nto clear any cached data before making any modifications.",
     "!url": "http://alloyui.com/classes/BaseCore.html#method_modifyAttrs"
    }
   },
   "BaseObservable": {
    "!type": "fn()",
    "!doc": "Provides an augmentable implementation of lifecycle and attribute events for\n`BaseCore`.",
    "!url": "http://alloyui.com/classes/BaseObservable.html",
    "prototype": {
     "init": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nLifecycle event for the init phase, fired prior to initialization.\nInvoking the preventDefault() method on the event object provided\nto subscribers will prevent initialization from occuring.\n</p>\n<p>\nSubscribers to the \"after\" momemt of this event, will be notified\nafter initialization of the object is complete (and therefore\ncannot prevent initialization).\n</p>",
      "!url": "http://alloyui.com/classes/BaseObservable.html#event_init"
     },
     "destroy": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nLifecycle event for the destroy phase,\nfired prior to destruction. Invoking the preventDefault\nmethod on the event object provided to subscribers will\nprevent destruction from proceeding.\n</p>\n<p>\nSubscribers to the \"after\" moment of this event, will be notified\nafter destruction is complete (and as a result cannot prevent\ndestruction).\n</p>",
      "!url": "http://alloyui.com/classes/BaseObservable.html#event_destroy"
     }
    }
   },
   "Button": {
    "!type": "fn(config: yui.Object) -> +button.Button",
    "!proto": "widget.Widget",
    "!doc": "Creates a Button",
    "!url": "http://alloyui.com/classes/Button.html",
    "prototype": {
     "undefined": {
      "!type": "fn()",
      "!doc": "var push = Y.one('#myPushButton'),\n    toggle = Y.one('#myToggleButton');",
      "!url": "http://alloyui.com/classes/Button.html"
     }
    }
   }
  },
  "button": {
   "Button": {
    "!type": "fn(config: yui.Object) -> +button.Button",
    "!proto": "widget.Widget",
    "!doc": "Creates a Button",
    "!url": "http://alloyui.com/classes/Button.html",
    "prototype": {
     "BOUNDING_TEMPLATE": {
      "!type": "string",
      "!doc": "Bounding box template that will contain the Button's DOM subtree.",
      "!url": "http://alloyui.com/classes/Button.html#property_BOUNDING_TEMPLATE"
     },
     "CONTENT_TEMPLATE": {
      "!type": "string",
      "!doc": "Content box template",
      "!url": "http://alloyui.com/classes/Button.html#property_CONTENT_TEMPLATE"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The text of the button's label",
      "!url": "http://alloyui.com/classes/Button.html#attribute_label"
     },
     "labelHTML": {
      "!type": "fn()",
      "!doc": "The HTML of the button's label\n\nThis attribute accepts HTML and inserts it into the DOM **without**\nsanitization.  This attribute should only be used with HTML that has\neither been escaped (using `Y.Escape.html`), or sanitized according to\nthe requirements of your application.\n\nIf all you need is support for text labels, please use the `label`\nattribute instead.",
      "!url": "http://alloyui.com/classes/Button.html#attribute_labelHTML"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "List of class names used in the Button's DOM",
     "!url": "http://alloyui.com/classes/Button.html#property_CLASS_NAMES"
    }
   },
   "ToggleButton": {
    "!type": "fn(config: yui.Object) -> +button.ToggleButton",
    "!proto": "button.Button",
    "!doc": "Creates a ToggleButton",
    "!url": "http://alloyui.com/classes/ToggleButton.html",
    "prototype": {
     "trigger": {
      "!type": "string",
      "!url": "http://alloyui.com/classes/ToggleButton.html#property_trigger"
     },
     "selectedAttrName": {
      "!type": "string",
      "!url": "http://alloyui.com/classes/ToggleButton.html#property_selectedAttrName"
     },
     "initializer": {
      "!type": "fn()",
      "!url": "http://alloyui.com/classes/ToggleButton.html#method_initializer"
     },
     "destructor": {
      "!type": "fn()",
      "!url": "http://alloyui.com/classes/ToggleButton.html#method_destructor"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "Hooks up events for the widget",
      "!url": "http://alloyui.com/classes/ToggleButton.html#method_bindUI"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Syncs the UI for the widget",
      "!url": "http://alloyui.com/classes/ToggleButton.html#method_syncUI"
     },
     "toggle": {
      "!type": "fn()",
      "!doc": "Toggles the selected/pressed/checked state of a ToggleButton",
      "!url": "http://alloyui.com/classes/ToggleButton.html#method_toggle"
     },
     "type": {
      "!type": "fn()",
      "!url": "http://alloyui.com/classes/ToggleButton.html#attribute_type"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Array of static constants used to identify the classnames applied to DOM nodes",
     "!url": "http://alloyui.com/classes/ToggleButton.html#property_CLASS_NAMES"
    }
   }
  },
  "button_core": {
   "ButtonCore": {
    "!type": "fn(config: yui.Object) -> +button_core.ButtonCore",
    "!doc": "Creates a button",
    "!url": "http://alloyui.com/classes/ButtonCore.html",
    "prototype": {
     "TEMPLATE": {
      "!type": "string",
      "!url": "http://alloyui.com/classes/ButtonCore.html#property_TEMPLATE"
     },
     "enable": {
      "!type": "fn()",
      "!doc": "Sets the button's `disabled` DOM attribute to `false`",
      "!url": "http://alloyui.com/classes/ButtonCore.html#method_enable"
     },
     "disable": {
      "!type": "fn()",
      "!doc": "Sets the button's `disabled` DOM attribute to `true`",
      "!url": "http://alloyui.com/classes/ButtonCore.html#method_disable"
     },
     "getNode": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets the button's host node",
      "!url": "http://alloyui.com/classes/ButtonCore.html#method_getNode"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The text of the button's label",
      "!url": "http://alloyui.com/classes/ButtonCore.html#config_label"
     },
     "labelHTML": {
      "!type": "fn()",
      "!doc": "The HTML of the button's label\n\nThis attribute accepts HTML and inserts it into the DOM **without**\nsanitization.  This attribute should only be used with HTML that has\neither been escaped (using `Y.Escape.html`), or sanitized according to\nthe requirements of your application.\n\nIf all you need is support for text labels, please use the `label`\nattribute instead.",
      "!url": "http://alloyui.com/classes/ButtonCore.html#config_labelHTML"
     },
     "disabled": {
      "!type": "fn()",
      "!doc": "The button's enabled/disabled state",
      "!url": "http://alloyui.com/classes/ButtonCore.html#config_disabled"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Name of this component.",
     "!url": "http://alloyui.com/classes/ButtonCore.html#property_NAME"
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Array of static constants used to identify the classnames applied to DOM nodes",
     "!url": "http://alloyui.com/classes/ButtonCore.html#property_CLASS_NAMES"
    }
   }
  },
  "button_group": {
   "ButtonGroup": {
    "!type": "fn(config: yui.Object) -> +button_group.ButtonGroup",
    "!proto": "widget.Widget",
    "!doc": "Creates a ButtonGroup",
    "!url": "http://alloyui.com/classes/ButtonGroup.html",
    "prototype": {
     "renderUI": {
      "!type": "fn()",
      "!doc": "Creates a visual representation of the widget based on existing parameters.",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#method_renderUI"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "Hooks up events for the widget",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#method_bindUI"
     },
     "getButtons": {
      "!type": "fn()",
      "!doc": "Returns all buttons inside this this button group",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#method_getButtons"
     },
     "getSelectedButtons": {
      "!type": "fn()",
      "!doc": "Returns all Y.Buttons instances that are selected",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#method_getSelectedButtons"
     },
     "getSelectedValues": {
      "!type": "fn()",
      "!doc": "Returns the values of all Y.Button instances that are selected",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#method_getSelectedValues"
     },
     "selectionChange": {
      "!type": "fn(the: event.Event)",
      "!doc": "fires when any button in the group changes its checked status",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#event_selectionChange"
     },
     "type": {
      "!type": "fn()",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#attribute_type"
     },
     "BUTTON_SELECTOR": {
      "!type": "string",
      "!doc": "Selector used to find buttons inside a ButtonGroup",
      "!url": "http://alloyui.com/classes/ButtonGroup.html#property_BUTTON_SELECTOR"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "List of class names to use for ButtonGroups",
     "!url": "http://alloyui.com/classes/ButtonGroup.html#property_CLASS_NAMES"
    }
   }
  },
  "button_plugin": {
   "Plugin.Button": {
    "!type": "fn(config: yui.Object) -> +button_plugin.Plugin.Button",
    "!proto": "button_core.ButtonCore",
    "!url": "http://alloyui.com/classes/Plugin.Button.html",
    "NAME": {
     "!type": "string",
     "!doc": "Name of this component.",
     "!url": "http://alloyui.com/classes/Plugin.Button.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Namespace of this component.",
     "!url": "http://alloyui.com/classes/Plugin.Button.html#property_NS"
    },
    "prototype": {
     "createNode": {
      "!type": "fn(node: yui.Object, config: yui.Object) -> +yui.Object",
      "!doc": "A factory that plugs a Y.Node instance with Y.Plugin.Button",
      "!url": "http://alloyui.com/classes/Plugin.Button.html#method_createNode"
     }
    }
   }
  },
  "cache": {
   "Cache": {
    "!type": "fn() -> +cache.Cache",
    "!proto": "base.Base",
    "!doc": "Base class for the YUI Cache utility.",
    "!url": "http://alloyui.com/classes/Cache.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/Cache.html#property_NAME"
    },
    "prototype": {
     "max": {
      "!type": "fn()",
      "!doc": "Maximum number of entries the Cache can hold.\nSet to 0 to turn off caching.",
      "!url": "http://alloyui.com/classes/Cache.html#attribute_max"
     },
     "size": {
      "!type": "fn()",
      "!doc": "Number of entries currently cached.",
      "!url": "http://alloyui.com/classes/Cache.html#attribute_size"
     },
     "uniqueKeys": {
      "!type": "fn()",
      "!doc": "Validate uniqueness of stored keys. Default is false and\nis more performant.",
      "!url": "http://alloyui.com/classes/Cache.html#attribute_uniqueKeys"
     },
     "expires": {
      "!type": "fn()",
      "!doc": "Absolute Date when data expires or\nrelative number of milliseconds. Zero disables expiration.",
      "!url": "http://alloyui.com/classes/Cache.html#attribute_expires"
     },
     "entries": {
      "!type": "fn()",
      "!doc": "Cached entries.",
      "!url": "http://alloyui.com/classes/Cache.html#attribute_entries"
     },
     "add": {
      "!type": "fn(request: yui.Object, response: yui.Object)",
      "!doc": "Adds a new entry to the cache of the format\n{request:request, response:response, cached:cached, expires:expires}.\nIf cache is full, evicts the stalest entry before adding the new one.",
      "!url": "http://alloyui.com/classes/Cache.html#method_add"
     },
     "flush": {
      "!type": "fn()",
      "!doc": "Flushes cache.",
      "!url": "http://alloyui.com/classes/Cache.html#method_flush"
     },
     "request": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when an entry is requested from the cache.",
      "!url": "http://alloyui.com/classes/Cache.html#event_request"
     },
     "retrieve": {
      "!type": "fn(request: yui.Object) -> +yui.Object",
      "!doc": "Retrieves cached object for given request, if available, and refreshes\nentry in the cache. Returns null if there is no cache match.",
      "!url": "http://alloyui.com/classes/Cache.html#method_retrieve"
     }
    }
   },
   "CacheOffline": {
    "!type": "fn() -> +cache.CacheOffline",
    "!proto": "cache.Cache",
    "!doc": "Extends Cache utility with offline functionality.",
    "!url": "http://alloyui.com/classes/CacheOffline.html",
    "prototype": {
     "error": {
      "!type": "fn()",
      "!doc": "Fired when an entry could not be added, most likely due to\nexceeded browser quota.\n<dl>\n<dt>error (Object)</dt> <dd>The error object.</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/CacheOffline.html#event_error"
     },
     "sandbox": {
      "!type": "fn()",
      "!doc": "A string that must be passed in via the constructor.\nThis identifier is used to sandbox one cache instance's entries\nfrom another. Calling the cache instance's flush and length methods\nor get(\"entries\") will apply to only these sandboxed entries.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#attribute_sandbox"
     },
     "expires": {
      "!type": "fn()",
      "!doc": "Absolute Date when data expires or\nrelative number of milliseconds. Zero disables expiration.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#attribute_expires"
     },
     "max": {
      "!type": "fn()",
      "!doc": "Disabled.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#attribute_max"
     },
     "uniqueKeys": {
      "!type": "fn()",
      "!doc": "Always true for CacheOffline.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#attribute_uniqueKeys"
     },
     "add": {
      "!type": "fn(request: yui.Object, response: yui.Object)",
      "!doc": "Adds a new entry to the cache of the format\n{request:request, response:response, cached:cached, expires: expires}.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#method_add"
     },
     "retrieve": {
      "!type": "fn(request: yui.Object) -> +yui.Object",
      "!doc": "Retrieves cached object for given request, if available.\nReturns null if there is no cache match.",
      "!url": "http://alloyui.com/classes/CacheOffline.html#method_retrieve"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/CacheOffline.html#property_NAME"
    },
    "flushAll": {
     "!type": "fn()",
     "!doc": "Removes all items from all sandboxes. Useful if localStorage has\nexceeded quota. Only supported on browsers that implement HTML 5\nlocalStorage.",
     "!url": "http://alloyui.com/classes/CacheOffline.html#method_flushAll"
    }
   },
   "Plugin.Cache": {
    "!type": "fn()",
    "!proto": "cache.Cache",
    "!doc": "Plugin.Cache adds pluginizability to Cache.",
    "!url": "http://alloyui.com/classes/Plugin.Cache.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/Plugin.Cache.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/Plugin.Cache.html#property_NAME"
    }
   }
  },
  "calendar": {
   "CalendarBase": {
    "!type": "fn(config: yui.Object) -> +calendar.CalendarBase",
    "!proto": "widget.Widget",
    "!doc": "month range of dates, rendered as a grid with date and\nweekday labels.",
    "!url": "http://alloyui.com/classes/CalendarBase.html",
    "prototype": {
     "initializer": {
      "!type": "fn()",
      "!doc": "Designated initializer\nInitializes instance-level properties of\ncalendar.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#method_initializer"
     },
     "renderUI": {
      "!type": "fn()",
      "!doc": "renderUI implementation\n\nCreates a visual representation of the calendar based on existing parameters.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#method_renderUI"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "bindUI implementation\n\nAssigns listeners to relevant events that change the state\nof the calendar.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#method_bindUI"
     },
     "selectDates": {
      "!type": "fn(dates: datatype_date.Date) -> !this",
      "!doc": "Selects a given date or array of dates.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#method_selectDates"
     },
     "deselectDates": {
      "!type": "fn(dates?: datatype_date.Date) -> !this",
      "!doc": "Deselects a given date or array of dates, or deselects\nall dates if no argument is specified.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#method_deselectDates"
     },
     "selectionChange": {
      "!type": "fn()",
      "!doc": "Fired when the set of selected dates changes. Contains a payload with\na `newSelection` property with an array of selected dates.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#event_selectionChange"
     },
     "date": {
      "!type": "fn()",
      "!doc": "The date corresponding to the current calendar view. Always\nnormalized to the first of the month that contains the date\nat assignment time. Used as the first date visible in the\ncalendar.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_date"
     },
     "showPrevMonth": {
      "!type": "fn()",
      "!doc": "A setting specifying whether to shows days from the previous\nmonth in the visible month's grid, if there are empty preceding\ncells available.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_showPrevMonth"
     },
     "showNextMonth": {
      "!type": "fn()",
      "!doc": "A setting specifying whether to shows days from the next\nmonth in the visible month's grid, if there are empty\ncells available at the end.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_showNextMonth"
     },
     "headerRenderer": {
      "!type": "fn()",
      "!doc": "Custom header renderer for the calendar.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_headerRenderer"
     },
     "enabledDatesRule": {
      "!type": "fn()",
      "!doc": "The name of the rule which all enabled dates should match.\nEither disabledDatesRule or enabledDatesRule should be specified,\nor neither, but not both.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_enabledDatesRule"
     },
     "disabledDatesRule": {
      "!type": "fn()",
      "!doc": "The name of the rule which all disabled dates should match.\nEither disabledDatesRule or enabledDatesRule should be specified,\nor neither, but not both.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_disabledDatesRule"
     },
     "selectedDates": {
      "!type": "fn()",
      "!doc": "A read-only attribute providing a list of currently selected dates.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_selectedDates"
     },
     "customRenderer": {
      "!type": "fn()",
      "!doc": "An object of the form {rules:Object, filterFunction:Function},\nproviding  set of rules and a custom rendering function for\ncustomizing specific calendar cells.",
      "!url": "http://alloyui.com/classes/CalendarBase.html#attribute_customRenderer"
     }
    }
   },
   "Calendar": {
    "!type": "fn(config: yui.Object) -> +calendar.Calendar",
    "!proto": "calendar.CalendarBase",
    "!doc": "month range of dates, rendered as a grid with date and\nweekday labels.",
    "!url": "http://alloyui.com/classes/Calendar.html",
    "prototype": {
     "initializer": {
      "!type": "fn()",
      "!doc": "Designated initializer. Activates the navigation plugin for the calendar.",
      "!url": "http://alloyui.com/classes/Calendar.html#method_initializer"
     },
     "dateClick": {
      "!type": "fn()",
      "!doc": "Fired when a specific date cell in the calendar is clicked. The event carries a\npayload which includes a `cell` property corresponding to the node of the actual\ndate cell, and a `date` property, with the `Date` that was clicked.",
      "!url": "http://alloyui.com/classes/Calendar.html#event_dateClick"
     },
     "prevMonthClick": {
      "!type": "fn()",
      "!doc": "Fired when any of the previous month's days displayed before the calendar grid\nare clicked.",
      "!url": "http://alloyui.com/classes/Calendar.html#event_prevMonthClick"
     },
     "nextMonthClick": {
      "!type": "fn()",
      "!doc": "Fired when any of the next month's days displayed after the calendar grid\nare clicked.",
      "!url": "http://alloyui.com/classes/Calendar.html#event_nextMonthClick"
     },
     "subtractMonth": {
      "!type": "fn() -> !this",
      "!doc": "Subtracts one month from the current calendar view.",
      "!url": "http://alloyui.com/classes/Calendar.html#method_subtractMonth"
     },
     "subtractYear": {
      "!type": "fn() -> !this",
      "!doc": "Subtracts one year from the current calendar view.",
      "!url": "http://alloyui.com/classes/Calendar.html#method_subtractYear"
     },
     "addMonth": {
      "!type": "fn() -> !this",
      "!doc": "Adds one month to the current calendar view.",
      "!url": "http://alloyui.com/classes/Calendar.html#method_addMonth"
     },
     "addYear": {
      "!type": "fn() -> !this",
      "!doc": "Adds one year to the current calendar view.",
      "!url": "http://alloyui.com/classes/Calendar.html#method_addYear"
     },
     "selectionMode": {
      "!type": "fn()",
      "!doc": "A setting specifying the type of selection the calendar allows.\nPossible values include:\n<ul>\n  <li>`single` - One date at a time</li>\n  <li>`multiple-sticky` - Multiple dates, selected one at a time (the dates \"stick\"). This option\n  is appropriate for mobile devices, where function keys from the keyboard are not available.</li>\n  <li>`multiple` - Multiple dates, selected with Ctrl/Meta keys for additional single\n  dates, and Shift key for date ranges.</li>",
      "!url": "http://alloyui.com/classes/Calendar.html#attribute_selectionMode"
     },
     "date": {
      "!type": "fn()",
      "!doc": "The date corresponding to the current calendar view. Always\nnormalized to the first of the month that contains the date\nat assignment time. Used as the first date visible in the\ncalendar.",
      "!url": "http://alloyui.com/classes/Calendar.html#attribute_date"
     },
     "minimumDate": {
      "!type": "fn()",
      "!doc": "Unless minimumDate is null, it will not be possible to display and select dates earlier than this one.",
      "!url": "http://alloyui.com/classes/Calendar.html#attribute_minimumDate"
     },
     "maximumDate": {
      "!type": "fn()",
      "!doc": "Unless maximumDate is null, it will not be possible to display and select dates later than this one.",
      "!url": "http://alloyui.com/classes/Calendar.html#attribute_maximumDate"
     }
    }
   }
  },
  "calendarnavigator": {
   "Plugin.CalendarNavigator": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A plugin class which adds navigation controls to Calendar.",
    "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the widget, which will\nreference the plugin instance, when it's plugged in.",
     "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "The NAME of the CalendarNavigator class. Used to prefix events generated\nby the plugin class.",
     "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the plugin.",
     "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#property_ATTRS"
    },
    "prototype": {
     "shiftByMonths": {
      "!type": "fn()",
      "!doc": "The number of months to shift by when the control arrows are clicked.",
      "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#attribute_shiftByMonths"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "The initializer lifecycle implementation. Modifies the host widget's\nrender to add navigation controls.",
      "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#method_initializer"
     },
     "destructor": {
      "!type": "fn()",
      "!doc": "The initializer destructor implementation. Responsible for destroying the initialized\ncontrol mechanisms.",
      "!url": "http://alloyui.com/classes/Plugin.CalendarNavigator.html#method_destructor"
     }
    }
   }
  },
  "charts": {
   "AreaSeries": {
    "!type": "fn(config: yui.Object) -> +charts.AreaSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The AreaSeries class renders quantitative data on a graph by creating a fill between 0\nand the relevant data points.",
    "!url": "http://alloyui.com/classes/AreaSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/AreaSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be\n     retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/AreaSeries.html#attribute_styles"
     }
    }
   },
   "AreaSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.AreaSplineSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "AreaSplineSeries renders an area graph with data points connected by a curve.",
    "!url": "http://alloyui.com/classes/AreaSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/AreaSplineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be\n     retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/AreaSplineSeries.html#attribute_styles"
     }
    }
   },
   "Axis": {
    "!type": "fn(config: yui.Object) -> +charts.Axis",
    "!proto": "widget.Widget",
    "!doc": "An abstract class that provides the core functionality for draw a chart axis. Axis is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/Axis.html",
    "prototype": {
     "getLabelByIndex": {
      "!type": "fn(i: number, l: number) -> ?",
      "!doc": "Calculates and returns a value based on the number of labels and the index of\nthe current label.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getLabelByIndex"
     },
     "getMaxLabelBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the coordinates (top, right, bottom, left) for the bounding box of the last label.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getMaxLabelBounds"
     },
     "getMinLabelBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the coordinates (top, right, bottom, left) for the bounding box of the first label.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getMinLabelBounds"
     },
     "getTotalMajorUnits": {
      "!type": "fn() -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getTotalMajorUnits"
     },
     "getMajorUnitDistance": {
      "!type": "fn(len: number, uiLen: number, majorUnit: yui.Object) -> ?",
      "!doc": "Returns the distance between major units on an axis.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getMajorUnitDistance"
     },
     "getMinimumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the first label on an\naxis.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getMinimumValue"
     },
     "getMaximumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the last label on an\naxis.",
      "!url": "http://alloyui.com/classes/Axis.html#method_getMaximumValue"
     },
     "width": {
      "!type": "fn()",
      "!doc": "When set, defines the width of a vertical axis instance. By default, vertical axes automatically size based\non their contents. When the width attribute is set, the axis will not calculate its width. When the width\nattribute is explicitly set, axis labels will postion themselves off of the the inner edge of the axis and the\ntitle, if present, will position itself off of the outer edge. If a specified width is less than the sum of\nthe axis' contents, excess content will overflow.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "When set, defines the height of a horizontal axis instance. By default, horizontal axes automatically size based\non their contents. When the height attribute is set, the axis will not calculate its height. When the height\nattribute is explicitly set, axis labels will postion themselves off of the the inner edge of the axis and the\ntitle, if present, will position itself off of the outer edge. If a specified height is less than the sum of\nthe axis' contents, excess content will overflow.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_height"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which the axis line and ticks will be rendered.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_graphic"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Contains the contents of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_node"
     },
     "position": {
      "!type": "fn()",
      "!doc": "Direction of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_position"
     },
     "topTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the top of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_topTickOffset"
     },
     "bottomTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the bottom of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_bottomTickOffset"
     },
     "leftTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the left of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_leftTickOffset"
     },
     "rightTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the right side of the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_rightTickOffset"
     },
     "labels": {
      "!type": "fn()",
      "!doc": "Collection of labels used to render the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_labels"
     },
     "tickPoints": {
      "!type": "fn()",
      "!doc": "Collection of points used for placement of labels and ticks along the axis.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_tickPoints"
     },
     "overlapGraph": {
      "!type": "fn()",
      "!doc": "Indicates whether the axis overlaps the graph. If an axis is the inner most axis on a given\nposition and the tick position is inside or cross, the axis will need to overlap the graph.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_overlapGraph"
     },
     "title": {
      "!type": "fn()",
      "!doc": "Title for the axis. When specified, the title will display. The position of the title is determined by the axis position.\n<dl>\n    <dt>top</dt><dd>Appears above the axis and it labels. The default rotation is 0.</dd>\n    <dt>right</dt><dd>Appears to the right of the axis and its labels. The default rotation is 90.</dd>\n    <dt>bottom</dt><dd>Appears below the axis and its labels. The default rotation is 0.</dd>\n    <dt>left</dt><dd>Appears to the left of the axis and its labels. The default rotation is -90.</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_title"
     },
     "appendLabelFunction": {
      "!type": "fn()",
      "!doc": "Function used to append an axis value to an axis label. This function has the following signature:\n <dl>\n     <dt>textField</dt><dd>The axis label to be appended. (`HTMLElement`)</dd>\n     <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`\n     or a `String`. This method does not use (`HTMLElement` | `String`)</dd>\n </dl>\nThe default method appends a value to the `HTMLElement` using the `appendChild` method. If the given\nvalue is a `String`, the method will convert the the value to a `textNode` before appending to the\n`HTMLElement`. This method will not convert an `HTMLString` to an `HTMLElement`.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_appendLabelFunction"
     },
     "appendTitleFunction": {
      "!type": "fn()",
      "!doc": "Function used to append a title value to the title object. This function has the following signature:\n <dl>\n     <dt>textField</dt><dd>The title text field to be appended. (`HTMLElement`)</dd>\n     <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`\n     or a `String`. This method does not use (`HTMLElement` | `String`)</dd>\n </dl>\nThe default method appends a value to the `HTMLElement` using the `appendChild` method. If the given\nvalue is a `String`, the method will convert the the value to a `textNode` before appending to the\n`HTMLElement` element. This method will not convert an `HTMLString` to an `HTMLElement`.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_appendTitleFunction"
     },
     "labelValues": {
      "!type": "fn()",
      "!doc": "An array containing the unformatted values of the axis labels. By default, TimeAxis, NumericAxis and\nStackedAxis labelValues are determined by the majorUnit style. By default, CategoryAxis labels are\ndetermined by the values of the dataProvider.\n<p>When the labelValues attribute is explicitly set, the labelValues are dictated by the set value and\nthe position of ticks and labels are determined by where those values would fall on the axis. </p>",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_labelValues"
     },
     "hideFirstMajorUnit": {
      "!type": "fn()",
      "!doc": "Suppresses the creation of the the first visible label and tick.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_hideFirstMajorUnit"
     },
     "hideLastMajorUnit": {
      "!type": "fn()",
      "!doc": "Suppresses the creation of the the last visible label and tick.",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_hideLastMajorUnit"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing an axis. This attribute is inherited from `Renderer`. Below are the default values:\n <dl>\n     <dt>majorTicks</dt><dd>Properties used for drawing ticks.\n         <dl>\n             <dt>display</dt><dd>Position of the tick. Possible values are `inside`, `outside`, `cross` and `none`.\n             The default value is `inside`.</dd>\n             <dt>length</dt><dd>The length (in pixels) of the tick. The default value is 4.</dd>\n             <dt>color</dt><dd>The color of the tick. The default value is `#dad8c9`</dd>\n             <dt>weight</dt><dd>Number indicating the width of the tick. The default value is 1.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>line</dt><dd>Properties used for drawing the axis line.\n         <dl>\n             <dt>weight</dt><dd>Number indicating the width of the axis line. The default value is 1.</dd>\n             <dt>color</dt><dd>The color of the axis line. The default value is `#dad8c9`.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>majorUnit</dt><dd>Properties used to calculate the `majorUnit` for the axis.\n         <dl>\n             <dt>determinant</dt><dd>The algorithm used for calculating distance between ticks. The possible options are\n             `count` and `distance`. If the `determinant` is `count`, the axis ticks will spaced so that a specified number\n             of ticks appear on the axis. If the `determinant` is `distance`, the axis ticks will spaced out according to\n             the specified distance. The default value is `count`.</dd>\n             <dt>count</dt><dd>Number of ticks to appear on the axis when the `determinant` is `count`. The default value is 11.</dd>\n             <dt>distance</dt><dd>The distance (in pixels) between ticks when the `determinant` is `distance`. The default\n             value is 75.</dd>\n         </dl>\n     </dd>\n     <dt>label</dt><dd>Properties and styles applied to the axis labels.\n         <dl>\n             <dt>color</dt><dd>The color of the labels. The default value is `#808080`.</dd>\n             <dt>alpha</dt><dd>Number between 0 and 1 indicating the opacity of the labels. The default value is 1.</dd>\n             <dt>fontSize</dt><dd>The font-size of the labels. The default value is 85%</dd>\n             <dt>rotation</dt><dd>The rotation, in degrees (between -90 and 90) of the labels. The default value is 0.</dd>\n             <dt>offset</td><dd>A number between 0 and 1 indicating the relationship of the label to a tick. For a horizontal axis\n             label, a value of 0 will position the label's left side even to the the tick. A position of 1 would position the\n             right side of the label with the tick. A position of 0.5 would center the label horizontally with the tick. For a\n             vertical axis, a value of 0 would position the top of the label with the tick, a value of 1 would position the bottom\n             of the label with the tick and a value 0 would center the label vertically with the tick. The default value is 0.5.</dd>\n             <dt>margin</dt><dd>The distance between the label and the axis/tick. Depending on the position of the `Axis`,\n             only one of the properties used.\n                 <dl>\n                     <dt>top</dt><dd>Pixel value used for an axis with a `position` of `bottom`. The default value is 4.</dd>\n                     <dt>right</dt><dd>Pixel value used for an axis with a `position` of `left`. The default value is 4.</dd>\n                     <dt>bottom</dt><dd>Pixel value used for an axis with a `position` of `top`. The default value is 4.</dd>\n                     <dt>left</dt><dd>Pixel value used for an axis with a `position` of `right`. The default value is 4.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://alloyui.com/classes/Axis.html#attribute_styles"
     }
    }
   },
   "AxisBase": {
    "!type": "fn(config: yui.Object) -> +charts.AxisBase",
    "!proto": "base.Base",
    "!doc": "An abstract class that provides the core functionality used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/AxisBase.html",
    "prototype": {
     "getOrigin": {
      "!type": "fn() -> ?",
      "!doc": "Returns the value corresponding to the origin on the axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_getOrigin"
     },
     "addKey": {
      "!type": "fn(value)",
      "!doc": "Adds an array to the key hash.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_addKey"
     },
     "removeKey": {
      "!type": "fn(value: string)",
      "!doc": "Removes an array from the key hash.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_removeKey"
     },
     "getKeyValueAt": {
      "!type": "fn(key: string, index: number) -> ?",
      "!doc": "Returns a value based of a key value and an index.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_getKeyValueAt"
     },
     "getDataByKey": {
      "!type": "fn(value: string) -> ?",
      "!doc": "Returns values based on key identifiers. When a string is passed as an argument, an array of values is returned.\nWhen an array of keys is passed as an argument, an object literal with an array of values mapped to each key is\nreturned.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_getDataByKey"
     },
     "getTotalMajorUnits": {
      "!type": "fn() -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_getTotalMajorUnits"
     },
     "getEdgeOffset": {
      "!type": "fn(ct: number, l: number) -> ?",
      "!doc": "Gets the distance that the first and last ticks are offset from there respective\nedges.",
      "!url": "http://alloyui.com/classes/AxisBase.html#method_getEdgeOffset"
     },
     "calculateEdgeOffset": {
      "!type": "fn()",
      "!doc": "Determines whether and offset is automatically calculated for the edges of the axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_calculateEdgeOffset"
     },
     "keys": {
      "!type": "fn()",
      "!doc": "Hash of array identifed by a string value.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_keys"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Returns the type of axis data\n  <dl>\n      <dt>time</dt><dd>Manages time data</dd>\n      <dt>stacked</dt><dd>Manages stacked numeric data</dd>\n      <dt>numeric</dt><dd>Manages numeric data</dd>\n      <dt>category</dt><dd>Manages categorical data</dd>\n  </dl>",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_type"
     },
     "dataProvider": {
      "!type": "fn()",
      "!doc": "Instance of `ChartDataProvider` that the class uses\nto build its own data.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_dataProvider"
     },
     "dataMaximum": {
      "!type": "fn()",
      "!doc": "The maximum value contained in the `data` array. Used for\n`maximum` when `autoMax` is true.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_dataMaximum"
     },
     "maximum": {
      "!type": "fn()",
      "!doc": "The maximum value that will appear on an axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_maximum"
     },
     "dataMinimum": {
      "!type": "fn()",
      "!doc": "The minimum value contained in the `data` array. Used for\n`minimum` when `autoMin` is true.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_dataMinimum"
     },
     "minimum": {
      "!type": "fn()",
      "!doc": "The minimum value that will appear on an axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_minimum"
     },
     "setMax": {
      "!type": "fn()",
      "!doc": "Determines whether the maximum is calculated or explicitly\nset by the user.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_setMax"
     },
     "setMin": {
      "!type": "fn()",
      "!doc": "Determines whether the minimum is calculated or explicitly\nset by the user.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_setMin"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Array of axis data",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_data"
     },
     "keyCollection": {
      "!type": "fn()",
      "!doc": "Array containing all the keys in the axis.",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_keyCollection"
     },
     "labelFunctionScope": {
      "!type": "fn()",
      "!doc": "Object which should have by the labelFunction",
      "!url": "http://alloyui.com/classes/AxisBase.html#attribute_labelFunctionScope"
     }
    }
   },
   "BarSeries": {
    "!type": "fn(config: yui.Object) -> +charts.BarSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "The BarSeries class renders bars positioned vertically along a category or time axis. The bars'\nlengths are proportional to the values they represent along a horizontal axis.\nand the relevant data points.",
    "!url": "http://alloyui.com/classes/BarSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/BarSeries.html#attribute_type"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction of the category axis that the bars are plotted against.",
      "!url": "http://alloyui.com/classes/BarSeries.html#attribute_direction"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>height</dt><dd>indicates the width of the marker. The default value is 12.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/BarSeries.html#attribute_styles"
     }
    }
   },
   "CandlestickSeries": {
    "!type": "fn(config: yui.Object) -> +charts.CandlestickSeries",
    "!proto": "charts.RangeSeries",
    "!doc": "The CandlestickSeries class renders columns (candles) and lines (wicks) representing the open, high, low and close\nvalues for a chart.",
    "!url": "http://alloyui.com/classes/CandlestickSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_type"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_graphic"
     },
     "upcandle": {
      "!type": "fn()",
      "!doc": "Reference to the candlestick used when the close value is higher than the open value.",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_upcandle"
     },
     "downcandle": {
      "!type": "fn()",
      "!doc": "Reference to the candlestick used when the open value is higher than the close value.",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_downcandle"
     },
     "wick": {
      "!type": "fn()",
      "!doc": "Reference to the line drawn between the high and low values.",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_wick"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing candles and wicks. This attribute is inherited from `RangeSeries`. Below are the default values:\n <dl>\n     <dt>upcandle</dt><dd>Properties for a candle representing a period that closes higher than it opens.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#00aa00\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>downcandle</dt><dd>Properties for a candle representing a period that opens higher than it closes.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#aa0000\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>wick</dt><dd>Properties for the wick, which is a line drawn from the high point of the period to the low point of the period.\n         <dl>\n             <dt>color</dt><dd>The color of the wick. The default value is \"#000000\".</dd>\n             <dt>weight</dt><dd>The weight of the wick. The default value is 1.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the wick. The default value is 1.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://alloyui.com/classes/CandlestickSeries.html#attribute_styles"
     }
    }
   },
   "CartesianChart": {
    "!type": "fn() -> +charts.CartesianChart",
    "!proto": "charts.ChartBase",
    "!doc": "The CartesianChart class creates a chart with horizontal and vertical axes.",
    "!url": "http://alloyui.com/classes/CartesianChart.html",
    "prototype": {
     "planarEvent:mouseover": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseover event.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#event_planarEvent:mouseover"
     },
     "planarEvent:mouseout": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseout event.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#event_planarEvent:mouseout"
     },
     "_addToAxesCollection": {
      "!type": "fn(position: string, axis: charts.Axis)",
      "!doc": "Adds axis instance to the appropriate array based on position",
      "!url": "http://alloyui.com/classes/CartesianChart.html#method__addToAxesCollection"
     },
     "getSeriesItems": {
      "!type": "fn(series: charts.CartesianSeries, index: number) -> ?",
      "!doc": "Returns an object literal containing a categoryItem and a valueItem for a given series index. Below is the structure of each:",
      "!url": "http://alloyui.com/classes/CartesianChart.html#method_getSeriesItems"
     },
     "_getAriaMessage": {
      "!type": "fn(key: number) -> ?",
      "!doc": "Returns the appropriate message based on the key press.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#method__getAriaMessage"
     },
     "allowContentOverflow": {
      "!type": "fn()",
      "!doc": "Indicates whether axis labels are allowed to overflow beyond the bounds of the chart's content box.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_allowContentOverflow"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for the chart. Contains a key indexed hash of the following:\n <dl>\n     <dt>series</dt><dd>A key indexed hash containing references to the `styles` attribute for each series in the chart.\n     Specific style attributes vary depending on the series:\n     <ul>\n         <li><a href=\"AreaSeries.html#attr_styles\">AreaSeries</a></li>\n         <li><a href=\"BarSeries.html#attr_styles\">BarSeries</a></li>\n         <li><a href=\"ColumnSeries.html#attr_styles\">ColumnSeries</a></li>\n         <li><a href=\"ComboSeries.html#attr_styles\">ComboSeries</a></li>\n         <li><a href=\"LineSeries.html#attr_styles\">LineSeries</a></li>\n         <li><a href=\"MarkerSeries.html#attr_styles\">MarkerSeries</a></li>\n         <li><a href=\"SplineSeries.html#attr_styles\">SplineSeries</a></li>\n     </ul>\n     </dd>\n     <dt>axes</dt><dd>A key indexed hash containing references to the `styles` attribute for each axes in the chart. Specific\n     style attributes can be found in the <a href=\"Axis.html#attr_styles\">Axis</a> class.</dd>\n     <dt>graph</dt><dd>A reference to the `styles` attribute in the chart. Specific style attributes can be found in the\n     <a href=\"Graph.html#attr_styles\">Graph</a> class.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_styles"
     },
     "axes": {
      "!type": "fn()",
      "!doc": "Axes to appear in the chart. This can be a key indexed hash of axis instances or object literals\nused to construct the appropriate axes.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_axes"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series to appear on the chart. This can be an array of Series instances or object literals\nused to construct the appropriate series.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_seriesCollection"
     },
     "stacked": {
      "!type": "fn()",
      "!doc": "Indicates whether or not the chart is stacked.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_stacked"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of chart's category axis when there is no series collection specified. Charts can\nbe horizontal or vertical. When the chart type is column, the chart is horizontal.\nWhen the chart type is bar, the chart is vertical.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_direction"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether or not an area is filled in a combo chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_showAreaFill"
     },
     "showMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether to display markers in a combo chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_showMarkers"
     },
     "showLines": {
      "!type": "fn()",
      "!doc": "Indicates whether to display lines in a combo chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_showLines"
     },
     "categoryAxisName": {
      "!type": "fn()",
      "!doc": "Indicates the key value used to identify a category axis in the `axes` hash. If\nnot specified, the categoryKey attribute value will be used.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_categoryAxisName"
     },
     "valueAxisName": {
      "!type": "fn()",
      "!doc": "Indicates the key value used to identify a the series axis when an axis not generated.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_valueAxisName"
     },
     "horizontalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the horizontalGridlines for the chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_horizontalGridlines"
     },
     "verticalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the verticalGridlines for the chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_verticalGridlines"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Type of chart when there is no series collection specified.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_type"
     },
     "categoryAxis": {
      "!type": "fn()",
      "!doc": "Reference to the category axis used by the chart.",
      "!url": "http://alloyui.com/classes/CartesianChart.html#attribute_categoryAxis"
     }
    }
   },
   "CartesianSeries": {
    "!type": "fn(config: yui.Object) -> +charts.CartesianSeries",
    "!proto": "charts.SeriesBase",
    "!doc": "An abstract class for creating series instances with horizontal and vertical axes.\nCartesianSeries provides the core functionality used by the following classes:\n<ul>\n     <li>{{#crossLink \"LineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"MarkerSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"AreaSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"SplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"AreaSplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"ComboSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"ComboSplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"Histogram\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/CartesianSeries.html",
    "prototype": {
     "seriesTypeCollection": {
      "!type": "fn()",
      "!doc": "An array of all series of the same type used within a chart application.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_seriesTypeCollection"
     },
     "xDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying data related to the x-coordinate.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xDisplayName"
     },
     "yDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying data related to the y-coordinate.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yDisplayName"
     },
     "categoryDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying category data",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_categoryDisplayName"
     },
     "valueDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying value data",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_valueDisplayName"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_type"
     },
     "order": {
      "!type": "fn()",
      "!doc": "Order of this instance of this `type`.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_order"
     },
     "graphOrder": {
      "!type": "fn()",
      "!doc": "Order of the instance",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_graphOrder"
     },
     "xcoords": {
      "!type": "fn()",
      "!doc": "x coordinates for the series.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xcoords"
     },
     "ycoords": {
      "!type": "fn()",
      "!doc": "y coordinates for the series",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_ycoords"
     },
     "xAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\nx-values to the graph.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xAxis"
     },
     "yAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\ny-values to the graph.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yAxis"
     },
     "xKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe x-axis `Axis` instance.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xKey"
     },
     "yKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe y-axis `Axis` instance.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yKey"
     },
     "xData": {
      "!type": "fn()",
      "!doc": "Array of x values for the series.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xData"
     },
     "yData": {
      "!type": "fn()",
      "!doc": "Array of y values for the series.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yData"
     },
     "xMarkerPlane": {
      "!type": "fn()",
      "!doc": "Collection of area maps along the xAxis. Used to determine mouseover for multiple\nseries.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xMarkerPlane"
     },
     "yMarkerPlane": {
      "!type": "fn()",
      "!doc": "Collection of area maps along the yAxis. Used to determine mouseover for multiple\nseries.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yMarkerPlane"
     },
     "xMarkerPlaneOffset": {
      "!type": "fn()",
      "!doc": "Distance from a data coordinate to the left/right for setting a hotspot.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_xMarkerPlaneOffset"
     },
     "yMarkerPlaneOffset": {
      "!type": "fn()",
      "!doc": "Distance from a data coordinate to the top/bottom for setting a hotspot.",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_yMarkerPlaneOffset"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of the series",
      "!url": "http://alloyui.com/classes/CartesianSeries.html#attribute_direction"
     }
    }
   },
   "CategoryAxis": {
    "!type": "fn(config: yui.Object) -> +charts.CategoryAxis",
    "!proto": "charts.Axis",
    "!doc": "CategoryAxis draws a category axis for a chart.",
    "!url": "http://alloyui.com/classes/CategoryAxis.html",
    "prototype": {
     "getMinimumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the first label on an\naxis.",
      "!url": "http://alloyui.com/classes/CategoryAxis.html#method_getMinimumValue"
     },
     "getMaximumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the last label on an\naxis.",
      "!url": "http://alloyui.com/classes/CategoryAxis.html#method_getMaximumValue"
     }
    }
   },
   "CategoryImpl": {
    "!type": "fn() -> +charts.CategoryImpl",
    "!doc": "CategoryImpl contains logic for managing category data. CategoryImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/CategoryImpl.html",
    "prototype": {
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Pattern used by the `labelFunction` to format a label. The default `labelFunction` values for\n`CategoryAxis` and `CategoryAxisBase` do not accept a format object. This value can be used by\na custom method.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#attribute_labelFormat"
     },
     "calculateEdgeOffset": {
      "!type": "fn()",
      "!doc": "Determines whether and offset is automatically calculated for the edges of the axis.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#attribute_calculateEdgeOffset"
     },
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or `HTMLElement`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>Template for formatting label. (optional)</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#attribute_labelFunction"
     },
     "formatLabel": {
      "!type": "fn(value: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#method_formatLabel"
     },
     "getDataByKey": {
      "!type": "fn(value: string) -> ?",
      "!doc": "Returns an array of values based on an identifier key.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#method_getDataByKey"
     },
     "getTotalMajorUnits": {
      "!type": "fn(majorUnit: yui.Object, len: number) -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#method_getTotalMajorUnits"
     },
     "getKeyValueAt": {
      "!type": "fn(key: string, index: number) -> ?",
      "!doc": "Returns a value based of a key value and an index.",
      "!url": "http://alloyui.com/classes/CategoryImpl.html#method_getKeyValueAt"
     }
    }
   },
   "ChartBase": {
    "!type": "fn() -> +charts.ChartBase",
    "!doc": "The ChartBase class is an abstract class used to create charts.",
    "!url": "http://alloyui.com/classes/ChartBase.html",
    "prototype": {
     "dataProvider": {
      "!type": "fn()",
      "!doc": "Data used to generate the chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_dataProvider"
     },
     "seriesKeys": {
      "!type": "fn()",
      "!doc": "A collection of keys that map to the series axes. If no keys are set,\nthey will be generated automatically depending on the data structure passed into\nthe chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_seriesKeys"
     },
     "ariaLabel": {
      "!type": "fn()",
      "!doc": "Sets the `aria-label` for the chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_ariaLabel"
     },
     "ariaDescription": {
      "!type": "fn()",
      "!doc": "Sets the aria description for the chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_ariaDescription"
     },
     "tooltip": {
      "!type": "fn()",
      "!doc": "Reference to the default tooltip available for the chart.\n<p>Contains the following properties:</p>\n <dl>\n     <dt>node</dt><dd>Reference to the actual dom node</dd>\n     <dt>showEvent</dt><dd>Event that should trigger the tooltip</dd>\n     <dt>hideEvent</dt><dd>Event that should trigger the removal of a tooltip (can be an event or an array of events)</dd>\n     <dt>styles</dt><dd>A hash of style properties that will be applied to the tooltip node</dd>\n     <dt>show</dt><dd>Indicates whether or not to show the tooltip</dd>\n     <dt>markerEventHandler</dt><dd>Displays and hides tooltip based on marker events</dd>\n     <dt>planarEventHandler</dt><dd>Displays and hides tooltip based on planar events</dd>\n     <dt>markerLabelFunction</dt><dd>Reference to the function used to format a marker event triggered tooltip's text.\n     The method contains the following arguments:\n <dl>\n     <dt>categoryItem</dt><dd>An object containing the following:\n <dl>\n     <dt>axis</dt><dd>The axis to which the category is bound.</dd>\n     <dt>displayName</dt><dd>The display name set to the category (defaults to key if not provided).</dd>\n     <dt>key</dt><dd>The key of the category.</dd>\n     <dt>value</dt><dd>The value of the category.</dd>\n </dl>\n </dd>\n <dt>valueItem</dt><dd>An object containing the following:\n     <dl>\n         <dt>axis</dt><dd>The axis to which the item's series is bound.</dd>\n         <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>\n         <dt>key</dt><dd>The key for the series.</dd>\n         <dt>value</dt><dd>The value for the series item.</dd>\n     </dl>\n </dd>\n <dt>itemIndex</dt><dd>The index of the item within the series.</dd>\n <dt>series</dt><dd> The `CartesianSeries` instance of the item.</dd>\n <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>\n </dl>\n The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose\n to return an html string, you will also need to override the tooltip's `setTextFunction` method to accept an html string.\n </dd>\n <dt>planarLabelFunction</dt><dd>Reference to the function used to format a planar event triggered tooltip's text\n <dl>\n     <dt>categoryAxis</dt><dd> `CategoryAxis` Reference to the categoryAxis of the chart.\n     <dt>valueItems</dt><dd>Array of objects for each series that has a data point in the coordinate plane of the event. Each\n     object contains the following data:\n <dl>\n     <dt>axis</dt><dd>The value axis of the series.</dd>\n     <dt>key</dt><dd>The key for the series.</dd>\n     <dt>value</dt><dd>The value for the series item.</dd>\n     <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>\n </dl>\n </dd>\n     <dt>index</dt><dd>The index of the item within its series.</dd>\n     <dt>seriesArray</dt><dd>Array of series instances for each value item.</dd>\n     <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>\n </dl>\n </dd>\n </dl>\n The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose\n to return an html string, you will also need to override the tooltip's `setTextFunction` method to accept an html string.\n </dd>\n <dt>setTextFunction</dt><dd>Method that writes content returned from `planarLabelFunction` or `markerLabelFunction` into the\n the tooltip node. Has the following signature:\n <dl>\n     <dt>label</dt><dd>The `HTMLElement` that the content is to be added.</dd>\n     <dt>val</dt><dd>The content to be rendered into tooltip. This can be a `String` or `HTMLElement`. If an HTML string is used,\n     it will be rendered as a string.</dd>\n </dl>\n </dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_tooltip"
     },
     "categoryKey": {
      "!type": "fn()",
      "!doc": "The key value used for the chart's category axis.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_categoryKey"
     },
     "categoryType": {
      "!type": "fn()",
      "!doc": "Indicates the type of axis to use for the category axis.\n\n <dl>\n     <dt>category</dt><dd>Specifies a `CategoryAxis`.</dd>\n     <dt>time</dt><dd>Specifies a `TimeAxis</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_categoryType"
     },
     "interactionType": {
      "!type": "fn()",
      "!doc": "Indicates the the type of interactions that will fire events.\n\n <dl>\n     <dt>marker</dt><dd>Events will be broadcasted when the mouse interacts with individual markers.</dd>\n     <dt>planar</dt><dd>Events will be broadcasted when the mouse intersects the plane of any markers on the chart.</dd>\n     <dt>none</dt><dd>No events will be broadcasted.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_interactionType"
     },
     "axesCollection": {
      "!type": "fn()",
      "!doc": "Reference to all the axes in the chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_axesCollection"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to graph instance.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_graph"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://alloyui.com/classes/ChartBase.html#attribute_groupMarkers"
     },
     "getSeries": {
      "!type": "fn(val) -> ?",
      "!doc": "Returns a series instance by index or key value.",
      "!url": "http://alloyui.com/classes/ChartBase.html#method_getSeries"
     },
     "getAxisByKey": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Returns an `Axis` instance by key reference. If the axis was explicitly set through the `axes` attribute,\nthe key will be the same as the key used in the `axes` object. For default axes, the key for\nthe category axis is the value of the `categoryKey` (`category`). For the value axis, the default\nkey is `values`.",
      "!url": "http://alloyui.com/classes/ChartBase.html#method_getAxisByKey"
     },
     "getCategoryAxis": {
      "!type": "fn() -> ?",
      "!doc": "Returns the category axis for the chart.",
      "!url": "http://alloyui.com/classes/ChartBase.html#method_getCategoryAxis"
     },
     "markerEvent:mouseover": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseover event.",
      "!url": "http://alloyui.com/classes/ChartBase.html#event_markerEvent:mouseover"
     },
     "markerEvent:mouseout": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseout event.",
      "!url": "http://alloyui.com/classes/ChartBase.html#event_markerEvent:mouseout"
     },
     "markerEvent:mousedown": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mousedown event.",
      "!url": "http://alloyui.com/classes/ChartBase.html#event_markerEvent:mousedown"
     },
     "markerEvent:mouseup": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseup event.",
      "!url": "http://alloyui.com/classes/ChartBase.html#event_markerEvent:mouseup"
     },
     "markerEvent:click": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a click event.",
      "!url": "http://alloyui.com/classes/ChartBase.html#event_markerEvent:click"
     },
     "toggleTooltip": {
      "!type": "fn(e: yui.Object)",
      "!doc": "Event listener for toggling the tooltip. If a tooltip is visible, hide it. If not, it\nwill create and show a tooltip based on the event object.",
      "!url": "http://alloyui.com/classes/ChartBase.html#method_toggleTooltip"
     },
     "hideTooltip": {
      "!type": "fn()",
      "!doc": "Hides the default tooltip",
      "!url": "http://alloyui.com/classes/ChartBase.html#method_hideTooltip"
     },
     "_getAllKeys": {
      "!type": "fn(dp: yui.Array) -> ?",
      "!doc": "Returns all the keys contained in a  `dataProvider`.",
      "!url": "http://alloyui.com/classes/ChartBase.html#method__getAllKeys"
     }
    }
   },
   "ChartLegend": {
    "!type": "fn()",
    "!proto": "widget.Widget",
    "!doc": "ChartLegend provides a legend for a chart.",
    "!url": "http://alloyui.com/classes/ChartLegend.html",
    "prototype": {
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the `Chart` instance.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_chart"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction in relation of the legend's layout. The `direction` of the legend is determined by its\n`position` value.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_direction"
     },
     "position": {
      "!type": "fn()",
      "!doc": "Indicates the position and direction of the legend. Possible values are `left`, `top`, `right` and `bottom`.\nValues of `left` and `right` values have a `direction` of `vertical`. Values of `top` and `bottom` values have\na `direction` of `horizontal`.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_position"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the legend. Depending on the implementation of the ChartLegend, this value is `readOnly`.\nBy default, the legend is included in the layout of the `Chart` that it references. Under this circumstance,\n`width` is always `readOnly`. When the legend is rendered in its own dom element, the `readOnly` status is\ndetermined by the direction of the legend. If the `position` is `left` or `right` or the `direction` is\n`vertical`, width is `readOnly`. If the position is `top` or `bottom` or the `direction` is `horizontal`,\nwidth can be explicitly set. If width is not explicitly set, the width will be determined by the width of the\nlegend's parent element.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "The height of the legend. Depending on the implementation of the ChartLegend, this value is `readOnly`.\nBy default, the legend is included in the layout of the `Chart` that it references. Under this circumstance,\n`height` is always `readOnly`. When the legend is rendered in its own dom element, the `readOnly` status is\ndetermined by the direction of the legend. If the `position` is `top` or `bottom` or the `direction` is\n`horizontal`, height is `readOnly`. If the position is `left` or `right` or the `direction` is `vertical`,\nheight can be explicitly set. If height is not explicitly set, the height will be determined by the width of the\nlegend's parent element.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_height"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of legend.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of legend.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_y"
     },
     "items": {
      "!type": "fn()",
      "!doc": "Array of items contained in the legend. Each item is an object containing the following properties:\n\n<dl>\n     <dt>node</dt><dd>Node containing text for the legend item.</dd>\n     <dt>marker</dt><dd>Shape for the legend item.</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_items"
     },
     "background": {
      "!type": "fn()",
      "!doc": "Background for the legend.",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_background"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Properties used to display and style the ChartLegend.  This attribute is inherited from `Renderer`.\nBelow are the default values:\n\n <dl>\n     <dt>gap</dt><dd>Distance, in pixels, between the `ChartLegend` instance and the chart's content. When `ChartLegend`\n     is rendered within a `Chart` instance this value is applied.</dd>\n     <dt>hAlign</dt><dd>Defines the horizontal alignment of the `items` in a `ChartLegend` rendered in a horizontal direction.\n     This value is applied when the instance's `position` is set to top or bottom. This attribute can be set to left, center\n     or right. The default value is center.</dd>\n     <dt>vAlign</dt><dd>Defines the vertical alignment of the `items` in a `ChartLegend` rendered in vertical direction. This\n     value is applied when the instance's `position` is set to left or right. The attribute can be set to top, middle or\n     bottom. The default value is middle.</dd>\n     <dt>item</dt><dd>Set of style properties applied to the `items` of the `ChartLegend`.\n         <dl>\n             <dt>hSpacing</dt><dd>Horizontal distance, in pixels, between legend `items`.</dd>\n             <dt>vSpacing</dt><dd>Vertical distance, in pixels, between legend `items`.</dd>\n             <dt>label</dt><dd>Properties for the text of an `item`.\n                 <dl>\n                     <dt>color</dt><dd>Color of the text. The default values is \"#808080\".</dd>\n                     <dt>fontSize</dt><dd>Font size for the text. The default value is \"85%\".</dd>\n                 </dl>\n             </dd>\n             <dt>marker</dt><dd>Properties for the `item` markers.\n                 <dl>\n                     <dt>width</dt><dd>Specifies the width of the markers.</dd>\n                     <dt>height</dt><dd>Specifies the height of the markers.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>background</dt><dd>Properties for the `ChartLegend` background.\n         <dl>\n             <dt>fill</dt><dd>Properties for the background fill.\n                 <dl>\n                     <dt>color</dt><dd>Color for the fill. The default value is \"#faf9f2\".</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>Properties for the background border.\n                 <dl>\n                     <dt>color</dt><dd>Color for the border. The default value is \"#dad8c9\".</dd>\n                     <dt>weight</dt><dd>Weight of the border. The default values is 1.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n</dl>",
      "!url": "http://alloyui.com/classes/ChartLegend.html#attribute_styles"
     }
    }
   },
   "ColumnSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ColumnSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "The ColumnSeries class renders columns positioned horizontally along a category or time axis. The columns'\nlengths are proportional to the values they represent along a vertical axis.\nand the relevant data points.",
    "!url": "http://alloyui.com/classes/ColumnSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/ColumnSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 12.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ColumnSeries.html#attribute_styles"
     }
    }
   },
   "ComboSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ComboSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The ComboSeries class renders a combination of lines, plots and area fills in a single series.\nEach series type has a corresponding boolean attribute indicating if it is rendered. By default,\nlines and plots are rendered and area is not.",
    "!url": "http://alloyui.com/classes/ComboSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_showAreaFill"
     },
     "showLines": {
      "!type": "fn()",
      "!doc": "Indicates whether lines are displayed.",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_showLines"
     },
     "showMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether markers are displayed.",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_showMarkers"
     },
     "marker": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the markers. These styles can also\nbe accessed through the `styles` attribute. Below are default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the\n             graph. The color will be retrieved from the below array:<br/>\n             `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph.\n             The color will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>\n     <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_marker"
     },
     "line": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the lines. These styles can also be accessed through the `styles` attribute.\nBelow are the default values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color\n     will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value\n     between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default\n     value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default\n     value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default\n     value is 10.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_line"
     },
     "area": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the area fills. These styles can also be accessed through the `styles` attribute.\nBelow are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the\n     graph. The color will be retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_area"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for the series. Contains a key indexed hash of the following:\n <dl>\n     <dt>marker</dt><dd>Style properties for the markers in the series. Specific style attributes are listed\n     <a href=\"#attr_marker\">here</a>.</dd>\n     <dt>line</dt><dd>Style properties for the lines in the series. Specific\n     style attributes are listed <a href=\"#attr_line\">here</a>.</dd>\n     <dt>area</dt><dd>Style properties for the area fills in the series. Specific style attributes are listed\n     <a href=\"#attr_area\">here</a>.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/ComboSeries.html#attribute_styles"
     }
    }
   },
   "ComboSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ComboSplineSeries",
    "!proto": "charts.ComboSeries",
    "!doc": "The ComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, splines and plots\nare rendered and areaspline is not.",
    "!url": "http://alloyui.com/classes/ComboSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/ComboSplineSeries.html#attribute_type"
     }
    }
   },
   "Graph": {
    "!type": "fn() -> +charts.Graph",
    "!proto": "widget.Widget",
    "!doc": "Graph manages and contains series instances for a `CartesianChart`\ninstance.",
    "!url": "http://alloyui.com/classes/Graph.html",
    "prototype": {
     "getSeriesByIndex": {
      "!type": "fn(val: number) -> ?",
      "!doc": "Returns a series instance based on an index.",
      "!url": "http://alloyui.com/classes/Graph.html#method_getSeriesByIndex"
     },
     "getSeriesByKey": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Returns a series instance based on a key value.",
      "!url": "http://alloyui.com/classes/Graph.html#method_getSeriesByKey"
     },
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the chart instance using the graph.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_chart"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series. When setting the `seriesCollection` the array can contain a combination of either\n`CartesianSeries` instances or object literals with properties that will define a series.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_seriesCollection"
     },
     "showBackground": {
      "!type": "fn()",
      "!doc": "Indicates whether the `Graph` has a background.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_showBackground"
     },
     "seriesDictionary": {
      "!type": "fn()",
      "!doc": "Read-only hash lookup for all series on in the `Graph`.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_seriesDictionary"
     },
     "horizontalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the horizontal `Gridlines` instance.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_horizontalGridlines"
     },
     "verticalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the vertical `Gridlines` instance.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_verticalGridlines"
     },
     "background": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for the background.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_background"
     },
     "gridlines": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for gridlines.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_gridlines"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for series.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_graphic"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_groupMarkers"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing a background. Below are the default values:\n <dl>\n     <dt>background</dt><dd>An object containing the following values:\n         <dl>\n             <dt>fill</dt><dd>Defines the style properties for the fill. Contains the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is #faf9f2.</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background fill.\n                     The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>Defines the style properties for the border. Contains the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is #dad8c9.</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background border.\n                     The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://alloyui.com/classes/Graph.html#attribute_styles"
     }
    }
   },
   "Gridlines": {
    "!type": "fn(config: yui.Object) -> +charts.Gridlines",
    "!proto": "base.Base",
    "!doc": "Gridlines draws gridlines on a Graph.",
    "!url": "http://alloyui.com/classes/Gridlines.html",
    "prototype": {
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction of the gridline.",
      "!url": "http://alloyui.com/classes/Gridlines.html#attribute_direction"
     },
     "axis": {
      "!type": "fn()",
      "!doc": "Indicate the `Axis` in which to bind\nthe gridlines.",
      "!url": "http://alloyui.com/classes/Gridlines.html#attribute_axis"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Indicates the `Graph` in which the gridlines\nare drawn.",
      "!url": "http://alloyui.com/classes/Gridlines.html#attribute_graph"
     },
     "count": {
      "!type": "fn()",
      "!doc": "Indicates the number of gridlines to display. If no value is set, gridlines will equal the number of ticks in\nthe corresponding axis.",
      "!url": "http://alloyui.com/classes/Gridlines.html#attribute_count"
     }
    }
   },
   "LineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.LineSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The LineSeries class renders quantitative data on a graph by connecting relevant data points.",
    "!url": "http://alloyui.com/classes/LineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/LineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the\ndefault values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series\n     on the graph. The color will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default\n     value is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default\n     value is 10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing\n     or null value between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed.\n     The default value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the\n     dash. The default value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between\n     dashes. The default value is 10.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/LineSeries.html#attribute_styles"
     }
    }
   },
   "MarkerSeries": {
    "!type": "fn(config: yui.Object) -> +charts.MarkerSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The MarkerSeries class renders quantitative data by plotting relevant data points\non a graph.",
    "!url": "http://alloyui.com/classes/MarkerSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/MarkerSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `Renderer`. Below are the default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on\n             the graph. The color will be retrieved from the below array:<br/>\n             `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on\n             the graph. The color will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>\n     <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/MarkerSeries.html#attribute_styles"
     }
    }
   },
   "NumericImpl": {
    "!type": "fn() -> +charts.NumericImpl",
    "!doc": "NumericImpl contains logic for numeric data. NumericImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"NumericAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/NumericImpl.html",
    "prototype": {
     "alwaysShowZero": {
      "!type": "fn()",
      "!doc": "Indicates whether 0 should always be displayed.",
      "!url": "http://alloyui.com/classes/NumericImpl.html#attribute_alwaysShowZero"
     },
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or an `HTMLElement`. The default\nimplementation of the method returns a `String`. The output of this method will be rendered to the DOM using\n`appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override\nthe Data' `appendLabelFunction` to accept html as a `String`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>Object containing properties used to format the label. (optional)</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/NumericImpl.html#attribute_labelFunction"
     },
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Object containing properties used by the `labelFunction` to format a\nlabel.",
      "!url": "http://alloyui.com/classes/NumericImpl.html#attribute_labelFormat"
     },
     "roundingMethod": {
      "!type": "fn()",
      "!doc": "Indicates how to round unit values.\n  <dl>\n      <dt>niceNumber</dt><dd>Units will be smoothed based on the number of ticks and data range.</dd>\n      <dt>auto</dt><dd>If the range is greater than 1, the units will be rounded.</dd>\n      <dt>numeric value</dt><dd>Units will be equal to the numeric value.</dd>\n      <dt>null</dt><dd>No rounding will occur.</dd>\n  </dl>",
      "!url": "http://alloyui.com/classes/NumericImpl.html#attribute_roundingMethod"
     },
     "": {
      "!type": "fn(value: yui.Object, format: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://alloyui.com/classes/NumericImpl.html"
     },
     "getTotalByKey": {
      "!type": "fn(key: string) -> ?",
      "!doc": "Returns the sum of all values per key.",
      "!url": "http://alloyui.com/classes/NumericImpl.html#method_getTotalByKey"
     },
     "getOrigin": {
      "!type": "fn() -> ?",
      "!doc": "Returns the value corresponding to the origin on the axis.",
      "!url": "http://alloyui.com/classes/NumericImpl.html#method_getOrigin"
     }
    }
   },
   "OHLCSeries": {
    "!type": "fn(config: yui.Object) -> +charts.OHLCSeries",
    "!proto": "charts.RangeSeries",
    "!doc": "The OHLCSeries class renders lines representing the open, high, low and close\nvalues for a chart.",
    "!url": "http://alloyui.com/classes/OHLCSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/OHLCSeries.html#attribute_type"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://alloyui.com/classes/OHLCSeries.html#attribute_graphic"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `RangeSeries`. Below are the default values:\n <dl>\n     <dt>upmarker</dt><dd>Properties for a marker representing a period that closes higher than it opens.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#00aa00\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>downmarker</dt><dd>Properties for a marker representing a period that opens higher than it closes.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#aa0000\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://alloyui.com/classes/OHLCSeries.html#attribute_styles"
     }
    }
   },
   "PieChart": {
    "!type": "fn() -> +charts.PieChart",
    "!proto": "charts.ChartBase",
    "!doc": "The PieChart class creates a pie chart",
    "!url": "http://alloyui.com/classes/PieChart.html",
    "prototype": {
     "getSeriesItem": {
      "!type": "fn(series, index) -> ?",
      "!doc": "Returns an object literal containing a categoryItem and a valueItem for a given series index.",
      "!url": "http://alloyui.com/classes/PieChart.html#method_getSeriesItem"
     },
     "_getAriaMessage": {
      "!type": "fn(key: number) -> ?",
      "!doc": "Returns the appropriate message based on the key press.",
      "!url": "http://alloyui.com/classes/PieChart.html#method__getAriaMessage"
     },
     "ariaDescription": {
      "!type": "fn()",
      "!doc": "Sets the aria description for the chart.",
      "!url": "http://alloyui.com/classes/PieChart.html#attribute_ariaDescription"
     },
     "axes": {
      "!type": "fn()",
      "!doc": "Axes to appear in the chart.",
      "!url": "http://alloyui.com/classes/PieChart.html#attribute_axes"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series to appear on the chart. This can be an array of Series instances or object literals\nused to describe a Series instance.",
      "!url": "http://alloyui.com/classes/PieChart.html#attribute_seriesCollection"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Type of chart when there is no series collection specified.",
      "!url": "http://alloyui.com/classes/PieChart.html#attribute_type"
     }
    }
   },
   "PieSeries": {
    "!type": "fn(config: yui.Object) -> +charts.PieSeries",
    "!proto": "charts.SeriesBase",
    "!doc": "PieSeries visualizes data as a circular chart divided into wedges which represent data as a\npercentage of a whole.",
    "!url": "http://alloyui.com/classes/PieSeries.html",
    "prototype": {
     "": {
      "!type": "fn()",
      "!doc": "The legend for the chart.",
      "!url": "http://alloyui.com/classes/PieSeries.html"
     },
     "getTotalValues": {
      "!type": "fn() -> ?",
      "!doc": "Returns the sum of all values for the series.",
      "!url": "http://alloyui.com/classes/PieSeries.html#method_getTotalValues"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_type"
     },
     "order": {
      "!type": "fn()",
      "!doc": "Order of this instance of this `type`.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_order"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to the `Graph` in which the series is drawn into.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_graph"
     },
     "categoryAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\nseries values to the graph.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_categoryAxis"
     },
     "categoryKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe category `Axis` instance.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_categoryKey"
     },
     "valueKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe value `Axis` instance.",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_valueKey"
     },
     "categoryDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying category data",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_categoryDisplayName"
     },
     "valueDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying value data",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_valueDisplayName"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are  the default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>colors</dt><dd>An array of colors to be used for the marker fills. The color for each marker  is\n             retrieved from the array below:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alphas</dt><dd>An array of alpha references (Number from 0 to 1) indicating the opacity of each marker\n             fill. The default value is [1].</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>An array of colors to be used for the marker borders. The color for each marker is\n             retrieved from the array below:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/PieSeries.html#attribute_styles"
     }
    }
   },
   "RangeSeries": {
    "!type": "fn(config: yui.Object) -> +charts.RangeSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "An abstract class for creating range series instances.\nRangeSeries is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CandlestickSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"OHLCSeries\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/RangeSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/RangeSeries.html#attribute_type"
     },
     "ohlc": {
      "!type": "fn()",
      "!doc": "Values to be used for open, high, low and close keys.",
      "!url": "http://alloyui.com/classes/RangeSeries.html#attribute_ohlc"
     }
    }
   },
   "Renderer": {
    "!type": "fn()",
    "!doc": "The Renderer class is a base class for chart components that use the `styles`\nattribute.",
    "!url": "http://alloyui.com/classes/Renderer.html",
    "prototype": {
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for class",
      "!url": "http://alloyui.com/classes/Renderer.html#attribute_styles"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://alloyui.com/classes/Renderer.html#attribute_graphic"
     }
    }
   },
   "SeriesBase": {
    "!type": "fn(config: yui.Object) -> +charts.SeriesBase",
    "!proto": "base.Base",
    "!doc": "An abstract class for creating series instances.\nSeriesBase is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CartesianSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"PieSeries\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/SeriesBase.html",
    "prototype": {
     "getTotalValues": {
      "!type": "fn() -> ?",
      "!doc": "Returns the sum of all values for the series.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#method_getTotalValues"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Returns the height of the parent graph",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_height"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_graphic"
     },
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the `Chart` application. If no `Chart` application is present,\na reference to the `Graphic` instance that the series is drawn into will be returned.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_chart"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to the `Graph` in which the series is drawn into.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_graph"
     },
     "rendered": {
      "!type": "fn()",
      "!doc": "Indicates whether the Series has been through its initial set up.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_rendered"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether to show the series",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_visible"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://alloyui.com/classes/SeriesBase.html#attribute_groupMarkers"
     }
    }
   },
   "SplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.SplineSeries",
    "!proto": "charts.LineSeries",
    "!doc": "SplineSeries renders a graph with data points connected by a curve.",
    "!url": "http://alloyui.com/classes/SplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/SplineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing lines. This attribute is inherited from `Renderer`.\nBelow are the default values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on\n     the graph. The color will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value\n     is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is\n     10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null\n     value between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The\n     default value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash.\n     The default value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes.\n     The default value is 10.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/SplineSeries.html#attribute_styles"
     }
    }
   },
   "StackedAreaSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedAreaSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "StackedAreaSeries area fills to display data showing its contribution to a whole.",
    "!url": "http://alloyui.com/classes/StackedAreaSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedAreaSeries.html#attribute_type"
     }
    }
   },
   "StackedAreaSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedAreaSplineSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "StackedAreaSplineSeries creates a stacked area chart with points data points connected by a curve.",
    "!url": "http://alloyui.com/classes/StackedAreaSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedAreaSplineSeries.html#attribute_type"
     }
    }
   },
   "StackedBarSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedBarSeries",
    "!proto": "charts.BarSeries",
    "!doc": "The StackedBarSeries renders bar chart in which series are stacked horizontally to show\ntheir contribution to the cumulative total.",
    "!url": "http://alloyui.com/classes/StackedBarSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedBarSeries.html#attribute_type"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of the series",
      "!url": "http://alloyui.com/classes/StackedBarSeries.html#attribute_direction"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `BarSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>height</dt><dd>indicates the width of the marker. The default value is 24.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/StackedBarSeries.html#attribute_styles"
     }
    }
   },
   "StackedColumnSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedColumnSeries",
    "!proto": "charts.ColumnSeries",
    "!doc": "The StackedColumnSeries renders column chart in which series are stacked vertically to show\ntheir contribution to the cumulative total.",
    "!url": "http://alloyui.com/classes/StackedColumnSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedColumnSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `ColumnSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 24.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://alloyui.com/classes/StackedColumnSeries.html#attribute_styles"
     }
    }
   },
   "StackedComboSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedComboSeries",
    "!proto": "charts.ComboSeries",
    "!doc": "The StackedComboSeries class renders a combination of lines, plots and area fills in a single series. Series\nare stacked along the value axis to indicate each series contribution to a cumulative total. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are\nrendered.",
    "!url": "http://alloyui.com/classes/StackedComboSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedComboSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://alloyui.com/classes/StackedComboSeries.html#attribute_showAreaFill"
     }
    }
   },
   "StackedComboSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedComboSplineSeries",
    "!proto": "charts.StackedComboSeries",
    "!doc": "The StackedComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Series\nare stacked along the value axis to indicate each series contribution to a cumulative total. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are\nrendered.",
    "!url": "http://alloyui.com/classes/StackedComboSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedComboSplineSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://alloyui.com/classes/StackedComboSplineSeries.html#attribute_showAreaFill"
     }
    }
   },
   "StackedLineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedLineSeries",
    "!proto": "charts.LineSeries",
    "!doc": "StackedLineSeries creates line graphs in which the different series are stacked along a value axis\nto indicate their contribution to a cumulative total.",
    "!url": "http://alloyui.com/classes/StackedLineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedLineSeries.html#attribute_type"
     }
    }
   },
   "StackedMarkerSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedMarkerSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "StackedMarkerSeries plots markers with different series stacked along the value axis to indicate each\nseries' contribution to a cumulative total.",
    "!url": "http://alloyui.com/classes/StackedMarkerSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedMarkerSeries.html#attribute_type"
     }
    }
   },
   "StackedSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedSplineSeries",
    "!proto": "charts.SplineSeries",
    "!doc": "StackedSplineSeries creates spline graphs in which the different series are stacked along a value axis\nto indicate their contribution to a cumulative total.",
    "!url": "http://alloyui.com/classes/StackedSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://alloyui.com/classes/StackedSplineSeries.html#attribute_type"
     }
    }
   },
   "TimeImpl": {
    "!type": "fn() -> +charts.TimeImpl",
    "!doc": "TimeImpl contains logic for time data. TimeImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"TimeAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://alloyui.com/classes/TimeImpl.html",
    "prototype": {
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or an `HTMLElement`. The default\nimplementation of the method returns a `String`. The output of this method will be rendered to the DOM using\n`appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override\nthe Axis' `appendLabelFunction` to accept html as a `String`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>STRFTime string used to format the label. (optional)</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/TimeImpl.html#attribute_labelFunction"
     },
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Pattern used by the `labelFunction` to format a label.",
      "!url": "http://alloyui.com/classes/TimeImpl.html#attribute_labelFormat"
     },
     "formatLabel": {
      "!type": "fn(value: yui.Object, format: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://alloyui.com/classes/TimeImpl.html#method_formatLabel"
     }
    }
   },
   "ClassNameManager": {
    "!type": "fn()",
    "!doc": "A singleton class providing:\n\n<ul>\n   <li>Easy creation of prefixed class names</li>\n   <li>Caching of previously created class names for improved performance.</li>\n</ul>",
    "!url": "http://alloyui.com/classes/ClassNameManager.html",
    "prototype": {
     "undefined": {
      "!type": "fn()",
      "!doc": "Tests to ensures that clicks and/or touches outside the chart are not halted.",
      "!url": "http://alloyui.com/classes/ClassNameManager.html"
     }
    }
   }
  },
  "classnamemanager": {
   "ClassNameManager": {
    "!type": "fn()",
    "!doc": "A singleton class providing:\n\n<ul>\n   <li>Easy creation of prefixed class names</li>\n   <li>Caching of previously created class names for improved performance.</li>\n</ul>",
    "!url": "http://alloyui.com/classes/ClassNameManager.html",
    "classNamePrefix": {
     "!type": "string",
     "!doc": "Configuration property indicating the prefix for all CSS class names in this YUI instance.",
     "!url": "http://alloyui.com/classes/ClassNameManager.html#property_classNamePrefix"
    },
    "classNameDelimiter": {
     "!type": "string",
     "!doc": "Configuration property indicating the delimiter used to compose all CSS class names in\nthis YUI instance.",
     "!url": "http://alloyui.com/classes/ClassNameManager.html#property_classNameDelimiter"
    },
    "prototype": {
     "getClassName": {
      "!type": "fn(classnameSection?: string, skipPrefix: bool)",
      "!doc": "Returns a class name prefixed with the the value of the\n<code>Y.config.classNamePrefix</code> attribute + the provided strings.\nUses the <code>Y.config.classNameDelimiter</code> attribute to delimit the\nprovided strings. E.g. Y.ClassNameManager.getClassName('foo','bar'); // yui-foo-bar",
      "!url": "http://alloyui.com/classes/ClassNameManager.html#method_getClassName"
     }
    }
   }
  },
  "collection": {
   "Array": {
    "!type": "fn(thing: Any, startIndex?: number, force?: bool) -> +yui.Array",
    "!doc": "Provides utility methods for working with arrays. Additional array helpers can\nbe found in the `collection` and `array-extras` modules.\n\n`Y.Array(thing)` returns a native array created from _thing_. Depending on\n_thing_'s type, one of the following will happen:\n\n  * Arrays are returned unmodified unless a non-zero _startIndex_ is\n    specified.\n  * Array-like collections (see `Array.test()`) are converted to arrays.\n  * For everything else, a new array is created with _thing_ as the sole\n    item.\n\nNote: elements that are also collections, such as `<form>` and `<select>`\nelements, are not automatically converted to arrays. To force a conversion,\npass `true` as the value of the _force_ parameter.",
    "!url": "http://alloyui.com/classes/Array.html",
    "lastIndexOf": {
     "!type": "fn(a: yui.Array, val: Any, fromIndex?: number) -> number",
     "!doc": "Returns the index of the last item in the array that contains the specified\nvalue, or `-1` if the value isn't found.",
     "!url": "http://alloyui.com/classes/Array.html#method_lastIndexOf"
    },
    "unique": {
     "!type": "fn(array: yui.Array, testFn?: fn()) -> +yui.Array",
     "!doc": "Returns a copy of the input array with duplicate items removed.\n\nNote: If the input array only contains strings, the `Y.Array.dedupe()` method is\na much faster alternative.",
     "!url": "http://alloyui.com/classes/Array.html#method_unique"
    },
    "filter": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "Executes the supplied function on each item in the array. Returns a new array\ncontaining the items for which the supplied function returned a truthy value.",
     "!url": "http://alloyui.com/classes/Array.html#method_filter"
    },
    "reject": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "The inverse of `Array.filter()`. Executes the supplied function on each item.\nReturns a new array containing the items for which the supplied function\nreturned `false`.",
     "!url": "http://alloyui.com/classes/Array.html#method_reject"
    },
    "every": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> bool",
     "!doc": "Executes the supplied function on each item in the array. Iteration stops if the\nsupplied function does not return a truthy value.",
     "!url": "http://alloyui.com/classes/Array.html#method_every"
    },
    "map": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "Executes the supplied function on each item in the array and returns a new array\ncontaining all the values returned by the supplied function.",
     "!url": "http://alloyui.com/classes/Array.html#method_map"
    },
    "reduce": {
     "!type": "fn(a: yui.Array, init: Any, f: fn(), o?: yui.Object) -> +Any",
     "!doc": "Executes the supplied function on each item in the array, \"folding\" the array\ninto a single value.",
     "!url": "http://alloyui.com/classes/Array.html#method_reduce"
    },
    "find": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Object",
     "!doc": "Executes the supplied function on each item in the array, searching for the\nfirst item that matches the supplied function.",
     "!url": "http://alloyui.com/classes/Array.html#method_find"
    },
    "grep": {
     "!type": "fn(a: yui.Array, pattern: RegExp) -> +yui.Array",
     "!doc": "Iterates over an array, returning a new array of all the elements that match the\nsupplied regular expression.",
     "!url": "http://alloyui.com/classes/Array.html#method_grep"
    },
    "partition": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Object",
     "!doc": "Partitions an array into two new arrays, one with the items for which the\nsupplied function returns `true`, and one with the items for which the function\nreturns `false`.",
     "!url": "http://alloyui.com/classes/Array.html#method_partition"
    },
    "zip": {
     "!type": "fn(a: yui.Array, a2: yui.Array) -> +yui.Array",
     "!doc": "Creates an array of arrays by pairing the corresponding elements of two arrays\ntogether into a new array.",
     "!url": "http://alloyui.com/classes/Array.html#method_zip"
    },
    "flatten": {
     "!type": "fn(a: yui.Array) -> +yui.Array",
     "!doc": "Flattens an array of nested arrays at any abitrary depth into a single, flat\narray.",
     "!url": "http://alloyui.com/classes/Array.html#method_flatten"
    },
    "invoke": {
     "!type": "fn(items: yui.Array, name: string, args?: Any) -> +yui.Array",
     "!doc": "Executes a named method on each item in an array of objects. Items in the array\nthat do not have a function by that name will be skipped.",
     "!url": "http://alloyui.com/classes/Array.html#method_invoke"
    }
   },
   "ArrayList": {
    "!type": "fn(items: yui.Array) -> +collection.ArrayList",
    "!doc": "Generic ArrayList class for managing lists of items and iterating operations\nover them.  The targeted use for this class is for augmentation onto a\nclass that is responsible for managing multiple instances of another class\n(e.g. NodeList for Nodes).  The recommended use is to augment your class with\nArrayList, then use ArrayList.addMethod to mirror the API of the constituent\nitems on the list's API.\n\nThe default implementation creates immutable lists, but mutability can be\nprovided via the arraylist-add submodule or by implementing mutation methods\ndirectly on the augmented class's prototype.",
    "!url": "http://alloyui.com/classes/ArrayList.html",
    "prototype": {
     "add": {
      "!type": "fn(item: Mixed, index: number) -> !this",
      "!doc": "Add a single item to the ArrayList.  Does not prevent duplicates.",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_add"
     },
     "remove": {
      "!type": "fn(needle: Mixed, all: bool, comparator: fn()) -> !this",
      "!doc": "Removes first or all occurrences of an item to the ArrayList.  If a\ncomparator is not provided, uses itemsAreEqual method to determine\nmatches.",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_remove"
     },
     "itemsAreEqual": {
      "!type": "fn(a: Mixed, b: Mixed) -> bool",
      "!doc": "Default comparator for items stored in this list.  Used by remove().",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_itemsAreEqual"
     },
     "filter": {
      "!type": "fn(validator: fn()) -> +collection.ArrayList",
      "!doc": "<p>Create a new ArrayList (or augmenting class instance) from a subset\nof items as determined by the boolean function passed as the\nargument.  The original ArrayList is unchanged.</p>\n\n<p>The validator signature is <code>validator( item )</code>.</p>",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_filter"
     },
     "item": {
      "!type": "fn(i: Integer) -> +Mixed",
      "!doc": "Get an item by index from the list.  Override this method if managing a\nlist of objects that have a different public representation (e.g. Node\ninstances vs DOM nodes).  The iteration methods that accept a user\nfunction will use this method for access list items for operation.",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_item"
     },
     "each": {
      "!type": "fn(fn: fn(), context: Mixed) -> !this",
      "!doc": "<p>Execute a function on each item of the list, optionally providing a\ncustom execution context.  Default context is the item.</p>\n\n<p>The callback signature is <code>callback( item, index )</code>.</p>",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_each"
     },
     "some": {
      "!type": "fn(fn: fn(), context: Mixed) -> bool",
      "!doc": "<p>Execute a function on each item of the list, optionally providing a\ncustom execution context.  Default context is the item.</p>\n\n<p>The callback signature is <code>callback( item, index )</code>.</p>\n\n<p>Unlike <code>each</code>, if the callback returns true, the\niteration will stop.</p>",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_some"
     },
     "indexOf": {
      "!type": "fn(needle: Mixed) -> +Integer",
      "!doc": "Finds the first index of the needle in the managed array of items.",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_indexOf"
     },
     "size": {
      "!type": "fn() -> +Integer",
      "!doc": "How many items are in this list?",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_size"
     },
     "isEmpty": {
      "!type": "fn() -> bool",
      "!doc": "Is this instance managing any items?",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_isEmpty"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Provides an array-like representation for JSON.stringify.",
      "!url": "http://alloyui.com/classes/ArrayList.html#method_toJSON"
     }
    },
    "addMethod": {
     "!type": "fn(dest: yui.Object, name: string)",
     "!doc": "<p>Adds a pass through method to dest (typically the prototype of a list\nclass) that calls the named method on each item in the list with\nwhatever parameters are passed in.  Allows for API indirection via list\ninstances.</p>\n\n<p>Accepts a single string name or an array of string names.</p>\n\n<pre><code>list.each( function ( item ) {\n    item.methodName( 1, 2, 3 );\n} );\n// becomes\nlist.methodName( 1, 2, 3 );</code></pre>\n\n<p>Additionally, the pass through methods use the item retrieved by the\n<code>_item</code> method in case there is any special behavior that is\nappropriate for API mirroring.</p>\n\n<p>If the iterated method returns a value, the return value from the\nadded method will be an array of values with each value being at the\ncorresponding index for that item.  If the iterated method does not\nreturn a value, the added method will be chainable.",
     "!url": "http://alloyui.com/classes/ArrayList.html#method_addMethod"
    }
   }
  },
  "color": {
   "Color": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion.\n\n    Y.Color.toRGB('f00'); // rgb(255, 0, 0)\n\n    Y.Color.toHex('rgb(255, 255, 0)'); // #ffff00",
    "!url": "http://alloyui.com/classes/Color.html",
    "KEYWORDS": {
     "!type": "+yui.Object",
     "!url": "http://alloyui.com/classes/Color.html#property_KEYWORDS"
    },
    "REGEX_HEX": {
     "!type": "+RegExp",
     "!doc": "NOTE: `(\\ufffe)?` is added to the Regular Expression to carve out a\nplace for the alpha channel that is returned from toArray\nwithout compromising any usage of the Regular Expression",
     "!url": "http://alloyui.com/classes/Color.html#property_REGEX_HEX"
    },
    "REGEX_HEX3": {
     "!type": "+RegExp",
     "!doc": "NOTE: `(\\ufffe)?` is added to the Regular Expression to carve out a\nplace for the alpha channel that is returned from toArray\nwithout compromising any usage of the Regular Expression",
     "!url": "http://alloyui.com/classes/Color.html#property_REGEX_HEX3"
    },
    "REGEX_RGB": {
     "!type": "+RegExp",
     "!url": "http://alloyui.com/classes/Color.html#property_REGEX_RGB"
    },
    "STR_HEX": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.html#property_STR_HEX"
    },
    "STR_RGB": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.html#property_STR_RGB"
    },
    "STR_RGBA": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.html#property_STR_RGBA"
    },
    "TYPES": {
     "!type": "+yui.Object",
     "!url": "http://alloyui.com/classes/Color.html#property_TYPES"
    },
    "CONVERTS": {
     "!type": "+yui.Object",
     "!url": "http://alloyui.com/classes/Color.html#property_CONVERTS"
    },
    "prototype": {
     "convert": {
      "!type": "fn(str: string, to: string) -> string",
      "!doc": "Converts the provided string to the provided type.\nYou can use the `Y.Color.TYPES` to get a valid `to` type.\nIf the color cannot be converted, the original color will be returned.",
      "!url": "http://alloyui.com/classes/Color.html#method_convert"
     },
     "toHex": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to a hex value string",
      "!url": "http://alloyui.com/classes/Color.html#method_toHex"
     },
     "toRGB": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an RGB value string",
      "!url": "http://alloyui.com/classes/Color.html#method_toRGB"
     },
     "toRGBA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an RGB value string",
      "!url": "http://alloyui.com/classes/Color.html#method_toRGBA"
     },
     "toArray": {
      "!type": "fn(str: string) -> +yui.Array",
      "!doc": "Converts the provided color string to an array of values where the\n    last value is the alpha value. Will return an empty array if\n    the provided string is not able to be parsed.\n\n    NOTE: `(\\ufffe)?` is added to `HEX` and `HEX3` Regular Expressions to\n    carve out a place for the alpha channel that is returned from\n    toArray without compromising any usage of the Regular Expression\n\n    Y.Color.toArray('fff');              // ['ff', 'ff', 'ff', 1]\n    Y.Color.toArray('rgb(0, 0, 0)');     // ['0', '0', '0', 1]\n    Y.Color.toArray('rgba(0, 0, 0, 0)'); // ['0', '0', '0', 1]",
      "!url": "http://alloyui.com/classes/Color.html#method_toArray"
     },
     "fromArray": {
      "!type": "fn(arr: yui.Array, template: string) -> string",
      "!doc": "Converts the array of values to a string based on the provided template.",
      "!url": "http://alloyui.com/classes/Color.html#method_fromArray"
     },
     "findType": {
      "!type": "fn(str: string) -> string",
      "!doc": "Finds the value type based on the str value provided.",
      "!url": "http://alloyui.com/classes/Color.html#method_findType"
     }
    }
   },
   "Color.Harmony": {
    "!type": "fn()",
    "!doc": "Color Harmony provides methods useful for color combination discovery.",
    "!url": "http://alloyui.com/classes/Color.Harmony.html",
    "prototype": {
     "getComplementary": {
      "!type": "fn(str: string, to?: string) -> +yui.Array",
      "!doc": "Returns an Array of two colors. The first color in the Array\n  will be the color passed in. The second will be the\n  complementary color of the color provided",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getComplementary"
     },
     "getSplit": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of three colors. The first color in the Array\n  will be the color passed in. The second two will be split\n  complementary colors.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getSplit"
     },
     "getAnalogous": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of five colors. The first color in the Array\n  will be the color passed in. The remaining four will be\n  analogous colors two in either direction from the initially\n  provided color.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getAnalogous"
     },
     "getTriad": {
      "!type": "fn(str: string, to?: string) -> string",
      "!doc": "Returns an Array of three colors. The first color in the Array\n  will be the color passed in. The second two will be equidistant\n  from the start color and each other.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getTriad"
     },
     "getTetrad": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of four colors. The first color in the Array\n  will be the color passed in. The remaining three colors are\n  equidistant offsets from the starting color and each other.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getTetrad"
     },
     "getSquare": {
      "!type": "fn(str: string, to?: string) -> string",
      "!doc": "Returns an Array of four colors. The first color in the Array\n  will be the color passed in. The remaining three colors are\n  equidistant offsets from the starting color and each other.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getSquare"
     },
     "getMonochrome": {
      "!type": "fn(str: string, count?: number, to?: string) -> string",
      "!doc": "Calculates lightness offsets resulting in a monochromatic Array\n  of values.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getMonochrome"
     },
     "getSimilar": {
      "!type": "fn(str: string, offset?: number, count?: number, to?: string) -> string",
      "!doc": "Creates an Array of similar colors. Returned Array is prepended\n   with the color provided followed a number of colors decided\n   by count",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getSimilar"
     },
     "getOffset": {
      "!type": "fn(str: string, adjust: yui.Object, to?: string) -> string",
      "!doc": "Adjusts the provided color by the offset(s) given. You may\n  adjust hue, saturation, and/or luminance in one step.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getOffset"
     },
     "getBrightness": {
      "!type": "fn(str: string) -> number",
      "!doc": "Returns 0 - 100 percentage of brightness from `0` (black) being the\n  darkest to `100` (white) being the brightest.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getBrightness"
     },
     "getSimilarBrightness": {
      "!type": "fn(str: string, match: string, to?: string) -> string",
      "!doc": "Returns a new color value with adjusted luminance so that the\n  brightness of the return color matches the perceived brightness\n  of the `match` color provided.",
      "!url": "http://alloyui.com/classes/Color.Harmony.html#method_getSimilarBrightness"
     }
    }
   },
   "Color.HSL": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion to hsl values.\n\n    Y.Color.toHSL('f00'); // hsl(0, 100%, 50%)\n\n    Y.Color.toHSLA('rgb(255, 255, 0'); // hsla(60, 100%, 50%, 1)",
    "!url": "http://alloyui.com/classes/Color.HSL.html",
    "REGEX_HSL": {
     "!type": "+RegExp",
     "!url": "http://alloyui.com/classes/Color.HSL.html#property_REGEX_HSL"
    },
    "STR_HSL": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.HSL.html#property_STR_HSL"
    },
    "STR_HSLA": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.HSL.html#property_STR_HSLA"
    },
    "prototype": {
     "toHSL": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSL string.",
      "!url": "http://alloyui.com/classes/Color.HSL.html#method_toHSL"
     },
     "toHSLA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSLA string.",
      "!url": "http://alloyui.com/classes/Color.HSL.html#method_toHSLA"
     }
    }
   },
   "Color.HSV": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion hsv values.\n\n    Y.Color.toHSV('f00'); // hsv(0, 100%, 100%)\n\n    Y.Color.toHSVA('rgb(255, 255, 0'); // hsva(60, 100%, 100%, 1)",
    "!url": "http://alloyui.com/classes/Color.HSV.html",
    "REGEX_HSV": {
     "!type": "+RegExp",
     "!url": "http://alloyui.com/classes/Color.HSV.html#property_REGEX_HSV"
    },
    "STR_HSV": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.HSV.html#property_STR_HSV"
    },
    "STR_HSVA": {
     "!type": "string",
     "!url": "http://alloyui.com/classes/Color.HSV.html#property_STR_HSVA"
    },
    "prototype": {
     "toHSV": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSV string.",
      "!url": "http://alloyui.com/classes/Color.HSV.html#method_toHSV"
     },
     "toHSVA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSVA string.",
      "!url": "http://alloyui.com/classes/Color.HSV.html#method_toHSVA"
     }
    }
   },
   "Console": {
    "!type": "fn(config?: yui.Object) -> +console.Console",
    "!proto": "widget.Widget",
    "!doc": "A basic console that displays messages logged throughout your application.",
    "!url": "http://alloyui.com/classes/Console.html",
    "prototype": {
     "undefined": {
      "!type": "fn(callback: fn(), accumulator: Mixed) -> +Mixed",
      "!doc": "An `Array#reduce` like method.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "": {
      "!type": "?",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "decompilation": {
      "!type": "fn()",
      "!doc": "Detect if functions support decompilation.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "descriptors": {
      "!type": "fn()",
      "!doc": "Detect ES5+ property descriptor API.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "getAllKeys": {
      "!type": "fn()",
      "!doc": "Detect ES5+ Object.getOwnPropertyNames().",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "iteratesOwnLast": {
      "!type": "fn()",
      "!doc": "Detect if own properties are iterated before inherited properties (all but IE < 9).",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "nodeClass": {
      "!type": "fn()",
      "!doc": "Detect if a node's [[Class]] is resolvable (all but IE < 9)\nand that the JS engine errors when attempting to coerce an object to a\nstring without a `toString` property value of `typeof` \"function\".",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "abort": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Aborts all benchmarks in the suite.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "clone": {
      "!type": "fn(options: yui.Object) -> +yui.Object",
      "!doc": "Creates a new suite with cloned benchmarks.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "filter": {
      "!type": "fn(callback: fn()) -> +yui.Object",
      "!doc": "An `Array#filter` like method.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "reset": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Resets all benchmarks in the suite.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "run": {
      "!type": "fn(options?: yui.Object) -> +yui.Object",
      "!doc": "Runs the suite.",
      "!url": "http://alloyui.com/classes/Console.html"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Displays relevant benchmark information when coerced to a string.",
      "!url": "http://alloyui.com/classes/Console.html"
     }
    },
    "undefined": {
     "!type": "fn()",
     "!doc": "The default options copied by suite instances.",
     "!url": "http://alloyui.com/classes/Console.html"
    }
   }
  },
  "console": {
   "Console": {
    "!type": "fn(config?: yui.Object) -> +console.Console",
    "!proto": "widget.Widget",
    "!doc": "A basic console that displays messages logged throughout your application.",
    "!url": "http://alloyui.com/classes/Console.html",
    "prototype": {
     "log": {
      "!type": "fn(arg: MIXED) -> !this",
      "!doc": "Wrapper for <code>Y.log</code>.",
      "!url": "http://alloyui.com/classes/Console.html#method_log"
     },
     "clearConsole": {
      "!type": "fn() -> !this",
      "!doc": "Clear the console of messages and flush the buffer of pending messages.",
      "!url": "http://alloyui.com/classes/Console.html#method_clearConsole"
     },
     "reset": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Triggers the reset behavior via the default logic in _defResetFn.",
      "!url": "http://alloyui.com/classes/Console.html#event_reset"
     },
     "collapse": {
      "!type": "fn() -> !this",
      "!doc": "Collapses the body and footer.",
      "!url": "http://alloyui.com/classes/Console.html#method_collapse"
     },
     "expand": {
      "!type": "fn() -> !this",
      "!doc": "Expands the body and footer if collapsed.",
      "!url": "http://alloyui.com/classes/Console.html#method_expand"
     },
     "printBuffer": {
      "!type": "fn(limit: number) -> !this",
      "!doc": "Outputs buffered messages to the console UI.  This is typically called\nfrom a scheduled interval until the buffer is empty (referred to as the\nprint loop).  The number of buffered messages output to the Console is\nlimited to the number provided as an argument.  If no limit is passed,\nall buffered messages are rendered.",
      "!url": "http://alloyui.com/classes/Console.html#method_printBuffer"
     },
     "entry": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Transfers a received message to the print loop buffer.  Default\nbehavior defined in _defEntryFn.",
      "!url": "http://alloyui.com/classes/Console.html#event_entry"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Sync the UI state to the current attribute state.",
      "!url": "http://alloyui.com/classes/Console.html#method_syncUI"
     },
     "scrollToLatest": {
      "!type": "fn() -> !this",
      "!doc": "Scrolls to the most recent entry",
      "!url": "http://alloyui.com/classes/Console.html#method_scrollToLatest"
     },
     "logEvent": {
      "!type": "fn()",
      "!doc": "Name of the custom event that will communicate log messages.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_logEvent"
     },
     "logSource": {
      "!type": "fn()",
      "!doc": "Object that will emit the log events.  By default the YUI instance.\nTo have a single Console capture events from all YUI instances, set\nthis to the Y.Global object.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_logSource"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements in the Console UI.\nDefault collection contains the following name:value pairs:\n\n<ul>\n  <li>title : &quot;Log Console&quot;</li>\n  <li>pause : &quot;Pause&quot;</li>\n  <li>clear : &quot;Clear&quot;</li>\n  <li>collapse : &quot;Collapse&quot;</li>\n  <li>expand : &quot;Expand&quot;</li>\n</ul>",
      "!url": "http://alloyui.com/classes/Console.html#attribute_strings"
     },
     "paused": {
      "!type": "fn()",
      "!doc": "Boolean to pause the outputting of new messages to the console.\nWhen paused, messages will accumulate in the buffer.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_paused"
     },
     "defaultCategory": {
      "!type": "fn()",
      "!doc": "If a category is not specified in the Y.log(..) statement, this\ncategory will be used. Categories &quot;info&quot;,\n&quot;warn&quot;, and &quot;error&quot; are also called log level.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_defaultCategory"
     },
     "defaultSource": {
      "!type": "fn()",
      "!doc": "If a source is not specified in the Y.log(..) statement, this\nsource will be used.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_defaultSource"
     },
     "entryTemplate": {
      "!type": "fn()",
      "!doc": "Markup template used to create the DOM structure for Console entries.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_entryTemplate"
     },
     "logLevel": {
      "!type": "fn()",
      "!doc": "Minimum entry log level to render into the Console.  The initial\nlogLevel value for all Console instances defaults from the\nY.config.logLevel YUI configuration, or Console.LOG_LEVEL_INFO if\nthat configuration is not set.\n\nPossible values are &quot;info&quot;, &quot;warn&quot;,\n&quot;error&quot; (case insensitive), or their corresponding statics\nConsole.LOG_LEVEL_INFO and so on.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_logLevel"
     },
     "printTimeout": {
      "!type": "fn()",
      "!doc": "Millisecond timeout between iterations of the print loop, moving\nentries from the buffer to the UI.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_printTimeout"
     },
     "printLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of entries printed in each iteration of the print\nloop. This is used to prevent excessive logging locking the page UI.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_printLimit"
     },
     "consoleLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of Console entries allowed in the Console body at one\ntime.  This is used to keep acquired messages from exploding the\nDOM tree and impacting page performance.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_consoleLimit"
     },
     "newestOnTop": {
      "!type": "fn()",
      "!doc": "New entries should display at the top of the Console or the bottom?",
      "!url": "http://alloyui.com/classes/Console.html#attribute_newestOnTop"
     },
     "scrollIntoView": {
      "!type": "fn()",
      "!doc": "When new entries are added to the Console UI, should they be\nscrolled into view?",
      "!url": "http://alloyui.com/classes/Console.html#attribute_scrollIntoView"
     },
     "startTime": {
      "!type": "fn()",
      "!doc": "The baseline time for this Console instance, used to measure elapsed\ntime from the moment the console module is <code>use</code>d to the\nmoment each new entry is logged (not rendered).\n\nThis value is reset by the instance method myConsole.reset().",
      "!url": "http://alloyui.com/classes/Console.html#attribute_startTime"
     },
     "lastTime": {
      "!type": "fn()",
      "!doc": "The precise time the last entry was logged.  Used to measure elapsed\ntime between log messages.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_lastTime"
     },
     "collapsed": {
      "!type": "fn()",
      "!doc": "Controls the collapsed state of the Console",
      "!url": "http://alloyui.com/classes/Console.html#attribute_collapsed"
     },
     "height": {
      "!type": "fn()",
      "!doc": "String with units, or number, representing the height of the Console,\ninclusive of header and footer. If a number is provided, the default\nunit, defined by Widget's DEF_UNIT, property is used.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_height"
     },
     "width": {
      "!type": "fn()",
      "!doc": "String with units, or number, representing the width of the Console.\nIf a number is provided, the default unit, defined by Widget's\nDEF_UNIT, property is used.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_width"
     },
     "useBrowserConsole": {
      "!type": "fn()",
      "!doc": "Pass through to the YUI instance useBrowserConsole configuration.\nBy default this is set to false, which will disable logging to the\nbrowser console when a Console instance is created.  If the\nlogSource is not a YUI instance, this has no effect.",
      "!url": "http://alloyui.com/classes/Console.html#attribute_useBrowserConsole"
     },
     "style": {
      "!type": "fn()",
      "!doc": "Allows the Console to flow in the document.  Available values are\n'inline', 'block', and 'separate' (the default).",
      "!url": "http://alloyui.com/classes/Console.html#attribute_style"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "The identity of the widget.",
     "!url": "http://alloyui.com/classes/Console.html#property_NAME"
    },
    "LOG_LEVEL_INFO": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow all\nincoming messages to generate Console entries.",
     "!url": "http://alloyui.com/classes/Console.html#property_LOG_LEVEL_INFO"
    },
    "LOG_LEVEL_WARN": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow only\nincoming messages of logLevel &quot;warn&quot; or &quot;error&quot;\nto generate Console entries.",
     "!url": "http://alloyui.com/classes/Console.html#property_LOG_LEVEL_WARN"
    },
    "LOG_LEVEL_ERROR": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow only\nincoming messages of logLevel &quot;error&quot; to generate\nConsole entries.",
     "!url": "http://alloyui.com/classes/Console.html#property_LOG_LEVEL_ERROR"
    },
    "ENTRY_CLASSES": {
     "!type": "+yui.Object",
     "!doc": "Map (object) of classNames used to populate the placeholders in the\nConsole.ENTRY_TEMPLATE markup when rendering a new Console entry.\n\n<p>By default, the keys contained in the object are:</p>\n<ul>\n   <li>entry_class</li>\n   <li>entry_meta_class</li>\n   <li>entry_cat_class</li>\n   <li>entry_src_class</li>\n   <li>entry_time_class</li>\n   <li>entry_content_class</li>\n</ul>",
     "!url": "http://alloyui.com/classes/Console.html#property_ENTRY_CLASSES"
    },
    "CHROME_CLASSES": {
     "!type": "+yui.Object",
     "!doc": "Map (object) of classNames used to populate the placeholders in the\nConsole.HEADER_TEMPLATE, Console.BODY_TEMPLATE, and\nConsole.FOOTER_TEMPLATE markup when rendering the Console UI.\n\n<p>By default, the keys contained in the object are:</p>\n<ul>\n  <li>console_hd_class</li>\n  <li>console_bd_class</li>\n  <li>console_ft_class</li>\n  <li>console_controls_class</li>\n  <li>console_checkbox_class</li>\n  <li>console_pause_class</li>\n  <li>console_pause_label_class</li>\n  <li>console_button_class</li>\n  <li>console_clear_class</li>\n  <li>console_collapse_class</li>\n  <li>console_title_class</li>\n</ul>",
     "!url": "http://alloyui.com/classes/Console.html#property_CHROME_CLASSES"
    },
    "HEADER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the header\nsection of the Console when it is rendered.  The template includes\nthese {placeholder}s:\n\n<ul>\n  <li>console_button_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_collapse_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_hd_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_title_class - contributed by Console.CHROME_CLASSES</li>\n  <li>str_collapse - pulled from attribute strings.collapse</li>\n  <li>str_title - pulled from attribute strings.title</li>\n</ul>",
     "!url": "http://alloyui.com/classes/Console.html#property_HEADER_TEMPLATE"
    },
    "BODY_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the Console body\n(where the messages are inserted) when it is rendered.  The template\nincludes only the {placeholder} &quot;console_bd_class&quot;, which is\nconstributed by Console.CHROME_CLASSES.",
     "!url": "http://alloyui.com/classes/Console.html#property_BODY_TEMPLATE"
    },
    "FOOTER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the footer\nsection of the Console when it is rendered.  The template includes\nmany of the {placeholder}s from Console.CHROME_CLASSES as well as:\n\n<ul>\n  <li>id_guid - generated unique id, relates the label and checkbox</li>\n  <li>str_pause - pulled from attribute strings.pause</li>\n  <li>str_clear - pulled from attribute strings.clear</li>\n</ul>",
     "!url": "http://alloyui.com/classes/Console.html#property_FOOTER_TEMPLATE"
    },
    "ENTRY_TEMPLATE": {
     "!type": "string",
     "!doc": "Default markup template used to create the DOM structure for Console\nentries. The markup contains {placeholder}s for content and classes\nthat are replaced via Y.Lang.sub.  The default template contains\nthe {placeholder}s identified in Console.ENTRY_CLASSES as well as the\nfollowing placeholders that will be populated by the log entry data:\n\n<ul>\n  <li>cat_class</li>\n  <li>src_class</li>\n  <li>totalTime</li>\n  <li>elapsedTime</li>\n  <li>localTime</li>\n  <li>sourceAndDetail</li>\n  <li>message</li>\n</ul>",
     "!url": "http://alloyui.com/classes/Console.html#property_ENTRY_TEMPLATE"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration of\nthe Widget.",
     "!url": "http://alloyui.com/classes/Console.html#property_ATTRS"
    }
   }
  },
  "console_filters": {
   "Plugin.ConsoleFilters": {
    "!type": "fn()",
    "!doc": "<p>Provides Plugin.ConsoleFilters plugin class.</p>\n\n<p>This plugin adds the ability to control which Console entries display by filtering on category and source. Two groups of checkboxes are added to the Console footer, one for categories and the other for sources.  Only those messages that match a checked category or source are displayed.</p>",
    "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html",
    "prototype": {
     "syncUI": {
      "!type": "fn()",
      "!doc": "Updates the UI to be in accordance with the current state of the plugin.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_syncUI"
     },
     "refreshConsole": {
      "!type": "fn()",
      "!doc": "Repopulates the Console with entries appropriate to the current filter\nsettings.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_refreshConsole"
     },
     "hideCategory": {
      "!type": "fn(cat: string)",
      "!doc": "Hides any number of categories from the UI.  Convenience method for\nmyConsole.filter.set('category.foo', false); set('category.bar', false);\nand so on.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_hideCategory"
     },
     "showCategory": {
      "!type": "fn(cat: string)",
      "!doc": "Shows any number of categories in the UI.  Convenience method for\nmyConsole.filter.set('category.foo', true); set('category.bar', true);\nand so on.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_showCategory"
     },
     "hideSource": {
      "!type": "fn(src: string)",
      "!doc": "Hides any number of sources from the UI.  Convenience method for\nmyConsole.filter.set('source.foo', false); set('source.bar', false);\nand so on.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_hideSource"
     },
     "showSource": {
      "!type": "fn(src: string)",
      "!doc": "Shows any number of sources in the UI.  Convenience method for\nmyConsole.filter.set('source.foo', true); set('source.bar', true);\nand so on.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#method_showSource"
     },
     "defaultVisibility": {
      "!type": "fn()",
      "!doc": "Default visibility applied to new categories and sources.",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#attribute_defaultVisibility"
     },
     "category": {
      "!type": "fn()",
      "!doc": "<p>Map of entry categories to their visibility status.  Update a\nparticular category's visibility by setting the subattribute to true\n(visible) or false (hidden).</p>\n\n<p>For example, yconsole.filter.set('category.info', false) to hide\nlog entries with the category/logLevel of 'info'.</p>\n\n<p>Similarly, yconsole.filter.get('category.warn') will return a\nboolean indicating whether that category is currently being included\nin the UI.</p>\n\n<p>Unlike the YUI instance configuration's logInclude and logExclude\nproperties, filtered entries are only hidden from the UI, but\ncan be made visible again.</p>",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#attribute_category"
     },
     "source": {
      "!type": "fn()",
      "!doc": "<p>Map of entry sources to their visibility status.  Update a\nparticular sources's visibility by setting the subattribute to true\n(visible) or false (hidden).</p>\n\n<p>For example, yconsole.filter.set('sources.slider', false) to hide\nlog entries originating from Y.Slider.</p>",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#attribute_source"
     },
     "cacheLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of entries to store in the message cache.  Use this to\nlimit the memory footprint in environments with heavy log usage.\nBy default, there is no limit (Number.POSITIVE_INFINITY).",
      "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#attribute_cacheLimit"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Plugin name.",
     "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace hung off the host object that this plugin will inhabit.",
     "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#property_NS"
    },
    "CATEGORIES_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the container for the category filters.",
     "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#property_CATEGORIES_TEMPLATE"
    },
    "SOURCES_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the container for the source filters.",
     "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#property_SOURCES_TEMPLATE"
    },
    "FILTER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the category and source filter checkboxes.",
     "!url": "http://alloyui.com/classes/Plugin.ConsoleFilters.html#property_FILTER_TEMPLATE"
    }
   }
  },
  "cookie": {
   "Cookie": {
    "!type": "fn()",
    "!doc": "Cookie utility.",
    "!url": "http://alloyui.com/classes/Cookie.html",
    "exists": {
     "!type": "fn(name: string) -> bool",
     "!doc": "Determines if the cookie with the given name exists. This is useful for\nBoolean cookies (those that do not follow the name=value convention).",
     "!url": "http://alloyui.com/classes/Cookie.html#method_exists"
    },
    "get": {
     "!type": "fn(name: string, options: fn()) -> +Any",
     "!doc": "Returns the cookie value for the given name.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_get"
    },
    "getSub": {
     "!type": "fn(name: string, subName: string, converter: fn(), options: yui.Object) -> +Any",
     "!doc": "Returns the value of a subcookie.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_getSub"
    },
    "getSubs": {
     "!type": "fn(name: string, options: yui.Object) -> +yui.Object",
     "!doc": "Returns an object containing name-value pairs stored in the cookie with the given name.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_getSubs"
    },
    "remove": {
     "!type": "fn(name: string, options: yui.Object) -> string",
     "!doc": "Removes a cookie from the machine by setting its expiration date to\nsometime in the past.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_remove"
    },
    "removeSub": {
     "!type": "fn(name: string, subName: string, options: yui.Object) -> string",
     "!doc": "Removes a sub cookie with a given name.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_removeSub"
    },
    "set": {
     "!type": "fn(name: string, value: Any, options: yui.Object) -> string",
     "!doc": "Sets a cookie with a given name and value.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_set"
    },
    "setSub": {
     "!type": "fn(name: string, subName: string, value: Any, options: yui.Object) -> string",
     "!doc": "Sets a sub cookie with a given name to a particular value.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_setSub"
    },
    "setSubs": {
     "!type": "fn(name: string, value: yui.Object, options: yui.Object) -> string",
     "!doc": "Sets a cookie with a given name to contain a hash of name-value pairs.",
     "!url": "http://alloyui.com/classes/Cookie.html#method_setSubs"
    }
   }
  },
  "dataschema": {
   "DataSchema.Array": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with data\nstored in arrays.\n\nSee the `apply` method below for usage.",
    "!url": "http://alloyui.com/classes/DataSchema.Array.html",
    "apply": {
     "!type": "fn(schema?: yui.Object, data: yui.Array) -> +yui.Object",
     "!doc": "Applies a schema to an array of data, returning a normalized object\nwith results in the `results` property. The `meta` property of the\nresponse object is present for consistency, but is assigned an empty\nobject.  If the input data is absent or not an array, an `error`\nproperty will be added.\n\nThe input array is expected to contain objects, arrays, or strings.\n\nIf _schema_ is not specified or _schema.resultFields_ is not an array,\n`response.results` will be assigned the input array unchanged.\n\nWhen a _schema_ is specified, the following will occur:\n\nIf the input array contains strings, they will be copied as-is into the\n`response.results` array.\n\nIf the input array contains arrays, `response.results` will contain an\narray of objects with key:value pairs assuming the fields in\n_schema.resultFields_ are ordered in accordance with the data array\nvalues.\n\nIf the input array contains objects, the identified\n_schema.resultFields_ will be used to extract a value from those\nobjects for the output result.\n\n_schema.resultFields_ field identifiers are objects with the following properties:\n\n  * `key`   : <strong>(required)</strong> The locator name (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use strings as identifiers\ninstead of objects (see example below).",
     "!url": "http://alloyui.com/classes/DataSchema.Array.html#method_apply"
    }
   },
   "DataSchema.Base": {
    "!type": "fn()",
    "!doc": "Base class for the YUI DataSchema Utility.",
    "!url": "http://alloyui.com/classes/DataSchema.Base.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: yui.Object) -> +yui.Object",
     "!doc": "Overridable method returns data as-is.",
     "!url": "http://alloyui.com/classes/DataSchema.Base.html#method_apply"
    },
    "prototype": {
     "parse": {
      "!type": "fn(value: yui.Object, field: yui.Object) -> +yui.Object",
      "!doc": "Applies field parser, if defined",
      "!url": "http://alloyui.com/classes/DataSchema.Base.html#method_parse"
     }
    }
   },
   "DataSchema.JSON": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with JSON data.\n\nSee the `apply` method for usage.",
    "!url": "http://alloyui.com/classes/DataSchema.JSON.html",
    "getPath": {
     "!type": "fn(locator: string) -> [string]",
     "!doc": "Utility function converts JSON locator strings into walkable paths",
     "!url": "http://alloyui.com/classes/DataSchema.JSON.html#method_getPath"
    },
    "getLocationValue": {
     "!type": "fn(path: [string], data: string) -> +yui.Object",
     "!doc": "Utility function to walk a path and return the value located there.",
     "!url": "http://alloyui.com/classes/DataSchema.JSON.html#method_getLocationValue"
    },
    "apply": {
     "!type": "fn(schema?: yui.Object, data: yui.Object) -> +yui.Object",
     "!doc": "Applies a schema to an array of data located in a JSON structure, returning\na normalized object with results in the `results` property. Additional\ninformation can be parsed out of the JSON for inclusion in the `meta`\nproperty of the response object.  If an error is encountered during\nprocessing, an `error` property will be added.\n\nThe input _data_ is expected to be an object or array.  If it is a string,\nit will be passed through `Y.JSON.parse()`.\n\nIf _data_ contains an array of data records to normalize, specify the\n_schema.resultListLocator_ as a dot separated path string just as you would\nreference it in JavaScript.  So if your _data_ object has a record array at\n_data.response.results_, use _schema.resultListLocator_ =\n\"response.results\". Bracket notation can also be used for array indices or\nobject properties (e.g. \"response['results']\");  This is called a \"path\nlocator\"\n\nField data in the result list is extracted with field identifiers in\n_schema.resultFields_.  Field identifiers are objects with the following\nproperties:\n\n  * `key`   : <strong>(required)</strong> The path locator (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use path locators (strings)\ninstead of field identifiers (objects) -- see example below.\n\nIf no processing of the result list array is needed, _schema.resultFields_\ncan be omitted; the `response.results` will point directly to the array.\n\nIf the result list contains arrays, `response.results` will contain an\narray of objects with key:value pairs assuming the fields in\n_schema.resultFields_ are ordered in accordance with the data array\nvalues.\n\nIf the result list contains objects, the identified _schema.resultFields_\nwill be used to extract a value from those objects for the output result.\n\nTo extract additional information from the JSON, include an array of\npath locators in _schema.metaFields_.  The collected values will be\nstored in `response.meta`.",
     "!url": "http://alloyui.com/classes/DataSchema.JSON.html#method_apply"
    }
   },
   "DataSchema.Text": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with\ndelimited text data.\n\nSee the `apply` method for usage.",
    "!url": "http://alloyui.com/classes/DataSchema.Text.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: string) -> +yui.Object",
     "!doc": "Applies a schema to a string of delimited data, returning a normalized\nobject with results in the `results` property. The `meta` property of\nthe response object is present for consistency, but is assigned an\nempty object.  If the input data is absent or not a string, an `error`\nproperty will be added.\n\nUse _schema.resultDelimiter_ and _schema.fieldDelimiter_ to instruct\n`apply` how to split up the string into an array of data arrays for\nprocessing.\n\nUse _schema.resultFields_ to specify the keys in the generated result\nobjects in `response.results`. The key:value pairs will be assigned\nin the order of the _schema.resultFields_ array, assuming the values\nin the data records are defined in the same order.\n\n_schema.resultFields_ field identifiers are objects with the following\nproperties:\n\n  * `key`   : <strong>(required)</strong> The property name you want\n        the data value assigned to in the result object (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use just the desired property\nname string as the field identifier instead of an object (see example\nbelow).",
     "!url": "http://alloyui.com/classes/DataSchema.Text.html#method_apply"
    }
   },
   "DataSchema.XML": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with XML data.\n\nSee the `apply` method for usage.",
    "!url": "http://alloyui.com/classes/DataSchema.XML.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: XMLDocument) -> +yui.Object",
     "!doc": "Applies a schema to an XML data tree, returning a normalized object with\nresults in the `results` property. Additional information can be parsed out\nof the XML for inclusion in the `meta` property of the response object.  If\nan error is encountered during processing, an `error` property will be\nadded.\n\nField data in the nodes captured by the XPath in _schema.resultListLocator_\nis extracted with the field identifiers described in _schema.resultFields_.\nField identifiers are objects with the following properties:\n\n  * `key`    : <strong>(required)</strong> The desired property name to use\n        store the retrieved value in the result object.  If `locator` is\n        not specified, `key` is also used as the XPath locator (String)\n  * `locator`: The XPath locator to the node or attribute within each\n        result node found by _schema.resultListLocator_ containing the\n        desired field data (String)\n  * `parser` : A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n  * `schema` : Used to retrieve nested field data into an array for\n        assignment as the result field value.  This object follows the same\n        conventions as _schema_.\n\nIf no value parsing or nested parsing is needed, you can use XPath locators\n(strings) instead of field identifiers (objects) -- see example below.\n\n`response.results` will contain an array of objects with key:value pairs.\nThe keys are the field identifier `key`s, and the values are the data\nvalues extracted from the nodes or attributes found by the field `locator`\n(or `key` fallback).\n\nTo extract additional information from the XML, include an array of\nXPath locators in _schema.metaFields_.  The collected values will be\nstored in `response.meta` with the XPath locator as keys.",
     "!url": "http://alloyui.com/classes/DataSchema.XML.html#method_apply"
    }
   }
  },
  "datasource": {
   "DataSourceArraySchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSourceArraySchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceArraySchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceArraySchema.html#property_NAME"
    }
   },
   "DataSourceCacheExtension": {
    "!type": "fn()",
    "!doc": "DataSourceCache extension binds Cache to DataSource.",
    "!url": "http://alloyui.com/classes/DataSourceCacheExtension.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceCacheExtension.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceCacheExtension.html#property_NAME"
    }
   },
   "DataSourceCache": {
    "!type": "fn()",
    "!proto": "cache.Cache",
    "!doc": "DataSource plugin adds cache functionality.",
    "!url": "http://alloyui.com/classes/DataSourceCache.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceCache.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceCache.html#property_NAME"
    }
   },
   "DataSource.Function": {
    "!type": "fn() -> +datasource.DataSource.Function",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Function subclass for the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSource.Function.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSource.Function.html#property_NAME"
    },
    "prototype": {
     "source": {
      "!type": "fn()",
      "!doc": "Stores the function that will serve the response data.",
      "!url": "http://alloyui.com/classes/DataSource.Function.html#attribute_source"
     }
    }
   },
   "DataSource.Get": {
    "!type": "fn() -> +datasource.DataSource.Get",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Get Utility subclass for the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSource.Get.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSource.Get.html#property_NAME"
    },
    "prototype": {
     "get": {
      "!type": "fn()",
      "!doc": "Pointer to Get Utility.",
      "!url": "http://alloyui.com/classes/DataSource.Get.html#attribute_get"
     },
     "asyncMode": {
      "!type": "fn()",
      "!doc": "Defines request/response management in the following manner:\n<dl>\n    <!--<dt>queueRequests</dt>\n    <dd>If a request is already in progress, wait until response is\n    returned before sending the next request.</dd>\n    <dt>cancelStaleRequests</dt>\n    <dd>If a request is already in progress, cancel it before\n    sending the next request.</dd>-->\n    <dt>ignoreStaleResponses</dt>\n    <dd>Send all requests, but handle only the response for the most\n    recently sent request.</dd>\n    <dt>allowAll</dt>\n    <dd>Send all requests and handle all responses.</dd>\n</dl>",
      "!url": "http://alloyui.com/classes/DataSource.Get.html#attribute_asyncMode"
     },
     "scriptCallbackParam": {
      "!type": "fn()",
      "!doc": "Callback string parameter name sent to the remote script. By default,\nrequests are sent to\n&#60;URI&#62;?&#60;scriptCallbackParam&#62;=callbackFunction",
      "!url": "http://alloyui.com/classes/DataSource.Get.html#attribute_scriptCallbackParam"
     },
     "generateRequestCallback": {
      "!type": "fn()",
      "!doc": "Accepts the DataSource instance and a callback ID, and returns a callback\nparam/value string that gets appended to the script URI. Implementers\ncan customize this string to match their server's query syntax.",
      "!url": "http://alloyui.com/classes/DataSource.Get.html#attribute_generateRequestCallback"
     }
    }
   },
   "DataSource.IO": {
    "!type": "fn() -> +datasource.DataSource.IO",
    "!proto": "datasource.DataSource.Local",
    "!doc": "IO subclass for the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSource.IO.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSource.IO.html#property_NAME"
    },
    "prototype": {
     "io": {
      "!type": "fn()",
      "!doc": "Pointer to IO Utility.",
      "!url": "http://alloyui.com/classes/DataSource.IO.html#attribute_io"
     },
     "ioConfig": {
      "!type": "fn()",
      "!doc": "Default IO Config.",
      "!url": "http://alloyui.com/classes/DataSource.IO.html#attribute_ioConfig"
     }
    }
   },
   "DataSourceJSONSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSourceJSONSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceJSONSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceJSONSchema.html#property_NAME"
    }
   },
   "DataSource.Local": {
    "!type": "fn() -> +datasource.DataSource.Local",
    "!proto": "base.Base",
    "!doc": "Base class for the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSource.Local.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSource.Local.html#property_NAME"
    },
    "prototype": {
     "source": {
      "!type": "fn()",
      "!doc": "Pointer to live data.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#attribute_source"
     },
     "request": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when a data request is received.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#event_request"
     },
     "data": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when raw data is received.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#event_data"
     },
     "response": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when response is returned.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#event_response"
     },
     "error": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when an error is encountered.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#event_error"
     },
     "sendRequest": {
      "!type": "fn(request?: yui.Object) -> number",
      "!doc": "Generates a unique transaction ID and fires <code>request</code> event.\n<strong>Note</strong>: the property <code>callback</code> is a\ndeprecated alias for the <code>on</code> transaction configuration\nproperty described below.",
      "!url": "http://alloyui.com/classes/DataSource.Local.html#method_sendRequest"
     }
    },
    "transactions": {
     "!type": "+yui.Object",
     "!doc": "Global in-progress transaction objects.",
     "!url": "http://alloyui.com/classes/DataSource.Local.html#property_transactions"
    },
    "issueCallback": {
     "!type": "fn(e: event_custom.EventFacade, caller: DataSource)",
     "!doc": "Returns data to callback.",
     "!url": "http://alloyui.com/classes/DataSource.Local.html#method_issueCallback"
    }
   },
   "Pollable": {
    "!type": "fn()",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Adds polling to the DataSource Utility.",
    "!url": "http://alloyui.com/classes/Pollable.html",
    "prototype": {
     "setInterval": {
      "!type": "fn(msec: number, request?: yui.Object) -> number",
      "!doc": "Sets up a polling mechanism to send requests at set intervals and\nforward responses to given callback.",
      "!url": "http://alloyui.com/classes/Pollable.html#method_setInterval"
     },
     "clearInterval": {
      "!type": "fn(id: number)",
      "!doc": "Disables polling mechanism associated with the given interval ID.",
      "!url": "http://alloyui.com/classes/Pollable.html#method_clearInterval"
     },
     "clearAllIntervals": {
      "!type": "fn()",
      "!doc": "Clears all intervals.",
      "!url": "http://alloyui.com/classes/Pollable.html#method_clearAllIntervals"
     }
    }
   },
   "DataSourceTextSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSourceTextSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceTextSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceTextSchema.html#property_NAME"
    }
   },
   "DataSourceXMLSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://alloyui.com/classes/DataSourceXMLSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/DataSourceXMLSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/DataSourceXMLSchema.html#property_NAME"
    }
   },
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://alloyui.com/classes/DataTable.html",
    "prototype": {
     "undefined": {
      "!type": "fn(expectedState)",
      "!doc": "The example code looks for chkbox.on('click')... attr checked == true\nIE doesn't set attr checked with a click\nIn non-IE, if you set checked to true then also click it checked == false (it seems)",
      "!url": "http://alloyui.com/classes/DataTable.html"
     }
    }
   }
  },
  "datatable": {
   "DataTable.Base": {
    "!type": "fn()",
    "!proto": "widget.Widget",
    "!doc": "The baseline implementation of a DataTable.  This class should be used\nprimarily as a superclass for a custom DataTable with a specific set of\nfeatures.  Because features can be composed onto `Y.DataTable`, custom\nsubclasses of DataTable.Base will remain unmodified when new feature modules\nare loaded.\n\nExample usage might look like this:\n\n<pre><code>\n// Custom subclass with only sorting and mutability added.  If other datatable\n// feature modules are loaded, this class will not be affected.\nvar MyTableClass = Y.Base.create('table', Y.DataTable.Base,\n                       [ Y.DataTable.Sortable, Y.DataTable.Mutable ]);\n\nvar table = new MyTableClass({\n    columns: ['firstName', 'lastName', 'age'],\n    data: [\n        { firstName: 'Frank', lastName: 'Zappa', age: 71 },\n        { firstName: 'Frank', lastName: 'Lloyd Wright', age: 144 },\n        { firstName: 'Albert', lastName: 'Einstein', age: 132 },\n        ...\n    ]\n});\n\ntable.render('#over-there');\n\n// DataTable.Base can be instantiated if a featureless table is needed.\nvar table = new Y.DataTable.Base({\n    columns: ['firstName', 'lastName', 'age'],\n    data: [\n        { firstName: 'Frank', lastName: 'Zappa', age: 71 },\n        { firstName: 'Frank', lastName: 'Lloyd Wright', age: 144 },\n        { firstName: 'Albert', lastName: 'Einstein', age: 132 },\n        ...\n    ]\n});\n\ntable.render('#in-here');\n</code></pre>\n\nDataTable.Base is built from DataTable.Core, and sets the default `view`\nto `Y.DataTable.TableView`.",
    "!url": "http://alloyui.com/classes/DataTable.Base.html",
    "prototype": {
     "delegate": {
      "!type": "fn(type: string, fn: fn(), spec: string, context: yui.Object, args: Any) -> +event_custom.EventHandle",
      "!doc": "Pass through to `delegate()` called from the `contentBox`.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#method_delegate"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.taregt, [0, 1];</pre></code>\n\nThis is actually just a pass through to the `view` instance's method\nby the same name.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#method_getCell"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.\n\nThis is actually just a pass through to the `view` instance's method\nby the same name.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#method_getRow"
     },
     "_displayColumns": {
      "!type": "[+yui.Object]",
      "!doc": "Array of the columns that correspond to those with value cells in the\ndata rows. Excludes colspan header columns (configured with `children`).",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#property__displayColumns"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Fires the `renderView` event, delegating UI updates to the configured View.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#method_syncUI"
     },
     "view": {
      "!type": "fn()",
      "!doc": "The View class used to render the `<table>` into the Widget's\n`contentBox`.  This View can handle the entire table rendering itself\nor delegate to other Views.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.\n\nWhen the DataTable is rendered, an instance of this View will be\ncreated and its `render()` method called.  The View instance will be\nassigned to the DataTable instance's `view` property.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#attribute_view"
     },
     "headerView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the\n`<thead>`&mdash;the column headers for the table.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `head` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#attribute_headerView"
     },
     "footerView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the `<tfoot>`.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `foot` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#attribute_footerView"
     },
     "bodyView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the `<tbody>`\nincluding all data rows.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `body` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.Base.html#attribute_bodyView"
     }
    }
   },
   "DataTable.BodyView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering the `<tbody>` section of a table. Used as\nthe default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.\n\nTranslates the provided `modelList` into a rendered `<tbody>` based on the data\nin the constituent Models, altered or amended by any special column\nconfigurations.\n\nThe `columns` configuration, passed to the constructor, determines which\ncolumns will be rendered.\n\nThe rendering process involves constructing an HTML template for a complete row\nof data, built by concatenating a customized copy of the instance's\n`CELL_TEMPLATE` into the `ROW_TEMPLATE` once for each column.  This template is\nthen populated with values from each Model in the `modelList`, aggregating a\ncomplete HTML string of all row and column data.  A `<tbody>` Node is then created from the markup and any column `nodeFormatter`s are applied.\n\nSupported properties of the column objects include:\n\n  * `key` - Used to link a column to an attribute in a Model.\n  * `name` - Used for columns that don't relate to an attribute in the Model\n    (`formatter` or `nodeFormatter` only) if the implementer wants a\n    predictable name to refer to in their CSS.\n  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this\n    column only.\n  * `formatter` - Used to customize or override the content value from the\n    Model.  These do not have access to the cell or row Nodes and should\n    return string (HTML) content.\n  * `nodeFormatter` - Used to provide content for a cell as well as perform any\n    custom modifications on the cell or row Node that could not be performed by\n    `formatter`s.  Should be used sparingly for better performance.\n  * `emptyCellValue` - String (HTML) value to use if the Model data for a\n    column, or the content generated by a `formatter`, is the empty string,\n    `null`, or `undefined`.\n  * `allowHTML` - Set to `true` if a column value, `formatter`, or\n    `emptyCellValue` can contain HTML.  This defaults to `false` to protect\n    against XSS.\n  * `className` - Space delimited CSS classes to add to all `<td>`s in a column.\n\nA column `formatter` can be:\n\n  * a function, as described below.\n  * a string which can be:\n      * the name of a pre-defined formatter function\n        which can be located in the `Y.DataTable.BodyView.Formatters` hash using the\n        value of the `formatter` property as the index.\n      * A template that can use the `{value}` placeholder to include the value\n        for the current cell or the name of any field in the underlaying model\n        also enclosed in curly braces.  Any number and type of these placeholders\n        can be used.\n\nColumn `formatter`s are passed an object (`o`) with the following properties:\n\n  * `value` - The current value of the column's associated attribute, if any.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `className` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's `<td>`.\n  * `rowIndex` - The zero-based row number.\n  * `rowClass` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's containing row `<tr>`.\n\nThey may return a value or update `o.value` to assign specific HTML content.  A\nreturned value has higher precedence.\n\nColumn `nodeFormatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if any.\n  * `td` - The `<td>` Node instance.\n  * `cell` - The `<div>` liner Node instance if present, otherwise, the `<td>`.\n    When adding content to the cell, prefer appending into this property.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `rowIndex` - The zero-based row number.\n\nThey are expected to inject content into the cell's Node directly, including\nany \"empty\" cell content.  Each `nodeFormatter` will have access through the\nNode API to all cells and rows in the `<tbody>`, but not to the `<table>`, as\nit will not be attached yet.\n\nIf a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be\n`destroy()`ed to remove them from the Node cache and free up memory.  The DOM\nelements will remain as will any content added to them.  _It is highly\nadvisable to always return `false` from your `nodeFormatter`s_.",
    "!url": "http://alloyui.com/classes/DataTable.BodyView.html",
    "prototype": {
     "CELL_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML template used to create table cells.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_CELL_TEMPLATE"
     },
     "CLASS_EVEN": {
      "!type": "string",
      "!doc": "CSS class applied to even rows.  This is assigned at instantiation.\n\nFor DataTable, this will be `yui3-datatable-even`.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_CLASS_EVEN"
     },
     "CLASS_ODD": {
      "!type": "string",
      "!doc": "CSS class applied to odd rows.  This is assigned at instantiation.\n\nWhen used by DataTable instances, this will be `yui3-datatable-odd`.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_CLASS_ODD"
     },
     "ROW_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML template used to create table rows.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_ROW_TEMPLATE"
     },
     "host": {
      "!type": "+yui.Object",
      "!doc": "The object that serves as the source of truth for column and row data.\nThis property is assigned at instantiation from the `host` property of\nthe configuration object passed to the constructor.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_host"
     },
     "TBODY_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<tbody>` containing the table rows.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_TBODY_TEMPLATE"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.target, [0, 1];</pre></code>",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_getCell"
     },
     "getRecord": {
      "!type": "fn(seed: string) -> +app.Model",
      "!doc": "Returns the Model associated to the row Node or id provided. Passing the\nNode or id for a descendant of the row also works.\n\nIf no Model can be found, `null` is returned.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_getRecord"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_getRow"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the table's `<tbody>` content by assembling markup generated by\npopulating the `ROW\\_TEMPLATE`, and `CELL\\_TEMPLATE` templates with content\nfrom the `columns` and `modelList` attributes.\n\nThe rendering process happens in three stages:\n\n1. A row template is assembled from the `columns` attribute (see\n   `_createRowTemplate`)\n\n2. An HTML string is built up by concatenating the application of the data in\n   each Model in the `modelList` to the row template. For cells with\n   `formatter`s, the function is called to generate cell content. Cells\n   with `nodeFormatter`s are ignored. For all other cells, the data value\n   from the Model attribute for the given column key is used.  The\n   accumulated row markup is then inserted into the container.\n\n3. If any column is configured with a `nodeFormatter`, the `modelList` is\n   iterated again to apply the `nodeFormatter`s.\n\nSupported properties of the column objects include:\n\n  * `key` - Used to link a column to an attribute in a Model.\n  * `name` - Used for columns that don't relate to an attribute in the Model\n    (`formatter` or `nodeFormatter` only) if the implementer wants a\n    predictable name to refer to in their CSS.\n  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in\n    this column only.\n  * `formatter` - Used to customize or override the content value from the\n    Model.  These do not have access to the cell or row Nodes and should\n    return string (HTML) content.\n  * `nodeFormatter` - Used to provide content for a cell as well as perform\n    any custom modifications on the cell or row Node that could not be\n    performed by `formatter`s.  Should be used sparingly for better\n    performance.\n  * `emptyCellValue` - String (HTML) value to use if the Model data for a\n    column, or the content generated by a `formatter`, is the empty string,\n    `null`, or `undefined`.\n  * `allowHTML` - Set to `true` if a column value, `formatter`, or\n    `emptyCellValue` can contain HTML.  This defaults to `false` to protect\n    against XSS.\n  * `className` - Space delimited CSS classes to add to all `<td>`s in a\n    column.\n\nColumn `formatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if\n    any.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `className` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's `<td>`.\n  * `rowIndex` - The zero-based row number.\n  * `rowClass` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's containing row `<tr>`.\n\nThey may return a value or update `o.value` to assign specific HTML\ncontent.  A returned value has higher precedence.\n\nColumn `nodeFormatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if\n    any.\n  * `td` - The `<td>` Node instance.\n  * `cell` - The `<div>` liner Node instance if present, otherwise, the\n    `<td>`.  When adding content to the cell, prefer appending into this\n    property.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `rowIndex` - The zero-based row number.\n\nThey are expected to inject content into the cell's Node directly, including\nany \"empty\" cell content.  Each `nodeFormatter` will have access through the\nNode API to all cells and rows in the `<tbody>`, but not to the `<table>`,\nas it will not be attached yet.\n\nIf a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be\n`destroy()`ed to remove them from the Node cache and free up memory.  The\nDOM elements will remain as will any content added to them.  _It is highly\nadvisable to always return `false` from your `nodeFormatter`s_.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_render"
     },
     "refreshRow": {
      "!type": "fn(row: node.Node, model: app.Model, colKeys: [string]) -> !this",
      "!doc": "Refreshes the provided row against the provided model and the Array of\ncolumns to be updated.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_refreshRow"
     },
     "refreshCell": {
      "!type": "fn(cell: node.Node, model?: app.Model, col?: yui.Object) -> !this",
      "!doc": "Refreshes the given cell with the provided model data and the provided\ncolumn configuration.\n\nUses the provided column formatter if aviable.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_refreshCell"
     },
     "getColumn": {
      "!type": "fn(name: string) -> +yui.Object",
      "!doc": "Returns column data from this.get('columns'). If a Y.Node is provided as\nthe key, will try to determine the key from the classname",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html#method_getColumn"
     },
     "undefined": {
      "!type": "fn(row: node.Node) -> number",
      "!doc": "Locates the row within the tbodyNode and returns the found index, or Null\nif it is not found in the tbodyNode",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.html"
     }
    },
    "Formatters": {
     "!type": "+yui.Object",
     "!doc": "Hash of formatting functions for cell contents.\n\nThis property can be populated with a hash of formatting functions by the developer\nor a set of pre-defined functions can be loaded via the `datatable-formatters` module.\n\nSee: [DataTable.BodyView.Formatters](./DataTable.BodyView.Formatters.html)",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.html#property_Formatters"
    }
   },
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://alloyui.com/classes/DataTable.html",
    "prototype": {
     "COL_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table's `<col>`s.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_COL_TEMPLATE"
     },
     "COLGROUP_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table's `<colgroup>`.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_COLGROUP_TEMPLATE"
     },
     "setColumnWidth": {
      "!type": "fn(id: number, width: number) -> !this",
      "!doc": "Assigns the style width of the `<col>` representing the column identifed by\n`id` and updates the column configuration.\n\nPass the empty string for `width` to return a column to auto sizing.\n\nThis does not trigger a `columnsChange` event today, but I can be convinced\nthat it should.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_setColumnWidth"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "Columns to include in the rendered table.\n\nIf omitted, the attributes on the configured `recordType` or the first item\nin the `data` collection will be used as a source.\n\nThis attribute takes an array of strings or objects (mixing the two is\nfine).  Each string or object is considered a column to be rendered.\nStrings are converted to objects, so `columns: ['first', 'last']` becomes\n`columns: [{ key: 'first' }, { key: 'last' }]`.\n\nDataTable.Core only concerns itself with a few properties of columns.\nThese properties are:\n\n* `key` - Used to identify the record field/attribute containing content for\n  this column.  Also used to create a default Model if no `recordType` or\n  `data` are provided during construction.  If `name` is not specified, this\n  is assigned to the `_id` property (with added incrementer if the key is\n  used by multiple columns).\n* `children` - Traversed to initialize nested column objects\n* `name` - Used in place of, or in addition to, the `key`.  Useful for\n  columns that aren't bound to a field/attribute in the record data.  This\n  is assigned to the `_id` property.\n* `id` - For backward compatibility.  Implementers can specify the id of\n  the header cell.  This should be avoided, if possible, to avoid the\n  potential for creating DOM elements with duplicate IDs.\n* `field` - For backward compatibility.  Implementers should use `name`.\n* `_id` - Assigned unique-within-this-instance id for a column.  By order\n  of preference, assumes the value of `name`, `key`, `id`, or `_yuid`.\n  This is used by the rendering views as well as feature module\n  as a means to identify a specific column without ambiguity (such as\n  multiple columns using the same `key`.\n* `_yuid` - Guid stamp assigned to the column object.\n* `_parent` - Assigned to all child columns, referencing their parent\n  column.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_columns"
     },
     "recordType": {
      "!type": "fn()",
      "!doc": "Model subclass to use as the `model` for the ModelList stored in the `data`\nattribute.\n\nIf not provided, it will try really hard to figure out what to use.  The\nfollowing attempts will be made to set a default value:\n\n1. If the `data` attribute is set with a ModelList instance and its `model`\n   property is set, that will be used.\n2. If the `data` attribute is set with a ModelList instance, and its\n   `model` property is unset, but it is populated, the `ATTRS` of the\n   `constructor of the first item will be used.\n3. If the `data` attribute is set with a non-empty array, a Model subclass\n   will be generated using the keys of the first item as its `ATTRS` (see\n   the `_createRecordClass` method).\n4. If the `columns` attribute is set, a Model subclass will be generated\n   using the columns defined with a `key`. This is least desirable because\n   columns can be duplicated or nested in a way that's not parsable.\n5. If neither `data` nor `columns` is set or populated, a change event\n   subscriber will listen for the first to be changed and try all over\n   again.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_recordType"
     },
     "data": {
      "!type": "+app.ModelList",
      "!doc": "The ModelList that manages the table's data.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_data"
     },
     "summary": {
      "!type": "fn()",
      "!doc": "Content for the `<table summary=\"ATTRIBUTE VALUE HERE\">`.  Values assigned\nto this attribute will be HTML escaped for security.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_summary"
     },
     "caption": {
      "!type": "fn()",
      "!doc": "HTML content of an optional `<caption>` element to appear above the table.\nLeave this config unset or set to a falsy value to remove the caption.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_caption"
     },
     "recordset": {
      "!type": "fn()",
      "!doc": "Deprecated as of 3.5.0. Passes through to the `data` attribute.\n\nWARNING: `get('recordset')` will NOT return a Recordset instance as of\n3.5.0.  This is a break in backward compatibility.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_recordset"
     },
     "columnset": {
      "!type": "fn()",
      "!doc": "Deprecated as of 3.5.0. Passes through to the `columns` attribute.\n\nWARNING: `get('columnset')` will NOT return a Columnset instance as of\n3.5.0.  This is a break in backward compatibility.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_columnset"
     },
     "getColumn": {
      "!type": "fn(name: string) -> +yui.Object",
      "!doc": "Gets the column configuration object for the given key, name, or index.  For\nnested columns, `name` can be an array of indexes, each identifying the index\nof that column in the respective parent's \"children\" array.\n\nIf you pass a column object, it will be returned.\n\nFor columns with keys, you can also fetch the column with\n`instance.get('columns.foo')`.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_getColumn"
     },
     "getRecord": {
      "!type": "fn(seed: number) -> +app.Model",
      "!doc": "Returns the Model associated to the record `id`, `clientId`, or index (not\nrow index).  If none of those yield a Model from the `data` ModelList, the\narguments will be passed to the `view` instance's `getRecord` method\nif it has one.\n\nIf no Model can be found, `null` is returned.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_getRecord"
     },
     "_getRecordType": {
      "!type": "fn(val: app.Model) -> +app.Model",
      "!doc": "Returns the Model class of the instance's `data` attribute ModelList.  If\nnot set, returns the explicitly configured value.",
      "!url": "http://alloyui.com/classes/DataTable.html#method__getRecordType"
     },
     "focusedCell": {
      "!type": "fn()",
      "!doc": "Cell that's currently either focused or\nfocusable when the DataTable gets the focus.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_focusedCell"
     },
     "keyIntoHeaders": {
      "!type": "fn()",
      "!doc": "Determines whether it is possible to navigate into the header area.\nThe examples referenced in the document show both behaviors so it seems\nit is optional.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_keyIntoHeaders"
     },
     "keyActions": {
      "!type": "+yui.Object",
      "!doc": "Table of actions to be performed for each key.  It is loaded with a clone\nof [ARIA_ACTIONS](#property_ARIA_ACTIONS) by default.\n\nThe key for each entry is either a key-code or an alias from the\n[KEY_NAMES](#property_KEY_NAMES) table. They can be prefixed with any combination\nof the modifier keys `alt`, `ctrl`, `meta` or `shift` each followed by a hyphen,\nsuch as `\"ctrl-shift-up\"` (modifiers, if more than one, should appear in alphabetical order).\n\nThe value for each entry should be a function or the name of a method in\nthe DataTable instance.  The method will receive the original keyboard\nEventFacade as its only argument.\n\nIf the value is a string and it cannot be resolved into a method,\nit will be assumed to be the name of an event to fire. The listener for that\nevent will receive an EventFacade containing references to the cell that has the focus,\nthe row, column and, unless it is a header row, the record it corresponds to.\nThe second argument will be the original EventFacade for the keyboard event.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_keyActions"
     },
     "showMessages": {
      "!type": "fn()",
      "!doc": "Enables the display of messages in the table.  Setting this to false will\nprevent the message Node from being created and `showMessage` from doing\nanything.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_showMessages"
     },
     "MESSAGE_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to generate the node that will be used to report messages.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_MESSAGE_TEMPLATE"
     },
     "hideMessage": {
      "!type": "fn() -> !this",
      "!doc": "Hides the message node.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_hideMessage"
     },
     "showMessage": {
      "!type": "fn(message: string) -> !this",
      "!doc": "Display the message node and set its content to `message`.  If there is a\nlocalized `strings` entry for the value of `message`, that string will be\nused.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_showMessage"
     },
     "_messageNode": {
      "!type": "+node.Node",
      "!doc": "Node used to display messages from `showMessage`.",
      "!url": "http://alloyui.com/classes/DataTable.html#property__messageNode"
     },
     "autoSync": {
      "!type": "fn()",
      "!doc": "Controls whether `addRow`, `removeRow`, and `modifyRow` should trigger the\nunderlying Model's sync layer by default.\n\nWhen `true`, it is unnecessary to pass the \"sync\" configuration property to\nthose methods to trigger per-operation sync.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_autoSync"
     },
     "addColumn": {
      "!type": "fn(column: yui.Object, index: number)",
      "!doc": "Fired by the `addColumn` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#event_addColumn"
     },
     "modifyColumn": {
      "!type": "fn(column: yui.Object, newColumnDef: yui.Object)",
      "!doc": "Fired by the `modifyColumn` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#event_modifyColumn"
     },
     "moveColumn": {
      "!type": "fn(column: yui.Object, index: yui.Object)",
      "!doc": "Fired by the `moveColumn` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#event_moveColumn"
     },
     "removeColumn": {
      "!type": "fn(column: yui.Object)",
      "!doc": "Fired by the `removeColumn` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#event_removeColumn"
     },
     "addRow": {
      "!type": "fn(data: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Adds a new record to the DataTable's `data` ModelList.  Record data can be\nan object of field values or an instance of the DataTable's configured\n`recordType` class.\n\nThis relays all parameters to the `data` ModelList's `add` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `save()` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_addRow"
     },
     "removeRow": {
      "!type": "fn(id: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Removes a record from the DataTable's `data` ModelList.  The record can be\nprovided explicitly or targeted by it's `id` (see ModelList's `getById`\nmethod), `clientId`, or index in the ModelList.\n\nAfter locating the target Model, this relays the Model and all other passed\narguments to the `data` ModelList's `remove` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be destroyed, passing\n`{ delete: true }` to trigger calling the Model's sync layer.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `destroy()` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_removeRow"
     },
     "modifyRow": {
      "!type": "fn(id: yui.Object, data: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Updates an existing record in the DataTable's `data` ModelList.  The record\ncan be provided explicitly or targeted by it's `id` (see ModelList's\n`getById` method), `clientId`, or index in the ModelList.\n\nAfter locating the target Model, this relays the all other passed\narguments to the Model's `setAttrs` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `save()` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_modifyRow"
     },
     "addRows": {
      "!type": "fn(data: [yui.Object], config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Adds an array of new records to the DataTable's `data` ModelList.  Record data\ncan be an array of objects containing field values or an array of instance of\nthe DataTable's configured `recordType` class.\n\nThis relays all parameters to the `data` ModelList's `add` method.\n\nTechnically, this is an alias to `addRow`, but please use the appropriately\nnamed method for readability.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Models will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to each Model's `save()` method.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_addRows"
     },
     "sortable": {
      "!type": "fn()",
      "!doc": "Controls which column headers can trigger sorting by user clicks.\n\nAcceptable values are:\n\n * \"auto\" - (default) looks for `sortable: true` in the column configurations\n * `true` - all columns are enabled\n * `false - no UI sortable is enabled\n * {String[]} - array of key names to give sortable headers",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_sortable"
     },
     "sortBy": {
      "!type": "fn()",
      "!doc": "The current sort configuration to maintain in the data.\n\nAccepts column `key` strings or objects with a single property, the column\n`key`, with a value of 1, -1, \"asc\", or \"desc\".  E.g. `{ username: 'asc'\n}`.  String values are assumed to be ascending.\n\nExample values would be:\n\n * `\"username\"` - sort by the data's `username` field or the `key`\n   associated to a column with that `name`.\n * `{ username: \"desc\" }` - sort by `username` in descending order.\n   Alternately, use values \"asc\", 1 (same as \"asc\"), or -1 (same as \"desc\").\n * `[\"lastName\", \"firstName\"]` - ascending sort by `lastName`, but for\n   records with the same `lastName`, ascending subsort by `firstName`.\n   Array can have as many items as you want.\n * `[{ lastName: -1 }, \"firstName\"]` - descending sort by `lastName`,\n   ascending subsort by `firstName`. Mixed types are ok.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_sortBy"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Strings containing language for sorting tooltips.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_strings"
     },
     "sort": {
      "!type": "fn(sortBy: string)",
      "!doc": "Notifies of an impending sort, either from clicking on a column\nheader, or from a call to the `sort` or `toggleSort` method.\n\nThe requested sort is available in the `sortBy` property of the event.\n\nThe default behavior of this event sets the table's `sortBy` attribute.",
      "!url": "http://alloyui.com/classes/DataTable.html#event_sort"
     },
     "SORTABLE_HEADER_TEMPLATE": {
      "!type": "string",
      "!doc": "Template for the node that will wrap the header content for sortable\ncolumns.",
      "!url": "http://alloyui.com/classes/DataTable.html#property_SORTABLE_HEADER_TEMPLATE"
     },
     "toggleSort": {
      "!type": "fn(fields: string, payload?: yui.Object) -> !this",
      "!doc": "Reverse the current sort direction of one or more fields currently being\nsorted by.\n\nPass the `key` of the column or columns you want the sort order reversed\nfor.",
      "!url": "http://alloyui.com/classes/DataTable.html#method_toggleSort"
     }
    },
    "KEY_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Mapping of key codes to friendly key names that can be used in the\n[keyActions](#property_keyActions) property and [ARIA_ACTIONS](#property_ARIA_ACTIONS)\nproperty.\n\nIt contains aliases for the following keys:\n    <ul>\n    <li>backspace</li>\n    <li>tab</li>\n    <li>enter</li>\n    <li>esc</li>\n    <li>space</li>\n    <li>pgup</li>\n    <li>pgdown</li>\n    <li>end</li>\n    <li>home</li>\n    <li>left</li>\n    <li>up</li>\n    <li>right</li>\n    <li>down</li>\n    <li>f1 .. f12</li>\n    </ul>",
     "!url": "http://alloyui.com/classes/DataTable.html#property_KEY_NAMES"
    },
    "ARIA_ACTIONS": {
     "!type": "+yui.Object",
     "!doc": "Mapping of key codes to actions according to the WAI-ARIA suggestion for the\n[Grid Widget](http://www.w3.org/WAI/PF/aria-practices/#grid).\n\nThe key for each entry is a key-code or [keyName](#property_KEY_NAMES) while the\nvalue can be a function that performs the action or a string.  If a string,\nit can either correspond to the name of a method in this module (or  any\nmethod in a DataTable instance) or the name of an event to fire.",
     "!url": "http://alloyui.com/classes/DataTable.html#property_ARIA_ACTIONS"
    }
   },
   "DataTable.Column": {
    "!type": "fn()",
    "!doc": "_This is a documentation entry only_\n\nColumns are described by object literals with a set of properties.\nThere is not an actual `DataTable.Column` class.\nHowever, for the purpose of documenting it, this pseudo-class is declared here.\n\nDataTables accept an array of column definitions in their [columns](DataTable.html#attr_columns)\nattribute.  Each entry in this array is a column definition which may contain\nany combination of the properties listed below.\n\nThere are no mandatory properties though a column will usually have a\n[key](#property_key) property to reference the data it is supposed to show.\nThe [columns](DataTable.html#attr_columns) attribute can accept a plain string\nin lieu of an object literal, which is the equivalent of an object with the\n[key](#property_key) property set to that string.",
    "!url": "http://alloyui.com/classes/DataTable.Column.html",
    "prototype": {
     "width": {
      "!type": "string",
      "!doc": "Adds a style `width` setting to an associated `<col>`\nelement for the column.\n\nNote, the assigned width will not truncate cell content, and\nit will not preserve the configured width if doing so would\ncompromise either the instance's `width` configuration or\nthe natural width of the table's containing DOM elements.\n\nIf absolute widths are required, it can be accomplished with\nsome custom CSS and the use of a `cellTemplate`, or\n`formatter`.  \n\nSee the description of \n[datatable-column-widths](DataTable.ColumnWidths.html) \nfor an example of how to do this.\n\n    { key: 'a', width: '400px' },\n    { key: 'b', width: '10em' }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_width"
     },
     "key": {
      "!type": "string",
      "!doc": "Binds the column values to the named property in the [data](DataTable.html#attr_data).\n\nOptional if [formatter](#property_formatter), [nodeFormatter](#property_nodeFormatter),\nor [cellTemplate](#property_cellTemplate) is used to populate the content.\n\nIt should not be set if [children](#property_children) is set.\n\nThe value is used for the [\\_id](#property__id) property unless the [name](#property_name)\nproperty is also set.\n\n    { key: 'username' }\n\nThe above column definition can be reduced to this:\n\n    'username'",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_key"
     },
     "name": {
      "!type": "string",
      "!doc": "An identifier that can be used to locate a column via\n[getColumn](DataTable.html#method_getColumn)\nor style columns with class `yui3-datatable-col-NAME` after dropping characters\nthat are not valid for CSS class names.\n\nIt defaults to the [key](#property_key).\n\nThe value is used for the [\\_id](#property__id) property.\n\n    { name: 'fullname', formatter: ... }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_name"
     },
     "field": {
      "!type": "string",
      "!doc": "An alias for [name](#property_name) for backward compatibility.\n\n    { field: 'fullname', formatter: ... }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_field"
     },
     "id": {
      "!type": "string",
      "!doc": "Overrides the default unique id assigned `<th id=\"HERE\">`.\n\n__Use this with caution__, since it can result in\nduplicate ids in the DOM.\n\n    {\n        name: 'checkAll',\n        id: 'check-all',\n        label: ...\n        formatter: ...\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_id"
     },
     "label": {
      "!type": "string",
      "!doc": "HTML to populate the header `<th>` for the column.\nIt defaults to the value of the [key](#property_key) property or the text\n`Column n` where _n_ is an ordinal number.\n\n    { key: 'MfgvaPrtNum', label: 'Part Number' }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_label"
     },
     "children": {
      "!type": "+yui.Array",
      "!doc": "Used to create stacked headers.\n\nChild columns may also contain `children`. There is no limit\nto the depth of nesting.\n\nColumns configured with `children` are for display only and\n<strong>should not</strong> be configured with a [key](#property_key).\nConfigurations relating to the display of data, such as\n[formatter](#property_formatter), [nodeFormatter](#property_nodeFormatter),\n[emptyCellValue](#property_emptyCellValue), etc. are ignored.\n\n    { label: 'Name', children: [\n        { key: 'firstName', label: 'First`},\n        { key: 'lastName', label: 'Last`}\n    ]}",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_children"
     },
     "abbr": {
      "!type": "string",
      "!doc": "Assigns the value `<th abbr=\"HERE\">`.\n\n    {\n      key  : 'forecast',\n      label: '1yr Target Forecast',\n      abbr : 'Forecast'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_abbr"
     },
     "title": {
      "!type": "string",
      "!doc": "Assigns the value `<th title=\"HERE\">`.\n\n    {\n      key  : 'forecast',\n      label: '1yr Target Forecast',\n      title: 'Target Forecast for the Next 12 Months'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_title"
     },
     "headerTemplate": {
      "!type": "+HTML",
      "!doc": "Overrides the default [CELL_TEMPLATE](DataTable.HeaderView.html#property_CELL_TEMPLATE)\nused by `Y.DataTable.HeaderView` to render the header cell\nfor this column.  This is necessary when more control is\nneeded over the markup for the header itself, rather than\nits content.\n\nUse the [label](#property_label) configuration if you don't need to\ncustomize the `<th>` iteself.\n\nImplementers are strongly encouraged to preserve at least\nthe `{id}` and `{_id}` placeholders in the custom value.\n\n    {\n        headerTemplate:\n            '<th id=\"{id}\" ' +\n                'title=\"Unread\" ' +\n                'class=\"{className}\" ' +\n                '{_id}>&#9679;</th>'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_headerTemplate"
     },
     "cellTemplate": {
      "!type": "string",
      "!doc": "Overrides the default [CELL_TEMPLATE](DataTable.BodyView.html#property_CELL_TEMPLATE)\nused by `Y.DataTable.BodyView` to render the data cells\nfor this column.  This is necessary when more control is\nneeded over the markup for the `<td>` itself, rather than\nits content.\n\n    {\n        key: 'id',\n        cellTemplate:\n            '<td class=\"{className}\">' +\n              '<input type=\"checkbox\" ' +\n                     'id=\"{content}\">' +\n            '</td>'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_cellTemplate"
     },
     "formatter": {
      "!type": "string",
      "!doc": "String or function used to translate the raw record data for each cell in a\ngiven column into a format better suited to display.\n\nIf it is a string, it will initially be assumed to be the name of one of the\nformatting functions in\n[Y.DataTable.BodyView.Formatters](DataTable.BodyView.Formatters.html).\nIf one such formatting function exists, it will be used.\n\nIf no such named formatter is found, it will be assumed to be a template\nstring and will be expanded.  The placeholders can contain the key to any\nfield in the record or the placeholder `{value}` which represents the value\nof the current field.\n\nIf the value is a function, it will be assumed to be a formatting function.\nA formatting function receives a single argument, an object with the following properties:\n\n* __value__ The raw value from the record Model to populate this cell.\n  Equivalent to `o.record.get(o.column.key)` or `o.data[o.column.key]`.\n* __data__ The Model data for this row in simple object format.\n* __record__ The Model for this row.\n* __column__ The column configuration object.\n* __className__ A string of class names to add `<td class=\"HERE\">` in addition to\n  the column class and any classes in the column's className configuration.\n* __rowIndex__ The index of the current Model in the ModelList.\n  Typically correlates to the row index as well.\n* __rowClass__ A string of css classes to add `<tr class=\"HERE\"><td....`\n  This is useful to avoid the need for nodeFormatters to add classes to the containing row.\n\nThe formatter function may return a string value that will be used for the cell\ncontents or it may change the value of the `value`, `className` or `rowClass`\nproperties which well then be used to format the cell.  If the value for the cell\nis returned in the `value` property of the input argument, no value should be returned.\n\n    {\n        key: 'name',\n        formatter: 'link',  // named formatter\n        linkFrom: 'website' // extra column property for link formatter\n    },\n    {\n        key: 'cost',\n        formatter: '${value}' // formatter template string\n      //formatter: '${cost}'  // same result but less portable\n    },\n    {\n        name: 'Name',          // column does not have associated field value\n                               // thus, it uses name instead of key\n        formatter: '{firstName} {lastName}' // template references other fields\n    },\n    {\n        key: 'price',\n        formatter: function (o) { // function both returns a string to show\n            if (o.value > 3) {    // and a className to apply to the cell\n                o.className += 'expensive';\n            }\n\n            return '$' + o.value.toFixed(2);\n        }\n    },",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_formatter"
     },
     "nodeFormatter": {
      "!type": "fn()",
      "!doc": "Used to customize the content of the data cells for this column.\n\n`nodeFormatter` is significantly slower than [formatter](#property_formatter)\nand should be avoided if possible. Unlike [formatter](#property_formatter),\n`nodeFormatter` has access to the `<td>` element and its ancestors.\n\nThe function provided is expected to fill in the `<td>` element itself.\n__Node formatters should return `false`__ except in certain conditions as described\nin the users guide.\n\nThe function receives a single object\nargument with the following properties:\n\n* __td__\tThe `<td>` Node for this cell.\n* __cell__\tIf the cell `<td> contains an element with class `yui3-datatable-liner,\n  this will refer to that Node. Otherwise, it is equivalent to `td` (default behavior).\n* __value__\tThe raw value from the record Model to populate this cell.\n  Equivalent to `o.record.get(o.column.key)` or `o.data[o.column.key]`.\n* __data__\tThe Model data for this row in simple object format.\n* __record__\tThe Model for this row.\n* __column__\tThe column configuration object.\n* __rowIndex__\tThe index of the current Model in the ModelList.\n _Typically_ correlates to the row index as well.",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_nodeFormatter"
     },
     "emptyCellValue": {
      "!type": "+String} depending on the setting of allowHTM",
      "!doc": "Provides the default value to populate the cell if the data\nfor that cell is `undefined`, `null`, or an empty string.\n\n    {\n        key: 'price',\n        emptyCellValue: '???'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_emptyCellValue"
     },
     "allowHTML": {
      "!type": "bool",
      "!doc": "Skips the security step of HTML escaping the value for cells\nin this column.\n\nThis is also necessary if [emptyCellValue](#property_emptyCellValue)\nis set with an HTML string.\n`nodeFormatter`s ignore this configuration.  If using a\n`nodeFormatter`, it is recommended to use\n[Y.Escape.html()](Escape.html#method_html)\non any user supplied content that is to be displayed.\n\n    {\n        key: 'preview',\n        allowHTML: true\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_allowHTML"
     },
     "className": {
      "!type": "string",
      "!doc": "A string of CSS classes that will be added to the `<td>`'s\n`class` attribute.\n\nNote, all cells will automatically have a class in the\nform of \"yui3-datatable-col-XXX\" added to the `<td>`, where\nXXX is the column's configured `name`, `key`, or `id` (in\nthat order of preference) sanitized from invalid characters.\n\n    {\n        key: 'symbol',\n        className: 'no-hide'\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_className"
     },
     "sortable": {
      "!type": "bool",
      "!doc": "Used when the instance's `sortable` attribute is set to\n\"auto\" (the default) to determine which columns will support\nuser sorting by clicking on the header.\n\nIf the instance's `key` attribute is not set, this\nconfiguration is ignored.\n\n    { key: 'lastLogin', sortable: true }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_sortable"
     },
     "caseSensitive": {
      "!type": "bool",
      "!doc": "When the instance's `caseSensitive` attribute is set to\n`true` the sort order is case sensitive (relevant to string columns only).\n\nCase sensitive sort is marginally more efficient and should be considered\nfor large data sets when case insensitive sort is not required.\n\n    { key: 'lastLogin', sortable: true, caseSensitive: true }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_caseSensitive"
     },
     "sortFn": {
      "!type": "fn()",
      "!doc": "Allows a column to be sorted using a custom algorithm.  The\nfunction receives three parameters, the first two being the\ntwo record Models to compare, and the third being a boolean\n`true` if the sort order should be descending.\n\nThe function should return `1` to sort `a` above `b`, `-1`\nto sort `a` below `b`, and `0` if they are equal.  Keep in\nmind that the order should be reversed when `desc` is\n`true`.\n\nThe `desc` parameter is provided to allow `sortFn`s to\nalways sort certain values above or below others, such as\nalways sorting `null`s on top.\n\n    {\n      label: 'Name',\n      sortFn: function (a, b, desc) {\n        var an = a.get('lname') + b.get('fname'),\n            bn = a.get('lname') + b.get('fname'),\n            order = (an > bn) ? 1 : -(an < bn);\n\n        return desc ? -order : order;\n      },\n      formatter: function (o) {\n        return o.data.lname + ', ' + o.data.fname;\n      }\n    }",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_sortFn"
     },
     "sortDir": {
      "!type": "number",
      "!doc": "(__read-only__) If a column is sorted, this\nwill be set to `1` for ascending order or `-1` for\ndescending.  This configuration is public for inspection,\nbut can't be used during DataTable instantiation to set the\nsort direction of the column.  Use the table's\n[sortBy](DataTable.html#attr_sortBy)\nattribute for that.",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_sortDir"
     }
    }
   },
   "Plugin.DataTableDataSource": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds DataSource integration to DataTable.",
    "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#property_NAME"
    },
    "prototype": {
     "datasource": {
      "!type": "fn()",
      "!doc": "Pointer to DataSource instance.",
      "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#attribute_datasource"
     },
     "initialRequest": {
      "!type": "fn()",
      "!doc": "Request sent to DataSource immediately upon initialization.",
      "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#attribute_initialRequest"
     },
     "load": {
      "!type": "fn(config: yui.Object)",
      "!doc": "Load data by calling DataSource's sendRequest() method under the hood.",
      "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#method_load"
     },
     "onDataReturnInitializeTable": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Callback function passed to DataSource's sendRequest() method populates\nan entire DataTable with new data, clearing previous data, if any.",
      "!url": "http://alloyui.com/classes/Plugin.DataTableDataSource.html#method_onDataReturnInitializeTable"
     }
    }
   },
   "DataTable.BodyView.Formatters": {
    "!type": "fn()",
    "!doc": "Registry of function producing cell formatting functions.\nAllows for names to be used in the column\ndefinition `formatter` property:\n\n    {key:\"myColumn\", formatter:\"date\"}\n\nThese functions are not meant to be used directly.  Instead, they will be\nautomatically called when their names are used as values for the `formatter`\nproperty in a columnd definition.\nThey will be called just once per rendering cycle and will receive\nthe column configuration.  They are expected to return a function that will\nthen be called once per row and will do the actual formatting.\nThey are expected to do all the preparatory once-per-render work\nso that the actual formatting function doesn't need to repeat it.",
    "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html",
    "prototype": {
     "TFOOT_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<tfoot>` containing the table footers.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#property_TFOOT_TEMPLATE"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the `<tfoot>` Node and inserts it after the `<thead>` Node.",
      "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_render"
     }
    }
   },
   "DataTable.HeaderView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering the `<thead>` section of a table. Used as\nthe default `headerView` for `Y.DataTable.Base` and `Y.DataTable` classes.\n\nTranslates the provided array of column configuration objects into a rendered\n`<thead>` based on the data in those objects.\n\n\nThe structure of the column data is expected to be a single array of objects,\nwhere each object corresponds to a `<th>`.  Those objects may contain a\n`children` property containing a similarly structured array to indicate the\nnested cells should be grouped under the parent column's colspan in a separate\nrow of header cells. E.g.\n\n<pre><code>\nnew Y.DataTable.HeaderView({\n  container: tableNode,\n  columns: [\n    { key: 'id' }, // no nesting\n    { key: 'name', children: [\n      { key: 'firstName', label: 'First' },\n      { key: 'lastName',  label: 'Last' } ] }\n  ]\n}).render();\n</code></pre>\n\nThis would translate to the following visualization:\n\n<pre>\n---------------------\n|    |     name     |\n|    |---------------\n| id | First | Last |\n---------------------\n</pre>\n\nSupported properties of the column objects include:\n\n  * `label`     - The HTML content of the header cell.\n  * `key`       - If `label` is not specified, the `key` is used for content.\n  * `children`  - Array of columns to appear below this column in the next\n                  row.\n  * `headerTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this\n    column only.\n  * `abbr`      - The content of the 'abbr' attribute of the `<th>`\n  * `title`     - The content of the 'title' attribute of the `<th>`\n  * `className` - Adds this string of CSS classes to the column header\n\nThrough the life of instantiation and rendering, the column objects will have\nthe following properties added to them:\n\n  * `id`       - (Defaulted by DataTable) The id to assign the rendered column\n  * `_colspan` - To supply the `<th>` attribute\n  * `_rowspan` - To supply the `<th>` attribute\n  * `_parent`  - (Added by DataTable) If the column is a child of another\n    column, this points to its parent column\n\nThe column object is also used to provide values for {placeholder} tokens in the\ninstance's `CELL_TEMPLATE`, so you can modify the template and include other\ncolumn object properties to populate them.",
    "!url": "http://alloyui.com/classes/DataTable.HeaderView.html",
    "prototype": {
     "CELL_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the table's header cell markup.  Override this to\ncustomize how header cell markup is created.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#property_CELL_TEMPLATE"
     },
     "columns": {
      "!type": "[+yui.Array]",
      "!doc": "The data representation of the header rows to render.  This is assigned by\nparsing the `columns` configuration array, and is used by the render()\nmethod.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#property_columns"
     },
     "ROW_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the table's header row markup.  Override this to\ncustomize the row markup.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#property_ROW_TEMPLATE"
     },
     "source": {
      "!type": "+yui.Object",
      "!doc": "The object that serves as the source of truth for column and row data.\nThis property is assigned at instantiation from the `source` property of\nthe configuration object passed to the constructor.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#property_source"
     },
     "THEAD_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<thead>` containing the table headers.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#property_THEAD_TEMPLATE"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the `<thead>` Node content by assembling markup generated by\npopulating the `ROW_TEMPLATE` and `CELL_TEMPLATE` templates with content\nfrom the `columns` property.",
      "!url": "http://alloyui.com/classes/DataTable.HeaderView.html#method_render"
     }
    }
   },
   "DataTable.Highlight": {
    "!type": "fn()",
    "!url": "http://alloyui.com/classes/DataTable.Highlight.html",
    "prototype": {
     "highlightRows": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the row when the mouse is over the row.",
      "!url": "http://alloyui.com/classes/DataTable.Highlight.html#attribute_highlightRows"
     },
     "highlightCols": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the column when the mouse is over the column.",
      "!url": "http://alloyui.com/classes/DataTable.Highlight.html#attribute_highlightCols"
     },
     "highlightCells": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the cell when the mouse is over it.",
      "!url": "http://alloyui.com/classes/DataTable.Highlight.html#attribute_highlightCells"
     },
     "highlightClassNames": {
      "!type": "+yui.Object",
      "!doc": "An object consisting of classnames for a `row`, a `col` and a `cell` to\nbe applied to their respective objects when the user moves the mouse over\nthe item and the attribute is set to true.",
      "!url": "http://alloyui.com/classes/DataTable.Highlight.html#property_highlightClassNames"
     }
    }
   },
   "DataTable.Paginator.View": {
    "!type": "fn()",
    "!proto": "app.View",
    "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html",
    "prototype": {
     "containerTemplate": {
      "!type": "string",
      "!doc": "Template for this view's container.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#property_containerTemplate"
     },
     "contentTemplate": {
      "!type": "string",
      "!doc": "Template for content. Helps maintain order of controls.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#property_contentTemplate"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "Sets classnames on the templates and bind events",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#method_initializer"
     },
     "render": {
      "!type": "fn() -> !this",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#method_render"
     },
     "attachEvents": {
      "!type": "fn()",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#method_attachEvents"
     },
     "pageSizes": {
      "!type": "fn()",
      "!doc": "Array of values used to populate the drop down for items per page",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#attribute_pageSizes"
     },
     "model": {
      "!type": "fn()",
      "!doc": "Model used for this view",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.View.html#attribute_model"
     }
    }
   },
   "DataTable.Paginator": {
    "!type": "fn()",
    "!url": "http://alloyui.com/classes/DataTable.Paginator.html",
    "prototype": {
     "paginatorModel": {
      "!type": "fn()",
      "!doc": "A model instance or a configuration object for the Model.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_paginatorModel"
     },
     "paginatorModelType": {
      "!type": "fn()",
      "!doc": "A pointer to a Model object to be instantiated, or a String off of the\n`Y` namespace.\n\nThis is only used if the `paginatorModel` is a configuration object or\nis null.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_paginatorModelType"
     },
     "paginatorView": {
      "!type": "fn()",
      "!doc": "A pointer to a `Y.View` object to be instantiated. A new view will be\ncreated for each location provided. Each view created will be given the\nsame model instance.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_paginatorView"
     },
     "pageSizes": {
      "!type": "fn()",
      "!doc": "Array of values used to populate the values in the Paginator UI allowing\nthe end user to select the number of items to display per page.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_pageSizes"
     },
     "rowsPerPage": {
      "!type": "fn()",
      "!doc": "Number of rows to display per page. As the UI changes the number of pages\nto display, this will update to reflect the value selected in the UI",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_rowsPerPage"
     },
     "paginatorLocation": {
      "!type": "fn()",
      "!doc": "String of `footer` or `header`, a Y.Node, or an Array or any combination\nof those values.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#attribute_paginatorLocation"
     },
     "firstPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the first page.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#method_firstPage"
     },
     "lastPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the last page.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#method_lastPage"
     },
     "previousPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the previous page.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#method_previousPage"
     },
     "nextPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the next page.",
      "!url": "http://alloyui.com/classes/DataTable.Paginator.html#method_nextPage"
     }
    }
   },
   "DataTable.TableView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering a `<table>` from provided data.  Used as\nthe default `view` for `Y.DataTable.Base` and `Y.DataTable` classes.",
    "!url": "http://alloyui.com/classes/DataTable.TableView.html",
    "prototype": {
     "CAPTION_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the caption Node if the `caption`\nattribute is set.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_CAPTION_TEMPLATE"
     },
     "TABLE_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table Node.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_TABLE_TEMPLATE"
     },
     "body": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `bodyView` that is\nresponsible for rendering and managing the table's `<tbody>`(s) and its\ncontent.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_body"
     },
     "foot": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `footerView` that is\nresponsible for rendering and managing the table's `<tfoot>` and its\ncontent.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_foot"
     },
     "head": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `headerView` that is\nresponsible for rendering and managing the table's `<thead>` and its\ncontent.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_head"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.taregt, [0, 1];</pre></code>\n\nThis is actually just a pass through to the `bodyView` instance's method\nby the same name.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#method_getCell"
     },
     "getRecord": {
      "!type": "fn(seed: string) -> +app.Model",
      "!doc": "Relays call to the `bodyView`'s `getRecord` method if it has one.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#method_getRecord"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.\n\nThis is actually just a pass through to the `bodyView` instance's method\nby the same name.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#method_getRow"
     },
     "displayColumns": {
      "!type": "[+yui.Object]",
      "!doc": "Array of the columns that correspond to those with value cells in the\ndata rows. Excludes colspan header columns (configured with `children`).",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#property_displayColumns"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the UI in the configured `container`.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#method_render"
     },
     "summary": {
      "!type": "fn()",
      "!doc": "Content for the `<table summary=\"ATTRIBUTE VALUE HERE\">`.  Values\nassigned to this attribute will be HTML escaped for security.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_summary"
     },
     "caption": {
      "!type": "fn()",
      "!doc": "HTML content of an optional `<caption>` element to appear above the\ntable.  Leave this config unset or set to a falsy value to remove the\ncaption.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_caption"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "Columns to include in the rendered table.\n\nThis attribute takes an array of objects. Each object is considered a\ndata column or header cell to be rendered.  How the objects are\ntranslated into markup is delegated to the `headerView`, `bodyView`,\nand `footerView`.\n\nThe raw value is passed to the `headerView` and `footerView`.  The\n`bodyView` receives the instance's `displayColumns` array, which is\nparsed from the columns array.  If there are no nested columns (columns\nconfigured with a `children` array), the `displayColumns` is the same\nas the raw value.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_columns"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Width of the table including borders.  This value requires units, so\n`200` is invalid, but `'200px'` is valid.  Setting the empty string\n(the default) will allow the browser to set the table width.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_width"
     },
     "headerView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the\n`<thead>`&mdash;the column headers for the table.\n\nThe instance of this View will be assigned to the instance's `head`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_headerView"
     },
     "headerConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `headerView`\ninstance.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_headerConfig"
     },
     "footerView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the\n`<tfoot>` (if appropriate).\n\nThe instance of this View will be assigned to the instance's `foot`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_footerView"
     },
     "footerConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `footerView`\ninstance.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_footerConfig"
     },
     "bodyView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the table's\n`<tbody>`&mdash;the data cells in the table.\n\nThe instance of this View will be assigned to the instance's `body`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_bodyView"
     },
     "bodyConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `bodyView`\ninstance.",
      "!url": "http://alloyui.com/classes/DataTable.TableView.html#attribute_bodyConfig"
     }
    }
   },
   "Date": {
    "!type": "fn()",
    "!doc": "Date provides a set of utility functions to operate against Date objects.",
    "!url": "http://alloyui.com/classes/Date.html",
    "prototype": {
     "undefined": {
      "!type": "fn()",
      "!doc": "It happens that the native DOM property `document.activeElement` is not always\nreliable, not in all browsers (guess which?).  The only reliable way to\nfind out which element has the focus is to set listeners for the `focus` event.\nSince `focus` does not bubble and since this is a test suite and not a final product,\nindividual listeners are set on each individual cell that might get the focus.\nAlso, some browsers (yes the same ones) don't fire `focus` synchronously\nbut do so at the first idle moment.  This means that you have to pause execution\nso the event can fire.  It can be done via `window.setTimeout` or, within a test\nsuite, using method `wait`.\nThat is why this `activeElement` variable exists.  It replaces the native\n`document.activeElement`.\nFor any test that has to check which cell got the focus, you have to call\n`setFocusListeners` first which will set all the listeners to track the cell\nwith the focus.\n`setFocusListeners` is an asynchronous method since its first task is to\nforce the first `focus` event to get fired. To do that it calls the `blur`\nmethod of the datatable instance before setting the listeners\nand the`focus` method  after so as to pick the initial focused element.\nSince the `focus` event is asynchronous, the `setFocusListeners` is forced\nto be asynchronous as well.\nNote that `fireKey` also needs to know which element has the focus so even\nif the test doesn't directly need to check the focused element, if you use\n`fireKey` you also need to call `setFocusListeners.",
      "!url": "http://alloyui.com/classes/Date.html"
     }
    }
   }
  },
  "datatable_formatters": {
   "DataTable.BodyView.Formatters": {
    "!type": "fn()",
    "!doc": "Registry of function producing cell formatting functions.\nAllows for names to be used in the column\ndefinition `formatter` property:\n\n    {key:\"myColumn\", formatter:\"date\"}\n\nThese functions are not meant to be used directly.  Instead, they will be\nautomatically called when their names are used as values for the `formatter`\nproperty in a columnd definition.\nThey will be called just once per rendering cycle and will receive\nthe column configuration.  They are expected to return a function that will\nthen be called once per row and will do the actual formatting.\nThey are expected to do all the preparatory once-per-render work\nso that the actual formatting function doesn't need to repeat it.",
    "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html",
    "button": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter that produces a BUTTON element using the value of\nthe [buttonLabel](DataTable.Column.html#property_buttonLabel)\ncolumn definition attribute as its label or the text\n`Click` if not found.\n\nApplies the CSS className `yui3-datatable-button` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_button"
    },
    "boolean": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that returns the texts `\"true\"` or `\"false\"`\nand assigns the CSS classNames `yui3-datatable-true` or `yui3-datatable-false`\nbased on the value of the cell.\n\nIf either a [booleanLabels](DataTable.Column.html#property_booleanLabels)\n configuration object is defined for the column\nor a [booleanLabels](DataTable.html#attr_booleanLabels)\nconfiguration attribute is defined for the datatable,\nthe formatter will use the values for the properties `true` or `false`\nof either of those objects as the text to show.\n\nIt returns `null`s or `undefined`s unchanged so that the `emptyCellValue`\nconfiguration attribute will eventually apply.\n\n     {key:\"active\", formatter: \"boolean\", booleanLabels: {\n         \"true\": \"yes\",\n         \"false\": \"no\"\n     }}",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_boolean"
    },
    "currency": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that formats values as currency using\nthe [Number.format](Number.html#method_format) method.\nIt looks for the format to apply in the\n[currencyFormat](DataTable.Column.html#property_currencyFormat) property\nof the column or in the\n[currencyFormat](DataTable.html#attr_currencyFormat)\n attribute of the whole table.\n\n    {key: \"amount\", formatter: \"currency\", currencyFormat: {\n        decimalPlaces:2,\n        decimalSeparator: \",\",\n        thousandsSeparator: \".\",\n        suffix: \"&euro;\"\n    }}\n\nSee [Number.format](Number.html#method_format) for the available format specs.\n\nAnything that cannot be parsed as a number will be returned unchanged.\n\nApplies the CSS className `yui3-datatable-currency` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_currency"
    },
    "date": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a date formatting function.\nIt looks for the format to apply in the\n[dateFormat](DataTable.Column.html#property_dateFormat)\nproperty of the column or in the\n[dateFormat](DataTable.html#attr_dateFormat)\n attribute of the whole table.\n\n    {key: \"DOB\", formatter: \"date\", dateFormat: \"%I:%M:%S %p\"}\n\nSee [Date.format](Date.html#method_format) for the available format specs.\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_date"
    },
    "localDate": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a date-only (no time part) formatting function using the current locale.\n\n    {key: \"DOB\", formatter: \"localDate\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_localDate"
    },
    "localTime": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a time-only (no date part) formatting function using the current locale.\n\n    {key: \"startTime\", formatter: \"localTime\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_localTime"
    },
    "localDateTime": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a date formatting function using the current locale.\n\n    {key: \"DOB\", formatter: \"localDateTime\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_localDateTime"
    },
    "email": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a function that produces email links.\nIf the column definition contains a property\n[linkFrom](DataTable.Column.html#property_linkFrom) it will use the value\nin that field for the link, otherwise, the same column value will be used for both\nlink and text.\n\n    {key: \"contact\", formatter: \"email\", linkFrom: \"contactEmail\"}\n\nIt will use the respective\n[emptyCellValue](DataTable.Column.html#property_emptyCellValue)\ncolumn configuration attribute\nfor each of the value and the link if either is empty.\nIf the link value is still empty, it will return the value with no link.\n\nApplies the CSS className `yui3-datatable-email` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_email"
    },
    "link": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a function that produces links.\nIf the column definition contains a property\n[linkFrom](DataTable.Column.html#property_linkFrom) it will use the value\nin that field for the link, otherwise, the same column value will be used for both\nlink and text.\n\n    {key: \"company\", formatter: \"link\", linkFrom: \"webSite\"}\n\nIt will use the respective\n[emptyCellValue](DataTable.Column.html#property_emptyCellValue)\n column configuration attribute\nfor each of the value and the link if either is empty.\nIf the link value is still empty, it will return the value with no link.\n\nApplies the CSS className `yui3-datatable-link` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_link"
    },
    "number": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that formats values using\nthe [Number.format](Number.html#method_format) method.\nIt looks for the format to apply in the\n[numberFormat](DataTable.Column.html#property_numberFormat)\nproperty of the column or in the\n[numberFormat](DataTable.html#attr_numberFormat)\nattribute of the whole table.\n\n     {key: \"weight\", formatter: \"number\", numberFormat: {\n         decimalPlaces:2,\n         decimalSeparator: \",\",\n         thousandsSeparator: \",\",\n         suffix: \"kg\"\n     }}\n\nSee [Number.format](Number.html#method_format) for the available format specs.\n\nAnything that cannot be parsed as a number will be returned unchanged.\n\nApplies the CSS className `yui3-datatable-number` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_number"
    },
    "lookup": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that returns texts from a lookup table\nbased on the stored value.\n\nIt looks for the translation to apply in the\n[lookupTable](DataTable.Column.html#property_lookupTable) property of the\ncolumn in either of these two formats:\n\n    {key: \"status\", formatter: \"lookup\", lookupTable: {\n        0: \"unknown\",\n        1: \"requested\",\n        2: \"approved\",\n        3: \"delivered\"\n    }},\n    {key: \"otherStatus\", formatter: \"lookup\", lookupTable: [\n        {value:0, text: \"unknown\"},\n        {value:1, text: \"requested\"},\n        {value:2, text: \"approved\"},\n        {value:3, text: \"delivered\"}\n    ]}\n\nApplies the CSS className `yui3-datatable-lookup` to the cell.",
     "!url": "http://alloyui.com/classes/DataTable.BodyView.Formatters.html#method_lookup"
    }
   },
   "DataTable.Column": {
    "!type": "fn()",
    "!doc": "_This is a documentation entry only_\n\nColumns are described by object literals with a set of properties.\nThere is not an actual `DataTable.Column` class.\nHowever, for the purpose of documenting it, this pseudo-class is declared here.\n\nDataTables accept an array of column definitions in their [columns](DataTable.html#attr_columns)\nattribute.  Each entry in this array is a column definition which may contain\nany combination of the properties listed below.\n\nThere are no mandatory properties though a column will usually have a\n[key](#property_key) property to reference the data it is supposed to show.\nThe [columns](DataTable.html#attr_columns) attribute can accept a plain string\nin lieu of an object literal, which is the equivalent of an object with the\n[key](#property_key) property set to that string.",
    "!url": "http://alloyui.com/classes/DataTable.Column.html",
    "prototype": {
     "buttonLabel": {
      "!type": "string",
      "!doc": "Label to be shown in the face of a button produced by the\n[button](DataTable.BodyView.Formatters.html#method_button) formatter",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_buttonLabel"
     },
     "booleanLabels": {
      "!type": "+yui.Object",
      "!doc": "Determines the texts to be shown to represent Boolean values when the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter\nis used.\n\nThe attribute is an object with text values for properties `true` and `false`.\n\n    {key:\"active\", formatter: \"boolean\", booleanLabels: {\n        \"true\": \"yes\",\n        \"false\": \"no\"\n    }}",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_booleanLabels"
     },
     "currencyFormat": {
      "!type": "+yui.Object",
      "!doc": "Format specification for columns using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_currencyFormat"
     },
     "dateFormat": {
      "!type": "string",
      "!doc": "Format specification for columns using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\nIt contains a string as described in\n[Date.format](Date.html#method_format).",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_dateFormat"
     },
     "linkFrom": {
      "!type": "string",
      "!doc": "Name of the field that is to provide the link for a column using the\n[email](DataTable.BodyView.Formatters.html#method_email) or\n[link](DataTable.BodyView.Formatters.html#method_link)\nformatters.",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_linkFrom"
     },
     "numberFormat": {
      "!type": "+yui.Object",
      "!doc": "Format specification for columns using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_numberFormat"
     },
     "lookupTable": {
      "!type": "+yui.Object",
      "!doc": "Map of values to text used to translate internal values to human readable text\nin columns using the [lookup](DataTable.BodyView.Formatters.html#method_lookup)\nformatter.\n\nThe map can be given in either of two formats:\n\n    {key: \"status\", formatter: \"lookup\", lookupTable: {\n        0: \"unknown\",\n        1: \"requested\",\n        2: \"approved\",\n        3: \"delivered\"\n    }},\n    {key: \"otherStatus\", formatter: \"lookup\", lookupTable: [\n        {value:0, text: \"unknown\"},\n        {value:1, text: \"requested\"},\n        {value:2, text: \"approved\"},\n        {value:3, text: \"delivered\"}\n    ]}\n\nThe last format is compatible with the [dropdown](DataTable.Editors.html#property_dropdown)\nand autocomplete-based editors, where the order of the items in the dropdown matters.",
      "!url": "http://alloyui.com/classes/DataTable.Column.html#property_lookupTable"
     }
    }
   },
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://alloyui.com/classes/DataTable.html",
    "prototype": {
     "booleanLabels": {
      "!type": "fn()",
      "!doc": "Determines the texts to be shown to represent Boolean values when the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter\nis used on any column.\n\nIt works like the column-specific\n[booleanLabels](DataTable.Column.html#property_booleanLabels) but\nfor all columns using the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter at once.\nThe values are often retrieved from a resource of localized texts.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_booleanLabels"
     },
     "currencyFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).\n\nIt is similar to\n[currencyFormat](DataTable.Column.html#property_currencyFormat)\nbut it applies to any column using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_currencyFormat"
     },
     "dateFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\nIt contains an object as described in\n[Date.format](Date.html#method_format).\n\nIt is similar to\n[dateFormat](DataTable.Column.html#property_dateFormat)\nbut it applies to any column using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_dateFormat"
     },
     "numberFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).\n\nIt is similar to\n[numberFormat](DataTable.Column.html#property_numberFormat)\nbut it applies to any column using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_numberFormat"
     }
    }
   }
  },
  "datatable_scroll": {
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://alloyui.com/classes/DataTable.html",
    "prototype": {
     "scrollable": {
      "!type": "fn()",
      "!doc": "Activates or deactivates scrolling in the table.  Acceptable values are:\n\n * `false` - (default) Scrolling is disabled.\n * `true` or 'xy' - If `height` is set, vertical scrolling will be\n   activated, if `width` is set, horizontal scrolling will be activated.\n * 'x' - Activate horizontal scrolling only. Requires the `width` attribute\n   is also set.\n * 'y' - Activate vertical scrolling only. Requires the `height` attribute\n   is also set.",
      "!url": "http://alloyui.com/classes/DataTable.html#attribute_scrollable"
     },
     "scrollTo": {
      "!type": "fn(id: string) -> !this",
      "!doc": "Scrolls a given row or cell into view if the table is scrolling.  Pass the\n`clientId` of a Model from the DataTable's `data` ModelList or its row\nindex to scroll to a row or a [row index, column index] array to scroll to\na cell.  Alternately, to scroll to any element contained within the table's\nscrolling areas, pass its ID, or the Node itself (though you could just as\nwell call `node.scrollIntoView()` yourself, but hey, whatever).",
      "!url": "http://alloyui.com/classes/DataTable.html#method_scrollTo"
     }
    }
   }
  },
  "datatype_date": {
   "Date": {
    "!type": "fn()",
    "!doc": "Date provides a set of utility functions to operate against Date objects.",
    "!url": "http://alloyui.com/classes/Date.html",
    "prototype": {
     "format": {
      "!type": "fn(oDate: datatype_date.Date, oConfig: yui.Object) -> +HTML",
      "!doc": "Takes a native JavaScript Date and formats it as a string for display to user.",
      "!url": "http://alloyui.com/classes/Date.html#method_format"
     },
     "isValidDate": {
      "!type": "fn(oDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether a native JavaScript Date contains a valid value.",
      "!url": "http://alloyui.com/classes/Date.html#method_isValidDate"
     },
     "areEqual": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether two dates correspond to the same date and time.",
      "!url": "http://alloyui.com/classes/Date.html#method_areEqual"
     },
     "isGreater": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the first date comes later than the second.",
      "!url": "http://alloyui.com/classes/Date.html#method_isGreater"
     },
     "isGreaterOrEqual": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the first date comes later than or is the same as\nthe second.",
      "!url": "http://alloyui.com/classes/Date.html#method_isGreaterOrEqual"
     },
     "isInRange": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date, cDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the date is between two other given dates.",
      "!url": "http://alloyui.com/classes/Date.html#method_isInRange"
     },
     "addDays": {
      "!type": "fn(oDate: datatype_date.Date, numDays: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of days to the given date.",
      "!url": "http://alloyui.com/classes/Date.html#method_addDays"
     },
     "addMonths": {
      "!type": "fn(oDate: datatype_date.Date, numMonths: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of months to the given date.",
      "!url": "http://alloyui.com/classes/Date.html#method_addMonths"
     },
     "addYears": {
      "!type": "fn(oDate: datatype_date.Date, numYears: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of years to the given date.",
      "!url": "http://alloyui.com/classes/Date.html#method_addYears"
     },
     "listOfDatesInMonth": {
      "!type": "fn(oDate: datatype_date.Date) -> +yui.Array",
      "!doc": "Lists all dates in a given month.",
      "!url": "http://alloyui.com/classes/Date.html#method_listOfDatesInMonth"
     },
     "daysInMonth": {
      "!type": "fn(oDate: datatype_date.Date) -> number",
      "!doc": "Takes a native JavaScript Date and returns the number of days\nin the month that the given date belongs to.",
      "!url": "http://alloyui.com/classes/Date.html#method_daysInMonth"
     },
     "parse": {
      "!type": "fn(data: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Converts data to type Date.",
      "!url": "http://alloyui.com/classes/Date.html#method_parse"
     }
    }
   }
  },
  "dd": {
   "Plugin.DDConstrained": {
    "!type": "fn() -> +dd.Plugin.DDConstrained",
    "!proto": "base.Base",
    "!doc": "Plugin for the dd-drag module to add the constraining methods to it.\nIt supports constraining to a node or viewport. It supports tick based moves and XY axis constraints.",
    "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html",
    "prototype": {
     "drag:tickAlignX": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned with the tickX value.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#event_drag:tickAlignX"
     },
     "drag:tickAlignY": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned with the tickY value.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#event_drag:tickAlignY"
     },
     "stickX": {
      "!type": "fn()",
      "!doc": "Stick the drag movement to the X-Axis. Default: false",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_stickX"
     },
     "stickY": {
      "!type": "fn()",
      "!doc": "Stick the drag movement to the Y-Axis",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_stickY"
     },
     "tickX": {
      "!type": "fn()",
      "!doc": "The X tick offset the drag node should snap to on each drag move. False for no ticks. Default: false",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_tickX"
     },
     "tickY": {
      "!type": "fn()",
      "!doc": "The Y tick offset the drag node should snap to on each drag move. False for no ticks. Default: false",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_tickY"
     },
     "tickXArray": {
      "!type": "fn()",
      "!doc": "An array of page coordinates to use as X ticks for drag movement.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_tickXArray"
     },
     "tickYArray": {
      "!type": "fn()",
      "!doc": "An array of page coordinates to use as Y ticks for drag movement.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_tickYArray"
     },
     "gutter": {
      "!type": "fn()",
      "!doc": "CSS style string for the gutter of a region (supports negative values): '5 0'\n(sets top and bottom to 5px, left and right to 0px), '1 2 3 4' (top 1px, right 2px, bottom 3px, left 4px)",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_gutter"
     },
     "constrain": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries. Arguments:<br>\n'view': Contrain to Viewport<br>\n'#selector_string': Constrain to this node<br>\n'{Region Object}': An Object Literal containing a valid region (top, right, bottom, left) of page positions",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_constrain"
     },
     "constrain2region": {
      "!type": "fn()",
      "!doc": "An Object Literal containing a valid region (top, right, bottom, left) of page positions to constrain the drag node to.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_constrain2region"
     },
     "constrain2node": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries of this node.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_constrain2node"
     },
     "constrain2view": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries of the viewport region.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_constrain2view"
     },
     "cacheRegion": {
      "!type": "fn()",
      "!doc": "Should the region be cached for performace. Default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#attribute_cacheRegion"
     },
     "resetCache": {
      "!type": "fn()",
      "!doc": "Reset the internal region cache.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#method_resetCache"
     },
     "getRegion": {
      "!type": "fn(inc: bool) -> +yui.Object",
      "!doc": "Get the active region: viewport, node, custom region",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#method_getRegion"
     },
     "inRegion": {
      "!type": "fn(xy: yui.Array) -> bool",
      "!doc": "Checks if the XY passed or the dragNode is inside the active region.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#method_inRegion"
     },
     "align": {
      "!type": "fn()",
      "!doc": "Modifies the Drag.actXY method from the after drag:align event. This is where the constraining happens.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#method_align"
     },
     "drag": {
      "!type": "fn()",
      "!doc": "Fires after drag:drag. Handle the tickX and tickX align events.",
      "!url": "http://alloyui.com/classes/Plugin.DDConstrained.html#method_drag"
     }
    }
   },
   "Plugin.Drop": {
    "!type": "fn() -> +dd.Plugin.Drop",
    "!proto": "dd.DD.Drop",
    "!doc": "Simple Drop plugin that can be attached to a Node via the plug method.",
    "!url": "http://alloyui.com/classes/Plugin.Drop.html",
    "prototype": {
     "NAME": {
      "!type": "string",
      "!doc": "dd-drop-plugin",
      "!url": "http://alloyui.com/classes/Plugin.Drop.html#property_NAME"
     },
     "NS": {
      "!type": "string",
      "!doc": "The Drop instance will be placed on the Node instance under the drop namespace. It can be accessed via Node.drop;",
      "!url": "http://alloyui.com/classes/Plugin.Drop.html#property_NS"
     }
    }
   },
   "Plugin.Drag": {
    "!type": "fn() -> +dd.Plugin.Drag",
    "!proto": "dd.DD.Drag",
    "!doc": "Simple Drag plugin that can be attached to a Node or Widget via the plug method.",
    "!url": "http://alloyui.com/classes/Plugin.Drag.html",
    "prototype": {
     "NAME": {
      "!type": "string",
      "!doc": "dd-plugin",
      "!url": "http://alloyui.com/classes/Plugin.Drag.html#property_NAME"
     },
     "NS": {
      "!type": "string",
      "!doc": "The Drag instance will be placed on the Node instance under the dd namespace. It can be accessed via Node.dd;",
      "!url": "http://alloyui.com/classes/Plugin.Drag.html#property_NS"
     }
    }
   },
   "DD.DDM": {
    "!type": "fn() -> +dd.DD.DDM",
    "!proto": "base.Base",
    "!doc": "Provides the base Drag Drop Manager required for making a Node draggable.",
    "!url": "http://alloyui.com/classes/DD.DDM.html",
    "prototype": {
     "dragCursor": {
      "!type": "fn()",
      "!doc": "The cursor to apply when dragging, if shimmed the shim will get the cursor.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#attribute_dragCursor"
     },
     "clickPixelThresh": {
      "!type": "fn()",
      "!doc": "The number of pixels to move to start a drag operation, default is 3.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#attribute_clickPixelThresh"
     },
     "clickTimeThresh": {
      "!type": "fn()",
      "!doc": "The number of milliseconds a mousedown has to pass to start a drag operation, default is 1000.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#attribute_clickTimeThresh"
     },
     "throttleTime": {
      "!type": "fn()",
      "!doc": "The number of milliseconds to throttle the mousemove event. Default: 150",
      "!url": "http://alloyui.com/classes/DD.DDM.html#attribute_throttleTime"
     },
     "dragMode": {
      "!type": "fn()",
      "!doc": "This attribute only works if the dd-drop module is active. It will set the dragMode (point, intersect, strict) of all future Drag instances.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#attribute_dragMode"
     },
     "_active": {
      "!type": "bool",
      "!doc": "flag set when we activate our first drag, so DDM can start listening for events.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property__active"
     },
     "CSS_PREFIX": {
      "!type": "string",
      "!doc": "The PREFIX to attach to all DD CSS class names",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_CSS_PREFIX"
     },
     "activeDrag": {
      "!type": "+Drag",
      "!doc": "A reference to the currently active draggable object.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_activeDrag"
     },
     "stopDrag": {
      "!type": "fn() -> !this",
      "!doc": "Method will forcefully stop a drag operation. For example calling this from inside an ESC keypress handler will stop this drag.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_stopDrag"
     },
     "getDrag": {
      "!type": "fn(node: string) -> +yui.Object",
      "!doc": "Get a valid Drag instance back from a Node or a selector string, false otherwise",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_getDrag"
     },
     "swapPosition": {
      "!type": "fn(n1: node.Node, n2: node.Node) -> +node.Node",
      "!doc": "Swap the position of 2 nodes based on their CSS positioning.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_swapPosition"
     },
     "getNode": {
      "!type": "fn(n: node.Node) -> +node.Node",
      "!doc": "Return a node instance from the given node, selector string or Y.Base extended object.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_getNode"
     },
     "swapNode": {
      "!type": "fn(n1: node.Node, n2: node.Node) -> +node.Node",
      "!doc": "Swap the position of 2 nodes based on their DOM location.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_swapNode"
     },
     "ddm:start": {
      "!type": "fn()",
      "!doc": "Fires from the DDM before all drag events fire.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#event_ddm:start"
     },
     "ddm:end": {
      "!type": "fn()",
      "!doc": "Fires from the DDM after the DDM finishes, before the drag end events.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#event_ddm:end"
     },
     "syncActiveShims": {
      "!type": "fn(force: bool)",
      "!doc": "This method will sync the position of the shims on the Drop Targets that are currently active.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_syncActiveShims"
     },
     "useHash": {
      "!type": "bool",
      "!doc": "Should we only check targets that are in the viewport on drags (for performance), default: true",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_useHash"
     },
     "activeDrop": {
      "!type": "+yui.Object",
      "!doc": "A reference to the active Drop Target",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_activeDrop"
     },
     "validDrops": {
      "!type": "+yui.Array",
      "!doc": "An array of the valid Drop Targets for this interaction.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_validDrops"
     },
     "otherDrops": {
      "!type": "+yui.Object",
      "!doc": "An object literal of Other Drop Targets that we encountered during this interaction (in the case of overlapping Drop Targets)",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_otherDrops"
     },
     "targets": {
      "!type": "+yui.Array",
      "!doc": "All of the Targets",
      "!url": "http://alloyui.com/classes/DD.DDM.html#property_targets"
     },
     "isOverTarget": {
      "!type": "fn(drop: yui.Object) -> bool",
      "!doc": "Check to see if the Drag element is over the target, method varies on current mode",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_isOverTarget"
     },
     "clearCache": {
      "!type": "fn()",
      "!doc": "Clears the cache data used for this interaction.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_clearCache"
     },
     "getBestMatch": {
      "!type": "fn(drops: yui.Array, all: bool) -> +Object or Array",
      "!doc": "This method will gather the area for all potential targets and see which has the hightest covered area and return it.",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_getBestMatch"
     },
     "getDrop": {
      "!type": "fn(node: string) -> +yui.Object",
      "!doc": "Get a valid Drop instance back from a Node or a selector string, false otherwise",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_getDrop"
     },
     "regDelegate": {
      "!type": "fn()",
      "!doc": "Register a Delegate with the DDM",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_regDelegate"
     },
     "getDelegate": {
      "!type": "fn() -> ?",
      "!doc": "Get a delegate instance from a container node",
      "!url": "http://alloyui.com/classes/DD.DDM.html#method_getDelegate"
     }
    }
   },
   "DD.Delegate": {
    "!type": "fn() -> +dd.DD.Delegate",
    "!proto": "base.Base",
    "!doc": "Provides the ability to drag multiple nodes under a container element using only one Y.DD.Drag instance as a delegate.",
    "!url": "http://alloyui.com/classes/DD.Delegate.html",
    "prototype": {
     "dd": {
      "!type": "?",
      "!doc": "A reference to the temporary dd instance used under the hood.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#property_dd"
     },
     "syncTargets": {
      "!type": "fn() -> !this",
      "!doc": "Applies the Y.Plugin.Drop to all nodes matching the cont + nodes selector query.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#method_syncTargets"
     },
     "createDrop": {
      "!type": "fn(node: node.Node, groups: yui.Array) -> ?",
      "!doc": "Apply the Drop plugin to this node",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#method_createDrop"
     },
     "container": {
      "!type": "fn()",
      "!doc": "A selector query to get the container to listen for mousedown events on. All \"nodes\" should be a child of this container.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_container"
     },
     "nodes": {
      "!type": "fn()",
      "!doc": "A selector query to get the children of the \"container\" to make draggable elements from.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_nodes"
     },
     "invalid": {
      "!type": "fn()",
      "!doc": "A selector query to test a node to see if it's an invalid item.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_invalid"
     },
     "lastNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the last item dragged.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_lastNode"
     },
     "currentNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the dd node.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_currentNode"
     },
     "dragNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the dd dragNode.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_dragNode"
     },
     "over": {
      "!type": "fn()",
      "!doc": "Is the mouse currently over the container",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_over"
     },
     "target": {
      "!type": "fn()",
      "!doc": "Should the items also be a drop target.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_target"
     },
     "dragConfig": {
      "!type": "fn()",
      "!doc": "The default config to be used when creating the DD instance.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_dragConfig"
     },
     "handles": {
      "!type": "fn()",
      "!doc": "The handles config option added to the temp DD instance.",
      "!url": "http://alloyui.com/classes/DD.Delegate.html#attribute_handles"
     }
    }
   },
   "DD.Drag": {
    "!type": "fn() -> +dd.DD.Drag",
    "!proto": "base.Base",
    "!doc": "Provides the ability to drag a Node.",
    "!url": "http://alloyui.com/classes/DD.Drag.html",
    "prototype": {
     "drag:mouseup": {
      "!type": "fn()",
      "!doc": "Handles the mouseup DOM event, does nothing internally just fires.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:mouseup"
     },
     "drag:mouseDown": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the mousedown DOM event, checks to see if you have a valid handle then starts the drag timers.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:mouseDown"
     },
     "drag:afterMouseDown": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after the mousedown event has been cleared.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:afterMouseDown"
     },
     "drag:removeHandle": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after a handle is removed.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:removeHandle"
     },
     "drag:addHandle": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after a handle is added.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:addHandle"
     },
     "drag:removeInvalid": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after an invalid selector is removed.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:removeInvalid"
     },
     "drag:addInvalid": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after an invalid selector is added.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:addInvalid"
     },
     "drag:start": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires at the start of a drag operation.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:start"
     },
     "drag:end": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires at the end of a drag operation.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:end"
     },
     "drag:drag": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires every mousemove during a drag operation.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:drag"
     },
     "drag:align": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:align"
     },
     "drag:over": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is over a Drop Target. (Fired from dd-drop)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:over"
     },
     "drag:enter": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node enters a Drop Target. (Fired from dd-drop)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:enter"
     },
     "drag:exit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node exits a Drop Target. (Fired from dd-drop)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:exit"
     },
     "drag:drophit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is dropped on a valid Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:drophit"
     },
     "drag:dropmiss": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is dropped on an invalid Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#event_drag:dropmiss"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the element to initiate a drag operation",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_node"
     },
     "dragNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the draggable element, defaults to node",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_dragNode"
     },
     "offsetNode": {
      "!type": "fn()",
      "!doc": "Offset the drag element by the difference in cursor position: default true",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_offsetNode"
     },
     "startCentered": {
      "!type": "fn()",
      "!doc": "Center the dragNode to the mouse position on drag:start: default false",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_startCentered"
     },
     "clickPixelThresh": {
      "!type": "fn()",
      "!doc": "The number of pixels to move to start a drag operation, default is 3.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_clickPixelThresh"
     },
     "clickTimeThresh": {
      "!type": "fn()",
      "!doc": "The number of milliseconds a mousedown has to pass to start a drag operation, default is 1000.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_clickTimeThresh"
     },
     "lock": {
      "!type": "fn()",
      "!doc": "Set to lock this drag element so that it can't be dragged: default false.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_lock"
     },
     "data": {
      "!type": "fn()",
      "!doc": "A payload holder to store arbitrary data about this drag object, can be used to store any value.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_data"
     },
     "move": {
      "!type": "fn()",
      "!doc": "If this is false, the drag element will not move with the cursor: default true. Can be used to \"resize\" the element.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_move"
     },
     "useShim": {
      "!type": "fn()",
      "!doc": "Use the protective shim on all drag operations: default true. Only works with dd-ddm, not dd-ddm-base.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_useShim"
     },
     "activeHandle": {
      "!type": "fn()",
      "!doc": "Config option is set by Drag to inform you of which handle fired the drag event (in the case that there are several handles): default false.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_activeHandle"
     },
     "primaryButtonOnly": {
      "!type": "fn()",
      "!doc": "By default a drag operation will only begin if the mousedown occurred with the primary mouse button.\nSetting this to false will allow for all mousedown events to trigger a drag.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_primaryButtonOnly"
     },
     "dragging": {
      "!type": "fn()",
      "!doc": "This attribute is not meant to be used by the implementor, it is meant to be used as an Event tracker so you can listen for it to change.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_dragging"
     },
     "target": {
      "!type": "+yui.Object",
      "!doc": "This will be a reference to the Drop instance associated with this drag if the target: true config attribute is set..",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_target"
     },
     "dragMode": {
      "!type": "fn()",
      "!doc": "This attribute only works if the dd-drop module is active. It will set the dragMode (point, intersect, strict) of this Drag instance.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_dragMode"
     },
     "groups": {
      "!type": "fn()",
      "!doc": "Array of groups to add this drag into.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_groups"
     },
     "handles": {
      "!type": "fn()",
      "!doc": "Array of valid handles to add. Adding something here will set all handles, even if previously added with addHandle",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_handles"
     },
     "bubbles": {
      "!type": "fn()",
      "!doc": "Controls the default bubble parent for this Drag instance. Default: Y.DD.DDM. Set to false to disable bubbling. Use bubbleTargets in config",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_bubbles"
     },
     "haltDown": {
      "!type": "fn()",
      "!doc": "Should the mousedown event be halted. Default: true",
      "!url": "http://alloyui.com/classes/DD.Drag.html#attribute_haltDown"
     },
     "addToGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Add this Drag instance to a group, this should be used for on-the-fly group additions.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_addToGroup"
     },
     "removeFromGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Remove this Drag instance from a group, this should be used for on-the-fly group removals.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_removeFromGroup"
     },
     "deltaXY": {
      "!type": "+yui.Array",
      "!doc": "The offset of the mouse position to the element's position",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_deltaXY"
     },
     "startXY": {
      "!type": "+yui.Array",
      "!doc": "The initial mouse position",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_startXY"
     },
     "nodeXY": {
      "!type": "+yui.Array",
      "!doc": "The initial element position",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_nodeXY"
     },
     "lastXY": {
      "!type": "+yui.Array",
      "!doc": "The position of the element as it's moving (for offset calculations)",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_lastXY"
     },
     "actXY": {
      "!type": "+yui.Array",
      "!doc": "The xy that the node will be set to. Changing this will alter the position as it's dragged.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_actXY"
     },
     "realXY": {
      "!type": "+yui.Array",
      "!doc": "The real xy position of the node.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_realXY"
     },
     "mouseXY": {
      "!type": "+yui.Array",
      "!doc": "The XY coords of the mousemove",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_mouseXY"
     },
     "region": {
      "!type": "+yui.Object",
      "!doc": "A region object associated with this drag, used for checking regions while dragging.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#property_region"
     },
     "validClick": {
      "!type": "fn(ev: event_custom.EventFacade) -> bool",
      "!doc": "Method first checks to see if we have handles, if so it validates the click\nagainst the handle. Then if it finds a valid handle, it checks it against\nthe invalid handles list. Returns true if a good handle was used, false otherwise.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_validClick"
     },
     "removeHandle": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Remove a Selector added by addHandle",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_removeHandle"
     },
     "addHandle": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Add a handle to a drag element. Drag only initiates when a mousedown happens on this element.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_addHandle"
     },
     "removeInvalid": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Remove an invalid handle added by addInvalid",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_removeInvalid"
     },
     "addInvalid": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Add a selector string to test the handle against. If the test passes the drag operation will not continue.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_addInvalid"
     },
     "start": {
      "!type": "fn() -> !this",
      "!doc": "Starts the drag operation",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_start"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Ends the drag operation",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_end"
     },
     "stopDrag": {
      "!type": "fn() -> !this",
      "!doc": "Method will forcefully stop a drag operation. For example calling this from inside an ESC keypress handler will stop this drag.",
      "!url": "http://alloyui.com/classes/DD.Drag.html#method_stopDrag"
     }
    },
    "START_EVENT": {
     "!type": "?",
     "!doc": "This property defaults to \"mousedown\", but when drag-gestures is loaded, it is changed to \"gesturemovestart\"",
     "!url": "http://alloyui.com/classes/DD.Drag.html#property_START_EVENT"
    }
   },
   "DD.Drop": {
    "!type": "fn() -> +dd.DD.Drop",
    "!proto": "base.Base",
    "!doc": "Provides the ability to create a Drop Target.",
    "!url": "http://alloyui.com/classes/DD.Drop.html",
    "prototype": {
     "drop:over": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element is over this target.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#event_drop:over"
     },
     "drop:enter": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element enters this target.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#event_drop:enter"
     },
     "drop:exit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element exits this target.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#event_drop:exit"
     },
     "drop:hit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a draggable node is dropped on this Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://alloyui.com/classes/DD.Drop.html#event_drop:hit"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the element to make a Drop Target",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_node"
     },
     "groups": {
      "!type": "fn()",
      "!doc": "Array of groups to add this drop into.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_groups"
     },
     "padding": {
      "!type": "fn()",
      "!doc": "CSS style padding to make the Drop Target bigger than the node.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_padding"
     },
     "lock": {
      "!type": "fn()",
      "!doc": "Set to lock this drop element.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_lock"
     },
     "bubbles": {
      "!type": "fn()",
      "!doc": "Controls the default bubble parent for this Drop instance. Default: Y.DD.DDM. Set to false to disable bubbling.\nUse bubbleTargets in config.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_bubbles"
     },
     "useShim": {
      "!type": "fn()",
      "!doc": "Use the Drop shim. Default: true",
      "!url": "http://alloyui.com/classes/DD.Drop.html#attribute_useShim"
     },
     "addToGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Add this Drop instance to a group, this should be used for on-the-fly group additions.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#method_addToGroup"
     },
     "removeFromGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Remove this Drop instance from a group, this should be used for on-the-fly group removals.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#method_removeFromGroup"
     },
     "shim": {
      "!type": "+yui.Object",
      "!doc": "Node reference to the targets shim",
      "!url": "http://alloyui.com/classes/DD.Drop.html#property_shim"
     },
     "region": {
      "!type": "+yui.Object",
      "!doc": "A region object associated with this target, used for checking regions while dragging.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#property_region"
     },
     "overTarget": {
      "!type": "bool",
      "!doc": "This flag is tripped when a drag element is over this target.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#property_overTarget"
     },
     "inGroup": {
      "!type": "fn(groups: yui.Array) -> ?",
      "!doc": "Check if this target is in one of the supplied groups.",
      "!url": "http://alloyui.com/classes/DD.Drop.html#method_inGroup"
     },
     "sizeShim": {
      "!type": "fn()",
      "!doc": "Positions and sizes the shim with the raw data from the node,\nthis can be used to programatically adjust the Targets shim for Animation..",
      "!url": "http://alloyui.com/classes/DD.Drop.html#method_sizeShim"
     }
    }
   },
   "Plugin.DDProxy": {
    "!type": "fn() -> +dd.Plugin.DDProxy",
    "!proto": "base.Base",
    "!doc": "Plugin for dd-drag for creating a proxy drag node, instead of dragging the original node.",
    "!url": "http://alloyui.com/classes/Plugin.DDProxy.html",
    "prototype": {
     "moveOnEnd": {
      "!type": "fn()",
      "!doc": "Move the original node at the end of the drag. Default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_moveOnEnd"
     },
     "hideOnEnd": {
      "!type": "fn()",
      "!doc": "Hide the drag node at the end of the drag. Default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_hideOnEnd"
     },
     "resizeFrame": {
      "!type": "fn()",
      "!doc": "Make the Proxy node assume the size of the original node. Default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_resizeFrame"
     },
     "positionProxy": {
      "!type": "fn()",
      "!doc": "Make the Proxy node appear in the same place as the original node. Default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_positionProxy"
     },
     "borderStyle": {
      "!type": "fn()",
      "!doc": "The default border style for the border of the proxy. Default: 1px solid #808080",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_borderStyle"
     },
     "cloneNode": {
      "!type": "fn()",
      "!doc": "Should the node be cloned into the proxy for you. Default: false",
      "!url": "http://alloyui.com/classes/Plugin.DDProxy.html#attribute_cloneNode"
     }
    }
   },
   "DD.Scroll": {
    "!type": "fn() -> +dd.DD.Scroll",
    "!proto": "base.Base",
    "!doc": "Base scroller class used to create the Plugin.DDNodeScroll and Plugin.DDWinScroll.\nThis class should not be called on it's own, it's designed to be a plugin.",
    "!url": "http://alloyui.com/classes/DD.Scroll.html",
    "prototype": {
     "buffer": {
      "!type": "fn()",
      "!doc": "The number of pixels from the edge of the screen to turn on scrolling. Default: 30",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_buffer"
     },
     "scrollDelay": {
      "!type": "fn()",
      "!doc": "The number of milliseconds delay to pass to the auto scroller. Default: 235",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_scrollDelay"
     },
     "host": {
      "!type": "fn()",
      "!doc": "The host we are plugged into.",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_host"
     },
     "windowScroll": {
      "!type": "fn()",
      "!doc": "Turn on window scroll support, default: false",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_windowScroll"
     },
     "vertical": {
      "!type": "fn()",
      "!doc": "Allow vertical scrolling, default: true.",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_vertical"
     },
     "horizontal": {
      "!type": "fn()",
      "!doc": "Allow horizontal scrolling, default: true.",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#attribute_horizontal"
     },
     "align": {
      "!type": "fn()",
      "!doc": "Called from the drag:align event to determine if we need to scroll.",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#method_align"
     },
     "start": {
      "!type": "fn()",
      "!doc": "Called from the drag:start event",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#method_start"
     },
     "end": {
      "!type": "fn()",
      "!doc": "Called from the drag:end event",
      "!url": "http://alloyui.com/classes/DD.Scroll.html#method_end"
     }
    }
   },
   "Plugin.DDWindowScroll": {
    "!type": "fn() -> +dd.Plugin.DDWindowScroll",
    "!proto": "Scroll",
    "!doc": "Extends the Scroll class to make the window scroll while dragging.",
    "!url": "http://alloyui.com/classes/Plugin.DDWindowScroll.html",
    "prototype": {
     "windowScroll": {
      "!type": "fn()",
      "!doc": "Turn on window scroll support, default: true",
      "!url": "http://alloyui.com/classes/Plugin.DDWindowScroll.html#attribute_windowScroll"
     }
    }
   },
   "Plugin.DDNodeScroll": {
    "!type": "fn() -> +dd.Plugin.DDNodeScroll",
    "!proto": "Scroll",
    "!doc": "Extends the Scroll class to make a parent node scroll while dragging.",
    "!url": "http://alloyui.com/classes/Plugin.DDNodeScroll.html",
    "prototype": {
     "node": {
      "!type": "fn()",
      "!doc": "The node we want to scroll. Used to set the internal parentScroll attribute.",
      "!url": "http://alloyui.com/classes/Plugin.DDNodeScroll.html#attribute_node"
     }
    }
   }
  },
  "dial": {
   "Dial": {
    "!type": "fn(config: yui.Object) -> +dial.Dial",
    "!proto": "widget.Widget",
    "!doc": "Create a dial to represent an input control capable of representing a\nseries of intermediate states based on the position of the Dial's handle.\nThese states are typically aligned to a value algorithm whereby the angle of the handle's\nposition corresponds to a given value.",
    "!url": "http://alloyui.com/classes/Dial.html",
    "prototype": {
     "min": {
      "!type": "fn()",
      "!doc": "minimum value allowed",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_min"
     },
     "max": {
      "!type": "fn()",
      "!doc": "maximum value allowed",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_max"
     },
     "diameter": {
      "!type": "fn()",
      "!doc": "diameter of the circular background object.\nOther objects scale accordingly.\nSet this only before rendering.",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_diameter"
     },
     "handleDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the handle object which users drag to change the value.\nDial sets the pixel dimension of the handle equal to handleDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_handleDiameter"
     },
     "markerDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the marker object which follows the angle of the handle during value changes.\nDial sets the pixel dimension of the marker equal to markerDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_markerDiameter"
     },
     "centerButtonDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the center button object.\nDial sets the pixel dimension of the centerButton equal to centerButtonDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_centerButtonDiameter"
     },
     "value": {
      "!type": "fn()",
      "!doc": "initial value of the Dial",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_value"
     },
     "minorStep": {
      "!type": "fn()",
      "!doc": "amount to increment/decrement the dial value\nwhen the arrow up/down/left/right keys are pressed",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_minorStep"
     },
     "majorStep": {
      "!type": "fn()",
      "!doc": "amount to increment/decrement the dial value\nwhen the page up/down keys are pressed",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_majorStep"
     },
     "stepsPerRevolution": {
      "!type": "fn()",
      "!doc": "number of value increments in one 360 degree revolution\nof the handle around the dial",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_stepsPerRevolution"
     },
     "decimalPlaces": {
      "!type": "fn()",
      "!doc": "number of decimal places of accuracy in the value",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_decimalPlaces"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "visible strings for the dial UI. This attribute is\ndefined by the base Widget class but has an empty value. The\nDial is simply providing a default value for the attribute.\nGets localized strings in the current language",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_strings"
     },
     "handleDistance": {
      "!type": "fn()",
      "!doc": "distance from the center of the dial to the\ncenter of the marker and handle, when at rest.\nThe value is a percent of the radius of the dial.",
      "!url": "http://alloyui.com/classes/Dial.html#attribute_handleDistance"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Synchronizes the DOM state with the attribute settings.",
      "!url": "http://alloyui.com/classes/Dial.html#method_syncUI"
     }
    }
   }
  },
  "dom": {
   "DOM": {
    "!type": "fn()",
    "!doc": "Provides DOM helper methods.",
    "!url": "http://alloyui.com/classes/DOM.html",
    "prototype": {
     "getText": {
      "!type": "fn(element: HTMLElement) -> string",
      "!doc": "Returns the text content of the HTMLElement.",
      "!url": "http://alloyui.com/classes/DOM.html#method_getText"
     },
     "setText": {
      "!type": "fn(element: HTMLElement, content: string)",
      "!doc": "Sets the text content of the HTMLElement.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setText"
     },
     "setAttribute": {
      "!type": "fn(el: HTMLElement, attr: string, val: string)",
      "!doc": "Provides a normalized attribute interface.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setAttribute"
     },
     "getAttribute": {
      "!type": "fn(el: HTMLElement, attr: string) -> string",
      "!doc": "Provides a normalized attribute interface.",
      "!url": "http://alloyui.com/classes/DOM.html#method_getAttribute"
     },
     "hasClass": {
      "!type": "fn(element: HTMLElement, className: string) -> bool",
      "!doc": "Determines whether a DOM element has the given className.",
      "!url": "http://alloyui.com/classes/DOM.html#method_hasClass"
     },
     "addClass": {
      "!type": "fn(element: HTMLElement, className: string)",
      "!doc": "Adds a class name to a given DOM element.",
      "!url": "http://alloyui.com/classes/DOM.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(element: HTMLElement, className: string)",
      "!doc": "Removes a class name from a given element.",
      "!url": "http://alloyui.com/classes/DOM.html#method_removeClass"
     },
     "replaceClass": {
      "!type": "fn(element: HTMLElement, oldClassName: string, newClassName: string)",
      "!doc": "Replace a class with another class for a given element.\nIf no oldClassName is present, the newClassName is simply added.",
      "!url": "http://alloyui.com/classes/DOM.html#method_replaceClass"
     },
     "toggleClass": {
      "!type": "fn(element: HTMLElement, className: string, addClass: bool)",
      "!doc": "If the className exists on the node it is removed, if it doesn't exist it is added.",
      "!url": "http://alloyui.com/classes/DOM.html#method_toggleClass"
     },
     "byId": {
      "!type": "fn(id: string, doc: yui.Object) -> +HTMLElement",
      "!doc": "Returns the HTMLElement with the given ID (Wrapper for document.getElementById).",
      "!url": "http://alloyui.com/classes/DOM.html#method_byId"
     },
     "elementByAxis": {
      "!type": "fn(element: HTMLElement, axis: string, fn?: fn(), all?: bool) -> +HTMLElement",
      "!doc": "Searches the element by the given axis for the first matching element.",
      "!url": "http://alloyui.com/classes/DOM.html#method_elementByAxis"
     },
     "contains": {
      "!type": "fn(element: HTMLElement, needle: HTMLElement) -> bool",
      "!doc": "Determines whether or not one HTMLElement is or contains another HTMLElement.",
      "!url": "http://alloyui.com/classes/DOM.html#method_contains"
     },
     "inDoc": {
      "!type": "fn(element: HTMLElement, doc: HTMLElement) -> bool",
      "!doc": "Determines whether or not the HTMLElement is part of the document.",
      "!url": "http://alloyui.com/classes/DOM.html#method_inDoc"
     },
     "create": {
      "!type": "fn(html: string, doc: HTMLDocument) -> +HTMLElement",
      "!doc": "Creates a new dom node using the provided markup string.",
      "!url": "http://alloyui.com/classes/DOM.html#method_create"
     },
     "addHTML": {
      "!type": "fn(node: HTMLElement, content: HTMLElement, where: HTMLElement)",
      "!doc": "Inserts content in a node at the given location",
      "!url": "http://alloyui.com/classes/DOM.html#method_addHTML"
     },
     "region": {
      "!type": "fn(element: HTMLElement) -> +yui.Object",
      "!doc": "Returns an Object literal containing the following about this element: (top, right, bottom, left)",
      "!url": "http://alloyui.com/classes/DOM.html#method_region"
     },
     "intersect": {
      "!type": "fn(element: HTMLElement, element2: HTMLElement, altRegion: yui.Object) -> +yui.Object",
      "!doc": "Find the intersect information for the passed nodes.",
      "!url": "http://alloyui.com/classes/DOM.html#method_intersect"
     },
     "inRegion": {
      "!type": "fn(node: yui.Object, node2: yui.Object, all: bool, altRegion: yui.Object) -> bool",
      "!doc": "Check if any part of this node is in the passed region",
      "!url": "http://alloyui.com/classes/DOM.html#method_inRegion"
     },
     "inViewportRegion": {
      "!type": "fn(element: HTMLElement, all: bool, altRegion: yui.Object) -> bool",
      "!doc": "Check if any part of this element is in the viewport",
      "!url": "http://alloyui.com/classes/DOM.html#method_inViewportRegion"
     },
     "viewportRegion": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns an Object literal containing the following about the visible region of viewport: (top, right, bottom, left)",
      "!url": "http://alloyui.com/classes/DOM.html#method_viewportRegion"
     },
     "winHeight": {
      "!type": "fn() -> number",
      "!doc": "Returns the inner height of the viewport (exludes scrollbar).",
      "!url": "http://alloyui.com/classes/DOM.html#method_winHeight"
     },
     "winWidth": {
      "!type": "fn() -> number",
      "!doc": "Returns the inner width of the viewport (exludes scrollbar).",
      "!url": "http://alloyui.com/classes/DOM.html#method_winWidth"
     },
     "docHeight": {
      "!type": "fn() -> number",
      "!doc": "Document height",
      "!url": "http://alloyui.com/classes/DOM.html#method_docHeight"
     },
     "docWidth": {
      "!type": "fn() -> number",
      "!doc": "Document width",
      "!url": "http://alloyui.com/classes/DOM.html#method_docWidth"
     },
     "docScrollX": {
      "!type": "fn() -> number",
      "!doc": "Amount page has been scroll horizontally",
      "!url": "http://alloyui.com/classes/DOM.html#method_docScrollX"
     },
     "docScrollY": {
      "!type": "fn() -> number",
      "!doc": "Amount page has been scroll vertically",
      "!url": "http://alloyui.com/classes/DOM.html#method_docScrollY"
     },
     "getXY": {
      "!type": "fn(element) -> +yui.Array",
      "!doc": "Gets the current position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_getXY"
     },
     "getScrollbarWidth": {
      "!type": "fn() -> number",
      "!doc": "Gets the width of vertical scrollbars on overflowed containers in the body\ncontent.",
      "!url": "http://alloyui.com/classes/DOM.html#method_getScrollbarWidth"
     },
     "getX": {
      "!type": "fn(element) -> number",
      "!doc": "Gets the current X position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_getX"
     },
     "getY": {
      "!type": "fn(element) -> number",
      "!doc": "Gets the current Y position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_getY"
     },
     "setXY": {
      "!type": "fn(element, xy: yui.Array, noRetry: bool)",
      "!doc": "Set the position of an html element in page coordinates.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_setXY"
     },
     "setX": {
      "!type": "fn(element, x: number)",
      "!doc": "Set the X position of an html element in page coordinates, regardless of how the element is positioned.\nThe element(s) must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_setX"
     },
     "setY": {
      "!type": "fn(element, y: number)",
      "!doc": "Set the Y position of an html element in page coordinates, regardless of how the element is positioned.\nThe element(s) must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://alloyui.com/classes/DOM.html#method_setY"
     },
     "swapXY": {
      "!type": "fn(node: node.Node, otherNode: node.Node) -> +node.Node",
      "!doc": "Swap the xy position with another node",
      "!url": "http://alloyui.com/classes/DOM.html#method_swapXY"
     },
     "setWidth": {
      "!type": "fn(element: HTMLElement, size: string)",
      "!doc": "Sets the width of the element to the given size, regardless\nof box model, border, padding, etc.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setWidth"
     },
     "setHeight": {
      "!type": "fn(element: HTMLElement, size: string)",
      "!doc": "Sets the height of the element to the given size, regardless\nof box model, border, padding, etc.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setHeight"
     },
     "setStyle": {
      "!type": "fn(An: HTMLElement, att: string, val: string)",
      "!doc": "Sets a style property for a given element.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setStyle"
     },
     "getStyle": {
      "!type": "fn(An: HTMLElement, att: string)",
      "!doc": "Returns the current style value for the given property.",
      "!url": "http://alloyui.com/classes/DOM.html#method_getStyle"
     },
     "setStyles": {
      "!type": "fn(node: HTMLElement, hash: yui.Object)",
      "!doc": "Sets multiple style properties.",
      "!url": "http://alloyui.com/classes/DOM.html#method_setStyles"
     },
     "getComputedStyle": {
      "!type": "fn(An: HTMLElement, att: string) -> string",
      "!doc": "Returns the computed style for the given node.",
      "!url": "http://alloyui.com/classes/DOM.html#method_getComputedStyle"
     }
    }
   },
   "Selector": {
    "!type": "fn()",
    "!doc": "Provides support for using CSS selectors to query the DOM",
    "!url": "http://alloyui.com/classes/Selector.html",
    "prototype": {
     "shorthand": {
      "!type": "+object",
      "!doc": "Mapping of shorthand tokens to corresponding attribute selector",
      "!url": "http://alloyui.com/classes/Selector.html#property_shorthand"
     },
     "operators": {
      "!type": "+object",
      "!doc": "List of operators and corresponding boolean functions.\nThese functions are passed the attribute and the current node's value of the attribute.",
      "!url": "http://alloyui.com/classes/Selector.html#property_operators"
     }
    },
    "useNative": {
     "!type": "?",
     "!doc": "Use the native version of `querySelectorAll`, if it exists.",
     "!url": "http://alloyui.com/classes/Selector.html#property_useNative"
    },
    "query": {
     "!type": "fn(selector: string, root: HTMLElement, firstOnly: bool) -> [+HTMLElement]",
     "!doc": "Retrieves a set of nodes based on a given CSS selector.",
     "!url": "http://alloyui.com/classes/Selector.html#method_query"
    },
    "filter": {
     "!type": "fn(nodes: [HTMLElement], selector: string) -> [+HTMLElement]",
     "!doc": "Filters out nodes that do not match the given CSS selector.",
     "!url": "http://alloyui.com/classes/Selector.html#method_filter"
    },
    "test": {
     "!type": "fn(node: HTMLElement, selector: string, root: HTMLElement) -> bool",
     "!doc": "Determines whether or not the given node matches the given CSS selector.",
     "!url": "http://alloyui.com/classes/Selector.html#method_test"
    },
    "ancestor": {
     "!type": "fn(node: HTMLElement, selector: string, testSelf: bool) -> +HTMLElement",
     "!doc": "A convenience method to emulate Y.Node's aNode.ancestor(selector).",
     "!url": "http://alloyui.com/classes/Selector.html#method_ancestor"
    }
   }
  },
  "dump": {
   "dump": {
    "!type": "fn(o: yui.Object, d: number) -> string",
    "!doc": "Returns a simple string representation of the object or array.\nOther types of objects will be returned unprocessed.  Arrays\nare expected to be indexed.",
    "!url": "http://alloyui.com/classes/YUI.html#method_dump"
   }
  },
  "editor": {
   "ContentEditable": {
    "!type": "fn() -> +editor.ContentEditable",
    "!proto": "Y.Plugin.Base",
    "!doc": "Creates a component to work with an elemment.",
    "!url": "http://alloyui.com/classes/ContentEditable.html",
    "prototype": {
     "use": {
      "!type": "fn()",
      "!doc": "Array of modules to include in the scoped YUI instance at render time. Default: ['node-base', 'editor-selection', 'stylesheet']",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_use"
     },
     "delegate": {
      "!type": "fn(type: string, fn: fn(), cont: String, Node, sel: string) -> +event_custom.EventHandle",
      "!doc": "A delegate method passed to the instance's delegate method",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_delegate"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get a reference to the internal YUI instance.",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: string) -> !this",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Set the focus to the container",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Show the iframe instance",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hide the iframe instance",
      "!url": "http://alloyui.com/classes/ContentEditable.html#method_hide"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The default text direction for this ContentEditable element. Default: ltr",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_dir"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container to set contentEditable=true or to create on render.",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_container"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The string to inject as Editor content. Default '<br>'",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_content"
     },
     "defaultblock": {
      "!type": "fn()",
      "!doc": "The default tag to use for block level items, defaults to: p",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_defaultblock"
     },
     "extracss": {
      "!type": "fn()",
      "!doc": "A string of CSS to add to the Head of the Editor",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_extracss"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Set the id of the new Node. (optional)",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_id"
     },
     "lang": {
      "!type": "fn()",
      "!doc": "The default language. Default: en-US",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_lang"
     },
     "linkedcss": {
      "!type": "fn()",
      "!doc": "An array of url's to external linked style sheets",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_linkedcss"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The Node instance of the container.",
      "!url": "http://alloyui.com/classes/ContentEditable.html#attribute_node"
     }
    },
    "THROTTLE_TIME": {
     "!type": "number",
     "!doc": "The throttle time for key events in IE",
     "!url": "http://alloyui.com/classes/ContentEditable.html#property_THROTTLE_TIME"
    },
    "DOM_EVENTS": {
     "!type": "+yui.Object",
     "!doc": "The DomEvents that the frame automatically attaches and bubbles",
     "!url": "http://alloyui.com/classes/ContentEditable.html#property_DOM_EVENTS"
    },
    "HTML": {
     "!type": "string",
     "!doc": "The template string used to create the ContentEditable element",
     "!url": "http://alloyui.com/classes/ContentEditable.html#property_HTML"
    },
    "NAME": {
     "!type": "string",
     "!doc": "The name of the class (contentEditable)",
     "!url": "http://alloyui.com/classes/ContentEditable.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace on which ContentEditable plugin will reside.",
     "!url": "http://alloyui.com/classes/ContentEditable.html#property_NS"
    }
   },
   "Plugin.CreateLinkBase": {
    "!type": "fn()",
    "!doc": "Adds prompt style link creation. Adds an override for the\n<a href=\"Plugin.ExecCommand.html#method_COMMANDS.createlink\">createlink execCommand</a>.",
    "!url": "http://alloyui.com/classes/Plugin.CreateLinkBase.html",
    "STRINGS": {
     "!type": "?",
     "!doc": "Strings used by the plugin",
     "!url": "http://alloyui.com/classes/Plugin.CreateLinkBase.html#property_STRINGS"
    },
    "PROMPT": {
     "!type": "?",
     "!doc": "String used for the Prompt",
     "!url": "http://alloyui.com/classes/Plugin.CreateLinkBase.html#property_PROMPT"
    },
    "DEFAULT": {
     "!type": "?",
     "!doc": "String used as the default value of the Prompt",
     "!url": "http://alloyui.com/classes/Plugin.CreateLinkBase.html#property_DEFAULT"
    }
   },
   "Plugin.ExecCommand.COMMANDS": {
    "!type": "fn()",
    "!doc": "Static object literal of execCommand overrides",
    "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html",
    "createlink": {
     "!type": "fn(cmd: string) -> +node.Node",
     "!doc": "Override for the createlink method from the <a href=\"Plugin.CreateLinkBase.html\">CreateLinkBase</a> plugin.",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_createlink"
    },
    "wrap": {
     "!type": "fn(cmd: string, tag: string) -> +node.NodeList",
     "!doc": "Wraps the content with a new element of type (tag)",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_wrap"
    },
    "inserthtml": {
     "!type": "fn(cmd: string, html: string) -> +node.Node",
     "!doc": "Inserts the provided HTML at the cursor, should be a single element.",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_inserthtml"
    },
    "insertandfocus": {
     "!type": "fn(cmd: string, html: string) -> +node.Node",
     "!doc": "Inserts the provided HTML at the cursor, and focuses the cursor afterwards.",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertandfocus"
    },
    "insertbr": {
     "!type": "fn(cmd: string)",
     "!doc": "Inserts a BR at the current cursor position",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertbr"
    },
    "insertimage": {
     "!type": "fn(cmd: string, img: string) -> +node.Node",
     "!doc": "Inserts an image at the cursor position",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertimage"
    },
    "addclass": {
     "!type": "fn(cmd: string, cls: string) -> +node.NodeList",
     "!doc": "Add a class to all of the elements in the selection",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_addclass"
    },
    "removeclass": {
     "!type": "fn(cmd: string, cls: string) -> +node.NodeList",
     "!doc": "Remove a class from all of the elements in the selection",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_removeclass"
    },
    "forecolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a forecolor to the current selection, or creates a new element and applies it",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_forecolor"
    },
    "backcolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a background color to the current selection, or creates a new element and applies it",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_backcolor"
    },
    "hilitecolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Sugar method, calles backcolor",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_hilitecolor"
    },
    "fontname2": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a font name to the current selection, or creates a new element and applies it",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_fontname2"
    },
    "fontsize2": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a fontsize to the current selection, or creates a new element and applies it",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_fontsize2"
    },
    "insertorderedlist": {
     "!type": "fn(cmd: string)",
     "!doc": "Overload for list",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertorderedlist"
    },
    "insertunorderedlist": {
     "!type": "fn(cmd: string)",
     "!doc": "Overload for list",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertunorderedlist"
    },
    "list": {
     "!type": "fn(cmd: string, tag: string)",
     "!doc": "Noramlizes lists creation/destruction for IE. All others pass through to native calls",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_list"
    },
    "justify": {
     "!type": "fn(cmd: string, val: string)",
     "!doc": "Noramlizes alignment for Webkit Browsers",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justify"
    },
    "justifycenter": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifycenter"
    },
    "justifyleft": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyleft"
    },
    "justifyright": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyright"
    },
    "justifyfull": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyfull"
    }
   },
   "EditorBase": {
    "!type": "fn() -> +editor.EditorBase",
    "!proto": "base.Base",
    "!doc": "Base class for Editor. Handles the business logic of Editor, no GUI involved only utility methods and events.\n\n     var editor = new Y.EditorBase({\n         content: 'Foo'\n     });\n     editor.render('#demo');",
    "!url": "http://alloyui.com/classes/EditorBase.html",
    "prototype": {
     "frame": {
      "!type": "?",
      "!doc": "Internal reference to the Y.ContentEditable instance",
      "!url": "http://alloyui.com/classes/EditorBase.html#property_frame"
     },
     "copyStyles": {
      "!type": "fn(from: node.Node, to: node.Node)",
      "!doc": "Copy certain styles from one node instance to another (used for new paragraph creation mainly)",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_copyStyles"
     },
     "getDomPath": {
      "!type": "fn(node: node.Node)",
      "!doc": "Walk the dom tree from this node up to body, returning a reversed array of parents.",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_getDomPath"
     },
     "execCommand": {
      "!type": "fn(cmd: string, val: string) -> +node.Node",
      "!doc": "Pass through to the frame.execCommand method",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_execCommand"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get the YUI instance of the frame",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: dom.Selector) -> !this",
      "!doc": "Renders the Y.ContentEditable to the passed node.",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Focus the contentWindow of the iframe",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Handles the showing of the Editor instance. Currently only handles the iframe",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Handles the hiding of the Editor instance. Currently only handles the iframe",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_hide"
     },
     "getContent": {
      "!type": "fn() -> string",
      "!doc": "(Un)Filters the content of the Editor, cleaning YUI related code. //TODO better filtering",
      "!url": "http://alloyui.com/classes/EditorBase.html#method_getContent"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The content to load into the Editor Frame",
      "!url": "http://alloyui.com/classes/EditorBase.html#attribute_content"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The value of the dir attribute on the HTML element of the frame. Default: ltr",
      "!url": "http://alloyui.com/classes/EditorBase.html#attribute_dir"
     },
     "linkedcss": {
      "!type": "fn()",
      "!doc": "An array of url's to external linked style sheets",
      "!url": "http://alloyui.com/classes/EditorBase.html#attribute_linkedcss"
     },
     "extracss": {
      "!type": "fn()",
      "!doc": "A string of CSS to add to the Head of the Editor",
      "!url": "http://alloyui.com/classes/EditorBase.html#attribute_extracss"
     },
     "defaultblock": {
      "!type": "fn()",
      "!doc": "The default tag to use for block level items, defaults to: p",
      "!url": "http://alloyui.com/classes/EditorBase.html#attribute_defaultblock"
     },
     "nodeChange": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fired from several mouse/key/paste event points.",
      "!url": "http://alloyui.com/classes/EditorBase.html#event_nodeChange"
     },
     "ready": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fired after the frame is ready.",
      "!url": "http://alloyui.com/classes/EditorBase.html#event_ready"
     }
    },
    "NORMALIZE_FONTSIZE": {
     "!type": "fn()",
     "!doc": "Pulls the fontSize from a node, then checks for string values (x-large, x-small)\nand converts them to pixel sizes. If the parsed size is different from the original, it calls\nnode.setStyle to update the node with a pixel size for normalization.",
     "!url": "http://alloyui.com/classes/EditorBase.html#method_NORMALIZE_FONTSIZE"
    },
    "TABKEY": {
     "!type": "?",
     "!doc": "The HTML markup to use for the tabkey",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_TABKEY"
    },
    "FILTER_RGB": {
     "!type": "fn(String) -> ?",
     "!doc": "Converts an RGB color string to a hex color, example: rgb(0, 255, 0) converts to #00ff00",
     "!url": "http://alloyui.com/classes/EditorBase.html#method_FILTER_RGB"
    },
    "TAG2CMD": {
     "!type": "?",
     "!doc": "A hash table of tags to their execcomand's",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_TAG2CMD"
    },
    "NC_KEYS": {
     "!type": "+yui.Object",
     "!doc": "Hash table of keys to fire a nodeChange event for.",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_NC_KEYS"
    },
    "USE": {
     "!type": "+yui.Array",
     "!doc": "The default modules to use inside the Frame",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_USE"
    },
    "NAME": {
     "!type": "?",
     "!doc": "The Class Name: editorBase",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_NAME"
    },
    "STRINGS": {
     "!type": "?",
     "!doc": "Editor Strings.  By default contains only the `title` property for the\nTitle of frame document (default \"Rich Text Editor\").",
     "!url": "http://alloyui.com/classes/EditorBase.html#property_STRINGS"
    }
   },
   "Plugin.EditorBidi": {
    "!type": "fn() -> +editor.Plugin.EditorBidi",
    "!proto": "base.Base",
    "!doc": "Plugin for Editor to support BiDirectional (bidi) text operations.",
    "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html",
    "EVENTS": {
     "!type": "?",
     "!doc": "The events to check for a direction change on",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_EVENTS"
    },
    "BLOCKS": {
     "!type": "?",
     "!doc": "More elements may be needed. BODY *must* be in the list to take care of the special case.\n\nblockParent could be changed to use inst.EditorSelection.BLOCKS\ninstead, but that would make Y.Plugin.EditorBidi.blockParent\nunusable in non-RTE contexts (it being usable is a nice\nside-effect).",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_BLOCKS"
    },
    "DIV_WRAPPER": {
     "!type": "?",
     "!doc": "Template for creating a block element",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_DIV_WRAPPER"
    },
    "blockParent": {
     "!type": "fn()",
     "!doc": "Returns a block parent for a given element",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#method_blockParent"
    },
    "_NODE_SELECTED": {
     "!type": "?",
     "!doc": "The data key to store on the node.",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property__NODE_SELECTED"
    },
    "addParents": {
     "!type": "fn()",
     "!doc": "Generates a list of all the block parents of the current NodeList",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#method_addParents"
    },
    "NAME": {
     "!type": "?",
     "!doc": "editorBidi",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorBidi",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_NS"
    },
    "RE_TEXT_ALIGN": {
     "!type": "?",
     "!doc": "Regex for testing/removing text-align style from an element",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#property_RE_TEXT_ALIGN"
    },
    "removeTextAlign": {
     "!type": "fn()",
     "!doc": "Method to test a node's style attribute for text-align and removing it.",
     "!url": "http://alloyui.com/classes/Plugin.EditorBidi.html#method_removeTextAlign"
    }
   },
   "Plugin.ExecCommand": {
    "!type": "fn() -> +editor.Plugin.ExecCommand",
    "!proto": "base.Base",
    "!doc": "Plugin for the frame module to handle execCommands for Editor",
    "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html",
    "prototype": {
     "bidi": {
      "!type": "?",
      "!doc": "bidi execCommand override for setting the text direction of a node.\nThis property is added to the `Y.Plugin.ExecCommands.COMMANDS`\ncollection.",
      "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html#property_bidi"
     },
     "command": {
      "!type": "fn(action: string, value: string) -> +node.Node",
      "!doc": "Execute a command on the frame's document.",
      "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html#method_command"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get's the instance of YUI bound to the parent frame",
      "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html#method_getInstance"
     }
    },
    "NAME": {
     "!type": "?",
     "!doc": "execCommand",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "exec",
     "!url": "http://alloyui.com/classes/Plugin.ExecCommand.html#property_NS"
    }
   },
   "Plugin.EditorBR": {
    "!type": "fn() -> +editor.Plugin.EditorBR",
    "!proto": "base.Base",
    "!doc": "Plugin for Editor to normalize BR's.",
    "!url": "http://alloyui.com/classes/Plugin.EditorBR.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorBR",
     "!url": "http://alloyui.com/classes/Plugin.EditorBR.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorBR",
     "!url": "http://alloyui.com/classes/Plugin.EditorBR.html#property_NS"
    }
   },
   "Plugin.EditorParaBase": {
    "!type": "fn() -> +editor.Plugin.EditorParaBase",
    "!proto": "base.Base",
    "!doc": "Base Plugin for Editor to paragraph auto wrapping and correction.",
    "!url": "http://alloyui.com/classes/Plugin.EditorParaBase.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorParaBase.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorParaBase.html#property_NS"
    }
   },
   "Plugin.EditorParaIE": {
    "!type": "fn() -> +editor.Plugin.EditorParaIE",
    "!proto": "editor.Plugin.EditorParaBase",
    "!doc": "Extends EditorParaBase with IE support",
    "!url": "http://alloyui.com/classes/Plugin.EditorParaIE.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorParaIE.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorParaIE.html#property_NS"
    }
   },
   "Plugin.EditorPara": {
    "!type": "fn() -> +editor.Plugin.EditorPara",
    "!proto": "editor.Plugin.EditorParaBase",
    "!doc": "Plugin for Editor to paragraph auto wrapping and correction.",
    "!url": "http://alloyui.com/classes/Plugin.EditorPara.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorPara.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://alloyui.com/classes/Plugin.EditorPara.html#property_NS"
    }
   },
   "EditorSelection": {
    "!type": "fn() -> +editor.EditorSelection",
    "!doc": "Wraps some common Selection/Range functionality into a simple object",
    "!url": "http://alloyui.com/classes/EditorSelection.html",
    "removeFontFamily": {
     "!type": "fn()",
     "!doc": "Utility method to remove dead font-family styles from an element.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_removeFontFamily"
    },
    "filter": {
     "!type": "fn()",
     "!doc": "Performs a prefilter on all nodes in the editor. Looks for nodes with a style: fontFamily or font face\nIt then creates a dynamic class assigns it and removed the property. This is so that we don't lose\nthe fontFamily when selecting nodes.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_filter"
    },
    "filterBlocks": {
     "!type": "fn()",
     "!doc": "Method attempts to replace all \"orphined\" text nodes in the main body by wrapping them with a <p>. Called from filter.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_filterBlocks"
    },
    "REG_FONTFAMILY": {
     "!type": "?",
     "!doc": "Regular Expression used to find dead font-family styles",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_REG_FONTFAMILY"
    },
    "REG_CHAR": {
     "!type": "?",
     "!doc": "Regular Expression to determine if a string has a character in it",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_REG_CHAR"
    },
    "REG_NON": {
     "!type": "?",
     "!doc": "Regular Expression to determine if a string has a non-character in it",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_REG_NON"
    },
    "REG_NOHTML": {
     "!type": "?",
     "!doc": "Regular Expression to remove all HTML from a string",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_REG_NOHTML"
    },
    "unfilter": {
     "!type": "fn() -> string",
     "!doc": "Undoes what filter does enough to return the HTML from the Editor, then re-applies the filter.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_unfilter"
    },
    "resolve": {
     "!type": "fn(n: HTMLElement) -> +node.Node",
     "!doc": "Resolve a node from the selection object and return a Node instance",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_resolve"
    },
    "getText": {
     "!type": "fn(node: node.Node) -> string",
     "!doc": "Returns the innerHTML of a node with all HTML tags removed.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_getText"
    },
    "ALL": {
     "!type": "?",
     "!doc": "The selector to use when looking for Nodes to cache the value of: [style],font[face]",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_ALL"
    },
    "BLOCKS": {
     "!type": "?",
     "!doc": "The selector to use when looking for block level items.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_BLOCKS"
    },
    "TMP": {
     "!type": "?",
     "!doc": "The temporary fontname applied to a selection to retrieve their values: yui-tmp",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_TMP"
    },
    "DEFAULT_TAG": {
     "!type": "?",
     "!doc": "The default tag to use when creating elements: span",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_DEFAULT_TAG"
    },
    "CURID": {
     "!type": "?",
     "!doc": "The id of the outer cursor wrapper",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_CURID"
    },
    "CUR_WRAPID": {
     "!type": "?",
     "!doc": "The id used to wrap the inner space of the cursor position",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_CUR_WRAPID"
    },
    "CURSOR": {
     "!type": "?",
     "!doc": "The default HTML used to focus the cursor..",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_CURSOR"
    },
    "ROOT": {
     "!type": "?",
     "!doc": "The default HTML element from which data will be retrieved. Default: body",
     "!url": "http://alloyui.com/classes/EditorSelection.html#property_ROOT"
    },
    "cleanCursor": {
     "!type": "fn()",
     "!doc": "Called from Editor keydown to remove the \"extra\" space before the cursor.",
     "!url": "http://alloyui.com/classes/EditorSelection.html#method_cleanCursor"
    },
    "prototype": {
     "text": {
      "!type": "string",
      "!doc": "Range text value",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_text"
     },
     "isCollapsed": {
      "!type": "bool",
      "!doc": "Flag to show if the range is collapsed or not",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_isCollapsed"
     },
     "anchorNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the parentNode of the anchorNode of the range",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_anchorNode"
     },
     "anchorOffset": {
      "!type": "number",
      "!doc": "The offset from the range object",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_anchorOffset"
     },
     "anchorTextNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the actual textNode of the range.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_anchorTextNode"
     },
     "focusNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the parentNode of the focusNode of the range",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_focusNode"
     },
     "focusOffset": {
      "!type": "number",
      "!doc": "The offset from the range object",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_focusOffset"
     },
     "focusTextNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the actual textNode of the range.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#property_focusTextNode"
     },
     "getSelected": {
      "!type": "fn() -> +node.NodeList",
      "!doc": "Get all the nodes in the current selection. This method will actually perform a filter first.\nThen it calls doc.execCommand('fontname', null, 'yui-tmp') to touch all nodes in the selection.\nThe it compiles a list of all nodes affected by the execCommand and builds a NodeList to return.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_getSelected"
     },
     "insertContent": {
      "!type": "fn(html: string) -> +node.Node",
      "!doc": "Insert HTML at the current cursor position and return a Node instance of the newly inserted element.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_insertContent"
     },
     "insertAtCursor": {
      "!type": "fn(html: string, node: node.Node, offset: number, collapse: bool) -> +node.Node",
      "!doc": "Insert HTML at the current cursor position, this method gives you control over the text node to insert into and the offset where to put it.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_insertAtCursor"
     },
     "wrapContent": {
      "!type": "fn(tag: string) -> +node.NodeList",
      "!doc": "Get all elements inside a selection and wrap them with a new element and return a NodeList of all elements touched.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_wrapContent"
     },
     "replace": {
      "!type": "fn(se: string, re: string) -> +node.Node",
      "!doc": "Find and replace a string inside a text node and replace it with HTML focusing the node after\nto allow you to continue to type.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_replace"
     },
     "remove": {
      "!type": "fn() -> !this",
      "!doc": "Destroy the range.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_remove"
     },
     "createRange": {
      "!type": "fn() -> +Range",
      "!doc": "Wrapper for the different range creation methods.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_createRange"
     },
     "selectNode": {
      "!type": "fn(node: node.Node, collapse: bool) -> !this",
      "!doc": "Select a Node (hilighting it).",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_selectNode"
     },
     "setCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Put a placeholder in the DOM at the current cursor position.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_setCursor"
     },
     "getCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Get the placeholder in the DOM at the current cursor position.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_getCursor"
     },
     "removeCursor": {
      "!type": "fn(keep: bool) -> +node.Node",
      "!doc": "Remove the cursor placeholder from the DOM.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_removeCursor"
     },
     "focusCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets a stored cursor and focuses it for editing, must be called sometime after setCursor",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_focusCursor"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Generic toString for logging.",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_toString"
     },
     "getEditorOffset": {
      "!type": "fn(node?: Y.Node) -> ?",
      "!doc": "Gets the offset of the selection for the selection within the current\neditor",
      "!url": "http://alloyui.com/classes/EditorSelection.html#method_getEditorOffset"
     }
    }
   },
   "Plugin.EditorTab": {
    "!type": "fn() -> +editor.Plugin.EditorTab",
    "!proto": "base.Base",
    "!doc": "Handles tab and shift-tab indent/outdent support.",
    "!url": "http://alloyui.com/classes/Plugin.EditorTab.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorTab",
     "!url": "http://alloyui.com/classes/Plugin.EditorTab.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "tab",
     "!url": "http://alloyui.com/classes/Plugin.EditorTab.html#property_NS"
    }
   },
   "Frame": {
    "!type": "fn() -> +editor.Frame",
    "!proto": "base.Base",
    "!doc": "Creates a wrapper around an iframe. It loads the content either from a local\nfile or from script and creates a local YUI instance bound to that new window and document.",
    "!url": "http://alloyui.com/classes/Frame.html",
    "prototype": {
     "use": {
      "!type": "fn()",
      "!doc": "Array of modules to include in the scoped YUI instance at render time. Default: ['none', 'selector-css2']",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_use"
     },
     "delegate": {
      "!type": "fn(type: string, fn: fn(), cont: string, sel: string) -> +event_custom.EventHandle",
      "!doc": "A delegate method passed to the instance's delegate method",
      "!url": "http://alloyui.com/classes/Frame.html#method_delegate"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get a reference to the internal YUI instance.",
      "!url": "http://alloyui.com/classes/Frame.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: string) -> !this",
      "!doc": "Render the iframe into the container config option or open the window.",
      "!url": "http://alloyui.com/classes/Frame.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Set the focus to the iframe",
      "!url": "http://alloyui.com/classes/Frame.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Show the iframe instance",
      "!url": "http://alloyui.com/classes/Frame.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hide the iframe instance",
      "!url": "http://alloyui.com/classes/Frame.html#method_hide"
     },
     "title": {
      "!type": "fn()",
      "!doc": "The title to give the blank page.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_title"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The default text direction for this new frame. Default: ltr",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_dir"
     },
     "lang": {
      "!type": "fn()",
      "!doc": "The default language. Default: en-US",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_lang"
     },
     "src": {
      "!type": "fn()",
      "!doc": "The src of the iframe/window. Defaults to javascript:;",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_src"
     },
     "designMode": {
      "!type": "fn()",
      "!doc": "Should designMode be turned on after creation.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_designMode"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The string to inject into the body of the new frame/window.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_content"
     },
     "basehref": {
      "!type": "fn()",
      "!doc": "The base href to use in the iframe.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_basehref"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container to append the iFrame to on render.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_container"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The Node instance of the iframe.",
      "!url": "http://alloyui.com/classes/Frame.html#attribute_node"
     },
     "id": {
      "!typ