/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fabric8.ui.runtime.fabric8;

import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.fusesource.ide.server.fabric8.ui.Messages;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;
import org.fusesource.ide.server.karaf.ui.runtime.v2x.KarafRuntimeComposite2x;

public class Fabric8RuntimeComposite1x
extends KarafRuntimeComposite2x {
    private static final String LIB_FABRIC8_VERSION_JAR = String.format("%s%s%s", "lib", SEPARATOR, "fabric-version.jar");

    public Fabric8RuntimeComposite1x(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, wizardHandle, model);
        wizardHandle.setTitle(Messages.Fabric8RuntimeComposite_wizard_tite);
        wizardHandle.setDescription(Messages.Fabric8RuntimeComposite_wizard_desc);
    }

    protected boolean doClassPathEntiresExist(String karafInstallDir) {
        File libServiceMixVersionJar = new File(String.format("%s%s%s", karafInstallDir, SEPARATOR, LIB_FABRIC8_VERSION_JAR));
        return super.doClassPathEntiresExist(karafInstallDir) && libServiceMixVersionJar.exists();
    }

    public boolean validate() {
        this.valid = super.validate();
        if (this.valid) {
            String dirLocation = this.txtKarafDir.getText().trim();
            if (dirLocation != null && !"".equals(dirLocation)) {
                File file = new File(dirLocation);
                if (!file.exists()) {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
                } else if (!file.isDirectory()) {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
                } else {
                    File binFuse = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.Fabric8RuntimeComposite_bin_fabric8);
                    File binFuseBat = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.Fabric8RuntimeComposite_bin_fabric8_bat);
                    if (binFuse.exists() || binFuseBat.exists()) {
                        this.valid = true;
                        this.wizardHandle.setMessage("", 0);
                    } else {
                        this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_invalid_dir, 3);
                    }
                }
            } else {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
            }
        }
        return this.valid;
    }

    public void handleEvent(Event event) {
        boolean valid = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtKarafDir && (valid = this.validate())) {
            String installDir = this.txtKarafDir.getText();
            this.model.setKarafInstallDir(installDir);
        }
        this.wizardHandle.update();
    }
}

