/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fabric8.ui;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.server.fabric8.ui.Fabric8UIPlugin;
import org.osgi.framework.Bundle;

public class Fabric8SharedImages {
    public static final String IMG_FABRIC8_LOGO_LARGE = "fabric8.png";
    private static Fabric8SharedImages instance;
    private Hashtable<String, Object> images;
    private Hashtable<String, Object> descriptors;

    private Fabric8SharedImages() {
        instance = this;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
        if (Fabric8UIPlugin.getDefault() == null || Fabric8UIPlugin.getDefault().getBundle() == null) {
            return;
        }
        Bundle pluginBundle = Fabric8UIPlugin.getDefault().getBundle();
        this.descriptors.put(IMG_FABRIC8_LOGO_LARGE, this.createImageDescriptor(pluginBundle, "/icons/fabric8.png"));
        for (String key : this.descriptors.keySet()) {
            ImageDescriptor descriptor = this.descriptor(key);
            this.images.put(key, descriptor.createImage());
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    public static Fabric8SharedImages instance() {
        if (instance == null) {
            instance = new Fabric8SharedImages();
        }
        return instance;
    }

    public static Image getImage(String key) {
        return Fabric8SharedImages.instance().image(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return Fabric8SharedImages.instance().descriptor(key);
    }

    public Image image(String key) {
        return (Image)this.images.get(key);
    }

    public ImageDescriptor descriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }

    public void cleanup() {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = (Image)this.images.get(iter.next());
            image.dispose();
        }
        this.images = null;
        this.descriptors = null;
        instance = null;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

