/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXPage;
import org.eclipse.birt.report.engine.emitter.pptx.util.PPTXUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;

public class PPTXPageDevice
implements IPageDevice {
    private static Logger logger = Logger.getLogger(PPTXPageDevice.class.getName());
    private Presentation presentation;

    public PPTXPageDevice(OutputStream output, String title, String author, String description, String subject, String tempFileDir, int compressionMode) {
        this.presentation = new Presentation(output, tempFileDir, compressionMode);
        this.presentation.setAuthor(author);
        this.presentation.setTitle(title);
        this.presentation.setDescription(description);
        this.presentation.setSubject(subject);
    }

    public void close() throws Exception {
        this.presentation.close();
    }

    public IPage newPage(int width, int height, Color backgroundColor) {
        PPTXPage page = null;
        try {
            width = PPTXUtil.convertToPointer(width);
            height = PPTXUtil.convertToPointer(height);
            page = new PPTXPage(this.presentation.createSlide(width, height, backgroundColor));
            page.drawBackgroundColor(backgroundColor, 0, 0, width, height);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return page;
    }
}

