/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.project.providers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.fusesource.ide.project.Activator;

public class CamelVirtualFolder {
    private IProject project;
    private ArrayList<IResource> camelFiles = new ArrayList();

    public CamelVirtualFolder(IProject prj) {
        this.project = prj;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new CamelVirtualFolderListener(this.project), 33);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return "Camel Contexts";
    }

    public void addCamelFile(IResource file) {
        if (!this.camelFiles.contains(file)) {
            this.camelFiles.add(file);
        }
    }

    public ArrayList<IResource> getCamelFiles() {
        return this.camelFiles;
    }

    public void populateChildren() {
        IPath p = this.project.getLocation();
        try {
            this.findFiles(p.toFile());
        }
        catch (CoreException coreException) {}
    }

    private void findFiles(File folder) throws CoreException {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    if (!f.getName().equalsIgnoreCase("target") || !f.getParentFile().getName().equalsIgnoreCase(this.project.getName())) {
                        this.findFiles(f);
                    }
                } else {
                    IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)f.getPath()));
                    if (ifile != null && ifile.getContentDescription() != null && ifile.getContentDescription().getContentType().getId().equals("org.fusesource.ide.camel.editor.camelContentType")) {
                        this.addCamelFile((IResource)ifile);
                    }
                }
                ++n2;
            }
        }
    }

    class CamelVirtualFolderListener
    implements IResourceChangeListener {
        private IProject _project;

        public CamelVirtualFolderListener(IProject project) {
            this._project = project;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 32) {
                CamelVirtualFolder.this.camelFiles.clear();
                CamelVirtualFolder.this.populateChildren();
            } else if (event.getType() == 1) {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter(this._project));
                }
                catch (CoreException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
        }
    }

    class DeltaPrinter
    implements IResourceDeltaVisitor {
        private IProject _project;

        public DeltaPrinter(IProject project) {
            this._project = project;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getProject() != null && !resource.getProject().equals((Object)CamelVirtualFolder.this.project)) {
                return true;
            }
            switch (delta.getKind()) {
                case 1: {
                    if (resource.getFullPath().toOSString().contains(String.valueOf(File.separator) + "target" + File.separator + "classes" + File.separator)) break;
                    try {
                        if (resource == null || !(resource instanceof IFile) || ((IFile)resource).getContentDescription() == null || !((IFile)resource).getContentDescription().getContentType().getId().equals("org.fusesource.ide.camel.editor.camelContentType")) break;
                        CamelVirtualFolder.this.addCamelFile(resource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 2: {
                    if (!CamelVirtualFolder.this.camelFiles.contains(resource)) break;
                    CamelVirtualFolder.this.camelFiles.remove(resource);
                }
            }
            return true;
        }
    }
}

