/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.switchyard.tools.ui.debug.IValidateConfiguration;

public final class ValidateConfigurationBuilder {
    public static final String TYPES_KEY = "switchYardValidatorBreakpointMarker.types";
    private ValidateConfigurationImpl _config = new ValidateConfigurationImpl();

    private ValidateConfigurationBuilder() {
    }

    public ValidateConfigurationBuilder types(Set<String> types) {
        this._config._validateTypes = types == null ? null : new LinkedHashSet<String>(types);
        return this;
    }

    public ValidateConfigurationBuilder updateFrom(Map<String, Object> attributes) {
        StringTokenizer tokens;
        Object value = attributes.get(TYPES_KEY);
        StringTokenizer stringTokenizer = tokens = value instanceof String ? new StringTokenizer((String)value) : null;
        if (tokens == null || !tokens.hasMoreTokens()) {
            this._config._validateTypes = null;
        } else {
            this._config._validateTypes = new LinkedHashSet();
            while (tokens.hasMoreTokens()) {
                this._config._validateTypes.add(tokens.nextToken());
            }
        }
        return this;
    }

    public IValidateConfiguration build() {
        return this._config;
    }

    public static ValidateConfigurationBuilder create() {
        return new ValidateConfigurationBuilder();
    }

    public static ValidateConfigurationBuilder createFrom(IValidateConfiguration config) {
        return ValidateConfigurationBuilder.create().types(config.getValidateTypes());
    }

    private static final class ValidateConfigurationImpl
    implements IValidateConfiguration {
        private Set<String> _validateTypes;

        private ValidateConfigurationImpl() {
        }

        @Override
        public Set<String> getValidateTypes() {
            return this._validateTypes == null ? null : Collections.unmodifiableSet(this._validateTypes);
        }

        @Override
        public Map<String, Object> toAttributesMap() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (this._validateTypes != null && this._validateTypes.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                for (String value : this._validateTypes) {
                    buffer.append(value.toString()).append(' ');
                }
                if (buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                attributes.put(ValidateConfigurationBuilder.TYPES_KEY, buffer.toString());
            }
            return attributes;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValidateConfigurationImpl) {
                ValidateConfigurationImpl other = (ValidateConfigurationImpl)obj;
                return (this._validateTypes == null || this._validateTypes.isEmpty()) && (other._validateTypes == null || other._validateTypes.isEmpty()) || this._validateTypes != null && this._validateTypes.equals(other._validateTypes);
            }
            return false;
        }
    }
}

