/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.IValidateConfiguration;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;
import org.switchyard.tools.ui.debug.ValidateConfigurationBuilder;
import org.switchyard.tools.ui.debug.ValidateHandlerBreakpoint;

public class ValidateBreakpointEditor
extends AbstractJavaBreakpointEditor {
    public static final int TRIGGER_PROP = 1;
    public static final int TYPES_PROP = 2;
    private ValidateHandlerBreakpoint _breakpoint;
    private Button _inButton;
    private Button _outButton;
    private Button _faultButton;
    private CheckboxTableViewer _typesTable;
    private Set<IInteractionConfiguration.TriggerType> _triggers;
    private boolean _updating;

    public Control createControl(Composite parent) {
        ScrolledComposite scrollable = new ScrolledComposite(parent, 768);
        scrollable.setLayout((Layout)new GridLayout());
        scrollable.setLayoutData((Object)new GridData(1808));
        Composite content = new Composite((Composite)scrollable, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        content.setBackground(parent.getBackground());
        content.setBackgroundMode(1);
        Group phaseGroup = new Group(content, 0);
        phaseGroup.setLayout((Layout)new GridLayout(3, false));
        phaseGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        phaseGroup.setText("Triggering phase");
        this._inButton = new Button((Composite)phaseGroup, 32);
        this._inButton.setText("IN");
        this._inButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.IN));
        this._outButton = new Button((Composite)phaseGroup, 32);
        this._outButton.setText("OUT");
        this._outButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.OUT));
        this._faultButton = new Button((Composite)phaseGroup, 32);
        this._faultButton.setText("FAULT");
        this._faultButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.FAULT));
        this._typesTable = CheckboxTableViewer.newCheckList((Composite)content, (int)2816);
        GridData gd = new GridData(1808);
        gd.minimumHeight = this._typesTable.getTable().getHeaderHeight() + 5 * this._typesTable.getTable().getItemHeight();
        this._typesTable.getControl().setLayoutData((Object)gd);
        TableViewerColumn typeColumn = new TableViewerColumn((TableViewer)this._typesTable, 16384);
        typeColumn.getColumn().setResizable(true);
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(500);
        this._typesTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ValidateType) {
                    QName type = QName.valueOf(((ValidateType)element).getName());
                    String localPart = type.getLocalPart();
                    String namespaceUri = type.getNamespaceURI();
                    if (namespaceUri == null || "".equals(namespaceUri)) {
                        if (localPart.startsWith("java:")) {
                            int lastDot = localPart.lastIndexOf(46);
                            if (lastDot > 0) {
                                return String.valueOf(localPart.substring(lastDot + 1)) + " {" + localPart.substring(5, lastDot) + "}";
                            }
                            return localPart.substring(5);
                        }
                        return localPart;
                    }
                    return String.valueOf(localPart) + " {" + namespaceUri + "}";
                }
                return super.getText(element);
            }
        });
        this._typesTable.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof ValidateType && ((ValidateType)element).getName() != null && ((ValidateType)element).getName().length() > 0;
            }
        });
        this._typesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._typesTable.getTable().setHeaderVisible(true);
        this._typesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (ValidateBreakpointEditor.this._updating) {
                    return;
                }
                ValidateBreakpointEditor.this.setDirty(2);
            }
        });
        scrollable.setContent((Control)content);
        content.setSize(content.computeSize(-1, -1));
        return scrollable;
    }

    public void setFocus() {
    }

    public IStatus getStatus() {
        if (this._inButton.getSelection() || this._outButton.getSelection() || this._faultButton.getSelection()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.switchyard.tools.ui.debug", "Must select at least one trigger (IN, OUT or FAULT).");
    }

    public Object getInput() {
        return this._breakpoint;
    }

    public void setInput(Object breakpoint) throws CoreException {
        this._updating = true;
        try {
            if (breakpoint instanceof ValidateHandlerBreakpoint) {
                this._breakpoint = (ValidateHandlerBreakpoint)breakpoint;
            } else {
                breakpoint = null;
            }
            this.initialize();
        }
        finally {
            this._updating = false;
        }
    }

    public void doSave() throws CoreException {
        if (this._breakpoint != null) {
            InteractionConfigurationBuilder builder = InteractionConfigurationBuilder.createFrom(this._breakpoint.getInteractionConfiguration());
            builder.triggers(this._triggers.isEmpty() ? null : EnumSet.copyOf(this._triggers));
            this._breakpoint.setInteractionConfiguration(builder.build());
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            Object[] objectArray = this._typesTable.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                String type = ((ValidateType)obj).getName();
                if (type != null && type.length() > 0) {
                    types.add(type);
                }
                ++n2;
            }
            ValidateConfigurationBuilder validateBuilder = ValidateConfigurationBuilder.createFrom(this._breakpoint.getValidateConfiguration());
            validateBuilder.types(types);
            this._breakpoint.setValidateConfiguration(validateBuilder.build());
        }
        this.setDirty(false);
    }

    private void initialize() {
        if (this._breakpoint == null) {
            this._inButton.setEnabled(false);
            this._inButton.setSelection(false);
            this._outButton.setEnabled(false);
            this._outButton.setSelection(false);
            this._faultButton.setEnabled(false);
            this._faultButton.setSelection(false);
        } else {
            IInteractionConfiguration config = this._breakpoint.getInteractionConfiguration();
            IValidateConfiguration validateConfig = this._breakpoint.getValidateConfiguration();
            this._triggers = config == null ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : config.getTriggers();
            this._triggers = this._triggers == null || this._triggers.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : EnumSet.copyOf(this._triggers);
            this._inButton.setEnabled(true);
            this._inButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.IN));
            this._outButton.setEnabled(true);
            this._outButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT));
            this._faultButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT));
            this._typesTable.setInput(this.getValidators());
            if (validateConfig.getValidateTypes() == null) {
                this._typesTable.setCheckedElements(new Object[0]);
            } else {
                this._typesTable.setCheckedElements(validateConfig.getValidateTypes().toArray());
            }
            this.updateEnablement();
        }
        this.setDirty(false);
    }

    private void updateEnablement() {
        this._faultButton.setEnabled(!this._outButton.getSelection());
        this._typesTable.getControl().setEnabled(this._triggers != null && this._triggers.size() > 0);
    }

    private Collection<ValidateType> getValidators() {
        IResource markerResource = this._breakpoint.getMarker().getResource();
        if (markerResource == null || markerResource.getProject() == null) {
            return Collections.emptyList();
        }
        ISwitchYardProject switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(markerResource.getProject());
        if (switchYardProject == null) {
            return Collections.emptyList();
        }
        IFile switchYardFile = switchYardProject.getOutputSwitchYardConfigurationFile();
        if (switchYardFile == null || !switchYardFile.isAccessible()) {
            switchYardFile = switchYardProject.getSwitchYardConfigurationFile();
        }
        if (switchYardFile == null || !switchYardFile.isAccessible()) {
            return Collections.emptyList();
        }
        ResourceSet rs = SwitchYardModelUtils.newResourceSet();
        Resource resource = rs.createResource(URI.createPlatformResourceURI((String)switchYardFile.getFullPath().toPortableString(), (boolean)true), "org.switchyard.content-type.1.x");
        try {
            resource.load(null);
            if (resource.getContents().size() > 0) {
                Object content = resource.getContents().get(0);
                if (content instanceof SwitchYardType) {
                    Collection<ValidateType> collection = this.getValidates((SwitchYardType)content);
                    return collection;
                }
                if (content instanceof DocumentRoot) {
                    Collection<ValidateType> collection = this.getValidates(((DocumentRoot)content).getSwitchyard());
                    return collection;
                }
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        finally {
            resource.unload();
        }
        return Collections.emptyList();
    }

    private Collection<ValidateType> getValidates(SwitchYardType switchyard) {
        if (switchyard == null || switchyard.getValidates() == null) {
            return Collections.emptyList();
        }
        return switchyard.getValidates().getValidate();
    }

    private final class TriggerSelectionListener
    extends SelectionAdapter {
        private final IInteractionConfiguration.TriggerType _trigger;

        private TriggerSelectionListener(IInteractionConfiguration.TriggerType trigger) {
            this._trigger = trigger;
        }

        public void widgetSelected(SelectionEvent event) {
            if (ValidateBreakpointEditor.this._updating) {
                return;
            }
            if (((Button)event.widget).getSelection()) {
                ValidateBreakpointEditor.this._triggers.add(this._trigger);
            } else {
                ValidateBreakpointEditor.this._triggers.remove((Object)this._trigger);
            }
            ValidateBreakpointEditor.this.updateEnablement();
            ValidateBreakpointEditor.this.setDirty(1);
        }
    }
}

