/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.debug.CamelProcessorBreakpoint;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ITransformConfiguration;
import org.switchyard.tools.ui.debug.TransformConfigurationBuilder;

public class TransformSequenceBreakpoint
extends DelegatingJavaBreakpoint<String> {
    private static final String MARKER_ID = "org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker";
    private static final String DELEGATE_KEY = CamelProcessorBreakpoint.class.getCanonicalName();
    private static final String TYPE = "org.switchyard.transform.TransformSequence";
    private static final String METHOD = "apply";
    private static final String SIGNATURE = "(Lorg/switchyard/Message;Lorg/switchyard/transform/TransformerRegistry;)V";
    private static final String VARIABLE_NAME = "message.getContext()";
    private ITransformConfiguration _transformConfiguration;

    public TransformSequenceBreakpoint() {
    }

    public TransformSequenceBreakpoint(IResource resource, IInteractionConfiguration configuration, ITransformConfiguration transformConfiguration, boolean register) throws CoreException {
        super(resource, configuration, register, MARKER_ID);
        this._transformConfiguration = transformConfiguration;
    }

    public ITransformConfiguration getTransformConfiguration() {
        if (this._transformConfiguration == null) {
            try {
                this._transformConfiguration = TransformConfigurationBuilder.create().updateFrom(this.getMarker().getAttributes()).build();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this._transformConfiguration;
    }

    public void setTransformConfiguration(ITransformConfiguration configuration) throws CoreException {
        if (configuration.equals(this._transformConfiguration)) {
            return;
        }
        Map attributes = this.getMarker().getAttributes();
        attributes.putAll(configuration.toAttributesMap());
        this.setAttributes(attributes);
        this._transformConfiguration = configuration;
        if (this.getDelegates().size() > 0) {
            this.configurationUpdated();
        }
    }

    @Override
    protected void createDelegates() throws CoreException {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(this.getMarker().getAttributes());
        attributes.put("org.eclipse.debug.core.persisted", false);
        attributes.put("transient", true);
        IJavaMethodBreakpoint delegate = JDIDebugModel.createMethodBreakpoint((IResource)this.getMarker().getResource(), (String)TYPE, (String)METHOD, (String)SIGNATURE, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)false, attributes);
        String condition = this.createCondition();
        if (condition != null) {
            delegate.setCondition(condition);
            delegate.setConditionEnabled(true);
        }
        delegate.setEnabled(this.isEnabled());
        this.addDelegate(DELEGATE_KEY, (JavaBreakpoint)delegate);
    }

    protected IJavaMethodBreakpoint getDelegate() {
        return (IJavaMethodBreakpoint)this.getDelegate(DELEGATE_KEY);
    }

    @Override
    protected void configurationUpdated() throws CoreException {
        IJavaMethodBreakpoint delegate = this.getDelegate();
        String newCondition = this.createCondition();
        String oldCondition = delegate.getCondition();
        if (newCondition == null) {
            if (oldCondition == null) {
                return;
            }
            delegate.setConditionEnabled(false);
            delegate.setCondition(null);
        } else {
            if (newCondition.equals(oldCondition)) {
                return;
            }
            delegate.setCondition(newCondition);
            if (!delegate.isConditionEnabled()) {
                delegate.setConditionEnabled(true);
            }
        }
        super.configurationUpdated();
    }

    private String createCondition() {
        String phaseCondition = this.createPhaseCondition();
        ITransformConfiguration config = this.getTransformConfiguration();
        if (config == null) {
            return phaseCondition;
        }
        Set<TransformType> transforms = config.getTransforms();
        if (transforms == null || transforms.isEmpty()) {
            return phaseCondition;
        }
        boolean addOr = false;
        StringBuffer buffer = new StringBuffer();
        if (phaseCondition != null) {
            buffer.append(phaseCondition).append(" && ");
        }
        buffer.append("_sequence.size() > 1 && (\n");
        for (TransformType transform : transforms) {
            if (transform.getFrom() == null || transform.getTo() == null) continue;
            if (addOr) {
                buffer.append(" || ");
            } else {
                addOr = true;
            }
            buffer.append('(');
            buffer.append("javax.xml.namespace.QName.valueOf(\"").append(transform.getFrom()).append("\").equals(_sequence.get(0))");
            buffer.append(" && ");
            buffer.append("(javax.xml.namespace.QName.valueOf(\"").append(transform.getTo()).append("\").equals(_sequence.get(_sequence.size()-1))");
            buffer.append(")\n");
        }
        buffer.append(')');
        buffer.insert(0, '(');
        buffer.append(")");
        return buffer.toString();
    }

    private String createPhaseCondition() {
        IInteractionConfiguration config = this.getInteractionConfiguration();
        if (config == null) {
            return null;
        }
        Set<IInteractionConfiguration.TriggerType> triggers = config.getTriggers();
        if (triggers == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean addOr = false;
        buffer.append("(");
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.IN)) {
            if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
                return null;
            }
            buffer.append("org.switchyard.ExchangePhase.IN == ").append(VARIABLE_NAME).append(".getPropertyValue(\"org.switchyard.bus.camel.phase\")");
            addOr = true;
        }
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("org.switchyard.ExchangePhase.OUT == ").append(VARIABLE_NAME).append(".getPropertyValue(\"org.switchyard.bus.camel.phase\")");
        } else if (triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("Boolean.TRUE.equals(").append(VARIABLE_NAME).append(".getPropertyValue(\"org.switchyard.bus.camel.fault\"))");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    protected void updateEnabled(boolean enabled) throws CoreException {
        this.getDelegate().setEnabled(enabled);
    }
}

