/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpoint;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpointEditor;
import org.switchyard.tools.ui.debug.SwitchYardDebugModelPresentation;
import org.switchyard.tools.ui.debug.TransformBreakpointEditor;
import org.switchyard.tools.ui.debug.TransformSequenceBreakpoint;
import org.switchyard.tools.ui.debug.ValidateBreakpointEditor;
import org.switchyard.tools.ui.debug.ValidateHandlerBreakpoint;

public class SwitchYardBreakpointPage
extends JavaBreakpointPage {
    private AbstractJavaBreakpointEditor _editor;
    private final Class<? extends IBreakpoint> _type;

    protected SwitchYardBreakpointPage(Class<? extends IBreakpoint> type) {
        this._type = type;
    }

    public void setElement(IAdaptable element) {
        Object source = element.getAdapter(EObject.class);
        if (source == null) {
            super.setElement(element);
        } else {
            super.setElement((IAdaptable)Platform.getAdapterManager().getAdapter(source, this._type));
        }
    }

    protected void doStore() throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
        if (this._editor.isDirty()) {
            this._editor.doSave();
        }
    }

    protected void createTypeSpecificEditors(Composite parent) {
        try {
            String type = this.getBreakpoint().getMarker().getType();
            this._editor = "org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(type) ? new TransformBreakpointEditor() : ("org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker".equals(type) ? new ValidateBreakpointEditor() : new ServiceInteractionBreakpointEditor());
            this._editor.createControl(parent);
            this._editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    IStatus status = SwitchYardBreakpointPage.this._editor.getStatus();
                    if (status.isOK()) {
                        if (SwitchYardBreakpointPage.this.fPrevMessage != null) {
                            SwitchYardBreakpointPage.this.removeErrorMessage(SwitchYardBreakpointPage.this.fPrevMessage);
                            SwitchYardBreakpointPage.this.fPrevMessage = null;
                        }
                    } else {
                        SwitchYardBreakpointPage.this.fPrevMessage = status.getMessage();
                        SwitchYardBreakpointPage.this.addErrorMessage(SwitchYardBreakpointPage.this.fPrevMessage);
                    }
                }
            });
            this._editor.setInput((Object)this.getBreakpoint());
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected void createTypeSpecificLabels(Composite parent) {
        DelegatingJavaBreakpoint breakpoint = (DelegatingJavaBreakpoint)this.getBreakpoint();
        IResource resource = breakpoint.getMarker().getResource();
        IInteractionConfiguration configuration = breakpoint.getInteractionConfiguration();
        QName service = configuration.getConsumerName() != null ? configuration.getConsumerName() : (configuration.getProviderName() != null ? configuration.getProviderName() : null);
        if (service != null) {
            this.createLabel(parent, "Service Name");
            SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)service.getLocalPart());
            if (service.getNamespaceURI() != null) {
                this.createLabel(parent, "Service Namespace");
                SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)service.getNamespaceURI());
            }
        }
        if (resource != null && resource.getProject() != null) {
            this.createLabel(parent, "Project");
            SWTFactory.createText((Composite)parent, (int)8, (int)1, (String)resource.getProject().getName());
        }
        this.setTitle(new SwitchYardDebugModelPresentation().getText(breakpoint));
    }

    public static final class ServiceInteractionBreakpointPage
    extends SwitchYardBreakpointPage {
        public ServiceInteractionBreakpointPage() {
            super(ServiceInteractionBreakpoint.class);
        }
    }

    public static final class TransformSequenceBreakpointPage
    extends SwitchYardBreakpointPage {
        public TransformSequenceBreakpointPage() {
            super(TransformSequenceBreakpoint.class);
        }
    }

    public static final class ValidateHandlerBreakpointPage
    extends SwitchYardBreakpointPage {
        public ValidateHandlerBreakpointPage() {
            super(ValidateHandlerBreakpoint.class);
        }
    }
}

