/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.switchyard.tools.ui.debug.CamelProcessorBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;

public class ServiceInterceptBreakpoint
extends CamelProcessorBreakpoint {
    private static final String MARKER_ID = "org.switchyard.tools.ui.debug.switchYardBreakpointMarker";
    private static final String TYPE = "org.switchyard.bus.camel.processors.InterceptProcessor";
    private static final String EXCHANGE_VARIABLE = "ex";

    public ServiceInterceptBreakpoint() {
        super(TYPE, EXCHANGE_VARIABLE);
    }

    public ServiceInterceptBreakpoint(IResource resource, IInteractionConfiguration configuration, boolean register) throws CoreException {
        super(resource, configuration, register, TYPE, EXCHANGE_VARIABLE, MARKER_ID);
        this.createDelegates();
    }

    @Override
    protected String createCondition() {
        String condition = super.createCondition();
        if (condition == null) {
            return condition;
        }
        String targetCondition = this.createTargetCondition();
        if (targetCondition == null) {
            return condition;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(targetCondition);
        buffer.append("\n        && ");
        buffer.append(condition);
        buffer.insert(0, '(');
        buffer.append(')');
        return buffer.toString();
    }

    protected SwitchYardDebugUtil.ServiceType getTargetType() {
        IInteractionConfiguration config = this.getInteractionConfiguration();
        SwitchYardDebugUtil.ServiceType type = config.getConsumerName() == null ? (config.getProviderName() == null ? null : SwitchYardDebugUtil.ServiceType.PROVIDER) : (config.getProviderName() == null ? SwitchYardDebugUtil.ServiceType.CONSUMER : null);
        return type;
    }

    protected String createTargetCondition() {
        SwitchYardDebugUtil.ServiceType type = this.getTargetType();
        if (type == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"').append(type.toString()).append('\"').append(".equalsIgnoreCase(this._target)");
        return buffer.toString();
    }
}

