/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;

public class ServiceInteractionBreakpointEditor
extends AbstractJavaBreakpointEditor {
    public static final int TRIGGER_PROP = 1;
    public static final int ASPECT_PROP = 2;
    private DelegatingJavaBreakpoint<?> _breakpoint;
    private Button _inButton;
    private Button _outButton;
    private Button _faultButton;
    private List<Button> _aspectButtons;
    private Set<IInteractionConfiguration.AspectType> _aspects;
    private Set<IInteractionConfiguration.TriggerType> _triggers;
    private boolean _updating;

    public Control createControl(Composite parent) {
        ScrolledComposite scrollable = new ScrolledComposite(parent, 768);
        scrollable.setLayout((Layout)new GridLayout());
        scrollable.setLayoutData((Object)new GridData(1808));
        Composite content = new Composite((Composite)scrollable, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        content.setBackground(parent.getBackground());
        content.setBackgroundMode(1);
        Group phaseGroup = new Group(content, 0);
        phaseGroup.setLayout((Layout)new GridLayout(3, false));
        phaseGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        phaseGroup.setText("Triggering phase");
        this._inButton = new Button((Composite)phaseGroup, 32);
        this._inButton.setText("IN");
        this._inButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.IN));
        this._outButton = new Button((Composite)phaseGroup, 32);
        this._outButton.setText("OUT");
        this._outButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.OUT));
        this._faultButton = new Button((Composite)phaseGroup, 32);
        this._faultButton.setText("FAULT");
        this._faultButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.FAULT));
        Group aspectsGroup = new Group(content, 0);
        aspectsGroup.setLayout((Layout)new GridLayout(3, false));
        aspectsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        aspectsGroup.setText("Trigger on");
        SelectionAdapter aspectSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ServiceInteractionBreakpointEditor.this._updating) {
                    return;
                }
                IInteractionConfiguration.AspectType aspect = (IInteractionConfiguration.AspectType)((Object)event.widget.getData(IInteractionConfiguration.AspectType.class.getCanonicalName()));
                if (((Button)event.widget).getSelection()) {
                    ServiceInteractionBreakpointEditor.this._aspects.add(aspect);
                } else {
                    ServiceInteractionBreakpointEditor.this._aspects.remove((Object)aspect);
                }
                ServiceInteractionBreakpointEditor.this.setDirty(2);
            }
        };
        this._aspectButtons = new ArrayList<Button>(IInteractionConfiguration.AspectType.values().length);
        IInteractionConfiguration.AspectType[] aspectTypeArray = IInteractionConfiguration.AspectType.values();
        int n = aspectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInteractionConfiguration.AspectType aspect = aspectTypeArray[n2];
            Button button = new Button((Composite)aspectsGroup, 32);
            button.setData(IInteractionConfiguration.AspectType.class.getCanonicalName(), (Object)aspect);
            button.setText(aspect.toString());
            button.addSelectionListener((SelectionListener)aspectSelectionListener);
            this._aspectButtons.add(button);
            ++n2;
        }
        scrollable.setContent((Control)content);
        content.setSize(content.computeSize(-1, -1));
        return scrollable;
    }

    public void setFocus() {
    }

    public IStatus getStatus() {
        if (this._inButton.getSelection() || this._outButton.getSelection() || this._faultButton.getSelection()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.switchyard.tools.ui.debug", "Must select at least one trigger (IN, OUT or FAULT).");
    }

    public Object getInput() {
        return this._breakpoint;
    }

    public void setInput(Object breakpoint) throws CoreException {
        this._updating = true;
        try {
            if (breakpoint instanceof DelegatingJavaBreakpoint) {
                this._breakpoint = (DelegatingJavaBreakpoint)breakpoint;
            } else {
                breakpoint = null;
            }
            this.initialize();
        }
        finally {
            this._updating = false;
        }
    }

    public void doSave() throws CoreException {
        if (this._breakpoint != null) {
            InteractionConfigurationBuilder builder = InteractionConfigurationBuilder.createFrom(this._breakpoint.getInteractionConfiguration());
            builder.triggers(this._triggers.isEmpty() ? null : EnumSet.copyOf(this._triggers));
            builder.aspects(this._aspects.isEmpty() ? null : EnumSet.copyOf(this._aspects));
            this._breakpoint.setInteractionConfiguration(builder.build());
        }
        this.setDirty(false);
    }

    private void initialize() {
        if (this._breakpoint == null) {
            this._inButton.setEnabled(false);
            this._inButton.setSelection(false);
            this._outButton.setEnabled(false);
            this._outButton.setSelection(false);
            this._faultButton.setEnabled(false);
            this._faultButton.setSelection(false);
        } else {
            IInteractionConfiguration config = this._breakpoint.getInteractionConfiguration();
            this._triggers = config == null ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : config.getTriggers();
            this._triggers = this._triggers == null || this._triggers.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : EnumSet.copyOf(this._triggers);
            this._aspects = config == null ? EnumSet.allOf(IInteractionConfiguration.AspectType.class) : config.getAspects();
            this._aspects = this._aspects == null || this._aspects.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.AspectType.class) : EnumSet.copyOf(this._aspects);
            this._inButton.setEnabled(true);
            this._inButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.IN));
            this._outButton.setEnabled(true);
            this._outButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT));
            this._faultButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT));
            for (Button button : this._aspectButtons) {
                IInteractionConfiguration.AspectType aspect = (IInteractionConfiguration.AspectType)((Object)button.getData(IInteractionConfiguration.AspectType.class.getCanonicalName()));
                button.setSelection(this._aspects.contains((Object)aspect));
            }
            this.updateEnablement();
        }
        this.setDirty(false);
    }

    private void updateEnablement() {
        this._faultButton.setEnabled(!this._outButton.getSelection());
        for (Button button : this._aspectButtons) {
            IInteractionConfiguration.AspectType aspect = (IInteractionConfiguration.AspectType)((Object)button.getData(IInteractionConfiguration.AspectType.class.getCanonicalName()));
            button.setEnabled(aspect.shouldEnable(this._triggers));
        }
    }

    private final class TriggerSelectionListener
    extends SelectionAdapter {
        private final IInteractionConfiguration.TriggerType _trigger;

        private TriggerSelectionListener(IInteractionConfiguration.TriggerType trigger) {
            this._trigger = trigger;
        }

        public void widgetSelected(SelectionEvent event) {
            if (ServiceInteractionBreakpointEditor.this._updating) {
                return;
            }
            if (((Button)event.widget).getSelection()) {
                ServiceInteractionBreakpointEditor.this._triggers.add(this._trigger);
            } else {
                ServiceInteractionBreakpointEditor.this._triggers.remove((Object)this._trigger);
            }
            ServiceInteractionBreakpointEditor.this.updateEnablement();
            ServiceInteractionBreakpointEditor.this.setDirty(1);
        }
    }
}

