/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;

public class ServiceBreakpoint
extends JavaMethodBreakpoint {
    public static final String TRIGGER_KEY = "switchYardServiceBreakpoint.trigger";
    public static final String SERVICE_TYPE_KEY = "switchYardServiceBreakpoint.type";
    public static final String SERVICE_NAME_KEY = "switchYardServiceBreakpoint.name";

    public ServiceBreakpoint() {
    }

    public ServiceBreakpoint(IResource resource, QName service, String uri, SwitchYardDebugUtil.ServiceType type, Set<IInteractionConfiguration.TriggerType> triggers) throws CoreException {
        super(resource, "org.switchyard.bus.camel.processors.InterceptProcessor", "process", "(Lorg/apache/camel/Exchange;)V", true, false, false, -1, -1, -1, 0, true, ServiceBreakpoint.createAttributes(service, uri, type, triggers));
    }

    public void setMarker(IMarker marker) throws CoreException {
        if (!"org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker".equals(marker.getType())) {
            marker.delete();
            marker = marker.getResource().createMarker("org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker");
        }
        super.setMarker(marker);
    }

    public String getModelIdentifier() {
        return "org.switchyard.tools.ui.debug";
    }

    public boolean isEntry() throws CoreException {
        return this.getTriggerTypes().contains((Object)IInteractionConfiguration.TriggerType.IN);
    }

    public void setEntry(boolean entry) throws CoreException {
        Set<IInteractionConfiguration.TriggerType> triggers = this.getTriggerTypes();
        boolean update = entry ? triggers.add(IInteractionConfiguration.TriggerType.IN) : triggers.remove((Object)IInteractionConfiguration.TriggerType.IN);
        if (update) {
            this.update(this.getServiceName(), this.getServiceType(), triggers);
        }
    }

    public boolean isExit() throws CoreException {
        return this.getTriggerTypes().contains((Object)IInteractionConfiguration.TriggerType.OUT);
    }

    public void setExit(boolean exit) throws CoreException {
        Set<IInteractionConfiguration.TriggerType> triggers = this.getTriggerTypes();
        boolean update = exit ? triggers.add(IInteractionConfiguration.TriggerType.OUT) : triggers.remove((Object)IInteractionConfiguration.TriggerType.OUT);
        if (update) {
            this.update(this.getServiceName(), this.getServiceType(), triggers);
        }
    }

    protected void updateEnabledState(EventRequest request, JDIDebugTarget target) throws CoreException {
        boolean enabled = this.isEnabled();
        if (request instanceof MethodExitRequest) {
            enabled = false;
        }
        if (enabled != request.isEnabled()) {
            this.internalUpdateEnabledState(request, enabled, target);
        }
    }

    public QName getServiceName() {
        String name = this.getMarker().getAttribute(SERVICE_NAME_KEY, null);
        return name == null ? null : QName.valueOf(name);
    }

    public SwitchYardDebugUtil.ServiceType getServiceType() {
        String type = this.getMarker().getAttribute(SERVICE_TYPE_KEY, null);
        return type == null ? null : SwitchYardDebugUtil.ServiceType.valueOf(type);
    }

    public Set<IInteractionConfiguration.TriggerType> getTriggerTypes() {
        String triggerStrings = this.getMarker().getAttribute(TRIGGER_KEY, null);
        return triggerStrings == null ? null : SwitchYardDebugUtil.fromString(IInteractionConfiguration.TriggerType.class, triggerStrings);
    }

    public void update(QName service, SwitchYardDebugUtil.ServiceType type, Set<IInteractionConfiguration.TriggerType> triggers) throws CoreException {
        this.setAttributes(new String[]{TRIGGER_KEY, SERVICE_TYPE_KEY, SERVICE_NAME_KEY, "message"}, new Object[]{SwitchYardDebugUtil.toString(triggers), type.toString(), service.toString(), String.format("Service %s: %s {%s} on %s", new Object[]{type, service.getLocalPart(), service.getNamespaceURI(), triggers})});
        this.setCondition(ServiceBreakpoint.createCondition(service, type, triggers));
    }

    private static Map<String, Object> createAttributes(QName service, String uri, SwitchYardDebugUtil.ServiceType type, Set<IInteractionConfiguration.TriggerType> triggers) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(TRIGGER_KEY, SwitchYardDebugUtil.toString(triggers));
        attributes.put(SERVICE_TYPE_KEY, type.toString());
        attributes.put(SERVICE_NAME_KEY, service.toString());
        attributes.put("org.eclipse.jdt.debug.core.conditionEnabled", Boolean.TRUE);
        attributes.put("org.eclipse.jdt.debug.core.condition", ServiceBreakpoint.createCondition(service, type, triggers));
        attributes.put("message", String.format("Service %s: %s {%s} on %s", new Object[]{type, service.getLocalPart(), service.getNamespaceURI(), triggers}));
        attributes.put("uri", uri);
        return attributes;
    }

    private static String createCondition(QName service, SwitchYardDebugUtil.ServiceType type, Set<IInteractionConfiguration.TriggerType> triggers) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"').append(type.toString()).append('\"').append(".equalsIgnoreCase(this._target)");
        buffer.append("\n        && ");
        if (triggers == null || triggers.isEmpty()) {
            triggers = EnumSet.allOf(IInteractionConfiguration.TriggerType.class);
        }
        boolean addOr = false;
        buffer.append("(");
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.IN)) {
            buffer.append("org.switchyard.ExchangePhase.IN == ex.getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
            addOr = true;
        }
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("org.switchyard.ExchangePhase.OUT == ex.getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
        } else if (triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("ex.getProperty(\"org.switchyard.bus.camel.fault\", false, Boolean.class)");
        }
        buffer.append(")");
        buffer.append("\n        && ");
        if (type == SwitchYardDebugUtil.ServiceType.PROVIDER) {
            buffer.append('\"').append(service.toString()).append('\"').append(".equals(ex.getProperty(\"org.switchyard.bus.camel.provider\", org.switchyard.Service.class).getName().toString())");
        } else {
            buffer.append('\"').append(service.toString()).append('\"').append(".equals(ex.getProperty(\"org.switchyard.bus.camel.consumer\", org.switchyard.ServiceReference.class).getName().toString())");
        }
        return buffer.toString();
    }
}

