/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;

public class InteractionConfigurationBuilder {
    public static final String TRIGGER_KEY = "switchYardServiceBreakpoint.trigger";
    public static final String ASPECT_KEY = "switchYardServiceBreakpoint.aspect";
    public static final String CONSUMER_NAME_KEY = "switchYardServiceBreakpoint.consumer.name";
    public static final String CONSUMER_URI_KEY = "switchYardServiceBreakpoint.consumer.uri";
    public static final String PROVIDER_NAME_KEY = "switchYardServiceBreakpoint.provider.name";
    public static final String PROVIDER_URI_KEY = "switchYardServiceBreakpoint.provider.uri";
    private BasicBreakpointConfiguration _config;

    private InteractionConfigurationBuilder() {
        this(new BasicBreakpointConfiguration());
    }

    protected InteractionConfigurationBuilder(BasicBreakpointConfiguration config) {
        this._config = config;
    }

    public InteractionConfigurationBuilder triggers(Set<IInteractionConfiguration.TriggerType> triggers) {
        this._config._triggers = triggers == null || triggers.isEmpty() ? null : EnumSet.copyOf(triggers);
        return this;
    }

    public InteractionConfigurationBuilder aspects(Set<IInteractionConfiguration.AspectType> aspects) {
        this._config._aspects = aspects == null || aspects.isEmpty() ? null : EnumSet.copyOf(aspects);
        return this;
    }

    public InteractionConfigurationBuilder consumer(QName name, String uri) {
        this._config._consumerName = name;
        this._config._consumerUri = uri;
        return this;
    }

    public InteractionConfigurationBuilder provider(QName name, String uri) {
        this._config._providerName = name;
        this._config._providerUri = uri;
        return this;
    }

    public InteractionConfigurationBuilder updateFrom(Map<String, Object> attributes) {
        return this.triggers(SwitchYardDebugUtil.fromString(IInteractionConfiguration.TriggerType.class, this.getString(attributes, TRIGGER_KEY, null))).aspects(SwitchYardDebugUtil.fromString(IInteractionConfiguration.AspectType.class, this.getString(attributes, ASPECT_KEY, null))).consumer(this.getQName(attributes, CONSUMER_NAME_KEY, null), this.getString(attributes, CONSUMER_URI_KEY, null)).provider(this.getQName(attributes, PROVIDER_NAME_KEY, null), this.getString(attributes, PROVIDER_URI_KEY, null));
    }

    public IInteractionConfiguration build() {
        return this._config;
    }

    public static InteractionConfigurationBuilder create() {
        return new InteractionConfigurationBuilder();
    }

    public static InteractionConfigurationBuilder createFrom(IInteractionConfiguration config) {
        if (config == null) {
            return InteractionConfigurationBuilder.create();
        }
        return InteractionConfigurationBuilder.create().updateFrom(config);
    }

    protected InteractionConfigurationBuilder updateFrom(IInteractionConfiguration config) {
        return InteractionConfigurationBuilder.create().triggers(config.getTriggers()).consumer(config.getConsumerName(), config.getConsumerUri()).provider(config.getProviderName(), config.getProviderUri());
    }

    protected QName getQName(Map<String, Object> attributes, String key, QName defaultValue) {
        Object value;
        if (attributes.containsKey(key) && (value = attributes.get(key)) instanceof String) {
            return QName.valueOf((String)value);
        }
        return defaultValue;
    }

    protected String getString(Map<String, Object> attributes, String key, String defaultValue) {
        Object value;
        if (attributes.containsKey(key) && (value = attributes.get(key)) instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    protected boolean getBoolean(Map<String, Object> attributes, String key, boolean defaultValue) {
        Object value;
        if (attributes.containsKey(key) && (value = attributes.get(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    protected static class BasicBreakpointConfiguration
    implements IInteractionConfiguration {
        private Set<IInteractionConfiguration.TriggerType> _triggers;
        private Set<IInteractionConfiguration.AspectType> _aspects;
        private QName _providerName;
        private String _providerUri;
        private QName _consumerName;
        private String _consumerUri;

        protected BasicBreakpointConfiguration() {
        }

        @Override
        public Set<IInteractionConfiguration.TriggerType> getTriggers() {
            return this._triggers == null || this._triggers.isEmpty() ? null : EnumSet.copyOf(this._triggers);
        }

        @Override
        public QName getProviderName() {
            return this._providerName;
        }

        @Override
        public String getProviderUri() {
            return this._providerUri;
        }

        @Override
        public QName getConsumerName() {
            return this._consumerName;
        }

        @Override
        public String getConsumerUri() {
            return this._consumerUri;
        }

        @Override
        public Set<IInteractionConfiguration.AspectType> getAspects() {
            return this._aspects == null || this._aspects.isEmpty() ? null : EnumSet.copyOf(this._aspects);
        }

        @Override
        public Map<String, Object> toAttributesMap() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(InteractionConfigurationBuilder.CONSUMER_NAME_KEY, this._consumerName == null ? null : this._consumerName.toString());
            attributes.put(InteractionConfigurationBuilder.CONSUMER_URI_KEY, this._consumerUri);
            attributes.put(InteractionConfigurationBuilder.PROVIDER_NAME_KEY, this._providerName == null ? null : this._providerName.toString());
            attributes.put(InteractionConfigurationBuilder.PROVIDER_URI_KEY, this._providerUri);
            attributes.put(InteractionConfigurationBuilder.TRIGGER_KEY, this._triggers != null && this._triggers.size() > 0 ? SwitchYardDebugUtil.toString(this._triggers) : null);
            attributes.put(InteractionConfigurationBuilder.ASPECT_KEY, this._aspects != null && this._aspects.size() > 0 ? SwitchYardDebugUtil.toString(this._aspects) : null);
            return attributes;
        }

        public int hashCode() {
            return this._consumerName == null ? (this._providerName == null ? 0 : this._providerName.hashCode()) : this._consumerName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BasicBreakpointConfiguration) {
                BasicBreakpointConfiguration other = (BasicBreakpointConfiguration)obj;
                return this.valuesMatch(this._providerName, other._providerName) && this.valuesMatch(this._providerUri, other._providerUri) && this.valuesMatch(this._consumerName, other._consumerName) && this.valuesMatch(this._consumerUri, other._consumerUri) && this.setsMatch(this._triggers, other._triggers) && this.setsMatch(this._aspects, other._aspects);
            }
            return false;
        }

        private boolean valuesMatch(Object one, Object other) {
            return one == null && other == null || one != null && one.equals(other);
        }

        private boolean setsMatch(Set<?> one, Set<?> other) {
            return (one == null || one.isEmpty()) && (other == null || other.isEmpty()) || one != null && one.equals(other);
        }
    }
}

