/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public interface IInteractionConfiguration {
    public QName getProviderName();

    public String getProviderUri();

    public QName getConsumerName();

    public String getConsumerUri();

    public Set<TriggerType> getTriggers();

    public Set<AspectType> getAspects();

    public Map<String, Object> toAttributesMap();

    public static enum AspectType {
        ENTRY(EnumSet.of(TriggerType.IN)),
        RETURN(EnumSet.of(TriggerType.OUT)),
        FAULT(EnumSet.of(TriggerType.OUT, TriggerType.FAULT)),
        TRANSACTION(null),
        SECURITY(null),
        POLICY(EnumSet.of(TriggerType.IN)),
        TARGET_INVOCATION(EnumSet.of(TriggerType.IN)),
        VALIDATION(null),
        TRANSFORMATION(null);

        private final Set<TriggerType> _supportedTriggers;

        private AspectType(Set<TriggerType> supportedTriggers) {
            this._supportedTriggers = supportedTriggers;
        }

        public boolean shouldEnable(Set<TriggerType> triggers) {
            return triggers == null || this._supportedTriggers == null || this.containsTriggers(triggers);
        }

        private boolean containsTriggers(Set<TriggerType> triggers) {
            for (TriggerType trigger : triggers) {
                if (!this._supportedTriggers.contains((Object)trigger)) continue;
                return true;
            }
            return false;
        }

        public Set<TriggerType> getSupportedTriggers() {
            return this._supportedTriggers == null ? null : Collections.unmodifiableSet(this._supportedTriggers);
        }
    }

    public static enum TriggerType {
        IN,
        OUT,
        FAULT;

    }
}

