/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.switchyard.tools.ui.debug";
    private static Activator plugin;
    private IDebugEventSetListener _debugListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.addDebugEventListener();
    }

    public void stop(BundleContext context) throws Exception {
        this.removeDebugEventListener();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void addDebugEventListener() {
        if (this._debugListener == null) {
            this._debugListener = new SwitchYardDebugEventSetListener();
            DebugPlugin.getDefault().addDebugEventListener(this._debugListener);
        }
    }

    private void removeDebugEventListener() {
        if (this._debugListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this._debugListener);
            this._debugListener = null;
        }
    }

    private static final class SwitchYardDebugEventSetListener
    implements IDebugEventSetListener {
        private SwitchYardDebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint[] breakpoints;
                IJavaDebugTarget target;
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget && "debug".equals((target = (IJavaDebugTarget)event.getSource()).getLaunch().getLaunchMode()) && (breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(Activator.PLUGIN_ID)) != null && breakpoints.length != 0) {
                    int n3;
                    IResource[] resources = null;
                    try {
                        resources = target.getLaunch().getLaunchConfiguration().getMappedResources();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (resources == null) {
                        IBreakpoint[] iBreakpointArray = breakpoints;
                        n3 = breakpoints.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBreakpoint breakpoint = iBreakpointArray[n4];
                            try {
                                if (breakpoint.isEnabled()) {
                                    target.breakpointAdded(breakpoint);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++n4;
                        }
                    } else {
                        HashSet<IProject> projectSet = new HashSet<IProject>();
                        IResource[] iResourceArray = resources;
                        int n5 = resources.length;
                        n3 = 0;
                        while (n3 < n5) {
                            IResource resource = iResourceArray[n3];
                            this.addProjectBreakpoints(resource.getProject(), breakpoints, target, projectSet);
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
        }

        private void addProjectBreakpoints(IProject project, IBreakpoint[] breakpoints, IJavaDebugTarget target, Set<IProject> seen) {
            if (!seen.add(project)) {
                return;
            }
            if (!project.isAccessible()) {
                return;
            }
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IProject breakpointProject = breakpoint.getMarker().getResource().getProject();
                if (project.equals((Object)breakpointProject)) {
                    try {
                        if (breakpoint.isEnabled()) {
                            target.breakpointAdded(breakpoint);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            try {
                IProjectDescription description = project.getDescription();
                IProject[] iProjectArray = description.getDynamicReferences();
                int n3 = iProjectArray.length;
                n = 0;
                while (n < n3) {
                    IProject referenced = iProjectArray[n];
                    this.addProjectBreakpoints(referenced, breakpoints, target, seen);
                    ++n;
                }
                iProjectArray = description.getReferencedProjects();
                n3 = iProjectArray.length;
                n = 0;
                while (n < n3) {
                    IProject referenced = iProjectArray[n];
                    this.addProjectBreakpoints(referenced, breakpoints, target, seen);
                    ++n;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

