/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenameJavaElementAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public RenameJavaElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenameJavaElementAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenameJavaElementAction.canEnable(selection));
                return;
            }
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isRenameElementAvailable(element);
    }

    private static IJavaElement getJavaElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)first;
    }

    public void run(IStructuredSelection selection) {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return;
        }
        if (!ActionUtil.isEditable(this.getShell(), element)) {
            return;
        }
        try {
            this.run(element, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        block5: {
            if (selection instanceof JavaTextSelection) {
                try {
                    JavaTextSelection javaTextSelection = (JavaTextSelection)selection;
                    IJavaElement[] elements = javaTextSelection.resolveElementAtOffset();
                    if (elements.length == 1) {
                        this.setEnabled(RefactoringAvailabilityTester.isRenameElementAvailable(elements[0]));
                        break block5;
                    }
                    ASTNode node = javaTextSelection.resolveCoveringNode();
                    this.setEnabled(node instanceof SimpleName);
                }
                catch (CoreException coreException) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        if (this.canRunInEditor()) {
            this.doRun();
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAction_rename, (String)RefactoringMessages.RenameAction_unavailable);
        }
    }

    public void doRun() {
        RenameLinkedMode activeLinkedMode = RenameLinkedMode.getActiveLinkedMode();
        if (activeLinkedMode != null) {
            if (activeLinkedMode.isCaretInLinkedPosition()) {
                activeLinkedMode.startFullDialog();
                return;
            }
            activeLinkedMode.cancel();
        }
        try {
            CorrectionCommandHandler handler;
            IJavaElement element = this.getJavaElementFromEditor();
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            boolean lightweight = store.getBoolean("Refactor.lightweight");
            if (element != null && RefactoringAvailabilityTester.isRenameElementAvailable(element)) {
                this.run(element, lightweight);
                return;
            }
            if (lightweight && (handler = new CorrectionCommandHandler(this.fEditor, "org.eclipse.jdt.ui.correction.renameInFile.assist", true)).doExecute()) {
                this.fEditor.setStatusLineErrorMessage(RefactoringMessages.RenameJavaElementAction_started_rename_in_file);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameJavaElementAction_name, (String)RefactoringMessages.RenameJavaElementAction_not_available);
    }

    public boolean canRunInEditor() {
        IJavaElement element;
        block6: {
            if (RenameLinkedMode.getActiveLinkedMode() != null) {
                return true;
            }
            element = this.getJavaElementFromEditor();
            if (element != null) break block6;
            return true;
        }
        try {
            return RefactoringAvailabilityTester.isRenameElementAvailable(element);
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private IJavaElement getJavaElementFromEditor() throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IJavaElement element, boolean lightweight) throws CoreException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), element)) {
            return;
        }
        if (ActionUtil.mustDisableJavaModelAction(this.getShell(), element)) {
            return;
        }
        if (lightweight && this.fEditor instanceof CompilationUnitEditor && !(element instanceof IPackageFragment)) {
            new RenameLinkedMode(element, (CompilationUnitEditor)this.fEditor).start();
        } else {
            RefactoringExecutionStarter.startRenameRefactoring(element, this.getShell());
        }
    }
}

