/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeType;
import org.jboss.tools.forge.ui.wizards.internal.WizardsPlugin;

public class WizardsHelper {
    public static boolean isJPAProject(IProject project) {
        boolean result = false;
        JpaProject.Reference reference = (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
        try {
            result = reference.getValue() != null;
        }
        catch (InterruptedException e) {
            WizardsPlugin.log(e);
        }
        return result;
    }

    public static boolean isHibernateToolsPluginAvailable() {
        final StringBuffer buff = new StringBuffer();
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ForgeRuntime runtime = ForgeCorePreferences.INSTANCE.getDefaultRuntime();
                String str = runtime.sendCommand("forge list-plugins");
                StringBuffer stringBuffer = buff;
                synchronized (stringBuffer) {
                    buff.append(str).append(" done");
                }
            }
        };
        new Thread(command).start();
        while (buff.length() == 0) {
            try {
                Thread.currentThread().wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return buff.toString().contains("org.jboss.hibernate.forge.hibernate-tools-plugin");
    }

    public static ForgeRuntime getForgeRuntime() {
        ForgeRuntime[] runtimes;
        ForgeRuntime result = null;
        ForgeRuntime[] forgeRuntimeArray = runtimes = ForgeCorePreferences.INSTANCE.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            String version;
            ForgeRuntime runtime = forgeRuntimeArray[n2];
            if (!ForgeRuntimeType.EXTERNAL.equals((Object)runtime.getState()) && (version = runtime.getVersion()).startsWith("1.") && (result == null || WizardsHelper.isHigherVersion(version, result.getVersion()))) {
                result = runtime;
            }
            ++n2;
        }
        return result;
    }

    private static boolean isHigherVersion(String first, String second) {
        boolean result = false;
        String[] f = first.split("\\.-");
        String[] s = second.split("\\.-");
        int i = 0;
        while (i < 3) {
            if (Integer.valueOf(f[i]) > Integer.valueOf(s[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }
}

