/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold.ScaffoldWizard;

public class ScaffoldWizardHelper {
    private ScaffoldWizard wizard;
    private String installedFacets;
    private String currentDirectory;

    ScaffoldWizardHelper(ScaffoldWizard wizard) {
        this.wizard = wizard;
    }

    void checkIfSetupNeeded(final ForgeRuntime runtime) {
        Job job = new Job("Setup Needed"){

            protected IStatus run(IProgressMonitor monitor) {
                ScaffoldWizardHelper.this.currentDirectory = runtime.sendCommand("pwd").trim();
                runtime.sendCommand("cd " + ScaffoldWizardHelper.this.wizard.getProjectLocation());
                ScaffoldWizardHelper.this.installedFacets = runtime.sendCommand("project list-facets");
                runtime.sendCommand("cd " + ScaffoldWizardHelper.this.currentDirectory);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScaffoldWizardHelper.this.wizard.setSetupNeeded(!ScaffoldWizardHelper.this.installedFacets.contains(ScaffoldWizardHelper.this.getSetupString()));
                        ScaffoldWizardHelper.this.wizard.setBusy(false);
                    }
                });
            }
        });
        job.schedule();
    }

    private String getScaffoldType() {
        return (String)this.wizard.getWizardDescriptor().get("ScaffoldProjectWizardPage.scaffoldType");
    }

    private String getSetupString() {
        String scaffoldType = this.getScaffoldType();
        if ("faces".equals(scaffoldType)) {
            return "+ faces\t[org.jboss.forge.scaffold.faces.FacesScaffold]";
        }
        if ("angularjs".equals(scaffoldType)) {
            return "+ angularjs\t[org.jboss.forge.scaffold.angularjs.AngularScaffold]";
        }
        return "INSTALLED";
    }
}

