/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold.AngularJsInstaller;
import org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold.ScaffoldProjectWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold.ScaffoldWizardHelper;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class ScaffoldWizard
extends AbstractForgeWizard {
    private ScaffoldProjectWizardPage scaffoldProjectWizardPage = new ScaffoldProjectWizardPage();
    boolean setupNeeded = false;
    private boolean busy = false;

    public ScaffoldWizard() {
        this.setWindowTitle("Scaffold Entities");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.doInit(workbench, sel);
    }

    private void doInit(IWorkbench workbench, IStructuredSelection sel) {
        this.initializeProject(sel);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (!ScaffoldWizard.this.isAngularJsPluginAvailable()) {
                    new AngularJsInstaller().install(ScaffoldWizard.this.getShell(), ScaffoldWizard.this.getRuntime());
                }
            }
        };
        new Thread(runner).start();
    }

    private boolean isAngularJsPluginAvailable() {
        String str = this.getRuntime().sendCommand("forge list-plugins");
        return str != null && str.contains("org.jboss.forge.angularjs-scaffoldx-plugin");
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || !WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("ScaffoldProjectWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.scaffoldProjectWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.sendRuntimeCommand("cd " + this.getProjectLocation(), monitor);
        if (this.setupNeeded || ((Boolean)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.forceSetup")).booleanValue()) {
            String scaffoldType = (String)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.scaffoldType");
            String command = "scaffold-x setup --scaffoldType " + scaffoldType;
            if (((Boolean)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.overwriteExisting")).booleanValue()) {
                command = String.valueOf(command) + " --overwrite";
            }
            this.sendRuntimeCommand(command, monitor);
        }
        for (String entityName : this.getEntityNames()) {
            String command = "scaffold-x from " + entityName;
            if (((Boolean)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.overwriteExisting")).booleanValue()) {
                command = String.valueOf(command) + " --overwrite";
            }
            this.sendRuntimeCommand(command, monitor);
        }
    }

    @Override
    protected int getAmountOfWorkExecute() {
        int entities = this.getEntityNames().size();
        return this.setupNeeded ? entities + 2 : entities + 1;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        IProject project = this.getProject(this.getProjectName());
        this.refreshResource((IResource)project, monitor);
        this.updateProjectConfiguration(project, monitor);
    }

    @Override
    protected int getAmountOfWorkRefresh() {
        return 2;
    }

    @Override
    public String getStatusMessage() {
        return "Scaffolding entities for project '" + this.getProjectName() + "'.";
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.projectName");
    }

    private List<String> getEntityNames() {
        List result = (List)this.getWizardDescriptor().get("ScaffoldProjectWizardPage.entityNames");
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    String getProjectLocation() {
        return this.getProject(this.getProjectName()).getLocation().toOSString();
    }

    void checkIfSetupNeeded() {
        this.setBusy(true);
        new ScaffoldWizardHelper(this).checkIfSetupNeeded(this.getRuntime());
    }

    void setBusy(boolean b) {
        this.busy = b;
        this.scaffoldProjectWizardPage.updatePageComplete();
    }

    void setSetupNeeded(boolean b) {
        this.setupNeeded = b;
    }

    boolean isBusy() {
        return this.busy;
    }
}

