/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.scaffold.ScaffoldWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class ScaffoldProjectWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "ScaffoldProjectWizardPage.projectName";
    static final String SCAFFOLD_TYPE = "ScaffoldProjectWizardPage.scaffoldType";
    static final String ENTITY_NAMES = "ScaffoldProjectWizardPage.entityNames";
    static final String OVERWRITE_EXISTING = "ScaffoldProjectWizardPage.overwriteExisting";
    static final String FORCE_SETUP = "ScaffoldProjectWizardPage.forceSetup";
    static final String SCAFFOLD_TYPE_FACES = "faces";
    static final String SCAFFOLD_TYPE_ANGULARJS = "angularjs";
    private Combo projectNameCombo;
    private Combo scaffoldTypeCombo;
    private Button overwriteButton;
    private Button forceSetupButton;
    private Table selectEntitiesTable;
    private Label selectEntitiesLabel;
    private ArrayList<String> entityNames = new ArrayList();

    protected ScaffoldProjectWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.scaffold.project", "Select Project", null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createScaffoldTypeEditor(control);
        this.createOverwriteButton(control);
        this.createForceSetupButton(control);
        this.createEntitiesEditor(control);
        this.setControl((Control)control);
    }

    private void createForceSetupButton(Composite parent) {
        this.forceSetupButton = new Button(parent, 32);
        this.forceSetupButton.setSelection(true);
        this.getWizardDescriptor().put(FORCE_SETUP, true);
        this.forceSetupButton.setText("Force Scaffold Setup");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.forceSetupButton.setLayoutData((Object)gridData);
        this.forceSetupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ScaffoldProjectWizardPage.this.getWizardDescriptor().put(ScaffoldProjectWizardPage.FORCE_SETUP, ScaffoldProjectWizardPage.this.overwriteButton.getSelection());
            }
        });
    }

    private void createOverwriteButton(Composite parent) {
        this.overwriteButton = new Button(parent, 32);
        this.overwriteButton.setSelection(true);
        this.getWizardDescriptor().put(OVERWRITE_EXISTING, true);
        this.overwriteButton.setText("Overwrite Existing Files");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.overwriteButton.setLayoutData((Object)gridData);
        this.overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ScaffoldProjectWizardPage.this.getWizardDescriptor().put(ScaffoldProjectWizardPage.OVERWRITE_EXISTING, ScaffoldProjectWizardPage.this.overwriteButton.getSelection());
            }
        });
    }

    private void createScaffoldTypeEditor(Composite parent) {
        Label scaffoldTypeLabel = new Label(parent, 0);
        scaffoldTypeLabel.setText("Scaffold Type: ");
        this.scaffoldTypeCombo = new Combo(parent, 12);
        this.scaffoldTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaffoldTypeCombo.add(SCAFFOLD_TYPE_FACES);
        this.scaffoldTypeCombo.add(SCAFFOLD_TYPE_ANGULARJS);
        String scaffoldType = (String)this.getWizardDescriptor().get(SCAFFOLD_TYPE);
        if (scaffoldType != null) {
            this.scaffoldTypeCombo.setText(scaffoldType);
            this.handleScaffoldTypeChange();
        }
        this.scaffoldTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newScaffoldType = ScaffoldProjectWizardPage.this.scaffoldTypeCombo.getText();
                String oldScaffoldType = (String)ScaffoldProjectWizardPage.this.getWizardDescriptor().get(ScaffoldProjectWizardPage.SCAFFOLD_TYPE);
                if (oldScaffoldType == null && newScaffoldType != null || !oldScaffoldType.equals(newScaffoldType)) {
                    ScaffoldProjectWizardPage.this.handleScaffoldTypeChange();
                }
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createProjectEditor(Composite parent) {
        IProject[] allProjects;
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project: ");
        this.projectNameCombo = new Combo(parent, 12);
        this.projectNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WizardsHelper.isJPAProject(project)) {
                this.projectNameCombo.add(project.getName());
            }
            ++n2;
        }
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName != null) {
            this.projectNameCombo.setText(projectName);
            this.handleProjectChange();
        }
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newProjectName = ScaffoldProjectWizardPage.this.projectNameCombo.getText();
                String oldProjectName = (String)ScaffoldProjectWizardPage.this.getWizardDescriptor().get(ScaffoldProjectWizardPage.PROJECT_NAME);
                if (oldProjectName == null && newProjectName != null || !oldProjectName.equals(newProjectName)) {
                    ScaffoldProjectWizardPage.this.handleProjectChange();
                }
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createEntitiesEditor(Composite parent) {
        this.selectEntitiesLabel = new Label(parent, 0);
        this.selectEntitiesLabel.setText(this.getEntitiesLabelText());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.selectEntitiesLabel.setLayoutData((Object)gridData);
        this.selectEntitiesTable = new Table(parent, 2848);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.selectEntitiesTable.setLayoutData((Object)gridData);
        this.selectEntitiesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem source = (TableItem)e.item;
                    if (source.getChecked()) {
                        ScaffoldProjectWizardPage.this.entityNames.add((String)source.getData());
                    } else {
                        ScaffoldProjectWizardPage.this.entityNames.remove((String)source.getData());
                    }
                }
            }
        });
        Button selectAllButton = new Button(parent, 8);
        selectAllButton.setText("Select All");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaffoldProjectWizardPage.this.entityNames.clear();
                TableItem[] tableItemArray = ScaffoldProjectWizardPage.this.selectEntitiesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(true);
                    ScaffoldProjectWizardPage.this.entityNames.add((String)tableItem.getData());
                    ++n2;
                }
            }
        });
        Button selectNoneButton = new Button(parent, 8);
        selectNoneButton.setText("Select None");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        selectNoneButton.setLayoutData((Object)gridData);
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaffoldProjectWizardPage.this.entityNames.clear();
                TableItem[] tableItemArray = ScaffoldProjectWizardPage.this.selectEntitiesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(false);
                    ++n2;
                }
            }
        });
        this.getWizardDescriptor().put(ENTITY_NAMES, this.entityNames);
        this.refreshEntitiesTable();
    }

    private void refreshEntitiesTable() {
        if (this.selectEntitiesTable == null) {
            return;
        }
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName == null) {
            return;
        }
        this.selectEntitiesTable.removeAll();
        IProject project = this.getProject(projectName);
        JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
        Iterable iterable = jpaProject.getAnnotatedJavaSourceTypes();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            TableItem tableItem = new TableItem(this.selectEntitiesTable, 0);
            JavaResourceAbstractType jrat = (JavaResourceAbstractType)iterator.next();
            String qualifiedName = jrat.getTypeBinding().getQualifiedName();
            tableItem.setData((Object)jrat.getFile().getLocation().toOSString());
            tableItem.setText(qualifiedName);
        }
    }

    private String getEntitiesLabelText() {
        String labelText = "Select entities";
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName != null) {
            labelText = String.valueOf(labelText) + " for project '" + projectName + "'";
        }
        labelText = String.valueOf(labelText) + " :";
        return labelText;
    }

    private void refreshEntitiesLabel() {
        if (this.selectEntitiesLabel == null) {
            return;
        }
        this.selectEntitiesLabel.setText(this.getEntitiesLabelText());
    }

    private void handleProjectChange() {
        this.getWizardDescriptor().put(PROJECT_NAME, this.projectNameCombo.getText());
        if (this.getWizardDescriptor().get(SCAFFOLD_TYPE) != null) {
            ((ScaffoldWizard)this.getWizard()).checkIfSetupNeeded();
        }
        this.refreshEntitiesTable();
        this.refreshEntitiesLabel();
    }

    private void handleScaffoldTypeChange() {
        this.getWizardDescriptor().put(SCAFFOLD_TYPE, this.scaffoldTypeCombo.getText());
        if (this.getWizardDescriptor().get(PROJECT_NAME) != null) {
            ((ScaffoldWizard)this.getWizard()).checkIfSetupNeeded();
        }
        this.refreshEntitiesTable();
        this.refreshEntitiesLabel();
    }

    public boolean isPageComplete() {
        boolean nameComplete;
        String projectName = this.projectNameCombo.getText();
        boolean busy = ((ScaffoldWizard)this.getWizard()).isBusy();
        boolean bl = nameComplete = projectName != null && !"".equals(projectName);
        return nameComplete && !busy;
    }

    void updatePageComplete() {
        this.setPageComplete(this.isPageComplete());
    }
}

