/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.db.generic.ui.wizard.NewJDBCFilteredCPWizard;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.jboss.tools.forge.ui.wizards.internal.WizardsPlugin;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.project.NewProjectWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.ConnectionProfileDescriptor;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.DataToolsConnectionProfileHelper;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.HibernateDialect;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class GenerateEntitiesWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "GenerateEntitiesWizardPage.projectName";
    static final String ENTITY_PACKAGE = "GenerateEntitiesWizardPage.entityPackage";
    static final String CONNECTION_PROFILE = "GenerateEntitiesWizardPage.connectionProfile";
    private HashMap<String, ConnectionProfileDescriptor> connectionProfiles = new HashMap();
    private DataToolsConnectionProfileHelper connectionProfileHelper = new DataToolsConnectionProfileHelper(this);
    private Combo projectNameCombo;
    private Combo connectionProfileCombo;
    private Combo hibernateDialectCombo;
    private Text entityPackageText;
    private Text urlText;
    private Text userNameText;
    private Text userPasswordText;
    private Text driverNameText;
    private Text driverLocationText;
    private Button saveButton;
    private Button revertButton;
    private Button browsePackageButton;
    private Button browseDriverClassButton;
    private Button browseDriverLocationButton;
    private boolean updatingConnectionProfileDetails = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GenerateEntitiesWizardPage.this.updatingConnectionProfileDetails) {
                return;
            }
            Widget widget = e.widget;
            if (widget == GenerateEntitiesWizardPage.this.urlText) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().url = GenerateEntitiesWizardPage.this.urlText.getText();
            } else if (widget == GenerateEntitiesWizardPage.this.userNameText) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().user = GenerateEntitiesWizardPage.this.userNameText.getText();
            } else if (widget == GenerateEntitiesWizardPage.this.userPasswordText) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().password = GenerateEntitiesWizardPage.this.userPasswordText.getText();
            } else if (widget == GenerateEntitiesWizardPage.this.driverNameText) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().driverClass = GenerateEntitiesWizardPage.this.driverNameText.getText();
            } else if (widget == GenerateEntitiesWizardPage.this.driverLocationText) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().driverLocation = GenerateEntitiesWizardPage.this.driverLocationText.getText();
                GenerateEntitiesWizardPage.this.updateBrowseDriverClassButton();
            } else if (widget == GenerateEntitiesWizardPage.this.hibernateDialectCombo) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().dialect = GenerateEntitiesWizardPage.this.hibernateDialectCombo.getText();
            }
            GenerateEntitiesWizardPage.this.enableButtons(true);
        }
    };

    protected GenerateEntitiesWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.generate.entities", "Generate Entities", null);
    }

    public void createControl(Composite parent) {
        this.getShell().setSize(this.getShell().computeSize(500, this.getShellHeight(), true));
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createEntityPackageEditor(control);
        this.createConnectionProfileEditor(control);
        this.createConnectionProfileDetailsEditor(control);
        this.setControl((Control)control);
    }

    private int getShellHeight() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("linux") >= 0 ? 660 : 570;
    }

    private void createProjectEditor(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("JPA Project: ");
        this.projectNameCombo = new Combo(parent, 12);
        this.projectNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        this.updateProjectComboBox(projectName);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.getWizardDescriptor().put(GenerateEntitiesWizardPage.PROJECT_NAME, GenerateEntitiesWizardPage.this.projectNameCombo.getText());
                GenerateEntitiesWizardPage.this.updateEntityPackageText();
                GenerateEntitiesWizardPage.this.browsePackageButton.setEnabled(GenerateEntitiesWizardPage.this.isProjectSelected());
            }
        });
        Button newProjectButton = new Button(parent, 0);
        newProjectButton.setText("New...");
        newProjectButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        newProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.openNewProjectWizard();
            }
        });
    }

    private void openNewProjectWizard() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenerateEntitiesWizardPage.this.updateProjectComboBox((String)evt.getNewValue());
            }
        };
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new NewProjectWizard(listener));
        dialog.open();
    }

    private void updateProjectComboBox(String selectedProjectName) {
        IProject[] allProjects;
        String currentSelection = this.projectNameCombo.getText();
        this.projectNameCombo.removeAll();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WizardsHelper.isJPAProject(project)) {
                String name = project.getName();
                this.projectNameCombo.add(name);
                if (name.equals(selectedProjectName)) {
                    this.projectNameCombo.setText(name);
                    this.getWizardDescriptor().put(PROJECT_NAME, name);
                    this.updateEntityPackageText();
                    return;
                }
            }
            ++n2;
        }
        this.projectNameCombo.setText(currentSelection);
    }

    private void updateEntityPackageText() {
        if (this.entityPackageText == null) {
            return;
        }
        try {
            String projectName = this.projectNameCombo.getText();
            if (projectName == null || "".equals(projectName)) {
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return;
            }
            File pomFile = project.getFile("pom.xml").getLocation().toFile();
            Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
            String entityPackage = String.valueOf(model.getGroupId()) + ".model";
            this.entityPackageText.setText(entityPackage);
            this.getWizardDescriptor().put(ENTITY_PACKAGE, entityPackage);
        }
        catch (CoreException e) {
            WizardsPlugin.log(e);
        }
    }

    private void createEntityPackageEditor(Composite parent) {
        Label entityPackageLabel = new Label(parent, 0);
        entityPackageLabel.setText("Entity Package: ");
        this.entityPackageText = new Text(parent, 2048);
        this.entityPackageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.entityPackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GenerateEntitiesWizardPage.this.getWizardDescriptor().put(GenerateEntitiesWizardPage.ENTITY_PACKAGE, GenerateEntitiesWizardPage.this.entityPackageText.getText());
            }
        });
        this.updateEntityPackageText();
        this.browsePackageButton = new Button(parent, 0);
        this.browsePackageButton.setText("Browse...");
        this.browsePackageButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.browsePackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GenerateEntitiesWizardPage.this.selectEntityPackage();
            }
        });
        this.browsePackageButton.setEnabled(this.isProjectSelected());
    }

    private boolean isProjectSelected() {
        String projectName = this.projectNameCombo.getText();
        return projectName != null && !"".equals(projectName);
    }

    private List<IPackageFragment> getPackageFragments() {
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        try {
            String projectName = this.projectNameCombo.getText();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    IJavaElement[] iJavaElementArray = root.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement javaElement = iJavaElementArray[n4];
                        this.addPackageFragments(javaElement, result);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            WizardsPlugin.log(e);
        }
        return result;
    }

    private void addPackageFragments(IJavaElement javaElement, List<IPackageFragment> list) throws JavaModelException {
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            if (!packageFragment.isDefaultPackage()) {
                list.add(packageFragment);
            }
            IJavaElement[] iJavaElementArray = packageFragment.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.addPackageFragments(child, list);
                ++n2;
            }
        }
    }

    private void selectEntityPackage() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setTitle("Package Selection");
        dialog.setMessage("Select a package.");
        dialog.setElements(this.getPackageFragments().toArray());
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPackageFragment) {
            IPackageFragment result = (IPackageFragment)results[0];
            this.entityPackageText.setText(result.getElementName());
        }
    }

    private void createConnectionProfileEditor(Composite parent) {
        Label connectionProfileLabel = new Label(parent, 0);
        connectionProfileLabel.setText("Connection Profile Name: ");
        this.connectionProfileCombo = new Combo(parent, 12);
        this.connectionProfileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connectionProfileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.updateConnectionProfileDetails();
                GenerateEntitiesWizardPage.this.getWizardDescriptor().put(GenerateEntitiesWizardPage.CONNECTION_PROFILE, GenerateEntitiesWizardPage.this.getSelectedConnectionProfile());
            }
        });
        Button connectionProfileButton = new Button(parent, 0);
        connectionProfileButton.setText("New...");
        connectionProfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewJDBCFilteredCPWizard wizard = new NewJDBCFilteredCPWizard();
                WizardDialog wizardDialog = new WizardDialog(GenerateEntitiesWizardPage.this.getShell(), (IWizard)wizard);
                wizardDialog.setHelpAvailable(false);
                wizardDialog.open();
                GenerateEntitiesWizardPage.this.connectionProfileHelper.retrieveConnectionProfiles();
            }
        });
        connectionProfileButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connectionProfileHelper.retrieveConnectionProfiles();
        this.connectionProfileCombo.setText("");
        this.getWizardDescriptor().put(CONNECTION_PROFILE, this.getSelectedConnectionProfile());
    }

    void refreshConnectionProfiles(ConnectionProfileDescriptor[] newConnectionProfiles) {
        Set oldConnectionProfileNames = ((HashMap)this.connectionProfiles.clone()).keySet();
        String newConnectionProfileName = null;
        this.connectionProfiles.clear();
        this.connectionProfileCombo.removeAll();
        ConnectionProfileDescriptor[] connectionProfileDescriptorArray = newConnectionProfiles;
        int n = newConnectionProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionProfileDescriptor connectionProfile = connectionProfileDescriptorArray[n2];
            this.connectionProfileCombo.add(connectionProfile.name);
            this.connectionProfiles.put(connectionProfile.name, connectionProfile);
            if (!oldConnectionProfileNames.contains(connectionProfile.name)) {
                newConnectionProfileName = connectionProfile.name;
            }
            if (newConnectionProfileName != null && this.isConnectionDetailsControlCreated()) {
                this.connectionProfileCombo.setText(newConnectionProfileName);
                this.updateConnectionProfileDetails();
                this.getWizardDescriptor().put(CONNECTION_PROFILE, this.getSelectedConnectionProfile());
            }
            ++n2;
        }
    }

    private boolean isConnectionDetailsControlCreated() {
        return this.urlText != null;
    }

    private void createConnectionProfileDetailsEditor(Composite parent) {
        Label connectionProfileDetailsLabel = new Label(parent, 0);
        connectionProfileDetailsLabel.setText("Connection Profile Details: ");
        connectionProfileDetailsLabel.setLayoutData((Object)new GridData(4, 1024, true, false, 2, -1));
        Combo dummyCombo = new Combo(parent, 12);
        dummyCombo.setVisible(false);
        Group group = new Group(parent, -1);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, -1));
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = -2;
        group.setLayout((Layout)groupLayout);
        this.createUrlEditor((Composite)group);
        this.createUserNameEditor((Composite)group);
        this.createPasswordEditor((Composite)group);
        this.createHibernateDialectEditor((Composite)group);
        this.createDriverLocationEditor((Composite)group);
        this.createDriverNameEditor((Composite)group);
        this.createUpdateRestoreComposite((Composite)group);
        this.updateConnectionProfileDetails();
    }

    private void createUrlEditor(Composite parent) {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setText("URL: ");
        this.urlText = new Text(parent, 2048);
        this.urlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GenerateEntitiesWizardPage.this.updatingConnectionProfileDetails) {
                    return;
                }
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().url = GenerateEntitiesWizardPage.this.urlText.getText();
                GenerateEntitiesWizardPage.this.enableButtons(true);
            }
        });
        Button dummyButton = new Button(parent, 0);
        dummyButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        dummyButton.setVisible(false);
    }

    private void createUserNameEditor(Composite parent) {
        Label userNameLabel = new Label(parent, 0);
        userNameLabel.setText("User Name: ");
        this.userNameText = new Text(parent, 2048);
        this.userNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GenerateEntitiesWizardPage.this.updatingConnectionProfileDetails) {
                    return;
                }
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().user = GenerateEntitiesWizardPage.this.userNameText.getText();
                GenerateEntitiesWizardPage.this.enableButtons(true);
            }
        });
        Button dummyButton = new Button(parent, 0);
        dummyButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        dummyButton.setVisible(false);
    }

    private void createPasswordEditor(Composite parent) {
        Label userPasswordLabel = new Label(parent, 0);
        userPasswordLabel.setText("User Password: ");
        this.userPasswordText = new Text(parent, 0x400800);
        this.userPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userPasswordText.addModifyListener(this.modifyListener);
        Button dummyButton = new Button(parent, 0);
        dummyButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        dummyButton.setVisible(false);
    }

    private void createHibernateDialectEditor(Composite parent) {
        Label hibernateDialectLabel = new Label(parent, 0);
        hibernateDialectLabel.setText("Hibernate Dialect: ");
        this.hibernateDialectCombo = new Combo(parent, 4);
        this.hibernateDialectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillHibernateDialectCombo();
        this.hibernateDialectCombo.addModifyListener(this.modifyListener);
        this.hibernateDialectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((GenerateEntitiesWizardPage)GenerateEntitiesWizardPage.this).getSelectedConnectionProfile().dialect = GenerateEntitiesWizardPage.this.hibernateDialectCombo.getText();
                GenerateEntitiesWizardPage.this.enableButtons(true);
            }
        });
        Button dummyButton = new Button(parent, 0);
        dummyButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        dummyButton.setVisible(false);
    }

    private void fillHibernateDialectCombo() {
        HibernateDialect[] hibernateDialectArray = HibernateDialect.values();
        int n = hibernateDialectArray.length;
        int n2 = 0;
        while (n2 < n) {
            HibernateDialect hibernateDialect = hibernateDialectArray[n2];
            this.hibernateDialectCombo.add(hibernateDialect.getClassName());
            ++n2;
        }
    }

    private void createDriverNameEditor(Composite parent) {
        Label driverNameLabel = new Label(parent, 0);
        driverNameLabel.setText("Driver Class: ");
        this.driverNameText = new Text(parent, 2048);
        this.driverNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.driverNameText.addModifyListener(this.modifyListener);
        this.browseDriverClassButton = new Button(parent, 0);
        this.browseDriverClassButton.setText("Browse...");
        this.browseDriverClassButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.browseDriverClassButton.setEnabled(false);
        this.browseDriverClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.browseForDriverClass();
            }
        });
    }

    private void browseForDriverClass() {
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                WizardsPlugin plugin = WizardsPlugin.getDefault();
                ImageRegistry registry = plugin.getImageRegistry();
                Image image = registry.get("WizardsPlugin.classIcon");
                return image;
            }

            public String getText(Object element) {
                return ((Class)element).getName();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Driver Selection");
        dialog.setMessage("Select a driver.");
        dialog.setElements((Object[])this.getDriverClasses());
        if (dialog.open() == 0) {
            Class selectedDriver = (Class)dialog.getFirstResult();
            this.driverNameText.setText(selectedDriver.getName());
        }
    }

    private Class<?>[] getDriverClasses() {
        ArrayList result = new ArrayList();
        try {
            File file = new File(this.driverLocationText.getText());
            URL[] urls = new URL[]{file.toURI().toURL()};
            URLClassLoader classLoader = URLClassLoader.newInstance(urls);
            Class<?> driverClass = classLoader.loadClass(Driver.class.getName());
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> iter = jarFile.entries();
            while (iter.hasMoreElements()) {
                JarEntry entry = iter.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String name = entry.getName();
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                try {
                    Class<?> clazz = classLoader.loadClass(name);
                    if (!driverClass.isAssignableFrom(clazz)) continue;
                    result.add(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
            jarFile.close();
        }
        catch (Exception exception) {}
        return result.toArray(new Class[result.size()]);
    }

    private void createDriverLocationEditor(Composite parent) {
        Label driverLocationLabel = new Label(parent, 0);
        driverLocationLabel.setText("Driver Location: ");
        this.driverLocationText = new Text(parent, 2048);
        this.driverLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.driverLocationText.addModifyListener(this.modifyListener);
        this.browseDriverLocationButton = new Button(parent, 0);
        this.browseDriverLocationButton.setText("Browse...");
        this.browseDriverLocationButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.browseDriverLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateEntitiesWizardPage.this.browseForDriverLocation();
            }
        });
    }

    private void browseForDriverLocation() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.open();
        String fileName = dialog.getFileName();
        String path = dialog.getFilterPath();
        if (fileName != null && path != null) {
            this.driverLocationText.setText(String.valueOf(path) + File.separator + fileName);
        }
    }

    private void createUpdateRestoreComposite(Composite parent) {
        Composite updateRestoreComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginTop = 5;
        updateRestoreComposite.setLayout((Layout)layout);
        this.saveButton = new Button(updateRestoreComposite, 0);
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionProfileDescriptor connectionProfile = GenerateEntitiesWizardPage.this.getSelectedConnectionProfile();
                if (connectionProfile.name == null || "".equals(connectionProfile.name)) {
                    InputDialog dialog = new InputDialog(GenerateEntitiesWizardPage.this.getShell(), "Connection Profile", "Please enter a name for the connection profile.", "connection profile", null);
                    if (dialog.open() != 1) {
                        connectionProfile.name = dialog.getValue();
                        GenerateEntitiesWizardPage.this.connectionProfiles.put(connectionProfile.name, connectionProfile);
                        GenerateEntitiesWizardPage.this.connectionProfiles.put("", new ConnectionProfileDescriptor());
                    } else {
                        return;
                    }
                }
                GenerateEntitiesWizardPage.this.connectionProfileHelper.saveConnectionProfile(connectionProfile);
                GenerateEntitiesWizardPage.this.refreshConnectionProfiles(GenerateEntitiesWizardPage.this.connectionProfiles.values().toArray(new ConnectionProfileDescriptor[GenerateEntitiesWizardPage.this.connectionProfiles.size()]));
                GenerateEntitiesWizardPage.this.connectionProfileCombo.setText(connectionProfile.name);
                GenerateEntitiesWizardPage.this.enableButtons(false);
            }
        });
        this.saveButton.setLayoutData((Object)new GridData(4, -1, true, false));
        this.revertButton = new Button(updateRestoreComposite, 0);
        this.revertButton.setText("Revert");
        this.revertButton.setEnabled(false);
        this.revertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = GenerateEntitiesWizardPage.this.connectionProfileCombo.getText();
                if (name != null && !"".equals(name)) {
                    GenerateEntitiesWizardPage.this.connectionProfileHelper.revertConnectionProfile(GenerateEntitiesWizardPage.this.getSelectedConnectionProfile());
                    GenerateEntitiesWizardPage.this.enableButtons(false);
                }
            }
        });
        this.revertButton.setLayoutData((Object)new GridData(4, -1, true, false));
        updateRestoreComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, -1));
    }

    void updateConnectionProfileDetails() {
        this.updatingConnectionProfileDetails = true;
        ConnectionProfileDescriptor selectedConnectionProfile = this.getSelectedConnectionProfile();
        String url = selectedConnectionProfile.url;
        url = url == null ? "" : url;
        this.urlText.setText(url);
        String user = selectedConnectionProfile.user;
        user = user == null ? "" : user;
        this.userNameText.setText(user);
        String password = selectedConnectionProfile.password;
        password = password == null ? "" : password;
        String driverClassName = selectedConnectionProfile.driverClass;
        this.userPasswordText.setText(password);
        driverClassName = driverClassName == null ? "" : driverClassName;
        this.driverNameText.setText(driverClassName);
        String hibernateDialect = selectedConnectionProfile.dialect;
        hibernateDialect = hibernateDialect == null ? "" : hibernateDialect;
        this.hibernateDialectCombo.setText(hibernateDialect);
        String driverLocation = selectedConnectionProfile.driverLocation;
        driverLocation = driverLocation == null ? "" : driverLocation;
        this.driverLocationText.setText(driverLocation);
        this.updatingConnectionProfileDetails = false;
    }

    private void enableButtons(boolean enabled) {
        this.saveButton.setEnabled(enabled);
        this.revertButton.setEnabled(enabled);
    }

    private ConnectionProfileDescriptor getSelectedConnectionProfile() {
        return this.connectionProfiles.get(this.connectionProfileCombo.getText());
    }

    private void updateBrowseDriverClassButton() {
        File file;
        String driverLocation = this.driverLocationText.getText();
        if (driverLocation != null && (file = new File(driverLocation)).exists()) {
            this.browseDriverClassButton.setEnabled(true);
            return;
        }
        this.browseDriverClassButton.setEnabled(false);
    }
}

