/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.reveng;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.ConnectionProfileDescriptor;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.GenerateEntitiesWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.HibernateToolsInstaller;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class GenerateEntitiesWizard
extends AbstractForgeWizard {
    private GenerateEntitiesWizardPage generateEntitiesWizardPage = new GenerateEntitiesWizardPage();
    String prompt = null;
    String promptNoProject = null;

    public GenerateEntitiesWizard() {
        this.setWindowTitle("Generate Entities");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.doInit(workbench, sel);
    }

    private void doInit(IWorkbench workbench, IStructuredSelection sel) {
        this.initializeProject(sel);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (!GenerateEntitiesWizard.this.isHibernateToolsPluginAvailable()) {
                    new HibernateToolsInstaller().install(GenerateEntitiesWizard.this.getShell(), GenerateEntitiesWizard.this.getRuntime());
                }
            }
        };
        new Thread(runner).start();
    }

    private boolean isHibernateToolsPluginAvailable() {
        String str = this.getRuntime().sendCommand("forge list-plugins");
        return str != null && str.contains("org.jboss.hibernate.forge.hibernate-tools-plugin");
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || !WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("GenerateEntitiesWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.generateEntitiesWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        String entityPackage;
        this.sendRuntimeCommand("cd " + this.getProjectLocation(), monitor);
        String generateCommand = "generate-entities --url " + this.getConnectionProfile().url + " --user " + this.getConnectionProfile().user + " --dialect " + this.getConnectionProfile().dialect + " --driver " + this.getConnectionProfile().driverClass + " --pathToDriver " + this.getConnectionProfile().driverLocation;
        if (this.getConnectionProfile().password != null && !"".equals(this.getConnectionProfile().password)) {
            generateCommand = String.valueOf(generateCommand) + " --password " + this.getConnectionProfile().password;
        }
        if ((entityPackage = (String)this.getWizardDescriptor().get("GenerateEntitiesWizardPage.entityPackage")) != null && !"".equals(entityPackage)) {
            generateCommand = String.valueOf(generateCommand) + " --entityPackage " + entityPackage;
        }
        this.sendRuntimeCommand(generateCommand, monitor);
    }

    @Override
    protected int getAmountOfWorkExecute() {
        return 2;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        IProject project = this.getProject(this.getProjectName());
        this.refreshResource((IResource)project, monitor);
        this.updateProjectConfiguration(project, monitor);
    }

    @Override
    protected int getAmountOfWorkRefresh() {
        return 2;
    }

    @Override
    public String getStatusMessage() {
        return "Generating entities for project '" + this.getProjectName() + "'.";
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("GenerateEntitiesWizardPage.projectName");
    }

    private ConnectionProfileDescriptor getConnectionProfile() {
        return (ConnectionProfileDescriptor)this.getWizardDescriptor().get("GenerateEntitiesWizardPage.connectionProfile");
    }

    private String getProjectLocation() {
        return this.getProject(this.getProjectName()).getLocation().toOSString();
    }
}

