/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.reveng;

import java.util.ArrayList;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.ConnectionProfileDescriptor;
import org.jboss.tools.forge.ui.wizards.internal.wizard.reveng.GenerateEntitiesWizardPage;

public class ForgeConnectionProfileHelper {
    private static final String CONNECTION_PROFILE = "Connection profile \"";
    private static final String DIALECT = "dialect:";
    private static final String DRIVER_CLASS = "driver class:";
    private static final String DRIVER_LOCATION = "driver location:";
    private static final String URL = "url:";
    private static final String USER = "user:";
    private GenerateEntitiesWizardPage wizardPage;

    ForgeConnectionProfileHelper(GenerateEntitiesWizardPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    boolean retrieveConnectionProfiles(final ForgeRuntime runtime) {
        WorkspaceJob job = new WorkspaceJob("Retrieving connection profiles"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                String rawString = runtime.sendCommand("connection-profiles list");
                ForgeConnectionProfileHelper.this.refreshConnectionProfiles(ForgeConnectionProfileHelper.this.getConnectionProfiles(rawString));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return true;
    }

    private void refreshConnectionProfiles(final ConnectionProfileDescriptor[] connectionProfiles) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ForgeConnectionProfileHelper.this.wizardPage.refreshConnectionProfiles(connectionProfiles);
            }
        });
    }

    private ConnectionProfileDescriptor[] getConnectionProfiles(String raw) {
        ArrayList<ConnectionProfileDescriptor> result = new ArrayList<ConnectionProfileDescriptor>();
        int start = -1;
        int end = raw.indexOf(CONNECTION_PROFILE);
        while (end < raw.length()) {
            start = end;
            end = (end = raw.indexOf(CONNECTION_PROFILE, start + CONNECTION_PROFILE.length())) == -1 ? raw.length() : end;
            result.add(this.parseConnectionProfile(raw.substring(start, end).trim()));
        }
        ConnectionProfileDescriptor unnamed = new ConnectionProfileDescriptor();
        unnamed.name = "";
        result.add(unnamed);
        return result.toArray(new ConnectionProfileDescriptor[result.size()]);
    }

    private ConnectionProfileDescriptor parseConnectionProfile(String raw) {
        ConnectionProfileDescriptor result = new ConnectionProfileDescriptor();
        String lineSeparator = System.getProperty("line.separator");
        int start = 0;
        int end = -1;
        start = raw.indexOf(CONNECTION_PROFILE) + CONNECTION_PROFILE.length();
        end = raw.indexOf("\":", start);
        result.name = raw.substring(start, end);
        start = raw.indexOf(DIALECT, end) + DIALECT.length();
        end = raw.indexOf(lineSeparator, start);
        result.dialect = raw.substring(start, end).trim();
        start = raw.indexOf(DRIVER_CLASS, end) + DRIVER_CLASS.length();
        end = raw.indexOf(lineSeparator, start);
        result.driverClass = raw.substring(start, end).trim();
        start = raw.indexOf(DRIVER_LOCATION, end) + DRIVER_LOCATION.length();
        end = raw.indexOf(lineSeparator, start);
        result.driverLocation = raw.substring(start, end).trim();
        start = raw.indexOf(URL, end) + URL.length();
        end = raw.indexOf(lineSeparator, start);
        result.url = raw.substring(start, end).trim();
        start = raw.indexOf(USER, end) + USER.length();
        end = (end = raw.indexOf(lineSeparator, start)) == -1 ? raw.length() : end;
        result.user = raw.substring(start, end).trim();
        return result;
    }
}

