/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.rest;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.rest.RestSetupHelper;
import org.jboss.tools.forge.ui.wizards.internal.wizard.rest.RestWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class RestWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "RestWizardPage.projectName";
    static final String ENTITY_NAMES = "RestWizardPage.entityNames";
    static final String SETUP_NEEDED = "RestWizardPage.setupNeeded";
    static final String ACTIVATOR_TYPE = "RestWizardPage.activatorType";
    static final String CONTENT_TYPE = "RestWizardPage.contentType";
    static final String ACTIVATOR_TYPE_WEB_XML = "WEB_XML";
    static final String ACTIVATOR_TYPE_APPLICATION_CLASS = "APP_CLASS";
    static final String ACTIVATOR_TYPE_NONE = "";
    static final String CONTENT_TYPE_XML = "application/xml";
    static final String CONTENT_TYPE_JSON = "application/json";
    static final String PAGE_NAME = "org.jboss.tools.forge.ui.wizard.rest";
    private ArrayList<String> entityNames = new ArrayList();
    private Combo projectNameCombo;
    private Combo activatorTypeCombo;
    private Combo contentTypeCombo;
    private Table selectEntitiesTable;
    private boolean busy = false;

    protected RestWizardPage() {
        super(PAGE_NAME, "Generate REST Endpoints", null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createActivatorTypeEditor(control);
        this.createContentTypeEditor(control);
        this.createEntitiesEditor(control);
        this.setControl((Control)control);
        this.initializeEditors();
    }

    private void initializeEditors() {
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName != null) {
            this.projectNameCombo.setText(projectName);
            this.handleProjectChange();
        }
    }

    private void createContentTypeEditor(Composite parent) {
        Label contentTypeLabel = new Label(parent, 0);
        contentTypeLabel.setText("Content type:");
        this.contentTypeCombo = new Combo(parent, 12);
        this.contentTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.contentTypeCombo.add(CONTENT_TYPE_JSON);
        this.contentTypeCombo.add(CONTENT_TYPE_XML);
        this.contentTypeCombo.setText(CONTENT_TYPE_JSON);
        this.getWizardDescriptor().put(CONTENT_TYPE, CONTENT_TYPE_JSON);
        this.contentTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RestWizardPage.this.getWizardDescriptor().put(RestWizardPage.CONTENT_TYPE, RestWizardPage.this.contentTypeCombo.getText());
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText(ACTIVATOR_TYPE_NONE);
    }

    private void createProjectEditor(Composite parent) {
        IProject[] allProjects;
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project: ");
        this.projectNameCombo = new Combo(parent, 12);
        this.projectNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WizardsHelper.isJPAProject(project)) {
                this.projectNameCombo.add(project.getName());
            }
            ++n2;
        }
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newProjectName = RestWizardPage.this.projectNameCombo.getText();
                String oldProjectName = (String)RestWizardPage.this.getWizardDescriptor().get(RestWizardPage.PROJECT_NAME);
                if (oldProjectName == null && newProjectName != null || !oldProjectName.equals(newProjectName)) {
                    RestWizardPage.this.handleProjectChange();
                }
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText(ACTIVATOR_TYPE_NONE);
    }

    private void createActivatorTypeEditor(Composite parent) {
        Label activatorTypeLabel = new Label(parent, 0);
        activatorTypeLabel.setText("Activator type:");
        this.activatorTypeCombo = new Combo(parent, 12);
        this.activatorTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.activatorTypeCombo.add(ACTIVATOR_TYPE_WEB_XML);
        this.activatorTypeCombo.add(ACTIVATOR_TYPE_APPLICATION_CLASS);
        this.activatorTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RestWizardPage.this.getWizardDescriptor().put(RestWizardPage.ACTIVATOR_TYPE, RestWizardPage.this.activatorTypeCombo.getText());
            }
        });
        this.activatorTypeCombo.setEnabled(false);
        Label filler = new Label(parent, 0);
        filler.setText(ACTIVATOR_TYPE_NONE);
    }

    private void createEntitiesEditor(Composite parent) {
        Label selectEntitiesLabel = new Label(parent, 0);
        selectEntitiesLabel.setText("Select entities:");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        selectEntitiesLabel.setLayoutData((Object)gridData);
        this.selectEntitiesTable = new Table(parent, 2848);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.selectEntitiesTable.setLayoutData((Object)gridData);
        this.selectEntitiesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem source = (TableItem)e.item;
                    if (source.getChecked()) {
                        RestWizardPage.this.entityNames.add(source.getText());
                    } else {
                        RestWizardPage.this.entityNames.remove(source.getText());
                    }
                }
            }
        });
        Button selectAllButton = new Button(parent, 8);
        selectAllButton.setText("Select All");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestWizardPage.this.entityNames.clear();
                TableItem[] tableItemArray = RestWizardPage.this.selectEntitiesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(true);
                    RestWizardPage.this.entityNames.add(tableItem.getText());
                    ++n2;
                }
            }
        });
        Button selectNoneButton = new Button(parent, 8);
        selectNoneButton.setText("Select None");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        selectNoneButton.setLayoutData((Object)gridData);
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestWizardPage.this.entityNames.clear();
                TableItem[] tableItemArray = RestWizardPage.this.selectEntitiesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(false);
                    ++n2;
                }
            }
        });
        this.getWizardDescriptor().put(ENTITY_NAMES, this.entityNames);
        this.refreshEntitiesTable();
    }

    private void refreshEntitiesTable() {
        if (this.selectEntitiesTable == null) {
            return;
        }
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName == null) {
            return;
        }
        this.selectEntitiesTable.removeAll();
        IProject project = this.getProject(projectName);
        JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
        Iterable iterable = jpaProject.getAnnotatedJavaSourceTypes();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            TableItem tableItem = new TableItem(this.selectEntitiesTable, 0);
            JavaResourceAbstractType jrat = (JavaResourceAbstractType)iterator.next();
            String qualifiedName = jrat.getTypeBinding().getQualifiedName();
            tableItem.setData((Object)jrat.getFile().getLocation().toOSString());
            tableItem.setText(qualifiedName);
        }
    }

    private void handleProjectChange() {
        this.activatorTypeCombo.setEnabled(false);
        this.getWizardDescriptor().put(PROJECT_NAME, this.projectNameCombo.getText());
        this.setBusy(true);
        this.updatePageComplete();
        this.checkRestSetup();
        this.refreshEntitiesTable();
    }

    private void checkRestSetup() {
        new RestSetupHelper((RestWizard)this.getWizard()).checkRestSetup(this.getWizard().getRuntime());
    }

    void setSetupNeeded(boolean b) {
        this.getWizardDescriptor().put(SETUP_NEEDED, b);
        this.activatorTypeCombo.setEnabled(b);
    }

    void setActivatorType(String activatorType) {
        if (activatorType.equals(ACTIVATOR_TYPE_NONE)) {
            this.getWizardDescriptor().put(ACTIVATOR_TYPE, null);
            this.activatorTypeCombo.deselectAll();
        } else {
            this.getWizardDescriptor().put(ACTIVATOR_TYPE, activatorType);
            this.activatorTypeCombo.setText(activatorType);
        }
    }

    void setBusy(boolean b) {
        this.busy = b;
        this.updatePageComplete();
    }

    public boolean isPageComplete() {
        boolean nameComplete;
        String projectName = this.projectNameCombo.getText();
        boolean bl = nameComplete = projectName != null && !ACTIVATOR_TYPE_NONE.equals(projectName);
        return nameComplete && !this.busy;
    }

    void updatePageComplete() {
        this.setPageComplete(this.isPageComplete());
    }
}

