/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.rest;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.rest.RestWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class RestWizard
extends AbstractForgeWizard {
    private RestWizardPage restWizardPage = new RestWizardPage();

    public RestWizard() {
        this.setWindowTitle("Generate REST Endpoints");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.initializeProject(sel);
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || !WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("RestWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.restWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.sendRuntimeCommand("cd " + this.getProjectLocation(), monitor);
        if (this.getSetupNeeded()) {
            String activatorType = (String)this.getWizardDescriptor().get("RestWizardPage.activatorType");
            if (activatorType == null) {
                activatorType = "WEB_XML";
            }
            this.sendRuntimeCommand("rest setup --activatorType " + activatorType, monitor);
        }
        for (String entityName : this.getEntityNames()) {
            String command = "rest endpoint-from-entity " + entityName;
            command = String.valueOf(command) + " --contentType " + (String)this.getWizardDescriptor().get("RestWizardPage.contentType");
            command = String.valueOf(command) + " --strategy ROOT_AND_NESTED_DTO";
            this.sendRuntimeCommand(command, monitor);
        }
    }

    private boolean getSetupNeeded() {
        return (Boolean)this.getWizardDescriptor().get("RestWizardPage.setupNeeded");
    }

    @Override
    protected int getAmountOfWorkExecute() {
        int entities = this.getEntityNames().size();
        return this.getSetupNeeded() ? entities + 2 : entities + 1;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        IProject project = this.getProject(this.getProjectName());
        this.refreshResource((IResource)project, monitor);
        this.updateProjectConfiguration(project, monitor);
    }

    @Override
    protected int getAmountOfWorkRefresh() {
        return 2;
    }

    @Override
    public String getStatusMessage() {
        return "Generating REST endpoints for project '" + this.getProjectName() + "'.";
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("RestWizardPage.projectName");
    }

    private List<String> getEntityNames() {
        return (List)this.getWizardDescriptor().get("RestWizardPage.entityNames");
    }

    String getProjectLocation() {
        return this.getProject(this.getProjectName()).getLocation().toOSString();
    }
}

