/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.rest;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.wizards.internal.wizard.rest.RestWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.rest.RestWizardPage;

public class RestSetupHelper {
    private RestWizard wizard;
    private RestWizardPage wizardPage;
    private String installedFacets;
    private String currentDirectory;

    RestSetupHelper(RestWizard wizard) {
        this.wizard = wizard;
        this.wizardPage = (RestWizardPage)wizard.getPage("org.jboss.tools.forge.ui.wizard.rest");
    }

    void checkRestSetup(final ForgeRuntime runtime) {
        Job job = new Job("Setup Needed"){

            protected IStatus run(IProgressMonitor monitor) {
                RestSetupHelper.this.currentDirectory = runtime.sendCommand("pwd").trim();
                runtime.sendCommand("cd " + RestSetupHelper.this.wizard.getProjectLocation());
                RestSetupHelper.this.installedFacets = runtime.sendCommand("project list-facets");
                runtime.sendCommand("cd " + RestSetupHelper.this.currentDirectory);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean setupNeeded = true;
                        if (RestSetupHelper.this.installedFacets.contains(RestSetupHelper.this.getWebXmlString())) {
                            RestSetupHelper.this.wizardPage.setActivatorType("WEB_XML");
                            setupNeeded = false;
                        } else if (RestSetupHelper.this.installedFacets.contains(RestSetupHelper.this.getApplicationClassString())) {
                            RestSetupHelper.this.wizardPage.setActivatorType("APP_CLASS");
                            setupNeeded = false;
                        } else {
                            RestSetupHelper.this.wizardPage.setActivatorType("");
                        }
                        RestSetupHelper.this.wizardPage.setSetupNeeded(setupNeeded);
                        RestSetupHelper.this.wizardPage.setBusy(false);
                    }
                });
            }
        });
        job.schedule();
    }

    private String getWebXmlString() {
        return "+ forge.spec.jaxrs.webxml\t[org.jboss.forge.spec.javaee.rest.RestWebXmlFacetImpl]";
    }

    private String getApplicationClassString() {
        return "+ forge.spec.jaxrs.applicationclass\t[org.jboss.forge.spec.javaee.rest.RestApplicationFacetImpl]";
    }
}

