/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.project;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.persistence.ContainerType;
import org.jboss.tools.forge.ui.wizards.internal.wizard.persistence.ProviderType;
import org.jboss.tools.forge.ui.wizards.internal.wizard.project.ProjectType;

public class NewProjectWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "NewProjectWizardPage.projectName";
    static final String PROJECT_LOCATION = "NewProjectWizardPage.projectLocation";
    static final String PROJECT_TYPE = "NewProjectWizardPage.projectType";
    static final String TOP_LEVEL_PACKAGE = "NewProjectWizardPage.topLevelPackage";
    static final String PROVIDER_NAME = "NewProjectWizardPage.providerName";
    static final String CONTAINER_NAME = "NewProjectWizardPage.containerName";
    static final String SETUP_PERSISTENCE = "NewProjectWizardPage.setupPersistence";
    static final String CREATE_MAIN = "NewProjectWizardPage.createMain";
    static final String FINAL_NAME = "NewProjectWizardPage.finalName";
    private static final String DEFAULT_PROVIDER = "HIBERNATE";
    private static final String DEFAULT_CONTAINER = "JBOSS_AS7";
    private static final String INITIAL_LOCATION = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    private Button setupPersistenceButton;
    private Text projectNameText;
    private Text topLevelPackageText;
    private Text projectLocationText;
    private Combo projectTypeCombo;
    private Combo providerCombo;
    private Combo containerCombo;
    private boolean projectNameAndPackageNameAreSynchronized = true;

    protected NewProjectWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.newproject", "Create New Project", null);
        this.setDescription("This is the description: blablablah");
        this.setMessage("Enter the project name.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.createNameEditor(container);
        this.createLocationEditor(container);
        this.createTopLevelPackageEditor(container);
        this.createProjectTypeEditor(container);
        this.createSeparator(container);
        this.createMainClassEditor(container);
        this.createFinalNameEditor(container);
        this.createSeparator(container);
        this.createSetupPersistenceEditor(container);
        this.createProviderEditor(container);
        this.createContainerEditor(container);
        this.setControl((Control)container);
    }

    private void createProviderEditor(Composite parent) {
        Label providerLabel = new Label(parent, 0);
        providerLabel.setText("Provider: ");
        this.providerCombo = new Combo(parent, 4);
        this.providerCombo.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.providerCombo.setLayoutData((Object)gridData);
        this.providerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.PROVIDER_NAME, NewProjectWizardPage.this.providerCombo.getText());
            }
        });
        ProviderType[] providerTypeArray = ProviderType.values();
        int n = providerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderType type = providerTypeArray[n2];
            this.providerCombo.add(type.name());
            ++n2;
        }
        this.providerCombo.setText(DEFAULT_PROVIDER);
        this.providerCombo.setEnabled(this.setupPersistenceButton.getSelection());
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createContainerEditor(Composite parent) {
        Label containerLabel = new Label(parent, 0);
        containerLabel.setText("Container: ");
        this.containerCombo = new Combo(parent, 4);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.containerCombo.setLayoutData((Object)gridData);
        this.containerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.CONTAINER_NAME, NewProjectWizardPage.this.containerCombo.getText());
            }
        });
        ContainerType[] containerTypeArray = ContainerType.values();
        int n = containerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContainerType type = containerTypeArray[n2];
            this.containerCombo.add(type.name());
            ++n2;
        }
        this.containerCombo.setText(DEFAULT_CONTAINER);
        this.containerCombo.setEnabled(this.setupPersistenceButton.getSelection());
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
        separator.setLayoutData((Object)gridData);
    }

    private void createNameEditor(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project Name: ");
        this.projectNameText = new Text(parent, 2048);
        this.projectNameText.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 250;
        this.projectNameText.setLayoutData((Object)gridData);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardPage.this.updateProjectName();
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createLocationEditor(Composite parent) {
        Label projectLocationLabel = new Label(parent, 0);
        projectLocationLabel.setText("Project Location: ");
        this.projectLocationText = new Text(parent, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 250;
        this.projectLocationText.setLayoutData((Object)gridData);
        this.projectLocationText.setText(INITIAL_LOCATION);
        this.getWizardDescriptor().put(PROJECT_LOCATION, INITIAL_LOCATION);
        this.projectLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardPage.this.updateProjectLocation();
            }
        });
        Button projectLocationButton = new Button(parent, 0);
        projectLocationButton.setText("Browse...");
        projectLocationButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        projectLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewProjectWizardPage.this.getShell());
                dialog.setMessage("Select the destination folder where the project will be created.");
                dialog.setText("Folder Selection");
                dialog.setFilterPath((String)NewProjectWizardPage.this.getWizardDescriptor().get(NewProjectWizardPage.PROJECT_LOCATION));
                String result = dialog.open();
                if (result != null) {
                    NewProjectWizardPage.this.projectLocationText.setText(result);
                    NewProjectWizardPage.this.updateProjectLocation();
                }
            }
        });
    }

    private void updateProjectLocation() {
        String projectLocation = this.projectLocationText.getText();
        this.getWizardDescriptor().put(PROJECT_LOCATION, projectLocation);
        this.setPageComplete(this.checkPageComplete());
    }

    private void updateProjectName() {
        String projectName = this.projectNameText.getText();
        this.getWizardDescriptor().put(PROJECT_NAME, projectName);
        if (this.projectNameAndPackageNameAreSynchronized) {
            this.topLevelPackageText.setText("com.example." + projectName);
        }
        if (!this.checkProjectName()) {
            this.setErrorMessage("The project name cannot be empty.");
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.checkPageComplete());
    }

    private void createTopLevelPackageEditor(Composite parent) {
        Label topLevelPackageLabel = new Label(parent, 0);
        topLevelPackageLabel.setText("Top Level Package: ");
        this.topLevelPackageText = new Text(parent, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 250;
        this.topLevelPackageText.setLayoutData((Object)gridData);
        this.topLevelPackageText.setText(this.getInitialTopLevelPackage());
        this.topLevelPackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String topLevelPackage = NewProjectWizardPage.this.topLevelPackageText.getText();
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.TOP_LEVEL_PACKAGE, topLevelPackage);
                NewProjectWizardPage.this.setPageComplete(NewProjectWizardPage.this.checkPageComplete());
            }
        });
        this.topLevelPackageText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                NewProjectWizardPage.this.projectNameAndPackageNameAreSynchronized = false;
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private String getInitialTopLevelPackage() {
        String result = (String)this.getWizardDescriptor().get(TOP_LEVEL_PACKAGE);
        if (result == null) {
            result = "com.example";
            this.getWizardDescriptor().put(TOP_LEVEL_PACKAGE, result);
        }
        return result;
    }

    private void createProjectTypeEditor(Composite parent) {
        Label projectTypeLabel = new Label(parent, 0);
        projectTypeLabel.setText("Project Type: ");
        this.projectTypeCombo = new Combo(parent, 12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = 15;
        this.projectTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillProjectTypeCombo();
        this.projectTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectType type = ProjectType.getType(NewProjectWizardPage.this.projectTypeCombo.getText());
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.PROJECT_TYPE, type);
                NewProjectWizardPage.this.enableSetupPersistence(!ProjectType.POM.equals((Object)type) && !ProjectType.EAR.equals((Object)type));
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void enableSetupPersistence(boolean enabled) {
        this.getWizardDescriptor().put(SETUP_PERSISTENCE, enabled ? this.setupPersistenceButton.getSelection() : false);
        this.setupPersistenceButton.setEnabled(enabled);
        this.providerCombo.setEnabled(this.setupPersistenceButton.getSelection() && this.setupPersistenceButton.isEnabled());
        this.containerCombo.setEnabled(this.setupPersistenceButton.getSelection() && this.setupPersistenceButton.isEnabled());
    }

    private void fillProjectTypeCombo() {
        ProjectType[] projectTypeArray = ProjectType.values();
        int n = projectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectType type = projectTypeArray[n2];
            this.projectTypeCombo.add(type.getName());
            ++n2;
        }
        this.projectTypeCombo.setText("");
        this.getWizardDescriptor().put(PROJECT_TYPE, (Object)ProjectType.NONE);
    }

    private void createMainClassEditor(Composite parent) {
        final Button mainClassButton = new Button(parent, 32);
        mainClassButton.setText("Create a Main class for the new project");
        GridData gridData = new GridData(16384, 0x1000000, true, false, 3, 1);
        mainClassButton.setLayoutData((Object)gridData);
        mainClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.CREATE_MAIN, mainClassButton.getSelection());
            }
        });
        this.getWizardDescriptor().put(CREATE_MAIN, false);
    }

    private void createFinalNameEditor(Composite parent) {
        final Button finalNameButton = new Button(parent, 32);
        finalNameButton.setSelection(false);
        finalNameButton.setText("Final Name: ");
        final Text finalNameText = new Text(parent, 2048);
        finalNameText.setText("");
        finalNameText.setEnabled(false);
        finalNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        finalNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = finalNameButton.getSelection();
                finalNameText.setEnabled(selected);
                if (selected) {
                    NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.FINAL_NAME, finalNameText.getText());
                } else {
                    NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.FINAL_NAME, null);
                }
            }
        });
        finalNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.FINAL_NAME, finalNameText.getText());
            }
        });
        Label filler = new Label(parent, 0);
        filler.setText("");
    }

    private void createSetupPersistenceEditor(Composite parent) {
        this.setupPersistenceButton = new Button(parent, 32);
        this.setupPersistenceButton.setText("Set up persistence for the new project");
        GridData gridData = new GridData(16384, 0x1000000, true, false, 3, 1);
        this.setupPersistenceButton.setLayoutData((Object)gridData);
        this.setupPersistenceButton.setSelection(true);
        this.getWizardDescriptor().put(SETUP_PERSISTENCE, true);
        this.setupPersistenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = NewProjectWizardPage.this.setupPersistenceButton.getSelection();
                NewProjectWizardPage.this.providerCombo.setEnabled(selection);
                NewProjectWizardPage.this.containerCombo.setEnabled(selection);
                NewProjectWizardPage.this.getWizardDescriptor().put(NewProjectWizardPage.SETUP_PERSISTENCE, selection);
            }
        });
    }

    public boolean isPageComplete() {
        return this.checkProjectName() && this.checkProjectLocation() && this.checkTopLevelPackage();
    }

    private boolean checkPageComplete() {
        if (!this.checkProjectName()) {
            this.setErrorMessage("The project name cannot be empty.");
            return false;
        }
        if (!this.checkProjectLocation()) {
            this.setErrorMessage("The project location cannot be empty.");
            return false;
        }
        if (!this.checkTopLevelPackage()) {
            return false;
        }
        this.setErrorMessage(null);
        if (this.getMessageType() != 2) {
            this.setMessage("Push the Finish button to create the project.");
        }
        return true;
    }

    private boolean checkProjectName() {
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        return projectName != null && !"".equals(projectName);
    }

    private boolean checkProjectLocation() {
        String projectLocation = (String)this.getWizardDescriptor().get(PROJECT_LOCATION);
        return projectLocation != null && !"".equals(projectLocation);
    }

    private boolean checkTopLevelPackage() {
        String topLevelPackage = (String)this.getWizardDescriptor().get(TOP_LEVEL_PACKAGE);
        if (topLevelPackage == null || "".equals(topLevelPackage)) {
            this.setErrorMessage("The package name cannot be empty.");
            return false;
        }
        IStatus status = JavaConventions.validatePackageName((String)topLevelPackage, (String)"1.3", (String)"1.3");
        if (status.getSeverity() == 4) {
            this.setErrorMessage("The package name is not valid. " + status.getMessage());
            return false;
        }
        if (status.getSeverity() == 2) {
            this.setMessage("This package name is discouraged. " + status.getMessage(), 2);
        }
        return true;
    }
}

