/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.model.Model;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.forge.ui.wizards.internal.WizardsPlugin;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.project.NewProjectWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.project.ProjectType;

public class NewProjectWizard
extends AbstractForgeWizard {
    private NewProjectWizardPage newProjectWizardPage = new NewProjectWizardPage();
    private PropertyChangeListener listener;

    public NewProjectWizard(PropertyChangeListener listener) {
        this();
        this.listener = listener;
    }

    public NewProjectWizard() {
        this.setWindowTitle("Create New Project");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.newProjectWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.executeNewProject(monitor);
        if (this.needsPersistenceSetup()) {
            this.executePersistenceSetup(monitor);
        }
    }

    @Override
    protected int getAmountOfWorkExecute() {
        return this.needsPersistenceSetup() ? 2 : 1;
    }

    private void executePersistenceSetup(IProgressMonitor monitor) {
        String command = "persistence setup ";
        command = String.valueOf(command) + " --provider " + this.getProviderName();
        command = String.valueOf(command) + " --container " + this.getContainerName();
        this.sendRuntimeCommand(command, monitor);
    }

    private String getProviderName() {
        return (String)this.getWizardDescriptor().get("NewProjectWizardPage.providerName");
    }

    private String getContainerName() {
        return (String)this.getWizardDescriptor().get("NewProjectWizardPage.containerName");
    }

    private void executeNewProject(IProgressMonitor monitor) {
        String finalName;
        String type;
        String command = "new-project";
        command = String.valueOf(command) + " --named " + this.getProjectName();
        command = String.valueOf(command) + " --projectFolder " + this.getProjectFolder();
        String topLevelPackage = this.getTopLevelPackage();
        if (topLevelPackage != null) {
            command = String.valueOf(command) + " --topLevelPackage " + topLevelPackage;
        }
        if ((type = this.getProjectType()) != null) {
            command = String.valueOf(command) + " --type " + type;
        }
        if (this.createMain()) {
            command = String.valueOf(command) + " --createMain ";
        }
        if ((finalName = this.getFinalName()) != null) {
            command = String.valueOf(command) + " --finalName " + finalName;
        }
        this.sendRuntimeCommand(command, monitor);
    }

    private String getFinalName() {
        return this.notEmptyString((String)this.getWizardDescriptor().get("NewProjectWizardPage.finalName"));
    }

    private boolean createMain() {
        Object obj = this.getWizardDescriptor().get("NewProjectWizardPage.createMain");
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    private String getProjectType() {
        Object obj = this.getWizardDescriptor().get("NewProjectWizardPage.projectType");
        return this.notEmptyString(((ProjectType)((Object)obj)).getName());
    }

    private String getTopLevelPackage() {
        return this.notEmptyString((String)this.getWizardDescriptor().get("NewProjectWizardPage.topLevelPackage"));
    }

    private String notEmptyString(String str) {
        if (str != null && !"".equals(str)) {
            return str;
        }
        return null;
    }

    private boolean needsPersistenceSetup() {
        Object obj = this.getWizardDescriptor().get("NewProjectWizardPage.setupPersistence");
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    @Override
    public String getStatusMessage() {
        return "Creating new project '" + this.getProjectName() + "'.";
    }

    private String getProjectLocation() {
        return (String)this.getWizardDescriptor().get("NewProjectWizardPage.projectLocation");
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("NewProjectWizardPage.projectName");
    }

    private String getProjectFolder() {
        return String.valueOf(this.getProjectLocation()) + File.separator + this.getProjectName();
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        this.importProject(this.getProjectLocation(), this.getProjectName(), monitor);
        this.updateProjectConfiguration(this.getProject(this.getProjectName()), monitor);
        this.updateListener(monitor);
    }

    private void updateListener(IProgressMonitor monitor) {
        monitor.setTaskName("Updating calling wizard...");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NewProjectWizard.this.listener.propertyChange(new PropertyChangeEvent(this, null, null, NewProjectWizard.this.getProjectName()));
            }
        });
        monitor.worked(1);
    }

    protected void importProject(String location, String name, IProgressMonitor monitor) {
        try {
            monitor.setTaskName("Importing project " + this.getProjectName());
            MavenPlugin.getProjectConfigurationManager().importProjects(this.getProjectToImport(this.getProjectLocation(), this.getProjectName()), new ProjectImportConfiguration(), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
        }
        catch (CoreException e) {
            WizardsPlugin.log(e);
        }
    }

    @Override
    protected int getAmountOfWorkRefresh() {
        return 3;
    }

    private MavenProjectInfo createMavenProjectInfo(String location, String name) {
        MavenProjectInfo result = null;
        try {
            File projectDir = new File(location, name);
            File pomFile = new File(projectDir, "pom.xml");
            Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
            String pomName = String.valueOf(name) + "/" + "pom.xml";
            result = new MavenProjectInfo(pomName, pomFile, model, null);
        }
        catch (CoreException coreException) {}
        return result;
    }

    private Collection<MavenProjectInfo> getProjectToImport(String location, String name) {
        ArrayList<MavenProjectInfo> result = new ArrayList<MavenProjectInfo>(1);
        result.add(this.createMavenProjectInfo(location, name));
        return result;
    }
}

